<?php

/***************************************************************
 * Logimetrix Techsolutions Pvt. Ltd.
 * File Name   : UserController.php
 * File Description  : UserController
 * Created By : Puneet Mishra
 * Created Date: 25 Nov 2016
 ***************************************************************/
 
class UserController extends Zend_Controller_Action{

            var $dbAdapter;
            var $db;

            public function init(){
               /* Initialize action controller here */
               $bootstrap = $this->getInvokeArg('bootstrap');
               $aConfig = $bootstrap->getOptions();
               $this->db = Zend_Db_Table::getDefaultAdapter();
               $auth = Zend_Auth::getInstance();
               $authStorage = $auth->getStorage();
               $this->WebLoginID = $authStorage->read()->WebLoginID;
               $users = new Application_Model_Users();
               $logout_details = $users->getUserLoginDetailByWebLoginCode($this->WebLoginID);
               $this->view->last_login = $logout_details['login_time'];               
            }
    
            public function indexAction(){
               $this->checklogin();
               $params = $this->view->params = $this->getRequest()->getParams(); 
               $Retailer = new Application_Model_Retailer(); 
               
               $role = 'Sales';

               if($params['user'] !=""){
                  $cond .="and StaffName like '%".$user."%'";
               }
               if($params['sale_person'] !=""){
                  $cond .="and s.id  = '".$params['sale_person']."'";
               }

               $query = "select s.*, t.StaffName as tse_name, t.employee_code as tse_employee_code from logi_user as s left join logi_user as t on (t.id = s.parent_tse) where s.Role = '".$role."' $cond";
               $result = $this->db->fetchAll($query);

               $sql_get_sale         = "select * from logi_user where Role = 'Sales' order by StaffName";
               $this->view->res_sale = $res_sale = $this->db->fetchAll($sql_get_sale);

               $page=$this->_getParam('page',1);
               $paginator = Zend_Paginator::factory($result);      
               $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
               $paginator->setItemCountPerPage(10); // number of items to show per page
               $this->view->paginator = $paginator;
               $this->view->totalrec = $paginator->getTotalItemCount();
            }

            public function viewMappedProductAction(){
               $this->checklogin();
               $params = $this->view->params = $this->getRequest()->getParams(); 
               $Retailer = new Application_Model_Retailer(); 
               $result= $Retailer->getDistributerProductList($params['datacode']); 
               $page=$this->_getParam('page',1);
               $paginator = Zend_Paginator::factory($result);      
               $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
               $paginator->setItemCountPerPage(10); // number of items to show per page
               $this->view->paginator = $paginator;
               $this->view->totalrec = $paginator->getTotalItemCount();
            }

            public function addNewUserAction(){
                $this->checklogin();
                $db = $this->db;
                $params = $this->getRequest()->getParams();
                $Retailer = new Application_Model_Retailer();
                $this->view->params = $params;
                $auth = Zend_Auth::getInstance();
                $authStorage = $auth->getStorage();
                $this->view->getTableLastUserId = $getTableLastUserId = $Retailer->GetLastID();   
                $this->view->getAllProduct = $getAllProduct = $Retailer->getdetailforallproduct();  
                $this->view->getAllSalePersonList = $getAllSalePersonList= $Retailer->getAllSalePersonList();
                $this->view->getStateList = $getStateList= $Retailer->getStateList();

                $sql_get_tse = "select * from logi_user where Role = 'TSE' order by StaffName";
                $this->view->res_tse = $res_tse = $this->db->fetchAll($sql_get_tse);
               

                if($this->getRequest()->isPost()){
                    
                    if($params['name'] ==""){
                        $this->view->errorMessage = "Please Enter User Name";
                    }

                    else{
                       
                        $data = array();                    
                        $data['StaffName']     = $params['name'];
                        $data['Email']         = $params['email'];
                        $data['MobileNo']      = $params['phone'];
                        $data['Address_Per']   =  $params['permanent_address'];
                        $data['Address_Curr']  = $params['curr_address'];
                        $data['role']          =  $params['role'];   
                        $data['Gender']        = $params['gender'];
                        $data['parent_sale']   = $params['sale_person'];
                        $data['Password']      = $params['password'];
                        $data['DistrictID']    = $params['district'];                                     
                        $data['state']         = $params['state'];
                        $data['DistrictID']    = $params['district'];                                     
                        $data['employee_code'] = $params['employee_code'];
                        $data['sap_code']      = $params['sap_code'];
                        $data['parent_tse']    = $params['tse'];
                        $data['parent_sale']   = $params['tsm'];

                        if($params['role']=='TSE'){
                          $data['manager']     = $params['manager'];
                        }
                        else if($params['role']=='Sales'){
                            $get_tse_manager = "select manager from logi_user where id = '".$params['tse']."'";
                            $res_tse_manager = $this->db->fetchRow($get_tse_manager);
                            $data['manager'] = $res_tse_manager['manager'];

                        }
                        // else if($params['role']=='Sales'){

                        // }
                        



                        $db->insert('logi_user', $data);
                        $lastid = $db->lastInsertId();
                                
                        if($params['role'] == 'Distributer'){
                            $i=0;
                            foreach($params['product_name'] as $key=>$value){
                                $product_detail[$i] = array();
                                $product_detail[$i]['distributer_id'] = $params['generated_login_id'];
                                $product_detail[$i]['product_id']     = $params['product_name'][$i];
                                $product_detail[$i]['sub_product_id'] = $params['sub_product_name'][$i];
                                $product_detail[$i]['rate']           = $params['rate'][$i];
                                $product_detail[$i]['retailer_rate']  = $params['retailer_rate'][$i];
                                $db->insert('logi_distributer_products', $product_detail[$i]);                            
                                $i++;  
                            } 
                        }
                        $this->view->getLastInsertedId = $lastid;
                        $this->view->successMessage = "User Detail added successfully.";
                    }     
                }        
            }
  
            public function editUserAction(){
                
                $this->checklogin();
                $db = $this->db;
                $auth = Zend_Auth::getInstance();
		        $authStorage = $auth->getStorage();
		        $params = $this->getRequest()->getParams();
                $Retailer = new Application_Model_Retailer();               
	            $this->view->params = $params;	
                $this->view->AllRETAILERData = $AllRETAILERData= $Retailer->AllDistributerData(); 
                $this->view->result = $result = $Retailer->GetRetailerDetailByLOginId($params['datacode']);
                $this->view->getStateList = $getStateList= $Retailer->getStateList();
                $this->view->getDistrictDetail = $getDistrictDetail = $Retailer->getDistrictDetail();
                $this->view->GetproductdetailagainestDistributerID = $GetproductdetailagainestDistributerID = $Retailer->GetproductdetailagainestDistributerID($result['LoginID']);
                $this->view->getAllSalePersonList = $getAllSalePersonList= $Retailer->getAllSalePersonList();
                $this->view->getAllProduct = $getAllProduct = $Retailer->getdetailforallproduct();  
                $this->view->getAllSubProductData = $getAllSubProductData = $Retailer->getAllSubProductData();    
                if($this->getRequest()->isPost()){
                    
                    $data = array();
                    $data['StaffName'] =    $params['name'];
                    $data['Email'] =        $params['email'];
                    $data['MobileNo'] =     $params['phone'];
                    $data['Address_Per'] =  $params['permanent_address'];
                    $data['Address_Curr'] = $params['curr_address'];
                    $data['role'] =         $params['role'];
                    $data['DistrictID'] =   $params['district']; 
                    $data['parent_sale'] =  $params['sale_person'];
                    $data['Gender'] =       $params['gender'];
                    $data['Password'] =     $params['password'];
                    $data['LoginID'] =      $params['loginID']; 
					//print_r($data);
					//exit();
                    $db->update('logi_user',$data, array('LoginID=?'=>$params['loginID']));
                    
                    if($params['role'] == 'Distributer'){
                        $pre=explode(',',$params['prv_id']);                        
                        if($params['id']){
                           echo  $res=array_diff($pre,$params['id']);  
                             $Retailer->deleteRetailerProductData($res);
                        }	
                        else{
                           $Retailer->deleteRetailerProductData($pre);
                        }                        
                        $i=0;                      
			            foreach($params['product_name'] as $key=>$value){
                            if(in_array($params['id'][$i],$params['id'])){
                                $data_update[$i]['distributer_id'] = $params['loginID'];
                                $data_update[$i]['product_id'] = $params['product_name'][$i];
                                $data_update[$i]['sub_product_id'] = $params['sub_product_name'][$i];               
                                $data_update[$i]['rate'] = $params['rate'][$i];	
                                $data_update[$i]['retailer_rate'] = $params['retailer_rate'][$i]; 														
                                $db->update('logi_distributer_products',$data_update[$i],array('id=?'=>$params['id'][$i]));								
			                      }						
                            else{
                                $data_update[$i]['distributer_id'] = $params['loginID'];
                                $data_update[$i]['product_id'] = $params['product_name'][$i];               
                                $data_update[$i]['rate'] = $params['rate'][$i];	
                                $data_update[$i]['sub_product_id'] = $params['sub_product_name'][$i];  
                                $data_update[$i]['retailer_rate'] = $params['retailer_rate'][$i];  														
                                $db->insert('logi_distributer_products', $data_update[$i]);  
                            }                      
                            $i++;  
                        } 
                    }
                    $this->_redirect('user/index');
                }        
            } 
  

            public function getSubProductListAction(){

                $this->checklogin();
                $this->getHelper('Layout')->disableLayout();
                $this->getHelper('ViewRenderer')->setNoRender();
                $this->getResponse()->setHeader('Content-Type', 'application/json');
                $Retailer = new Application_Model_Retailer();      
                $product_id = $this->getRequest()->getParam('product_id');
                $data_list_unformat = $Retailer->getSubProductListByProductId($product_id);          
                $sub_product_list[] = array("value"=>"",'text'=>"--Select Sub Product--");
                foreach($data_list_unformat as $single){
                    $sub_product_list[] = array("value"=>$single['id'],"text"=>$single['sub_product_name']);
                }             
                $this->getHelper('Layout')->disableLayout();
                $this->getHelper('ViewRenderer')->setNoRender();
                $this->getResponse()->setHeader('Content-Type', 'application/json');
                echo json_encode(array('options'=>$sub_product_list));
                return;      
            }


            public function getZonalHeadListAction(){

                $this->checklogin();
                $this->db = Zend_Db_Table::getDefaultAdapter();
                $this->getHelper('Layout')->disableLayout();
                $this->getHelper('ViewRenderer')->setNoRender();
                $this->getResponse()->setHeader('Content-Type', 'application/json');    
                $district = $this->getRequest()->getParam('district');

                $sql_zonal_user = "select id, StaffName from logi_user where DistrictID = '".$district."' and Role='ZonalHead' order by StaffName";
                $result  = $this->db->fetchAll($sql_zonal_user);

                $user_list[] = array("value"=>"",'text'=>"--Select Zonal Head--");
                foreach($result as $single){
                    $user_list[] = array("value"=>$single['id'],"text"=>$single['StaffName']);
                }             
                $this->getHelper('Layout')->disableLayout();
                $this->getHelper('ViewRenderer')->setNoRender();
                $this->getResponse()->setHeader('Content-Type', 'application/json');
                echo json_encode(array('options'=>$user_list));
                return;      
            }


            public function getSalePersonDistrictWiseAction(){

                $this->checklogin();
                $this->getHelper('Layout')->disableLayout();
                $this->getHelper('ViewRenderer')->setNoRender();
                $this->getResponse()->setHeader('Content-Type', 'application/json');
                $Retailer = new Application_Model_Retailer();      
                $district_id = $this->getRequest()->getParam('district_id');
                $data_list_unformat = $Retailer->getSalePersonDistrictWise($district_id);          
                $sub_product_list[] = array("value"=>"",'text'=>"--Select Sales Person--");
                foreach($data_list_unformat as $single){
                    $sub_product_list[] = array("value"=>$single['LoginID'],"text"=>$single['StaffName'].' ('.$single['LoginID'].')');
                }             
                $this->getHelper('Layout')->disableLayout();
                $this->getHelper('ViewRenderer')->setNoRender();
                $this->getResponse()->setHeader('Content-Type', 'application/json');
                echo json_encode(array('options'=>$sub_product_list));
                return;      
            }


            public function viewUserAction(){
                $this->checklogin();
                $db = $this->db;
                $auth = Zend_Auth::getInstance();
                $authStorage = $auth->getStorage();
                $params = $this->getRequest()->getParams();
                $Retailer = new Application_Model_Retailer();
                $this->view->params = $params;	             
                $this->view->retailer= $retailer = $Retailer->GetRetailerDetailByLOginId($params['datacode']); 
                $this->view->getRetailerSiteLocation= $getRetailerSiteLocation = $Retailer->getRetailerSiteLocation($retailer['id']);  
            }
  
  
  
            public function viewretailerAction(){
                $this->checklogin();
                $params = $this->view->params = $this->getRequest()->getParams(); 
                $Retailer = new Application_Model_Retailer(); 

                $sql_dis = "select * from logi_user where md5(md5(id)) = '".$params['datacode']."'";      
                $this->view->res_dis = $res_psm = $this->db->fetchRow($sql_dis);

                $this->view->customer = $result = $Retailer->GETAllReatilerByDistributerId($params['datacode']);
                $page=$this->_getParam('page',1);
                $paginator = Zend_Paginator::factory($result);      
                $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
                $paginator->setItemCountPerPage(10); // number of items to show per page
                $this->view->paginator = $paginator;
                $this->view->totalrec = $paginator->getTotalItemCount();
            }
  
  
            public function checkmobilenoAction(){		
                $this->checklogin(); 
                $Retailer = new Application_Model_Retailer();
                $Mobile = $this->getRequest()->getParam('Mobile');
                $this->getHelper('Layout')->disableLayout();
                $this->getHelper('ViewRenderer')->setNoRender();
                if($Mobile !=""){						      
                    $result =  $Retailer->CheckMobileNo($Mobile);						 
                    echo json_encode($result);                                

                }                                                                                    
            }
    
    
          	public function getDataListAction(){
                $this->checklogin();
                $this->getHelper('Layout')->disableLayout();
                $this->getHelper('ViewRenderer')->setNoRender();
                $this->getResponse()->setHeader('Content-Type', 'application/json');
                $Retailer = new Application_Model_Retailer();
                $product_id = $this->getRequest()->getParam('product_id');
               
                $data_list_unformat = $Retailer->datalist($product_id);
               
                $data_list = $data_list_unformat['packing_type'];
                
                echo json_encode($data_list);
                return;  	   
            }
        
        
        
            public function getDistrictListAction(){

                $this->checklogin();
                
                $this->getHelper('Layout')->disableLayout();
                $this->getHelper('ViewRenderer')->setNoRender();
                 $this->getResponse()->setHeader('Content-Type', 'application/json');
                $Retailer = new Application_Model_Retailer();
                
                $state = $this->getRequest()->getParam('state');
                $district_list_unformat = $Retailer->getDistrictListStateWise($state);
                $district_list[] = array("value"=>"","text"=>"--Select District--");
                foreach($district_list_unformat as $single){
                   $district_list[] = array("value"=>$single['id'],"text"=>$single['district']);
                }
                echo json_encode(array('options'=>$district_list));
                return;  

            }
                
                
            public function deleteUserAction(){		
                $this->checklogin();

                $db=  $this->db = Zend_Db_Table::getDefaultAdapter();
                $auth = Zend_Auth::getInstance();
                $authStorage = $auth->getStorage();                
                $Retailer = new Application_Model_Retailer();                
                $userId = $this->getRequest()->getParam('userId');
                $Retailer->deleteUser($userId);                                                                                  
            }


            public function clearDeviceAction(){     
                $this->checklogin();

                $db=  $this->db = Zend_Db_Table::getDefaultAdapter();
                $auth = Zend_Auth::getInstance();
                $authStorage = $auth->getStorage();                
                $Retailer = new Application_Model_Retailer();                
                $userId = $this->getRequest()->getParam('userId');

                $data = array();
                $data['Device_type']   =  '';
                $data['Device_token']  =  '';
                $data['DeviceID']      =  ''; 
                $db->update('logi_user',$data, array('id=?'=>$userId));                                                                                  
            }


            public function changeStatusAction(){

                $this->checklogin();
                $db=  $this->db = Zend_Db_Table::getDefaultAdapter();
                $auth = Zend_Auth::getInstance();
                $authStorage = $auth->getStorage(); 
                              
                $Retailer = new Application_Model_Retailer();                
                $status= $this->getRequest()->getParam('status');
                $order_id= $this->getRequest()->getParam('order_id');

                $data_update = array();
                $data_update['status'] = $status; 

                $db->update('logi_order',$data_update,array('id=?'=>$order_id));
                $this->_helper->layout()->disableLayout(); 
                $this->_helper->viewRenderer->setNoRender(true);                                                                                    
            }



            public function viewDistributerAction(){
               $this->checklogin();
               $params = $this->view->params = $this->getRequest()->getParams(); 
               $Retailer = new Application_Model_Retailer();

               $sql_psm = "select * from logi_user where md5(md5(id)) = '".$params['datacode']."'";      
               $this->view->res_psm = $res_psm = $this->db->fetchRow($sql_psm);

               $result = $Retailer->getDistributersOfSalePersons($params['datacode'],$params['name'], 'Distributer');
               $page=$this->_getParam('page',1);
               $paginator = Zend_Paginator::factory($result);      
               $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
               $paginator->setItemCountPerPage(10); // number of items to show per page
               $this->view->paginator = $paginator;
               $this->view->totalrec = $paginator->getTotalItemCount();
            }

  
     
            public function checklogin(){   
              $auth = Zend_Auth::getInstance(); 
              $errorMessage = ""; 
              /*************** check user identity ************/
              if(!$auth->hasIdentity()){
                    $this->_redirect('admin/index');  
              }   
            }     
}
