<?php
date_default_timezone_set("Asia/Kolkata");


/***************************************************************
* Logimetrix Techsolution Pvt. Ltd.
* File Name           : ApiController.php
* File Description   : All Api Method
* Created By        : Puneet Mishra
* Created Date     : 11 Nov 2016
***************************************************************/



class ApiController extends Zend_Controller_Action{

	var $phpNative;
	var $secretkey;
	var $db;
	var $currdate;
	var $siteurl;

	public function init(){
        //Initialize action controller here 
		$this->_helper->viewRenderer->setNoRender(true);
		$bootstrap           = $this->getInvokeArg('bootstrap');
		$aConfig             = $bootstrap->getOptions();
		if(isset($aConfig['api']['searchuser']['secret']) && $aConfig['api']['searchuser']['secret'] != ""){
			$this->secretkey = $aConfig['api']['searchuser']['secret'];
		}
		$this->siteurl   = $aConfig['api']['site']['url'];
		$this->db        = Zend_Db_Table::getDefaultAdapter();
        $this->currdate  = date("Y-m-d H:i:s"); //$date->toString('Y-m-d H:m:s');
        $this->day       = date("d");
        $this->month     = date("m");
        $this->year      = date("Y");
    }

    /**
     * index() method is used to api index
     * @param NULL
     * @return True 
     */
    
    public function indexAction(){
    	echo "Welcome api controller";
    	exit;
        // action body
    }
    
    public function serverUrlAction(){
    	echo json_encode(array(
    		"error_code" => '0',
    		'response_string' => 'success.',
    		'serverurl' => 'http://rufil.cropnet.co.in/api'
    	));
    	exit;
    }
    
    
    public function getSecretHashKey(){
    	return md5(uniqid(rand(), TRUE));
    }
    
    function getAddress($lat, $lng){
    	$url     = "https://maps.googleapis.com/maps/api/geocode/json?key=AIzaSyD67PS69UkNREHH5pkb1E-zCy7iWKSNgE4&latlng=" . $lat . "," . $lng . "&sensor=false";
    	$json    = @file_get_contents($url);
    	$data    = json_decode($json);
    	$status  = $data->status;
    	$address = '';
    	if ($status == "OK") {
    		$address = $data->results[0]->formatted_address;
    	} 
    	else{

    		$address = 'Not Found';
    	}
    	return $address;
    }


    public function getCordinateDistance($lat1, $lon1, $lat2, $lon2) {
    	if (($lat1 == $lat2) && ($lon1 == $lon2)) {
    		return 0;
    	}
    	else {
    		$theta = $lon1 - $lon2;
    		$dist = sin(deg2rad($lat1)) * sin(deg2rad($lat2)) +  cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta));
    		$dist = acos($dist);
    		$dist = rad2deg($dist);
    		$miles = $dist * 60 * 1.1515;

    		return ($miles * 1.609344);
    	}
    }



    /**
     * login() method is used to android user login
     * @param String
     * @return JSON 
     */
    
    public function loginAction(){

        // Get the Request parameters
    	$params       = $this->getRequest()->getParams();
    	$secretkey    = $this->secretkey;
    	$db           = $this->db;
        // Genaral Information of the user login details
    	$LoginID      = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$Imei         = isset($params['device_id']) ? $params['device_id'] : "";
    	$device_type  = isset($params['device_type']) ? $params['device_type'] : "";
    	$lat          = isset($params['user_latitude']) ? $params['user_latitude'] : "";
    	$long         = isset($params['user_longitude']) ? $params['user_longitude'] : "";
    	$fire_base_id = isset($params['fcm_token']) ? $params['fcm_token'] : "";
    	$version      = isset($params['version']) ? $params['version'] : "";
    	$password     = isset($params['Password']) ? $params['Password'] : "";

    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();

    		if (!$Imei) {
    			$error_code = 2;
    			throw new Exception("Device ID missing.");
    		}

    		if (!$LoginID) {
    			$error_code = 2;
    			throw new Exception("Login ID missing.");
    		}
    		if (!$password) {
    			$error_code = 2;
    			throw new Exception("Password  missing.");
    		}

    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($LoginID, $password);

    		if (!empty($alldata['LoginID']) != $LoginID && !empty($alldata['password']) != $password) {
    			$error_code = 3;
    			throw new Exception('Invalid login.');
    		}

    		if (!empty($alldata['DeviceID'])) {
    			if ($alldata['DeviceID'] != $Imei) {
    				$error_code = 4;
    				throw new Exception('You are not authorized for this device.');
    			}
    		}

    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 5;
    			throw new Exception('Your account is not active.');
    		}

    		if (isset($alldata['access_status']) && $alldata['access_status'] == 2) {
    			$error_code = 6;
    			throw new Exception('This account deactivated by admin.');
    		}
    		$address = $this->getAddress($lat, $long);
    		$update                                   = array();
    		$update['device_type']                    = $device_type;
    		$update['device_token']                   = $this->getSecretHashKey();
    		$update['DeviceID']                       = $Imei; 
    		$update['gps_status']                     = 'on';
    		$update['lat']                            = $lat; 
    		$update['long']                           = $long;
    		$update['address']                        = $address;
    		$update['fire_base_id']                   = $fire_base_id;
    		if ($version) {
    			$update['app_version']                = $version;
    		}
    		$update['last_location_service_hit_time'] = $this->currdate;
    		$user->updateSingleTableData('logi_user', $update, 'LoginID', $alldata['LoginID']);

    		$user_login_data                          = array();
    		$user_login_data['mob_user_staff_code']   = $LoginID;
    		$user_login_data['login_time']            = $this->currdate;
    		$user_login_data['server_detail']         = json_encode($_SERVER);
    		$db->insert('logi_user_login_detail', $user_login_data);

    		$getLoginUserDetail                       = $user->getUserDataByLoginId($LoginID, $password);

    		$sync_time = '2';

    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string'          => 'login success.',
    			'get_Login_User_Detail'    => $getLoginUserDetail,
    			'distance'                 => '500000000000',
    			'location_distance'        => '500000000000',
    			'sync_time'                => $sync_time
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code"      => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }

    public function getDistributorListAction(){

        // Get the Request parameters
    	$params       = $this->getRequest()->getParams();
    	$secretkey    = $this->secretkey;
    	$db           = $this->db;
        // Genaral Information of the user login details
    	$LoginID      = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$Imei         = isset($params['device_id']) ? $params['device_id'] : "";
    	$device_type  = isset($params['device_type']) ? $params['device_type'] : ""; 
    	$password     = isset($params['Password']) ? $params['Password'] : "";

    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();
    		if (!$LoginID || !$Imei  || !$password) {
    			$error_code = 2;
    			throw new Exception("Required parameter missing.");
    		}
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($LoginID, $password);

    		if (!empty($alldata['LoginID']) != $LoginID && !empty($alldata['password']) != $password) {
    			$error_code = 3;
    			throw new Exception('Invalid login.');
    		}

    		if (!empty($alldata['DeviceID'])) {
    			if ($alldata['DeviceID'] != $Imei) {
    				$error_code = 4;
    				throw new Exception('You are not authorized for this device.');
    			}
    		}

    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 5;
    			throw new Exception('Your account is not active.');
    		}

    		if (isset($alldata['access_status']) && $alldata['access_status'] == 2) {
    			$error_code = 6;
    			throw new Exception('This account deactivated by admin.');
    		}

    		if($alldata['Role']=='ASM'){
    			$role_cond .="and parent_area_manager = '".$alldata['userId']."'";
    		}

    		else if($alldata['Role']=='Sales'){
    			$role_cond .="and parent_sale = '".$alldata['userId']."'";
    		}

    		$sql_distributor = "select id as distributor_id, StaffName as distributor_name, state, DistrictID as district from logi_user where   1 $role_cond and Role = 'Distributer'";
    		$res_distribuotr_list    = $db->fetchAll($sql_distributor);

    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string'          => 'distributor listed successfully.',
    			'Get_Distributer_Detail'   => $res_distribuotr_list

    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code"      => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }

    /**
     * getAccessModulesAction() method is used to get All Access Modules By Role
     * @param NULL
     * @return JSON 
     */
    
    public function getAccessModulesAction(){
    	$params       = $this->getRequest()->getParams();
    	$db           = $this->db;
    	$LoginID      = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$password     = isset($params['Password']) ? $params['Password'] : "";
    	$error_code = 1;
    	$succes     = FALSE;
    	try {

    		if (!$LoginID || !$password) {
    			$error_code = 2;
    			throw new Exception("Required parameter missing.");
    		}

    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($LoginID, $password);

    		if (!empty($alldata['LoginID']) != $LoginID && !empty($alldata['password']) != $password) {
    			$error_code = 3;
    			throw new Exception('Invalid login.');
    		}

    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 5;
    			throw new Exception('Your account is not active.');
    		}

    		if (isset($alldata['access_status']) && $alldata['access_status'] == 2) {
    			$error_code = 6;
    			throw new Exception('This account deactivated by admin.');
    		}

    		$result_access_module = $this->modulePermission($alldata['Role']);
    		$succes = TRUE;

    	}catch (Exception $e) {
    		$error = $e->getMessage();
    	}

    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'access_module' => $result_access_module,
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code"      => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }


    /**
     * startDay() method is used to get all jobs
     * @param NULL
     * @return JSON 
     */
    
    public function startDayAction(){
        // Get the Request parameters
    	$params           = $this->getRequest()->getParams();
    	$db               = $this->db;
        // Genaral Information of the user login details
    	$appkey           = isset($params['appkey']) ? $params['appkey'] : "";
    	$LoginID          = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$latitude         = isset($params['latitude']) ? $params['latitude'] : "";
    	$longitude        = isset($params['longitude']) ? $params['longitude'] : "";
    	$device_id        = isset($params['device_id']) ? $params['device_id'] : "";
    	$status           = isset($params['status']) ? $params['status'] : "";
    	$ofline_timestamp = isset($params['offline_timestamp']) ? $params['offline_timestamp'] : "";

    	$area_latitude    = isset($params['area_latitude']) ? $params['area_latitude'] : "";
    	$area_longitude   = isset($params['area_longitude']) ? $params['area_longitude'] : "";
    	$area_name        = isset($params['area_name']) ? $params['area_name'] : "";
    	$password = isset($params['Password']) ? $params['Password'] : "";

    	$error_code = 1;
    	$succes     = FALSE;
    	try {

    		$db->beginTransaction();
    		if (!$LoginID || !$device_id || !password) {
    			throw new Exception("Required parameter missing.");
    		}

    		$user = new Application_Model_Users();

    		$alldata = $user->getUserDataByLoginId($LoginID, $password);
    		$count   = count($alldata);

    		if (!empty($alldata['LoginID']) != $LoginID) {
    			throw new Exception('Invalid user.');
    		}

    		if ($alldata['Device_token'] != $appkey) {
    			throw new Exception("Invalid request.");
    		}

    		if (!empty($alldata['device_id'])) {
    			if ($alldata['device_id'] != $device_id) {
    				$error_code = 3;
    				throw new Exception('You are not authorized for this device.');
    			}
    		}

    		if (strtoupper($alldata['StaffStatus']) != 'AC') {
    			throw new Exception('Your account is not active.');
    		}

    		$StaffCode    = $alldata['LoginID'];
    		$StaffName    = $alldata['StaffName'];

    		$sql_get_psm  = "select * from logi_user where LoginID = '" . $LoginID . "'";
    		$res_psm      = $db->fetchRow($sql_get_psm);

    		$notification = array();
    		if ($status == 1) {
    			$daystart                                = 'day_start';
    			$notification['LoginID']                 = $LoginID;
    			$notification['latitude']                = $latitude;
    			$notification['longitude']               = $longitude;
    			$notification['status']                  = $daystart;
    			$notification['noti_date']               = $ofline_timestamp;
    			$notification['sink_date_time']          = $this->currdate;
    			$notification['parent_regional_manager'] = $res_psm['parent_regional_manager'];
    			$notification['parent_zonal_manager']    = $res_psm['parent_zonal_manager'];
    			$notification['parent_area_manager']     = $res_psm['parent_area_manager'];
    			$notification['parent_sale_person']      = $res_psm['id'];

    			$notification['area_name']               = $area_name;
    			$notification['area_latitude']           = $area_latitude;
    			$notification['area_longitude']          = $area_longitude; 
    			$db->insert('Attendance', $notification);
    		}

    		else {
    			$dayclose                                = 'day_close';
    			$notification['LoginID']                 = $LoginID;
    			$notification['latitude']                = $latitude;
    			$notification['longitude']               = $longitude;
    			$notification['status']                  = $dayclose;
    			$notification['noti_date']               = $ofline_timestamp;
    			$notification['sink_date_time']          = $this->currdate;
    			$notification['parent_regional_manager'] = $res_psm['parent_regional_manager'];
    			$notification['parent_zonal_manager']    = $res_psm['parent_zonal_manager'];
    			$notification['parent_area_manager']     = $res_psm['parent_area_manager'];
    			$notification['parent_sale_person']      = $res_psm['id'];

    			$notification['area_name']               = $area_name;
    			$notification['area_latitude']           = $area_latitude;
    			$notification['area_longitude']          = $area_longitude;
    			$notification['day_end_by']              = 'app'; 
    			$db->insert('Attendance', $notification);
    		}
            // Notification message insert notification table
    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}

    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'User attended successfully.'
    		));
    		exit;
    	}

    	else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}

    }


    public function getCollectionAction(){
    	$db             = Zend_Db_Table::getDefaultAdapter();
    	$params         = json_decode(file_get_contents('php://input'), true);
    	$params         = $this->getRequest()->getParams();
    	$retailer_id    = isset($params['retailer_id']) ? $params['retailer_id'] : "";
    	$distributor_id = isset($params['distributor_id']) ? $params['distributor_id'] : "";
    }

    //***************************Retailer Location tagging   Api**********************************************************//

    public function insertRetailerTaggingDataAction(){
        // Get the Request parameters
    	$params        = $this->getRequest()->getParams();
    	$secretkey      = $this->secretkey;
    	$db             = $this->db;
    	$appkey         = isset($params['appkey']) ? $params['appkey'] : "";
    	$user_id        = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$Imei           = isset($params['device_id']) ? $params['device_id'] : "";
    	$device_type    = isset($params['device_type']) ? $params['device_type'] : "";

    	$retailer_id    = isset($params['retailer_id']) ? $params['retailer_id'] : "";
    	$lat            = isset($params['user_latitude']) ? $params['user_latitude'] : "";
    	$long           = isset($params['user_longitude']) ? $params['user_longitude'] : "";
    	$taging_date    = isset($params['taging_date']) ? $params['taging_date'] : "";
    	$distributer_id = isset($params['distributer_id']) ? $params['distributer_id'] : "";
    	$tag_status     = isset($params['tag_status']) ? $params['tag_status'] : "";

    	$error_code     = 1;
    	$succes         = FALSE;

    	try {

    		$db->beginTransaction();
    		$user                       = new Application_Model_Users();
    		$alldata                    = $user->getUserDataByLoginId($user_id);
    		$checkCountRetailerLocation = $user->checkCountRetailerLocation($retailer_id);
    		if ($alldata['Device_token'] != $appkey) {
    			throw new Exception("Invalid request.");
    		}

    		if (!$Imei || !$retailer_id || !$user_id) {
    			throw new Exception("Required parameter missing.");
    		}

    		if (!empty($alldata['LoginID']) != $user_id) {
    			throw new Exception('Invalid login id.');
    		}

    		if (!empty($alldata['device_id'])) {
    			if ($alldata['device_id'] != $Imei) {
    				$error_code = 3;
    				throw new Exception('You are not athorized for this device.');
    			}
    		}

    		if (!$retailer_id) {
    			throw new Exception("Please Select Retailer Name.");
    		}

    		if ($checkCountRetailerLocation['number'] != 0) {
    			throw new Exception('For this retailer geo taging already exist.');
    		}

    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 3;
    			throw new Exception('Your account is not active.');
    		}

    		if ($alldata['access_status'] == 2) {
    			$error_code = 2;
    			throw new Exception('This account deactivated by admin.');
    		}

    		$retailergeotagingdetail = array();
    		if (isset($_FILES['photograph1']['tmp_name']) AND !empty($_FILES['photograph1']['tmp_name'])) {
    			$tempName  = $_FILES['photograph1']['tmp_name'];
    			$imageName = time() . $_FILES['photograph1']['name'];
    			$uploads   = 'uploads/retailer_site_location/';
    			if (!file_exists($uploads)) {
    				mkdir($uploads);
    			}
    			$pathComplete = $uploads . $imageName;
    			@move_uploaded_file($tempName, $pathComplete);
    			$retailergeotagingdetail['photograph1'] = $imageName;
    		}

            // User site_photograph2 image Code 

    		if (isset($_FILES['photograph2']['tmp_name']) AND !empty($_FILES['photograph2']['tmp_name'])) {
    			$tempName1  = $_FILES['photograph2']['tmp_name'];
    			$imageName2 = time() . $_FILES['photograph2']['name'];
    			$uploads1   = 'uploads/retailer_site_location/';
    			if (!file_exists($uploads1)) {
    				mkdir($uploads1);
    			}
    			$pathComplete1 = $uploads1 . $imageName2;
    			@move_uploaded_file($tempName1, $pathComplete1);
    			$retailergeotagingdetail['photograph2'] = $imageName2;

    		}

    		$sql_get_retailer = "select * from logi_user where id = '" . $retailer_id . "'";
    		$res_retailer     = $db->fetchRow($sql_get_retailer);

    		$distributer                                        = $user->getUserDetailById($distributer_id);
    		$retailergeotagingdetail['retailer_id']             = $retailer_id;
    		$retailergeotagingdetail['lat']                     = $lat;
    		$retailergeotagingdetail['long']                    = $long;
    		$retailergeotagingdetail['sale_person_id']          = $user_id;
    		$retailergeotagingdetail['distributer_person_id']   = $distributer['LoginID'];
    		$retailergeotagingdetail['taging_date']             = $taging_date;
    		$retailergeotagingdetail['parent_regional_manager'] = $res_retailer['parent_regional_manager'];
    		$retailergeotagingdetail['parent_zonal_manager']    = $res_retailer['parent_zonal_manager'];
    		$retailergeotagingdetail['parent_area_manager']     = $res_retailer['parent_area_manager'];
    		$retailergeotagingdetail['parent_sale_person']      = $res_retailer['parent_sale'];
    		$db->insert('retailers_site_location', $retailergeotagingdetail);

    		$updateUserDetail               = array();
    		$updateUserDetail['tag_status'] = $tag_status;
    		$db->update('logi_user', $updateUserDetail, array(
    			'id=?' => $retailer_id
    		));

    		$db->commit();
    		$succes = TRUE;
    	}

    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}

    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'Retailer geo taging detail added successfully'
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }



    //***************************Tag Bmc  Api**********************************************************//

    public function tagBmcAction(){
        // Get the Request parameters
    	$params        = $this->getRequest()->getParams();
    	$secretkey      = $this->secretkey;
    	$db             = $this->db;
    	$appkey         = isset($params['appkey']) ? $params['appkey'] : "";
    	$user_id        = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$Imei           = isset($params['device_id']) ? $params['device_id'] : "";
    	$device_type    = isset($params['device_type']) ? $params['device_type'] : "";
    	$bmc_id         = isset($params['bmc_id']) ? $params['bmc_id'] : "";
    	$lat            = isset($params['user_latitude']) ? $params['user_latitude'] : "";
    	$long           = isset($params['user_longitude']) ? $params['user_longitude'] : "";
    	$taging_date    = isset($params['taging_date']) ? $params['taging_date'] : "";
        //$distributer_id = isset($params['distributer_id']) ? $params['distributer_id'] : "";
    	$tag_status     = isset($params['tag_status']) ? $params['tag_status'] : "";

    	$error_code     = 1;
    	$succes         = FALSE;

    	try {

    		$db->beginTransaction();
    		$user                       = new Application_Model_Users();
    		$alldata                    = $user->getUserDataByLoginId($user_id);
            //$checkCountRetailerLocation = $user->checkCountRetailerLocation($retailer_id);
    		if ($alldata['Device_token'] != $appkey) {
    			throw new Exception("Invalid request.");
    		}

    		if (!$Imei || !$retailer_id || !$user_id) {
    			throw new Exception("Required parameter missing.");
    		}

    		if (!empty($alldata['LoginID']) != $user_id) {
    			throw new Exception('Invalid login id.');
    		}

    		if (!empty($alldata['device_id'])) {
    			if ($alldata['device_id'] != $Imei) {
    				$error_code = 3;
    				throw new Exception('You are not athorized for this device.');
    			}
    		}
    		if (!$retailer_id) {
    			throw new Exception("Please Select Retailer Name.");
    		}
    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 3;
    			throw new Exception('Your account is not active.');
    		}
    		if ($alldata['access_status'] == 2) {
    			$error_code = 2;
    			throw new Exception('This account deactivated by admin.');
    		}
    		$retailergeotagingdetail = array();
    		if (isset($_FILES['photograph1']['tmp_name']) AND !empty($_FILES['photograph1']['tmp_name'])) {
    			$tempName  = $_FILES['photograph1']['tmp_name'];
    			$imageName = time() . $_FILES['photograph1']['name'];
    			$uploads   = 'uploads/retailer_site_location/';
    			if (!file_exists($uploads)) {
    				mkdir($uploads);
    			}
    			$pathComplete = $uploads . $imageName;
    			@move_uploaded_file($tempName, $pathComplete);
    			$retailergeotagingdetail['photograph1'] = $imageName;
    		}
            // User site_photograph2 image Code 
    		if (isset($_FILES['photograph2']['tmp_name']) AND !empty($_FILES['photograph2']['tmp_name'])) {
    			$tempName1  = $_FILES['photograph2']['tmp_name'];
    			$imageName2 = time() . $_FILES['photograph2']['name'];
    			$uploads1   = 'uploads/retailer_site_location/';
    			if (!file_exists($uploads1)) {
    				mkdir($uploads1);
    			}
    			$pathComplete1 = $uploads1 . $imageName2;
    			@move_uploaded_file($tempName1, $pathComplete1);
    			$retailergeotagingdetail['photograph2'] = $imageName2;

    		}

    		$sql_get_retailer = "select * from logi_user where id = '" . $retailer_id . "'";
    		$res_retailer     = $db->fetchRow($sql_get_retailer);
            //$distributer                                        = $user->getUserDetailById($distributer_id);
    		$retailergeotagingdetail['retailer_id']             = $retailer_id;
    		$retailergeotagingdetail['lat']                     = $lat;
    		$retailergeotagingdetail['long']                    = $long;
    		$retailergeotagingdetail['sale_person_id']          = $user_id;
            //$retailergeotagingdetail['distributer_person_id'] = $distributer['LoginID'];
    		$retailergeotagingdetail['taging_date']             = $taging_date;
    		$retailergeotagingdetail['parent_regional_manager'] = $res_retailer['parent_regional_manager'];
    		$retailergeotagingdetail['parent_zonal_manager']    = $res_retailer['parent_zonal_manager'];
    		$retailergeotagingdetail['parent_area_manager']     = $res_retailer['parent_area_manager'];
            //$retailergeotagingdetail['parent_sale_person']      = $res_retailer['parent_sale'];
    		$db->insert('tbl_bmc_tagging', $retailergeotagingdetail);

    		$updateUserDetail               = array();
    		$updateUserDetail['tag_status'] = $tag_status;
    		$db->update('logi_user', $updateUserDetail, array(
    			'id=?' => $retailer_id
    		));

    		$db->commit();
    		$succes = TRUE;
    	}

    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}

    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'Bmc tagged successfully'
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }


    //******************************End of Retailer Site location api*************************************************************//


    // ***************************End Of Inserting Order Deatil Api*********************************//

    //***********************Update Order Detail Api*********************************//

    public function updateorderdetailAction(){
        // Get the Request parameters
    	$params    = $this->getRequest()->getParams();
        //  $params = array('item_detail'=>'[{"product_id":"1","qty":"1"},{"product_id":"8","qty":"1"}]');
    	$secretkey = $this->secretkey;
    	$db        = $this->db;

    	if (get_magic_quotes_gpc()) {
    		$order_data = stripslashes($params['item_detail']);
    	} else {
    		$order_data = $params['item_detail'];
    	}

    	$get_order_data = json_decode($order_data, true);
        // Genaral Information of the user login detail
        // $appkey=mys3cr3tk3y;
    	$appkey         = isset($params['appkey']) ? $params['appkey'] : "";
    	$MobileNo       = isset($params['MobileNo']) ? $params['MobileNo'] : "";
    	$Imei           = isset($params['Imei_no']) ? $params['Imei_no'] : "";
    	$device_type    = isset($params['device_type']) ? $params['device_type'] : "";
    	$device_token   = isset($params['device_token']) ? $params['device_token'] : "";
    	$order_date     = isset($params['order_date']) ? $params['order_date'] : "";
    	$order_id       = isset($params['order_id']) ? $params['order_id'] : "";
    	$error_code     = 1;
    	$succes         = FALSE;

    	try {

    		$db->beginTransaction();

    		if ($secretkey != $appkey) {
    			throw new Exception("Invalid request.");
    		}

    		if (!$MobileNo || !$Imei || !$device_token) {
    			throw new Exception("Required parameter missing.");
    		}

    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($MobileNo);


    		if (!empty($alldata['MobileNo']) != $MobileNo) {
    			throw new Exception('Invalid login id.');
    		}

    		if (!empty($alldata['device_id'])) {
    			if ($alldata['device_id'] != $Imei) {
    				$error_code = 3;
    				throw new Exception('You are not authorized for this device.');
    			}
    		}

    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 3;
    			throw new Exception('Your account is not active.');
    		}

    		if ($alldata['access_status'] == 2) {
    			$error_code = 2;
    			throw new Exception('This account deactivated by admin.');
    		}
    		if ($order_id) {
    			$deletedata = $db->delete('logi_order_item', $order_id);
    			if ($deletedata) {
    				$getDistributerLoginID = $user->getDistributerLoginID($MobileNo);
    				$orderData             = array();
    				$creditLimit = $user->GetParentId($getDistributerLoginID['LoginID']);

    				$k                 = 0;
    				$toal_order_amount = 0;

    				foreach ($get_order_data as $k) {
    					$getProductRate = $user->getProductRate($MobileNo, $k['product_id']);
    					$toal_order_amount += $getProductRate['rate'] * $k['qty'];
    					$insertItemData                     = array();
    					$insertItemData['product_id']       = $k['product_id'];
    					$insertItemData['qty']              = $k['qty'];
    					$insertItemData['rate']             = $getProductRate['rate'];
    					$insertItemData['amount']           = $getProductRate['rate'] * $k['qty'];
    					$insertItemData['order_id']         = $order_id;
    					$insertItemData['retailer_ code']   = $alldata['LoginID'];
    					$insertItemData['distributer_code'] = $getDistributerLoginID['LoginID'];
    					$db->insert('logi_order_item', $insertItemData);
    					$k++;
    				}

    				$update_total_order_amount['total_amt'] = $toal_order_amount;
    				$db->update('logi_order', $update_total_order_amount, array(
    					'id=?' => $order_id
    				));

    				$act_credit                          = $creditLimit['credit_limit'] - $toal_order_amount;
    				$update_credit_limit['credit_limit'] = $act_credit;
    				$db->update('logi_user', $update_credit_limit, array(
    					'LoginID=?' => $getDistributerLoginID['LoginID']
    				));

    				$db->commit();
    				$succes = TRUE;
    			}
    		}

    	}

    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}

    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'Order Detail Inserted Successfully.'
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }

    // ***************************End Of Update Order Deatil Api*********************************//
    //*********************************************Api Procurement******************************************************************// 


    public function retailerOrderSummaryAction(){
        // Get the Request parameters
    	$params       = $this->getRequest()->getParams();
    	$secretkey    = $this->secretkey;
    	$db           = $this->db;
        // Genaral Information of the user login detail
        // $appkey=mys3cr3tk3y;
    	$appkey       = isset($params['appkey']) ? $params['appkey'] : "";

    	$LoginID      = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$Imei         = isset($params['device_id']) ? $params['device_id'] : "";
    	$device_type  = isset($params['device_type']) ? $params['device_type'] : "";
    	$device_token = isset($params['device_token']) ? $params['device_token'] : "";
    	$start_date   = isset($params['start_date']) ? $params['start_date'] : "";
    	$end_date     = isset($params['end_date']) ? $params['end_date'] : "";
    	$password     = isset($params['Password']) ? $params['Password'] : "";

    	$error_code   = 1;
    	$succes       = FALSE;

    	try {
    		$db->beginTransaction();
            // if ($secretkey != $appkey) {
            //  throw new Exception("Invalid request.");
            // }
    		if (!$LoginID || !$Imei || !$device_token) {
    			throw new Exception("Required parameter missing.");
    		}
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($LoginID, $password);
            // if (!empty($alldata['MobileNo']) != $MobileNo) {
            //  throw new Exception('Invalid login id.');
            // }
    		if (!empty($alldata['device_id'])) {
    			if ($alldata['device_id'] != $Imei) {
    				$error_code = 3;
    				throw new Exception('You are not athorized for this device.');
    			}
    		}

    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 3;
    			throw new Exception('Your account is not active.');
    		}

    		if ($alldata['access_status'] == 2) {
    			$error_code = 2;
    			throw new Exception('This account deactivated by admin.');
    		}

    		$retailerLoginId      = $alldata['LoginID'];
            // exit();
    		$retailer             = new Application_Model_Retailer();
    		$retailerOrderSummary = $retailer->getRetailerOrdersSummary($alldata['userId'], $start_date, $end_date);

    		$db->commit();
    		$succes = TRUE;
    	}

    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}

    	if ($succes == TRUE) {
    		if (!empty($retailerOrderSummary)) {
    			echo json_encode(array(
    				"error_code" => '0',
    				'response_string' => 'Sucess',
    				'RetailerOrderSummary' => $retailerOrderSummary
    			));
    			exit;
    		} else {
    			echo json_encode(array(
    				"error_code" => '4',
    				'response_string' => 'No Record Found..'
    			));
    			exit;
    		}

    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }

    //********************************************End of Assest Api***************************************************//  



    /**
    * salesTrackingAction() method is used to get all jobs
    * @param NULL
    * @return JSON 
    */
    
    public function salesTrackingAction(){
        // Get the Request parameters
    	$params             = $this->getRequest()->getParams();
    	$secretkey          = $this->secretkey;
    	$db                 = $this->db;
        // Genaral Information of the user login details
    	$appkey             = isset($params['appkey']) ? $params['appkey'] : "";
    	$user_id            = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$password            = isset($params['password']) ? $params['password'] : "";
    	$Imei               = isset($params['Imei_no']) ? $params['Imei_no'] : "";
    	$lat                = isset($params['user_latitude']) ? $params['user_latitude'] : "";
    	$long               = isset($params['user_longitude']) ? $params['user_longitude'] : "";
    	$time_spend         = isset($params['time_spend']) ? date('Y-m-d H:i:s',strtotime($params['time_spend'])) : date('Y-m-d H:i:s');
    	$datetime           = isset($params['datetime']) ? $params['datetime'] : "";
    	$dataOnOff          = isset($params['dataOnOff']) ? $params['dataOnOff'] : "";
    	$move_status        = isset($params['move_status']) ? $params['move_status'] : "";
    	$battery_status     = isset($params['battery_status']) ? $params['battery_status'] : "";
    	$travelled_distance = isset($params['travelled_distance']) ? $params['travelled_distance'] : "";
    	$velocity           = isset($params['velocity']) ? $params['velocity'] : "";

    	$error_code = 1;
    	$succes     = FALSE;

    	try {

    		$db->beginTransaction();
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($user_id,$password);
    		$count   = count($alldata);
      // print_r($alldata);

    		// if ($alldata['Device_token'] != $appkey) {
    		// 	throw new Exception("Invalid request.");
    		// }
    		if (!$user_id || !$Imei || !$lat || !$long) {
    			throw new Exception("Required parameter missing.");
    		}
    		if (!empty($alldata['LoginID']) != $user_id) {
    			throw new Exception('Invalid user.');
    		}
    		if (!empty($alldata['device_id'])) {
    			if ($alldata['device_id'] != $Imei) {
    				$error_code = 3;
    				throw new Exception('You are not athorized for this device.');
    			}
    		}
    		if (strtoupper($alldata['StaffStatus']) != 'AC') {
    			throw new Exception('Your account is not active.');
    		}
    		$last_track_query = "select * from user_path where mob_user_staff_code = '".$alldata['LoginID']."' order by id desc limit 1";
    		$last_track =  $db->fetchRow($last_track_query);
    		if($last_track){
    			$travelled_distance = round($this->getCordinateDistance($last_track['lat'],$last_track['long'],$lat,$long),2);
    			$timediff_in_hr = ((strtotime(date('Y-m-d H:i:s')) - strtotime($last_track['time_spend']))/60)/60;
    			$velocity = $travelled_distance/$timediff_in_hr;
    		}else{
    			$travelled_distance = 0;
    			$velocity = 0;
    		}

    		$velocity_round_off = number_format($velocity, 1, '.', '');
    		$address            = $this->getAddress($lat, $long);

    		$insert                        = array();
    		$insert['mob_user_staff_code'] = $alldata['LoginID'];
    		$insert['lat']                 = $lat;
    		$insert['long']                = $long;
    		$insert['address']             = $address;
    		$insert['add_date_time']       = date("Y-m-d H:i:s");
    		$insert['battery_status']      = $battery_status;
    		$insert['userId']              = $alldata['userId'];
    		$insert['travelled_distance']  = $travelled_distance;
    		$insert['time_spend']          = $time_spend  ;
    		$insert['datetime']            = date('Y-m-d H:i:s', strtotime($datetime));
    		$insert['dataOnOff']           = $dataOnOff;
    		if ($velocity) {
    			$insert['velocity'] = $velocity_round_off;
    		}
    		$insert['move_status'] = $move_status;

    		if($last_track && $travelled_distance > "0.05"){
    			$db->insert('user_path', $insert);
    		}else if(!$last_track){
    			$db->insert('user_path', $insert);
    		}

    		if ($alldata['Last_location_service_hit_time'] != $this->currdate) {
    			$update['lat']                            = $lat;
    			$update['long']                           = $long;
    			$update['moving_status']                  = $move_status;
    			$update['network_status']                 = $dataOnOff;
    			$update['battery_status']                 = $battery_status;
    			$update['Last_location_service_hit_time'] = $this->currdate;
    			$user->updateSingleTableData('logi_user', $update, 'LoginID', $alldata['LoginID']);
    		}
    		$db->commit();


    		$succes = TRUE;
    	}
    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();

    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'Location track added successfully.'
    		));
    		exit;

    	}
    	else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }


    public function trackUserAction(){
        // Get the Request parameters
    	$params    = $this->getRequest()->getParams();
    	$secretkey = $this->secretkey;
    	$db        = $this->db;
        // Genaral Information of the user login details
    	$appkey    = isset($params['appkey']) ? $params['appkey'] : "";
    	$user_id   = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$Imei      = isset($params['Imei_no']) ? $params['Imei_no'] : "";
    	$password      = isset($params['Password']) ? $params['Password'] : "";

    	if (get_magic_quotes_gpc()) {
    		$get_user_track_data = stripslashes($params['GPSData']);
    	} else {
    		$get_user_track_data = $params['GPSData'];
    	}
    	$get_user_track_data = json_decode($get_user_track_data, true);

    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($user_id,$password);
    		$count   = count($alldata);

    		if ($alldata['Device_token'] != $appkey) {
    			throw new Exception("Invalid request.");
    		}
    		if (!$user_id || !$Imei) {
    			throw new Exception("Required parameter missing.");
    		}
    		if (!empty($alldata['LoginID']) != $user_id) {
    			throw new Exception('Invalid user.');
    		}
    		if (!empty($alldata['device_id'])) {
    			if ($alldata['device_id'] != $Imei) {
    				$error_code = 3;
    				throw new Exception('You are not athorized for this device.');
    			}
    		}

    		if (strtoupper($alldata['StaffStatus']) != 'AC') {
    			throw new Exception('Your account is not active.');
    		}

    		$k = 0;
    		foreach ($get_user_track_data as $k) {
    			if ($k['user_latitude'] > 1 && $k['user_longitude'] > 1) {

    				$address = $this->getAddress($k['user_latitude'], $k['user_longitude']);

    				$last_track_query = "select * from user_path where mob_user_staff_code = '".$alldata['LoginID']."' limit 1";
    				$last_track =  $db->fetchRow($last_track_query);
    				if($last_track){
    					$travelled_distance = round($this->getCordinateDistance($last_track['lat'],$last_track['long'],$k['user_latitude'],$k['user_longitude'],2));
    				}else{
    					$travelled_distance = 0;
    				}

    				$velocity_round_off            = number_format($k['velocity'], 1, '.', '');
    				$insert                        = array();
    				$insert['mob_user_staff_code'] = $alldata['LoginID'];
    				$insert['lat']                 = $k['user_latitude'];
    				$insert['long']                = $k['user_longitude'];
    				$insert['address']             = $address;
    				$insert['add_date_time']       = date('Y-m-d H:i:s', strtotime($k['datetime'])); 
    				$insert['battery_status']      = $k['battery_status'];
    				$insert['userId']              = $alldata['userId'];
    				$insert['travelled_distance']  = $travelled_distance;
    				$insert['time_spend']          = $k['time_spend'];
    				$insert['datetime']            = date('Y-m-d H:i:s', strtotime($k['datetime']));
    				$insert['dataOnOff']           = $k['dataOnOff'];
    				$insert['created_at']          = date("Y-m-d H:i:s");
    				if ($k['velocity']) {
    					$insert['velocity']        = $velocity_round_off;
    				}
    				$insert['move_status']         = $k['move_status'];
    				$db->insert('user_path', $insert);
    				$k++;

    				if (date('Y-m-d', strtotime($k['datetime'])) == date("Y-m-d")) {
    					if ($alldata['Last_location_service_hit_time'] != $this->currdate) {
    						$address                                  = $this->getAddress($k['user_latitude'], $k['user_longitude']);
    						$update['lat']                            = $k['user_latitude'];
    						$update['long']                           = $k['user_longitude'];
    						$update['moving_status']                  = $k['move_status'];
    						$update['network_status']                 = $k['dataOnOff'];
    						$update['battery_status']                 = $k['battery_status'];
    						$update['Last_location_service_hit_time'] = $this->currdate;
    						$update['address']                        = $address;
    						$user->updateSingleTableData('logi_user', $update, 'LoginID', $alldata['LoginID']);
    					}
    				}
    			}
    		}
    		$db->commit();
    		$succes = TRUE;
    	}

    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();

    	}

    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'Location track added successfully.'
    		));
    		exit;

    	}

    	else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}

    }

    public function getRetailerListAction(){

        // Get the Request parameters
    	$params    = $this->getRequest()->getParams();
    	$secretkey = $this->secretkey;
    	$db        = $this->db;
        // Genaral Information of the user login details
    	$appkey    = isset($params['appkey']) ? $params['appkey'] : "";
    	$user_id   = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$Imei      = isset($params['Imei_no']) ? $params['Imei_no'] : "";
    	$password  = isset($params['Password']) ? $params['Password'] : ""; 

    	$by_status  = isset($params['by_status']) ? $params['by_status'] : ""; 
    	$by_date  = isset($params['by_date']) ? $params['by_date'] : ""; 
    	$lat  = isset($params['lat']) ? $params['lat'] : "";
    	$lng  = isset($params['lng']) ? $params['lng'] : "";

    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();
         //  if ($secretkey != $appkey) {
         //     throw new Exception("Invalid request.");
         // }

    		if (!$Imei) {
    			throw new Exception("Device ID missing.");
    		}
    		if (!$user_id) {
    			throw new Exception("Login ID missing.");
    		}
    		if (!$password) {
    			throw new Exception("Password missing.");
    		}

    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($user_id, $password);

    		if (!empty($alldata['LoginID']) != $user_id) {
    			throw new Exception('Invalid login id.');
    		}

    		if (!empty($alldata['device_id'])) {
    			if ($alldata['device_id'] != $Imei) {
    				$error_code = 3;
    				throw new Exception('You are not athorized for this device.');
    			}
    		}

    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 3;
    			throw new Exception('Your account is not active.');
    		}

    		if ($alldata['access_status'] == 2) {
    			$error_code = 2;
    			throw new Exception('This account deactivated by admin.');
    		}



    		$getCrosspondingReetailers = $user->getCrosspondingReetailers($by_date, $by_status, $alldata['userId'], $alldata['Role'],$lat,$lng);

    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'list of retailers',
    			'retailers_detail' => $getCrosspondingReetailers
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }

    //Insert Order Api used for inserting new order 
    //Created By Puneet Mishra
    public function insertOrderDetailAction(){
        // Get the Request parameters
    	$params    = $this->getRequest()->getParams();
    	$secretkey = $this->secretkey;
    	$db        = $this->db;
    	if (get_magic_quotes_gpc()) {
    		$item_detail = stripslashes($params['item_detail']);
    	} else {
    		$item_detail = $params['item_detail'];
    	}

    	$item_detail_data = json_decode($item_detail, true);
        // Genaral Information of the user login details
    	$appkey           = isset($params['appkey']) ? $params['appkey'] : "";
    	$LoginID          = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$Imei             = isset($params['device_id']) ? $params['device_id'] : "";
    	$distributer_id   = isset($params['distributer_id']) ? $params['distributer_id'] : "";
    	$retailer_id      = isset($params['retailer_id']) ? $params['retailer_id'] : "";
    	$state            = isset($params['state']) ? $params['state'] : "";
    	$district         = isset($params['district']) ? $params['district'] : "";
    	$shift            = isset($params['shift']) ? $params['shift'] : "1";
    	$order_date       = isset($params['order_date']) ? $params['order_date'] : "";

    	$type             = isset($params['type']) ? $params['type'] : "";
    	$order_code       = isset($params['order_code']) ? $params['order_code'] : "";
    	$remark           = isset($params['remark']) ? $params['remark'] : "";
    	$password         = isset($params['Password']) ? $params['Password'] : "";

    	$error_code       = 1;
    	$succes           = FALSE;

    	try {
    		$db->beginTransaction();
    		if (!$Imei || !$LoginID) {
    			throw new Exception("Required parameter missing.");
    		}

    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($LoginID, $password);

    		if (!empty($alldata['LoginID']) != $LoginID) {
    			throw new Exception('Invalid login id.');
    		}

    		if (!empty($alldata['device_id'])) {
    			if ($alldata['device_id'] != $Imei) {
    				$error_code = 3;
    				throw new Exception('You are not athorized for this device.');
    			}
    		}

    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 3;
    			throw new Exception('Your account is not active.');
    		}     

    		if ($alldata['access_status'] == 2) {
    			$error_code = 2;
    			throw new Exception('This account deactivated by admin.');
    		}

    		$getRetailerDetail = $user->getUserDetailById($params['retailer_id']);
    		$distributer       = $user->getUserDetailById($distributer_id);

    		$sql_distributor_user_detail = "select * from logi_user where id = '" . $distributer_id . "'";
    		$res_distributor_user        = $db->fetchRow($sql_distributor_user_detail);

    		$sql_get_psm = "select * from logi_user where id = '" . $retailer_id . "'";
    		$res_psm     = $db->fetchRow($sql_get_psm);
    		if ($type == "0") {
                //Insert Order Detail
    			$order_insert_data                            = array();
                $order_insert_data['retailer_id']             = $retailer_id; //Retailer
                $order_insert_data['distributor_id']          = $distributer_id;
                $order_insert_data['sale_person_id']          = $res_psm['parent_sale'];
                $order_insert_data['status']                  = '0';
                $order_insert_data['order_date']              = $order_date;
                $order_insert_data['state']                   = $res_distributor_user['state']; //Sale
                $order_insert_data['district']                = $res_distributor_user['DistrictID'];
                $order_insert_data['shift']                   = $shift;
                $order_insert_data['remark']                  = $remark;
                
                $order_insert_data['parent_regional_manager'] = $res_psm['parent_regional_manager'];
                $order_insert_data['parent_zonal_manager']    = $res_psm['parent_zonal_manager'];
                $order_insert_data['parent_area_manager']     = $res_psm['parent_area_manager'];
                $order_insert_data['created_by']              = $alldata['userId'];
                $db->insert('logi_order', $order_insert_data);
                $lastorderInsertId = $db->lastInsertId();
                $ordrId                                       = 'ORDER0' . $lastorderInsertId; //Generated Order Code
                $generate_order_code                          = array();
                $generate_order_code['code']                  = $ordrId;
                $db->update('logi_order', $generate_order_code, array(
                	'id=?' => $lastorderInsertId
                ));
                
                $i = 1;
                foreach ($item_detail_data as $value) {
                	if ($value['scheme_id']) {
                		$get_scheme_detail[$i] = "select * from tbl_product_scheme where  id = '" . $value['scheme_id'] . "'";
                		$result[$i]            = $db->fetchRow($get_scheme_detail[$i]);

                		if ($result[$i]['type'] == 'percentage') {
                			$deduct_amount[$i] = $value['amount'] * $result[$i]['off_price_percentage'] / 100;
                		} else {
                			$count_qty        = $value['qty'] / $result[$i]['buy_qty'];
                			$get_free_qty[$i] = floor($count_qty) * $result[$i]['get_free_qty'];
                		}
                	}
                	$total_price[$i] = $value['amount'] - $deduct_amount[$i];

                	$order_insert_item_data[$i]                            = array();
                	$order_insert_item_data[$i]['order_id']                = $lastorderInsertId;
                	$order_insert_item_data[$i]['product_id']              = $value['product_id'];
                	$order_insert_item_data[$i]['subproduct_id']           = $value['sub_product_id'];
                	$order_insert_item_data[$i]['qty']                     = $value['qty'];
                	$order_insert_item_data[$i]['rate']                    = $value['rate'];
                	$order_insert_item_data[$i]['amount']                  = $value['amount'];
                	$order_insert_item_data[$i]['distributor_id']          = $distributer_id;
                	$order_insert_item_data[$i]['retailer_id']             = $retailer_id;
                	$order_insert_item_data[$i]['schemed_product_id']      = $result[$i]['scheme_on_product'];
                	$order_insert_item_data[$i]['schemed_subproduct_id']   = $result[$i]['scheme_on_subproduct'];
                	$order_insert_item_data[$i]['off_price']               = $deduct_amount[$i];
                	$order_insert_item_data[$i]['offered_qty']             = $get_free_qty[$i];
                	$order_insert_item_data[$i]['scheme_id']               = $value['scheme_id'];
                	$order_insert_item_data[$i]['off_price_percentage']    = $result[$i]['off_price_percentage'];
                	$order_insert_item_data[$i]['parent_regional_manager'] = $res_psm['parent_regional_manager'];
                	$order_insert_item_data[$i]['parent_zonal_manager']    = $res_psm['parent_zonal_manager'];
                	$order_insert_item_data[$i]['parent_area_manager']     = $res_psm['parent_area_manager'];
                	$order_insert_item_data[$i]['parent_sale_person']      = $res_psm['parent_sale'];

                	$db->insert('logi_order_item_detail', $order_insert_item_data[$i]);
                	$total_order_amount += $value['amount'];

                	$i++;
                }
                
                $insert_order_notification_detail                            = array();
                $insert_order_notification_detail['order_id']                = $lastorderInsertId; //Last inserted order id
                $insert_order_notification_detail['order_code']              = $ordrId;
                $insert_order_notification_detail['order_status']            = '0';
                $insert_order_notification_detail['read_status']             = '0';
                $insert_order_notification_detail['order_date']              = $order_date;
                $insert_order_notification_detail['shift']                   = $shift;
                $insert_order_notification_detail['parent_regional_manager'] = $res_psm['parent_regional_manager'];
                $insert_order_notification_detail['parent_zonal_manager']    = $res_psm['parent_zonal_manager'];
                $insert_order_notification_detail['parent_area_manager']     = $res_psm['parent_area_manager'];
                $insert_order_notification_detail['parent_sale_person']      = $res_psm['parent_sale'];
                $insert_order_notification_detail['distributor_id']          = $distributer_id;
                $insert_order_notification_detail['retailer_id']             = $retailer_id;
                $insert_order_notification_detail['created_by']              = $alldata['userId'];
                $insert_order_notification_detail['state_id']                = $res_distributor_user['state'];
                $insert_order_notification_detail['district_id']             = $res_distributor_user['DistrictID'];
                $db->insert('tbl_order_notification', $insert_order_notification_detail);
                
                $update_total_order_amount              = array();
                $update_total_order_amount['total_amt'] = $total_order_amount;
                $db->update('logi_order', $update_total_order_amount, array(
                	'id=?' => $lastorderInsertId
                ));
                $msg = "Order Generated Successfully";
            }

            if ($type == "1") { //Update  Order Detail
            	$getOrderIdByOrderCode = $user->getOrderIdByOrderCode($order_code);
            	$user->deleteOrderItem($getOrderIdByOrderCode['id']);
            	foreach ($item_detail_data as $value) {
            		$order_insert_item_data                            = array();
            		$order_insert_item_data['order_id']                = $getOrderIdByOrderCode['id'];
            		$order_insert_item_data['product_id']              = $value['product_id'];
            		$order_insert_item_data['subproduct_id']           = $value['sub_product_id'];
            		$order_insert_item_data['qty']                     = $value['qty'];
            		$order_insert_item_data['rate']                    = $value['rate'];
            		$order_insert_item_data['amount']                  = $value['amount'];
            		$order_insert_item_data['distributor_id']          = $distributer_id;
            		$order_insert_item_data['retailer_id']             = $retailer_id;
            		$order_insert_item_data['parent_regional_manager'] = $res_psm['parent_regional_manager'];
            		$order_insert_item_data['parent_zonal_manager']    = $res_psm['parent_zonal_manager'];
            		$order_insert_item_data['parent_area_manager']     = $res_psm['parent_area_manager'];
            		$order_insert_item_data['parent_sale_person']      = $res_psm['parent_sale'];
            	}

            	$update_total_order_amount              = array();
            	$update_total_order_amount['total_amt'] = $total_order_amount;
            	$db->update('logi_order', $update_total_order_amount, array(
            		'id=?' => $getOrderIdByOrderCode['id']
            	));
            	$msg               = "Order Updated Successfully";
            	$ordrId            = $order_code;
            	$lastorderInsertId = $getOrderIdByOrderCode['id'];
            }
            $db->commit();
            $succes = TRUE;
        }
        catch (Exception $e) {
            //Rollback transaction
        	$db->rollBack();
        	$error = $e->getMessage();
        }
        if ($succes == TRUE) {
        	echo json_encode(array(
        		"error_code" => '0',
        		'response_string' => $msg,
        		'Server_id' => $lastorderInsertId,
        		'Server_code' => $ordrId
        	));
        	exit;
        } else {
        	echo json_encode(array(
        		"error_code" => $error_code,
        		'response_string' => $error
        	));
        	exit;
        }
    }


    public function saveRetailerAction(){
    	$params             = $this->getRequest()->getParams();
    	$secretkey          = $this->secretkey;
    	$db                 = $this->db;
    	$appkey             = isset($params['appkey']) ? $params['appkey'] : "";
    	$loginId            = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$distributer_id     = isset($params['distributer_id']) ? $params['distributer_id'] : "";
    	$name               = isset($params['name']) ? $params['name'] : "";
    	$email              = isset($params['email']) ? $params['email'] : "";
    	$phone              = isset($params['phone']) ? $params['phone'] : "";
    	$permanent_address  = isset($params['permanent_address']) ? $params['permanent_address'] : "";
    	$local_generated_id = isset($params['local_generated_id']) ? $params['local_generated_id'] : ""; 
    	$lat                = isset($params['user_latitude']) ? $params['user_latitude'] : "";
    	$long               = isset($params['user_longitude']) ? $params['user_longitude'] : "";
    	$taging_date        = isset($params['taging_date']) ? $params['taging_date'] : "";
    	$tag_status         = isset($params['tag_status']) ? $params['tag_status'] : "";
    	$password           = isset($params['Password']) ? $params['Password'] : "";
    	$category           = isset($params['category']) ? $params['category'] : "";
    	$mapped_area        = isset($params['mapped_area']) ? $params['mapped_area'] : "";

    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();
    		if (!$loginId || !$appkey || !$password) {
    			throw new Exception("Required parameter missing.");
    		}
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($loginId, $password);

    		if ($appkey != $alldata['Device_token']) {
    			throw new Exception("Invalid appkey.");
    		}

    		if (!empty($alldata['LoginID']) != $loginId) {
    			$error_code = 3;
    			throw new Exception('Invalid login id.');
    		}

    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 5;
    			throw new Exception('Your account is not active.');
    		}

    		$sql_check_user = "select id from logi_user where StaffName = '".$name."' and MobileNo ='".$phone."'";
    		$result_user    = $db->fetchRow($sql_check_user);

    		if ($result_user) {
    			$error_code = 6;
    			throw new Exception('Retailer already exist.');
    		}

    		$sql_get_psm = "select * from logi_user where id = '".$distributer_id."'";
    		$res_psm     = $db->fetchRow($sql_get_psm);

    		$retailer                            = array();
    		$retailer['StaffName']               = $name;
    		$retailer['Email']                   = $email;
    		$retailer['MobileNo']                = $phone;
    		$retailer['Address_Per']             = $permanent_address;
    		$retailer['Address_Curr']            = $permanent_address;
    		$retailer['parent_regional_manager'] = $res_psm['parent_regional_manager'];
    		$retailer['parent_zonal_manager']    = $res_psm['parent_zonal_manager'];
    		$retailer['parent_area_manager']     = $res_psm['parent_area_manager'];
    		$retailer['parent_sale']             = $res_psm['parent_sale'];
    		$retailer['parent_distributer']      = $distributer_id;
    		$retailer['state']                   = '38';
    		$retailer['DistrictID']              = '86';
    		$retailer['local_generated_id']      = $local_generated_id;
    		$retailer['Role']                    = 'Retailer';
    		$retailer['region']                  = '1';
    		$retailer['zone']                    = '1';
    		$retailer['tagged_latitude']         = $lat;
    		$retailer['tagged_longitude']        = $long;
    		$retailer['tag_status']              = '1';
    		$retailer['approval_status']         = '0';
    		$retailer['category']                = $category;
    		$retailer['area_id']                 = $mapped_area;
    		$db->insert('logi_user', $retailer);
    		$lastretailerInsertId = $db->lastInsertId();

    		$login_id                            = 'RET00' . $lastretailerInsertId;
    		$update_login_id                     = array();
    		$update_login_id['LoginID'] = $login_id;
    		$db->update('logi_user', $update_login_id, array(
    			'id=?' => $lastretailerInsertId
    		)); 

    		$message = "Hi $name, Thank you for connecting with Rufil.Thanks & Regards : Rufil Team";
    		$this->send_sms($phone,$message);

    		$sqlOtherUser = "select user_id, location_name from logi_user_location_mapping where user_id != ".$alldata['userId']." and location_id = ".$mapped_area;
    		$resultOtherUser = $db->fetchAll($sqlOtherUser);
    		if($resultOtherUser){
    			foreach($resultOtherUser as $other_user_data){
    				$push_message = "$name has been added in area ".$other_user_data['location_name'];
    				$this->pushNotification($push_message, $other_user_data['user_id']);
    			}
    		}

    		$notification                            = array();
    		$notification['transaction_id']          = $lastretailerInsertId;
    		$notification['notification_type']       = '11';
    		$notification['notification_type_str']   = 'new_retailer';
    		$notification['notification_date_time']  = $this->currdate;
    		$notification['parent_regional_manager'] = $res_psm['parent_regional_manager'];
    		$notification['parent_zonal_manager']    = $res_psm['parent_zonal_manager'];
    		$notification['parent_area_manager']     = $res_psm['parent_area_manager'];
    		$notification['parent_sale_person']      = $res_psm['parent_zonal_manager'];
    		$notification['distributor_id']          = $res_psm['parent_sale'];
    		$notification['retailer_id']             = $lastretailerInsertId;
    		$notification['app_user_id']             = $alldata['userId'];
    		$db->insert('logi_notification', $notification);
    		$retailer_id = $db->lastInsertId();

    		$retailergeotagingdetail = array();
    		if (isset($_FILES['photograph1']['tmp_name']) AND !empty($_FILES['photograph1']['tmp_name'])) {
    			$tempName  = $_FILES['photograph1']['tmp_name'];
    			$imageName = time() . $_FILES['photograph1']['name'];
    			$uploads   = 'uploads/retailer_site_location/';
    			if (!file_exists($uploads)) {
    				mkdir($uploads);
    			}
    			$pathComplete = $uploads . $imageName;
    			@move_uploaded_file($tempName, $pathComplete);
    			$retailergeotagingdetail['photograph1'] = $imageName;
    		}

    		if (isset($_FILES['photograph2']['tmp_name']) AND !empty($_FILES['photograph2']['tmp_name'])) {
    			$tempName1  = $_FILES['photograph2']['tmp_name'];
    			$imageName2 = time() . $_FILES['photograph2']['name'];
    			$uploads1   = 'uploads/retailer_site_location/';
    			if (!file_exists($uploads1)) {
    				mkdir($uploads1);
    			}
    			$pathComplete1 = $uploads1 . $imageName2;
    			@move_uploaded_file($tempName1, $pathComplete1);
    			$retailergeotagingdetail['photograph2'] = $imageName2;
    		}

    		$sql_get_retailer = "select * from logi_user where id = '" . $retailer_id . "'";
    		$res_retailer     = $db->fetchRow($sql_get_retailer);

    		$distributer                                        = $user->getUserDetailById($distributer_id);
    		$retailergeotagingdetail['retailer_id']             = $lastretailerInsertId;
    		$retailergeotagingdetail['lat']                     = $lat;
    		$retailergeotagingdetail['long']                    = $long;
    		$retailergeotagingdetail['sale_person_id']          = $alldata['userId'];
    		$retailergeotagingdetail['distributer_person_id']   = $distributer['LoginID'];
    		$retailergeotagingdetail['taging_date']             = $taging_date;
    		$retailergeotagingdetail['parent_regional_manager'] = $res_retailer['parent_regional_manager'];
    		$retailergeotagingdetail['parent_zonal_manager']    = $res_retailer['parent_zonal_manager'];
    		$retailergeotagingdetail['parent_area_manager']     = $res_retailer['parent_area_manager'];
    		$retailergeotagingdetail['parent_sale_person']      = $res_retailer['parent_sale'];
    		$retailergeotagingdetail['taging_date']             = $taging_date;
    		$db->insert('retailers_site_location', $retailergeotagingdetail);

    		$updateUserDetail               = array();
    		$updateUserDetail['tag_status'] = $tag_status;
    		$db->update('logi_user', $updateUserDetail, array(
    			'id=?' => $retailer_id
    		));

    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {

    		$db->rollBack();
    		$error = $e->getMessage();
    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code"         => '0',
    			'response_string'    => 'Retailer details has been added successfully.',
    			'local_generated_id' => $local_generated_id,
    			'server_id'          => $lastretailerInsertId,
    			'user_latitude'      => $user_latitude,
    			'user_longitude'     => $user_longitude
    		));
    		exit;
    	}

    	else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }

    public function checkExistingRetailerAction(){
    	$params            = $this->getRequest()->getParams();
    	$secretkey         = $this->secretkey;
    	$db                = $this->db;

    	$appkey            = isset($params['appkey']) ? $params['appkey'] : "";
    	$loginId           = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$distributer_id    = isset($params['distributer_id']) ? $params['distributer_id'] : "";
    	$name              = isset($params['name']) ? $params['name'] : "";
    	$email             = isset($params['email']) ? $params['email'] : "";
    	$phone             = isset($params['phone']) ? $params['phone'] : "";
    	$permanent_address = isset($params['permanent_address']) ? $params['permanent_address'] : "";

    	$error_code = 1;
    	$succes     = FALSE;

    	try {

    		$db->beginTransaction();
    		if (!$loginId || !$appkey) {
    			throw new Exception("Required parameter missing.");
    		}
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($loginId);

    		if ($appkey != $alldata['Device_token']) {
    			throw new Exception("Invalid appkey.");
    		}

    		if (!empty($alldata['LoginID']) != $loginId) {
    			$error_code = 3;
    			throw new Exception('Invalid login id.');
    		}

    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 5;
    			throw new Exception('Your account is not active.');
    		}

    		$sql    = "select * from logi_user where StaffName like '%" . $name . "%'";
    		$result = $db->fetchRow($sql);

    		if ($result) {
    			$error_code = 6;
    			$msg_string = "Retailer already exist";
    		} else {
    			$error_code = 2;
    			$msg_string = "Success";
    		}

    		$db->commit();
    		$succes = TRUE;
    	}

    	catch (Exception $e) {

    		$db->rollBack();
    		$error = $e->getMessage();

    	}

    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $msg_string,
    			'server_id' => $lastretailerInsertId
    		));
    		exit;

    	}

    	else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}

    }

    public function updateOrderStatusAction(){

        // Get the Request parameters
    	$params       = $this->getRequest()->getParams();
    	$secretkey    = $this->secretkey;
    	$db           = $this->db;
        // Genaral Information of the user login details
    	$LoginID      = isset($params['LoginID']) ? $params['LoginID'] : "";
        // $Imei   = isset($params['device_id'])?$params['device_id']:"";
    	$order_id     = isset($params['order_id']) ? $params['order_id'] : "";
    	$order_status = isset($params['order_status']) ? $params['order_status'] : "";
    	$error_code   = 1;
    	$succes       = FALSE;

    	try {
    		$db->beginTransaction();


    		if (!$LoginID) {
    			$error_code = 2;
    			throw new Exception("Required parameter missing.");
    		}

    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($LoginID);


    		if (!empty($alldata['LoginID']) != $LoginID) {
    			$error_code = 3;
    			throw new Exception('Invalid login id.');
    		}

    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 5;
    			throw new Exception('Your account is not active.');
    		}

    		if ($alldata['access_status'] == 2) {
    			$error_code = 6;
    			throw new Exception('This account deactivated by admin.');
    		}

    		$update_order_status = array();
    		if (isset($_FILES['order_invoice']['tmp_name']) AND !empty($_FILES['order_invoice']['tmp_name'])) {
    			$tempName  = $_FILES['order_invoice']['tmp_name'];
    			$imageName = time() . $_FILES['order_invoice']['name'];
    			$uploads   = 'uploads/order_invoice/';
    			if (!file_exists($uploads)) {
    				mkdir($uploads);
    			}
    			$pathComplete = $uploads . $imageName;
    			@move_uploaded_file($tempName, $pathComplete);
    		}
    		$update_order_status['attachment'] = $imageName;
    		$update_order_status['status']     = $order_status;
    		$db->update('logi_order', $update_order_status, array(
    			'code=?' => $order_id
    		));

    		$sql_get_order = "select * from logi_order where code = '" . $order_id . "'";
    		$res_order     = $db->fetchRow($sql_get_order);

    		$insert_order_notification_detail                            = array();
            $insert_order_notification_detail['order_id']                = $res_order['id']; //Last inserted order id
            $insert_order_notification_detail['order_code']              = $res_order['code'];
            $insert_order_notification_detail['order_status']            = $order_status;
            $insert_order_notification_detail['read_status']             = '0';
            $insert_order_notification_detail['order_date']              = $this->currdate;
            $insert_order_notification_detail['shift']                   = $res_order['shift'];
            $insert_order_notification_detail['parent_regional_manager'] = $res_order['parent_regional_manager'];
            $insert_order_notification_detail['parent_zonal_manager']    = $res_order['parent_zonal_manager'];
            $insert_order_notification_detail['parent_area_manager']     = $res_order['parent_area_manager'];
            $insert_order_notification_detail['parent_sale_person']      = $res_order['sale_person_id'];
            $insert_order_notification_detail['distributor_id']          = $res_order['distributor_id'];
            $insert_order_notification_detail['retailer_id']             = $res_order['retailer_id'];
            $insert_order_notification_detail['created_by']              = $alldata['userId'];
            $insert_order_notification_detail['state_id']                = $res_order['state'];
            $insert_order_notification_detail['district_id']             = $res_order['district'];
            $db->insert('tbl_order_notification', $insert_order_notification_detail);
            
            $db->commit();
            $succes = TRUE;
        }
        catch (Exception $e) {
            //Rollback transaction
        	$db->rollBack();
        	$error = $e->getMessage();
        }
        if ($succes == TRUE) {
        	echo json_encode(array(
        		"error_code" => '0',
        		'response_string' => 'Order Status Updated Successfully.'
        	));
        	exit;
        } else {
        	echo json_encode(array(
        		"error_code" => $error_code,
        		'response_string' => $error,
        		'params' => $params
        	));
        	exit;
        }
    }


    public function saveSurveyDataAction(){
        // Get the Request parameters
    	$params    = $this->getRequest()->getParams();
    	$secretkey = $this->secretkey;
    	$db        = $this->db;
    	$appkey    = isset($params['appkey']) ? $params['appkey'] : "";
    	$user_id   = isset($params['LoginID']) ? $params['LoginID'] : "";

    	$survey_type          = isset($params['survey_type']) ? $params['survey_type'] : "";
    	$party_name           = isset($params['party_name']) ? $params['party_name'] : "";
    	$contact_num          = isset($params['contact_num']) ? $params['contact_num'] : "";
    	$contact_person       = isset($params['contact_person']) ? $params['contact_person'] : "";
    	$name_of_dairy        = isset($params['name_of_dairy']) ? $params['name_of_dairy'] : "";
    	$tentative_requarment = isset($params['tentative_requarment']) ? $params['tentative_requarment'] : "";

    	$sku_wise_qty              = isset($params['sku_wise_qty']) ? $params['sku_wise_qty'] : "";
    	$contact_num               = isset($params['contact_num']) ? $params['contact_num'] : "";
    	$contact_person            = isset($params['contact_person']) ? $params['contact_person'] : "";
    	$name_of_dairy             = isset($params['name_of_dairy']) ? $params['name_of_dairy'] : "";
    	$name_existing_distributor = isset($params['name_existing_distributor']) ? $params['name_existing_distributor'] : "";
    	$survey_date               = isset($params['survey_date']) ? $params['survey_date'] : "";
    	$address                   = isset($params['address']) ? $params['address'] : "";
    	$remark                    = isset($params['remark']) ? $params['remark'] : "";

    	$name_of_colony       = isset($params['name_of_colony']) ? $params['name_of_colony'] : "";
    	$house_num            = isset($params['house_num']) ? $params['house_num'] : "";
    	$type_milk_consumtion = isset($params['type_milk_consumtion']) ? $params['type_milk_consumtion'] : "";
    	$sku_type             = isset($params['sku_type']) ? $params['sku_type'] : "";
    	$consumption_qty      = isset($params['consumption_qty']) ? $params['consumption_qty'] : "";
    	$ppm_sale             = isset($params['ppm_sale']) ? $params['ppm_sale'] : "";

    	$name_of_institution = isset($params['name_of_institution']) ? $params['name_of_institution'] : "";
    	$designation         = isset($params['designation']) ? $params['designation'] : "";
    	$competitor_price    = isset($params['competitor_price']) ? $params['competitor_price'] : "";

    	$terms_condition                 = isset($params['terms_condition']) ? $params['terms_condition'] : "";
    	$party_agreed                    = isset($params['party_agreed']) ? $params['party_agreed'] : "";
    	$demand_of_new_party             = isset($params['demand_of_new_party']) ? $params['demand_of_new_party'] : "";
    	$new_party_retailer              = isset($params['new_party_retailer']) ? $params['new_party_retailer'] : "";
    	$nature_of_bussiness             = isset($params['nature_of_bussiness']) ? $params['nature_of_bussiness'] : "";
    	$avg_qty                         = isset($params['avg_qty']) ? $params['avg_qty'] : "";
    	$nature_of_bussiness_other       = isset($params['nature_of_bussiness_other']) ? $params['nature_of_bussiness_other'] : "";
    	$name_existing_distributor_other = isset($params['name_existing_distributor_other']) ? $params['name_existing_distributor_other'] : "";


    	$error_code = 1;
    	$succes     = FALSE;

    	try {

    		$db->beginTransaction();
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($user_id);
    		if ($alldata['Device_token'] != $appkey) {
    			throw new Exception("Invalid request.");
    		}

    		if (!empty($alldata['LoginID']) != $user_id) {
    			throw new Exception('Invalid login id.');
    		}

    		if (!empty($alldata['device_id'])) {
    			if ($alldata['device_id'] != $Imei) {
    				$error_code = 3;
    				throw new Exception('You are not athorized for this device.');
    			}
    		}

    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 3;
    			throw new Exception('Your account is not active.');
    		}

    		if ($alldata['access_status'] == 2) {
    			$error_code = 2;
    			throw new Exception('This account deactivated by admin.');
    		}

    		if (isset($_FILES['signature']['tmp_name']) AND !empty($_FILES['signature']['tmp_name'])) {
    			$tempName       = $_FILES['signature']['tmp_name'];
    			$signature_name = time() . $_FILES['signature']['name'];
    			$uploads        = 'uploads/survey/';
    			if (!file_exists($uploads)) {
    				mkdir($uploads);
    			}
    			$pathComplete = $uploads . $signature_name;
    			@move_uploaded_file($tempName, $pathComplete);
    		}

    		$sql_get_psm = "select * from logi_user where LoginID = '" . $user_id . "'";
    		$res_psm     = $db->fetchRow($sql_get_psm);

    		$surveyData                         = array();
            //if($survey_type=='1'){  
    		$surveyData['party_name']           = $party_name;
    		$surveyData['sku_wise_qty']         = $sku_wise_qty;
    		$surveyData['name_of_dairy']        = $name_of_dairy;
    		$surveyData['tentative_reqirement'] = $tentative_requarment;

    		if ($name_existing_distributor == 'OTHERS') {
    			$surveyData['existing_distributor'] = $name_existing_distributor_other;
    			$surveyData['others']               = 'yes';
    		} else {
    			$surveyData['existing_distributor'] = $name_existing_distributor;
    		}
            //}    
            //else if($survey_type=='2'){
    		$surveyData['name_of_colony']       = $name_of_colony;
    		$surveyData['house_num']            = $house_num;
    		$surveyData['type_milk_consumtion'] = $type_milk_consumtion;
    		$surveyData['sku_type']             = $sku_type;
    		$surveyData['consumption_qty']      = $consumption_qty;
    		$surveyData['ppm_sale']             = $ppm_sale;
            //}
            //else if($survey_type=='3'){
    		$surveyData['name_of_institution']  = $name_of_institution;
    		$surveyData['designation']          = $designation;
    		$surveyData['competitor_price']     = $competitor_price;
    		$surveyData['terms_condition']      = $terms_condition;
            //}
            //else if($survey_type=='4'){
    		$surveyData['party_agreed']         = $party_agreed;
    		$surveyData['demand_of_new_party']  = $demand_of_new_party;
    		$surveyData['new_party_retailer']   = $new_party_retailer;
    		$surveyData['nature_of_bussiness']  = $nature_of_bussiness;
    		$surveyData['avg_qty']              = $avg_qty;
            // }
    		$surveyData['address']              = $address;
    		$surveyData['remark']               = $remark;
    		$surveyData['contact_number']       = $contact_num;
    		$surveyData['signature']            = $signature_name;
    		$surveyData['survey_type']          = $survey_type;
    		$surveyData['survey_date']          = $survey_date;
    		$surveyData['contact_person']       = $contact_person;
    		$surveyData['user_id']              = $alldata['userId'];

    		$surveyData['nature_of_bussiness_other'] = $nature_of_bussiness_other;

    		if ($alldata['Role'] == 'RM') {
    			$surveyData['parent_regional_manager'] = $res_psm['parent_regional_manager'];
    		} else if ($alldata['Role'] == 'ZM') {
    			$surveyData['parent_regional_manager'] = $res_psm['parent_regional_manager'];
    			$surveyData['parent_zonal_manager']    = $res_psm['id'];
    		} else if ($alldata['Role'] == 'ASM') {
    			$surveyData['parent_regional_manager'] = $res_psm['parent_regional_manager'];
    			$surveyData['parent_zonal_manager']    = $res_psm['parent_zonal_manager'];
    			$surveyData['parent_area_manager']     = $res_psm['id'];
    		} else if ($alldata['Role'] == 'Sales') {
    			$surveyData['parent_regional_manager'] = $res_psm['parent_regional_manager'];
    			$surveyData['parent_zonal_manager']    = $res_psm['parent_zonal_manager'];
    			$surveyData['parent_area_manager']     = $res_psm['parent_area_manager'];
    			$surveyData['parent_sale_person']      = $res_psm['id'];
    		}

    		$db->insert('tbl_survey', $surveyData);

    		$db->commit();
    		$succes = TRUE;
    	}

    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}

    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'Survey detail added successfully'
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }

    public function getSurveyListAction(){
        // Get the Request parameters
    	$params    = $this->getRequest()->getParams();
    	$secretkey = $this->secretkey;
    	$db        = $this->db;
        // Genaral Information of the user login details
    	$appkey    = isset($params['appkey']) ? $params['appkey'] : "";
    	$user_id   = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$Imei      = isset($params['device_id']) ? $params['device_id'] : "";
    	$date_from = isset($params['date_from']) ? $params['date_from'] : "";
    	$date_to   = isset($params['date_to']) ? $params['date_to'] : "";

    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();

    		if (!$Imei || !$user_id) {
    			throw new Exception("Required parameter missing.");
    		}

    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($user_id);

    		if (!empty($alldata['LoginID']) != $user_id) {
    			throw new Exception('Invalid login id.');
    		}

    		if (!empty($alldata['device_id'])) {
    			if ($alldata['device_id'] != $Imei) {
    				$error_code = 3;
    				throw new Exception('You are not athorized for this device.');
    			}
    		}

    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 3;
    			throw new Exception('Your account is not active.');
    		}

    		if ($alldata['access_status'] == 2) {
    			$error_code = 2;
    			throw new Exception('This account deactivated by admin.');
    		}

    		if ($date_from && $date_to) {
    			$cond .= "and s.survey_date between  '" . $date_from . "' and '" . $date_to . "'";
    		}

    		$sql_survey        = "select s.*, st.survey_name as survey_type_name from tbl_survey as s left join tbl_survey_type as st on (s.survey_type = st.id) where  s.user_id = '" . $alldata['userId'] . "'  $cond";
    		$res_survey_detail = $db->fetchAll($sql_survey);

    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'survey list',
    			'retailers_detail' => $res_survey_detail
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }



    public function saveExpensesAction(){
    	$db                         = $this->db;
        // Get the Request parameters
    	$params                     = $this->getRequest()->getParams();
        // Genaral Information of the user login details
    	$LoginID                    = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$invoiceType                = isset($params['invoiceType']) ? $params['invoiceType'] : "";
    	$expenseDate                = isset($params['expenseDate']) ? $params['expenseDate'] : "";
    	$amount                     = isset($params['amount']) ? $params['amount'] : "";
    	$remark                     = isset($params['remark']) ? $params['remark'] : "";
    	$attachment                 = isset($params['attachment']) ? $params['attachment'] : "";
    	$password                   = isset($params['Password']) ? $params['Password'] : "";
    	$start_reading              = isset($params['start_reading']) ? $params['start_reading'] : "";
    	$start_reading_attechment   = isset($params['start_reading_attechment']) ? $params['start_reading_attechment'] : "";
    	$end_reading                = isset($params['end_reading']) ? $params['end_reading'] : "";
    	$end_reading_attechement    = isset($params['end_reading_attechement']) ? $params['end_reading_attechement'] : "";

    	$error_code                 = 1;
    	$succes                     = FALSE;

    	try {

    		$db->beginTransaction();
    		if (!$LoginID) {
    			throw new Exception("Required parameter missing.");
    		}
    		$user           = new Application_Model_Users();
    		$alldata        = $user->getUserDataByLoginId($LoginID, $password);

    		if (!empty($alldata['LoginID']) != $LoginID) {
    			$error_code = 3;
    			throw new Exception('Invalid login id.');
    		}

    		$sqlUserInfo    = "select * from logi_user where LoginID = '" . $LoginID . "'";
    		$resUserInfo    = $db->fetchRow($sqlUserInfo);

    		$insertExpense  = array();
    		if (isset($_FILES['attachment']['tmp_name']) AND !empty($_FILES['attachment']['tmp_name'])) {
    			$tempName   = $_FILES['attachment']['tmp_name'];
    			$imageName  = time() . $_FILES['attachment']['name'];
    			$uploads    = 'uploads/expenses/';
    			if (!file_exists($uploads)) {
    				mkdir($uploads);
    			}
    			$pathComplete = $uploads . $imageName;
    			@move_uploaded_file($tempName, $pathComplete);
    			$insertExpense['attachment'] = $pathComplete;
    		}
    		if (isset($_FILES['start_reading_attechment']['tmp_name']) AND !empty($_FILES['start_reading_attechment']['tmp_name'])) {
    			$tempNameStartReading  = $_FILES['start_reading_attechment']['tmp_name'];
    			$imageNameStartReading = time() . $_FILES['start_reading_attechment']['name'];
    			$uploadsStartReading   = 'uploadsStartReading/expenses/';
    			if (!file_exists($uploadsStartReading)) {
    				mkdir($uploadsStartReading);
    			}
    			$pathCompleteStartReading = $uploadsStartReading . $imageNameStartReading;
    			@move_uploaded_file($tempNameStartReading, $pathCompleteStartReading);
    			$insertExpense['start_reading_attechment'] = $pathCompleteStartReading;
    		}
    		if (isset($_FILES['end_reading_attechement']['tmp_name']) AND !empty($_FILES['end_reading_attechement']['tmp_name'])) {
    			$tempNameEndReading  = $_FILES['end_reading_attechement']['tmp_name'];
    			$imageNameEndReading = time() . $_FILES['end_reading_attechement']['name'];
    			$uploadsEndReading   = 'uploadsEndReading/expenses/';
    			if (!file_exists($uploadsEndReading)) {
    				mkdir($uploadsEndReading);
    			}
    			$pathCompleteEndReading = $uploadsEndReading . $imageNameEndReading;
    			@move_uploaded_file($tempNameEndReading, $pathCompleteEndReading);
    			$insertExpense['end_reading_attechement'] = $pathCompleteEndReading;
    		}

    		$insertExpense['start_reading']               = $start_reading;
    		$insertExpense['end_reading']                 = $end_reading;
    		$insertExpense['LoginID']                     = $LoginID;
    		$insertExpense['user_id']                     = $resUserInfo['id'];
    		$insertExpense['invoiceType']                 = $invoiceType;
    		$insertExpense['dateFrom']                    = $expenseDate;
    		$insertExpense['dateTo']                      = $expenseDate;
    		$insertExpense['expenseDate']                 = $expenseDate;
    		$insertExpense['amount']                      = $amount;
    		$insertExpense['remark']                      = $remark;
    		if ($alldata['Role'] == 'RM') {
    			$insertExpense['parent_regional_manager'] = $resUserInfo['id'];
    		}else if ($alldata['Role'] == 'ZM') {
    			$insertExpense['parent_regional_manager'] = $resUserInfo['parent_regional_manager'];
    			$insertExpense['parent_zonal_manager']    = $resUserInfo['id'];
    		}else if ($alldata['Role'] == 'ASM') {
    			$insertExpense['parent_regional_manager'] = $resUserInfo['parent_regional_manager'];
    			$insertExpense['parent_zonal_manager']    = $resUserInfo['parent_zonal_manager'];
    			$insertExpense['parent_area_manager']     = $resUserInfo['id'];
    		}else if ($alldata['Role'] == 'Sales') {
    			$insertExpense['parent_regional_manager'] = $resUserInfo['parent_regional_manager'];
    			$insertExpense['parent_zonal_manager']    = $resUserInfo['parent_zonal_manager'];
    			$insertExpense['parent_area_manager']     = $resUserInfo['parent_area_manager'];
    			$insertExpense['parent_sale_person']      = $resUserInfo['id'];
    		}
    		$db->insert('tbl_expenses', $insertExpense);

    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'Expenses details has been added successfully.'
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }

    public function saveLeaveAction(){
        // Get the Request parameters
    	$params           = $this->getRequest()->getParams();
    	$db               = $this->db;
        // Genaral Information of the user login details
    	$LoginID          = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$leaveFrom        = isset($params['leaveFrom']) ? $params['leaveFrom'] : "";
    	$leaveTo          = isset($params['leaveTo']) ? $params['leaveTo'] : "";
    	$reason           = isset($params['reason']) ? $params['reason'] : "";
    	$leaveType        = isset($params['leaveType']) ? $params['leaveType'] : "";
        //  $halfDay     = isset($params['halfDay']) ? $params['halfDay'] : "";
    	$shift            = isset($params['shift']) ? $params['shift'] : "";
    	$attachment       = isset($params['attachment']) ? $params['attachment'] : "";
    	$leaveStatus      = isset($params['leaveStatus']) ? $params['leaveStatus'] : "";
    	$appliedDate      = isset($params['appliedDate']) ? $params['appliedDate'] : "";
    	$allocated_person = isset($params['allocated_person']) ? $params['allocated_person'] : "";
    	$password         = isset($params['Password']) ? $params['Password'] : "";


    	$error_code = 1;
    	$succes     = FALSE;

    	try {

    		$db->beginTransaction();
    		if (!$LoginID) {
    			throw new Exception("Required parameter missing.");
    		}
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($LoginID, $password);

    		if (!empty($alldata['LoginID']) != $LoginID) {
    			$error_code = 3;
    			throw new Exception('Invalid login id.');
    		}

    		$insertLeave = array();
    		if (isset($_FILES['attachment']['tmp_name']) AND !empty($_FILES['attachment']['tmp_name'])) {
    			$tempName  = $_FILES['attachment']['tmp_name'];
    			$imageName = time() . $_FILES['attachment']['name'];
    			$uploads   = 'uploads/leave/';
    			if (!file_exists($uploads)) {
    				mkdir($uploads);
    			}
    			$pathComplete = $uploads . $imageName;
    			@move_uploaded_file($tempName, $pathComplete);
    			$insertLeave['attachment'] = $imageName;
    		}

    		$insertLeave                     = array();
    		$insertLeave['LoginID']          = $LoginID;
    		$insertLeave['leaveFrom']        = $leaveFrom;
    		$insertLeave['leaveTo']          = $leaveTo;
            //$insertLeave['monthFrom']      = $monthFrom;
            //$insertLeave['monthTo']        = $monthTo;
    		$insertLeave['reason']           = $reason;
    		$insertLeave['leaveType']        = $leaveType;
            //$insertLeave['halfDay']        = $halfDay;
    		$insertLeave['shift']            = $shift;
            //$insertLeave['remainingLeave'] = $remainingLeave;
            //$insertLeave['leaveLeft']      = $leaveLeft;
    		$insertLeave['leaveStatus']      = $leaveStatus;
    		$insertLeave['appliedDate']      = $appliedDate;
    		$insertLeave['allocated_person'] = $allocated_person;
    		$db->insert('tbl_leave', $insertLeave);

    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}

    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'Leave details added successfully.'
    		));
    		exit;
    	}

    	else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}

    }

    public function getLeaveAction(){
        // Get the Request parameters
    	$params = $this->getRequest()->getParams();
    	$db     = $this->db;
        // Genaral Information of the user login details
    	$LoginID = isset($params['LoginID']) ? $params['LoginID'] : "";

    	$error_code = 1;
    	$succes     = FALSE;
    	try {
    		$db->beginTransaction();
    		if (!$LoginID) {
    			throw new Exception("Required parameter missing.");
    		}
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($LoginID);

    		if (!empty($alldata['LoginID']) != $LoginID) {
    			$error_code = 3;
    			throw new Exception('Invalid login id.');
    		}

    		$leave_status_query  = "SELECT * FROM tbl_leave_status ORDER BY leaveStatus";
    		$leave_status_result = $db->fetchAll($leave_status_query);

    		$leave_query  = "SELECT * FROM tbl_leave WHERE LoginID = '" . $params['LoginID'] . "'";
    		$leave_result = $db->fetchAll($leave_query);

    		$db->commit();
    		$succes = TRUE;
    	}

    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();

    	}

    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'Leave listed successfully.',
    			'leave_status_result' => $leave_status_result,
    			'leave_result' => $leave_result
    		));
    		exit;
    	}

    	else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}

    }

    public function getTaskAction(){
        // Get the Request parameters
    	$params  = $this->getRequest()->getParams();
    	$db      = $this->db;
        // Genaral Information of the user login details
    	$LoginID = isset($params['LoginID']) ? $params['LoginID'] : "";

    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();
    		if (!$LoginID) {
    			throw new Exception("Required parameter missing.");
    		}
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($LoginID);

    		if (!empty($alldata['LoginID']) != $LoginID) {
    			$error_code = 3;
    			throw new Exception('Invalid login id.');
    		}

    		$task_query  = "SELECT * FROM tbl_task_schedule WHERE LoginID = '" . $params['LoginID'] . "'";
    		$task_result = $db->fetchAll($task_query);

    		$db->commit();
    		$succes = TRUE;
    	}

    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();

    	}

    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'Task listed successfully.',
    			'task_result' => $task_result
    		));
    		exit;
    	}

    	else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}

    }

    public function getSchemeAction(){
        // Get the Request parameters
    	$params = $this->getRequest()->getParams();
    	$db     = $this->db;

    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();
    		$user = new Application_Model_Users();

    		$category_query              = "SELECT * FROM tbl_category GROUP BY category";
    		$this->view->category_result = $category_result = $db->fetchAll($category_query);

    		$product_query               = "SELECT * FROM tbl_product_price GROUP BY product";
    		$this->view->product_result  = $product_result = $db->fetchAll($product_query);

    		$area_query                  = "SELECT * FROM tbl_area GROUP BY area";
    		$this->view->area_result     = $area_result = $db->fetchAll($area_query);

    		$scheme_query  = "SELECT tas.scheme_id, tas.product_id, tas.scheme, tas.area_id, tas.cat_id, tc.category, tpp.product, tpp.price, ta.area FROM tbl_area_scheme AS tas LEFT JOIN tbl_category AS tc ON (tas.cat_id = tc.category_id) LEFT JOIN tbl_product_price AS tpp ON (tas.product_id = tpp.product_id) LEFT JOIN tbl_area AS ta ON (tas.area_id = ta.area_id)";
    		$scheme_result = $db->fetchAll($scheme_query);

    		$db->commit();
    		$succes = TRUE;
    	}

    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();

    	}

    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'Product listed successfully.',
    			'scheme_result' => $scheme_result,
    			'category_result' => $category_result,
    			'product_result' => $product_result,
    			'area_result' => $area_result
    		));
    		exit;

    	}

    	else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}

    }

    public function getRetailerTaggingDetailAction(){
        // Get the Request parameters
    	$params     = $this->getRequest()->getParams();
    	$db         = $this->db;
        // Genaral Information of the user login details
    	$LoginID    = isset($params['sale_person']) ? $params['sale_person'] : "";
    	$date_from  = isset($params['date_from']) ? $params['date_from'] : "";
    	$date_to    = isset($params['date_to']) ? $params['date_to'] : "";
        //print_r($LoginID); exit();
    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();
    		if (!$LoginID) {
    			throw new Exception("Required parameter missing.");
    		}
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($LoginID);

    		if (!empty($alldata['LoginID']) != $LoginID) {
    			$error_code = 3;
    			throw new Exception('Invalid login id.');
    		}
    		$Retailer               = new Application_Model_Retailer();
    		$getRetailerTaggingData = $Retailer->getRetailerTaggingData($params['sale_person'], $date_from, $date_to);
    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}

    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'Retailer listed successfully.',
    			'getRetailerTaggingData' => $getRetailerTaggingData
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}

    }

    /**
     * saveVisitPlanScheduleAction() method is used to save schedule task for sales persons.
     * @return JSON 
     */
    
    public function saveVisitPlanScheduleAction(){
        // Get the Request parameters
    	$params         = $this->getRequest()->getParams();
    	$db             = $this->db;
    	$appkey         = isset($params['appkey']) ? $params['appkey'] : "";
    	$LoginID        = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$device_id      = isset($params['device_id']) ? $params['device_id'] : "";
    	$retailer_id    = isset($params['retailer_id']) ? $params['retailer_id'] : "";
    	$visit_time     = isset($params['visit_time']) ? $params['visit_time'] : "";
    	$visit_purpose  = isset($params['visit_purpose']) ? $params['visit_purpose'] : "";
    	$visit_date     = isset($params['visit_date']) ? $params['visit_date'] : "";
    	$remark         = isset($params['remark']) ? $params['remark'] : "";
    	$status         = isset($params['status']) ? $params['status'] : "";
    	$plan_id        = isset($params['plan_id']) ? $params['plan_id'] : "";
    	$distributor_id = isset($params['distributor_id']) ? $params['distributor_id'] : "";
    	$LoginID        = strtoupper($LoginID);

    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();
    		if (!$LoginID || !$device_id) {
    			throw new Exception("Required parameter missing.");
    		}
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId(strtoupper($LoginID));
    		if (!empty($alldata['LoginID']) != strtoupper($LoginID)) {
    			throw new Exception('Invalid login id.');
    		}

    		if (!empty($alldata['DeviceID'])) {
    			if ($alldata['DeviceID'] != $device_id) {
    				$error_code = 3;
    				throw new Exception('You are not athorized for this device.');
    			}
    		}

    		if ($appkey != $alldata['Device_token']) {
    			throw new Exception("Invalid appkey.");
    		}
    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 3;
    			throw new Exception('Your account is not active.');
    		}

    		if ($alldata['App_Access_Status'] == 2) {
    			$error_code = 2;
    			throw new Exception('This account deactivated by admin.');
    		}

    		$sql_get_psm = "select * from logi_user where id = '" . $retailer_id . "'";
    		$res_psm     = $db->fetchRow($sql_get_psm);

    		$planedVisitDetailArray                   = array();
    		$planedVisitDetailArray['retailer_id']    = $retailer_id;
    		$planedVisitDetailArray['schedule_time']  = $visit_time;
    		$planedVisitDetailArray['schedule_date']  = $visit_date;
    		$planedVisitDetailArray['remark']         = $remark;
    		$planedVisitDetailArray['loginid']        = strtoupper($LoginID);
    		$planedVisitDetailArray['sale_person_id'] = $res_psm['parent_sale'];
    		$planedVisitDetailArray['visit_purpose']  = $visit_purpose;
    		$planedVisitDetailArray['distributor_id'] = $distributor_id;

    		$planedVisitDetailArray['parent_regional_manager'] = $res_psm['parent_regional_manager'];
    		$planedVisitDetailArray['parent_zonal_manager']    = $res_psm['parent_zonal_manager'];
    		$planedVisitDetailArray['parent_area_manager']     = $res_psm['parent_area_manager'];
    		$planedVisitDetailArray['parent_sale_person']      = $res_psm['parent_sale'];

    		if ($status == '0') {
    			$db->insert('tbl_visit_management', $planedVisitDetailArray);
    			$planScheduleId  = $db->lastInsertId();
    			$response_string = 'Plan scheduled Successfully.';
    		} else {
    			$db->update('tbl_visit_management', $planedVisitDetailArray, array(
    				'id=?' => $plan_id
    			));
    			$planScheduleId  = $plan_id;
    			$response_string = 'Planed schedule Data Updated Successfully.';
    		}

    		$db->commit();
    		$succes = TRUE;

    	}

    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();

    	}

    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => $response_string,
    			'plan_id' => $planScheduleId,
    			'server_id' => $planScheduleId
    		));
    		exit;

    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;

    	}
    }
    
    
    /**
     * getPlanedVisitDetailAction() method is used to get list of scheduled task for sale persons.
     * @return JSON 
     */
    
    public function getPlanedVisitDetailAction(){
        // Get the Request parameters
    	$params    = $this->getRequest()->getParams();
    	$db        = $this->db;
    	$appkey    = isset($params['appkey']) ? $params['appkey'] : "";
    	$LoginID   = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$device_id = isset($params['device_id']) ? $params['device_id'] : "";
    	$password = isset($params['Password']) ? $params['Password'] : "";
    	$LoginID   = strtoupper($LoginID);

    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();
    		if (!$LoginID) {
    			throw new Exception("Login id missing.");
    		}
    		if (!$device_id) {
    			throw new Exception("Device id missing.");
    		}
    		if (!Password) {
    			throw new Exception("Password missing.");
    		}
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($LoginID, $password);

    		if (!empty($alldata['LoginID']) != strtoupper($LoginID)) {
    			throw new Exception('Invalid login id.');
    		}

    		if (!empty($alldata['DeviceID'])) {
    			if ($alldata['DeviceID'] != $device_id) {
    				$error_code = 3;
    				throw new Exception('You are not athorized for this device.');
    			}
    		}

    		if ($appkey != $alldata['Device_token']) {
    			throw new Exception("Invalid appkey.");
    		}
    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 3;
    			throw new Exception('Your account is not active.');
    		}

    		if ($alldata['App_Access_Status'] == 2) {
    			$error_code = 2;
    			throw new Exception('This account deactivated by admin.');
    		}

    		$sql    = "select tvm.id as server_id, tvm.schedule_date, tvm.schedule_time, tvm.visit_purpose, tvm.remark, ur.StaffName as retailer, ua.StaffName as ait  from tbl_visit_management as tvm left join logi_user as ur on (ur.id = tvm.retailer_id) left join logi_user as ua on (ua.id = tvm.sale_person_id) where tvm.sale_person_id  = '" . $alldata['userId'] . "' order by tvm.id desc";
    		$result = $db->fetchAll($sql);

    		$db->commit();
    		$succes = TRUE;

    	}
    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();

    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'Planed visit detail listed successfully.',
    			'list' => $result
    		));
    		exit;

    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;

    	}
    }

    /**
     * saveActivityNotificationAction() method is used to save activity  for sales persons.
     * @return JSON 
     */
    
    public function saveActivityNotificationAction(){
        // Get the Request parameters
    	$params                 = $this->getRequest()->getParams();
    	$db                     = $this->db;
    	$appkey                 = isset($params['appkey']) ? $params['appkey'] : "";
    	$LoginID                = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$device_id              = isset($params['device_id']) ? $params['device_id'] : "";
    	$retailer_id            = isset($params['retailer_id']) ? $params['retailer_id'] : "";
    	$notification_date_time = isset($params['notification_date_time']) ? $params['notification_date_time'] : "";
    	$latitude               = isset($params['latitude']) ? $params['latitude'] : "";
    	$longitude              = isset($params['longitude']) ? $params['longitude'] : "";
    	$distributor_id         = isset($params['distributor_id']) ? $params['distributor_id'] : "";
    	$notification_type      = isset($params['notification_type']) ? $params['notification_type'] : "";
    	$LoginID                = strtoupper($LoginID);

    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();
    		if (!$LoginID || !$device_id || !$latitude || !$longitude) {
    			throw new Exception("Required parameter missing.");
    		}

    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId(strtoupper($LoginID));
    		if (!empty($alldata['LoginID']) != strtoupper($LoginID)) {
    			throw new Exception('Invalid login id.');
    		}

    		if (!empty($alldata['DeviceID'])) {
    			if ($alldata['DeviceID'] != $device_id) {
    				$error_code = 3;
    				throw new Exception('You are not athorized for this device.');
    			}
    		}

    		if ($appkey != $alldata['Device_token']) {
    			throw new Exception("Invalid appkey.");
    		}

    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 3;
    			throw new Exception('Your account is not active.');
    		}

    		if ($alldata['App_Access_Status'] == 2) {
    			$error_code = 2;
    			throw new Exception('This account deactivated by admin.');
    		}

    		$sql_get_retailer = "select * from logi_user where id = '" . $retailer_id . "'";
    		$res_retailer     = $db->fetchRow($sql_get_retailer);

    		$notificationArray                = array();
    		$notificationArray['app_user_id'] = $alldata['userId'];

    		$notificationArray['loginid']                = $LoginID;
    		$notificationArray['notification_date_time'] = $notification_date_time;
    		$notificationArray['latitude']               = $latitude;
    		$notificationArray['longitude']              = $latitude;
    		$notificationArray['notification_type']      = $notification_type;

    		$notificationArray['parent_regional_manager'] = $res_retailer['parent_regional_manager'];
    		$notificationArray['parent_zonal_manager']    = $res_retailer['parent_zonal_manager'];
    		$notificationArray['parent_area_manager']     = $res_retailer['parent_area_manager'];
    		$notificationArray['parent_sale_person']      = $res_retailer['parent_sale'];
    		$notificationArray['distributor_id']          = $res_retailer['parent_distributer'];
    		$notificationArray['retailer_id']             = $retailer_id;

    		$db->insert('logi_notification', $notificationArray);
    		$serverId = $db->lastInsertId();

    		if ($notification_type == '0') {
    			$msg = "Reach at site successfully";
    		} else {
    			$msg = "Left site successfully";
    		}

    		$db->commit();
    		$succes = TRUE;

    	}

    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();

    	}

    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => $msg,
    			'serverId' => $serverId,
    			'server_id' => $serverId
    		));
    		exit;

    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;

    	}
    }
    
    function dateConverter($var){
    	$date       = explode('/', $var);
    	$final_date = $date['2'] . '-' . $date['1'] . '-' . $date['0'];
    	return $final_date;
    }
    
    
    /**
     * getUserListAction() method is used to get list of sales persons .
     * @return JSON 
     */
    
    public function getUserListAction(){
        // Get the Request parameters
    	$params    = $this->getRequest()->getParams();
    	$db        = $this->db;
    	$appkey    = isset($params['appkey']) ? $params['appkey'] : "";
    	$LoginID   = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$password  = isset($params['Password']) ? $params['Password'] : "";
    	$LoginID   = strtoupper($LoginID);

    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();
    		if (!$appkey) {
    			throw new Exception("Token missing.");
    		}
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByAppToken($appkey);

    		if ($appkey != $alldata['Device_token']) {
    			throw new Exception("Invalid appkey.");
    		}

    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 3;
    			throw new Exception('Your account is not active.');
    		}

    		if ($alldata['App_Access_Status'] == 2) {
    			$error_code = 2;
    			throw new Exception('This account deactivated by admin.');
    		}

    		$sql    = "select id, LoginID, StaffName from logi_user where LoginID != '" . $alldata['LoginID'] . "'  and Role = 'Sales' ";
    		$result = $db->fetchAll($sql);

    		$db->commit();
    		$succes = TRUE;
    	}

    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();

    	}

    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'Success.',
    			'list' => $result
    		));
    		exit;

    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;

    	}
    }


    /**
     * saveTaskAction() method is used to save task
     * @return JSON 
     * Created By : Puneet Mishra
     * Created At : 06 March 2018
     */
    
    public function saveTaskAction(){
    	$db          = $this->db;
        //$taskData = json_decode(file_get_contents('php://input'), true);
    	$taskData    = $params = $this->getRequest()->getParams();

    	$appkey      = isset($params['appkey']) ? $params['appkey'] : "";
    	$LoginID     = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$device_id   = isset($params['device_id']) ? $params['device_id'] : "";
    	$description = isset($taskData['description']) ? $taskData['description'] : "";
    	$assign_to   = isset($taskData['assign_to']) ? $taskData['assign_to'] : "";
    	$priority    = isset($taskData['priority']) ? $taskData['priority'] : "";
    	$start_date  = isset($taskData['start_date']) ? $taskData['start_date'] : "";
    	$reminder    = isset($taskData['reminder']) ? $taskData['reminder'] : "";
    	$due_date    = isset($taskData['due_date']) ? $taskData['due_date'] : "";
    	$password    = isset($taskData['Password']) ? $taskData['Password'] : "";

    	$succes = FALSE;
    	try {
    		$db->beginTransaction();
    		if (!$device_id || !$LoginID || !$appkey) {
    			$error_code = 400;
    			throw new Exception("Required parameter missing.");
    		}

    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId(strtoupper($LoginID),$password);

    		if ($alldata['DeviceID'] != $device_id) {
    			$error_code = 407;
    			throw new Exception('You are not authorized for this device.');
    		}

    		if (strtolower($alldata['StaffStatus']) != ac) {
    			$error_code = 407;
    			throw new Exception('This account deactivated by admin.');
    		}

    		$sql_task_last_id    = "select id from tbl_task order by id desc limit 1";
    		$result_task_last_id = $db->fetchRow($sql_task_last_id);
    		$task                = 'TASK00' . ($result_task_last_id['id'] + 1);

    		$sql_get_psm = "select * from logi_user where LoginID = '" . $LoginID . "'";
    		$res_psm     = $db->fetchRow($sql_get_psm);

    		$taskArray                            = array();
    		$taskArray['task_id']                 = $task;
    		$taskArray['description']             = $description;
    		$taskArray['assign_to']               = $assign_to;
    		$taskArray['due_date']                = $due_date;
    		$taskArray['start_date']              = $start_date;
    		$taskArray['reminder']                = $reminder;
    		$taskArray['priority']                = $priority;
    		$taskArray['created']                 = date('Y-m-d h:i:s');
    		$taskArray['created_by']              = $alldata['userId'];
    		$taskArray['parent_regional_manager'] = $res_psm['parent_regional_manager'];
    		$taskArray['parent_zonal_manager']    = $res_psm['parent_zonal_manager'];
    		$taskArray['parent_area_manager']     = $res_psm['parent_area_manager'];
    		$taskArray['parent_sale_person']      = $res_psm['id'];
    		$taskArray['creation_interface']      = 'app';
    		$taskArray['role']                    = $res_psm['Role'];
    		$this->db->insert('tbl_task', $taskArray);
    		$taskId = $db->lastInsertId();

            //First Attachment Array                   
    		if (isset($_FILES['attachment']['tmp_name']) AND !empty($_FILES['attachment']['tmp_name'])) {
    			$tempName  = $_FILES['attachment']['tmp_name'];
    			$type      = explode('.', $_FILES['attachment']['name']);
    			$imageName = $task . '1-' . time() . '.' . $type[1];
    			$uploads   = 'uploads/task/';
    			if (!file_exists($uploads)) {
    				mkdir($uploads);
    			}
    			$pathComplete = $uploads . $imageName;
    			@move_uploaded_file($tempName, $pathComplete);

    			$taskAttachmentData               = array();
    			$taskAttachmentData['attachment'] = $imageName;
    			$taskAttachmentData['created']    = date('Y-m-d h:i:s');
    			$taskAttachmentData['task_id']    = $taskId;
    			$this->db->insert('tbl_task_attachment', $taskAttachmentData);
    		}

    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
    		$error = $e->getMessage();
    	}

    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '200',
    			'response_string' => 'Success.',
    			'server_generated_id' => $taskId,
    			'task_id' => $task,
    			'attachment' => $_FILES['attachment']
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }


    /**
     * getTaskListAction() method is used to get all Task List 
     * @return JSON 
     * Created By : Puneet Mishra
     * Created At : 07 March 2018
     */
    
    public function getTaskListAction(){
    	$db         = $this->db;
    	$params     = $this->getRequest()->getParams();
    	$appkey     = isset($params['appkey']) ? $params['appkey'] : "";
    	$LoginID    = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$device_id  = isset($params['device_id']) ? $params['device_id'] : "";
    	$password   = isset($params['Password']) ? $params['Password'] : "";

    	$succes     = FALSE;
    	try {
    		$db->beginTransaction();
    		if (!$LoginID || !$device_id || !$appkey) {
    			throw new Exception("Required parameter missing.");
    		}

    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId(strtoupper($LoginID),$password);

    		if (!empty($alldata['LoginID']) != strtoupper($LoginID)) {
    			throw new Exception('Invalid login id.');
    		}

    		if (!empty($alldata['DeviceID'])) {
    			if ($alldata['DeviceID'] != $device_id) {
    				$error_code = 3;
    				throw new Exception('You are not athorized for this device.');
    			}
    		}

    		if ($appkey != $alldata['Device_token']) {
    			throw new Exception("Invalid appkey.");
    		}

    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 3;
    			throw new Exception('Your account is not active.');
    		}

    		if ($alldata['App_Access_Status'] == 2) {
    			$error_code = 2;
    			throw new Exception('This account deactivated by admin.');
    		}
            //Get tasks list
    		$sql_task_assigned_me    = "select t.*, u.StaffName as user, us.StaffName as created  from tbl_task as t left join logi_user as u on (t.assign_to = u.id) left join logi_user as us on (t.created_by = us.id) WHERE t.assign_to='" . $alldata['userId'] . "'  order by t.id desc";
    		$result_task_assigned_me = $db->fetchAll($sql_task_assigned_me);

    		$sql_task_assigned_to_other    = "select t.*, u.StaffName as user, us.StaffName as created  from tbl_task as t left join logi_user as u on (t.assign_to = u.id) left join logi_user as us on (t.created_by = us.id) WHERE t.created_by='" . $alldata['userId'] . "'  order by t.id desc";
    		$result_task_assigned_to_other = $db->fetchAll($sql_task_assigned_to_other);

    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
    		$error = $e->getMessage();
    	}

    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code"                      => '200',
    			'response_string'                 => 'success.',
    			'get_task_list_assigned_to_me'    => $result_task_assigned_me,
    			'get_task_list_assigned_to_other' => $result_task_assigned_to_other
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }


    public function saveFeedbackAction(){
        // Get the Request parameters
    	$params         = $this->getRequest()->getParams();
    	$secretkey      = $this->secretkey;
    	$db             = $this->db;
        // Genaral Information of the user login details
    	$appkey         = isset($params['appkey']) ? $params['appkey'] : "";
    	$loginId        = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$device_id      = isset($params['device_id']) ? $params['device_id'] : "";
    	$issues         = isset($params['issues']) ? $params['issues'] : "";
    	$remark         = isset($params['remark']) ? $params['remark'] : "";
    	$resolution     = isset($params['resolution']) ? $params['resolution'] : "";
    	$retailer_id    = isset($params['retailer_id']) ? $params['retailer_id'] : "";
    	$distributor_id = isset($params['distributor_id']) ? $params['distributor_id'] : "";
    	$product_id     = isset($params['product_id']) ? $params['product_id'] : "";
    	$sub_product_id = isset($params['sub_product_id']) ? $params['sub_product_id'] : "";

    	$error_code = 1;
    	$succes     = FALSE;

    	try {

    		$db->beginTransaction();
    		if (!$loginId || !$appkey) {
    			throw new Exception("Required parameter missing.");
    		}
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($loginId);
            // echo '<pre>';
            // print_r($alldata);exit;
    		if ($appkey != $alldata['Device_token']) {
    			throw new Exception("Invalid appkey.");
    		}

    		if (!empty($alldata['LoginID']) != $loginId) {
    			$error_code = 3;
    			throw new Exception('Invalid login id.');
    		}

    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 5;
    			throw new Exception('Your account is not active.');
    		}
    		$retailer = new Application_Model_Retailer();

    		$sql_get_psm = "select * from logi_user where LoginID = '" . $loginId . "'";
    		$res_psm     = $db->fetchRow($sql_get_psm);

    		$data                  = array();
    		$data['login_id']      = $alldata['userId'];
    		$data['issues']        = $issues;
    		$data['remark']        = $remark;
    		$data['resolution']    = $resolution;
    		$data['product_id']    = $product_id;
    		$data['subproduct_id'] = $sub_product_id;
    		$data['status']        = '0';
    		$data['created_on']    = date('Y-m-d h:i:s');

    		$data['parent_regional_manager'] = $res_psm['parent_regional_manager'];
    		$data['parent_zonal_manager']    = $res_psm['parent_zonal_manager'];
    		$data['parent_area_manager']     = $res_psm['parent_area_manager'];
    		$data['parent_sale_person']      = $alldata['userId'];
    		$data['distributor_id']          = $distributor_id;
    		$data['retailer_id']             = $retailer_id;

    		$db->insert('tbl_feedback', $data);

    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
    		$db->rollBack();
    		$error = $e->getMessage();

    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'Feedback has been added successfully.'
    		));
    		exit;
    	}

    	else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}

    }

    public function changeTaskStatusAction(){
        // Get the Request parameters
    	$params    = $this->getRequest()->getParams();
    	$secretkey = $this->secretkey;
    	$db        = $this->db;
        // Genaral Information of the user login details
    	$appkey    = isset($params['appkey']) ? $params['appkey'] : "";
    	$loginId   = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$device_id = isset($params['device_id']) ? $params['device_id'] : "";
    	$task_id   = isset($params['task_id']) ? $params['task_id'] : "";
    	$status    = isset($params['status']) ? $params['status'] : "";
    	$password  = isset($params['Password']) ? $params['Password'] : "";

    	$error_code = 1;
    	$succes     = FALSE;

    	try { 

    		$db->beginTransaction();
    		if (!$loginId || !$appkey) {
    			throw new Exception("Required parameter missing.");
    		}
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($loginId, $password);

    		if ($appkey != $alldata['Device_token']) {
    			throw new Exception("Invalid appkey.");
    		}

    		if (!empty($alldata['LoginID']) != $loginId) {
    			$error_code = 3;
    			throw new Exception('Invalid login id.');
    		}

    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 5;
    			throw new Exception('Your account is not active.');
    		}
    		$retailer = new Application_Model_Retailer();

    		$data                = array();
    		$data['status']      = $status;
    		$data['approved_by'] = $alldata['userId'];

    		$db->update('tbl_task', $data, array(
    			'task_id=?' => $task_id
    		));

    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
    		$db->rollBack();
    		$error = $e->getMessage();

    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'Status has been Changed successfully.'
    		));
    		exit;
    	}

    	else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }

    /**
     * getProductCatalogue() method is used to get all product catalogue
     * @param NULL
     * @return JSON 
     */
    
    public function getProductCatalogueAction(){
        // Get the Request parameters
    	$params      = $this->getRequest()->getParams();
    	$db          = $this->db;
        // Genaral Information of the user login details
    	$appkey      = isset($params['appkey']) ? $params['appkey'] : "";
    	$LoginID     = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$device_id   = isset($params['device_id']) ? $params['device_id'] : "";
    	$device_type = isset($params['device_type']) ? $params['device_type'] : "";
    	$password    = isset($params['Password']) ? $params['Password'] : "";
    	$error_code  = 1;
    	$succes      = FALSE;

    	try {
    		$db->beginTransaction();
    		if (!$LoginID || !$device_id) {
    			throw new Exception("Required parameter missing.");
    		}

    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($LoginID, $password);
    		$count   = count($alldata);
    		if (!empty($alldata['LoginID']) != $LoginID) {
    			throw new Exception('Invalid user.');

    		}
    		if ($alldata['Device_token'] != $appkey) {
    			throw new Exception("Invalid request.");
    		}

    		if (!empty($alldata['device_id'])) {
    			if ($alldata['device_id'] != $device_id) {
    				$error_code = 3;
    				throw new Exception('You are not authorized for this device.');
    			}
    		}
    		if (strtoupper($alldata['StaffStatus']) != 'AC') {
    			throw new Exception('Your account is not active.');
    		}

    		$get_catalogue_detail = $this->getCatalogueDetail($alldata['userId'], $alldata['Role']);

    		$db->commit();
    		$succes = TRUE;

    	}
    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}

    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'Product catalogue listed successfully',
    			'product_catalogue_list' => $get_catalogue_detail
    		));
    		exit;
    	}

    	else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }
    
    
    public function getCatalogueDetail($sale_person_id, $role){
    	$db          = $this->db;
    	$curr_date   = date('y-m-d');
    	$final_array = array();

    	if ($role == 'RM') {
    		$sql_distributor = "select id, LoginID, StaffName from logi_user where parent_regional_manager = '" . $sale_person_id . "' and Role = 'distributer'";
    	} else if ($role == 'ASM') {
    		$sql_distributor = "select id, LoginID, StaffName from logi_user where parent_area_manager = '" . $sale_person_id . "' and Role = 'distributer'";
    	} else if ($role == 'ZM') {
    		$sql_distributor = "select id, LoginID, StaffName from logi_user where parent_zonal_manager = '" . $sale_person_id . "' and Role = 'distributer'";
    	} else if ($role == 'Sales') {
    		$sql_distributor = "select id, LoginID, StaffName from logi_user where parent_sale = '" . $sale_person_id . "' and Role = 'distributer'";
    	}
    	$result_distributor = $db->fetchAll($sql_distributor);
    	if ($result_distributor) {
    		$array_distributor_list = array();
    		foreach ($result_distributor as $distributor_data) {
    			array_push($array_distributor_list, "'" . $distributor_data['LoginID'] . "'");
    		}
    		$distributor_list_str = implode(',', $array_distributor_list);

    		$query_mapped_product  = "select subproduct.rate, ldp.product_id, p.product_name, subproduct.id as sub_product_id, subproduct.sub_product_name, subproduct.product_image, subproduct.description from logi_distributer_products as ldp left join logi_product as p on (p.id = ldp.product_id) left join sub_product as subproduct on (ldp.sub_product_id = subproduct.id) where ldp.distributer_id in ($distributor_list_str) group by ldp.product_id, ldp.sub_product_id";
    		$result_mapped_product = $db->fetchAll($query_mapped_product);

    		$product_detail = array();
    		foreach ($result_mapped_product as $mapped_product_detail) {
    			$all_sql_scheme = "select spsm.*, r.route_name,  p.product_name, sp.sub_product_name from tbl_product_scheme as spsm  left join logi_product as p on (p.id = spsm.offered_product) left join sub_product as sp on (sp.id = spsm.offered_subproduct) left join tbl_route as r on (r.id = spsm.route) where  spsm.scheme_on_product = '" . $mapped_product_detail['product_id'] . "' and spsm.scheme_on_subproduct = '" . $mapped_product_detail['sub_product_id'] . "'";
    			$all_res_scheme = $db->fetchAll($all_sql_scheme);

    			$scheme_array = array();
    			foreach ($all_res_scheme as $data_all) {
    				$data_array = array(
    					'scheme_on_product' => $mapped_product_detail['product_id'],
    					'scheme_on_subproduct' => $mapped_product_detail['sub_product_id'],
    					'scheme_type' => $data_all['type'],
    					'scheme_server_id' => $data_all['id'],
    					'buy_qty' => $data_all['buy_qty'],
    					'offered_product' => $data_all['offered_product'],
    					'offered_subproduct' => $data_all['offered_subproduct'],
    					'off_price_percentage' => $data_all['off_price_percentage'],
    					'get_free_qty' => $data_all['get_free_qty']
    				);
    				array_push($scheme_array, $data_array);
    			}
    			$image = $this->siteurl . 'uploads/product_catalogue/'.$mapped_product_detail['product_image'];

    			$product_catalogue = array(
    				'product_id' => $mapped_product_detail['product_id'],
    				'product_name' => $mapped_product_detail['product_name'],
    				'sub_product_id' => $mapped_product_detail['sub_product_id'],
    				'sub_product_name' => $mapped_product_detail['sub_product_name'],
    				'catalogue_image' => $image,
    				'discreption' => $mapped_product_detail['description'],
    				'rate' => $mapped_product_detail['rate'],
    				'available_scheme' => $scheme_array
    			);
    			array_push($final_array, $product_catalogue);
    		}
    	}
    	return $final_array;
    }
    
    
    public function insertDailyVenStockAction(){
        // Get the Request parameters
    	$params     = $this->getRequest()->getParams();
    	$secretkey  = $this->secretkey;
    	$db         = $this->db;
        // Genaral Information of the user login details
    	$appkey     = isset($params['appkey']) ? $params['appkey'] : "";
    	$loginId    = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$device_id  = isset($params['device_id']) ? $params['device_id'] : "";
    	$product    = isset($params['product']) ? $params['product'] : "";
    	$subproduct = isset($params['subproduct']) ? $params['subproduct'] : "";
    	$qty        = isset($params['qty']) ? $params['qty'] : "";
    	$ven_no     = isset($params['ven_no']) ? $params['ven_no'] : "";
    	$remark     = isset($params['remark']) ? $params['remark'] : "";
    	$date_on    = isset($params['date_on']) ? $params['date_on'] : "";

    	$error_code = 1;
    	$succes     = FALSE;

    	try {

    		$db->beginTransaction();
    		if (!$loginId || !$appkey) {
    			throw new Exception("Required parameter missing.");
    		}
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($loginId);

            // echo '<pre>';
            // print_r($alldata);exit;

    		if ($appkey != $alldata['Device_token']) {
    			throw new Exception("Invalid appkey.");
    		}

    		if (!empty($alldata['LoginID']) != $loginId) {
    			$error_code = 3;
    			throw new Exception('Invalid login id.');
    		}

    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 5;
    			throw new Exception('Your account is not active.');
    		}
    		$retailer = new Application_Model_Retailer();

    		$data                = array();
    		$data['sale_person'] = $alldata['userId'];
    		$data['product']     = $product;
    		$data['subproduct']  = $subproduct;
    		$data['qty']         = $qty;
    		$data['ven_no']      = $ven_no;
    		$data['remark']      = $remark;
    		$data['date_on']     = $date_on;
    		$db->insert('tbl_daily_ven_stock_in', $data);
    		$server_generated_id = $db->lastInsertId();

    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
    		$db->rollBack();
    		$error = $e->getMessage();

    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'Product uploaded successfully.',
    			'server_generated_id' => $server_generated_id
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }
    
    
    public function saveVanDetailDataAction(){
        // Get the Request parameters
    	$params    = $this->getRequest()->getParams();
    	$secretkey = $this->secretkey;
    	$db        = $this->db;
        // Genaral Information of the user login details

    	$curr_date       = date('Y-m-d');
    	$appkey          = isset($params['appkey']) ? $params['appkey'] : "";
    	$loginId         = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$device_id       = isset($params['device_id']) ? $params['device_id'] : "";
    	$ven_description = isset($params['ven_description']) ? $params['ven_description'] : "";
    	$order_date      = isset($params['order_date']) ? $params['order_date'] : "";
    	$retailer_id     = isset($params['retailer_id']) ? $params['retailer_id'] : "";
    	$remark          = isset($params['remark']) ? $params['remark'] : "";
    	$amount_received = isset($params['amount_received']) ? $params['amount_received'] : "";
    	$total_amount    = isset($params['total_amount']) ? $params['total_amount'] : "";
    	$distributor_id  = isset($params['distributor_id']) ? $params['distributor_id'] : "";
    	$item            = isset($params['item']) ? $params['item'] : '';
    	$payment_type    = isset($params['payment_type']) ? $params['payment_type'] : "";
    	$curr_date       = isset($params['curr_date']) ? $params['curr_date'] : "";
    	$cheque_no       = isset($params['cheque_no']) ? $params['cheque_no'] : "";
    	$signature       = isset($params['signature']) ? $params['signature'] : "";
    	$trip_id         = isset($params['trip_id']) ? $params['trip_id'] : "";
    	$password        = isset($params['Password']) ? $params['Password'] : "";
    	$error_code      = 1;
    	$succes          = FALSE;

    	try {

    		$db->beginTransaction();
    		if (!$loginId || !$appkey) {
    			throw new Exception("Required parameter missing.");
    		}
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($loginId, $password);
            // echo '<pre>';
            // print_r($alldata);exit;
    		if ($appkey != $alldata['Device_token']) {
    			throw new Exception("Invalid appkey.");
    		}
    		if (!empty($alldata['LoginID']) != $loginId) {
    			$error_code = 3;
    			throw new Exception('Invalid login id.');
    		}
    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 5;
    			throw new Exception('Your account is not active.');
    		}
    		$item_detail = array(
    			'item' => $item
    		);

    		if (get_magic_quotes_gpc()) {
    			$item_detail = stripslashes($item_detail['item']);
    		} else {
    			$item_detail = $item_detail['item'];
    		}
    		$item_detail_data = json_decode($item_detail, true);

    		$binary = base64_decode($signature);
    		header('Content-Type: bitmap; charset=utf-8');
    		$filename = 'signature/' . time() . '.jpg';
    		$file     = fopen($filename, 'wb');
    		fwrite($file, $binary);
    		fclose($file);

    		$sql_retailer = "select * from logi_user where id ='" . $retailer_id . "'";
    		$res_ret      = $db->fetchRow($sql_retailer);

    		$data                            = array();
    		$data['total_amount']            = $total_amount;
    		$data['cheque_no']               = $cheque_no;
    		$data['amount_received']         = $amount_received;
    		$data['order_date']              = $curr_date;
    		$data['ven_description']         = $ven_description;
    		$data['remark']                  = $remark;
    		$data['attached_doc']            = $imageName;
    		$data['parent_regional_manager'] = $res_ret['parent_regional_manager'];
    		$data['parent_zonal_manager']    = $res_ret['parent_zonal_manager'];
    		$data['parent_area_manager']     = $res_ret['parent_area_manager'];
    		$data['parent_sale_person']      = $res_ret['parent_sale'];
    		$data['distributor_id']          = $res_ret['parent_distributer'];
    		$data['payment_mode']            = $payment_type;
    		$data['retailer_id']             = $retailer_id;
    		$data['attachment']              = $filename;
    		$data['user_login_id']           = $loginId;
    		$data['trip_id']                 = $trip_id;
    		$db->insert('tbl_ven_sale_description', $data);
    		$server_generated_id = $db->lastInsertId();

    		foreach ($item_detail_data as $value) {
    			$order_insert_item_data                            = array();
    			$order_insert_item_data['product_id']              = $value['product_id'];
    			$order_insert_item_data['sub_product_id']          = $value['sub_product_id'];
    			$order_insert_item_data['qty']                     = $value['qty'];
    			$order_insert_item_data['rate']                    = $value['rate'];
    			$order_insert_item_data['amount']                  = $value['amount'];
    			$order_insert_item_data['parent_regional_manager'] = $res_ret['parent_regional_manager'];
    			$order_insert_item_data['parent_zonal_manager']    = $res_ret['parent_zonal_manager'];
    			$order_insert_item_data['parent_area_manager']     = $res_ret['parent_area_manager'];
    			$order_insert_item_data['parent_sale_person']      = $res_ret['parent_sale'];
    			$order_insert_item_data['distributor_id']          = $res_ret['parent_distributer'];
    			$order_insert_item_data['retailer_id']             = $retailer_id;
    			$order_insert_item_data['description_id']          = $server_generated_id;
    			$db->insert('tbl_ven_sale_item_detail', $order_insert_item_data);

    			$curr_date                  = date('y-m-d');
    			$sql_get_product_allocation = "select remaining_qty from tbl_allocated_product_details where sale_person_id  = '" . $alldata['userId'] . "' and subproduct_id = '" . $value['sub_product_id'] . "' and date(created_at) = '" . $curr_date . "'";
    			$result_qty                 = $db->fetchRow($sql_get_product_allocation);
    			$remaining_qty              = $result_qty['remaining_qty'] - $value['qty'];

    			$sql_update_qty = "update tbl_allocated_product_details set remaining_qty  = '" . $remaining_qty . "' where sale_person_id  = '" . $alldata['userId'] . "' and subproduct_id = '" . $value['sub_product_id'] . "' and date(created_at) = '" . $curr_date . "'";
    			$db->query($sql_update_qty);
    		}
    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
    		$db->rollBack();
    		$error = $e->getMessage();

    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'Data uploaded successfully.',
    			'server_generated_id' => $server_generated_id
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }
    
    
    public function getExpenseListAction(){
        // Get the Request parameters
    	$params    = $this->getRequest()->getParams();
    	$secretkey = $this->secretkey;
    	$db        = $this->db;
        // Genaral Information of the user login details
    	$appkey    = isset($params['appkey']) ? $params['appkey'] : "";
    	$loginId   = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$device_id = isset($params['device_id']) ? $params['device_id'] : "";
    	$password  = isset($params['Password']) ? $params['Password'] : "";

    	$error_code = 1;
    	$succes     = FALSE;

    	try {

    		$db->beginTransaction();
    		if (!$loginId || !$appkey) {
    			throw new Exception("Required parameter missing.");
    		}
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($loginId, $password);

    		$id = $alldata['userId'];
            // echo '<pre>';
            // print_r($alldata);exit;
    		if ($appkey != $alldata['Device_token']) {
    			throw new Exception("Invalid appkey.");
    		}

    		if (!empty($alldata['LoginID']) != $loginId) {
    			$error_code = 3;
    			throw new Exception('Invalid login id.');
    		}

    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 5;
    			throw new Exception('Your account is not active.');
    		}

    		$sql_user = "select * from logi_user where LoginID ='" . $loginId . "'";
    		$res_user = $db->fetchRow($sql_user);

    		if ($res_user['Role'] == 'RM') {
    			$user_cond .= "and parent_regional_manager = '" . $id . "' ";
    		}
    		if ($res_user['Role'] == 'ZM') {
    			$user_cond .= "and parent_zonal_manager = '" . $id . "' ";
    		}
    		if ($res_user['Role'] == 'ASM') {
    			$user_cond .= "and parent_area_manager = '" . $id . "' ";
    		}
    		if ($res_user['Role'] == 'Sales') {
    			$user_cond .= "and parent_sale_person = '" . $id . "' ";
    		}
    		$final_array = array();
    		$sql         = "select * from tbl_expenses where LoginID  = '" . $loginId . "' $user_cond order by created_at";
    		$result      = $db->fetchAll($sql);

    		foreach ($result as $data) {
    			$attachment = $this->siteurl . $data['attachment'];
    			$data_array = array(
    				'invoiceType' => $data['invoiceType'],
    				'dateFrom' => $data['dateFrom'],
    				'dateTo' => $data['dateTo'],
    				'amount' => $data['amount'],
    				'remark' => $data['remark'],
    				'attachment' => $attachment
    			);
    			array_push($final_array, $data_array);
    		}
    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
    		$db->rollBack();
    		$error = $e->getMessage();

    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'Status has been Changed successfully.',
    			'expense_list' => $final_array
    		));
    		exit;
    	}

    	else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }
    
    
    public function saveAllocatedProductDetailAction(){
        // Get the Request parameters
    	$params    = $this->getRequest()->getParams();
    	$secretkey = $this->secretkey;
    	$db        = $this->db;
        //$params = array( 'item'=>'[{"amount":"220.0","product_id":"4","qty":"5","rate":"44","sub_product_id":"10"}]');
    	if (get_magic_quotes_gpc()) {
    		$item_detail = stripslashes($params['item']);
    	} else {
    		$item_detail = $params['item'];
    	}
    	$item_detail_data = json_decode($item_detail, true);
        // Genaral Information of the user login details
    	$appkey           = isset($params['appkey']) ? $params['appkey'] : "";
    	$LoginID          = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$Imei             = isset($params['device_id']) ? $params['device_id'] : "";
    	$allocated_to     = isset($params['allocated_to']) ? $params['allocated_to'] : "";
    	$allocated_date   = isset($params['allocated_date']) ? $params['allocated_date'] : "";
    	$distributor_id   = isset($params['distributor_id']) ? $params['distributor_id'] : "";
    	$remark           = isset($params['remark']) ? $params['remark'] : "Best";

    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();
    		if (!$Imei || !$LoginID) {
    			throw new Exception("Required parameter missing.");
    		}

    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($LoginID);

    		if (!empty($alldata['LoginID']) != $LoginID) {
    			throw new Exception('Invalid login id.');
    		}

    		if (!empty($alldata['device_id'])) {
    			if ($alldata['device_id'] != $Imei) {
    				$error_code = 3;
    				throw new Exception('You are not athorized for this device.');
    			}
    		}

    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 3;
    			throw new Exception('Your account is not active.');
    		}

    		if ($alldata['access_status'] == 2) {
    			$error_code = 2;
    			throw new Exception('This account deactivated by admin.');
    		}

    		$allocation_detail                   = array();
    		$allocation_detail['distributor_id'] = $distributor_id;
    		$allocation_detail['allocated_date'] = $allocated_date;
    		$allocation_detail['allocated_to']   = $allocated_to;
    		$allocation_detail['remark']         = $remark;
    		$allocation_detail['allocated_by']   = $alldata['userId'];
    		$db->insert('tbl_product_allocation', $allocation_detail);
    		$lastorderInsertId = $db->lastInsertId();

    		foreach ($item_detail_data as $value) {
    			$allocation_item_detail                  = array();
    			$allocation_item_detail['allocator_id']  = $lastorderInsertId;
    			$allocation_item_detail['product_id']    = $value['product_id'];
    			$allocation_item_detail['subproduct_id'] = $value['sub_product_id'];
    			$allocation_item_detail['qty']           = $value['qty'];
    			$db->insert('tbl_allocated_product_details', $allocation_item_detail);
    		}

    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'Products allocated successfully'
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }
    
    
    
    public function saveCollectionDetailAction(){
        // Get the Request parameters
    	$params    = $this->getRequest()->getParams();
    	$secretkey = $this->secretkey;
    	$db        = $this->db;

        // Genaral Information of the user login details
    	$appkey          = isset($params['appkey']) ? $params['appkey'] : "";
    	$LoginID         = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$Imei            = isset($params['device_id']) ? $params['device_id'] : "";
    	$distributor_id  = isset($params['distributor_id']) ? $params['distributor_id'] : "";
    	$retailer_id     = isset($params['retailer_id']) ? $params['retailer_id'] : "";
    	$payment_mode    = isset($params['payment_mode']) ? $params['payment_mode'] : "";
    	$cash_payment    = isset($params['cash_payment']) ? $params['cash_payment'] : "";
    	$collection_date = isset($params['collection_date']) ? $params['collection_date'] : "";
    	$cheque_number   = isset($params['cheque_no']) ? $params['cheque_no'] : "";

    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();
    		if (!$Imei || !$LoginID) {
    			throw new Exception("Required parameter missing.");
    		}

    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($LoginID);

    		if (!empty($alldata['LoginID']) != $LoginID) {
    			throw new Exception('Invalid login id.');
    		}
            //  if($alldata['Device_token'] != $appkey){                        
            //     throw new Exception("Invalid request.");
            // }
    		if (!empty($alldata['device_id'])) {
    			if ($alldata['device_id'] != $Imei) {
    				$error_code = 3;
    				throw new Exception('You are not authorized for this device.');
    			}
    		}

    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 3;
    			throw new Exception('Your account is not active.');
    		}

    		if ($alldata['access_status'] == 2) {
    			$error_code = 2;
    			throw new Exception('This account deactivated by admin.');
    		}


    		$order_insert_item_data = array();
    		if (isset($_FILES['attachment']['tmp_name']) AND !empty($_FILES['attachment']['tmp_name'])) {
    			$tempName  = $_FILES['attachment']['tmp_name'];
    			$imageName = time() . $_FILES['attachment']['name'];
    			$uploads   = 'uploads/collection_attachment/';
    			if (!file_exists($uploads)) {
    				mkdir($uploads);
    			}
    			$pathComplete = $uploads . $imageName;
    			@move_uploaded_file($tempName, $pathComplete);
    			$order_insert_item_data['attachment'] = $imageName;
    		}

    		if (isset($_FILES['photograph']['tmp_name']) AND !empty($_FILES['photograph']['tmp_name'])) {
    			$tempNameAttachedDoc = $_FILES['photograph']['tmp_name'];
    			$imageAttachedDoc    = time() . $_FILES['photograph']['name'];
    			$uploadsAttachedDoc  = 'uploads/collection_attachment/';
    			if (!file_exists($uploadsAttachedDoc)) {
    				mkdir($uploadsAttachedDoc);
    			}
    			$pathCompleteAttachedDoc = $uploadsAttachedDoc . $imageNameAttachedDoc;
    			@move_uploaded_file($tempNameAttachedDoc, $pathCompleteAttachedDoc);
    			$order_insert_item_data['photograph'] = $imageAttachedDoc;
    		}
    		$order_insert_item_data['cheque_number']   = $cheque_number;
    		$order_insert_item_data['distributor_id']  = $distributor_id;
    		$order_insert_item_data['retailer_id']     = $retailer_id;
    		$order_insert_item_data['payment_mode']    = $payment_mode;
    		$order_insert_item_data['amount']          = $cash_payment;
    		$order_insert_item_data['created_by']      = $alldata['userId'];
    		$order_insert_item_data['collection_date'] = $collection_date;

    		$db->insert('tbl_collection', $order_insert_item_data);

    		$sql_get_userdata = "select fire_base_id from logi_user where id = '" . $alldata['userId'] . "'";
    		$res_userdata     = $db->fetchRow($sql_get_userdata);

    		if ($alldata['Role'] == 'Sales') {
    			$message = $cash_payment . " amount received by " . $alldata['StaffName'];
    			$this->pushNotification($message, $res_userdata['parent_area_manager']);
    		}

    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'Success'
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }
    
    
    function pushNotification($message, $user_id){
        #API access key from Google API's Console
    	define('API_ACCESS_KEY', 'AAAA5F1syzg:APA91bE1zLVa56rlaeReQCsAErgp93YfMcLxNb37KqmkHNnjcNqXukqCAq32DmdyxaNlDTHuEBctjz9md-Rz0TkgnQtiMSMi4obYjLFSsXcu5P7Q8U2_C5vALlQUzkwLs8g91xuD7lVw');

    	$sql_get_fire_base_key = "select fire_base_id from logi_user where id = '" . $user_id . "'";
    	$fire_base_result      = $this->db->fetchRow($sql_get_fire_base_key);

    	$registrationIds = $fire_base_result['fire_base_id'];
        //json_encode(array('message'=>$activity_data['message'], 'api_type'=>$api_type))
    	$body            = $message;
    	$title           = 'Saathi';
        #prep the bundle
    	$msg             = array(
    		'body' => $body,
    		'title' => $title,
    		'icon' => 'myicon',
    		/*Default Icon*/
    		'sound' => 'mySound'
    		/*Default sound*/
    	);
    	$fields          = array(
    		'to' => $registrationIds,
    		'notification' => $msg
    	);


    	$headers = array(
    		'Authorization: key=' . API_ACCESS_KEY,
    		'Content-Type: application/json'
    	);
        #Send Reponse To FireBase Server    
    	$ch      = curl_init();
    	curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
    	curl_setopt($ch, CURLOPT_POST, true);
    	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
    	$result = curl_exec($ch);
    	curl_close($ch);
        #Echo Result Of FireBase Server
    	return $result;
    }
    
    
    
    public function getLeaveListAction(){
        // Get the Request parameters
    	$params    = $this->getRequest()->getParams();
    	$secretkey = $this->secretkey;
    	$db        = $this->db;
        // Genaral Information of the user login details
    	$appkey    = isset($params['appkey']) ? $params['appkey'] : "";
    	$user_id   = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$Imei      = isset($params['device_id']) ? $params['device_id'] : "";
    	$password      = isset($params['Password']) ? $params['Password'] : "";

    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();
            // if ($secretkey != $appkey) {
            //  throw new Exception("Invalid request.");
            // }

    		if (!$Imei || !$user_id) {
    			throw new Exception("Required parameter missing.");
    		}

    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($user_id, $password);

    		if (!empty($alldata['LoginID']) != $user_id) {
    			throw new Exception('Invalid login id.');
    		}
    		if (!empty($alldata['device_id'])) {
    			if ($alldata['device_id'] != $Imei) {
    				$error_code = 3;
    				throw new Exception('You are not athorized for this device.');
    			}
    		}
    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 3;
    			throw new Exception('Your account is not active.');
    		}
    		if ($alldata['access_status'] == 2) {
    			$error_code = 2;
    			throw new Exception('This account deactivated by admin.');
    		}

    		$sql_leave_list = "select l.leaveFrom, l.leaveTo, l.reason, l.leaveType as leave_id, l.remark, l.leaveStatus, l.approval_remark, l.shift , lt.leaveType as leave_name from tbl_leave as l left join leave_type as lt on (lt.leaveType_id = l.leaveType) where LoginID = '" . $user_id . "'";
    		$result         = $db->fetchAll($sql_leave_list);

    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'list of retailers',
    			'get_leave_list' => $result
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }


    public function modulePermission($role){
    	$db = $this->db;

    	$final_array      = array();
    	$sql_get_mapping9 = "select * from tbl_role_wise_module where role ='" . $role . "' and module = 'task_management'";
    	$result9          = $db->fetchRow($sql_get_mapping9);
    	$module_array9    = array(
    		'id' => $result9['id'],
    		'module' => $result9['module'],
    		'status' => $result9['status']
    	);
    	array_push($final_array, $module_array9);

    	$sql_get_mapping8 = "select * from tbl_role_wise_module where role ='" . $role . "' and module = 'collection'";
    	$result8          = $db->fetchRow($sql_get_mapping8);
    	$module_array8    = array(
    		'id' => $result8['id'],
    		'module' => $result8['module'],
    		'status' => $result8['status']
    	);
    	array_push($final_array, $module_array8);

    	$sql_get_mapping7 = "select * from tbl_role_wise_module where role ='" . $role . "' and module = 'leave_management'";
    	$result7          = $db->fetchRow($sql_get_mapping7);
    	$module_array7    = array(
    		'id' => $result7['id'],
    		'module' => $result7['module'],
    		'status' => $result7['status']
    	);
    	array_push($final_array, $module_array7);

    	$sql_get_mapping6 = "select * from tbl_role_wise_module where role ='" . $role . "' and module = 'visit_management'";
    	$result6          = $db->fetchRow($sql_get_mapping6);
    	$module_array6    = array(
    		'id' => $result6['id'],
    		'module' => $result6['module'],
    		'status' => $result6['status']
    	);
    	array_push($final_array, $module_array6);

    	$sql_get_mapping5 = "select * from tbl_role_wise_module where role ='" . $role . "' and module = 'expense_management'";
    	$result5          = $db->fetchRow($sql_get_mapping5);
    	$module_array5    = array(
    		'id' => $result5['id'],
    		'module' => $result5['module'],
    		'status' => $result5['status']
    	);
    	array_push($final_array, $module_array5);

    	$sql_get_mapping13 = "select * from tbl_role_wise_module where role ='" . $role . "' and module = 'van_sale_distribution'";
    	$result13          = $db->fetchRow($sql_get_mapping13);
    	$module_array13    = array(
    		'id' => $result13['id'],
    		'module' => $result13['module'],
    		'status' => $result13['status']
    	);
    	array_push($final_array, $module_array13);

    	$sql_get_mapping4 = "select * from tbl_role_wise_module where role ='" . $role . "' and module = 'product_allocation'";
    	$result4          = $db->fetchRow($sql_get_mapping4);
    	$module_array4    = array(
    		'id' => $result4['id'],
    		'module' => $result4['module'],
    		'status' => $result4['status']
    	);
    	array_push($final_array, $module_array4);

    	$sql_get_mapping3 = "select * from tbl_role_wise_module where role ='" . $role . "' and module = 'product_catalouge'";
    	$result3          = $db->fetchRow($sql_get_mapping3);
    	$module_array3    = array(
    		'id' => $result3['id'],
    		'module' => $result3['module'],
    		'status' => $result3['status']
    	);
    	array_push($final_array, $module_array3);

    	$sql_get_mapping2 = "select * from tbl_role_wise_module where role ='" . $role . "' and module = 'order_management'";
    	$result2          = $db->fetchRow($sql_get_mapping2);
    	$module_array2    = array(
    		'id' => $result2['id'],
    		'module' => $result2['module'],
    		'status' => $result2['status']
    	);
    	array_push($final_array, $module_array2);

    	$sql_get_mapping1 = "select * from tbl_role_wise_module where role ='" . $role . "' and module = 'retailer_management'";
    	$result1          = $db->fetchRow($sql_get_mapping1);
    	$module_array1    = array(
    		'id' => $result1['id'],
    		'module' => $result1['module'],
    		'status' => $result1['status']
    	);
    	array_push($final_array, $module_array1);

    	$sql_get_mapping10 = "select * from tbl_role_wise_module where role ='" . $role . "' and module = 'time_spent_at_outlet'";
    	$result10          = $db->fetchRow($sql_get_mapping10);
    	$module_array10    = array(
    		'id' => $result10['id'],
    		'module' => $result10['module'],
    		'status' => $result10['status']
    	);
    	array_push($final_array, $module_array10);

    	$sql_get_mapping11 = "select * from tbl_role_wise_module where role ='" . $role . "' and module = 'feedback'";
    	$result11          = $db->fetchRow($sql_get_mapping11);
    	$module_array11    = array(
    		'id' => $result11['id'],
    		'module' => $result11['module'],
    		'status' => $result11['status']
    	);
    	array_push($final_array, $module_array11);

    	$sql_get_mapping12 = "select * from tbl_role_wise_module where role ='" . $role . "' and module = 'help'";
    	$result12          = $db->fetchRow($sql_get_mapping12);
    	$module_array12    = array(
    		'id' => $result12['id'],
    		'module' => $result12['module'],
    		'status' => $result12['status']
    	);
    	array_push($final_array, $module_array12);

    	return $final_array;
    }

    public function getProductAllocationDataAction(){

        // Get the Request parameters
    	$params    = $this->getRequest()->getParams();
    	$secretkey = $this->secretkey;
    	$db        = $this->db;
        // Genaral Information of the user login details
    	$appkey    = isset($params['appkey']) ? $params['appkey'] : "";
    	$user_id   = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$Imei      = isset($params['device_id']) ? $params['device_id'] : "";
    	$curr_date = isset($params['curr_date']) ? $params['curr_date'] : "";
    	$password  = isset($params['Password']) ? $params['Password'] : "";

    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();

    		if (!$Imei || !$user_id  || !$password) {
    			throw new Exception("Required parameter missing.");
    		}

    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($user_id, $password);

    		if (!empty($alldata['LoginID']) != $user_id) {
    			throw new Exception('Invalid login id.');
    		}


    		if (!empty($alldata['device_id'])) {
    			if ($alldata['device_id'] != $Imei) {
    				$error_code = 3;
    				throw new Exception('You are not athorized for this device.');
    			}
    		}

    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 3;
    			throw new Exception('Your account is not active.');
    		}

    		if ($alldata['access_status'] == 2) {
    			$error_code = 2;
    			throw new Exception('This account deactivated by admin.');
    		}

    		$currdate = $curr_date;

    		$sql="select * from tbl_product_allocation where allocated_to = '".$alldata['userId']."' and   date(allocated_date) = '".$currdate."' and allocation_status = '1'";
    		$result_allocation = $db->fetchRow($sql);

    		$sql_van_sal            = "select subproduct.rate, order_items.remaining_qty as quantity, subproduct.gst_slab,subproduct.gst_rate, 
    		order_items.remaining_qty as alloc_quantity, 
    		order_items.product_id as product_id, 
    		order_items.subproduct_id as sub_product_id, 
    		product.product_name as product_name,    
    		subproduct.sub_product_name  as sub_product_name,
    		order_items.product_id as alloc_product_id,
    		order_items.subproduct_id as alloc_sub_product_id,
    		product.product_name as alloc_product_name,
    		subproduct.sub_product_name  as alloc_sub_product_name
    		from tbl_allocated_product_details as order_items left join logi_product as product on(order_items.product_id = product.id) LEFT JOIN  sub_product as subproduct ON (subproduct.id = order_items.subproduct_id)   where 1 and order_items.allocator_id = '" . $result_allocation['id'] . "'";
    		$result_allocation_item = $db->fetchAll($sql_van_sal);
    		$data                   = array(
    			'allocation_id' => $result_allocation['id'],
    			'warehouse_id' => $result_allocation['warehouse_id'],
    			'warehouse_name' => $result_allocation['warehouse_name'],
    			'warehouse_latitude' => $result_allocation['warehouse_latitude'],
    			'warehouse_longitude' => $result_allocation['warehouse_longitude'],
    			'remark' => $result_allocation['remark'],
    			'allocated_items' => $result_allocation_item,
    			'status' => '0'
    		);

    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'Listing successfull',
    			'get_allocated_items_detail' => $data
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }

    public function generateTicketAction(){
    	$response    = array();
        // Get the Request parameters
    	$params      = $this->getRequest()->getParams();
    	$secretkey   = $this->secretkey;
    	$db          = $this->db;
    	$appkey      = isset($params['appkey']) ? $params['appkey'] : "";
    	$user_id     = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$Imei        = isset($params['device_id']) ? $params['device_id'] : "";
    	$device_type = isset($params['device_type']) ? $params['device_type'] : "";


    	$issue_type  = isset($params['issuetype']) ? $params['issuetype'] : "";
    	$priority    = isset($params['priority']) ? $params['priority'] : "";
    	$description = isset($params['description']) ? $params['description'] : "";
    	$phoneNo     = isset($params['phone_no']) ? $params['phone_no'] : "";
    	$ticket_date = isset($params['ticket_date']) ? $params['ticket_date'] : "";
    	$subject     = isset($params['subject']) ? $params['subject'] : "";

    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($user_id);

    		if ($alldata['Device_token'] != $appkey) {
    			$response['flag']    = false;
    			$response['message'] = "Invalid Token";
    		} else if (!$Imei) {
    			$response['flag']    = false;
    			$response['message'] = "Imei not found";
    		} else if (!empty($alldata['LoginID']) != $user_id) {
    			$response['flag']    = false;
    			$response['message'] = "Invalid login id";
    		} else if (!empty($alldata['device_id'])) {
    			if ($alldata['device_id'] != $Imei) {
    				$response['flag']       = false;
    				$response['error_code'] = 3;
    				$response['message']    = "You are not athorized for this device.";
    			}
    		} else if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$response['flag']       = false;
    			$response['error_code'] = 3;
    			$response['message']    = "Your account is not active.";
    		} else if ($alldata['access_status'] == 2) {
    			$response['flag']       = false;
    			$response['error_code'] = 2;
    			$response['message']    = "This account deactivated by admin";
    		} else {
    			$ticketgenerate = array();
    			if (isset($_FILES['ticket_attachement']['tmp_name']) AND !empty($_FILES['ticket_attachement']['tmp_name'])) {
    				$tempName           = $_FILES['ticket_attachement']['tmp_name'];
    				$ticket_attachement = time() . $_FILES['ticket_attachement']['name'];
    				$uploads            = 'uploads/ticket_attachement/';
    				if (!file_exists($uploads)) {
    					mkdir($uploads);
    				}
    				$pathComplete = $uploads . $ticket_attachement;
    				@move_uploaded_file($tempName, $pathComplete);
    				$retailergeotagingdetail['ticket_attachement'] = $ticket_attachement;
    			}
    			$ticketgenerate                       = array();
    			$ticketgenerate['issue_type']         = $issue_type;
    			$ticketgenerate['priority']           = $priority;
    			$ticketgenerate['subject']            = $subject;
    			$ticketgenerate['description']        = $description;
    			$ticketgenerate['phone_no']           = $phoneNo;
    			$ticketgenerate['ticket_attachement'] = $ticket_attachement;
    			$ticketgenerate['user_id']            = $alldata['userId'];
    			$ticketgenerate['ticket_date']        = $ticket_date;
    			$db->insert('generate_ticket', $ticketgenerate);
    			$server_generated_id = $db->lastInsertId();

    			$db->commit();
    			$response['flag']                = true;
    			$response['message']             = "Ticket Generated Successfully";
    			$response['server_generated_id'] = $server_generated_id;

    		}
    	}
    	catch (Exception $e) {
    		$db->rollBack();
    		$response['flag']    = false;
    		$response['message'] = $e->getMessage();
    	}
    	echo json_encode($response);
    	exit;
    }

    public function getTicketAction(){
        // Get the Request parameters
    	$params    = $this->getRequest()->getParams();
    	$secretkey = $this->secretkey;
    	$db        = $this->db;
        // Genaral Information of the user login details
    	$appkey    = isset($params['appkey']) ? $params['appkey'] : "";
    	$user_id   = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$Imei      = isset($params['device_id']) ? $params['device_id'] : "";

    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();
            // if ($secretkey != $appkey) {
            //  throw new Exception("Invalid request.");
            // }

    		if (!$Imei || !$user_id) {
    			throw new Exception("Required parameter missing.");
    		}

    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($user_id);

    		if (!empty($alldata['LoginID']) != $user_id) {
    			throw new Exception('Invalid login id.');
    		}


    		if (!empty($alldata['device_id'])) {
    			if ($alldata['device_id'] != $Imei) {
    				$error_code = 3;
    				throw new Exception('You are not athorized for this device.');
    			}
    		}

    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 3;
    			throw new Exception('Your account is not active.');
    		}

    		if ($alldata['access_status'] == 2) {
    			$error_code = 2;
    			throw new Exception('This account deactivated by admin.');
    		}

    		$sql_ticket = "SELECT generate_ticket.id as ticket_id, logi_user.StaffName AS User,logi_user.LoginID as login_id,`issue_type`, `priority`, `subject`, `description`, `phone_no`, `ticket_attachement`, DATE(ticket_date) as date, `status`, `created_at` FROM `generate_ticket`
    		LEFT JOIN logi_user on (logi_user.id=generate_ticket.user_id) where generate_ticket.user_id ='" . $alldata['userId'] . "' order by generate_ticket.id desc limit 10";
    		$result     = $db->fetchAll($sql_ticket);

    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'list of ticket',
    			'get_ticket_list' => $result
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }

    public function updateTicketStatusAction(){
        // Get the Request parameters
    	$params    = $this->getRequest()->getParams();
    	$secretkey = $this->secretkey;
    	$db        = $this->db;
        // Genaral Information of the user login details
    	$appkey    = isset($params['appkey']) ? $params['appkey'] : "";
    	$user_id   = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$Imei      = isset($params['Imei_no']) ? $params['Imei_no'] : "";
    	$ticket_id = isset($params['ticket_id']) ? $params['ticket_id'] : "";
    	$status    = isset($params['status']) ? $params['status'] : "";

    	$error_code = 1;
    	$succes     = FALSE;

    	try {

    		$db->beginTransaction();

    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($user_id);
    		$count   = count($alldata);

    		if ($alldata['Device_token'] != $appkey) {
    			throw new Exception("Invalid request.");
    		}
    		if (!$user_id || !$Imei) {
    			throw new Exception("Required parameter missing.");
    		}


    		if (!empty($alldata['LoginID']) != $user_id) {
    			throw new Exception('Invalid user.');
    		}
    		if (!empty($alldata['device_id'])) {
    			if ($alldata['device_id'] != $Imei) {
    				$error_code = 3;
    				throw new Exception('You are not athorized for this device.');
    			}
    		}

    		if (strtoupper($alldata['StaffStatus']) != 'AC') {
    			throw new Exception('Your account is not active.');
    		}

    		$update           = array();
    		$update['status'] = $status;
    		$user->updateSingleTableData('generate_ticket', $update, 'id', $ticket_id);

    		$db->commit();
    		$succes = TRUE;
    	}

    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();

    	}

    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'Status has been successfully updated.'
    		));
    		exit;

    	}

    	else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}

    }
    /**
     * login() method is used to android user login
     * @param String
     * @return JSON 
     */
    public function loginVanSaleAction(){
        // Get the Request parameters
    	$params       = $this->getRequest()->getParams();
    	$secretkey    = $this->secretkey;
    	$db           = $this->db;
        // Genaral Information of the user login details
    	$LoginID      = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$Imei         = isset($params['device_id']) ? $params['device_id'] : "";
    	$device_type  = isset($params['device_type']) ? $params['device_type'] : "";
    	$lat          = isset($params['user_latitude']) ? $params['user_latitude'] : "";
    	$long         = isset($params['user_longitude']) ? $params['user_longitude'] : "";
    	$fire_base_id = isset($params['fcm_token']) ? $params['fcm_token'] : "";
    	$version      = isset($params['version']) ? $params['version'] : "";
    	$password     = isset($params['Password']) ? $params['Password'] : "";

    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();


    		if (!$LoginID || !$Imei) {
    			$error_code = 2;
    			throw new Exception("Required parameter missing.");
    		}

    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($LoginID, $password);

    		if (!empty($alldata['LoginID']) != $LoginID) {
    			$error_code = 3;
    			throw new Exception('Invalid login id.');
    		}

    		if (!empty($alldata['DeviceID'])) {
    			if ($alldata['DeviceID'] != $Imei) {
    				$error_code = 4;
    				throw new Exception('You are not authorized for this device.');
    			}
    		}

    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 5;
    			throw new Exception('Your account is not active.');
    		}

    		if ($alldata['access_status'] == 2) {
    			$error_code = 6;
    			throw new Exception('This account deactivated by admin.');
    		}

    		$address = $this->getAddress($lat, $long);

            //print_r($LoginID); exit();

    		$update                 = array();
    		$update['device_type']  = $device_type;
    		$update['device_token'] = $this->getSecretHashKey();
            $update['DeviceID']     = $Imei; // IMEI Code
            $update['gps_status']   = 'on';
            $update['lat']          = $lat; // IMEI Code
            $update['long']         = $long;
            $update['address']      = $address;
            $update['fire_base_id'] = $fire_base_id;
            if ($version) {
            	$update['app_version'] = $version;
            }
            $update['last_location_service_hit_time'] = $this->currdate;
            $user->updateSingleTableData('logi_user', $update, 'LoginID', $alldata['LoginID']);
            
            $user_login_data                        = array();
            $user_login_data['mob_user_staff_code'] = $LoginID;
            $user_login_data['login_time']          = $this->currdate;
            $user_login_data['server_detail']       = json_encode($_SERVER);
            $db->insert('logi_user_login_detail', $user_login_data);
            
            $getLoginUserDetail = $user->getUserDataByLoginId($LoginID, $password);
            
            $sync_time = '2';
            
            
            $sql_retailer_list = "select id, StaffName from logi_user where Role = 'retailer' order by id desc limit 20";
            $res_retailer      = $db->fetchAll($sql_retailer_list);
            
            $db->commit();
            $succes = TRUE;
        }
        catch (Exception $e) {
            //Rollback transaction
        	$db->rollBack();
        	$error = $e->getMessage();
        }
        if ($succes == TRUE) {
        	echo json_encode(array(
        		"error_code" => '0',
        		'response_string' => 'login success.',
        		'get_Login_User_Detail' => $getLoginUserDetail,
        		'sync_time' => $sync_time,
        		'retailer_list' => $res_retailer
        	));
        	exit;
        } else {
        	echo json_encode(array(
        		"error_code" => $error_code,
        		'response_string' => $error
        	));
        	exit;
        }
    }

    public function vanSaleTripAction(){
        // Get the Request parameters
    	$params         = $this->getRequest()->getParams();
    	$secretkey      = $this->secretkey;
    	$db             = $this->db;
        // Genaral Information of the user login details
    	$appkey         = isset($params['appkey']) ? $params['appkey'] : "";
    	$loginId        = isset($params['loginID']) ? $params['loginID'] : "";
    	$password       = isset($params['Password']) ? $params['Password'] : "";
    	$device_id      = isset($params['device_id']) ? $params['device_id'] : "";
    	$trip_status    = isset($params['trip_status']) ? $params['trip_status'] : "";
    	$latitude       = isset($params['latitude']) ? $params['latitude'] : "";
    	$longitude      = isset($params['longitude']) ? $params['longitude'] : "";
    	$trip_date      = isset($params['trip_date']) ? $params['trip_date'] : "";
    	$warehouse_id   = isset($params['warehouse_id']) ? $params['warehouse_id'] : "";
    	$allocation_id  = isset($params['allocation_id']) ? $params['allocation_id'] : "";
    	$item_remaining = isset($params['item_remaining']) ? $params['item_remaining'] : "";
    	$trip_id        = isset($params['trip_id']) ? $params['trip_id'] : "";

    	$error_code = 1;
    	$succes     = FALSE;

    	try {
            // echo "<pre>";print_r($loginId);exit;
    		$db->beginTransaction();
    		if (!$loginId || !$appkey) {
    			throw new Exception("Required parameter missing.");
    		}
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($loginId,$password);
            // echo '<pre>';
            // print_r($alldata);exit;
    		if ($appkey != $alldata['Device_token']) {
    			throw new Exception("Invalid appkey.");
    		}

    		if (!empty($alldata['LoginID']) != $loginId) {
    			$error_code = 3;
    			throw new Exception('Invalid login id.');
    		}

    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 5;
    			throw new Exception('Your account is not active.');
    		}

    		$retailer = new Application_Model_Retailer();

    		$data                         = array();
    		$data['user_id']              = $alldata['userId'];
    		$data['warehouse_id']         = $warehouse_id;
    		$data['trip_start_latitude']  = $latitude;
    		$data['trip_start_longitude'] = $longitude;
    		$data['trip_date']            = $trip_date;
    		$data['trip_status']          = $trip_status;
    		$data['allocation_id']        = $allocation_id;
    		$data['trip_id']              = $trip_id;
    		$db->insert('tbl_trip_detail', $data);
    		$server_generated_id = $db->lastInsertId();

    		if($trip_status=='1'){
    			$update_trip_id = array();
    			$update_trip_id['trip_id'] = $server_generated_id;
    			$db->update('tbl_trip_detail', $update_trip_id, array(
    				'id=?' => $server_generated_id
    			));
    		}    
    		if ($trip_status == '2') {
    			$remaining_item                = array();
    			$remaining_item['trip_id']     = $server_generated_id;
    			$remaining_item['item_detail'] = $item_remaining;
    			$remaining_item['trip_id']     = $trip_id;
    			$db->insert('trip_remaining_product_detail', $remaining_item);
    		}
    		if ($trip_status == '1') {
    			$server_trip_id = $server_generated_id;
    			$trip_msg = 'Trip start successfully';
    		} else {
    			$server_trip_id = $trip_id;
    			$trip_msg = 'Trip end successfully';
    		}
    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
    		$db->rollBack();
    		$error = $e->getMessage();

    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => $trip_msg,
    			'server_generated_trip_id' => $server_trip_id
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }

    public function trackTripAction(){
        // Get the Request parameters
    	$params             = $this->getRequest()->getParams();
    	$secretkey          = $this->secretkey;
    	$db                 = $this->db;
        // Genaral Information of the user login details
    	$appkey             = isset($params['appkey']) ? $params['appkey'] : "";
    	$loginId            = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$device_id          = isset($params['device_id']) ? $params['device_id'] : "";
    	$travelled_distance = isset($params['travelled_distance']) ? $params['travelled_distance'] : "";
    	$latitude           = isset($params['latitude']) ? $params['latitude'] : "";
    	$longitude          = isset($params['longitude']) ? $params['longitude'] : "";
    	$trip_date          = isset($params['trip_date']) ? $params['trip_date'] : "";
    	$warehouse_id       = isset($params['warehouse_id']) ? $params['warehouse_id'] : "";
    	$trip_id            = isset($params['trip_id']) ? $params['trip_id'] : "";
    	$allocation_id      = isset($params['allocation_id']) ? $params['allocation_id'] : "";

    	$error_code = 1;
    	$succes     = FALSE;

    	try {

    		$db->beginTransaction();
    		if (!$loginId || !$appkey) {
    			throw new Exception("Required parameter missing.");
    		}
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($loginId);

            // echo '<pre>';
            // print_r($alldata);exit;

    		if ($appkey != $alldata['Device_token']) {
    			throw new Exception("Invalid appkey.");
    		}

    		if (!empty($alldata['LoginID']) != $loginId) {
    			$error_code = 3;
    			throw new Exception('Invalid login id.');
    		}

    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 5;
    			throw new Exception('Your account is not active.');
    		}
    		$retailer = new Application_Model_Retailer();

    		$data                         = array();
    		$data['user_id']              = $alldata['userId'];
    		$data['trip_id']              = $trip_id;
    		$data['warehouse_id']         = $warehouse_id;
    		$data['trip_start_latitude']  = $latitude;
    		$data['trip_start_longitude'] = $longitude;
    		$data['trip_date']            = $trip_date;
    		$data['travelled_distance']   = $travelled_distance;
    		$data['allocation_id']        = $allocation_id;
    		$db->insert('tbl_track_trip', $data);
    		$server_generated_id = $db->lastInsertId();

    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
    		$db->rollBack();
    		$error = $e->getMessage();

    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'Track successful',
    			'server_generated_track_id' => $server_generated_id
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }

    public function getGeneratedLeaveAction(){
        // Get the Request parameters
    	$params    = $this->getRequest()->getParams();
    	$secretkey = $this->secretkey;
    	$db        = $this->db;
        // Genaral Information of the user login details
    	$appkey    = isset($params['appkey']) ? $params['appkey'] : "";
    	$user_id   = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$Imei      = isset($params['device_id']) ? $params['device_id'] : "";

    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();
            // if ($secretkey != $appkey) {
            //  throw new Exception("Invalid request.");
            // }
    		if (!$Imei || !$user_id) {
    			throw new Exception("Required parameter missing.");
    		}
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($user_id);

    		if (!empty($alldata['LoginID']) != $user_id) {
    			throw new Exception('Invalid login id.');
    		}
    		if (!empty($alldata['device_id'])) {
    			if ($alldata['device_id'] != $Imei) {
    				$error_code = 3;
    				throw new Exception('You are not athorized for this device.');
    			}
    		}
    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 3;
    			throw new Exception('Your account is not active.');
    		}
    		if ($alldata['access_status'] == 2) {
    			$error_code = 2;
    			throw new Exception('This account deactivated by admin.');
    		}
    		$sql    = "SELECT * from tbl_leave order by leave_id desc limit 10";
    		$result = $db->fetchAll($sql);

    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'list of leave',
    			'list' => $result
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }

    public function approveLeaveAction(){
        // Get the Request parameters
    	$params        = $this->getRequest()->getParams();
    	$secretkey     = $this->secretkey;
    	$db            = $this->db;
        // Genaral Information of the user login details
    	$appkey        = isset($params['appkey']) ?        $params['appkey'] : "";
    	$user_id       = isset($params['LoginID']) ?       $params['LoginID'] : "";
    	$Imei          = isset($params['device_id']) ?     $params['device_id'] : "";
    	$status        = isset($params['leave_status']) ?  $params['leave_status'] : "";
    	$remark        = isset($params['remark']) ?        $params['remark'] : "";
    	$user_login_id = isset($params['user_login_id']) ? $params['user_login_id'] : "";
    	$leave_id      = isset($params['leave_id']) ?      $params['leave_id'] : "";

    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();

    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($user_id);
    		$count   = count($alldata);

    		if ($alldata['Device_token'] != $appkey) {
    			throw new Exception("Invalid request.");
    		}
    		if (!$user_id || !$Imei || !$leave_id) {
    			throw new Exception("Required parameter missing.");
    		}

    		if (!empty($alldata['LoginID']) != $user_id) {
    			throw new Exception('Invalid user.');
    		}
    		if (!empty($alldata['device_id'])) {
    			if ($alldata['device_id'] != $Imei) {
    				$error_code = 3;
    				throw new Exception('You are not athorized for this device.');
    			}
    		}

    		if (strtoupper($alldata['StaffStatus']) != 'AC') {
    			throw new Exception('Your account is not active.');
    		}

    		$update                    = array();
    		$update['leaveStatus']     = $status;
    		$update['approval_remark'] = $remark;

    		$db->update('tbl_leave', $update, array(
    			'leave_id=?' => $leave_id
    		));
    		$db->commit();
    		$succes = TRUE;
    	}

    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();

    	}

    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'Status has been successfully updated.'
    		));
    		exit;
    	}

    	else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}

    }

    public function getGeneratedExpenseAction(){
        // Get the Request parameters
    	$params    = $this->getRequest()->getParams();
    	$secretkey = $this->secretkey;
    	$db        = $this->db;
        // Genaral Information of the user login details
    	$appkey    = isset($params['appkey']) ? $params['appkey'] : "";
    	$user_id   = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$Imei      = isset($params['device_id']) ? $params['device_id'] : "";

    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();
            // if ($secretkey != $appkey) {
            //  throw new Exception("Invalid request.");
            // }
    		if (!$Imei || !$user_id) {
    			throw new Exception("Required parameter missing.");
    		}
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($user_id);

    		if (!empty($alldata['LoginID']) != $user_id) {
    			throw new Exception('Invalid login id.');
    		}
    		if (!empty($alldata['device_id'])) {
    			if ($alldata['device_id'] != $Imei) {
    				$error_code = 3;
    				throw new Exception('You are not athorized for this device.');
    			}
    		}
    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 3;
    			throw new Exception('Your account is not active.');
    		}
    		if ($alldata['access_status'] == 2) {
    			$error_code = 2;
    			throw new Exception('This account deactivated by admin.');
    		}
    		$sql    = "SELECT tbl_expenses.status, tbl_expenses.expense_id, logi_user.StaffName, tbl_expenses.dateFrom, tbl_expenses.dateTo, tbl_expenses.invoiceType, tbl_expenses.amount, tbl_expenses.remark, tbl_expenses.approval_remark, tbl_expenses.attachment from tbl_expenses left join logi_user on (logi_user.LoginID = tbl_expenses.LoginID) order by expense_id desc limit 10";
    		$result = $db->fetchAll($sql);

    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'list of expense',
    			'list' => $result
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }


    public function approveExpenseAction(){
        // Get the Request parameters
    	$params     = $this->getRequest()->getParams();
    	$secretkey  = $this->secretkey;
    	$db         = $this->db;
        // Genaral Information of the user login details
    	$appkey     = isset($params['appkey']) ? $params['appkey'] : "";
    	$user_id    = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$Imei       = isset($params['device_id']) ? $params['device_id'] : "";
    	$status     = isset($params['expense_status']) ? $params['expense_status'] : "";
    	$remark     = isset($params['remark']) ? $params['remark'] : "";
    	$expense_id = isset($params['expense_id']) ? $params['expense_id'] : "";

    	$error_code = 1;
    	$succes     = FALSE;

    	try {

    		$db->beginTransaction();

    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($user_id);
    		$count   = count($alldata);

    		if ($alldata['Device_token'] != $appkey) {
    			throw new Exception("Invalid request.");
    		}
    		if (!$user_id || !$Imei) {
    			throw new Exception("Required parameter missing.");
    		}
    		if (!empty($alldata['LoginID']) != $user_id) {
    			throw new Exception('Invalid user.');
    		}
    		if (!empty($alldata['device_id'])) {
    			if ($alldata['device_id'] != $Imei) {
    				$error_code = 3;
    				throw new Exception('You are not athorized for this device.');
    			}
    		}

    		if (strtoupper($alldata['StaffStatus']) != 'AC') {
    			throw new Exception('Your account is not active.');
    		}

    		$update                    = array();
    		$update['status']          = $status;
    		$update['approval_remark'] = $remark;
    		$user->updateSingleTableData('tbl_expenses', $update, 'expense_id', $expense_id);

    		$db->commit();
    		$succes = TRUE;
    	}

    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();

    	}

    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'Status has been successfully updated.'
    		));
    		exit;

    	}

    	else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }



    public function saveProductReturnDataAction(){
        // Get the Request parameters
    	$params    = $this->getRequest()->getParams();
    	$secretkey = $this->secretkey;
    	$db        = $this->db;
        // Genaral Information of the user login details

    	$curr_date     = date('Y-m-d');
    	$appkey        = isset($params['appkey']) ? $params['appkey'] : "";
    	$loginId       = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$device_id     = isset($params['device_id']) ? $params['device_id'] : "";
    	$return_type   = isset($params['return_type']) ? $params['return_type'] : "";
    	$delivery_date = isset($params['delivery_date']) ? $params['delivery_date'] : "";
    	$retailer_id   = isset($params['retailer_id']) ? $params['retailer_id'] : "";
    	$item_detail   = isset($params['item_detail']) ? $params['item_detail'] : "";
    	$remark        = isset($params['remark']) ? $params['remark'] : "";
    	$signature     = isset($params['signature']) ? $params['signature'] : "";
    	$error_code    = 1;
    	$succes        = FALSE;

    	try {
    		$db->beginTransaction();
    		if (!$loginId || !$appkey) {
    			throw new Exception("Required parameter missing.");
    		}
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($loginId);
            // echo '<pre>';
            // print_r($alldata);exit;
    		if ($appkey != $alldata['Device_token']) {
    			throw new Exception("Invalid appkey.");
    		}
    		if (!empty($alldata['LoginID']) != $loginId) {
    			$error_code = 3;
    			throw new Exception('Invalid login id.');
    		}
    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 5;
    			throw new Exception('Your account is not active.');
    		}


            // $item_detail = array(
            //     'item' => $item
            // );

            // if (get_magic_quotes_gpc()) {
            //     $item_detail = stripslashes($item_detail['item']);
            // } else {
            //     $item_detail = $item_detail['item'];
            // }
            // $item_detail_data = json_decode($item_detail, true);

    		$binary = base64_decode($signature);
    		header('Content-Type: bitmap; charset=utf-8');
    		$filename = 'signature/' . time() . '.jpg';
    		$file     = fopen($filename, 'wb');
    		fwrite($file, $binary);
    		fclose($file);

    		$sql_retailer = "select * from logi_user where id ='" . $retailer_id . "'";
    		$res_ret      = $db->fetchRow($sql_retailer);

    		$data                  = array();
    		$data['delivery_date'] = $delivery_date;
    		$data['return_type']   = $return_type;
    		$data['item_detail']   = $item_detail;
    		$data['login_user_id'] = $alldata['userId'];
    		$data['remark']        = $remark;
    		$data['attachment']    = $filename;
    		$db->insert('tbl_product_return', $data);
    		$server_generated_id = $db->lastInsertId();

    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
    		$db->rollBack();
    		$error = $e->getMessage();

    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'Data save successfully.',
    			'server_generated_id' => $server_generated_id
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }

    public function getSubProductDataAction(){
        // Get the Request parameters
    	$params    = $this->getRequest()->getParams();
    	$secretkey = $this->secretkey;
    	$db        = $this->db;
        // Genaral Information of the user login details

    	$curr_date     = date('Y-m-d');
    	$appkey        = isset($params['appkey']) ? $params['appkey'] : "";
    	$loginId       = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$device_id     = isset($params['device_id']) ? $params['device_id'] : "";
    	$product_id    = isset($params['product_id']) ? $params['product_id'] : "1";
    	$error_code    = 1;
    	$succes        = FALSE;

    	try {
    		$db->beginTransaction();
            // if (!$loginId || !$appkey) {
            //     throw new Exception("Required parameter missing.");
            // }
            // $user    = new Application_Model_Users();
            // $alldata = $user->getUserDataByLoginId($loginId);
            // echo '<pre>';
            // print_r($alldata);exit;
            // if ($appkey != $alldata['Device_token']) {
            //     throw new Exception("Invalid appkey.");
            // }
            // if (!empty($alldata['LoginID']) != $loginId) {
            //     $error_code = 3;
            //     throw new Exception('Invalid login id.');
            // }
            // if (strtolower($alldata['StaffStatus']) != 'ac') {
            //     $error_code = 5;
            //     throw new Exception('Your account is not active.');
            // }
    		$query = "select u.id, u.unit, subproduct.sku, subproduct.id, subproduct.sub_product_name, product.product_name, unit.unit from sub_product as subproduct left join unit as unit on (subproduct.unit = unit.id) left join logi_product as product on (product.id = subproduct.product_id) left join unit as u on (u.id = subproduct.unit) where subproduct.status = '0' and product_id = '".$product_id."' ";      
    		$result = $db->fetchAll($query); 

    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
    		$db->rollBack();
    		$error = $e->getMessage();

    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'Data save successfully.',
    			'subproductlist' => $result
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }


    public function getUserLocationAction(){
        // Get the Request parameters
    	$params    = $this->getRequest()->getParams();
    	$secretkey = $this->secretkey;
    	$db        = $this->db;
        // Genaral Information of the user login details
    	$appkey    = isset($params['appkey']) ? $params['appkey'] : "";
    	$user_id   = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$Imei      = isset($params['device_id']) ? $params['device_id'] : "";
    	$password  = isset($params['Password']) ? $params['Password'] : "";
    	$lat  = isset($params['lat']) ? $params['lat'] : "";
    	$lng  = isset($params['lng']) ? $params['lng'] : "";


    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();
            // if($secretkey != $appkey){                        
            //     throw new Exception("Invalid request.");
            // }
    		if (!$Imei) {
    			throw new Exception("Device ID missing.");
    		}
    		if (!$user_id) {
    			throw new Exception("Login ID missing.");
    		}
    		if (!$password) {
    			throw new Exception("Password missing.");
    		}
    		// if (!$lat) {
    		// 	throw new Exception("Lattitude missing.");
    		// }
    		// if (!$lng) {
    		// 	throw new Exception("Logitude missing.");
    		// }

    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($user_id, $password);

    		if (!empty($alldata['LoginID']) != $user_id) {
    			throw new Exception('Invalid login id.');
    		}

    		if (!empty($alldata['device_id'])) {
    			if ($alldata['device_id'] != $Imei) {
    				$error_code = 3;
    				throw new Exception('You are not athorized for this device.');
    			}
    		}

    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 3;
    			throw new Exception('Your account is not active.');
    		}

    		if ($alldata['access_status'] == 2) {
    			$error_code = 2;
    			throw new Exception('This account deactivated by admin.');
    		}

    		if($lat != "" && $lng !=""){
    			$sql_location        = "SELECT *, ( 3959 * acos(cos(radians(".$lat.")) * cos(radians(latitude)) * cos(radians(longitude) - radians(".$lng.")) + sin(radians(".$lat.")) * sin(radians(latitude ))) ) AS distance FROM logi_user_location_mapping where user_id = '" . $alldata['userId'] . "' ORDER BY distance
    			";
    		}else{
    			$sql_location        = "select * from logi_user_location_mapping where  user_id = '" . $alldata['userId'] . "'";
    		}
    		$res_location        = $db->fetchAll($sql_location);


    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'location list',
    			'location_list' => $res_location
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }



    /**
     * getMasterData() method is used to get master data
     * @param String
     * @return JSON 
     */

    public function getMasterDataAction(){ 

        // Get the Request parameters
    	$params       = $this->getRequest()->getParams();
    	$secretkey    = $this->secretkey;
    	$db           = $this->db;
        // Genaral Information of the user login details
    	$LoginID      = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$Imei         = isset($params['device_id']) ? $params['device_id'] : "";
    	$device_type  = isset($params['device_type']) ? $params['device_type'] : "";
    	$password     = isset($params['Password']) ? $params['Password'] : "";

    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();
    		if (!$LoginID || !$Imei  || !$password) {
    			$error_code = 2;
    			throw new Exception("Required parameter missing.");
    		}

    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($LoginID, $password);

    		if (!empty($alldata['LoginID']) != $LoginID && !empty($alldata['password']) != $password) {
    			$error_code = 3;
    			throw new Exception('Invalid login.');
    		}

    		if (!empty($alldata['DeviceID'])) {
    			if ($alldata['DeviceID'] != $Imei) {
    				$error_code = 4;
    				throw new Exception('You are not authorized for this device.');
    			}
    		}

    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 5;
    			throw new Exception('Your account is not active.');
    		}

    		if (isset($alldata['access_status']) && $alldata['access_status'] == 2) {
    			$error_code = 6;
    			throw new Exception('This account deactivated by admin.');
    		}

    		$getShiftDetail               = $user->getShiftDetail();            
    		$getConfigurationData         = $user->getConfigurationData();
    		$getSurveyType                = $user->getSurveyType();
    		$getBrandType                 = $user->getBrandType();
    		$getDistributorListForSurve   = $user->getDistributorListForSurvey();
    		$getNatureOfBussiness         = $user->getNatureOfBussiness();

    		$leave_type_query             = "SELECT * FROM leave_type";
    		$leave_type_result            = $db->fetchAll($leave_type_query);

    		$shift_query                  = "SELECT * FROM tbl_shift";
    		$shift_result                 = $db->fetchAll($shift_query);

    		$invoice_query                = "SELECT * FROM invoice_type ORDER BY invoiceType";
    		$invoice_result               = $db->fetchAll($invoice_query);

    		$get_support_issue            = "select * from tbl_support_issue_type order by issue_name";
    		$result_support_issues        = $db->fetchAll($get_support_issue);
    		$month_target = 0;
    		$sales_person_sql             = "select id from logi_user where LoginID='".$LoginID."'";
    		$sales_person                 = $db->fetchRow($sales_person_sql);
    		if($sales_person){
    			$monthly_target_sql       = "select * from sales_person_monthly_targets where sale_person_id=".$sales_person['id'];
    			$monthly_target           = $db->fetchRow($monthly_target_sql);
    			if($monthly_target){
    				$month_target         = $monthly_target['monthly_targets'];
    			}
    			else{
    				$month_target         = '0';
    			}
    		}
    		$sync_time = '2';

    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string'          => 'Master data list',
    			'Get_All_Shift'            => $getShiftDetail,
    			'get_configuration_data'   => $getConfigurationData,
    			'server_type'              => $getSurveyType,
    			'brand_type'               => $getBrandType,
    			'nature_of_bussiness'      => $getNatureOfBussiness,
    			'leave_type_result'        => $leave_type_result,
    			'shift_result'             => $shift_result,
    			'invoice_result'           => $invoice_result,
    			'distance'                 => '100',
    			'support_issue_list'       => $result_support_issues,
    			'sync_time'                => $sync_time,
    			'month_target'             => $month_target
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code"      => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }



    public function notifyEtaToWarehouseAction(){
    	$response = array();
    	try{
    		$db           = $this->db;
    		$params       = $this->getRequest()->getParams();
    		if(isset($params['van_sale_id']) && $params['van_sale_id'] != ""){
    			$userSql = "select id from logi_user where role='van_sale' and id=".$params['van_sale_id'];
    			$user = $db->fetchRow($userSql);
    			if($user){
    				$currdate = date('Y-m-d');
    				$productAllocationSql = "select * from tbl_product_allocation where allocated_to=".$user['id']." and DATE(allocated_date) = '".$currdate."' and allocation_status = 1  group by warehouse_id";
    				$productAllocations = $db->fetchAll($productAllocationSql);
    				if($productAllocations){
    					foreach ($productAllocations as $productAllocation) {
    						$distributorSql = "select u.*,w.warehouse_name,w.warehouse_code,w.warehouse_latitude,w.warehouse_longitude from logi_user as u left join  distributor_warehouse_associations as dwa on  dwa.distributor_id = u.id left join logi_warehouse as w on w.id = dwa.warehouse_id where w.id=".$productAllocation['warehouse_id'];
    						$distributor  = $db->fetchRow($distributorSql);
    						if($distributor){
    							$lastUserPathSql = "select * from user_path where userId=".$user['id']." order by id desc LIMIT 1";
    							$lastUserPath = $db->fetchRow($lastUserPathSql);
    							$distance_time = $this->GetDrivingDistance($lastUserPath['lat'],$distributor['warehouse_latitude'],$lastUserPath['long'],$distributor['warehouse_longitude']);
    							if(round($distance_time['hours']) <= 1){
    								$response['distance_time'] = $distance_time;
    							}
    						}
    					}
    				}else{
    					$response['flag'] = false;
    					$response['message'] = "No Any Product Allocation";
    				}
    			}else{
    				$response['flag'] = false;
    				$response['message'] = "Invalid Van Sale Id";
    			}
    		}else{
    			$response['flag'] = false;
    			$response['message'] = "Van Sale Id Missing";
    		}
    	}catch(Exception $e){
    		$response['flag'] = false;
    		$response['message'] = $e->getMessage();
    	}
    	echo json_encode($response);exit;
    }



    function GetDrivingDistance($lat1, $lat2, $long1, $long2){
    	$url = "https://maps.googleapis.com/maps/api/distancematrix/json?origins=".$lat1.",".$long1."&destinations=".$lat2.",".$long2."&key=AIzaSyD67PS69UkNREHH5pkb1E-zCy7iWKSNgE4&mode=driving&language=pl-PL";
    	$ch = curl_init();
    	curl_setopt($ch, CURLOPT_URL, $url);
    	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    	curl_setopt($ch, CURLOPT_PROXYPORT, 3128);
    	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    	$response = curl_exec($ch);
    	curl_close($ch);
    	$response_a = json_decode($response, true);
    	$origin_addresses = $response_a['origin_addresses'][0];
    	$destination_addresses = $response_a['destination_addresses'][0];
    	$dist = $response_a['rows'][0]['elements'][0]['distance']['text'];
    	$time = $response_a['rows'][0]['elements'][0]['duration']['text'];

    	return array(
    		'origin_addresses' => $origin_addresses, 
    		'destination_addresses' => $destination_addresses, 
    		'distance' => $dist, 
    		'hours' => ($time/60),
    		'time' => $time
    	);
    }


    public function loginFsvAction(){

        // Get the Request parameters
    	$params       = $this->getRequest()->getParams();
    	$secretkey    = $this->secretkey;
    	$db           = $this->db;
        // Genaral Information of the user login details
    	$LoginID      = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$Imei         = isset($params['device_id']) ? $params['device_id'] : "";
    	$device_type  = isset($params['device_type']) ? $params['device_type'] : "";
    	$lat          = isset($params['user_latitude']) ? $params['user_latitude'] : "";
    	$long         = isset($params['user_longitude']) ? $params['user_longitude'] : "";
    	$fire_base_id = isset($params['fcm_token']) ? $params['fcm_token'] : "";
    	$version      = isset($params['version']) ? $params['version'] : "";
    	$password     = isset($params['Password']) ? $params['Password'] : "";

    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();

    		if (!$LoginID || !$Imei  || !$password) {
    			$error_code = 2;
    			throw new Exception("Required parameter missing.");
    		}
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($LoginID, $password);

    		if (!empty($alldata['LoginID']) != $LoginID && !empty($alldata['password']) != $password) {
    			$error_code = 3;
    			throw new Exception('Invalid login.');
    		}
    		if (!empty($alldata['DeviceID'])) {
    			if ($alldata['DeviceID'] != $Imei) {
    				$error_code = 4;
    				throw new Exception('You are not authorized for this device.');
    			}
    		}
    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 5;
    			throw new Exception('Your account is not active.');
    		}
    		if (isset($alldata['access_status']) && $alldata['access_status'] == 2) {
    			$error_code = 6;
    			throw new Exception('This account deactivated by admin.');
    		}
    		$address = $this->getAddress($lat, $long);
            //print_r($LoginID); exit();
    		$update                                   = array();
    		$update['device_type']                    = $device_type;
    		$update['device_token']                   = $this->getSecretHashKey();
            $update['DeviceID']                       = $Imei; // IMEI Code
            $update['gps_status']                     = 'on';
            $update['lat']                            = $lat; // IMEI Code
            $update['long']                           = $long;
            $update['address']                        = $address;
            $update['fire_base_id']                   = $fire_base_id;
            if ($version) {
            	$update['app_version']                = $version;
            }
            $update['last_location_service_hit_time'] = $this->currdate;
            $user->updateSingleTableData('logi_user', $update, 'LoginID', $alldata['LoginID']);
            
            $user_login_data                          = array();
            $user_login_data['mob_user_staff_code']   = $LoginID;
            $user_login_data['login_time']            = $this->currdate;
            $user_login_data['server_detail']         = json_encode($_SERVER);
            $db->insert('logi_user_login_detail', $user_login_data);
            
            $getLoginUserDetail                       = $user->getUserDataByLoginId($LoginID, $password);

            
            $sync_time = '2';
            
            $db->commit();
            $succes = TRUE;
        }
        catch (Exception $e) {
            //Rollback transaction
        	$db->rollBack();
        	$error = $e->getMessage();
        }
        if ($succes == TRUE) {
        	echo json_encode(array(
        		"error_code" => '0',
        		'response_string'          => 'login success.',
        		'get_Login_User_Detail'    => $getLoginUserDetail,
        		'sync_time'                => $sync_time,
        		'minimum_distance'         => '1000'
        	));
        	exit;
        } else {
        	echo json_encode(array(
        		"error_code"      => $error_code,
        		'response_string' => $error
        	));
        	exit;
        }
    }

    public function getMappedBmcAction(){
        // Get the Request parameters
    	$params       = $this->getRequest()->getParams();
    	$secretkey    = $this->secretkey;
    	$db           = $this->db;
        // Genaral Information of the user login details
    	$LoginID      = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$Imei         = isset($params['device_id']) ? $params['device_id'] : "";
    	$device_type  = isset($params['device_type']) ? $params['device_type'] : "";
    	$appkey       = isset($params['appkey']) ? $params['appkey'] : ""; 
    	$password     = isset($params['Password']) ? $params['Password'] : "";

    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();

    		if (!$LoginID || !$Imei  || !$password) {
    			$error_code = 2;
    			throw new Exception("Required parameter missing.");
    		}
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($LoginID, $password);

    		if (!empty($alldata['LoginID']) != $LoginID && !empty($alldata['password']) != $password) {
    			$error_code = 3;
    			throw new Exception('Invalid login.');
    		}
    		if (!empty($alldata['DeviceID'])) {
    			if ($alldata['DeviceID'] != $Imei) {
    				$error_code = 4;
    				throw new Exception('You are not authorized for this device.');
    			}
    		}
    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 5;
    			throw new Exception('Your account is not active.');
    		}
    		if (isset($alldata['access_status']) && $alldata['access_status'] == 2) {
    			$error_code = 6;
    			throw new Exception('This account deactivated by admin.');
    		}
    		$query_bmc_mapping  = "SELECT tbl_bmc.id, tbl_bmc.bmc_name as location_name, tbl_bmc.lat as  latitude, tbl_bmc.long as  longitude  FROM tbl_bmc where 1";
    		$result_bmc_mapping = $db->fetchAll($query_bmc_mapping); 

    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string'   => 'Get mapped bmc list.',              
    			'mapped_bmc_detail' => $result_bmc_mapping
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code"      => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }



    public function saveFarmerDataAction(){
        // Get the Request parameters
    	$params                  = $this->getRequest()->getParams();
    	$secretkey               = $this->secretkey;
    	$db                      = $this->db;
        // Genaral Information of the user login details
    	$curr_date               = date('Y-m-d');
    	$appkey                  = isset($params['appkey']) ? $params['appkey'] : "5a73841ed8a1eceb09a1c58503e0f59f";
    	$loginId                 = isset($params['LoginID']) ? $params['LoginID'] : "USER0097";
    	$device_id               = isset($params['device_id']) ? $params['device_id'] : "861646041339159";
    	$farmer_name             = isset($params['farmer_name']) ? $params['farmer_name'] : "";
    	$mobile_no               = isset($params['mobile_no']) ? $params['mobile_no'] : "";
    	$address                 = isset($params['address']) ? $params['address'] : "";
    	$password                = isset($params['Password']) ? $params['Password'] : "";
    	$doc_no                  = isset($params['doc_no']) ? $params['doc_no'] : "899";
    	$rev_no                  = isset($params['rev_no']) ? $params['rev_no'] : "87789";
    	$rev_date                = isset($params['rev_date']) ? $params['rev_date'] : "2019-12-12";
    	$issue_no                = isset($params['issue_no']) ? $params['issue_no'] : "09";
    	$issue_date              = isset($params['issue_date']) ? $params['issue_date'] : "";
    	$date_of_evaluation      = isset($params['date_of_evaluation']) ? $params['date_of_evaluation'] : "";
    	$father_name             = isset($params['father_name']) ? $params['father_name'] : "";
    	$gender                  = isset($params['gender']) ? $params['gender'] : "";
    	$age                     = isset($params['age']) ? $params['age'] : "";
    	$village                 = isset($params['village']) ? $params['village'] : "";
    	$teshil                  = isset($params['teshil']) ? $params['teshil'] : "";
    	$district                = isset($params['district']) ? $params['district'] : "";
    	$pin_code                = isset($params['pin_code']) ? $params['pin_code'] : "";
    	$state                   = isset($params['state']) ? $params['state'] : "";
    	$land_holding            = isset($params['land_holding']) ? $params['land_holding'] : "";
    	$family_detail           = isset($params['family_detail']) ? $params['family_detail'] : "";
    	$milch_animal            = isset($params['milch_animal']) ? $params['milch_animal'] : "";
    	$background_verfication  = isset($params['background_verfication']) ? $params['background_verfication'] : "";
    	$bank_deatil             = isset($params['bank_deatil']) ? $params['bank_deatil'] : "";
    	$id_card_no              = isset($params['id_card_no']) ? $params['id_card_no'] : "";
    	$attachment              = isset($params['attachment']) ? $params['attachment'] : "";
    	$farmer_id               = isset($params['farmer_id']) ? $params['farmer_id'] : "";
    	$activity_status         = isset($params['activity_status']) ? $params['activity_status'] : "";
    	$adhar_card_no           = isset($params['adhar_card_no']) ? $params['adhar_card_no'] : "";
    	$voter_id                = isset($params['voter_id']) ? $params['voter_id'] : "";
    	$bank_passbook           = isset($params['bank_passbook']) ? $params['bank_passbook'] : "";
    	$other_id                = isset($params['other_id']) ? $params['other_id'] : "";
        $verification_remark     = isset($params['verification_remark']) ? $params['verification_remark'] : "";

        $error_code              = 1;
        $succes                  = FALSE;

        try {
          $db->beginTransaction();
          if (!$loginId) {
             throw new Exception("Login Id missing.");
         }
         if (!$appkey) {
             throw new Exception("Appkey missing.");
         }
         if (!$device_id) {
             throw new Exception("Device id missing.");
         }
         $user    = new Application_Model_Users();
         $alldata = $user->getUserDataByLoginId($loginId, $password);

         if ($appkey != $alldata['Device_token']) {
             throw new Exception("Invalid appkey.");
         }
         if (!empty($alldata['LoginID']) != $loginId) {
             $error_code = 3;
             throw new Exception('Invalid login id.');
         }
         if (strtolower($alldata['StaffStatus']) != 'ac') {
             $error_code = 5;
             throw new Exception('Your account is not active.');
         }
         $sql_check_farmer = "select * from tbl_farmer where mobile_no = '".$mobile_no."' and adhar_card_no = $adhar_card_no";
         $resultCheckFarmer = $db->fetchRow($sql_check_farmer);
         if ($resultCheckFarmer) {
             $error_code = 5;
             throw new Exception('Farmer already exist.');
         }
         $data   = array();


         if($params["adhar_card_attachment"]){
            $data['adhar_card_attachment'] = $this->uploadFile($params["adhar_card_attachment"],'uploads/bank_detail/');
        }

        if($params["voter_id_attachment"]){
            $data['voter_id_attachment'] = $this->uploadFile($params["voter_id_attachment"],'uploads/bank_detail/');
        }

        if($params["bank_passbook_attachment"]){
            $data['bank_passbook_attachment'] = $this->uploadFile($params["bank_passbook_attachment"],'uploads/bank_detail/');
        }

        if($params["other_id_attachment"]){
            $data['other_id_attachment'] = $this->uploadFile($params["other_id_attachment"],'uploads/bank_detail/');
        }

        $data['farmer_name']                = $farmer_name;
        $data['mobile_no']                  = $mobile_no;
        $data['address']                    = $address;
        $data['doc_no']                     = $doc_no;
        $data['rev_no']                     = $rev_no;
        $data['rev_date']                   = $rev_date;
        $data['issue_no']                   = $issue_no;
        $data['issue_date']                 = $issue_date;
        $data['date_of_evaluation']         = $date_of_evaluation;
        $data['father_name']                = $father_name;
        $data['gender']                     = $gender;
        $data['age']                        = $age;
        $data['village']                    = $village;
        $data['teshil']                     = $teshil;
        $data['district']                   = $district;
        $data['pin_code']                   = $pin_code;
        $data['state']                      = $state;
        $data['land_holding']               = $land_holding;
        $data['family_detail']              = $family_detail;
        $data['milch_animal']               = $milch_animal;
        $data['background_verfication']     = $background_verfication;
        $data['bank_deatil']                = $bank_deatil;
        $data['id_card_no']                 = $id_card_no;
        $data['adhar_card_no']              = $adhar_card_no;
        $data['voter_id']                   = $voter_id;
        $data['bank_passbook']              = $bank_passbook;
        $data['other_id']                   = $other_id;
        $data['user_id']                    = $alldata['userId'];
        $data['verification_remark']        = $alldata['verification_remark'];

        if($activity_status ==1){
           $db->update('tbl_farmer', $data, array('id=?' => $farmer_id));
           $response_msg_str = "Farmer updated successfully.";
       }
       else{
           $db->insert('tbl_farmer', $data);
           $server_generated_id             = $db->lastInsertId();

           $farmer_code = 'FAR00'.$server_generated_id;
           $update_query = "update tbl_farmer set  farmer_code = '".$farmer_code."' where id ='".$server_generated_id."'";
           $db->query($update_query);
           $response_msg_str = "Farmer added successfully.";

           $message = "Hi $farmer_name, Thank you for connecting with Rufil.Thanks & Regards : Rufil Team";
           $this->send_sms($mobile_no,$message);
       }
       $db->commit();
       $succes = TRUE;
   }
   catch (Exception $e) {
      $db->rollBack();
      $error = $e->getMessage();

  }
  if ($succes == TRUE) {
      echo json_encode(array(
       "error_code" => '0',
       'response_string' => $response_msg_str,
       'server_generated_id' => $server_generated_id,
       'adhar_card_attachment'=>$params["adhar_card_attachment"]
   ));
      exit;
  } else {
      echo json_encode(array(
       "error_code" => $error_code,
       'response_string' => $error
   ));
      exit;
  }
}


public function getFarmerDataAction(){
        // Get the Request parameters
 $params    = $this->getRequest()->getParams();
 $secretkey = $this->secretkey;
 $db        = $this->db;
        // Genaral Information of the user login details

 $curr_date       = date('Y-m-d');
 $appkey          = isset($params['appkey']) ? $params['appkey'] : "";
 $loginId         = isset($params['LoginID']) ? $params['LoginID'] : "";
 $device_id       = isset($params['device_id']) ? $params['device_id'] : "";
 $password        = isset($params['Password']) ? $params['Password'] : "";
 $error_code      = 1;
 $succes          = FALSE;

 try {

  $db->beginTransaction();
  if (!$loginId || !$appkey) {
   throw new Exception("Required parameter missing.");
}
$user    = new Application_Model_Users();
$alldata = $user->getUserDataByLoginId($loginId, $password);
            // echo '<pre>';
            // print_r($alldata);exit;
if ($appkey != $alldata['Device_token']) {
   throw new Exception("Invalid appkey.");
}
if (!empty($alldata['LoginID']) != $loginId) {
   $error_code = 3;
   throw new Exception('Invalid login id.');
}
if (strtolower($alldata['StaffStatus']) != 'ac') {
   $error_code = 5;
   throw new Exception('Your account is not active.');
}

$sql = "select * from tbl_farmer where user_id  = '".$alldata['userId']."'";
$res = $db->fetchAll($sql);


$db->commit();
$succes = TRUE;
}
catch (Exception $e) {
  $db->rollBack();
  $error = $e->getMessage();

}
if ($succes == TRUE) {
  echo json_encode(array(
   "error_code" => '0',
   'response_string' => 'Farmer list.',
   'farmer_list' => $res
));
  exit;
} else {
  echo json_encode(array(
   "error_code" => $error_code,
   'response_string' => $error
));
  exit;
}
}

public function getVansaleRetailerListAction(){

        // Get the Request parameters
 $params       = $this->getRequest()->getParams();
 $secretkey    = $this->secretkey;
 $db           = $this->db;
        // Genaral Information of the user login details
 $LoginID      = isset($params['LoginID']) ? $params['LoginID'] : "";
 $Imei         = isset($params['device_id']) ? $params['device_id'] : "";
 $device_type  = isset($params['device_type']) ? $params['device_type'] : "";        
 $password     = isset($params['Password']) ? $params['Password'] : "";

 $error_code = 1;
 $succes     = FALSE;

 try {
  $db->beginTransaction();

  if (!$LoginID || !$Imei) {
   $error_code = 2;
   throw new Exception("Required parameter missing.");
}

$user    = new Application_Model_Users();
$alldata = $user->getUserDataByLoginId($LoginID, $password);

if (!empty($alldata['LoginID']) != $LoginID) {
   $error_code = 3;
   throw new Exception('Invalid login id.');
}

if (!empty($alldata['DeviceID'])) {
   if ($alldata['DeviceID'] != $Imei) {
    $error_code = 4;
    throw new Exception('You are not authorized for this device.');
}
}

if (strtolower($alldata['StaffStatus']) != 'ac') {
   $error_code = 5;
   throw new Exception('Your account is not active.');
}

if ($alldata['access_status'] == 2) {
   $error_code = 6;
   throw new Exception('This account deactivated by admin.');
}

$sql_retailer_list = "select id, StaffName from logi_user where Role = 'retailer' order by id desc limit 20";
$res_retailer      = $db->fetchAll($sql_retailer_list);

$db->commit();
$succes = TRUE;
}
catch (Exception $e) {
            //Rollback transaction
  $db->rollBack();
  $error = $e->getMessage();
}
if ($succes == TRUE) {
  echo json_encode(array(
   "error_code" => '0',
   'response_string' => 'retailer list.',
   'retailer_list' => $res_retailer
));
  exit;
} else {
  echo json_encode(array(
   "error_code" => $error_code,
   'response_string' => $error
));
  exit;
}
}

    /**
     * bmcCheckinCheckout() method is used to check in check out at bmc
     * @param NULL
     * @return JSON 
     */
    
    public function bmcCheckinCheckoutAction(){
        // Get the Request parameters
    	$params           = $this->getRequest()->getParams();
    	$db               = $this->db;
        // Genaral Information of the user login details
    	$appkey           = isset($params['appkey']) ? $params['appkey'] : "";
    	$LoginID          = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$latitude         = isset($params['curr_latitude']) ? $params['curr_latitude'] : "";
    	$longitude        = isset($params['curr_longitude']) ? $params['curr_longitude'] : "";
    	$device_id        = isset($params['device_id']) ? $params['device_id'] : "";
    	$status           = isset($params['status']) ? $params['status'] : "";
    	$curr_date_time   = isset($params['curr_date_time']) ? $params['curr_date_time'] : "";
    	$bmc_latitude     = isset($params['bmc_latitude']) ? $params['bmc_latitude'] : "";
    	$bmc_longitude    = isset($params['bmc_longitude']) ? $params['bmc_longitude'] : "";
    	$bmc_name         = isset($params['bmc_name']) ? $params['bmc_name'] : "";
    	$password         = isset($params['Password']) ? $params['Password'] : "";

    	$error_code = 1;
    	$succes     = FALSE;
    	try {
    		$db->beginTransaction();
    		if (!$LoginID || !$device_id || !password) {
    			throw new Exception("Required parameter missing.");
    		}
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($LoginID, $password);
    		$count   = count($alldata);

    		if (!empty($alldata['LoginID']) != $LoginID) {
    			throw new Exception('Invalid user.');
    		}
    		if ($alldata['Device_token'] != $appkey) {
    			throw new Exception("Invalid request.");
    		}
    		if (!empty($alldata['device_id'])) {
    			if ($alldata['device_id'] != $device_id) {
    				$error_code = 3;
    				throw new Exception('You are not authorized for this device.');
    			}
    		}
    		if (strtoupper($alldata['StaffStatus']) != 'AC') {
    			throw new Exception('Your account is not active.');
    		}
    		$StaffCode    = $alldata['LoginID'];
    		$StaffName    = $alldata['StaffName'];

    		$sql_get_psm  = "select * from logi_user where LoginID = '" . $LoginID . "'";
    		$res_psm      = $db->fetchRow($sql_get_psm);

    		$notification = array();
    		if ($status == 1) {
    			$check_in                                = 'check_in';
    			$notification['LoginID']                 = $LoginID;
    			$notification['latitude']                = $latitude;
    			$notification['longitude']               = $longitude;
    			$notification['status']                  = $check_in;
    			$notification['noti_date']               = $curr_date_time;
    			$notification['sink_date_time']          = $this->currdate;
    			$notification['parent_regional_manager'] = $res_psm['parent_regional_manager'];
    			$notification['parent_zonal_manager']    = $res_psm['parent_zonal_manager'];
    			$notification['parent_area_manager']     = $res_psm['parent_area_manager'];
    			$notification['parent_sale_person']      = $res_psm['id'];
    			$notification['bmc_name']                = $bmc_name;
    			$notification['bmc_latitude']            = $bmc_latitude;
    			$notification['bmc_longitude']           = $bmc_longitude;  
    			$db->insert('tbl_bmc_attendance', $notification);
    			$notification_message = "Check in successfully";
    		}
    		else {
    			$check_out                               = 'check_out';
    			$notification['LoginID']                 = $LoginID;
    			$notification['latitude']                = $latitude;
    			$notification['longitude']               = $longitude;
    			$notification['status']                  = $check_out;
    			$notification['noti_date']               = $curr_date_time;
    			$notification['sink_date_time']          = $this->currdate;
    			$notification['parent_regional_manager'] = $res_psm['parent_regional_manager'];
    			$notification['parent_zonal_manager']    = $res_psm['parent_zonal_manager'];
    			$notification['parent_area_manager']     = $res_psm['parent_area_manager'];
    			$notification['parent_sale_person']      = $res_psm['id'];
    			$notification['bmc_name']                = $bmc_name;
    			$notification['bmc_latitude']            = $bmc_latitude;
    			$notification['bmc_longitude']           = $bmc_longitude;  
    			$db->insert('tbl_bmc_attendance', $notification);
    			$notification_message = "Check out successfully";
    		}
            // Notification message insert notification table
    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => $notification_message
    		));
    		exit;
    	}
    	else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }

    /**
     * saveBMCAction() method is used to save bmc
     * @param NULL
     * @return JSON 
     */
    
    public function saveBmcAction(){
        // Get the Request parameters
    	$params             = $this->getRequest()->getParams();
    	$secretkey          = $this->secretkey;
    	$db                 = $this->db;
        // Genaral Information of the user login details
    	$appkey             = isset($params['appkey']) ? $params['appkey'] : "";
    	$loginId            = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$name               = isset($params['name']) ? $params['name'] : "";
    	$permanent_address  = isset($params['permanent_address']) ? $params['permanent_address'] : "";
    	$latitude           = isset($params['bmc_latitude']) ? $params['bmc_latitude'] : "";
    	$longitude          = isset($params['bmc_longitude']) ? $params['bmc_longitude'] : "";
    	$taging_date        = isset($params['taging_date']) ? $params['taging_date'] : "";
    	$tag_status         = isset($params['tag_status']) ? $params['tag_status'] : "";
    	$password           = isset($params['Password']) ? $params['Password'] : "";

    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();
    		if (!$loginId || !$appkey || !$password) {
    			throw new Exception("Required parameter missing.");
    		}
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($loginId, $password);

    		if ($appkey != $alldata['Device_token']) {
    			throw new Exception("Invalid appkey.");
    		}

    		if (!empty($alldata['LoginID']) != $loginId) {
    			$error_code = 3;
    			throw new Exception('Invalid login id.');
    		}

    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 5;
    			throw new Exception('Your account is not active.');
    		}

    		$sql_check_user = "select * from tbl_bmc where bmc_name like '%" . $name . "'";
    		$result_user    = $db->fetchRow($sql_check_user);

    		if ($result_user) {
    			$error_code = 6;
    			throw new Exception('Retailer already exist.');
    		}
    		$sql_user_detail  = "select * from logi_user where id = '".$alldata['userId']."'";
    		$res_user_detail  = $db->fetchRow($sql_user_detail);

    		$retailergeotagingdetail = array();
    		if ($params["photograph1"] != "") {
    			$retailergeotagingdetail['photograph1'] = $this->uploadFile($params["photograph1"],'uploads/retailer_site_location/');
    		}
    		if ($params["photograph2"] != "") {
    			$retailergeotagingdetail['photograph2'] = $this->uploadFile($params["photograph2"],'uploads/retailer_site_location/');
    		}
    		$retailergeotagingdetail['bmc_name']                = $name;
    		$retailergeotagingdetail['address']                 = $permanent_address;
    		$retailergeotagingdetail['fsv_id']                  = $alldata['userId'];
    		$retailergeotagingdetail['lat']                     = $latitude;
    		$retailergeotagingdetail['long']                    = $longitude;
    		$retailergeotagingdetail['taging_date']             = $taging_date;
    		$retailergeotagingdetail['parent_regional_manager'] = $res_user_detail['parent_regional_manager'];
    		$retailergeotagingdetail['parent_zonal_manager']    = $res_user_detail['parent_zonal_manager'];
    		$retailergeotagingdetail['parent_area_manager']     = $res_user_detail['parent_area_manager'];
    		$retailergeotagingdetail['taging_date']             = $taging_date;
    		$db->insert('tbl_bmc', $retailergeotagingdetail);

    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code"         => '0',
    			'response_string'    => 'Bmc added successfully.',
    			'local_generated_id' => $local_generated_id,
    			'server_id'          => $lastretailerInsertId,
    			'user_latitude'      => $user_latitude,
    			'user_longitude'     => $user_longitude
    		));
    		exit;
    	}

    	else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }


    public function sendOtpAction(){

        // Get the Request parameters
    	$params    = $this->getRequest()->getParams();
    	$secretkey = $this->secretkey;
    	$db        = $this->db;
        // Genaral Information of the user login details
    	$mobile_no    = isset($params['mobile_no']) ? $params['mobile_no'] : "";
    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();

    		if (!$mobile_no) {
    			throw new Exception("Required parameter missing.");
    		}
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByMobileNo($mobile_no);

    		if (!$alldata) {
    			throw new Exception('Mobile no not exist.');
    		}
    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 3;
    			throw new Exception('Your account is not active.');
    		}
    		if ($alldata['access_status'] == 2) {
    			$error_code = 2;
    			throw new Exception('This account deactivated by admin.');
    		}
    		$otp = rand(100000,999999);

    		$updateOtp               = array();
    		$updateOtp['otp']        = $otp;
    		$updateOtp['otp_status'] = '1';
    		$db->update('logi_user', $updateOtp, array('MobileNo=?' => $mobile_no));

    		$otp_message = "Your+otp+for+reset+password+is+".$otp;

    		$url = "https://api.infobip.com/sms/1/text/query?username=Rufil123&password=Rufil@123&text=".$otp_message."&from=RUFILJ&to=91".$mobile_no;
    		$ch = curl_init();
            // set URL and other appropriate options
    		curl_setopt($ch, CURLOPT_URL, $url);
            // grab URL and pass it to the browser
    		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    		curl_exec($ch);
            // close cURL resource, and free up system resources
    		curl_close($ch);

    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'OTP send successfully'
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }

    public function verifyOtpAction(){
        // Get the Request parameters
    	$params     = $this->getRequest()->getParams();
    	$secretkey  = $this->secretkey;
    	$db         = $this->db;
        // Genaral Information of the user login details
    	$otp        = isset($params['otp']) ? $params['otp'] : "";
    	$mobile_no  = isset($params['mobile_no']) ? $params['mobile_no'] : "";
    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();

    		if (!$mobile_no || !$otp) {
    			throw new Exception("Required parameter missing.");
    		}
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByMobileNoAndOtp($mobile_no, $otp);

    		if (!$alldata) {
    			throw new Exception('Otp does not match.');
    		}

    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'OTP verified successfully'
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }

    public function changePasswordAction(){
        // Get the Request parameters
    	$params           = $this->getRequest()->getParams();
    	$secretkey        = $this->secretkey;
    	$db               = $this->db;
        // Genaral Information of the user login details
    	$mobile_no        = isset($params['mobile_no']) ? $params['mobile_no'] : "";
    	$new_password     = isset($params['new_password']) ? $params['new_password'] : "";
    	$error_code       = 1;
    	$succes           = FALSE;

    	try {
    		$db->beginTransaction();

    		if (!$new_password) {
    			throw new Exception("Password is blank.");
    		}
    		$updatePassword               = array();
    		$updatePassword['otp']        = '';
    		$updatePassword['otp_status'] = '0';
    		$updatePassword['Password']   = $new_password;
    		$db->update('logi_user', $updatePassword, array(
    			'MobileNo=?' => $mobile_no
    		));
    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'Password changed successfully'
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }

    /**
     * getCustomerCategoryList() method is used to get master data of customer list
     * @param NULL
     * @return JSON 
     */
    
    public function getCustomerCategoryListAction(){
        // Get the Request parameters
    	$params             = $this->getRequest()->getParams();
    	$secretkey          = $this->secretkey;
    	$db                 = $this->db;
        // Genaral Information of the user login details
    	$appkey             = isset($params['appkey']) ? $params['appkey'] : "";
    	$loginId            = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$password           = isset($params['Password']) ? $params['Password'] : "";

    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();
    		if (!$loginId || !$appkey || !$password) {
    			throw new Exception("Required parameter missing.");
    		}
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($loginId, $password);
            // echo "<pre>";
            // print_r($alldata);
            // exit;
    		if ($appkey != $alldata['Device_token']) {
    			throw new Exception("Invalid appkey.");
    		}
    		if (!empty($alldata['LoginID']) != $loginId) {
    			$error_code = 3;
    			throw new Exception('Invalid login id.');
    		}
    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 5;
    			throw new Exception('Your account is not active.');
    		}
    		$sql = "select * from tbl_customer_category where status = '1'";
    		$res = $db->fetchAll($sql);

    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code"         => '0',
    			'response_string'    => 'Customer category listed successfully.',
    			'list' => $res
    		));
    		exit;
    	}
    	else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }

    function uploadFile($file,$uploaddir){
    	$binary   = base64_decode($file);
    	header('Content-Type: bitmap; charset=utf-8');
    	$filename   = $uploaddir.'/'.time().rand(1,100000000).'.jpg';
    	$file     = fopen($filename, 'wb');
    	fwrite($file, $binary);
    	fclose($file); 
    	return '/'.$filename;

    }

    public function monthlyTargetAction(){
        // Get the Request parameters
    	$params       = $this->getRequest()->getParams();
    	$secretkey    = $this->secretkey;
    	$db           = $this->db;
        // Genaral Information of the user login details
    	$LoginID      = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$Imei         = isset($params['device_id']) ? $params['device_id'] : "";
    	$device_type  = isset($params['device_type']) ? $params['device_type'] : "";
    	$appkey       = isset($params['appkey']) ? $params['appkey'] : ""; 
    	$password     = isset($params['Password']) ? $params['Password'] : "";

    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();

    		if (!$LoginID || !$Imei  || !$password) {
    			$error_code = 2;
    			throw new Exception("Required parameter missing.");
    		}

    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($LoginID, $password);

    		if (!empty($alldata['LoginID']) != $LoginID && !empty($alldata['password']) != $password) {
    			$error_code = 3;
    			throw new Exception('Invalid login.');
    		}

    		if (!empty($alldata['DeviceID'])) {
    			if ($alldata['DeviceID'] != $Imei) {
    				$error_code = 4;
    				throw new Exception('You are not authorized for this device.');
    			}
    		}

    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 5;
    			throw new Exception('Your account is not active.');
    		}

    		if (isset($alldata['access_status']) && $alldata['access_status'] == 2) {
    			$error_code = 6;
    			throw new Exception('This account deactivated by admin.');
    		}

    		$query_monthly_target  = "SELECT monthly_targets  FROM sales_person_monthly_targets where sale_person_id = '".$alldata['userId']."' order by id desc limit 1";
    		$result_monthly_target = $db->fetchRow($query_monthly_target); 

    		if($result_monthly_target){
    			$monthly_target = $result_monthly_target['monthly_targets'];
    		}
    		else{
    			$monthly_target = NA;
    		}

    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string'   => 'Get monthly target.',              
    			'monthly_target'    => $monthly_target
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code"      => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }


    public function getFarmerDetailAction(){
        // Get the Request parameters
    	$params       = $this->getRequest()->getParams();
    	$secretkey    = $this->secretkey;
    	$db           = $this->db;
        // Genaral Information of the user login details
    	$LoginID      = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$Imei         = isset($params['device_id']) ? $params['device_id'] : "";
    	$device_type  = isset($params['device_type']) ? $params['device_type'] : "";
    	$appkey       = isset($params['appkey']) ? $params['appkey'] : ""; 
    	$password     = isset($params['Password']) ? $params['Password'] : "";
    	$farmer_id     = isset($params['farmer_id']) ? $params['farmer_id'] : "";


    	$error_code = 1;
    	$succes     = FALSE;

    	try {
    		$db->beginTransaction();

    		if (!$LoginID || !$Imei  || !$password) {
    			$error_code = 2;
    			throw new Exception("Required parameter missing.");
    		}
    		$user    = new Application_Model_Users();
    		$alldata = $user->getUserDataByLoginId($LoginID, $password);

    		if (!empty($alldata['LoginID']) != $LoginID && !empty($alldata['password']) != $password) {
    			$error_code = 3;
    			throw new Exception('Invalid login.');
    		}
    		if (!empty($alldata['DeviceID'])) {
    			if ($alldata['DeviceID'] != $Imei) {
    				$error_code = 4;
    				throw new Exception('You are not authorized for this device.');
    			}
    		}
    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 5;
    			throw new Exception('Your account is not active.');
    		}
    		if (isset($alldata['access_status']) && $alldata['access_status'] == 2) {
    			$error_code = 6;
    			throw new Exception('This account deactivated by admin.');
    		}
    		$query  = "SELECT *  FROM tbl_farmer where id = '".$farmer_id."'";
    		$result = $db->fetchAll($query); 

    		$db->commit();
    		$succes = TRUE;
    	}
    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}
    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string'   => 'Farmer detail.',              
    			'farmer_detail' => $result
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code"      => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }

    public function send_sms($number,$message){
    	if(strlen($number) == 10){
    		$url = "https://api.infobip.com/sms/1/text/query?username=Rufil123&password=Rufil@123&text=".urlencode($message)."&from=RUFILJ&to=91".$number;
    		$ch = curl_init();
    		curl_setopt($ch, CURLOPT_URL, $url);
    		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    		curl_exec($ch);
    		curl_close($ch);
    	}
    }
}