<?php

/***************************************************************
 * Logimetrix Techsolutions Pvt. Ltd.
 * File Name   : Productallocation.php
 * File Description  : Productallocation
 * Created By : Puneet Mishra
 * Created Date: 31 Aug 2018
 ***************************************************************/

class ProductallocationController extends Zend_Controller_Action{

  var $dbAdapter;
  var $db;

  public function init(){
   /* Initialize action controller here */
   $this->_flashMessenger  = $this->_helper->getHelper('FlashMessenger');
   $bootstrap = $this->getInvokeArg('bootstrap');
   $aConfig = $bootstrap->getOptions();
   $this->db = Zend_Db_Table::getDefaultAdapter();
   $auth = Zend_Auth::getInstance();
   $authStorage = $auth->getStorage();
   $this->WebLoginID = $authStorage->read()->WebLoginID;
   $users = new Application_Model_Users();
   $logout_details = $users->getUserLoginDetailByWebLoginCode($this->WebLoginID);
   $this->view->last_login = $logout_details['login_time']; 

   $this->role                    = $authStorage->read()->Role;
   $this->id                      = $authStorage->read()->id;              
 }

 public function indexAction(){
  $this->view->messages = $this->_flashMessenger->getMessages();  
  $this->checklogin();
  $params = $this->view->params = $this->getRequest()->getParams();
  $gmap = new Application_Model_Gmap();
  $this->view->getUserList = $getUserList =  $gmap->getUserList( $this->role, $this->id); 

  $role = $this->role;
  $id   = $this->id;

  if($params['sale_person'] !=""){
    $cond .="and u.parent_sale = '".$params['sale_person']."'";
  }

  if($params['distributor'] !=""){
    $cond .="and u.StaffName  like '%".$params['distributor']."%'";
  }

  if ($role == 'super_admin') {
    $user_cond .= "";
  }

  if ($role == 'RM') {
    $user_cond .= "and u.parent_regional_manager = '" . $id . "'";
  }

  if ($role == 'ZM') {
    $user_cond .= "and u.parent_zonal_manager = '" . $id . "' ";
  }

  if ($role == 'ASM') {
    $user_cond .= "and u.parent_area_manager = '" . $id . "' ";
  }

  if ($role == 'Sales') {
    $user_cond .= "and u.parent_sale = '" . $id . "' ";
  }

  $query = "select u.*, tsi.id as tsi_id, tsi.StaffName as tsi_name from logi_user as u left join logi_user as tsi on (tsi.id = u.parent_sale) where 1 and u.Role = 'distributer' $cond  $user_cond order by id desc";
  $result = $this->db->fetchAll($query);
  $page=$this->_getParam('page',1);
  $paginator = Zend_Paginator::factory($result);      
  $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
  $paginator->setItemCountPerPage(15); // number of items to show per page
  $this->view->paginator = $paginator;
  $this->view->totalrec = $paginator->getTotalItemCount();
}

public function mapProductAction(){
  $this->checklogin();
  $db = $this->db;
  $this->view->messages = $this->_flashMessenger->getMessages();
  $params = $this->getRequest()->getParams();
  $Retailer = new Application_Model_Retailer();
  $this->view->params = $params;
  $auth = Zend_Auth::getInstance();
  $authStorage = $auth->getStorage(); 
  $this->view->getAllProduct = $getAllProduct = $Retailer->getdetailforallproduct();  

  $sql_user             = "select * from logi_user where md5(LoginID) = '".$params['datacode']."' ";
  $this->view->res_user = $res_user = $this->db->fetchRow($sql_user);

  if($this->getRequest()->isPost()){
    $i=0;
    foreach($params['product_name'] as $key=>$value){
      $product_detail[$i] = array();
      $product_detail[$i]['distributer_id'] = $params['datacode'];
      $product_detail[$i]['product_id']     = $params['product_name'][$i];
      $product_detail[$i]['sub_product_id'] = $params['sub_product_name'][$i];
      $product_detail[$i]['rate']           = $params['rate'][$i];
      $product_detail[$i]['retailer_rate']  = $params['retailer_rate'][$i];

      $db->insert('logi_distributer_products', $product_detail[$i]);                            
      $i++;  
    } 
    $this->view->successMessage = "Product Mapped Successfully"; 
  }        
}

public function editMappedProductAction(){
  $this->checklogin();
  $db = $this->db;
  $this->view->messages = $this->_flashMessenger->getMessages();
  $params = $this->getRequest()->getParams();
  $Retailer = new Application_Model_Retailer();
  $this->view->params = $params;
  $auth = Zend_Auth::getInstance();
  $authStorage = $auth->getStorage(); 
  $this->view->getAllProduct = $getAllProduct = $Retailer->getdetailforallproduct();  

  $sql_user             = "select * from logi_user where md5(LoginID) = '".$params['datacode']."' ";
  $this->view->res_user = $res_user = $this->db->fetchRow($sql_user);

  $query_get_mapped_product = "select * from logi_distributer_products where md5(distributer_id) = '".$params['datacode']."' order by product_id" ;        
  $this->view->result_mapped_product = $result_mapped_product = $this->db->fetchAll($query_get_mapped_product);

  if($this->getRequest()->isPost()){

    $sql_delete_mapped_product = "delete from logi_distributer_products where distributer_id = '".$params['datacode']."'";
    $this->db->query($sql_delete_mapped_product);

    $i=0;
    foreach($params['product_name'] as $key=>$value){
      $product_detail[$i] = array();
      $product_detail[$i]['distributer_id'] = $params['datacode'];
      $product_detail[$i]['product_id']     = $params['product_name'][$i];
      $product_detail[$i]['sub_product_id'] = $params['sub_product_name'][$i];
      $product_detail[$i]['rate']           = $params['rate'][$i];
      $product_detail[$i]['retailer_rate']  = $params['retailer_rate'][$i];

      $db->insert('logi_distributer_products', $product_detail[$i]);                            
      $i++;  
    } 
    $this->_flashMessenger->addMessage('Product mapping updated successfully.');
    $this->_redirect('/productmapping/edit-mapped-product/datacode/'.md5($params['datacode'])); 
  }        
}

public function getSubProductListAction(){

  $this->checklogin();
  $this->getHelper('Layout')->disableLayout();
  $this->getHelper('ViewRenderer')->setNoRender();
  $this->getResponse()->setHeader('Content-Type', 'application/json');
  $Retailer = new Application_Model_Retailer();      
  $product_id = $this->getRequest()->getParam('product_id');
  $data_list_unformat = $Retailer->getSubProductListByProductId($product_id);          
  $sub_product_list[] = array("value"=>"",'text'=>"--Select Sub Product--");
  foreach($data_list_unformat as $single){
    $sub_product_list[] = array("value"=>$single['id'],"text"=>$single['sub_product_name']);
  }             
  $this->getHelper('Layout')->disableLayout();
  $this->getHelper('ViewRenderer')->setNoRender();
  $this->getResponse()->setHeader('Content-Type', 'application/json');
  echo json_encode(array('options'=>$sub_product_list));
  return;      
}

public function checklogin(){   
  $auth = Zend_Auth::getInstance(); 
  $errorMessage = ""; 
  /*************** check user identity ************/
  if(!$auth->hasIdentity()){
    $this->_redirect('admin/index');  
  }   
}     
}
