<?php

/***************************************************************

* Logimetrix Techsolution Pvt. Ltd.

* File Name   : Users.php

* File Description  : Model Method

* Created By : Puneet Mishra




* Created Date: 25 Nov 2016

***************************************************************/



class Application_Model_Users extends Zend_Db_Table_Abstract{

    //var $userCondi = " and (role='field_user' OR role='zone_head') and is_deleted='0' and access_status='0' and StaffStatus='AC'";



    public function getUserLoginDetailByWebLoginCode($WebLoginID){
        $db    = Zend_Db_Table::getDefaultAdapter();
        $query = "SELECT * FROM logi_user_login_detail WHERE  mob_user_staff_code =?";
        return $result = $db->fetchRow($query, array(
            $WebLoginID
        ));
    }
    
    /**
     * updateUserLoginDetailsByLoginID() method is used to update app user details
     * @param Array
     * @return True 
     * add by Abhishek(24-07-2015)
     */
    
    public function updateUserLoginDetailsByLoginID($WebLoginID, $login_time){
        $db = Zend_Db_Table::getDefaultAdapter();
        $db->query("update logi_user_login_detail set login_time=? where WebLoginID=? ", array(
            $login_time,
            $WebLoginID
        ));
    }
    
    /**
     * insertUserLoginDetailsByWebLoginID() method is used to insert user login details  by web app
     * @param Array
     * @return True 
     */
    
    public function insertUserLoginDetailsByWebLoginID($user_login_data = array()){
        $db = Zend_Db_Table::getDefaultAdapter();
        return $result = $db->insert("logi_user_login_detail", $user_login_data);
    }
    
    /**
     * insertUserLoginDetailsByLoginID() method is used to insert user login details by mobile app
     * @param Array
     * @return True 
     */
    
    public function insertUserLoginDetailsByLoginID($user_login_data = array()){
        $db = Zend_Db_Table::getDefaultAdapter();
        return $result = $db->insert("logi_user_login_detail", $user_login_data);
    }
    
    
    /**
     * updateUserLogoutDetailsByLoginID() method is used to update app user details
     * @param Array
     * @return True 
     * add by Abhishek(24-07-2015)
     */
    
    public function updateUserLogoutDetailsByLoginID($WebLoginID, $logout_time){
        $db = Zend_Db_Table::getDefaultAdapter();
        $db->query("update logi_user_login_detail set logout_time=? where WebLoginID=? ", array(
            $logout_time,
            $WebLoginID
        ));
    }
    
    
    /**
     * updateChangePasswordByStaffCode() method is used to get all users details
     * @param Array
     * @return Array 
     */
    
    public function updateChangePasswordByStaffCode($updateData = array(), $where){
        $db = Zend_Db_Table::getDefaultAdapter();
        $db->update('logi_admin', $updateData, $where);
    }
    
    
    public function GetAllFEList($webLoginId){
        $db    = Zend_Db_Table::getDefaultAdapter();
        $query = "SELECT StaffName,LoginID,Email,MobileNo FROM logi_field_users 
        WHERE ParentWebLoginID=? and StaffStatus='AC' and role='field_user' order by id DESC";
        return $result = $db->fetchAll($query, array(
            $webLoginId
        ));
    }
    
    /**
     * getUserDataByUserUniqueId() method is used to get all users list by email
     * @param String and Array
     * @return Array 
     */
    
    public function getUserDataByLoginId($loginID, $password){
        $db    = Zend_Db_Table::getDefaultAdapter();
        $query = "SELECT Password as password, id as userId, MobileNo, LoginID,DeviceID,StaffStatus,StaffName,Device_type,Device_token,Role,  state,  DistrictID,last_location_service_hit_time FROM logi_user WHERE LoginID='" . $loginID . "'  and Password = '".$password."'";  
        
        return $result = $db->fetchRow($query, array());
    }
    public function getUserDataLoginId($LoginID){
        $db    = Zend_Db_Table::getDefaultAdapter();
        $query = "SELECT Password as password, id as userId, MobileNo, LoginID,DeviceID,StaffStatus,StaffName,Device_type,Device_token,Role,  state,  DistrictID,last_location_service_hit_time FROM logi_user WHERE LoginID='" . $LoginID . "'";  
        
        return $result = $db->fetchRow($query, array());
    }
    public function getUserDataByAppToken($Device_token){
        $db    = Zend_Db_Table::getDefaultAdapter();
        $query = "SELECT Password as password, id as userId, MobileNo, LoginID,DeviceID,StaffStatus,StaffName,Device_type,Device_token,Role,  state,  DistrictID FROM logi_user WHERE Device_token='" . $Device_token ."'";    
        return $result = $db->fetchRow($query, array());
    }

    public function getUserDataByMobileNo($mobile_no){
        $db    = Zend_Db_Table::getDefaultAdapter();
        $query = "SELECT Password as password, id as userId, MobileNo, LoginID,DeviceID,StaffStatus,StaffName,Device_type,Device_token,Role,  state,  DistrictID FROM logi_user WHERE MobileNo='" . $mobile_no . "'";
        
        return $result = $db->fetchRow($query, array());
    }


    public function getUserDataByMobileNoAndOtp($mobile_no, $otp){
        $db    = Zend_Db_Table::getDefaultAdapter();
        $query = "SELECT Password as password, id as userId, MobileNo, LoginID,DeviceID,StaffStatus,StaffName,Device_type,Device_token,Role,  state,  DistrictID FROM logi_user WHERE MobileNo='" . $mobile_no . "' and otp='".$otp."' and otp_status = '1'";
        
        return $result = $db->fetchRow($query, array());
    }
    
    
    public function getUserDataByLoginIdForSalePerson($user_id, $password){
        $db    = Zend_Db_Table::getDefaultAdapter();
        $query = "SELECT id as userId, parent_name,MobileNo,Password, LoginID,DeviceID,StaffStatus,StaffName,Device_type,Device_token,Role FROM logi_user WHERE LoginID='" . $user_id . "' and Password='" . $password . "' and Role IN ('Sales', 'TSE')";
        return $result = $db->fetchRow($query, array());
    }
    
    public function updateSingleTableData($table = 'logi_user', $data, $whereField, $id){
        $db     = new Zend_Db_table($table);
        $where  = $db->getAdapter()->quoteInto(" $whereField = ?", array(
            $id
        ));
        $result = $db->update($data, $where);
    }
    
    public function getReachSiteData($user, $selected_date, $role, $id){
        $db = Zend_Db_Table::getDefaultAdapter();

        if ($role == 'super_admin') {
            $user_cond .= "";
        }
        if ($role == 'RM') {
            $user_cond .= "and ln.parent_regional_manager = '" . $id . "' ";
        }
        if ($role == 'ZM') {
            $user_cond .= "and ln.parent_zonal_manager = '" . $id . "' ";
        }
        if ($role == 'ASM') {
            $user_cond .= "and ln.parent_area_manager = '" . $id . "' ";
        }
        if ($role == 'Sales') {
            $user_cond .= "and ln.parent_sale_person = '" . $id . "' ";
        }
        if ($selected_date) {
            $current_date = $selected_date;
        } else {
            $current_date = date("Y-m-d");
        }
        if ($user) {
            $cond = "and ln.loginid ='" . $user . "'";
        }
        
        $query = "SELECT ln.*, lu.StaffName as retailer, lu1.StaffName as sale_person, date(ln.notification_date_time) as notification_date FROM logi_notification as ln
        left join logi_user as lu on(lu.id = ln.retailer_id)
        left join logi_user as lu1 on(lu1.id = ln.app_user_id)
        where date(ln.notification_date_time) = '" . $current_date . "' $cond $user_cond
        group by ln.retailer_id, ln.app_user_id, date(ln.notification_date_time)";
        $result = $db->fetchAll($query);
        return $result;
    }
    
    public function getAttDash($id, $curr_date, $last){
        $db    = Zend_Db_Table::getDefaultAdapter();
        $query = "SELECT * from Attendance where LoginID = '" . $id . "' and date(noti_date) BETWEEN '" . $last . "' - INTERVAL 1 DAY AND '" . $curr_date . "' group by date(noti_date) order by date(noti_date) desc";
        return $result = $db->fetchAll($query);
    }
    
    public function getNameForAttdash($id){
        $db    = Zend_Db_Table::getDefaultAdapter();
        $query = "SELECT * from logi_user where LoginID = '" . $id . "' ";
        return $result = $db->fetchRow($query);
    }
    
    public function getDashboardAttendance($id, $role){
        $db = Zend_Db_Table::getDefaultAdapter();
        if ($role == 'super_admin') {
            $user_cond .= "";
        }
        
        if ($role == 'RM') {
            $user_cond .= "and l.parent_regional_manager = '" . $id . "' ";
        }
        
        if ($role == 'ZM') {
            $user_cond .= "and l.parent_zonal_manager = '" . $id . "' ";
        }
        
        if ($role == 'ASM') {
            $user_cond .= "and l.parent_area_manager = '" . $id . "' ";
        }
        
        if ($role == 'Sales') {
            $user_cond .= "and l.parent_sale = '" . $id . "' ";
        }
        $query = "SELECT a.*,l.LoginID,l.StaffName from Attendance as a left join logi_user as l on(l.LoginID = a.LoginID) where date(a.noti_date) = '" . date('Y-m-d') . "' $user_cond group by a.LoginID order by date(a.noti_date)";
        return $result = $db->fetchALl($query);
        
    }
    
    public function getDayStartforDashAtt($id, $date){
        $db    = Zend_Db_Table::getDefaultAdapter();
        $query = "SELECT  latitude, longitude, noti_date from Attendance   where date(noti_date) = '" . $date . "' and LoginID = '" . $id . "' and status='day_start'  limit 1";
        return $result = $db->fetchRow($query);
    }
    
    public function getDayEndforDashAtt($id, $date){
        $db    = Zend_Db_Table::getDefaultAdapter();
        $query = "SELECT  latitude, longitude, noti_date  from Attendance   where date(noti_date) = '" . $date . "' and LoginID = '" . $id . "' and status='day_close' order by id desc limit 1";
        return $result = $db->fetchRow($query);
    }
    
    public function GetProductDetail($parent){
        $db = Zend_Db_Table::getDefaultAdapter();
        
        $query  = "select LoginID from logi_user where id = $parent";
        $result = $db->fetchRow($query);
        
        $query_product  = $query = "SELECT product.id as product_id , product.product_name,  product.qty, unit.unit, packing.packing_type FROM   logi_distributer_products as dp  left join logi_product AS product on (dp.product_id = product.id) LEFT JOIN unit AS unit ON ( unit.id = product.unit ) left join packing_type AS packing ON ( packing.id = product.packing_type ) where dp.distributer_id ='" . $result['LoginID'] . "'";
        $result_product = $db->fetchAll($query_product);
        $get_prduct     = array();
        foreach ($result_product as $data) {
            array_push($get_prduct, $data);
        }
        $total_product = json_encode($get_prduct);
        return $get_total_product_detail = array(
            'product_deatil' => $get_prduct
        );
        
    }
    
    
    public function getParentDistributerProductDetail($parent){
        $db = Zend_Db_Table::getDefaultAdapter();
        
        $query = "SELECT product.id as product_id , product.product_name, sub_product.id as sub_product_id, sub_product.sub_product_name as sub_product_name,  dp.rate FROM   logi_distributer_products as dp  left join logi_product AS product on (dp.product_id = product.id) LEFT JOIN unit AS unit ON ( unit.id = product.unit ) left join packing_type AS packing ON ( packing.id = product.packing_type )
        left join sub_product AS sub_product ON ( sub_product.id = dp.sub_product_id ) where dp.distributer_id ='" . $parent . "'";
        return $result_product = $db->fetchAll($query);
        
    }
    
    
    
    public function subcategorybyproduct(){
        $db = Zend_Db_Table::getDefaultAdapter();
        
        $query = "select * from logi_product_subcategory";
        return $result = $db->fetchAll($query);
    }
    
    public function getInventorycount($product, $subproduct){

        $db    = Zend_Db_Table::getDefaultAdapter();
        $query = "select count(id) as number from inventory where product_category = '" . $product . "' and  product_subcategory = '" . $subproduct . "'";
        return $result = $db->fetchRow($query);
    }
    
    public function getInventoryquantity($product, $subproduct){

        $db    = Zend_Db_Table::getDefaultAdapter();
        $query = "select qty from inventory where product_category = '" . $product . "' and  product_subcategory = '" . $subproduct . "'";
        return $result = $db->fetchRow($query);
    }
    
    
    public function updateinventoryData($data, $product, $subproduct){
        $db    = Zend_Db_Table::getDefaultAdapter();
        $query = "update inventory set qty = '" . $data['qty'] . "', date = '" . $data['date'] . "' where product_category = '" . $product . "' and product_subcategory = '" . $subproduct . "'";
        $db->query($query);
    }
    
    public function updateorderId($data, $id){
        $db    = Zend_Db_Table::getDefaultAdapter();
        $query = "update logi_order set code = '" . $data . "' where id= '" . $id . "'";
        $db->query($query);
    }
    
    
    public function getProductRate($MobileNo, $product_id){
        $db = Zend_Db_Table::getDefaultAdapter();
        $query_reatiler  = "select parent_name from logi_user where MobileNo = '" . $MobileNo . "' and Role = 'Retailer'";
        $result_reatiler = $db->fetchRow($query_reatiler);
        
        $query_distributer  = "select LoginID from logi_user where id  = '" . $result_reatiler['parent_name'] . "'";
        $result_distributer = $db->fetchRow($query_distributer);
        
        $query = "select rate from logi_distributer_products where distributer_id = '" . $result_distributer['LoginID'] . "' and  product_id = '" . $product_id . "'";
        return $result = $db->fetchRow($query);
    }
    
    
    public function getDistributerLoginID($MobileNo){
        $db = Zend_Db_Table::getDefaultAdapter();
        
        $query_reatiler  = "select parent_name from logi_user where MobileNo = '" . $MobileNo . "' and Role = 'Retailer'";
        $result_reatiler = $db->fetchRow($query_reatiler);
        
        $query_distributer = "select LoginID from logi_user where id  = '" . $result_reatiler['parent_name'] . "'";
        return $result_distributer = $db->fetchRow($query_distributer);
    }
    
    public function GetParentId($distributer){
        $db    = Zend_Db_Table::getDefaultAdapter();
        $query = "select * from logi_user where LoginID = '" . $distributer . "'";
        
        return $result = $db->fetchRow($query);
    }
    
    public function getCrosspondingReetailers($search_by_date, $search_by_status, $user, $role,$lat,$lng,$Area_id){
        $db = Zend_Db_Table::getDefaultAdapter();
        $search_cond = "";

        if($search_by_date){
            $search_cond  .=" and date(u1.Created) = '".$search_by_date."'";
        }
        if($search_by_status != ""){
            if($search_by_status == "1"){
                $search_cond  .=" and u1.approval_status = 1";
            }else if($search_by_status == "0"){
                $search_cond  .=" and u1.approval_status = 0";
            }
        }
        if($Area_id !== ""){
            $area =    "select location_id from logi_user_location_mapping WHERE 1 and id = '".$Area_id."'";
        }
        else{
            $area =    "select location_id from logi_user_location_mapping WHERE 1  and user_id = '".$user."'";  
        }
        $res  = $db->fetchAll($area);
        if($res){
            $area_array = array();
            foreach ($res as $ress){
                $det = $ress['location_id'];
                array_push($area_array,"'".$det."'");
            }
            $area_array = array_unique($area_array);
            $ids = implode(",",$area_array);
        }
        else{
            $ids = "'none'";
        }
        if($role=='RM'){
            $query = "select u1.category, u1.Address_Curr, u1.id, u1.StaffName as staffName,u1.StaffStatus, u1.MobileNo as mobileNo, u1.tagged_latitude, u1.tagged_longitude, u2.id as distributor_id, u2.StaffName as distributor_name, u1.approval_status from logi_user as u1 left join logi_user as u2 on (u1.parent_distributer = u2.id) where u1.Role = 'Retailer' and u1.StaffStatus = 'AC'  and u1.parent_regional_manager = '" . $user . "' $search_cond";
        }

        if($role=='ZM'){
            $query = "select u1.category, u1.Address_Curr, u1.id, u1.StaffName as staffName, u1.StaffStatus,u1.MobileNo as mobileNo, u1.tagged_latitude, u1.tagged_longitude, u2.id as distributor_id, u2.StaffName as distributor_name , u1.approval_status from logi_user as u1 left join logi_user as u2 on (u1.parent_distributer = u2.id) where u1.Role = 'Retailer' and u1.StaffStatus =  'AC'  and u1.parent_zonal_manager = '" . $user . "' $search_cond";
        }
        if($role=='ASM'){
          // $ids = join("','",$area_array); 
         $query = "select u1.category, u1.Address_Curr, u1.id, u1.StaffName as staffName,u1.StaffStatus, u1.MobileNo as mobileNo, u1.tagged_latitude, u1.tagged_longitude,u1.area_id,u2.id as distributor_id, u2.StaffName as distributor_name , u1.approval_status from logi_user as u1 left join logi_user as u2 on (u1.parent_distributer = u2.id) where u1.Role = 'Retailer' and u1.StaffStatus =  'AC'  and u1.area_id IN (select id from logi_user_location_mapping WHERE  location_id in ($ids) )   $search_cond"; 
     } 
     if($role =='Sales'){
        $query ="select u1.category, u1.Address_Curr, u1.id, u1.StaffName as staffName,u1.StaffStatus, u1.MobileNo as mobileNo, u1.tagged_latitude, u1.tagged_longitude,u1.area_id,u2.id as distributor_id, u2.StaffName as distributor_name , u1.approval_status from logi_user as u1 left join logi_user as u2 on (u1.parent_distributer = u2.id) where u1.Role = 'Retailer' and u1.StaffStatus =  'AC' and u1.area_id IN (select id from logi_user_location_mapping WHERE location_id in ($ids) )  $search_cond";

    }
    $result = $db->fetchAll($query);

    $final_array = array();
    $curr_date = date('Y-m-d'); 
    foreach($result  as $data){
        $check_in_sql = "select * from retailer_check_in_out where retailer = '".$data['id']."' and saleperson = '".$user."' and date(timedate) = '".$curr_date."' order by id desc limit 1";
        $resultCheckIn = $db->fetchRow($check_in_sql);
        if(!$resultCheckIn){
            $visit_status = 'Not found';
        }
        else{
            $visit_status = $resultCheckIn['status'];
        }

        $sql_get_location_id = "select location_id from logi_user_location_mapping where id  = '".$data['area_id']."'";
        $res_location_id   = $db->fetchRow($sql_get_location_id);
        $detail_array = array('category'=>$data['category'], 'Address_Curr'=>$data['Address_Curr'], 'id'=>$data['id'], 'staffName'=>$data['staffName'], 'mobileNo'=>$data['mobileNo'], 'tagged_latitude'=>$data['tagged_latitude'], 'tagged_longitude'=>$data['tagged_longitude'], 'distributor_id'=>$data['distributor_id'], 'distributor_name'=>$data['distributor_name'], 'approval_status'=>$data['approval_status'],'locationid'=>$res_location_id['location_id'], 'visit_status'=>$visit_status);
        array_push($final_array, $detail_array);
    }
    return $final_array;
}


public function checkCountRetailerLocation($retailer){
    $db    = Zend_Db_Table::getDefaultAdapter();
    $query = "select count(id) as number from retailers_site_location where retailer_id = '" . $retailer . "'";
    return $result = $db->fetchRow($query);
}


public function getShiftDetail(){
    $db    = Zend_Db_Table::getDefaultAdapter();
    $query = "select * from logi_shift";
    return $result = $db->fetchAll($query);
}

public function getChildUsersDetail($id, $Role){
    $db              = Zend_Db_Table::getDefaultAdapter();
    $distributerList = array();

    if ($Role == "RM") {
        $query_distributer_detail = "select id as distributer_id, LoginID as Distributer_loginId,StaffName as distributer_name, state, DistrictID as district from logi_user where   parent_regional_manager = '" . $id . "' and Role =  'Distributer'";
    }

    else if($Role == "ZM"){
       $query_distributer_detail = "select id as distributer_id, LoginID as Distributer_loginId,StaffName as distributer_name, state, DistrictID as district from logi_user where   parent_zonal_manager = '" . $id . "' and Role =  'Distributer'"; 
   }

   else if($Role == "ASM"){
       $query_distributer_detail = "select id as distributer_id, LoginID as Distributer_loginId,StaffName as distributer_name, state, DistrictID as district from logi_user where   parent_area_manager = '" . $id . "' and Role =  'Distributer'"; 
   }

   else if($Role == "Sales"){
       $query_distributer_detail = "select id as distributer_id, LoginID as Distributer_loginId,StaffName as distributer_name, state, DistrictID as district from logi_user where   parent_sale = '" . $id . "' and Role =  'Distributer'"; 
   } 

   else {
    $query_distributer_detail = "select id as distributer_id, LoginID as Distributer_loginId,StaffName as distributer_name, state, DistrictID as district from logi_user where   parent_tse = '" . $id . "' and Role =  'Distributer'";
}

$result = $db->fetchAll($query_distributer_detail);
foreach ($result as $val) {
    $query_retailers_detail  = "select id as serverGeneratedId, approval_status, local_generated_id, category,  tag_status, id as retailer_id, StaffName as retailer_name, MobileNo as mobileNo,  Address_Per as address, Gender as gender , Email as email, tagged_latitude, tagged_longitude from logi_user where parent_distributer = '" . $val['distributer_id'] . "' and Role = 'Retailer' limit 1000";
    $resultretailer          = $db->fetchAll($query_retailers_detail);

    $query_vansale_detail    = "select  id as staff_id, StaffName as staff_name, MobileNo as mobileNo,  Address_Per as address, Gender as gender , Email as email from logi_user where parent_distributer = '" . $val['distributer_id'] . "' and Role = 'van_sale'";
    $resultvansale           = $db->fetchAll($query_vansale_detail);

    $query_product_dtail     = "select product.id as product_id, subproduct.id as sub_product_id, product.product_name,subproduct.sub_product_name, ldp.retailer_rate as rate from logi_distributer_products as ldp left join logi_product as product on (ldp.product_id = product.id)  left join sub_product as subproduct on (ldp.sub_product_id = subproduct.id) where ldp.distributer_id ='" . $val['Distributer_loginId'] . "'";
    $result_query_product_dtail = $db->fetchAll($query_product_dtail);

    $distributer_detail = array(
        'distributer_id'     => $val["distributer_id"],
        'distributer_name'   => $val["distributer_name"],
        'state'              => $val["state"],
        'district'           => $val["district"],
        'retailer_list'      => $resultretailer,
        'van_sale_user_list' => $resultvansale,
        'product_detail'     => $result_query_product_dtail,

    );
    array_push($distributerList, $distributer_detail);
}
return $distributerList;
}



public function getUserDetailById($distributer){
    $db    = Zend_Db_Table::getDefaultAdapter();
    $query = "select * from logi_user where id = '" . $distributer . "'";

    return $result = $db->fetchRow($query);
}



public function getOrderIdByOrderCode($order_code){
    $db    = Zend_Db_Table::getDefaultAdapter();
    $query = "select * from logi_order where code = '" . $order_code . "'";
    return $result = $db->fetchRow($query);
}



public function deleteOrderItem($order_id){
    $db    = Zend_Db_Table::getDefaultAdapter();
    $query = "delete from  logi_order_item where  order_id = '" . $order_id . "'";
    $db->query($query);
}



public function getTotalOrderCount($role, $user){
    $db = Zend_Db_Table::getDefaultAdapter();
    if ($role == "Manager") {
        $user_list = $user['distributor_person_list'];
        $cond .= "and distributer_code IN ($user_list)";
    }
    $query = "select count(id) as total_count from  logi_order where 1 $cond";
    return $result = $db->fetchRow($query);
}


public function getTotalProcessOrderCount($role, $user){
    $db   = Zend_Db_Table::getDefaultAdapter();
    $user = $user['distributor_person_list'];
    if ($role == 'Manager' || $role == 'Sales') {
        $cond .= "and distributer_code in ($user)";
    }
    $query = "select count(id) as total_count from  logi_order where  status = 'process' $cond";

    return $result = $db->fetchRow($query);
}


public function getTotalDeliveredOrderCount($role, $user){
    $db = Zend_Db_Table::getDefaultAdapter();
    if ($role == "Distributer") {
        $cond .= "and distributer_code ='" . $user . "'";
    }
    $query = "select count(id) as total_count from  logi_order where  status = 'deliverd' $cond";
    return $result = $db->fetchRow($query);
}


public function getTotalDeclineOrderCount($role, $user){
    $db = Zend_Db_Table::getDefaultAdapter();
    if ($role == "Distributer") {
        $cond .= "and distributer_code ='" . $user . "'";
    }
    $query = "select count(id) as total_count from  logi_order where  status = 'decline' $cond";
    return $result = $db->fetchRow($query);
}


public function getTotalSalesPersonCount($role, $id){
    $db = Zend_Db_Table::getDefaultAdapter();

    if ($role == 'super_admin') {
        $user_cond .= "";
    }

    if ($role == 'RM') {
        $user_cond .= "and parent_regional_manager = '" . $id . "' ";
    }

    if ($role == 'ZM') {
        $user_cond .= "and parent_zonal_manager = '" . $id . "' ";
    }

    if ($role == 'ASM') {
        $user_cond .= "and parent_area_manager = '" . $id . "' ";
    }

    if ($role == 'Sales') {
        $user_cond .= "and parent_sale = '" . $id . "' ";
    }

    $query = "select count(id) as total_count from  logi_user where  Role = 'Sales' $user_cond $cond";
    return $result = $db->fetchRow($query);
}


public function getTotalDistributorPersonCount($role, $id){
    $db = Zend_Db_Table::getDefaultAdapter();

    if ($role == 'super_admin') {
        $user_cond .= "";
    }

    if ($role == 'RM') {
        $user_cond .= "and parent_regional_manager = '" . $id . "' ";
    }

    if ($role == 'ZM') {
        $user_cond .= "and parent_zonal_manager = '" . $id . "' ";
    }

    if ($role == 'ASM') {
        $user_cond .= "and parent_area_manager = '" . $id . "' ";
    }

    if ($role == 'Sales') {
        $user_cond .= "and parent_sale = '" . $id . "' ";
    }

    $query = "select count(id) as total_count from  logi_user where  Role = 'Distributer' $cond $user_cond";
    return $result = $db->fetchRow($query);
}

public function getTotalRetailerCount($role, $id){
    $db = Zend_Db_Table::getDefaultAdapter();

    if ($role == 'super_admin') {
        $user_cond .= "";
    }

    if ($role == 'RM') {
        $user_cond .= "and parent_regional_manager = '" . $id . "' ";
    }

    if ($role == 'ZM') {
        $user_cond .= "and parent_zonal_manager = '" . $id . "' ";
    }

    if ($role == 'ASM') {
        $user_cond .= "and parent_area_manager = '" . $id . "' ";
    }

    if ($role == 'Sales') {
        $user_cond .= "and parent_sale = '" . $id . "' ";
    }

    $query = "select count(id) as total_count from  logi_user where  Role = 'Retailer' $cond $user_cond";
    return $result = $db->fetchRow($query);
}


public function getStateList(){
    $db    = Zend_Db_Table::getDefaultAdapter();
    $query = "select * from  state";
    return $result = $db->fetchAll($query);
}

    // public function getDistrictList(){    
    //     $db =  Zend_Db_Table::getDefaultAdapter();
    //     $query = "select * from  district where state = '1'";
    //     return $result = $db->fetchAll($query); 
    // }

public function getDistrictList($stateId){
    $db     = Zend_Db_Table::getDefaultAdapter();
    $query  = " select  * from district where state='" . $stateId . "' ";
    $result = $db->fetchAll($query);

    $district = array();
    foreach ($result as $value) {
        $query_sales  = " select  count(id) as totalSalesUsers from logi_user where DistrictID='" . $value['id'] . "' and Role='Sales' ";
        $result_sales = $db->fetchRow($query_sales);

        $query_distributer  = " select  count(id) as totalDistributerUsers from logi_user where DistrictID='" . $value['id'] . "' and Role='Distributer' ";
        $result_distributer = $db->fetchRow($query_distributer);

        $query_retailer  = " select  count(id) as totalRetailerUsers from logi_user where DistrictID='" . $value['id'] . "' and Role='Retailer'";
        $result_retailer = $db->fetchRow($query_retailer);

        $districtData = array(
            'id' => $value['id'],
            'state_id' => $value['state'],
            'district_name' => $value['district'],
            'salesUserCount' => $result_sales['totalSalesUsers'],
            'distributerCount' => $result_distributer['totalDistributerUsers'],
            'retailerCount' => $result_retailer['totalRetailerUsers']
        );
        array_push($district, $districtData);
    }
    return $district;
}

public function getUserStatusCount($role, $id){
    $db = Zend_Db_Table::getDefaultAdapter();

    if ($role == 'super_admin') {
        $user_cond .= "";
    }

    if ($role == 'RM') {
        $user_cond .= "and parent_regional_manager = '" . $id . "' ";
    }

    if ($role == 'ZM') {
        $user_cond .= "and parent_zonal_manager = '" . $id . "' ";
    }

    if ($role == 'ASM') {
        $user_cond .= "and parent_area_manager = '" . $id . "' ";
    }

    if ($role == 'Sales') {
        $user_cond .= "and parent_sale = '" . $id . "' ";
    }

    $date   = date("Y-m-d H:i:s");
    $query  = "select count(id) as totalonline  from logi_user where TIMESTAMPDIFF(MINUTE,Last_location_service_hit_time,'" . $date . "') < 20  and StaffStatus = 'AC' $user_cond and Role !='Retailer'";
    $result = $db->fetchRow($query);

    $query_user  = "select count(id) as totalUser  from logi_user where StaffStatus = 'AC' $user_cond and Role !='Retailer'";
    $result_user = $db->fetchRow($query_user);

    $offline = $result_user['totalUser'] - $result['totalonline'];
    $online  = $result['totalonline'];

    $onlineOffline = array(
        'online' => $online,
        'offline' => $offline
    );
    return $onlineOffline;
}

public function getUserList($type){
    $db = Zend_Db_Table::getDefaultAdapter();

    $date = date("Y-m-d H:i:s");
    if ($type == 'online') {
        $query = "select *  from logi_user where TIMESTAMPDIFF(MINUTE,Last_location_service_hit_time,'" . $date . "') < 15  and Role='Sales' and StaffStatus = 'AC'";

    } elseif ($type == 'offline') {
        $query_offline  = "select *  from logi_user where TIMESTAMPDIFF(MINUTE,Last_location_service_hit_time,'" . $date . "') < 15  and Role='Sales' and StaffStatus = 'AC'";
        $result_offline = $db->fetchAll($query_offline);


        $user_array = array();
        foreach ($result_offline as $val) {
            array_push($user_array, "'" . $val['id'] . "'");
        }

        $userId = implode(',', $user_array);
        if ($user_array) {
            $query = "select *  from logi_user where id not in($userId)  and Role IN ('Sales', 'TSE') and StaffStatus = 'AC'";
        } else {
            $query = "select *  from logi_user where Role='Sales' and StaffStatus = 'AC'";
        }


    } elseif ($type == 'moving') {
        $query = "select *  from logi_user where TIMESTAMPDIFF(MINUTE,Last_location_service_hit_time,'" . $date . "') < 20  and Role IN ('Sales', 'TSE') and moving_status='1' and StaffStatus = 'AC'";

    } elseif ($type == 'notMoving') {
        $query_moving  = "select *  from logi_user where TIMESTAMPDIFF(MINUTE,Last_location_service_hit_time,'" . $date . "') < 20  and Role='Sales' and moving_status='1' and StaffStatus = 'AC'";
        $result_moving = $db->fetchAll($query_moving);

        $user_array = array();
        foreach ($result_moving as $val) {
            array_push($user_array, "'" . $val['id'] . "'");
        }

        $userId = implode(',', $user_array);
        if ($user_array) {
            $query = "select *  from logi_user where TIMESTAMPDIFF(MINUTE,Last_location_service_hit_time,'" . $date . "') < 20  and id not in($userId)  and Role IN ('Sales', 'TSE') and StaffStatus = 'AC'";
        } else {
            $query = "select *  from logi_user where TIMESTAMPDIFF(MINUTE,Last_location_service_hit_time,'" . $date . "') < 20  and Role IN ('Sales', 'TSE') and StaffStatus = 'AC'";
        }

    } elseif ($type == 'GPSOn') {
        $query = "select *  from logi_user where TIMESTAMPDIFF(MINUTE,Last_location_service_hit_time,'" . $date . "') < 20  and Role IN ('Sales', 'TSE') and StaffStatus = 'AC'";

    } elseif ($type == 'GPSOff') {
        $query_offline  = "select *  from logi_user where TIMESTAMPDIFF(MINUTE,Last_location_service_hit_time,'" . $date . "') < 20  and Role IN ('Sales', 'TSE') and StaffStatus = 'AC'";
        $result_offline = $db->fetchAll($query_offline);


        $user_array = array();
        foreach ($result_offline as $val) {
            array_push($user_array, "'" . $val['id'] . "'");
        }

        $userId = implode(',', $user_array);
        if ($user_array) {
            $query = "select *  from logi_user where id not in($userId)  and Role IN ('Sales', 'TSE') and StaffStatus = 'AC'";
        } else {
            $query = "select *  from logi_user where Role='Sales' and StaffStatus = 'AC'";
        }

    } elseif ($type == 'network') {
        $query = "select * from logi_user where TIMESTAMPDIFF(MINUTE,Last_location_service_hit_time,'" . $date . "') < 20  and Role IN ('Sales', 'TSE') and network_status='1' and StaffStatus = 'AC'";

    } elseif ($type == 'noNetwork') {
        $query = "select *  from logi_user where TIMESTAMPDIFF(MINUTE,Last_location_service_hit_time,'" . $date . "') < 20  and Role IN ('Sales', 'TSE') and network_status='0' and StaffStatus = 'AC'";

    } elseif ($type == 'low') {
        $query = "select * from logi_user where  TIMESTAMPDIFF(MINUTE,Last_location_service_hit_time,'" . $date . "') < 20  and Role IN ('Sales', 'TSE') and battery_status<33";

    } elseif ($type == 'medium') {
        $query = "select * from logi_user where  TIMESTAMPDIFF(MINUTE,Last_location_service_hit_time,'" . $date . "') < 20  and Role IN ('Sales', 'TSE') and battery_status>33 and battery_status<60";

    } elseif ($type == 'full') {
        $query = "select * from logi_user where  TIMESTAMPDIFF(MINUTE,Last_location_service_hit_time,'" . $date . "') < 20  and Role IN ('Sales', 'TSE') and battery_status>60";

    }
    $result = $db->fetchAll($query);
        // echo '<pre>';
        // print_r($result);
        // exit();
    return $result;
}

public function getSalesPersonList($role, $id){
    $db    = Zend_Db_Table::getDefaultAdapter();

    if ($role == 'super_admin') {
        $user_cond .= "";
    }

    if ($role == 'RM') {
        $user_cond .= "and parent_regional_manager = '" . $id . "' ";
    }

    if ($role == 'ZM') {
        $user_cond .= "and parent_zonal_manager = '" . $id . "' ";
    }

    if ($role == 'ASM') {
        $user_cond .= "and parent_area_manager = '" . $id . "' ";
    }

    if ($role == 'Sales') {
        $user_cond .= "and parent_sale = '" . $id . "' ";
    }
    $query = "select id, StaffName from logi_user where Role='Sales' $user_cond order by StaffName ASC";
    return $db->fetchAll($query);
}

public function getSalesPersonDetails($day, $month, $year, $userId)
{
    $db     = Zend_Db_Table::getDefaultAdapter();
    $date   = $year . '-' . $month . '-' . $day;
    $query  = "select * from logi_user where id='" . $userId . "'";
    $result = $db->fetchRow($query);

    $query_retailer  = "select count(id) as totalAddRetailer from logi_user where DATE(Created)='" . $date . "' and  parent_sale='" . $result['id'] . "' and Role='Retailer'";
    $result_retailer = $db->fetchRow($query_retailer);

    $query_tagged_retailer  = "select count(id) as totalTagRetailer from retailers_site_location where sale_person_id = '" . $result['id'] . "' and DATE(taging_date)='" . $date . "'";
    $result_tagged_retailer = $db->fetchRow($query_tagged_retailer);

    $query_order  = "select count(id) as totalOrder from logi_order where sale_person_id = '" . $result['id'] . "' and DATE(order_date)='" . $date . "'";
    $result_order = $db->fetchRow($query_order);

    $user = array(
        'id' => $result['id'],
        'LoginID' => $result['LoginID'],
        'StaffName' => $result['StaffName'],
        'Role' => $result['Role'],
        'latitude' => $result['lat'],
        'longitude' => $result['long'],
        'batteryStatus' => $result['battery_status'],
        'totalAddRetailer' => $result_retailer['totalAddRetailer'],
        'totalTagRetailer' => $result_tagged_retailer['totalTagRetailer'],
        'totalOrder' => $result_order['totalOrder'],
        'employee_code' => $result['employee_code']
    );

    return $user;
}

public function getChildListByWebLoginId($id, $role)
{
    $db = Zend_Db_Table::getDefaultAdapter();

    if ($role == 'Manager') {
        $query = "select id, LoginID, Role  from  logi_user  where  manager ='" . $id . "'";
    } else if ($role = 'Sales') {
        $query = "select id, LoginID, Role  from  logi_user where  parent_sale ='" . $id . "' and Role = 'Distributer'";
    }

    $result = $db->fetchAll($query);
    if ($result) {
        $array_sale_persons           = array();
        $array_distributor_persons    = array();
        $array_distributor_persons_id = array();
        $array_sales_persons_id       = array();
        foreach ($result as $data) {
            if ($data['Role'] == 'Sales') {
                array_push($array_sale_persons, "'" . $data['LoginID'] . "'");
                array_push($array_sales_persons_id, "'" . $data['id'] . "'");
            } else if ($data['Role'] == 'Distributer') {
                array_push($array_distributor_persons, "'" . $data['LoginID'] . "'");
                array_push($array_distributor_persons_id, "'" . $data['id'] . "'");
            }
        }
        if ($array_sale_persons) {
            $sale_person_list = implode(',', $array_sale_persons);
        }
        if ($array_distributor_persons) {
            $distributor_person_list = implode(',', $array_distributor_persons);
        }

        if ($array_distributor_persons_id) {
            $distributor_person_id_list = implode(',', $array_distributor_persons_id);
        }

        if ($array_sales_persons_id) {
            $sale_person_id_list = implode(',', $array_sales_persons_id);
        }

        $array_list = array(
            'sale_person_list' => $sale_person_list,
            'distributor_person_list' => $distributor_person_list,
            'sale_person_id_list' => $sale_person_id_list,
            'distributor_person_id_list' => $distributor_person_id_list
        );

        return $array_list;
    }
}

public function getConfigurationData()
{
    $db    = Zend_Db_Table::getDefaultAdapter();
    $query = "select gps_frequency, logout_time from logi_configuration where 1";
    return $result = $db->fetchRow($query);
}

public function getDistributorRoute($id)
{
    $db    = Zend_Db_Table::getDefaultAdapter();
    $query = "select t.town_name, r.route_name from tbl_user_route_mapping as trm left join tbl_route as r on (r.id = trm.route_id) left join
    tbl_route_town as t on (trm.town_id = t.id) where trm.distributor_person_id = '" . $id . "'";
    return $result = $db->fetchRow($query);
}

public function getSurveyType()
{
    $db    = Zend_Db_Table::getDefaultAdapter();
    $query = "select * from tbl_survey_type where status = '0'";
    return $result = $db->fetchAll($query);
}

public function getBrandType()
{
    $db    = Zend_Db_Table::getDefaultAdapter();
    $query = "select * from tbl_brand where status = '0'";
    return $result = $db->fetchAll($query);
}

public function getDistributorListForSurvey()
{
    $db    = Zend_Db_Table::getDefaultAdapter();
    $query = "select * from logi_user where Role = 'Distributer'";
    return $result = $db->fetchAll($query);
}


public function getNatureOfBussiness()
{
    $db    = Zend_Db_Table::getDefaultAdapter();
    $query = "select * from tbl_nature_of_bussiness where status = '0'";
    return $result = $db->fetchAll($query);
}


public function getReachAtSiteDateTime($retailer, $sale, $notidate)
{
    $db    = Zend_Db_Table::getDefaultAdapter();
    $query = "select * from logi_notification where retailer_id = '" . $retailer . "' and app_user_id = '" . $sale . "' and date(notification_date_time) = '" . $notidate . "' and notification_type = '0' order by id asc limit 1";
    return $result = $db->fetchRow($query);
}

public function getMoveFromSiteDateTime($retailer, $sale, $notidate)
{
    $db    = Zend_Db_Table::getDefaultAdapter();
    $query = "select * from logi_notification where retailer_id = '" . $retailer . "' and app_user_id = '" . $sale . "' and date(notification_date_time) = '" . $notidate . "' and notification_type = '1' order by id desc limit 1";
    return $result = $db->fetchRow($query);
    ;
}

public function checkDistributorProductMapping($id)
{
    $db    = Zend_Db_Table::getDefaultAdapter();
    $query = "select * from logi_distributer_products where distributer_id = '" . $id . "'";
    return $result = $db->fetchAll($query);
}

public function getSubProductListByProductId($id)
{
    $db    = Zend_Db_Table::getDefaultAdapter();
    $query = "select * from sub_product where product_id = '" . $id . "' order by product_id";
    return $result = $db->fetchAll($query);
}


public function getUserTypeCount($role, $id){
    $db    = Zend_Db_Table::getDefaultAdapter();

    if ($role == 'super_admin') {
        $user_cond .= "";
    }

    if ($role == 'RM') {
        $user_cond .= "and parent_regional_manager = '" . $id . "' ";
    }

    if ($role == 'ZM') {
        $user_cond .= "and parent_zonal_manager = '" . $id . "' ";
    }

    if ($role == 'ASM') {
        $user_cond .= "and parent_area_manager = '" . $id . "' ";
    }

    if ($role == 'Sales') {
        $user_cond .= "and parent_sale = '" . $id . "' ";
    }

    $query_rm  = "select count(id) as user_count from logi_user where Role='RM' and StaffStatus = 'AC'";
    $result_rm =  $db->fetchRow($query_rm);

    $query_zm  = "select count(id) as user_count from logi_user where Role='ZM' and $user_cond StaffStatus = 'AC'";
    $result_zm =  $db->fetchRow($query_zm);

    $query_asm  = "select count(id) as user_count from logi_user where Role='ASM' $user_cond and StaffStatus = 'AC'";
    $result_asm  =  $db->fetchRow($query_asm);

    $query_tsi  = "select count(id) as user_count from logi_user where Role='Sales' $user_cond and StaffStatus = 'AC'";
    $result_tsi  =  $db->fetchRow($query_tsi);

    $query_distributor  = "select count(id) as user_count from logi_user where Role='distributer' $user_cond and StaffStatus = 'AC'";
    $result_distributor =  $db->fetchRow($query_distributor);

    $query_retailer  = "select count(id) as user_count from logi_user where Role='retailer' $user_cond and StaffStatus = 'AC'";
    $result_retailer =  $db->fetchRow($query_retailer);

    $data = array('tot_rm_count'=>$result_rm['user_count'], 'tot_zm_count'=>$result_zm['user_count'], 'tot_asm_count'=>$result_asm['user_count'], 'tot_tsi_count'=>$result_tsi['user_count'], 'tot_distributor_count'=>$result_distributor['user_count'], 'tot_retailer_count'=>$result_retailer['user_count']);

    return $data;
}


public function dateWiseRetailerActivity($role, $id){
    $db    = Zend_Db_Table::getDefaultAdapter();

    if ($role == 'super_admin') {
        $user_cond .= "";
    }

    if ($role == 'RM') {
        $user_cond .= "and parent_regional_manager = '" . $id . "' ";
    }

    if ($role == 'ZM') {
        $user_cond .= "and parent_zonal_manager = '" . $id . "' ";
    }

    if ($role == 'ASM') {
        $user_cond .= "and parent_area_manager = '" . $id . "' ";
    }

    if ($role == 'Sales') {
        $user_cond .= "and parent_sale = '" . $id . "' ";
    }


    $curr_date = date('Y-m-d');
    

    $query_retailer  = "select count(id) as user_count from logi_user where Role='retailer' $user_cond and StaffStatus = 'AC' and date(Created) = '".$curr_date."'";
    $result_retailer =  $db->fetchRow($query_retailer);

    $query_tagged_retailer  = "select count(id) as user_count from retailers_site_location where 1 $user_cond  and date(taging_date) = '".$curr_date."'";
    $result_result_tagged   =  $db->fetchRow($query_tagged_retailer);



    $data = array('today_retailer'=>$result_retailer['user_count'], 'today_tagged_retailer'=>$result_result_tagged['user_count']);

    return $data;
}
}
