<?php

/***************************************************************
 * Logimetrix Techsolution Pvt. Ltd.
 * File Name   : Model.php
 * File Description  : Model Method
 * Created By : Puneet Mishra
 * Created Date: 01 May 2018
 ***************************************************************/

class Application_Model_Model extends Zend_Db_Table_Abstract{

	public function getUserLoginDetailByWebLoginCode($WebLoginID){ 
		$db =  Zend_Db_Table::getDefaultAdapter();
		$query = "SELECT * FROM logi_user_login_detail WHERE WebLoginID=?";  
		return $result = $db->fetchRow($query, array($WebLoginID));
	}

	public function GetLastID(){
		$db =  Zend_Db_Table::getDefaultAdapter();
		$query = "select id from  logi_user order by id desc limit 1 ";          
		return $result = $db->fetchRow($query);
	}

	public function getUserListByLogiDetail($role, $id){
		$db =  Zend_Db_Table::getDefaultAdapter();
		if($role=='super_admin'){
			$role_cond .="and Role = 'RM'";
		}
		if($role=='RM'){
			$role_cond .="and Role = 'RM'   and id = '".$id."'";
		}
		if($role=='ZM'){
			$role_cond .="and Role = 'ZM'    and id = '".$id."'";
		}
		if($role=='ASM'){
			$role_cond .="and Role = 'ASM'   and id = '".$id."'";
		}
		if($role=='Sales'){
			$role_cond .="and Role = 'Sales' and id = '".$id."'";
		}
		$query = "select * from  logi_user where 1  $role_cond  and parent_id = '".$id."' order by StaffName";         
		return $result = $db->fetchAll($query);
	}

	public function getRegionalManagerList(){
		$db =  Zend_Db_Table::getDefaultAdapter();
		if($role =='RM'){
			$role_cond .=" and id = '".$id."'";
		}
		$query = "select * from  logi_user where  Role = 'RM'  $role_cond and parent_id = '".$parent_id."' order by StaffName";          
		return $result = $db->fetchAll($query);
	}

	public function getZonalHeadListByRegionalManager($rm_id, $id, $role){
		$db =  Zend_Db_Table::getDefaultAdapter();

		if($role !='super_admin' && $role !='RM' && $role =='ZM'){
			$role_cond .=" and id = '".$id."'";
		}
		$query = "select * from  logi_user where  Role = 'ZM' and md5(parent_regional_manager) = '".$rm_id."' $role_cond order by StaffName";          
		return $result = $db->fetchAll($query);
	}

	public function getAreaManagerListByZonalManager($zm_id, $id, $role){
		$db =  Zend_Db_Table::getDefaultAdapter();
		if($role !='super_admin' && $role !='RM' && $role !='ZM' && $role =='ASM'){
			$role_cond .=" and id = '".$id."'";
		}
		$query = "select * from  logi_user where  Role = 'ASM' and md5(parent_zonal_manager) = '".$zm_id."' $role_cond order by StaffName";       
		return $result = $db->fetchAll($query);
	}

	public function getSalesPersonListByAreaManager($am_id, $id, $role){
		$db =  Zend_Db_Table::getDefaultAdapter();

		if($role !='super_admin' && $role !='RM' && $role !='ZM' && $role !='ASM'){
			$role_cond .=" and id = '".$id."'";
		}

		$query = "select * from  logi_user where  Role = 'Sales' and md5(parent_area_manager) = '".$am_id."' $role_cond order by StaffName";       
		return $result = $db->fetchAll($query);
	}

	public function getDistributerListByAreaManager($am_id, $id, $role){
		$db =  Zend_Db_Table::getDefaultAdapter();

		if($role !='super_admin' && $role !='RM' && $role !='ZM' && $role !='ASM'){
			$role_cond .=" and id = '".$id."'";
		}
		$query = "select * from  logi_user where  Role = 'Distributer' and md5(parent_area_manager) = '".$am_id."' $role_cond order by StaffName";       
		return $result = $db->fetchAll($query);
	}

	public function getDistributorsBySalePersons($tsi_id){
		$db =  Zend_Db_Table::getDefaultAdapter();
		$query = "select * from  logi_user where  Role = 'Distributer' and md5(parent_sale) = '".$tsi_id."'  order by StaffName";          
		return $result = $db->fetchAll($query);
	}

	public function GETAllReatilerByDistributerId($distributor){
		$db =  Zend_Db_Table::getDefaultAdapter();
		$query = "select * from  logi_user where  Role = 'Retailer' and md5(parent_distributer) = '".$distributor."'  order by StaffName";          
		return $result = $db->fetchAll($query);
	}

	public function getStateList(){
		$db =  Zend_Db_Table::getDefaultAdapter();
		$query = "select * from state"; 
		return $result= $db->fetchAll($query);              
               // return 
	}

	public function getUserDetailtById($id){
		$db =  Zend_Db_Table::getDefaultAdapter();
		$query = "select * from  logi_user where md5(id) = '".$id."'";          
		return $result = $db->fetchRow($query);
	}

	public function getDistrictListByState($id){
		$db =  Zend_Db_Table::getDefaultAdapter();
		$query = "select * from  district where md5(state) = '".$id."' order by district";          
		return $result = $db->fetchAll($query);
	}

	public function getUserList($role, $name, $mobile, $employee_code, $login_user_role, $login_user_id, $region, $zone){
		$db =  Zend_Db_Table::getDefaultAdapter();
		if($login_user_role=='super_admin'){
            //$cond .="and Role = 'RM'";
		}
		if($login_user_role=='RM'){
			$cond .="and  u.parent_regional_manager = '".$login_user_id."'";
		}
		if($login_user_role=='ZM'){
			$cond .="and u.parent_zonal_manager = '".$login_user_id."'";
		}
		if($login_user_role=='ASM'){
			$cond .="and  u.parent_area_manager = '".$login_user_id."'";
		}
		if($login_user_role=='Sales'){
			$cond .="and  u.parent_sale = '".$login_user_id."'";
		}
		if($role){
			$cond .="and u.Role = '".$role."'";
		}
		if($name){
			$cond .="and u.StaffName like '%".$name."%'";
		}
		if($mobile){
			$cond .="and u.MobileNo like '%".$mobile."%'";
		}
		if($employee_code){
			$cond .="and u.employee_code like '%".$employee_code."%'";
		}
		//$query = "select u.*, rm.StaffName as regional_manager, zm.StaffName as zonal_manager, am.StaffName as area_manager, tsi.StaffName as tsi, dis.StaffName as distributor  from  logi_user as u left join logi_user as rm on (u.parent_regional_manager = rm.id) left join logi_user as am on (u.parent_area_manager = am.id) left join logi_user as tsi on (u.parent_sale = tsi.id) left join logi_user as dis on (u.parent_distributer = dis.id) left join logi_user as zm on (u.parent_zonal_manager = zm.id) where  1 and u.StaffStatus = 'AC' $cond and u.parent_id = '".$login_user_id."'   order by u.id desc"; 

		$query = "select u.*, rm.StaffName as regional_manager, zm.StaffName as zonal_manager, am.StaffName as area_manager, tsi.StaffName as tsi, dis.StaffName as distributor  from  logi_user as u left join logi_user as rm on (u.parent_regional_manager = rm.id) left join logi_user as am on (u.parent_area_manager = am.id) left join logi_user as tsi on (u.parent_sale = tsi.id) left join logi_user as dis on (u.parent_distributer = dis.id) left join logi_user as zm on (u.parent_zonal_manager = zm.id) where 1 $cond    order by u.id desc";       
		return $result = $db->fetchAll($query);
	}

	public function getStateDetailById($id){
		$db =  Zend_Db_Table::getDefaultAdapter();
		$query = "select * from state where id ='".$id."'"; 
		return $result= $db->fetchRow($query);              
               // return 
	}

	public function getDistrictDetailById($id){
		$db =  Zend_Db_Table::getDefaultAdapter();
		$query = "select * from district where id ='".$id."'"; 
		return $result= $db->fetchRow($query);              
               // return 
	}

	public function GetInvoiceTypeDetailById($id){
		$db =  Zend_Db_Table::getDefaultAdapter();
		$query = "select * from  invoice_type where invoice_id = '".$id."'";          
		return $result = $db->fetchRow($query);
	}

	public function getInvoiceTypeList(){
		$db =  Zend_Db_Table::getDefaultAdapter();
		$query = "select * from  invoice_type where status = '0'";          
		return $result = $db->fetchAll($query);
	}

	public function checkAllocationMappingMapping($val_sale, $curr_date){
		$db =  Zend_Db_Table::getDefaultAdapter();
		$query = "select count(id) as cnt from  tbl_product_allocation where date(allocated_date) = '".$curr_date."' and allocated_to = '".$val_sale."'";          
		return $result = $db->fetchrow($query);
	}

	public function getDistributorStrBySalesPerson($sale_person_id){
		$db =  Zend_Db_Table::getDefaultAdapter();
		$query = "select LoginID, id, StaffName from  logi_user  where parent_sale = '".$sale_person_id."' and Role= 'Distributer'";
		$result = $db->fetchAll($query);

		$distributor_array = array();
		foreach($result as $data ){
			array_push($distributor_array, "'".$data['LoginID']."'");
		}
		return $distributor_str = implode(",", $distributor_array);        
	}

	public function getDistributorProductDetail($distributor_str){
		$db =  Zend_Db_Table::getDefaultAdapter();
		$query = "select p.id, p.product_name from  sub_product as dp left join logi_product as p on (p.id = dp.product_id)   group by dp.product_id order by p.product_name";
		return $result = $db->fetchAll($query);          
	}

	public function getDistributorSubProductDetail($product_id, $distributor_str){
		$db =  Zend_Db_Table::getDefaultAdapter();
		$query = "select id, sub_product_name from  sub_product  where product_id = '".$product_id."'  order by sub_product_name";
		return $result = $db->fetchAll($query);          
	}

	public function getVehicleList($vehicle_no){
		$db =  Zend_Db_Table::getDefaultAdapter();

		if($vehicle_no){
			$cond .="and vehicle_no like '%".$vehicle_no."%'";
		}
		$query = "select * from  tbl_vehicle where status = '0' $cond";          
		return $result = $db->fetchAll($query);
	}

	public function getVehicleDetailById($vehicle_id){
		$db =  Zend_Db_Table::getDefaultAdapter();
		$query = "select * from  tbl_vehicle where md5(md5(id)) = '".$vehicle_id."'";          
		return $result = $db->fetchRow($query);
	}

	public function getVehicleMappingList(){
		$db =  Zend_Db_Table::getDefaultAdapter();
		$query = "select tbl_vehicle_mapping.* , logi_user.id as van_sale_person_id, logi_user.MobileNo ,logi_user.LoginID, logi_user.StaffName from  tbl_vehicle_mapping left join logi_user on ( logi_user.id = tbl_vehicle_mapping.user_id) where tbl_vehicle_mapping.status = '0' $cond";          
		return $result = $db->fetchAll($query);
	}

	public function getUnMappedVehicleList(){
		$db =  Zend_Db_Table::getDefaultAdapter();
		$query = "select * from  tbl_vehicle where status = '0' and mapped_status !='1'";
		return $result = $db->fetchAll($query);
	}

	public function getUnMappedVanSalePersonList($van_sale_person_str){
		$db =  Zend_Db_Table::getDefaultAdapter();
		if($van_sale_person_str){
			$cond  .="and id not in ($van_sale_person_str)";
		}
		$query = "select * from  logi_user where 1 $cond and Role = 'van_sale'";          
		return $result = $db->fetchAll($query);
	}

	public function getVehicleMappigDetailById($mapping_id){
		$db =  Zend_Db_Table::getDefaultAdapter();
		if($mapping_id){
			$cond .="and md5(md5(tbl_vehicle_mapping.id)) = '".$mapping_id."'";
		}
		$query = "select tbl_vehicle_mapping.*, logi_user.LoginID, logi_user.StaffName from  tbl_vehicle_mapping left join logi_user on (logi_user.id = tbl_vehicle_mapping.user_id)  where tbl_vehicle_mapping.status = '0' $cond";
		return $result = $db->fetchRow($query);
	}

	public function getRegionMappingList($region_name){
		$db =  Zend_Db_Table::getDefaultAdapter();
		if($region_name){
			$cond .="and region_name like '%".$region_name."%'";
		}
		$query_region = "select id as region_id , region_name  from tbl_region where status = '1' $cond order by region_name";
		$result_region = $db->fetchAll($query_region);

		$region_array = array();
		if($result_region){
			foreach($result_region as $region_data){
				$query_zone = "select id as zone_id, zone_name from tbl_zone where status = '1' and region_id = '".$region_data['region_id']."' order by zone_name";
				$result_zone = $db->fetchAll($query_zone);
				$zone_array = array();
				if($result_zone){
					foreach($result_zone as $zone_data){
						$query_check_mapping = "select id from tbl_zone_state_mapping where status = '1' and zone_id = '".$zone_data['zone_id']."' order by zone_name";
						$result_check_mapping = $db->fetchAll($query_check_mapping);

						if($result_check_mapping){
							$type = "'edit'"; 
							$state_mapping_icon = '<a  href="javascript:void(0)"" data-toggle="modal" data-target="#con-close-modal" onclick="mappedStateDetail('.$zone_data["zone_id"].', '.$type.')" class="iframe"><i class="glyphicon glyphicon-pencil" title="Map state" style="color:white;"></i></a>';
						} 
						else{
							$type = "'add'"; 
							$state_mapping_icon = '<a  href="javascript:void(0)"" data-toggle="modal" data-target="#con-close-modal" onclick="mappedStateDetail('.$zone_data["zone_id"].', '.$type.')" class="iframe"><i class="glyphicon glyphicon-plus-sign" title="Map state" style="color:white;"></i></a>';
						}
						$zone = "<button class='btn btn-purple waves-effect waves-light btn-xs' >".$zone_data['zone_name']."   ".$state_mapping_icon."</button>";
						array_push($zone_array, $zone);
					}
					$zone_str  = implode(" ", $zone_array);
					$region_data = array('region_id'=>$region_data['region_id'], 'region_name'=>$region_data['region_name'],'zone_detail'=>$zone_str);
					array_push($region_array, $region_data);      
				}   
			}
		}
		return $region_array;
	}

	public function getWarehouseList(){
		$db =  Zend_Db_Table::getDefaultAdapter();
		$query = "select * from  logi_warehouse where status = '1'";
		return $result = $db->fetchAll($query);
	}

	public function getZoneDetailById($zone_id){
		$db =  Zend_Db_Table::getDefaultAdapter();
		$query = "select * from  tbl_zone where id = '".$zone_id."'";
		return $result = $db->fetchRow($query);
	}

	public function getUnmappedStateList($zone_id, $type){
		$db =  Zend_Db_Table::getDefaultAdapter();

		if($type =='add'){
			$mapped_state = "select * from tbl_zone_state_mapping where status = '1' group by state_id ";
			$result_state = $db->fetchAll($mapped_state);
			$array_mapped_state = array();
			if($result_state){
				foreach($result_state as $mapped_state_data){
					array_push($array_mapped_state, "'".$mapped_state_data['state_id']."'");
				}
				$mapped_array_str = implode(",", $array_mapped_state);
				$query = "select * from  state where id not in ($mapped_array_str) ";
			}
			else{
				$query = "select * from  state";
			}
			$result = $db->fetchAll($query);    
		}
		elseif($type =='edit'){
			$mapped_state = "select * from tbl_zone_state_mapping where (status = '1' and zone_id != '".$zone_id."') group by state_id ";
			$result_state = $db->fetchAll($mapped_state);

			$array_mapped_state = array();
			if($result_state){
				foreach($result_state as $mapped_state_data){
					array_push($array_mapped_state, "'".$mapped_state_data['state_id']."'");
				}
				$mapped_array_str = implode(",", $array_mapped_state);
				$query = "select * from  state where id not in ($mapped_array_str) ";
			}
			else{
				$query = "select * from  state";
			}
			$result = $db->fetchAll($query);

		}
		return $result;
	}

	public function getMappedStateWithZone($zone_id){
		$db =  Zend_Db_Table::getDefaultAdapter();
		$query = "select * from  tbl_zone_state_mapping where zone_id = '".$zone_id."' and  status = '1'";
		$result = $db->fetchAll($query);

		$array_mapped_state = array();
		foreach($result as $state_data){
			array_push($array_mapped_state, $state_data['state_id']);
		}
		return $array_mapped_state;
	}

	public function getRegionDetailById($region_id){
		$db =  Zend_Db_Table::getDefaultAdapter();
		$query_region = "select * from  tbl_region where md5(md5(id)) = '".$region_id."'";
		$result_region = $db->fetchRow($query_region);

		$query_zone = "select id as zone_id, zone_name from  tbl_zone where region_id = '".$result_region['id']."' and status = '1'";
		$result_zone = $db->fetchAll($query_zone);

		return array('region_id'=>$result_region['id'], 'region_name'=>$result_region['region_name'], 'zone_list'=>$result_zone);
	}

	public function getBmcDetailById($user_id){
		$db =  Zend_Db_Table::getDefaultAdapter();
		$query_user = "select * from  logi_user where md5(md5(id)) = '".$user_id."'";
		$result_user = $db->fetchRow($query_user);
		return array('user_id'=>$result_user['id'], 'StaffName'=>$result_user['StaffName']);
	}

	public function getRegionList(){
		$db =  Zend_Db_Table::getDefaultAdapter();
		$query_region = "select * from  tbl_region where status = '1'";
		return $result_region = $db->fetchAll($query_region);
	}

	public function getFieldUserStateList(){
		$db =  Zend_Db_Table::getDefaultAdapter();
		$query = "select s.id as state_id, s.state as state_name from logi_user as u left join state as s on (s.id = u.state)  group by u.state";
		return $result = $db->fetchAll($query);
	}

	public function getUserDistrictList($state_id){
		$db =  Zend_Db_Table::getDefaultAdapter();
		$query = "select d.id as district_id, d.district as district_name from logi_user as u left join district as d on (d.id = u.DistrictID) where u.state = '".$state_id."' and Role ='Sales' group by u.DistrictID";
		return $result = $db->fetchAll($query);
	}

	public function getSalepersonByStateDistrict($state_id, $district_id){
		$db =  Zend_Db_Table::getDefaultAdapter();

		if($state_id){
			$cond .="and state = '".$state_id."'";
		}
		if($district_id){
			$cond .="and DistrictID = '".$district_id."'";
		}
		$query = "select id, LoginID, StaffName from logi_user where 1 and Role = 'Sales' $cond";
		return $result = $db->fetchAll($query);
	}

	public function getSalesPersonOpeningClosing($tsi_id){
		$db =  Zend_Db_Table::getDefaultAdapter();
		$curr_date = date("Y-m-d");

		$userQuery  = "select id, LoginID, StaffName from logi_user where 1 and id = '".$tsi_id."'";
		$resultUser = $db->fetchRow($userQuery);

		$queryDayStart  = "select id, add_date_time as noti_date, lat as latitude, `long` as longitude from user_path where date(add_date_time) = '".$curr_date."' and mob_user_staff_code = '".$resultUser['LoginID']."'  order by id asc limit 1";
		$resultDayStart = $db->fetchRow($queryDayStart);

		$queryDayEnd  = "select id, add_date_time as noti_date, lat as latitude, `long` as longitude from user_path where date(add_date_time) = '".$curr_date."' and mob_user_staff_code = '".$resultUser['LoginID']."'  order by id desc limit 1";
		$resultDayEnd = $db->fetchRow($queryDayEnd);

		$dayStartLocation = $resultDayStart['latitude'].'/'.$resultDayStart['longitude'];
		if($resultDayEnd['latitude'] && $resultDayStart['longitude']){
			$dayEndLocation = $resultDayEnd['latitude'].'/'.$resultDayEnd['longitude'];
		}
		return $finalResult = array('start_location'=>$dayStartLocation, 'end_location'=>$dayEndLocation);
	}

	public function checkOrderIndent($retailer_id){
		$db        =  Zend_Db_Table::getDefaultAdapter();
		$curr_date = date('Y-m-d');
		
		$query = "select date(generated_date) as last_order_indent_date from  tbl_order_indent where retailer_id = '".$retailer_id."' order by id desc limit 1";           
		$result = $db->fetchRow($query);

		if($result){
			$start_date = $curr_date;
			$end_date   = $result['last_order_indent_date'];
			$days_between = ceil(abs($end_date   - $start_date) / 86400);
			
			if($days_between > '1'  && $days_between < '4'){
				$color_code = '#F8FEA7';
			}
			else if($days_between > '3'){
				$color_code = '#FB8E2D';
			}
			else{
				$color_code = '#FFFFFF';
			}			 
		}
		else{
			$color_code = '#FFFFFF';
		}
		return  array('color_code'=>$color_code);
	}
}
