<?php
class ManagerForm extends Zend_Form
{
	public function __construct($params = null)
	{
		/************ Bisiness name *****************/
		$biz_name = $this->createElement('text','biz_name')
						->setRequired(true)
						->addDecorators(array(
						'ViewHelper',
						'Errors',
						array('HtmlTag', array('tag' => 'div')),
						array('Label', array('tag' => '')),
						));
		$biz_name->addErrorMessage('Name can\'t be empty');
		if($params['biz_name'])
		$biz_name->setValue($params['biz_name']);
		/************ Email address *****************/
		$email = $this->createElement('text','email')
						->setRequired(true)
						->addFilters(array('StringTrim', 'StripTags'))
						->addValidator('EmailAddress',  TRUE  )
						->addDecorators(array(
						'ViewHelper',
						'Errors',
						array('HtmlTag', array('tag' => 'div')),
						array('Label', array('tag' => '')),
						));
		$email->addErrorMessage('Please enter a valid email address.');
		if($params['email'])
		$email->setValue($params['email']);
		/************ Phone number *****************/				
		$phone = $this->createElement('text','phone')
					->setRequired(true)
					->addValidator('Digits')
					->addValidator('stringLength', false, array(10, 10))
					->addDecorators(array(
					'ViewHelper',
					'Errors',
					array('HtmlTag', array('tag' => 'div')),
					array('Label', array('tag' => '')),
					));
		//$phone->addErrorMessage('Please enter a valid phone number.');
		
		if($params['phone'])
		$phone->setValue($params['phone']);
		
		$submit = $this->createElement('submit','Submit');
		$submit->setLabel('Submit')
				->setIgnore(true);
		
		$this->addElements(array(
		$biz_name,
		$email,
		$phone,
		$submit
		)); 
	}
}