<?php
/***************************************************************
 * Logimetrix Tech Solutions Pvt. Ltd.
 * File Name   : AccountSettingController.php
 * File Description  : Account Settings
 * Created By : Abhishek Kumar Mishra
 * Created Date: 20 June 2015
 ***************************************************************/

class WarehouseController extends Zend_Controller_Action
{

  public function init()
  {
    /* Initialize action controller here */
    $bootstrap = $this->getInvokeArg('bootstrap');
    $aConfig = $bootstrap->getOptions();
    $this->view->siteurl = $aConfig['site']['image']['url'];
    $this->dbAdapter = Zend_Db_Table::getDefaultAdapter(); 
    $auth = Zend_Auth::getInstance();
    $authStorage = $auth->getStorage();
    $this->StaffCode = $authStorage->read()->StaffCode;
    $this->role = $authStorage->read()->role;
    $users = new Application_Model_Users();

  }
  public function warehouseAction() 
  {
   $auth = Zend_Auth::getInstance();
   $authStorage = $auth->getStorage();
   $this->StaffCode = $authStorage->read()->StaffCode;
   $this->role = $authStorage->read()->role;
   $this->dbAdapter = Zend_Db_Table::getDefaultAdapter(); 
   $name = 'W00';
   try{

    $sql = "SELECT state.state,district.district, logi_warehouse.id,warehouse_name,warehouse_latitude,warehouse_longitude,CONCAT('$name','',logi_warehouse.id) AS warehousecode FROM `logi_warehouse` 
    left join state on(logi_warehouse.state_name = state.id) 
    left JOIN district ON (logi_warehouse.distict_name =district.id )
    ORDER BY logi_warehouse.id DESC
    ";
      // echo($sql);
      // exit();
    $this->view->warehouses = $warehouses = $this->dbAdapter->fetchAll($sql);
  }catch(Exception $e){
    echo $e->getMessage();
    exit;
  }
  $params = $this->getRequest()->getParams();

    // print_r($warehouses);
    // exit();
}
public function addWarehouseAction() 
{ 
  try{
   $this->dbAdapter = Zend_Db_Table::getDefaultAdapter();
   $auth = Zend_Auth::getInstance();
   $authStorage = $auth->getStorage();
   $this->StaffCode = $authStorage->read()->StaffCode;
   $this->role = $authStorage->read()->role;

   $Retailer           = new Application_Model_Retailer();
   $this->view->params = $params;
   $this->view->getStateList = $getStateList = $Retailer->getStateList();

   $params = $this->getRequest()->getParams();
   if($this->getRequest()->isPost()){
      // echo '<pre>';
      // print_r($params);
      // exit();

    $i = 0;
    foreach ($params['warehouse_name'] as $value) {
      $data = array();
      $data['State_name'] = $params['state'][$i];
      $data['distict_name'] = $params['district'][$i];
      $data['warehouse_name'] = $params['warehouse_name'][$i];
      $data['warehouse_latitude'] = $params['warehouse_latitude'][$i];
      $data['warehouse_longitude'] = $params['warehouse_longitude'][$i];
      $data['status'] = $params['status'][$i];

      $this->dbAdapter->insert('logi_warehouse', $data);

      $i++;
    }
    $this->_redirect('/warehouse/warehouse');
  }
}
catch(Exception $e){
  echo $e->getMessage();
  exit;
}
}

function getDistrictListAction()
{

  $this->checklogin();

  $this->getHelper('Layout')->disableLayout();
  $this->getHelper('ViewRenderer')->setNoRender();
  $this->getResponse()->setHeader('Content-Type', 'application/json');
  $Retailer = new Application_Model_Retailer();

  $state                  = $this->getRequest()->getParam('state');
  $district_list_unformat = $Retailer->getDistrictListStateWise($state);
  $district_list[]        = array(
    "value" => "",
    "text" => "--Select District--"
  );
  foreach ($district_list_unformat as $single) {
    $district_list[] = array(
      "value" => $single['id'],
      "text" => $single['district']
    );
  }
  echo json_encode(array(
    'options' => $district_list
  ));
  return;
}

public function editWarehouseAction() 
{
 try{
  $this->dbAdapter = Zend_Db_Table::getDefaultAdapter();
  $name = 'W00';
  $params = $this->getRequest()->getParams('id');
  $Retailer           = new Application_Model_Retailer();
  $this->view->params = $params;
  $this->view->getStateList = $getStateList = $Retailer->getStateList();
  $sql = "SELECT *, district.district FROM `logi_warehouse`
  left JOIN district ON (logi_warehouse.distict_name =district.id )
  where logi_warehouse.id = '".$params['id']."'";
  $this->view->warehouses = $warehouses = $this->dbAdapter->fetchRow($sql);
  if($this->getRequest()->isPost()){
    $data = array();
    $data['State_name'] = $params['state'];
    $data['distict_name'] = $params['district'];
    $data['warehouse_name'] = $params['warehouse_name'];
    $data['warehouse_latitude'] = $params['warehouse_latitude'];
    $data['warehouse_longitude'] = $params['warehouse_longitude'];
    $data['status'] = $params['status'];
    $where = array('id = ?' => $params['id']);
    $this->dbAdapter->update('logi_warehouse',$data,$where);
    $this->_redirect('/warehouse/warehouse');
  }
}catch(Exception $e){
  echo $e->getMessage();
  exit;
}
}



}
?>