<?php

/***************************************************************
 * Logimetrix Techsolutions Pvt. Ltd.
 * File Name   : ProductController.php
 * File Description  : ProductController
 * Created By : Puneet Mishra
 * Created Date: 25 Nov 2016
 ***************************************************************/

class VisitController extends Zend_Controller_Action{
  var $dbAdapter;
  var $db;
  public function init(){
   /* Initialize action controller here */
   $this->_flashMessenger   = $this->_helper->getHelper('FlashMessenger');
   $this->initView();
   $bootstrap = $this->getInvokeArg('bootstrap');
   $aConfig = $bootstrap->getOptions();
   $db = $this->db = Zend_Db_Table::getDefaultAdapter();
   $auth = Zend_Auth::getInstance();
   $authStorage = $auth->getStorage();
   if(isset($authStorage->read()->WebLoginID)){
     $this->WebLoginID = $authStorage->read()->WebLoginID;
     $users = new Application_Model_Users();
     $logout_details = $users->getUserLoginDetailByWebLoginCode($this->WebLoginID);
     $this->Role                    = $authStorage->read()->Role;
     $this->id                      = $authStorage->read()->id;
     $this->parent_regional_manager = $authStorage->read()->parent_regional_manager;
     $this->parent_zonal_manager    = $authStorage->read()->parent_zonal_manager;
     $this->parent_area_manager     = $authStorage->read()->parent_area_manager;
     $this->parent_sale             = $authStorage->read()->parent_sale;
     $this->view->last_login = $logout_details['login_time'];               
   }
 }

 public function indexAction(){
   $this->view->messages  = $this->_flashMessenger->getMessages();
   $this->checklogin();
   $db = $this->db = Zend_Db_Table::getDefaultAdapter();
   $this->view->params = $params = $this->getRequest()->getParams('retailer','visit_from','visit_to');
   $auth = Zend_Auth::getInstance();
   $authStorage = $auth->getStorage();

   try{
    $sale_query = "SELECT * FROM logi_user WHERE Role = 'Sales'  and StaffStatus = 'AC' ORDER BY StaffName ";
    $this->view->sale_result = $sale_result = $db->fetchAll($sale_query);
    $cond = '';
    if(isset($params['sales']) && $params['sales'] != ""){
      $cond .= "AND tvm.sale_person_id = '".$params['sales']."'";
    }
    if(isset($params['visit_from']) && isset($params['visit_to']) && $params['visit_from'] && $params['visit_to']){
     $cond .=" AND tvm.schedule_date between '".$params['visit_from']."' and '".$params['visit_to']."' ";
   }
   else{
    $this->view->cur_date = $cur_date = date("Y-m-d");
    $cond .= "AND tvm.schedule_date = '".$cur_date."'";
  }

  if (isset($this->Role) &&  $this->Role == 'super_admin') {
    $user_cond .= "";
  }

  if (isset($this->Role) &&  $this->Role == 'RM') {
    $user_cond .= "and tvm.parent_regional_manager = '" . $id . "' ";
  }

  if (isset($this->Role) &&  $this->Role == 'ZM') {
    $user_cond .= "and tvm.parent_zonal_manager = '" . $id . "' ";
  }

  if (isset($this->Role) &&  $this->Role == 'ASM') {
    $user_cond .= "and tvm.parent_area_manager = '" . $id . "' ";
  }

  if (isset($this->Role) &&  $this->Role == 'Sales') {
    $user_cond .= "and tvm.parent_sale_person = '" . $id . "' ";
  }
  $visit_query = "SELECT tvm.*, luSale.id as tsi_id, lu.id as retailer_id, lu.StaffName as retailer_name, lvp.purpose, luSale.StaffName as sales_person FROM tbl_visit_management AS tvm 
  LEFT JOIN logi_user AS lu ON (tvm.retailer_id = lu.id) 
  LEFT JOIN logi_user AS luSale ON (tvm.sale_person_id = luSale.id) 
  LEFT JOIN logi_visit_purpose AS lvp ON (tvm.visit_purpose = lvp.id) WHERE 1 $cond ORDER BY tvm.schedule_date DESC ";

  $this->view->visit_result = $visit_result = $db->fetchAll($visit_query);

}
catch(Exception $e){
  echo $e->getMessage();exit;
}
}


public function visitDetailsViewAction(){
  $this->checklogin();
  $db = Zend_Db_Table::getDefaultAdapter();
  $params = $this->view->params = $this->getRequest()->getParams();

  $query = "SELECT tvm.*, l.StaffName as sales_person, r.StaffName as retailer_name from tbl_visit_management as tvm
  LEFT JOIN logi_user as l on (l.id = tvm.sale_person_id) 
  LEFT JOIN logi_user AS r ON (r.id = tvm.retailer_id)
  WHERE tvm.id='".$params['id']."'"; 
  $result = $db->fetchRow($query);
  $this->view->visit = $result;
  $layout = $this->_helper->layout();
  $layout->disableLayout('');
}

public function assignVisitAction(){

  $this->checklogin();
  $this->view->messages  = $this->_flashMessenger->getMessages();
  $db = $this->db = Zend_Db_Table::getDefaultAdapter();
  $this->view->params = $params = $this->getRequest()->getParams();
  $auth = Zend_Auth::getInstance();
  $authStorage = $auth->getStorage();

  $sales_query ="SELECT id, LoginID, StaffName FROM logi_user WHERE Role = 'Sales' and StaffStatus = 'AC' ORDER BY StaffName";
  $this->view->sales_result = $sales_result = $db->fetchAll($sales_query);

  $retailer_query ="SELECT id, LoginID, StaffName FROM logi_user WHERE Role = 'Retailer' and StaffStatus = 'AC' ORDER BY StaffName";
  $this->view->retailer_result = $retailer_result = $db->fetchAll($retailer_query);

  $purpose_query ="SELECT id, purpose FROM logi_visit_purpose ORDER BY purpose";
  $this->view->purpose_result = $purpose_result = $db->fetchAll($purpose_query);

  if(isset($params['id']) && $params['id'] != ""){
    $visit_query = "SELECT * FROM tbl_visit_management WHERE id = '".$params['id']."'";
    $this->view->visit_result = $visit_result = $db->fetchRow($visit_query);
  }

  if($this->getRequest()->isPost()){ 
    try{
      // print_r($params);
      // exit;
      $i = 0;
      foreach($params['retailer'] as $key=>$value){

       $sql_ret = "Select * from logi_user where id = '".$params['retailer'][$i]."'"; 
       $ret_result = $db->fetchRow($sql_ret);

       $insertVisit = array();
       $insertVisit['sale_person_id']            = $params['sale_person'][$i];
       $insertVisit['retailer_id']               = $ret_result['id'][$i];
       $insertVisit['schedule_date']             = $params['schedule_date'][$i];
       $insertVisit['schedule_time']             = $params['schedule_time'][$i];
       $insertVisit['visit_purpose']             = $params['visit_purpose'][$i];
       $insertVisit['remark']                    = $params['remark'][$i];
       $insertVisit['created_at']                = date("Y-m-d h:i:sa")[$i];
       $insertVisit['parent_regional_manager']   = $ret_result['parent_regional_manager'][$i];
       $insertVisit['parent_zonal_manager']      = $ret_result['parent_zonal_manager'][$i]; 
       $insertVisit['parent_area_manager']       = $ret_result['parent_area_manager'][$i];
       $insertVisit['parent_sale_person']        = $ret_result['parent_sale'][$i];
       $insertVisit['state']                     = $ret_result['state'][$i];
       $insertVisit['district']                  = $ret_result['DistrictID'][$i];

       $db->insert('tbl_visit_management', $insertVisit);
       $i++;  
     }

     $this->_flashMessenger->addMessage('Visit scheduled successfully!');
     $this->_redirect("/visit/assign-visit");

   }catch(Exception $e){
    echo $e->getMessage();exit;
  }

}        
}


public function editVisitAction(){
 try{
   $this->view->messages  = $this->_flashMessenger->getMessages();
   $db = $this->db = Zend_Db_Table::getDefaultAdapter();
   $this->view->params = $params = $this->getRequest()->getParams();
   $auth = Zend_Auth::getInstance();
   $authStorage = $auth->getStorage();
   // print_r($params);
   // exit;

   $sales_query ="SELECT id, LoginID, StaffName FROM logi_user WHERE Role = 'Sales' and StaffStatus = 'AC' ORDER BY StaffName";
   $this->view->sales_result = $sales_result = $db->fetchAll($sales_query);

   $retailer_query ="SELECT * FROM logi_user WHERE Role = 'Retailer' and StaffStatus = 'AC' ORDER BY StaffName";
   $this->view->retailer_result = $retailer_result = $db->fetchAll($retailer_query);

   $purpose_query ="SELECT id, purpose FROM logi_visit_purpose ORDER BY purpose";
   $this->view->purpose_result = $purpose_result = $db->fetchAll($purpose_query);
   $editvisit= "Select * from tbl_visit_management where id='".$params['id']."'";
   $this->view->visit_result = $visit_result = $db->fetchRow($editvisit); 

   if($this->getRequest()->isPost()){ 

    $updateVisit = array();
    $updateVisit['sale_person_id'] = $params['sale_person'];
    $updateVisit['retailer_id']    = $params['retailer'];
    $updateVisit['schedule_date']  = $params['schedule_date'];
    $updateVisit['schedule_time']  = $params['schedule_time'];
    $updateVisit['visit_purpose']  = $params['visit_purpose'];
    $updateVisit['remark']         = $params['remark'];
    // print_r($params);
    // exit;
    $db->update('tbl_visit_management', $updateVisit, array('id=?'=>$params['id'])); 
    $this->_flashMessenger->addMessage('Visit updated successfully!');
    $this->_redirect("/visit/edit-visit/id/".$params['id'].""); 
  }
}
catch(Exception $e){
  echo $e->getMessage();exit;
}
}

public function salesPersonMonthlyTargetsAction(){

  try{
    $this->checklogin();
    $db = $this->db = Zend_Db_Table::getDefaultAdapter();
    $this->view->params = $params = $this->getRequest()->getParams();
    $auth = Zend_Auth::getInstance();
    $authStorage = $auth->getStorage();
    
    $sale_query = "SELECT * FROM logi_user WHERE Role = 'Sales'  and StaffStatus = 'AC' ORDER BY StaffName ";
    $this->view->sale_result = $sale_result = $db->fetchAll($sale_query);
    $cond = '';
    if(isset($params['sales']) && $params['sales'] != ""){
      $cond .= "AND spmt.sale_person_id = '".$params['sales']."'";
    }

    $query = "SELECT spmt.*, luSale.id as tsi_id, luSale.StaffName as sales_person FROM sales_person_monthly_targets AS spmt 
    LEFT JOIN logi_user AS luSale ON (spmt.sale_person_id = luSale.id) 
    WHERE 1 $cond ";

    $this->view->monthly_targets = $monthly_targets = $db->fetchAll($query);

  }catch(Exception $e){
    echo $e->getMessage();exit;
  }
}

public function assignMonthlyTargetAction(){

  $this->checklogin();
  $this->view->messages  = $this->_flashMessenger->getMessages();
  $db = $this->db = Zend_Db_Table::getDefaultAdapter();
  $this->view->params = $params = $this->getRequest()->getParams();

  $sales_query ="SELECT id, LoginID, StaffName FROM logi_user WHERE Role = 'Sales' and StaffStatus = 'AC' ORDER BY StaffName";
  $this->view->sales_result = $sales_result = $db->fetchAll($sales_query);

  if(isset($params['id']) && $params['id'] != ""){
    $monthly_target_query = "SELECT * FROM sales_person_monthly_targets WHERE id = '".$params['id']."'";
    $this->view->monthly_target = $monthly_target = $db->fetchRow($monthly_target_query);
  }

  if($this->getRequest()->isPost()){ 
    try{

      if($params['id'] != ""){
       $updateTarget = array();
       $updateTarget['sale_person_id'] = $params['sale_person'];
       $updateTarget['monthly_targets']         = $params['monthly_target'];
       $db->update('sales_person_monthly_targets', $updateTarget, array('id=?'=>$params['id']));
       $this->_flashMessenger->addMessage('Monthly Target updated successfully!');
       $this->_redirect("/visit/assign-monthly-target/id/".$params['id']."/datacode/".md5(md5($params['id']))); 
     } 
     else {
       $sql_ret = "Select * from logi_user where id = '".$params['sale_person']."'";
       $ret_result = $db->fetchRow($sql_ret);

       $insertTarget = array();
       $insertTarget['sale_person_id']            = $params['sale_person'];
       $insertTarget['parent_regional_manager']   = $ret_result['parent_regional_manager'];
       $insertTarget['parent_zonal_manager']      = $ret_result['parent_zonal_manager']; 
       $insertTarget['parent_area_manager']       = $ret_result['parent_area_manager'];
       $insertTarget['monthly_targets']           = $params['monthly_target'];

       $db->insert('sales_person_monthly_targets', $insertTarget);
       $this->_flashMessenger->addMessage('Monthly Target scheduled successfully!');
       $this->_redirect("/visit/sales-person-monthly-targets");
     }
   }catch(Exception $e){
    echo $e->getMessage();exit;
  }

}        
}


public function salesPersonKmReadingsAction(){

  try{
    $this->checklogin();
    $db = $this->db = Zend_Db_Table::getDefaultAdapter();
    $this->view->params = $params = $this->getRequest()->getParams();
    $auth = Zend_Auth::getInstance();
    $authStorage = $auth->getStorage();
    
    $sale_query = "SELECT * FROM logi_user WHERE Role = 'Sales'  and StaffStatus = 'AC' ORDER BY StaffName ";
    $this->view->sale_result = $sale_result = $db->fetchAll($sale_query);
    $cond = '';
    if(isset($params['sales']) && $params['sales'] != ""){
      $cond .= "AND spkr.sale_person_id = '".$params['sales']."'";
    }

    if(isset($params['date_from']) && isset($params['date_to']) && $params['date_from'] && $params['date_to']){
      $cond .=" AND spkr.date between '".$params['date_from']."' and '".$params['date_to']."' ";
    }
    else{
      $this->view->cur_date = $cur_date = date("Y-m-d");
      $cond .= "AND spkr.date = '".$cur_date."'";
    }

    $query = "SELECT spkr.*, luSale.id as tsi_id, luSale.StaffName as sales_person FROM sales_person_km_readings AS spkr 
    LEFT JOIN logi_user AS luSale ON (spkr.sale_person_id = luSale.id) 
    WHERE 1 $cond ";
    $this->view->km_readings = $km_readings = $db->fetchAll($query);

  }catch(Exception $e){
    echo $e->getMessage();exit;
  }
}


public function editKmReadingAction(){
  $this->checklogin();
  $this->view->messages  = $this->_flashMessenger->getMessages();
  $db = $this->db = Zend_Db_Table::getDefaultAdapter();
  $this->view->params = $params = $this->getRequest()->getParams();
  $sales_query ="SELECT id, LoginID, StaffName FROM logi_user WHERE Role = 'Sales' and StaffStatus = 'AC' ORDER BY StaffName";
  $this->view->sales_result = $sales_result = $db->fetchAll($sales_query);
  if(isset($params['id']) && $params['id'] != ""){
    $km_reading_query = "SELECT * FROM sales_person_km_readings WHERE id = '".$params['id']."'";
    $this->view->km_reading = $km_reading = $db->fetchRow($km_reading_query);
  }else{
    exit;
  }

  if($this->getRequest()->isPost()){ 
    try{
      $sql_ret = "Select * from logi_user where id = '".$params['sale_person']."'";
      $ret_result = $db->fetchRow($sql_ret);
      $updateReading = array();
      $updateReading['sale_person_id']            = $params['sale_person'];
      $updateReading['parent_regional_manager']   = $ret_result['parent_regional_manager'];
      $updateReading['parent_zonal_manager']      = $ret_result['parent_zonal_manager']; 
      $updateReading['parent_area_manager']       = $ret_result['parent_area_manager'];
      $updateReading['date']                      = $params['date'];
      $updateReading['km_reading']                = $params['km_reading'];
      
      $db->update('sales_person_km_readings', $updateReading, array('id=?'=>$params['id']));
      $this->_flashMessenger->addMessage('Reading updated successfully!');
      $this->_redirect("/visit/edit-km-reading/id/".$params['id']."/datacode/".md5($params['id'])); 

    }catch(Exception $e){
      echo $e->getMessage();exit;
    }
  }
}


public function recordKilometerReadingAction(){

  $this->checklogin();
  $this->view->messages  = $this->_flashMessenger->getMessages();
  $db = $this->db = Zend_Db_Table::getDefaultAdapter();
  $this->view->params = $params = $this->getRequest()->getParams();

  $sales_query ="SELECT id, LoginID, StaffName FROM logi_user WHERE Role = 'Sales' and StaffStatus = 'AC' ORDER BY StaffName";
  $this->view->sales_result = $sales_result = $db->fetchAll($sales_query);

  if(isset($params['id']) && $params['id'] != ""){
    $km_reading_query = "SELECT * FROM sales_person_km_readings WHERE id = '".$params['id']."'";
    $this->view->km_reading = $km_reading = $db->fetchRow($km_reading_query);
  }

  if($this->getRequest()->isPost()){ 
    try{
      $i = 0;
      foreach ($params['sale_person'] as $key => $value) {
        $deleteReading = "delete from sales_person_km_readings where sale_person_id=".$params['sale_person'][$i]." and date='".$params['date'][$i]."'";
        $db->query($deleteReading);

        $sql_ret = "Select * from logi_user where id = '".$params['sale_person'][$i]."'";
        $ret_result = $db->fetchRow($sql_ret);
        $insertReading = array();
        $insertReading['sale_person_id']            = $params['sale_person'][$i];
        $insertReading['parent_regional_manager']   = $ret_result['parent_regional_manager'];
        $insertReading['parent_zonal_manager']      = $ret_result['parent_zonal_manager']; 
        $insertReading['parent_area_manager']       = $ret_result['parent_area_manager'];
        $insertReading['date']                      = $params['date'][$i];
        $insertReading['km_reading']                = $params['km_reading'][$i];
        $db->insert('sales_person_km_readings', $insertReading);
        $i++;
      }
      $this->_flashMessenger->addMessage('Reading Added successfully!');
      $this->_redirect("/visit/sales-person-km-readings");
    }catch(Exception $e){
      echo $e->getMessage();exit;
    }

  }        
}

public function getDistributerAction(){
  $sales_code =  $this->_getParam('sale_id');
  $params = $this->getRequest()->getParams();

  $dist_query = "SELECT id, LoginID, StaffName FROM logi_user where parent_sale = '".$params['sale_id']."' AND Role = 'Distributer' ORDER BY StaffName ";
  $dist_result = $this->db->fetchAll($dist_query);

  $Dist_List[]        = array("value"=>"",'text'=>"Select Distributer");
  foreach($dist_result as $key){
    $Dist_List[] = array("value"=>$key['id'],"text"=>$key['StaffName'].'('.$key['LoginID'].')');
  }
            //print_r($Dist_List);exit;
  $this->getHelper('Layout')->disableLayout();
  $this->getHelper('ViewRenderer')->setNoRender();
  $this->getResponse()->setHeader('Content-Type', 'application/json');
  echo json_encode(array('options'=>$Dist_List));
  return; 
}


public function getRetailerAction(){

  $dist_code =  $this->_getParam('distributer_id');
  $params = $this->getRequest()->getParams();

  $retailer_query = "SELECT id, LoginID, StaffName FROM logi_user where parent_distributer = '".$params['distributer_id']."' AND Role = 'Retailer' ORDER BY StaffName ";
  $retailer_result = $this->db->fetchAll($retailer_query);

  $Retailer_List[]        = array("value"=>"",'text'=>"Select Retailer");
  foreach($retailer_result as $key){
    $Retailer_List[] = array("value"=>$key['LoginID'],"text"=>$key['StaffName'].'('.$key['LoginID'].')');
  }
            //print_r($Class_List);exit;
  $this->getHelper('Layout')->disableLayout();
  $this->getHelper('ViewRenderer')->setNoRender();
  $this->getResponse()->setHeader('Content-Type', 'application/json');
  echo json_encode(array('options'=>$Retailer_List));
  return; 
}

public function deleteVisitAction(){ 
  $db = $this->db = Zend_Db_Table::getDefaultAdapter();
  $this->view->params = $params = $this->getRequest()->getParams('id');

  $where = array();
  $where[] = $this->db->quoteInto('id=?', $params['id']);
  $result =  $this->db->delete('tbl_visit_management', $where);
  $this->view->successMessage = "Scheduled visit deleted successfully.";
  $this->_redirect('/visit');     
}

public function visitFormatAction(){

  $this->checklogin();
  $this->view->messages  = $this->_flashMessenger->getMessages();
  $db = $this->db = Zend_Db_Table::getDefaultAdapter();
  $this->view->params = $params = $this->getRequest()->getParams();
  $sql_user = "select u.*, s.state as state_name, d.district as district_name, rm.StaffName as regional_manager, zm.StaffName as zonal_manager, am.StaffName as area_manager, tsi.StaffName as tsi, tsi.LoginID as tsi_code, dis.StaffName as distributor, dis.LoginID as distributor_code  from  logi_user as u 
  left join logi_user as rm on (u.parent_regional_manager = rm.id) 
  left join logi_user as am on (u.parent_area_manager = am.id) 
  left join logi_user as tsi on (u.parent_sale = tsi.id) 
  left join logi_user as dis on (u.parent_distributer = dis.id) 
  left join logi_user as zm on (u.parent_zonal_manager = zm.id) 
  left join state as s on (u.state = s.id) 
  left join district as d on (u.DistrictID = d.id) where  u.Role = 'Retailer'";
  $result = $this->db->fetchAll($sql_user);

  include 'PHPExcel/IOFactory.php';
  require_once 'PHPExcel/Classes/PHPExcel.php';
  $objPHPExcel = new PHPExcel();
  $objPHPExcel->getProperties()->setCreator("Ajay Kumar")
  ->setLastModifiedBy("Ajay Kumar")
  ->setTitle("Office 2007 XLSX  Document")
  ->setSubject("Office 2007 XLSX  Document")
  ->setDescription("Document for Office 2007 XLSX, generated using PHP classes.")
  ->setKeywords("office 2007 openxml php")
  ->setCategory("BOQ Data");
          // Add some data
  $objPHPExcel->getActiveSheet()
  ->setCellValue('A1', 'TSI Name')
  ->setCellValue('B1', 'TSI Code')
  ->setCellValue('C1', 'Distributor Name')
  ->setCellValue('D1', 'Distributor Code')
  ->setCellValue('E1', 'Retailer Name')
  ->setCellValue('F1', 'Retailer Code')
  ->setCellValue('G1', 'Visit Date')
  ->setCellValue('H1', 'Visit Time')
  ->setCellValue('I1', 'Purpose Of Visit')
  ->setCellValue('J1', 'Remark');
  $default_border = array(
    'style' => PHPExcel_Style_Border::BORDER_THIN,
    'color' => array('rgb'=>'000000')
  );

  $style_header = array(
    'fill' => array(
      'type' => PHPExcel_Style_Fill::FILL_SOLID,
      'color' => array('rgb'=>'999999')
    )
  );
  $objPHPExcel->getActiveSheet()->getStyle('A1:J1'); 
  $i = 2;   
  foreach($result as $data)      {
    $objPHPExcel->setActiveSheetIndex(0)
    ->setCellValue('A'.$i, $data['tsi'])
    ->setCellValue('B'.$i, $data['tsi_code'])
    ->setCellValue('C'.$i, $data['distributor'])
    ->setCellValue('D'.$i, $data['distributor_code'])
    ->setCellValue('E'.$i, $data['StaffName'])
    ->setCellValue('F'.$i, $data['LoginID'])
    ->setCellValue('G'.$i, '')
    ->setCellValue('H'.$i, '')
    ->setCellValue('I'.$i, '')
    ->setCellValue('J'.$i, '');
    $i++; 
  }
  $objPHPExcel->setActiveSheetIndex(0);
          // Redirect output to a client’s web browser (Excel2007)
  header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
  header('Content-Disposition: attachment;filename="assign_visit.xlsx"');
  header('Cache-Control: max-age=0'); 

  $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
  $objWriter->save('php://output');

  exit;
}


public function importVisitAction(){
 $this->view->messages  = $this->_flashMessenger->getMessages();

 if($this->getRequest()->isPost()){

  $fileName = $_FILES["file"]["tmp_name"];
  if ($_FILES["file"]["size"] > 0) {
    $file = fopen($fileName, "r");
    $i=1; 
    while (($column = fgetcsv($file, 10000, ",")) !== FALSE) {
      $sqlFeInfo = "select * from logi_user where LoginID = '".trim($column[0])."'";
      $resFeInfo = $this->db->fetchRow($sqlFeInfo);

      $sqlRetInfo = "select * from logi_user where LoginID = '".trim($column[2])."'";
      $resRetInfo = $this->db->fetchRow($sqlRetInfo);

      if($resRetInfo){
        $excel = array();
        $excel['schedule_date']                = date('Y-m-d',strtotime($column[4]));
        $excel['schedule_time']                = trim($column[5]);
        $excel['visit_purpose']                = trim($column[6]);
        $excel['remark']                       = trim($column[7]);
        $excel['retailer_id']                  = trim($column[2]);
        $excel['sale_person_id']               = $resFeInfo['id'];
        $excel['parent_regional_manager']      = $resRetInfo['parent_regional_manager'];
        $excel['parent_zonal_manager']         = $resRetInfo['parent_zonal_manager'];
        $excel['parent_area_manager']          = $resRetInfo['parent_area_manager'];
        $excel['parent_sale_person']           = $resRetInfo['parent_sale_person'];
        $excel['state']                        = $state['id'];
        $excel['district']                     = $district['id'];
        $excel['loginid']                      = $resFeInfo['LoginID'];

        $this->db->insert('tbl_visit_management', $excel);
      }
      $i++;
    }
    $this->_flashMessenger->addMessage('Visit data imported successfully!');
    $this->_redirect("/visit/index");
  }
  else{
   $this->_flashMessenger->addMessage('Something wrong!');
   $this->_redirect("/visit/index");
 }
} 
}

public function checklogin(){   
  $auth = Zend_Auth::getInstance(); 
  $errorMessage = ""; 
  /*************** check user identity ************/
  if(!$auth->hasIdentity()){
    $this->_redirect('admin/index');  
  }   
}     
}