<?php

/***************************************************************
 * Logimetrix Techsolutions Pvt. Ltd.
 * File Name   : UserLocationMappingController.php
 * File Description  : UserLocationMappingController
 * Created By : Arpita Upadhyay
 * Created Date: 15 May 2019
 ***************************************************************/

class UserLocationMappingController extends Zend_Controller_Action{
	var $dbAdapter;
	var $db;
	public function init(){
		/* Initialize action controller here */
		$this->_flashMessenger  = $this->_helper->getHelper('FlashMessenger');
		$bootstrap = $this->getInvokeArg('bootstrap');
		$aConfig = $bootstrap->getOptions();
		$this->db = Zend_Db_Table::getDefaultAdapter();
		$auth = Zend_Auth::getInstance();
		$authStorage = $auth->getStorage();
		$this->WebLoginID = $authStorage->read()->WebLoginID;
		$users = new Application_Model_Users();
		$logout_details = $users->getUserLoginDetailByWebLoginCode($this->WebLoginID);
		$this->view->last_login = $logout_details['login_time'];               
	}

	public function indexAction(){
		$this->checklogin();
		$this->view->messages = $this->_flashMessenger->getMessages();
		try{
			$params = $this->view->params = $this->getRequest()->getParams(); 
			$db = $this->db = Zend_Db_Table::getDefaultAdapter();
			$result = array();
			$user_query = "SELECT location.id as mapping_id, user.StaffName,location.user_id FROM logi_user_location_mapping as location
			left join logi_user as user on (user.id = location.user_id) group by user_id order by location.id desc";
			$users = $db->fetchAll($user_query);
			foreach ($users as $user){
				$user_location_query = "SELECT * FROM logi_user_location_mapping  where user_id=".$user['user_id'];
				$user_location_results = $db->fetchAll($user_location_query);
				$locations = array();
				foreach ($user_location_results as $user_location) {
					$location_detail = $user_location['location_name']."(".$user_location['latitude'].",".$user_location['longitude'].")";
					$location_edit_icon = '<a  href="javascript:void(0)" data-toggle="modal" data-target="#con-close-modal" onclick="editUserLocationMapping('.$user_location["id"].');" class="iframe"><i class="glyphicon glyphicon-pencil" title="Edit Location Mapping" style="color:white;"></i></a>&nbsp;';
					$location_delete_icon = '<a href="javascript:void(0)" onclick="deleteMapping('.$user_location["id"].');" title="Delete User Location Mapping"><i class="glyphicon glyphicon-remove" style="color:white;"></i></a>';
					$location = "<button class='btn btn-purple waves-effect waves-light btn-xs' >".$location_detail.$location_edit_icon.$location_delete_icon."</button>";
					array_push($locations, $location);
				}
				$user['location'] = $locations;
				array_push($result, $user);
			}			
			$this->view->record = $record = $result;
			
		}catch(Exception $e){
			echo $e->getMessage();exit;
		}

	}


	public function distributorAreaMappingAction(){
		$this->checklogin();
		$this->view->messages = $this->_flashMessenger->getMessages();
		try{
			$params = $this->view->params = $this->getRequest()->getParams(); 
			$db = $this->db = Zend_Db_Table::getDefaultAdapter();
			$sql_location          = "select * from logi_location order by location_name asc";
			$this->view->locations = $locations = $db->fetchAll($sql_location);
			$sql_distributor          = "SELECT * FROM `logi_user` WHERE `Role` = 'Distributer' order by StaffName asc";
			$this->view->distributor = $distributor = $db->fetchAll($sql_distributor);
			$sql_area_distributor          = "SELECT distributor_area.*, logi_location.location_name,logi_user.StaffName FROM `distributor_area` left JOIN logi_location on (distributor_area.area_id =logi_location.id ) LEFT JOIN logi_user on(distributor_area.distributor_id = logi_user.id)";
			$this->view->area_distributor = $area_distributor = $db->fetchAll($sql_area_distributor);
			$result = array();
			$user_query = "SELECT distributor_area.*, logi_location.location_name,logi_user.StaffName FROM `distributor_area` left JOIN logi_location on (distributor_area.area_id =logi_location.id ) LEFT JOIN logi_user on(distributor_area.distributor_id = logi_user.id) group by distributor_area.distributor_id";
			$users = $db->fetchAll($user_query);
			foreach ($users as $user){
				$user_location_query = "SELECT  distributor_area.*, logi_location.location_name FROM `distributor_area` left JOIN logi_location on (distributor_area.area_id =logi_location.id )  where distributor_id='".$user['distributor_id']."'";
				$user_location_results = $db->fetchAll($user_location_query);
				$locations = array();
				foreach ($user_location_results as $user_location) {
					$location_detail = $user_location['location_name'] ;

					$location_delete_icon = '<a href="javascript:void(0)" onclick="deleteMapping('.$user_location["id"].');" title="Delete User Location Mapping"><i class="glyphicon glyphicon-remove" style="color:white;"></i></a>';
					$location = "<button class='btn btn-purple waves-effect waves-light btn-xs' >".$location_detail.$location_delete_icon."</button>";
					array_push($locations, $location);
				}
				$user['location'] = $locations;
				array_push($result, $user);
			}			
			$this->view->record = $record = $result;


		}catch(Exception $e){
			echo $e->getMessage();exit;
		}

	}

	public function addUserLocationMappingAction(){
		try{
			$this->checklogin();
			$db = $this->db = Zend_Db_Table::getDefaultAdapter();
			$this->view->params = $params = $this->getRequest()->getParams();
			$auth = Zend_Auth::getInstance();
			$authStorage = $auth->getStorage();
			$this->view->messages = $this->_flashMessenger->getMessages();
			$sql = "select id,StaffName, LoginID from logi_user WHERE StaffStatus = 'AC' && Role in ('Sales', 'ASM')  ";
			$this->view->role      = $role = $db->fetchAll($sql);
			$sql = "select id,StaffName, LoginID from logi_user WHERE StaffStatus = 'AC' && Role = 'ZM'  ";
			$this->view->rolezm      = $rolezm = $db->fetchAll($sql);
			$sql_location          = "select * from logi_location";
			$this->view->locations = $locations = $db->fetchAll($sql_location);
			if($this->getRequest()->isPost()){
				if($params['sales']==''){
					$user = $params['asm'];
				}
				else{
					$user = $params['sales'];
				}
				$sql_location          = "select * from logi_location where id=".$params['location_name'];
				$location = $db->fetchRow($sql_location);
				$locationData = array();
				$locationData['location_id']      = $location['id'];
				$locationData['location_name']    = $location['location_name'];
				$locationData['latitude']         = $location['latitude'];
				$locationData['longitude']        = $location['longitude'];
				$locationData['user_id']          = $user;
				// print_r($locationData);
				// exit;
				$db->insert('logi_user_location_mapping', $locationData);

				//----Update current location status----//
				$updateCurrentMappingStatus = array();
				$updateCurrentMappingStatus['mapped_status'] = 1;
				$db->update('logi_location',$updateCurrentMappingStatus,array('id=?'=>$location['id']));
				
				$this->view->successMessage = "User Location added successfully.";
				$this->_redirect("user-location-mapping/"); 
			}

		}catch(Exception $e){
			echo $e->getMessage();exit;
		}
	}


	public function addDistributorLocationMappingAction(){
		try{
			$this->checklogin();
			$db = $this->db = Zend_Db_Table::getDefaultAdapter();
			$this->view->params = $params = $this->getRequest()->getParams();
			$auth = Zend_Auth::getInstance();
			$authStorage = $auth->getStorage();
			$this->view->messages = $this->_flashMessenger->getMessages();
			$sql_check = "select * from distributor_area where distributor_id ='".$params['distributor']."' and area_id  =  '".$params['location']."' ";
			$this->view->check_duplicate      = $check_duplicate = $db->fetchAll($sql_check); 
			if($check_duplicate)
			{
				$this->_flashMessenger->addMessage("Distributer Location already  Mapped.");
				$this->_redirect("/user-location-mapping/distributor-area-mapping#"); 
			}
			else{
				if($this->getRequest()->isPost()){
					$locationData = array();
					$locationData['distributor_id']   = $params['distributor'];
					$locationData['area_id']    = $params['location'];
					$db->insert('distributor_area', $locationData);
					$this->_flashMessenger->addMessage("Distributer Location added successfully.");
					$this->_redirect("/user-location-mapping/distributor-area-mapping#"); 
				}
			}
		}catch(Exception $e){
			echo $e->getMessage();exit;
		}
	}


	public function getAsmAction(){
		try {
			$this->checklogin();
			$db = $this->db = Zend_Db_Table::getDefaultAdapter();

			$params = $this->view->params = $this->getRequest()->getParams();
			$sql = "select id,StaffName, LoginID from logi_user WHERE parent_zonal_manager ='".$params['staff_id']."' and StaffStatus = 'AC' && Role = 'ASM' order by StaffName";
			$this->view->list_unformat      = $list_unformat = $db->fetchAll($sql);

			$list[] = array("value"=>"",'text'=>"--Select ASM--");
			foreach($list_unformat as $single){
				$list[] = array("value"=>$single['id'],"text"=>$single['StaffName'].'('.$single['LoginID'].')');
			}
			$this->getHelper('Layout')->disableLayout();
			$this->getHelper('ViewRenderer')->setNoRender();
			$this->getResponse()->setHeader('Content-Type', 'application/json');
			echo json_encode(array('options'=>$list));
		}
		catch(Exception $e){
			echo $e->getMessage();exit;
		}
		return;	

	}
	public function getSalesAction(){
		
		$this->checklogin();
		$db = $this->db = Zend_Db_Table::getDefaultAdapter();
		$params = $this->view->params = $this->getRequest()->getParams();
		$sql = "select id,StaffName, LoginID from logi_user WHERE parent_area_manager ='".$params['asm']."' and StaffStatus = 'AC' && Role ='Sales' order by StaffName ";
		$this->view->unformat      = $unformat = $db->fetchAll($sql);
		$saleslist[] = array("value"=>"",'text'=>"--Select Sales person--");
		foreach($unformat as $sales){
			$saleslist[] = array("value"=>$sales['id'],"text"=>$sales['StaffName'].'('.$sales['LoginID'].')');
		}

		$this->getHelper('Layout')->disableLayout();
		$this->getHelper('ViewRenderer')->setNoRender();
		$this->getResponse()->setHeader('Content-Type', 'application/json');
		echo json_encode(array('options'=>$saleslist));
		return;	
	}
	public function editUserLocationMappingAction(){
		try{
			$this->checklogin();
			$auth = Zend_Auth::getInstance();
			$authStorage = $auth->getStorage();
			$this->view->messages = $this->_flashMessenger->getMessages();
			$this->view->messages = $this->_flashMessenger->getMessages();

			$db = $this->db= Zend_Db_Table::getDefaultAdapter();

			$layout = $this->_helper->layout()->disableLayout('');
			$this->view->params = $params = $this->getRequest()->getParams();
			
			$sql_location           = "select * from logi_location where mapped_status = '0'";
			$this->view->locations  = $locations = $db->fetchAll($sql_location);

			if($this->getRequest()->isPost()){
				$sql_location = "select * from logi_location where id='".$params['location_id']."'";
				$location = $db->fetchRow($sql_location);

				$sql_old_location = "select location_id from logi_user_location_mapping where id='".$params['mapping_id']."'";
				$oldlocation = $db->fetchRow($sql_old_location);

                //----Update user mapping----//
				$locationupdate = array();
				$locationupdate['location_id']   = $location['id'];
				$locationupdate['location_name'] = $location['location_name'];
				$locationupdate['latitude']      = $location['latitude'];
				$locationupdate['longitude']     = $location['longitude'];
				$db->update('logi_user_location_mapping',$locationupdate,array('id=?'=>$params['mapping_id'])); 
                //----Update current location status----//
				$updateCurrentMappingStatus = array();
				$updateCurrentMappingStatus['mapped_status'] = 1;
				$db->update('logi_location',$updateCurrentMappingStatus,array('id=?'=>$params['location_id']));
				//----Update old location status---//
				$updateOldMappingStatus = array();
				$updateOldMappingStatus['mapped_status'] = 0;
				$db->update('logi_location',$updateOldMappingStatus,array('id=?'=>$oldlocation['location_id']));
				$this->_flashMessenger->addMessage('User Locations updated successfully.');
				$this->_redirect('/user-location-mapping/index');
			}     
		}
		catch(Exception $e){
			echo $e->getMessage();exit;
		}
	}

	public function deleteUserLocationMappingAction(){
		$this->checklogin();
		$db                   = $this->db;
		$auth                 = Zend_Auth::getInstance();
		$authStorage          = $auth->getStorage();
		$params               = $this->getRequest()->getParams();
		$this->view->messages = $this->_flashMessenger->getMessages();

		$sql_location = "select * from logi_user_location_mapping where id='".$params['id']."'";
		$location = $db->fetchRow($sql_location);

		$updateOldMappingStatus = array();
		$updateOldMappingStatus['mapped_status'] = 0;
		$db->update('logi_location',$updateOldMappingStatus,array('id=?'=>$location['location_id']));
		
		$sqlDeleteLocation = "DELETE FROM `logi_user_location_mapping` where  id = '".$params['id']."'";
		$db->query($sqlDeleteLocation);

		$this->_flashMessenger->addMessage('User Locations Deleted successfully.');
		
		$this->_helper->layout()->disableLayout(); 
		$this->_helper->viewRenderer->setNoRender(true);
	}
	public function deleteDistributorMappingAction(){
		$this->checklogin();
		$db                   = $this->db;
		$auth                 = Zend_Auth::getInstance();
		$authStorage          = $auth->getStorage();
		$params               = $this->getRequest()->getParams();
		$this->view->messages = $this->_flashMessenger->getMessages();
		$params = $this->view->params = $this->getRequest()->getParams();
		echo $sqlDelete = "DELETE FROM `distributor_area` where  id = '".$params['id']."'";
		$db->query($sqlDelete); exit;
		$this->_flashMessenger->addMessage('Distributer Locations Deleted successfully.');
		$this->_helper->layout()->disableLayout(); 
		$this->_helper->viewRenderer->setNoRender(true);
	}

	public function scriptUpdateMappingAction(){
		try{
			$this->checklogin();
			$auth = Zend_Auth::getInstance();
			$authStorage = $auth->getStorage();
			$db = $this->db= Zend_Db_Table::getDefaultAdapter();

			$sqlGetLocation = "select * from logi_user_location_mapping where location_id = '0'";
			$resLocation = $db->fetchAll($sqlGetLocation);

			foreach($resLocation as $location){
				$sqlLocationMaster = "select * from logi_location where location_name = '".$location['location_name']."'";
				$resLocationMaster = $db->fetchRow($sqlLocationMaster);
				$sqlUpdate = "update logi_user_location_mapping set location_id = '".$resLocationMaster['id']."', location_name = '".$resLocationMaster['location_name']."',  latitude = '".$resLocationMaster['latitude']."', longitude = '".$resLocationMaster['longitude']."' where location_name = '".$location['location_name']."'";
				$db->query($sqlUpdate);
			}
			echo 'Done';
			exit();
		}
		catch(Exception $e){
			echo $e->getMessage();exit;
		}
	}

	public function scriptUpdateMappedStatusAction(){
		try{
			$this->checklogin();
			$auth = Zend_Auth::getInstance();
			$authStorage = $auth->getStorage();
			$db = $this->db= Zend_Db_Table::getDefaultAdapter();
			$sqlGetLocation = "select location_id from logi_user_location_mapping ";
			$resLocation = $db->fetchAll($sqlGetLocation);

			foreach($resLocation as $location){
				$sqlUpdate = "update logi_location set mapped_status = '1'  where id = '".$location['location_id']."'";
				$db->query($sqlUpdate);
			}
			echo 'Done';
			exit();
		}
		catch(Exception $e){
			echo $e->getMessage();exit;
		}
	}

	public function checklogin(){   
		$auth = Zend_Auth::getInstance(); 
		$errorMessage = ""; 
		/*************** check user identity ************/
		if(!$auth->hasIdentity()){
			$this->_redirect('admin/index');  
		}   
	}     
}