<?php

/***************************************************************
 * Logimetrix Techsolutions Pvt. Ltd.
 * File Name   : UserController.php
 * File Description  : UserController
 * Created By : Puneet Mishra
 * Created Date: 25 Nov 2016
 ***************************************************************/

class UserController extends Zend_Controller_Action{

	var $dbAdapter;
	var $db;

	public function init(){
		/* Initialize action controller here */
		$this->_flashMessenger               = $this->_helper->getHelper('FlashMessenger');
		$bootstrap                           = $this->getInvokeArg('bootstrap');
		$aConfig                             = $bootstrap->getOptions();
		$this->db                            = Zend_Db_Table::getDefaultAdapter();
		$auth                                = Zend_Auth::getInstance();
		$authStorage                         = $auth->getStorage();
		$this->WebLoginID                    = $authStorage->read()->WebLoginID;
		$this->Role                          = $authStorage->read()->Role;
		$this->id                            = $authStorage->read()->id;
		$this->parent_regional_manager       = $authStorage->read()->parent_regional_manager;
		$this->parent_zonal_manager          = $authStorage->read()->parent_zonal_manager;
		$this->parent_area_manager           = $authStorage->read()->parent_area_manager;
		$this->parent_sale                   = $authStorage->read()->parent_sale;
		$users                               = new Application_Model_Users();
		$logout_details                      = $users->getUserLoginDetailByWebLoginCode($this->WebLoginID);
		$this->view->last_login              = $logout_details['login_time'];
	}

	public function indexAction(){
		$this->checklogin();
		$db     = $this->db;
		$auth                                = Zend_Auth::getInstance();
		$authStorage                         = $auth->getStorage();
		$params = $this->view->params = $this->getRequest()->getParams();

		$this->view->role = $this->Role;
		$this->view->id   = $this->id;

		$model  = new Application_Model_Model();
		$this->Role. $this->id;
		$getUserListByLogiDetail   = $model->getUserListByLogiDetail($this->Role, $this->id );

		if( $this->Role =='super_admin'){
			$this->view->username   = $username =  $authStorage->read()->username;
		}

		$this->view->getRegionList = $getRegionList  = $model->getRegionList();
		$page                      = $this->_getParam('page', 1);
		$paginator                 = Zend_Paginator::factory($getUserListByLogiDetail);
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(15); // number of items to show per page
        $this->view->paginator     = $paginator;
        $this->view->totalrec      = $paginator->getTotalItemCount();
    }

    public function viewZonalManagerAction(){

    	$this->checklogin();
    	$db                                = $this->db;
    	$params                            = $this->view->params = $this->getRequest()->getParams();
    	$this->view->role = $this->Role;
    	$this->view->id = $this->id;
    	$model                             = new Application_Model_Model();
    	$getZonalHeadListByRegionalManager = $model->getZonalHeadListByRegionalManager($params['datacode'],$this->id,$this->Role);

    	$page      = $this->_getParam('page', 1);
    	$paginator = Zend_Paginator::factory($getZonalHeadListByRegionalManager);
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(15); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec  = $paginator->getTotalItemCount();
        
    }

    public function viewAreaManagerAction(){
    	$this->checklogin();
    	$db                               = $this->db;
    	$params                           = $this->view->params = $this->getRequest()->getParams();
    	$model                            = new Application_Model_Model();
    	$this->view->role = $this->Role;
    	$this->view->id = $this->id;
    	$getAreaManagerListByZonalManager = $model->getAreaManagerListByZonalManager($params['zm'],$this->id, $this->Role);

    	$page      = $this->_getParam('page', 1);
    	$paginator = Zend_Paginator::factory($getAreaManagerListByZonalManager);
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(15); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec  = $paginator->getTotalItemCount();
        
    }

    public function viewTsiManagerAction(){
    	$this->checklogin();
    	$db                              = $this->db;
    	$params                          = $this->view->params = $this->getRequest()->getParams();
    	$model                           = new Application_Model_Model();
    	$this->view->role = $this->Role;
    	$this->view->id = $this->id;
    	$getSalesPersonListByAreaManager = $model->getSalesPersonListByAreaManager($params['am'], $this->id, $this->Role);
    	$page      = $this->_getParam('page', 1);
    	$paginator = Zend_Paginator::factory($getSalesPersonListByAreaManager);
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(15); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec  = $paginator->getTotalItemCount();
    }


    public function viewretailerAction(){
    	$this->checklogin();
    	$params = $this->view->params = $this->getRequest()->getParams();
    	$model  = new Application_Model_Model();
    	$this->view->role = $this->Role;
    	$this->view->id = $this->id;

    	$result    = $model->GETAllReatilerByDistributerId($params['distributor']);
    	$page      = $this->_getParam('page', 1);
    	$paginator = Zend_Paginator::factory($result);
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(15); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec  = $paginator->getTotalItemCount();
    }

    public function viewDistributerAction(){
    	$this->checklogin();
    	$params = $this->view->params = $this->getRequest()->getParams();
    	$model  = new Application_Model_Model();
    	$this->view->role = $this->Role;
    	$this->view->id = $this->id;
    	$result = $model->getDistributorsBySalePersons($params['tsi']);
    	$page      = $this->_getParam('page', 1);
    	$paginator = Zend_Paginator::factory($result);
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(15); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec  = $paginator->getTotalItemCount();
    }

    public function tseAction(){
    	$this->checklogin();
    	$params   = $this->view->params = $this->getRequest()->getParams();
    	$Retailer = new Application_Model_Retailer();

    	if ($params['user'] != "") {
    		$cond .= "and t.StaffName like '%" . $user . "%'";
    	}
    	if ($params['sale_person'] != "") {
    		$cond .= "and t.id  = '" . $params['sale_person'] . "'";
    	}

    	$query  = "select t.id,  t.StaffName as tse_name, t.MobileNo, t.Role, t.app_version, t.LoginID as tse_login_id, t.employee_code as tse_employee_code from logi_user as t  where t.Role = 'Sales' $cond";
    	$result = $this->db->fetchAll($query);

    	$sql_get_tse         = "select * from logi_user where Role = 'Sales' order by StaffName";
    	$this->view->res_tse = $res_sale = $this->db->fetchAll($sql_get_tse);

    	$page      = $this->_getParam('page', 1);
    	$paginator = Zend_Paginator::factory($result);
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(15); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec  = $paginator->getTotalItemCount();
    }

    public function tsmAction(){
    	$this->checklogin();
    	$params   = $this->view->params = $this->getRequest()->getParams();
    	$Retailer = new Application_Model_Retailer();

    	$role = 'Sales';

    	if ($params['user'] != "") {
    		$cond .= "and StaffName like '%" .$user. "%'";
    	}
    	if ($params['sale_person'] != "") {
    		$cond .= "and s.id  = '" .$params['sale_person']. "'";
    	}

    	$query  = "select s.*, t.StaffName as tse_name, t.LoginID as tse_login_id, t.employee_code as tse_employee_code from logi_user as s left join logi_user as t on (t.id = s.parent_tse) where md5(md5(s.parent_tse)) = '" . $params['datacode'] . "' and s.Role = '" . $role . "' $cond";
    	$result = $this->db->fetchAll($query);

    	$sql_get_sale         = "select * from logi_user where Role = 'Sales' order by StaffName";
    	$this->view->res_sale = $res_sale = $this->db->fetchAll($sql_get_sale);

    	$page      = $this->_getParam('page', 1);
    	$paginator = Zend_Paginator::factory($result);
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(15); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec  = $paginator->getTotalItemCount();
    }

    public function viewMappedProductAction(){
    	$this->checklogin();
    	$params    = $this->view->params = $this->getRequest()->getParams();
    	$Retailer  = new Application_Model_Retailer();
    	$result    = $Retailer->getDistributerProductList($params['datacode']);
    	$page      = $this->_getParam('page', 1);
    	$paginator = Zend_Paginator::factory($result);
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(15); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec  = $paginator->getTotalItemCount();
    }

    public function addNewUserAction(){
    	try{    	$this->checklogin();
    		$db                         = $this->db;
    		$auth                       = Zend_Auth::getInstance();
    		$authStorage                = $auth->getStorage();
    		$params                     = $this->getRequest()->getParams();
    		$this->view->role = $Role                       = $this->Role;
    		$id                         = $this->id;
    		if( $this->Role =='super_admin'){
    			$this->view->username   = $authStorage->read()->username;
    		}
    		$Retailer                   = new Application_Model_Retailer();
    		$this->view->params         = $params;

    		$this->view->getStateList   = $getStateList = $Retailer->getStateList();

    		if ($this->getRequest()->isPost()) {
    			$sql_get_region_zone = "select * from tbl_zone_state_mapping where state_id = '".$params['state']."' and status ='1'";
    			$result_region = $db->fetchRow($sql_get_region_zone);

    			if ($params['name'] == "") {
    				$this->view->errorMessage = "Please Enter User Name";
    			}
    			else {
    				$data = array();
    				if ($params['role'] == 'Distributer') {
    					$data['sap_code']                                   = $params['employee_code'];
    				} else {
    					$data['employee_code']                              = $params['employee_code'];
    				}
    				$data['StaffName']                                      = $params['name'];
    				$data['Email']                                          = $params['email'];
    				$data['MobileNo']                                       = $params['phone'];
    				$data['Address_Per']                                    = $params['permanent_address'];
    				$data['Address_Curr']                                   = $params['permanent_address'];
    				$data['role']                                           = $params['role'];
    				$data['Password']                                       = $params['password'];
    				$data['DistrictID']                                     = $params['district'];
    				$data['state']                                          = $params['state'];
    				$data['parent_regional_manager']                        = trim($params['regional_manager_id']);
    				$data['parent_zonal_manager']                           = trim($params['zonal_manager_id']);
    				$data['parent_area_manager']                            = trim($params['area_manager_id']);
    				$data['parent_sale']                                    = trim($params['sale_person_id']);
    				$data['parent_distributer']                             = trim($params['distributor_id']);
    				$data['region']                                         = $result_region['region_id'];
    				$data['zone']                                           = $result_region['zone_id'];   
    				$data['parent_id']                                      = $id;   
                    // print_r($data);
                    // exit;
    				$db->insert('logi_user', $data);
    				$lastid = $db->lastInsertId();

    				if ($params['role']=='Sales') {
    					$i = 0;
    					foreach($params['distributor'] as $value){
    						$distributor_detail                              = array();
    						$distributor_detail['StaffName']                 = $params['distributor'][$i];
    						$distributor_detail['Email']                     = $params['distrbutor_email'][$i];
    						$distributor_detail['MobileNo']                  = $params['distributor_phone'][$i];
    						$distributor_detail['parent_regional_manager']   = $params['regional_manager_id'];
    						$distributor_detail['parent_zonal_manager']      = $params['zonal_manager_id'];
    						$distributor_detail['parent_area_manager']       = $params['area_manager_id'];
    						$distributor_detail['parent_sale']               = $lastid;
    						$distributor_detail['parent_tse']                = $lastid;
    						$data['parent_id']                               = $id;
    						$distributor_detail['Role']                      = 'Distributer';
    						$db->insert('logi_user', $distributor_detail);
    						$currentDistributorId = $db->lastInsertId();

    						$updateLoginArray = array();
    						$updateLoginArray['LoginID']           = 'DIS00'.$currentDistributorId;
    						$updateLoginArray['WebLoginID']        = 'DIS00'.$currentDistributorId;
    						$updateLoginArray['Password']          = '123'; 
    						$db->update('logi_user', $updateLoginArray, array(
    							'id=?' => $currentDistributorId
    						));
    						$i++; 
    					}
    				}

    				if ($params['role'] == 'Manager') {
    					$user_login_id = 'MAN00' . $lastid;
    				}
    				else if ($params['role'] == 'ZM') {
    					$user_login_id = 'ZM00' . $lastid;
    				}
    				else if ($params['role'] == 'ASM') {
    					$user_login_id = 'ASM00' . $lastid;
    				}
    				else if ($params['role'] == 'Sales') {
    					$user_login_id = 'SAL00' . $lastid;
    				}
    				else if ($params['role'] == 'Distributer') {
    					$user_login_id = 'DIS00' . $lastid;
    				}
    				else if ($params['role'] == 'van_sale') {
    					$user_login_id = 'VAN00' . $lastid;
    				}
    				else {
    					$user_login_id = 'USER00' . $lastid;
    				}
    				$update_data                    = array();
    				$update_data['LoginID']         = $user_login_id;
    				$update_data['WebLoginID']      = $user_login_id;
    				$db->update('logi_user', $update_data, array(
    					'id=?' => $lastid
    				));
    				$this->view->successMessage = "User Detail added successfully.";
    			}
    			return;      
    		}
    	}catch( Exception $e){
    		echo $e->getMessage();
    		exit();
    	}
    }

    public function editUserAction(){

    	$this->checklogin();
    	$db                                                = $this->db;
    	$auth                                              = Zend_Auth::getInstance();
    	$authStorage                                       = $auth->getStorage();
    	$params                                            = $this->getRequest()->getParams();
    	$this->view->params                                = $params;
    	$this->Role                                        = $authStorage->read()->Role;
    	$this->id                                          = $authStorage->read()->id;
    	$model  = new Application_Model_Model();
       // $params['datacode'] = '202cb962ac59075b964b07152d234b70';
    	$this->view->getStateList                          = $getStateList                      = $model->getStateList();
    	$this->view->getUserDetailtById                    = $getUserDetailtById                = $model->getUserDetailtById($params['datacode']);
    	$this->view->getRegionalManagerList                = $getRegionalManagerList            = $model->getRegionalManagerList($this->Role, '');
    	$this->view->getZonalHeadListByRegionalManager     = $getZonalHeadListByRegionalManager = $model->getZonalHeadListByRegionalManager(md5($getUserDetailtById['parent_regional_manager']), '',  $this->Role);
    	$this->view->getAreaManagerListByZonalManager      = $getAreaManagerListByZonalManager  = $model->getAreaManagerListByZonalManager(md5($getUserDetailtById['parent_zonal_manager']), '',  $this->Role);
    	$this->view->getSalesPersonListByAreaManager       = $getSalesPersonListByAreaManager   = $model->getSalesPersonListByAreaManager(md5($getUserDetailtById['parent_area_manager']), '',  $this->Role);
    	$this->view->getDistributorsBySalePersons          = $getDistributorsBySalePersons      = $model->getDistributorsBySalePersons(md5($getUserDetailtById['parent_sale_person']), '',  $this->Role);
    	$this->view->getDistrictListByState                = $getDistrictListByState            = $model->getDistrictListByState(md5($getUserDetailtById['state']));   

    	if ($this->getRequest()->isPost()) {
    		$this->Role             = $authStorage->read()->Role;
    		$this->id               = $authStorage->read()->id;	

    		if($this->Role=='RM'){
    			$parent_regional_manager =  $this->id ;
    		}
    		else{
    			$parent_regional_manager = $params['regional_manager_id'];
    		}

    		$sql_user_detail         = "select * from logi_user where id = '".$params['userId']."'";
    		$result_user_detail      = $db->fetchRow($sql_user_detail);

    		if($result_user_detail['Role']=='Retailer'){
    			$role = $result_user_detail['Role'];
    			$parent_area_manager = $result_user_detail['parent_area_manager'];
    			$sale_person_id      = $result_user_detail['parent_sale'];
    		}
    		else{
    			$role = $params['role'];
    			$parent_area_manager = $params['area_manager_id'];
    			$sale_person_id      = $params['sale_person_id'];
    		}
    		$data = array();   
    		$data['employee_code']           = $params['employee_code'];
    		$data['sap_code']                = $params['employee_code'];
    		$data['StaffName']               = $params['name'];
    		$data['Email']                   = $params['email'];
    		$data['MobileNo']                = $params['phone'];
    		$data['Address_Per']             = $params['permanent_address'];
    		$data['Address_Curr']            = $params['permanent_address'];
    		$data['role']                    = $role; 
    		$data['Password']                = $params['password'];
    		$data['DistrictID']              = $params['district'];
    		$data['state']                   = $params['state'];
    		$data['parent_regional_manager'] = $parent_regional_manager;
    		$data['parent_zonal_manager']    = $params['zonal_manager_id'];
    		$data['parent_area_manager']     = $parent_area_manager;
    		$data['parent_sale']             = $sale_person_id;
    		$data['region']                  = $result_user_detail['region'];
    		$data['zone']                    = $result_user_detail['zone'];

    		$db->update('logi_user', $data, array('id=?' => $params['userId']));
    		$this->_redirect('user/index');
    	}
    }


    public function getSubProductListAction(){
    	$this->checklogin();
    	$this->getHelper('Layout')->disableLayout();
    	$this->getHelper('ViewRenderer')->setNoRender();
    	$this->getResponse()->setHeader('Content-Type', 'application/json');
    	$Retailer           = new Application_Model_Retailer();
    	$product_id         = $this->getRequest()->getParam('product_id');
    	$data_list_unformat = $Retailer->getSubProductListByProductId($product_id);
    	$sub_product_list[] = array(
    		"value" => "",
    		'text' => "--Select Sub Product--"
    	);
    	foreach ($data_list_unformat as $single) {
    		$sub_product_list[] = array(
    			"value" => $single['id'],
    			"text" => $single['sub_product_name']
    		);
    	}
    	$this->getHelper('Layout')->disableLayout();
    	$this->getHelper('ViewRenderer')->setNoRender();
    	$this->getResponse()->setHeader('Content-Type', 'application/json');
    	echo json_encode(array(
    		'options' => $sub_product_list
    	));
    	return;
    }

    public function getSubProductListByBrandCategoryAction(){
    	$this->checklogin();
    	$this->getHelper('Layout')->disableLayout();
    	$this->getHelper('ViewRenderer')->setNoRender();
    	$this->getResponse()->setHeader('Content-Type', 'application/json');
    	$Retailer           = new Application_Model_Retailer();
    	$product_id         = $this->getRequest()->getParam('product_id');
    	$brand_id           = $this->getRequest()->getParam('brand');
    	$data_list_unformat = $Retailer->getSubProductListByProductId($product_id, $brand_id);
    	$sub_product_list[] = array(
    		"value"         => "",
    		'text'          => "--Select Sub Product--"
    	);
    	foreach ($data_list_unformat as $single) {
    		$sub_product_list[] = array(
    			"value"     => $single['id'],
    			"text"      => $single['sub_product_name']
    		);
    	}
    	$this->getHelper('Layout')->disableLayout();
    	$this->getHelper('ViewRenderer')->setNoRender();
    	$this->getResponse()->setHeader('Content-Type', 'application/json');
    	echo json_encode(array(
    		'options'       => $sub_product_list
    	));
    	return;
    }


    public function getZonalHeadListAction(){
    	$this->checklogin();
    	$this->db = Zend_Db_Table::getDefaultAdapter();
    	$this->getHelper('Layout')->disableLayout();
    	$this->getHelper('ViewRenderer')->setNoRender();
    	$this->getResponse()->setHeader('Content-Type', 'application/json');
    	$district = $this->getRequest()->getParam('district');

    	$sql_zonal_user = "select id, StaffName from logi_user where DistrictID = '" . $district . "' and Role='ZonalHead' order by StaffName";
    	$result         = $this->db->fetchAll($sql_zonal_user);

    	$user_list[] = array(
    		"value" => "",
    		'text' => "--Select Zonal Head--"
    	);
    	foreach ($result as $single) {
    		$user_list[] = array(
    			"value" => $single['id'],
    			"text" => $single['StaffName']
    		);
    	}
    	$this->getHelper('Layout')->disableLayout();
    	$this->getHelper('ViewRenderer')->setNoRender();
    	$this->getResponse()->setHeader('Content-Type', 'application/json');
    	echo json_encode(array(
    		'options' => $user_list
    	));
    	return;
    }

    public function getRegionalManagerListAction(){
        $this->checklogin();
        $this->db = Zend_Db_Table::getDefaultAdapter();
        $this->getHelper('Layout')->disableLayout();
        $this->getHelper('ViewRenderer')->setNoRender();
        $this->getResponse()->setHeader('Content-Type', 'application/json');
        $district = $this->getRequest()->getParam('district');

        $sql_zonal_user = "select id, StaffName from logi_user where Role='RM' and Gps_status='on' order by StaffName";
        $result         = $this->db->fetchAll($sql_zonal_user);

        $user_list[] = array(
            "value" => "",
            'text' => "--Select Regional Head--"
        );
        foreach ($result as $single) {
            $user_list[] = array(
                "value" => $single['id'],
                "text" => $single['StaffName']
            );
        }
        $this->getHelper('Layout')->disableLayout();
        $this->getHelper('ViewRenderer')->setNoRender();
        $this->getResponse()->setHeader('Content-Type', 'application/json');
        echo json_encode(array(
            'options' => $user_list
        ));
        return;
    }

    public function getSalePersonDistrictWiseAction(){
    	$this->checklogin();
    	$this->getHelper('Layout')->disableLayout();
    	$this->getHelper('ViewRenderer')->setNoRender();
    	$this->getResponse()->setHeader('Content-Type', 'application/json');
    	$Retailer           = new Application_Model_Retailer();
    	$district_id        = $this->getRequest()->getParam('district_id');
    	$data_list_unformat = $Retailer->getSalePersonDistrictWise($district_id);
    	$sub_product_list[] = array(
    		"value" => "",
    		'text' => "--Select Sales Person--"
    	);
    	foreach ($data_list_unformat as $single) {
    		$sub_product_list[] = array(
    			"value" => $single['LoginID'],
    			"text" => $single['StaffName'].' (' .$single['LoginID'] .')'
    		);
    	}
    	$this->getHelper('Layout')->disableLayout();
    	$this->getHelper('ViewRenderer')->setNoRender();
    	$this->getResponse()->setHeader('Content-Type', 'application/json');
    	echo json_encode(array(
    		'options' => $sub_product_list
    	));
    	return;
    }


    public function viewUserAction(){
    	$this->checklogin();
    	$db                                  = $this->db;
    	$auth                                = Zend_Auth::getInstance();
    	$authStorage                         = $auth->getStorage();
    	$params                              = $this->getRequest()->getParams();
    	$model                               = new Application_Model_Model();
    	$this->view->params                  = $params;
    	$this->view->getUserDetailtById      = $getUserDetailtById    = $model->getUserDetailtById($params['datacode']);
    	$this->view->getStateDetailById      = $getStateDetailById    = $model->getStateDetailById($getUserDetailtById['state']);
    	$this->view->getDistrictDetailById   = $getDistrictDetailById = $model->getDistrictDetailById($getUserDetailtById['DistrictID']);
    }

    public function checkmobilenoAction(){
    	$this->checklogin();
    	$Retailer = new Application_Model_Retailer();
    	$Mobile   = $this->getRequest()->getParam('Mobile');
    	$this->getHelper('Layout')->disableLayout();
    	$this->getHelper('ViewRenderer')->setNoRender();
    	if ($Mobile != "") {
    		$result = $Retailer->CheckMobileNo($Mobile);
    		echo json_encode($result);
    	}
    }

    public function getDataListAction(){
    	$this->checklogin();
    	$this->getHelper('Layout')->disableLayout();
    	$this->getHelper('ViewRenderer')->setNoRender();
    	$this->getResponse()->setHeader('Content-Type', 'application/json');
    	$Retailer   = new Application_Model_Retailer();
    	$product_id = $this->getRequest()->getParam('product_id');
    	$data_list_unformat = $Retailer->datalist($product_id);
    	$data_list = $data_list_unformat['packing_type'];
    	echo json_encode($data_list);
    	return;
    }

    public function getDistrictListAction(){
    	$this->checklogin();
    	$this->getHelper('Layout')->disableLayout();
    	$this->getHelper('ViewRenderer')->setNoRender();
    	$this->getResponse()->setHeader('Content-Type', 'application/json');
    	$Retailer = new Application_Model_Retailer();

    	$state                  = $this->getRequest()->getParam('state');
    	$district_list_unformat = $Retailer->getDistrictListStateWise($state);
    	$district_list[]        = array(
    		"value" => "",
    		"text" => "--Select District--"
    	);
    	foreach ($district_list_unformat as $single) {
    		$district_list[] = array(
    			"value" => $single['id'],
    			"text" => $single['district']
    		);
    	}
    	echo json_encode(array(
    		'options' => $district_list
    	));
    	return;
    }


    public function deleteUserAction(){
    	$this->checklogin();

    	$db          = $this->db = Zend_Db_Table::getDefaultAdapter();
    	$auth        = Zend_Auth::getInstance();
    	$authStorage = $auth->getStorage();
    	$Retailer    = new Application_Model_Retailer();
    	$userId      = $this->getRequest()->getParam('userId');
       $query = "delete from logi_user where id = '".$userId."'";
       $db->query($query);
   }


   public function clearDeviceAction(){
     try{
      $this->checklogin();
      $db          = $this->db = Zend_Db_Table::getDefaultAdapter();
      $auth        = Zend_Auth::getInstance();
      $authStorage = $auth->getStorage();
      $userId      = $this->getRequest()->getParam('userId');
      $Retailer    = new Application_Model_Retailer();
      $query       = "select DeviceID from logi_user where id = ".$userId;   	
      $result      = $this->db->fetchRow($query);
      if($result && $result['DeviceID'] != ""){
       $device_data = array();
       $device_data['user_id'] = $userId;
       $device_data['device_id'] = $result['DeviceID'];
       $db->insert('logi_device_history',$device_data);
   }
   $data                 = array();
   $data['Device_type']  = '';
   $data['Device_token'] = '';
   $data['DeviceID']     = '';
   $db->update('logi_user', $data, array(
       'id=?' => $userId
   ));
}catch(Exception $e){
  echo $e->getMessage();exit;
}
}


public function changeStatusAction(){

 $this->checklogin();
 $db          = $this->db = Zend_Db_Table::getDefaultAdapter();
 $auth        = Zend_Auth::getInstance();
 $authStorage = $auth->getStorage();

 $model = new Application_Model_Model();
 $status_type   = $this->getRequest()->getParam('status_type');
 $id            = $this->getRequest()->getParam('id');

 $data_update           = array();
 if($status_type =='0'){
  $data_update['StaffStatus'] = 'IA';
}
if($status_type =='1'){
  $data_update['StaffStatus'] = 'AC';
}    
$db->update('logi_user', $data_update, array('id=?' => $id));
$this->_helper->layout()->disableLayout();
$this->_helper->viewRenderer->setNoRender(true);
}

public function approveRetailerAction(){

 $this->checklogin();
 $db          = $this->db = Zend_Db_Table::getDefaultAdapter();
 $auth        = Zend_Auth::getInstance();
 $authStorage = $auth->getStorage();

 $model = new Application_Model_Model();
 $status_type   = $this->getRequest()->getParam('status_type');
 $id            = $this->getRequest()->getParam('id');

 $data_update           = array();
 if($status_type =='0'){
  $data_update['approval_status'] = '1';
}
if($status_type =='1'){
  $data_update['approval_status'] = '0';
}    
$db->update('logi_user', $data_update, array('id=?' => $id));
$this->_helper->layout()->disableLayout();
$this->_helper->viewRenderer->setNoRender(true);
}

public function getFormAction(){
 $this->checklogin();
 $model = new Application_Model_Model();
 $this->_helper->layout()->disableLayout();
 $this->view->params = $params = $this->getRequest()->getParams();

 $this->view->role = $this->Role;
 $this->view->id = $this->id;

 $sql_distributer_user = "select id, StaffName, LoginID from logi_user where Role='Distributer' order by StaffName";
 $this->view->result = $result = $this->db->fetchAll($sql_distributer_user);
 if($this->Role=='RM'){
  $id = $this->id;
}
else{
  $id = $this->parent_regional_manager;
}

$getTableLastUserId                 = $model->GetLastID();
$this->view->getRegionalManagerList = $getRegionalManagerList = $model->getRegionalManagerList($this->Role, $id, $this->id);

if ($params['role'] == 'Manager') {
  $user_login_id = 'MAN00' .$getTableLastUserId['id'];
} else if ($params['role'] == 'ZM') {
  $user_login_id = 'ZM00' .$getTableLastUserId['id'];
} else if ($params['role'] == 'ASM') {
  $user_login_id = 'ASM00' .$getTableLastUserId['id'];
} else if ($params['role'] == 'Sales') {
  $user_login_id = 'SAL00' .$getTableLastUserId['id'];
} else if ($params['role'] == 'Distributer') {
  $user_login_id = 'DIS00' .$getTableLastUserId['id'];
} else {
  $user_login_id = 'USER00' .$getTableLastUserId['id'];
}
$this->view->user_login_id = $user_login_id;
}

public function getEditFormAction(){
 $this->checklogin();
 $model = new Application_Model_Model();
 $this->_helper->layout()->disableLayout();
 $this->view->params = $params = $this->getRequest()->getParams();

 $this->view->role = $this->Role;
 $this->view->id = $this->id;
 $this->view->getRegionalManagerList = $getRegionalManagerList = $model->getRegionalManagerList($this->Role, $id);
 $this->view->getUserDetailtById     = $getUserDetailtById     = $model->getUserDetailtById($params['datacode']);      
}


public function getZonalHeadListAjaxAction(){
 $this->checklogin();

 $this->getHelper('Layout')->disableLayout();
 $this->getHelper('ViewRenderer')->setNoRender();
 $this->getResponse()->setHeader('Content-Type', 'application/json');
 $model = new Application_Model_Model();
 $this->view->role = $this->Role;
 $this->view->id = $this->id;

 if($this->Role=='ZM'){
  $id = $this->id;
}
else{
  $id = $this->parent_zonal_manager;
}
$rm_id              = $this->getRequest()->getParam('rm_id');
$user_list_unformat = $model->getZonalHeadListByRegionalManager(md5($rm_id), $id, $this->Role);
$user_list[]        = array(
  "value" => "",
  "text" => "--Select Zonal Head--"
);
foreach ($user_list_unformat as $single) {
  $user_list[] = array(
   "value" => $single['id'],
   "text" => $single['StaffName'] . '(' . $single['LoginID'] . ')'
);
}
echo json_encode(array(
  'options' => $user_list
));
return;
}

public function getAreaManagerListAction(){
 $this->checklogin();

 $this->getHelper('Layout')->disableLayout();
 $this->getHelper('ViewRenderer')->setNoRender();
 $this->getResponse()->setHeader('Content-Type', 'application/json');
 $model = new Application_Model_Model();

 $this->view->role = $this->Role;
 $this->view->id = $this->id;

 if($this->Role=='ASM'){
  $id = $this->id;
}
else{
  $id = $this->parent_area_manager;
}

$zm_id              = $this->getRequest()->getParam('zm_id');
$user_list_unformat = $model->getAreaManagerListByZonalManager(md5($zm_id), $id, $this->Role);
$user_list[]        = array(
  "value" => "",
  "text" => "--Select Area Manager--"
);
foreach ($user_list_unformat as $single) {
  $user_list[] = array(
   "value" => $single['id'],
   "text" => $single['StaffName'] . '(' . $single['LoginID'] . ')'
);
}
echo json_encode(array(
  'options' => $user_list
));
return;
}

public function getSalesPersonListAction(){
 $this->checklogin();

 $this->getHelper('Layout')->disableLayout();
 $this->getHelper('ViewRenderer')->setNoRender();
 $this->getResponse()->setHeader('Content-Type', 'application/json');
 $model = new Application_Model_Model();

 $this->view->role = $this->Role;
 $this->view->id = $this->id;

 if($this->Role=='Sales'){
  $id = $this->id;
}
else{
  $id = $this->parent_sale;
}
$am_id              = $this->getRequest()->getParam('am_id');
$user_list_unformat = $model->getSalesPersonListByAreaManager(md5($am_id), $id, $this->Role);
$user_list[]        = array(
  "value" => "",
  "text" => "--Select TSI--"
);
foreach ($user_list_unformat as $single) {
  $user_list[] = array(
   "value" => $single['id'],
   "text" => $single['StaffName'] . '(' . $single['LoginID'] . ')'
);
}
echo json_encode(array(
  'options' => $user_list
));
return;
}

public function getDistributerAction(){
 $this->checklogin();

 $this->getHelper('Layout')->disableLayout();
 $this->getHelper('ViewRenderer')->setNoRender();
 $this->getResponse()->setHeader('Content-Type', 'application/json');
 $model = new Application_Model_Model();

 $this->view->role = $this->Role;
 $this->view->id = $this->id;

 if($this->Role=='Distributer'){
  $id = $this->id;
}
else{
  $id = $this->parent_sale;
}
$am_id              = $this->getRequest()->getParam('am_id');
$user_list_unformat = $model->getDistributerListByAreaManager(md5($am_id), $id, $this->Role);
$user_list[]        = array(
  "value" => "",
  "text" => "--Select Distributer--"
);
foreach ($user_list_unformat as $single) {
  $user_list[] = array(
   "value" => $single['id'],
   "text" => $single['StaffName'] . '(' . $single['LoginID'] . ')'
);
}
echo json_encode(array(
  'options' => $user_list
));
return;

}

public function getUserListAction(){
 $this->checklogin();
 $db = $this->db          = Zend_Db_Table::getDefaultAdapter();
 $auth                    = Zend_Auth::getInstance();
 $authStorage             = $auth->getStorage();
 $this->WebLoginID        = $authStorage->read()->WebLoginID;
 $this->Role              = $authStorage->read()->Role;
 $this->id                = $authStorage->read()->id;
 $model  = new Application_Model_Model();
 $params                  = $this->view->params = $this->getRequest()->getParams();

 if($params['user_type']){
  $role = $params['user_type'];
}
else{
  if($this->Role =='super_admin'){
   $role = 'RM';
}
else{
   $role = $this->Role;
}
}
$this->view->role = $role;

$getUserListByLogiDetail = $model->getUserList($role, $params['search_name'], $params['search_mobile'], $params['search_employee_code'],$this->Role, $this->id, $params['region'], $params['zone']);
$page                    = $this->_getParam('page', 1);
$paginator               = Zend_Paginator::factory($getUserListByLogiDetail);
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(3000); // number of items to show per page
        $this->view->paginator   = $paginator;
        $this->view->totalrec    = $paginator->getTotalItemCount();
        $this->getHelper('Layout')->disableLayout();          
    }


    public function getTsiListByDistributerAction(){
    	$this->checklogin();
    	$this->db = Zend_Db_Table::getDefaultAdapter();
    	$this->getHelper('Layout')->disableLayout();
    	$this->getHelper('ViewRenderer')->setNoRender();
    	$this->getResponse()->setHeader('Content-Type', 'application/json');
    	$distributor_id = $this->getRequest()->getParam('distributor_id');

    	$tsiListQuery = "select * from logi_user where parent_sale = '" . $distributor_id . "' and Role='sales' order by StaffName";
    	$result         = $this->db->fetchAll($tsiListQuery);

    	$user_list[] = array(
    		"value" => "",
    		'text' => "--Select Distributor--"
    	);
    	foreach ($result as $single) {
    		$user_list[] = array(
    			"value" => $single['id'],
    			"text" => $single['StaffName'].'('.$single['LoginID'].')'
    		);
    	}
    	$this->getHelper('Layout')->disableLayout();
    	$this->getHelper('ViewRenderer')->setNoRender();
    	$this->getResponse()->setHeader('Content-Type', 'application/json');
    	echo json_encode(array(
    		'options' => $user_list
    	));
    	return;
    }

    public function getDistributorListByTsiAction(){

    	$this->checklogin();
    	$this->db = Zend_Db_Table::getDefaultAdapter();
    	$this->getHelper('Layout')->disableLayout();
    	$this->getHelper('ViewRenderer')->setNoRender();
    	$this->getResponse()->setHeader('Content-Type', 'application/json');
    	$tsi_id = $this->getRequest()->getParam('tsi_id');

    	$sql_zonal_user = "select id, StaffName, LoginID from logi_user where Role='Distributer' order by StaffName";
    	$this->view->result = $result = $this->db->fetchAll($sql_zonal_user);

    	$user_list[] = array(
    		"value" => "",
    		'text' => "--Select Distributor--"
    	);
    	foreach ($result as $single) {
    		$user_list[] = array(
    			"value" => $single['id'],
    			"text" => $single['StaffName'].'('.$single['LoginID'].')'
    		);
    	}
    	$this->getHelper('Layout')->disableLayout();
    	$this->getHelper('ViewRenderer')->setNoRender();
    	$this->getResponse()->setHeader('Content-Type', 'application/json');
    	echo json_encode(array(
    		'options' => $user_list
    	));
    	return;
    }


    public function getUserDetailAction(){
    	$this->checklogin();
    	$layout = $this->_helper->layout();
    	$layout->disableLayout('');
    	$params = $this->view->params = $this->getRequest()->getParams();
    	$sql_user = "select u.*, s.state as state_name, d.district as district_name, rm.StaffName as regional_manager, zm.StaffName as zonal_manager, am.StaffName as area_manager, tsi.StaffName as tsi, dis.StaffName as distributor  from  logi_user as u left join logi_user as rm on (u.parent_regional_manager = rm.id) left join logi_user as am on (u.parent_area_manager = am.id) left join logi_user as tsi on (u.parent_sale = tsi.id) left join logi_user as dis on (u.parent_distributer = dis.id) left join logi_user as zm on (u.parent_zonal_manager = zm.id) left join state as s on (u.state = s.id) left join district as d on (u.DistrictID = d.id) where  u.id = '".$params['id']."'";
    	$this->view->result_user = $result_user = $this->db->fetchRow($sql_user);

    }

    public function getUserActivityAction(){
    	$this->checklogin();
    	$layout = $this->_helper->layout();
    	$layout->disableLayout('');
    	$params = $this->view->params = $this->getRequest()->getParams();
    	if($params['date_from']){
    		$curr_date = $params['date_from'];
    	}
        // print_r($curr_date);
    	$sql_user = "select u.*, s.state as state_name, d.district as district_name, rm.StaffName as regional_manager, zm.StaffName as zonal_manager, am.StaffName as area_manager, tsi.StaffName as tsi, dis.StaffName as distributor  from  logi_user as u left join logi_user as rm on (u.parent_regional_manager = rm.id) left join logi_user as am on (u.parent_area_manager = am.id) left join logi_user as tsi on (u.parent_sale = tsi.id) left join logi_user as dis on (u.parent_distributer = dis.id) left join logi_user as zm on (u.parent_zonal_manager = zm.id) left join state as s on (u.state = s.id) left join district as d on (u.DistrictID = d.id) where  u.id = '".$params['id']."'";
    	$this->view->result_user = $result_user = $this->db->fetchRow($sql_user);

    	

    	$query = "SELECT * FROM logi_user WHERE id = '".$params['id']."'";
    	$this->view->result = $result = $this->db->fetchRow($query);
       $Retailer = "select retailer_check_in_out.*, logi_user.id as users_id,logi_user.Address_Curr,logi_user.StaffName,logi_user.Created from retailer_check_in_out left join logi_user on  (logi_user.id = retailer_check_in_out.retailer) where  date(retailer_check_in_out.timedate) = '".$curr_date."' AND status ='checkin' and retailer_check_in_out.saleperson = '".$result['id']."' and logi_user.Created != '".$curr_date."' group by  retailer_check_in_out.retailer "    ; 


       $Retailer = $this->db->fetchAll($Retailer); 
       $final_array = array();
       foreach ($Retailer as $results) {
         $created =  date('Y-m-d',strtotime($results['Created']));
        // if (  $created != $curr_date) {
         $gRetailer = "select * from retailer_check_in_out where  date(timedate) = '".$curr_date."' AND status ='checkin' and saleperson = '".$results['saleperson']."' and retailer = '".$results['retailer']."'  ORDER BY timedate ASC limit 1"; 
         $Retailercheckin = $this->db->fetchRow($gRetailer); 

         $TagRetailer = "select * from retailer_check_in_out where  date(timedate) = '".$curr_date."' AND status ='checkout' and saleperson = '".$results['saleperson']."'  and retailer = '".$results['retailer']."'  ORDER BY timedate desc limit 1"  ;
         $Retailercheckout = $this->db->fetchRow($TagRetailer);  
            // print_r();
            // $check_out_date_time =  $Retailercheckout['timedate']; 
         $check_in_date =  date('Y-m-d',strtotime($Retailercheckin['timedate']));
         $check_in_time =  date('H:i:s',strtotime($Retailercheckin['timedate']));
         $check_out_time =  date('H:i:s',strtotime($Retailercheckout['timedate']));

         $diff_time=(strtotime($Retailercheckout['timedate'])-strtotime($results['timedate']))/60;
         if($diff_time >= 3){

            $detail = array(
                'id'=>$results['users_id'],
                'Retailer'=>$results['StaffName'],
                'address'=>$results['Address_Curr'],
                'checkouttime'=>$check_out_date_time,
                'checkintimedate'=>$Retailercheckin['timedate'], 
                'checkintime'=>$check_in_time, 
                'check_out_time'=>$Retailercheckout['timedate'], 
                'check_in_date'=>$check_in_date
            );

            
            array_push($final_array, $detail);  
        }
        

        

     // }

    }
    $sqlTagRetailer = "select logi_user.*, retailers_site_location.created as added_date from logi_user left join retailers_site_location on (retailers_site_location.retailer_id = logi_user.id) where date(logi_user.Created) = '".$curr_date."' and logi_user.parent_sale = '".$params['id']."'";
    $addRetailer = $this->db->fetchAll($sqlTagRetailer); 


    $this->view->addRetailer = $addRetailer;

    $this->view->final_array = $final_array;

}

public function getZoneListAjaxAction(){
   $db=  $this->db = Zend_Db_Table::getDefaultAdapter();
   $region_id =  $this->_getParam('region_id');

   $query =" select * from tbl_zone where region_id = '".$region_id."' and status = '1'";
   $result_list_unformat = $this->db->fetchAll($query);

   $zone_list[] = array("value"=>"",'text'=>"--Select Zone--");
   foreach($result_list_unformat as $single){
      $zone_list[] = array("value"=>$single['id'],"text"=>$single['zone_name']);
  }
  $this->getHelper('Layout')->disableLayout();
  $this->getHelper('ViewRenderer')->setNoRender();
  $this->getResponse()->setHeader('Content-Type', 'application/json');
  echo json_encode(array('options'=>$zone_list));
  return; 
}


public function transferDataAction(){
   $db=  $this->db = Zend_Db_Table::getDefaultAdapter();
   $layout = $this->_helper->layout();
   $layout->disableLayout('');
   $model = new Application_Model_Model();
   $this->view->messages = $this->_flashMessenger->getMessages();
   $params = $this->view->params     = $this->getRequest()->getParams();
   $sql_user_detail   = "select * from logi_user where id = '".$params['id']."'";
   $this->view->res_user_detail = $res_user_detail   = $db->fetchRow($sql_user_detail);

   if($res_user_detail['Role']=='RM'){
      $sql_similar_users = "select id, StaffName, LoginID from logi_user where Role = 'RM' and StaffStatus = 'AC' and id !='".$res_user_detail['id']."'";
  }
  elseif($res_user_detail['Role']=='ZM'){
      $sql_similar_users = "select id, StaffName, LoginID from logi_user where Role = 'ZM' and StaffStatus = 'AC' and parent_regional_manager = '".$res_user_detail['parent_regional_manager']."' and id !='".$res_user_detail['id']."'";
  }
  elseif($res_user_detail['Role']=='ASM'){
      $sql_similar_users = "select id, StaffName, LoginID from logi_user where Role = 'ASM' and StaffStatus = 'AC' and parent_regional_manager = '".$res_user_detail['parent_regional_manager']."' and parent_zonal_manager = '".$res_user_detail['parent_zonal_manager']."' and id !='".$res_user_detail['id']."'";
  }
  elseif($res_user_detail['Role']=='Sales'){
      $sql_similar_users = "select id, StaffName, LoginID from logi_user where Role = 'Sales' and StaffStatus = 'AC' and parent_regional_manager = '".$res_user_detail['parent_regional_manager']."' and parent_zonal_manager = '".$res_user_detail['parent_zonal_manager']."' and parent_area_manager = '".$res_user_detail['parent_area_manager']."' and id !='".$res_user_detail['id']."'";
  }
  elseif($res_user_detail['Role']=='Distributer'){
      $sql_similar_users = "select id, StaffName, LoginID from logi_user where Role = 'Distributer' and StaffStatus = 'AC' and parent_regional_manager = '".$res_user_detail['parent_regional_manager']."' and parent_zonal_manager = '".$res_user_detail['parent_zonal_manager']."' and parent_sale = '".$res_user_detail['parent_sale']."' and id !='".$res_user_detail['id']."'";
  }
  $this->view->res_similar_users = $res_similar_users = $db->fetchAll($sql_similar_users); 
  if($this->getRequest()->isPost() && $params['submit'] == 'submit'){

      if($params['Role']=='RM'){
         $sql_update_user = "update logi_user set parent_regional_manager = '".$params['to_user']."' where parent_regional_manager = '".$params['id']."'"; 
     }
     elseif($params['Role']=='ZM'){
         $sql_update_user = "update logi_user set parent_zonal_manager = '".$params['to_user']."' where parent_zonal_manager = '".$params['id']."'";
     }
     elseif($params['Role']=='ASM'){
         $sql_update_user = "update logi_user set parent_area_manager = '".$params['to_user']."' where parent_area_manager = '".$params['id']."'";
     }
     elseif($params['Role']=='Sales'){
         $sql_update_user = "update logi_user set parent_sale = '".$params['to_user']."' where parent_sale = '".$params['id']."'";
     }
     elseif($params['Role']=='Distributer'){
         $sql_update_user = "update logi_user set parent_distributer = '".$params['to_user']."' where parent_distributer = '".$params['id']."'";
     }
     $db->query($sql_update_user);

     $this->_flashMessenger->addMessage('Data transfered successfully.');
     $this->_redirect('user/index');        
 }   
}        

public function distributorWarehouseMappingAction(){
   $this->checklogin();
   try{
      $db = $this->db = Zend_Db_Table::getDefaultAdapter();
      $this->view->params = $params = $this->getRequest()->getParams();

      $distributorsSql = "select dwa.*, u.StaffName,w.warehouse_name,w.warehouse_code from distributor_warehouse_associations as dwa left join logi_user as u on u.id = dwa.distributor_id left join logi_warehouse as w on w.id = dwa.warehouse_id ";
      $distributors  = $db->fetchAll($distributorsSql);

      $final_assosiations = array();
      $this->view->assosiations = $distributors;     

  }catch(Exception $e){
      echo $e->getMessage();exit;
  }
}

public function addDistributorWarehouseMappingAction(){
   try{
      $this->checklogin();
      $this->view->messages = $this->_flashMessenger->getMessages();
      $db = $this->db = Zend_Db_Table::getDefaultAdapter();
      $this->view->params = $params = $this->getRequest()->getParams();
      $distributorsSql = "SELECT * FROM logi_user WHERE Role = 'Distributer'  and StaffStatus = 'AC' ORDER BY StaffName ";
      $this->view->distributors  = $db->fetchAll($distributorsSql);

      $warehousesSql = "SELECT * FROM logi_warehouse WHERE status = 1";
      $this->view->warehouses  = $db->fetchAll($warehousesSql);

      if ($this->getRequest()->isPost()) {
         $checkSql = "select * from distributor_warehouse_associations where warehouse_id=".$params['warehouse_id'];
         $result = $db->fetchRow($checkSql); 
         if(!$result){
            $mappingArray = array();
            $mappingArray['distributor_id'] = $params['distributor_id'];
            $mappingArray['warehouse_id'] = $params['warehouse_id'];
            $db->insert('distributor_warehouse_associations',$mappingArray);
            $this->view->successMessage = "Mapping added successfully.";
            $this->_redirect("/user/distributor-warehouse-mapping/"); 
        }else{
            echo "Warehouse already Assigned";
            exit;
        }
    }
}catch(Exception $e){
  echo $e->getMessage();exit;
}
}

public function editDistributorWarehouseMappingAction(){
   try{
      $this->checklogin();
      $db = $this->db = Zend_Db_Table::getDefaultAdapter();
      $this->view->params = $params = $this->getRequest()->getParams();
      $distributorsSql = "SELECT * FROM logi_user WHERE Role = 'Distributer'  and StaffStatus = 'AC' ORDER BY StaffName ";
      $this->view->distributors  = $db->fetchAll($distributorsSql);

      $warehousesSql = "SELECT * FROM logi_warehouse WHERE status = 1";
      $this->view->warehouses  = $db->fetchAll($warehousesSql);

      if ($this->getRequest()->isPost()) {
         $mapping = array();
         $mapping['distributor_id'] = $params['distributor_id'];
         $mapping['warehouse_id'] = $params['warehouse_id'];
         $db->update('distributor_warehouse_associations', $mapping, array('id=?' => $params['id']));
         $this->view->successMessage = "Mapping Update successfully.";
         $this->_redirect("/user/distributor-warehouse-mapping"); 

     }
 }catch(Exception $e){
  echo $e->getMessage();exit;
}
}


public function changeLocationAction(){
    $this->checklogin();
    $db                         = $this->db;
    $params                     = $this->getRequest()->getParams();
    $this->view->params         = $params;
    $sql_area = "select * from logi_location order by location_name";
    $this->view->area_list = $area_list = $db->fetchAll($sql_area);
    if ($this->getRequest()->isPost()) {
        // print_r($params); exit;
        $updateUser = array();
        if($params['area']){
            $sql_mapped_location = "select id from logi_user_location_mapping where location_id = '".$params['area']."'";
            $mappded_location_id = $db->fetchRow($sql_mapped_location);
            $updateUser['area_id']       = $mappded_location_id['id'];
        }

        if($params['latitude']  && $params['longitude']){
            $updateUser['tagged_latitude']    = $params['latitude'];
            $updateUser['tagged_longitude']   = $params['longitude']; 

            $update_location = array();
            $update_location['lat']    = $params['latitude'];
            $update_location['long']   = $params['longitude'];
            $db->update('retailers_site_location', $update_location, array(
                'retailer_id=?' => $params['id']
            )); 
        } 
        $db->update('logi_user', $updateUser, array(
            'id=?' => $params['id']
        ));
        $this->view->params         = $params;
        $this->view->successMessage = "Mapping Update successfully.";
        $this->_redirect("/user/change-location/id/".$params['id'].'/area/'.$params['area'].'/latitude/'.$params['latitude'].'/longitude/'.$params['longitude'].'/type/success'); 
    }   
}


public function approveChangeLocationAction(){
    $this->checklogin();
    $db                         = $this->db;
    $params                     = $this->getRequest()->getParams();
    $this->view->params         = $params;
    $sql_area = "select * from logi_location order by location_name";
    $this->view->area_list = $area_list = $db->fetchAll($sql_area);


    if($params['id']){
        $updateLocationArray = array();
        $updateLocationArray['change_location_status']   = '2';
        $db->update('logi_user', $updateLocationArray, array(
            'id=?' => $params['id']
        ));
        $this->view->successMessage = "Request approved successfully.";
        $this->_redirect("/user/index"); 
    }  
}


public function checklogin(){
   $auth         = Zend_Auth::getInstance();
   $errorMessage = "";
   /*************** check user identity ************/
   if (!$auth->hasIdentity()) {
      $this->_redirect('admin/index');
  }
}
}
