<?php

/***************************************************************
 * Logimetrix Techsolutions Pvt. Ltd.
 * File Name   : UserBmcMappingController.php
 * File Description  : UserBmcMappingController
 * Created By : Arpita Upadhyay
 * Created Date: 14 June 2019
 ***************************************************************/

class UserBmcMappingController extends Zend_Controller_Action{
	var $dbAdapter;
	var $db;
	public function init(){
		/* Initialize action controller here */
		$bootstrap = $this->getInvokeArg('bootstrap');
		$aConfig = $bootstrap->getOptions();
		$this->db = Zend_Db_Table::getDefaultAdapter();
		$auth = Zend_Auth::getInstance();
		$authStorage = $auth->getStorage();
		$this->WebLoginID = $authStorage->read()->WebLoginID;
		$this->_flashMessenger  = $this->_helper->getHelper('FlashMessenger');		
		$users = new Application_Model_Users();
		$logout_details = $users->getUserLoginDetailByWebLoginCode($this->WebLoginID);
		$this->view->last_login = $logout_details['login_time'];               
	}

	public function indexAction(){
		$this->checklogin();
		try{
			$params = $this->view->params = $this->getRequest()->getParams();
			$this->view->messages = $this->_flashMessenger->getMessages();

			$db = $this->db = Zend_Db_Table::getDefaultAdapter();
			$result = array();
			$user_query = "SELECT bmc.id, user.StaffName,bmc.user_id FROM logi_user_bmc_mapping as bmc
			left join logi_user as user on (user.id = bmc.user_id) group by user_id";
			$users = $db->fetchAll($user_query);
			foreach ($users as $user) {
				$user_bmc_query = "SELECT * FROM logi_user_bmc_mapping  where user_id=".$user['user_id'];
				$user_bmc_results = $db->fetchAll($user_bmc_query);
				// print_r($user_bmc_results);
				// exit();
				$locations = array();
				foreach ($user_bmc_results as $user_bmc) {
					$location = $user_bmc['location_name']."(".$user_bmc['latitude'].",".$user_bmc['longitude'].")";
					array_push($locations, $location);
				}
				$user['location'] = $locations;
				array_push($result, $user);
			}			
			// echo "<pre>";
			// print_r($result);
			// exit;
			$page=$this->_getParam('page',1);
			$paginator = Zend_Paginator::factory($result);      
			$paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); 
			$paginator->setItemCountPerPage(10); 
			$this->view->paginator = $paginator;
			$this->view->totalrec = $paginator->getTotalItemCount();
		}catch(Exception $e){
			echo $e->getMessage();exit;
		}

	}

	public function addUserBmcMappingAction(){
		try{

			$this->checklogin();
			$db = $this->db = Zend_Db_Table::getDefaultAdapter();
			$this->view->params = $params = $this->getRequest()->getParams();
			$this->view->messages = $this->_flashMessenger->getMessages();

			$auth = Zend_Auth::getInstance();
			$authStorage = $auth->getStorage();
			$sql = "select id,StaffName from logi_user WHERE StaffStatus = 'AC' && Role ='FSV' ";
			$this->view->role = $role = $db->fetchAll($sql);
			
			$sql_bmc          = "select * from logi_bmc";
			$this->view->bmc_users = $bmc_users = $db->fetchAll($sql_bmc);
			
			if($this->getRequest()->isPost()){
				$bmcData = array();
				$sql_bmc          = "select * from logi_bmc where id=".$params['location_name'];
				$location = $db->fetchRow($sql_bmc);
				$bmcData['location_name'] = $location['location_name'];
				$bmcData['latitude'] = $location['latitude'];
				$bmcData['longitude'] = $location['longitude'];
				$bmcData['user_id'] = $params['staffname'];
				$db->insert('logi_user_bmc_mapping', $bmcData);
				$this->_flashMessenger->addMessage('User Bmc added successfully.');

				
				$this->_redirect("user-bmc-mapping/"); 
			}

		}catch(Exception $e){
			echo $e->getMessage();exit;
		}
	}

	public function editUserBmcMappingAction(){
		try {

			$this->checklogin();
			$db = $this->db;
			
			$this->view->params               = $params = $this->getRequest()->getParams('id');
			$this->view->messages = $this->_flashMessenger->getMessages();

			$model                            = new Application_Model_Model();
			$this->view->getBmcDetailById  = $getBmcDetailById = $model->getBmcDetailById($params['datacode']);
			$query_bmc = "select id, location_name from  logi_bmc";
			$this->view->bmc_locations = $db->fetchAll($query_bmc);

			$user_bmc_query = "select * from  logi_user_bmc_mapping where md5(md5(user_id))= '".$params['datacode']."'";
			$this->view->user_bmc_locations = $db->fetchAll($user_bmc_query);
			

			if($this->getRequest()->isPost()){
				
				try{


					$bmcData = array();
					$deletemapping = "delete from logi_user_bmc_mapping where user_id=".$getBmcDetailById['user_id'];
					$db->query($deletemapping);
					foreach($params['location_name'] as $location_data){
						$location_query = "select * from  logi_bmc where id=".$location_data;
						$location = $db->fetchRow($location_query);
						$update_user_bmc_mapping = array();
						$update_user_bmc_mapping['user_id']     = $getBmcDetailById['user_id'];
						$update_user_bmc_mapping['location_name']   = $location['location_name'];
						$update_user_bmc_mapping['latitude']   = $location['latitude'];
						$update_user_bmc_mapping['longitude']   = $location['longitude'];
						$db->insert('logi_user_bmc_mapping', $update_user_bmc_mapping);
					}
				}catch(Exception $e){
					echo $e->getMessage();exit;
				}

				$this->_flashMessenger->addMessage('User Bmc updated successfully.');

				$this->_redirect("user-bmc-mapping/"); 
			}      
		} catch(Exception $e) {
			echo $e->getMessage();
			exit();
		}
	}

	public function deleteUserBmcMappingAction(){
		$this->checklogin();
		$db                   = $this->db;
		$auth                 = Zend_Auth::getInstance();
		$authStorage          = $auth->getStorage();
		$params               = $this->getRequest()->getParams();
		$this->view->messages = $this->_flashMessenger->getMessages();
		

		$sql_bmc = "DELETE FROM `logi_user_bmc_mapping` where  user_id = '".$params['id']."'";
		$db->query($sql_bmc);
		
		$this->_flashMessenger->addMessage('User Bmc Deleted successfully.');
		
		$this->_helper->layout()->disableLayout(); 
		$this->_helper->viewRenderer->setNoRender(true);
	}

	

	public function checklogin(){   
		$auth = Zend_Auth::getInstance(); 
		$errorMessage = ""; 
		/*************** check user identity ************/
		if(!$auth->hasIdentity()){
			$this->_redirect('admin/index');  
		}   
	}     
}