<?php

/***************************************************************
 * Logimetrix Techsolutions Pvt. Ltd.
 * File Name   : ReportsController.php
 * File Description  : ReportsController
 * Created By : Puneet Mishra
 * Created Date: 16 Nov 2016
 ***************************************************************/

class TestreportController extends Zend_Controller_Action{
	var $dbAdapter;
	var $db;
	public function init(){
		/* Initialize action controller here */
		$bootstrap = $this->getInvokeArg('bootstrap');
		$aConfig = $bootstrap->getOptions();
		$this->db = Zend_Db_Table::getDefaultAdapter();
		$auth = Zend_Auth::getInstance();
		$authStorage = $auth->getStorage();
		$this->WebLoginID = $authStorage->read()->LoginID;
		$users = new Application_Model_Users();
		$logout_details = $users->getUserLoginDetailByWebLoginCode($this->WebLoginID);
		$this->Role                    = $authStorage->read()->Role;
		$this->role                    = $authStorage->read()->Role;
		$this->id                      = $authStorage->read()->id;
		$this->LoginID                 = $authStorage->read()->LoginID;
		$this->parent_regional_manager = $authStorage->read()->parent_regional_manager;
		$this->parent_zonal_manager    = $authStorage->read()->parent_zonal_manager;
		$this->parent_area_manager     = $authStorage->read()->parent_area_manager;
		$this->parent_sale             = $authStorage->read()->parent_sale;
		$this->view->last_login = $logout_details['login_time'];      
	}

	public function allOrderListAction(){
		$this->checklogin();
		$this->db = Zend_Db_Table::getDefaultAdapter();
		$db = $this->db;
		$auth = Zend_Auth::getInstance();
		$authStorage = $auth->getStorage();
		$this->WebLoginID = $authStorage->read()->LoginID;
		$params = $this->view->params = $this->getRequest()->getParams(); 
		$Retailer = new Application_Model_Retailer();

		$this->view->result = $result = $Retailer->getAllOrderListOfDistributers(); 


		$page=$this->_getParam('page',1);
		$paginator = Zend_Paginator::factory($result);      
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(15); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec = $paginator->getTotalItemCount();   

      }

      public function retailerTaggingAction(){
       $this->checklogin();
       $params = $this->view->params = $this->getRequest()->getParams(); 
       $Retailer = new Application_Model_Retailer(); 
       $gmap = new Application_Model_Gmap();
       $this->view->getUserList = $gmap->getUserList($this->role, $this->id);

       $role = $this->role;
       $id   = $this->id;

       $date_from = $params['date_from'];
       $date_to = $params['date_to'];

       $this->view->getRetailerTaggingData = $result = $Retailer->getRetailerTaggingData($params['sale_person'],$date_from, $date_to,$role, $id );
       $this->view->getRetailerTaggingCountData = $getRetailerTaggingCountData = $Retailer->getRetailerTaggingCountData($params['sale_person'],$date_from, $date_to,$role, $id);

       $page=$this->_getParam('page',1);
       $paginator = Zend_Paginator::factory($result);      
          $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
          $paginator->setItemCountPerPage(15); // number of items to show per page
          $this->view->paginator = $paginator;
          $this->view->totalrec = $paginator->getTotalItemCount();
          // print_r($paginator);exit;
          if($params['tagging'] == 'Generate'){

          	$data = array(array('Sr. No.'=> "", 'Retailer Name'=> "", 'Retailer Mobile No'=> "", 'Sale Person Name'=> "",'Sale Person Login Id'=> "",'Sale Person Mobile No'=> "",'Tagging Date'=> ""));
          	$i = 2; 
          	foreach ($result as $rs) {

          		$tagging_date = date("d/m/Y", strtotime($rs['date(rsl.taging_date)']));
          		$row = array();
          		$row[] = stripslashes($i-1);
          		$row[] = stripslashes($rs["Retailer"]);
          		$row[] = stripslashes($rs["retailer_mobil_no"]);
          		$row[] = stripslashes($rs["Sale_person_name"]);
          		$row[] = stripslashes($rs["sale_login"]);
          		$row[] = stripslashes($rs["sale_person_mob"]);
          		$row[] = stripslashes($tagging_date);

          		$data[] = $row;
          		$i++;
          	}
          	function filterData(&$str){
          		$str = preg_replace("/\t/", "\\t", $str);
          		$str = preg_replace("/\r?\n/", "\\n", $str);
          		if(strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
          	}

                // file name for download
          	$fileName = "retailer_tagging_report.xls"; 

                // headers for download
          	header("Content-Disposition: attachment; filename=\"$fileName\"");
          	header("Content-Type: application/vnd.ms-excel");

          	$flag = false;
          	foreach($data as $row) {
          		if(!$flag) {
                        // display column names as first row
          			echo implode("\t", array_keys($row)) . "\n";
          			$flag = true;
          		}
                    // filter data
          		array_walk($row, 'filterData');
          		echo implode("\t", array_values($row)) . "\n";
          	}
          	exit;
          }
        }


        public function orderListInCurrentDateAction(){

         $this->checklogin();
         $this->db = Zend_Db_Table::getDefaultAdapter();
         $db = $this->db;
         $auth = Zend_Auth::getInstance();
         $authStorage = $auth->getStorage();
         $this->WebLoginID = $authStorage->read()->LoginID;
         $params = $this->view->params = $this->getRequest()->getParams(); 
         $Retailer = new Application_Model_Retailer();
         if($params['date'] !=''){     
          $curr_date = @date('Y-m-d',strtotime($params['date']));
        }
        else{
          $curr_date = date("Y-m-d");
        }

        $this->view->result = $result = $Retailer->getAllOrderListOfDistributersInCurrentDate($curr_date); 

        $page=$this->_getParam('page',1);
        $paginator = Zend_Paginator::factory($result);      
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(15); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec = $paginator->getTotalItemCount();   
      }

      public function distributerOrderSummaryInCurrentDateAction(){
       $this->checklogin();
       $this->db = Zend_Db_Table::getDefaultAdapter();
       $db = $this->db;
       $auth = Zend_Auth::getInstance();
       $authStorage = $auth->getStorage();
       $this->WebLoginID = $authStorage->read()->LoginID;
       $params = $this->view->params = $this->getRequest()->getParams(); 
       $Retailer = new Application_Model_Retailer();
       if($params['date'] !=''){
        $curr_date = @date('Y-m-d',strtotime($params['date']));
      }
      else{
        $curr_date = date("Y-m-d");
      }
      $getcountOrderByDistributerLoginIdForOwn = $Retailer->getcountOrderByDistributerLoginIdForOwnInCurrentDate($this->WebLoginID, $curr_date);
      if($getcountOrderByDistributerLoginIdForOwn['num'] !='0'){
        $this->view->WebLoginID =$this->WebLoginID;
        $this->view->result = $result = $Retailer->getOrderByDistributerLoginIdForOwnInCurrentDate($this->WebLoginID, $curr_date);
        $page=$this->_getParam('page',1);
        $paginator = Zend_Paginator::factory($result);      
            $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
            $paginator->setItemCountPerPage(15); // number of items to show per page
            $this->view->paginator = $paginator;
            $this->view->totalrec = $paginator->getTotalItemCount();
          }
          $this->view->getcountOrderBYDistributerLoginId = $getcountOrderBYDistributerLoginId = $Retailer->getcountOrderBYDistributerLoginId($this->WebLoginID, $curr_date);
          if($getcountOrderBYDistributerLoginId['num'] !='0'){
           $this->view->getOrderBYDistributerLoginId = $getOrderBYDistributerLoginId = $Retailer->getOrderBYDistributerLoginId($this->WebLoginID, $curr_date);    
         }    

       }

       public function distributerAllOrderSummaryAction(){
         $this->checklogin();
         $this->db = Zend_Db_Table::getDefaultAdapter();
         $db = $this->db;
         $auth = Zend_Auth::getInstance();
         $authStorage = $auth->getStorage();
         $this->WebLoginID = $authStorage->read()->LoginID;
         $params = $this->view->params = $this->getRequest()->getParams(); 
         $Retailer = new Application_Model_Retailer();
         if($params['date'] !=''){

          $curr_date = @date('Y-m-d',strtotime($params['date']));
        }
        else{
          $curr_date = date("Y-m-d");
        }
        $getcountOrderByDistributerLoginIdForOwn = $Retailer->getcountOrderByDistributerLoginIdForOwn($this->WebLoginID, $curr_date);
        if($getcountOrderByDistributerLoginIdForOwn['num'] !='0'){
          $this->view->WebLoginID =$this->WebLoginID;
          $this->view->result = $result = $Retailer->getOrderByDistributerLoginIdForOwn($this->WebLoginID, $curr_date);
          $page=$this->_getParam('page',1);
          $paginator = Zend_Paginator::factory($result);      
                $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
                $paginator->setItemCountPerPage(15); // number of items to show per page
                $this->view->paginator = $paginator;
                $this->view->totalrec = $paginator->getTotalItemCount();
              }

              $this->view->getcountOrderBYDistributerLoginId = $getcountOrderBYDistributerLoginId = $Retailer->getcountOrderBYDistributerLoginId($this->WebLoginID, $curr_date);
              if($getcountOrderBYDistributerLoginId['num'] !='0'){
               $this->view->getOrderBYDistributerLoginId = $getOrderBYDistributerLoginId = $Retailer->getOrderBYDistributerLoginId($this->WebLoginID, $curr_date);                
             }    

           }

           public function attendanceAction(){
             $this->checklogin();
             $params = $this->view->params = $this->getRequest()->getParams(); 
             $Retailer = new Application_Model_Retailer(); 
             $gmap = new Application_Model_Gmap();
             $this->view->getUserList = $gmap->getUserList();
             $currdatetime = date("Y-m-d H:i:s",strtotime('+330 minutes'));
             if($params['date_from']){
              $date_from = $params['date_from'];
            }
            else{
              $date_from = Date('Y-m-d');
            }

            $this->view->date_from = $date_from;
            $this->view->getAttendanceData = $result = $Retailer->getAttendanceData($params['sale_person'],$date_from);

            if($params['report'] == 'Generate'){

              $data = array(
               array(
                '#'=> "",
                'Sale Person Name'=> "" , 
                'Day Start Time'=> "",
                'Day End Time'=> "",
                'Total Working Hour'=>""
              ));
              $i = 2; 
              foreach ($result as $rs) {

               $getDayStart = $Retailer->getDayStart($rs['sale_login'], $date_from);
               $getDayEnd   = $Retailer->getDayEnd($rs['sale_login'],   $date_from);

               if($getDayEnd){
                $end           = $getDayEnd['noti_date'];
                $End_date_time = $getDayEnd['noti_date'];
              }
              else{
                if(date("Y-m-d") > $date_from){
                 $End_date_time = date("$date_from 23:59:59");
                 $end           = date("$date_from 23:59:59");;
               }
               else if(date("Y-m-d") == $date_from){
                 $End_date_time = $currdatetime;
                 $end           = 'N/A';
               }
               else{

               }
             }
             $dateDiff = intval((strtotime($End_date_time)-strtotime($getDayStart['noti_date']))/60);
             $hours = intval($dateDiff/60);
             $minutes = $dateDiff%60;

             $row = array();
             $row[] = stripslashes($i-1);
             $row[] = stripslashes($rs['Sale_person_name'].' ('.$rs['sale_login'].')');
             $row[] = stripslashes($getDayStart['noti_date']);
             $row[] = stripslashes($end);
             $row[] = stripslashes($hours.". ".$minutes." hour");

             $data[] = $row;
             $i++;
           }
           function filterData(&$str){
             $str = preg_replace("/\t/", "\\t", $str);
             $str = preg_replace("/\r?\n/", "\\n", $str);
             if(strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
           }
            // file name for download
           $fileName = "Attendance report.xls"; 
            // headers for download
           header("Content-Disposition: attachment; filename=\"$fileName\"");
           header("Content-Type: application/vnd.ms-excel");

           $flag = false;
           foreach($data as $row) {
             if(!$flag) {
                    // display column names as first row
              echo implode("\t", array_keys($row)) . "\n";
              $flag = true;
            }
                // filter data
            array_walk($row, 'filterData');
            echo implode("\t", array_values($row)) . "\n";
          }
          exit;
        }
      }


      public function userAttendanceAction(){
       $this->checklogin();
       $this->db = Zend_Db_Table::getDefaultAdapter();
       $db = $this->db;
       $id =  $this->id;
       $role = $this->role;
       $params = $this->view->params = $this->getRequest()->getParams(); 
       $Retailer = new Application_Model_Retailer(); 
       $gmap = new Application_Model_Gmap();
       $this->view->getUserList = $gmap->getUserList($this->role, $this->id);
       $currdatetime = date("Y-m-d H:i:s",strtotime('+330 minutes'));



       if ($role == 'super_admin') {
        $user_cond .= "";
      }

      if ($role == 'RM') {
        $user_cond .= "and a.parent_regional_manager = '" . $id . "' or a.LoginID = '".$this->LoginID."'";
      }

      if ($role == 'ZM') {
        $user_cond .= "and a.parent_zonal_manager = '" . $id . "' or a.LoginID = '".$this->LoginID."'";
      }

      if ($role == 'ASM') {
        $user_cond .= "and a.parent_area_manager = '" . $id . "' or a.LoginID = '".$this->LoginID."'";
      }

      if ($role == 'Sales') {
        $user_cond .= "and a.parent_sale_person = '" . $id . "' or a.LoginID = '".$this->LoginID."'";
      }

      if($params['user']){
        $cond .=" and a.LoginID = '".$params['user']."'";
      }
      if($params['date_from'] && $params['date_to']){
        $cond .=" and date(a.noti_date) between '".$params['date_from']."'  and '".$params['date_to']."' ";
      }
      else{
        $this->view->curr_date = $cur_date = Date('Y-m-d');
        $cond .=" and date(a.noti_date) = '".$cur_date."'";
      }

      $query = "SELECT  lu.StaffName as Sale_person_name, lu.LoginID as sale_login, lu.MobileNo as sale_person_mob, a.noti_date, date(a.noti_date) as attendance_date from Attendance as a left join logi_user as lu on (lu.LoginID = a.LoginID)  where 1 $cond $user_cond  group by date(a.noti_date), a.LoginID  order by date(a.noti_date) desc";  
      $result = $db->fetchAll($query);
        // $this->view->getAttendanceData = $result; 
      $page=$this->_getParam('page',1);
      $paginator = Zend_Paginator::factory($result);      
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(15); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec = $paginator->getTotalItemCount();

        if($params['report'] == 'Generate'){
        	$data = array(
        		array(
        			'#'=> "",
        			'Sale Person Name'=> "" , 
        			'Day Start Time'=> "",
        			'Day End Time'=> "",
        			'Total Working Hour'=>""
        		));
        	$i = 2; 
        	foreach ($result as $rs) {
        		if($params['date_from'] && $params['date_to']){
        			$curr_date = $rs['attendance_date'];
        		}
        		else{
        			$curr_date = Date('Y-m-d');
        		} 

        		$getDayStart = $Retailer->getDayStart($rs['sale_login'],$curr_date);
        		$getDayEnd   = $Retailer->getDayEnd($rs['sale_login'],  $curr_date);

        		if($getDayEnd){
        			$end           = $getDayEnd['noti_date'];
        			$End_date_time = $getDayEnd['noti_date'];
        		}
        		else{
        			if(date("Y-m-d") > $curr_date){
        				$End_date_time = date("$curr_date 23:59:59");
        				$end           = date("$curr_date 23:59:59");;
        			}
        			else if(date("Y-m-d") == $curr_date){
        				$End_date_time = $currdatetime;
        				$end           = 'N/A';
        			}
        			else{

        			}
        		}
        		$dateDiff = intval((strtotime($End_date_time)-strtotime($getDayStart['noti_date']))/60);
        		$hours    = intval($dateDiff/60);
        		$minutes  = $dateDiff%60;

        		$start_date = date("d/m/Y h:i:s", strtotime($getDayStart['noti_date']));
        		if($end !='N/A'){ $end_date =  date("d/m/Y h:i:s", strtotime($end)); } else{ $end_date =  $end;}

        		$row      = array();
        		$row[]    = stripslashes($i-1);
        		$row[]    = stripslashes($rs['Sale_person_name'].' ('.$rs['sale_login'].')');
        		$row[]    = stripslashes($start_date);
        		$row[]    = stripslashes($end_date);
        		$row[]    = stripslashes($hours.". ".$minutes." hour");   
        		$data[]   = $row;
        		$i++;
        	}
        	function filterData(&$str){
        		$str = preg_replace("/\t/", "\\t", $str);
        		$str = preg_replace("/\r?\n/", "\\n", $str);
        		if(strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
        	}
            // file name for download
        	$fileName = "Attendance report.xls"; 
            // headers for download
        	header("Content-Disposition: attachment; filename=\"$fileName\"");
        	header("Content-Type: application/vnd.ms-excel");

        	$flag = false;
        	foreach($data as $row) {
        		if(!$flag) {
                    // display column names as first row
        			echo implode("\t", array_keys($row)) . "\n";
        			$flag = true;
        		}
                // filter data
        		array_walk($row, 'filterData');
        		echo implode("\t", array_values($row)) . "\n";
        	}
        	exit;
        }
      }

      public function tabletDescriptionAction(){

       $this->checklogin();
       $params = $this->view->params = $this->getRequest()->getParams(); 
       $Retailer = new Application_Model_Retailer(); 
       $gmap = new Application_Model_Gmap();
       $this->view->getUserList = $gmap->getUserList();

       if($params['date_from']){
        $date_from = $params['date_from'];
      }
      else{
        $date_from = Date('Y-m-d');
      }

      $this->view->date_from = $date_from;
      $result = $Retailer->getTabeltReportZoneWise($params['sale_person'],$date_from);

      $page=$this->_getParam('page',1);
      $paginator = Zend_Paginator::factory($result);      
          $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
          $paginator->setItemCountPerPage(15); // number of items to show per page
          $this->view->paginator = $paginator;
          $this->view->totalrec = $paginator->getTotalItemCount();
        }



        public function userTabletDescriptionAction(){
         $this->checklogin();

         $params = $this->view->params = $this->getRequest()->getParams(); 
         $Retailer = new Application_Model_Retailer(); 
         $gmap = new Application_Model_Gmap();
         $this->view->getUserList = $gmap->getUserList();
         if($params['date_from']){
          $date_from = $params['date_from'];
        }
        else{
          $date_from = Date('Y-m-d');
        }

        $this->view->date_from = $date_from;
        $result = $Retailer->getTabeltReportUserAndZoneWise($params['sale_person'],$date_from);

        $page=$this->_getParam('page',1);
        $paginator = Zend_Paginator::factory($result);      
          $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
          $paginator->setItemCountPerPage(15); // number of items to show per page
          $this->view->paginator = $paginator;
          $this->view->totalrec = $paginator->getTotalItemCount();
        }


        public function monthlyReportAction(){
         $this->checklogin();
         $auth = Zend_Auth::getInstance();
         $authStorage = $auth->getStorage();
         $params = $this->view->params = $this->getRequest()->getParams();
         $gmap = new Application_Model_Gmap();
         $this->view->getUserList =$getUserList =  $gmap->getUserList();

         $this->view->totalnum = $params['page']; 
         $Retailer = new Application_Model_Retailer(); 
         $this->view->result = $result =  $Retailer->getMonthlyPsmReport($params['sale_person'], $params['date_from'], $params['date_to']);
         if($params['report'] == 'Generate'){

          $data = array(
           array(
            '#'=> "",
            'Date'=> "" , 
            'Sale Person'=> "",
            'Sale Person Code'=> "",
            'Total Distance Travelled'=>"",
            'New Retailers'=>"",
            'Existing Retailers'=>"",
            'Total PPM Cartes'=>"",
            'Total Dahi Cartes'=>"",
            'Total BM Cartes'=>"",
            'Total GHEE Cartes'=>"",
            'Login Time'=>"",
            'Log Off Time'=>"",
            'Difference in Logoff & Login Time'=>"",
            'No of HRs Tablet On'=>""
          ));
          $i = 2; 
          foreach ($result as $rs) {

           $row = array();
           $row[] = stripslashes($i-1);
           $row[] = stripslashes($rs['date']);
           $row[] = stripslashes($rs['sale_person']);
           $row[] = stripslashes($rs['LoginID']);

           $row[] = stripslashes($rs['travelled_distance']);
           $row[] = stripslashes($rs['new_retailer_tagged']);
           $row[] = stripslashes($rs['existing_retailer']);
           $row[] = stripslashes('0');
           $row[] = stripslashes('0');
           $row[] = stripslashes('0');
           $row[] = stripslashes('0');
           $row[] = stripslashes($rs['login_time']);
           $row[] = stripslashes($rs['logout_time']);
           $row[] = stripslashes($rs['hour_diff']);
           $row[] = stripslashes($rs['tablet_hr_on']);

           $data[] = $row;
           $i++;
         }
         function filterData(&$str){
           $str = preg_replace("/\t/", "\\t", $str);
           $str = preg_replace("/\r?\n/", "\\n", $str);
           if(strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
         }

            // file name for download
         $fileName = "Monthly Report.xls"; 

            // headers for download
         header("Content-Disposition: attachment; filename=\"$fileName\"");
         header("Content-Type: application/vnd.ms-excel");

         $flag = false;
         foreach($data as $row) {
           if(!$flag) {
                    // display column names as first row
            echo implode("\t", array_keys($row)) . "\n";
            $flag = true;
          }
                // filter data
          array_walk($row, 'filterData');
          echo implode("\t", array_values($row)) . "\n";
        }
        exit;
      }  
    }

    public function salePersonMonthlyReportAction(){
     $this->checklogin();
     $auth = Zend_Auth::getInstance();
     $authStorage = $auth->getStorage();
     $params = $this->view->params = $this->getRequest()->getParams();
     $gmap = new Application_Model_Gmap();
     $this->view->getUserList =$getUserList =  $gmap->getUserList();

     $this->view->totalnum = $params['page']; 
     $Retailer = new Application_Model_Retailer(); 
     $this->view->result = $result = $Retailer->getSalePersonMonthlyPsmReport($params['sale_person'], $params['date_from'], $params['date_to']);

     if($params['report'] == 'Generate'){

      $data = array(
       array(
        '#'=> "",
        'Date'=> "" , 
        'Sale Person'=> "",
        'Sale Person Code'=> "",
        'Total Distance Travelled'=>"",
        'New Retailers'=>"",
        'Existing Retailers'=>"",
        'No of HRs Tablet On'=>""
      ));
      $i = 2; 
      foreach ($result as $rs) {
       $row    = array();
       $row[]  = stripslashes($i-1);
       $row[]  = stripslashes($rs['date']);
       $row[]  = stripslashes($rs['sale_person']);
       $row[]  = stripslashes($rs['LoginID']);
       $row[]  = stripslashes($rs['travelled_distance']);
       $row[]  = stripslashes($rs['new_retailer_tagged']);
       $row[]  = stripslashes($rs['existing_retailer']);
       $row[]  = stripslashes($rs['tablet_hr_on']);
       $data[] = $row;
       $i++;
     }
     function filterData(&$str){
       $str = preg_replace("/\t/", "\\t", $str);
       $str = preg_replace("/\r?\n/", "\\n", $str);
       if(strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
     }

            // file name for download
     $fileName = "Monthly Day Wise Report.xls"; 

            // headers for download
     header("Content-Disposition: attachment; filename=\"$fileName\"");
     header("Content-Type: application/vnd.ms-excel");

     $flag = false;
     foreach($data as $row) {
       if(!$flag) {
                    // display column names as first row
        echo implode("\t", array_keys($row)) . "\n";
        $flag = true;
      }
                // filter data
      array_walk($row, 'filterData');
      echo implode("\t", array_values($row)) . "\n";
    }
    exit;
  }
}


public function orderReportAction(){
 $this->checklogin();
 $auth = Zend_Auth::getInstance();
 $authStorage = $auth->getStorage();
 $params = $this->view->params = $this->getRequest()->getParams();
 $this->view->totalnum = $params['page'];

 $id   = $this->id;
 $role = $this->role;

 if ($role == 'super_admin') {
  $user_cond .= "";
}

if ($role == 'RM') {
  $user_cond .= "and o.parent_regional_manager = '" . $id . "' ";
}

if ($role == 'ZM') {
  $user_cond .= "and o.parent_zonal_manager = '" . $id . "' ";
}

if ($role == 'ASM') {
  $user_cond .= "and o.parent_area_manager = '" . $id . "' ";
}

if ($role == 'Sales') {
  $user_cond .= "and o.sale_person_id = '" . $id . "' ";
}

$sql_order = "select o.*, created_person_by.StaffName as created_by_person, s.StaffName as sale_person_name, r.StaffName as retailer_name, u.StaffName, u.sap_code, date(o.order_date) as ordered_date, u.id as dis_id from logi_order as o left join  logi_user as u on (o.distributor_id = u.id) left join  logi_user as r on (o.retailer_id = r.id) left join  logi_user as s on (o.sale_person_id = s.id) left join logi_user as created_person_by on (created_person_by.id = o.created_by) where 1 $user_cond  order by o.id desc";
$res_order= $this->db->fetchAll($sql_order);

$page=$this->_getParam('page',1);
$paginator = Zend_Paginator::factory($res_order);      
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(15); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec = $paginator->getTotalItemCount();
      }


      public function venSaleDescriptionAction(){
       $this->checklogin();
       $auth = Zend_Auth::getInstance();
       $authStorage = $auth->getStorage();
       $params = $this->view->params = $this->getRequest()->getParams();
       $this->view->totalnum = $params['page'];

       $id   = $this->id;
       $role = $this->role;

       if ($role == 'super_admin') {
        $user_cond .= "";
      }

      if ($role == 'RM') {
        $user_cond .= "and o.parent_regional_manager = '" . $id . "' ";
      }

      if ($role == 'ZM') {
        $user_cond .= "and o.parent_zonal_manager = '" . $id . "' ";
      }

      if ($role == 'ASM') {
        $user_cond .= "and o.parent_area_manager = '" . $id . "' ";
      }

      if ($role == 'Sales') {
        $user_cond .= "and o.parent_sale_person = '" . $id . "' ";
      }

      $sql_order = "select o.*, s.StaffName as sale_person_name, r.StaffName as retailer_name, u.StaffName, u.sap_code from tbl_ven_sale_description as o left join  logi_user as u on (o.distributor_id = u.id) left join  logi_user as r on (o.retailer_id = r.id) left join  logi_user as s on (o.parent_sale_person = s.id) where 1 $user_cond  order by o.id desc";
      $res_order= $this->db->fetchAll($sql_order);

      $page=$this->_getParam('page',1);
      $paginator = Zend_Paginator::factory($res_order);      
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(15); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec = $paginator->getTotalItemCount();
      }

      public function viewVenSaleDescriptionAction(){
       $this->checklogin();
       $layout = $this->_helper->layout();
       $layout->disableLayout('');
       $params = $this->view->params = $this->getRequest()->getParams();

       $query_product_list = "select order_items.*,  product.product_name, subproduct.sub_product_name from tbl_ven_sale_item_detail as order_items left join logi_product as product on(order_items.product_id = product.id) LEFT JOIN  sub_product as subproduct ON (subproduct.id = order_items.sub_product_id) where order_items.description_id = '".$params['id']."'";
       $query_details = "select o.*, s.StaffName as sale_person_name, r.StaffName as retailer_name, u.StaffName, u.sap_code from tbl_ven_sale_description as o left join  logi_user as u on (o.distributor_id = u.id) left join  logi_user as r on (o.retailer_id = r.id) left join  logi_user as s on (o.parent_sale_person = s.id) where o.id = '".$params['id']."'";
       $this->view->result = $result = $this->db->fetchAll($query_product_list);
       $this->view->details_result = $details_result = $this->db->fetchRow($query_details);
     }


     public function surveyAction(){
       $this->checklogin();
       $params = $this->view->params = $this->getRequest()->getParams();

       $sql_user = "select * from logi_user where Role = 'Survey'";
       $result_user = $this->db->fetchAll($sql_user); 
       $this->view->getUserList = $result_user;

       $sql_survey_type = "select * from tbl_survey_type where status = '0'";
       $result_survey_type = $this->db->fetchAll($sql_survey_type); 
       $this->view->survey_type_list = $result_survey_type;

       if($params['survey_type']==''){
        $cond .=" and survey.survey_type = '1'";
      }

      if($params['survey_type']){
        $cond .=" and survey.survey_type = '".$params['survey_type']."'";
      }

      if($params['user']){
        $cond .=" and survey.user_id = '".$params['user']."'";
      }

      if($params['date_from'] && !$params['date_from']){
        $cond .=" and survey.survey_date = '".$params['date_from']."'";
      }

      if(!$params['date_from'] && $params['date_to']){
        $cond .=" and survey.survey_date = '".$params['date_to']."'";
      }

      if($params['date_from'] && $params['date_to']){
        $cond .=" and survey.survey_date between  '".$params['date_from']."' and '".$params['date_to']."'";
      }

      $sql = "select survey.*, u.StaffName, u.LoginID, st.survey_name as survey_type_name from tbl_survey as survey left join logi_user as u on (u.id = survey.user_id) left join tbl_survey_type as st on (st.id = survey.survey_type) where 1 $cond order by survey.id desc";
      $result = $this->db->fetchAll($sql);
        // echo '<pre>';
        // print_r($result);
        // exit();
      $page=$this->_getParam('page',1);
      $paginator = Zend_Paginator::factory($result);      
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(15); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec = $paginator->getTotalItemCount();

        if($params['report'] == 'Generate'){
            // require_once 'PHPExcel/Classes/PHPExcel.php';
            // $objPHPExcel = new PHPExcel();

        	if($params['survey_type'] == '1'){
        		$data = array(
        			array(
        				'#'=> "",
        				'Survey Type'=> "" , 
        				'Survey Date'=> "",
        				'Surveyor Name'=> "",
        				'Party Name'=> "",
        				'Address'=>"",
        				'Contact Name'=>"",
        				'Contact No'=>"",
        				'Name of Dairy'=>"",
        				'Avg. Qty(Lit/Day'=> "" , 
        				'Tentative Reqiremen'=> "",
        				'Agree with saahaj'=> "",
        				'Sku Wise Qty'=>"",
        				'Existing Distributor'=>"",
        				'Remark'=>"",
        				'Retailer Signature'=>"",
        			)
        		);
        	}

        	else if($params['survey_type'] == '2'){
        		$data = array(
        			array(
        				'#'=> "",
        				'Survey Type'=> "" , 
        				'Survey Date'=> "",
        				'Surveyor Name'=> "",
        				'Name Of Colony'=> "",
        				'House No.'=>"",
        				'Contact Name'=>"",
        				'Contact No'=>"",
        				'Milk Type Consumtion'=>"",
        				'Sku Type'=> "" , 
        				'Daily Consumption Qty (in Lit)'=> "",
        				'Brand Name'=> "",
        				'Remark'=>"",
        				'Customer Signatur'=>""
        			)
        		);
        	}

        	else if($params['survey_type'] == '3'){
        		$data = array(
        			array(
        				'#'=> "",
        				'Survey Type'=> "" , 
        				'Survey Date'=> "",
        				'Surveyor Name'=> "",
        				'Name Of Institution'=> "",
        				'Address'=>"",
        				'Contact Name'=>"",
        				'Contact No'=>"",
        				'Designation'=>"",
        				'Milk Type Consumtion'=> "" , 
        				'Sku Type'=> "",
        				'Daily Consumption Qty (in Lit)'=> "",
        				'Brand Name'=>"",
        				'Competitor Price & Payment Term'=>"",
        				'Remark'=>"",
        				'Instutution Signature'=>""
        			)
        		);
        	}

        	else if($params['survey_type'] == '4'){
        		$data = array(
        			array(
        				'#'=> "",
        				'Survey Type'=> "" , 
        				'Survey Date'=> "",
        				'Surveyor Name'=> "",
        				'Party Name'=> "",
        				'Address'=>"",
        				'Contact Name'=>"",
        				'Contact No'=>"",
        				'Nature Of Bussiness'=>"",
        				'Other Nature Of Bussiness'=> "" , 
        				'Existing Distributor'=> "",
        				'Term & Condition'=> "",
        				'Party Agreed'=>"",
        				'New Party Demond'=>"",
        				'New Party Retailer'=>"",
        				'Remark'=>"",
        				'Distributor Signature'=>""
        			)
        		);
        	}
        	$i = 2; 
        	foreach ($result as $rs) {
        		$row    = array();
        		$row[]  = stripslashes($i-1);
        		if($params['survey_type'] == '1'){    
        			$row[]  = stripslashes($rs['survey_type_name']);
        			$row[]  = stripslashes($rs['survey_date']);
        			$row[]  = stripslashes($rs['StaffName']);
        			$row[]  = stripslashes($rs['party_name']);
        			$row[]  = stripslashes($rs['address']);
        			$row[]  = stripslashes($rs['contact_person']);
        			$row[]  = stripslashes($rs['contact_number']);
        			$row[]  = stripslashes($rs['name_of_dairy']);
        			$row[]  = stripslashes($rs['avg_qty']);
        			$row[]  = stripslashes($rs['tentative_reqirement']);
        			$row[]  = stripslashes($rs['party_agreed']);
        			$row[]  = stripslashes($rs['sku_wise_qty']);
        			$row[]  = stripslashes($rs['existing_distributor']);
        			$row[]  = stripslashes($rs['remark']);
        		}
        		else if($params['survey_type'] == '2'){    
        			$row[]  = stripslashes($rs['survey_type_name']);
        			$row[]  = stripslashes($rs['survey_date']);
        			$row[]  = stripslashes($rs['StaffName']);
        			$row[]  = stripslashes($rs['name_of_colony']);
        			$row[]  = stripslashes($rs['house_num']);
        			$row[]  = stripslashes($rs['contact_person']);
        			$row[]  = stripslashes($rs['contact_number']);
        			$row[]  = stripslashes($rs['type_milk_consumtion']);
        			$row[]  = stripslashes($rs['sku_type']);
        			$row[]  = stripslashes($rs['consumption_qty']);
        			$row[]  = stripslashes($rs['ppm_sale']);
        			$row[]  = stripslashes($rs['remark']);
        		}
        		else if($params['survey_type'] == '3'){    
        			$row[]  = stripslashes($rs['survey_type_name']);
        			$row[]  = stripslashes($rs['survey_date']);
        			$row[]  = stripslashes($rs['StaffName']);
        			$row[]  = stripslashes($rs['name_of_institution']);
        			$row[]  = stripslashes($rs['address']);
        			$row[]  = stripslashes($rs['contact_person']);
        			$row[]  = stripslashes($rs['contact_number']);
        			$row[]  = stripslashes($rs['designation']);
        			$row[]  = stripslashes($rs['type_milk_consumtion']);
        			$row[]  = stripslashes($rs['sku_type']);
        			$row[]  = stripslashes($rs['consumption_qty']);
        			$row[]  = stripslashes($rs['ppm_sale']);
        			$row[]  = stripslashes($rs['competitor_price']);
        			$row[]  = stripslashes($rs['remark']);
        		}
        		else if($params['survey_type'] == '4'){    
        			$row[]  = stripslashes($rs['survey_type_name']);
        			$row[]  = stripslashes($rs['survey_date']);
        			$row[]  = stripslashes($rs['StaffName']);
        			$row[]  = stripslashes($rs['party_name']);
        			$row[]  = stripslashes($rs['address']);
        			$row[]  = stripslashes($rs['contact_person']);
        			$row[]  = stripslashes($rs['contact_number']);
        			$row[]  = stripslashes($rs['nature_of_bussiness']);
        			$row[]  = stripslashes($rs['nature_of_bussiness_other']);
        			$row[]  = stripslashes($rs['existing_distributor']);
        			$row[]  = stripslashes($rs['terms_condition']);
        			$row[]  = stripslashes($rs['party_agreed']);
        			$row[]  = stripslashes($rs['demand_of_new_party']);
        			$row[]  = stripslashes($rs['new_party_retailer']);
        			$row[]  = stripslashes($rs['remark']);
        		}
        		$data[] = $row;
        		$i++;
        	}
        	function filterData(&$str){
        		$str = preg_replace("/\t/", "\\t", $str);
        		$str = preg_replace("/\r?\n/", "\\n", $str);
        		if(strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
        	}

            // file name for download
        	$fileName = "Survey Report.xls"; 
            // headers for download
        	header("Content-Disposition: attachment; filename=\"$fileName\"");
        	header("Content-Type: application/vnd.ms-excel");

        	$flag = false;
        	foreach($data as $row) {
        		if(!$flag) {
                    // display column names as first row
        			echo implode("\t", array_keys($row)) . "\n";
        			$flag = true;
        		}
                // filter data
        		array_walk($row, 'filterData');
        		echo implode("\t", array_values($row)) . "\n";
        	}
        	exit;
        }
      }


      public function surveyReportAction(){
       $this->checklogin();
       $params = $this->view->params = $this->getRequest()->getParams();
        // echo 'hi';
        // exit();
       $sql_user = "select * from logi_user where Role = 'Survey'";
       $result_user = $this->db->fetchAll($sql_user); 
       $this->view->getUserList = $result_user;

       $sql_survey_type = "select * from tbl_survey_type where status = '0'";
       $result_survey_type = $this->db->fetchAll($sql_survey_type); 
       $this->view->survey_type_list = $result_survey_type;

       if($params['survey_type']==''){
        $cond .=" and survey.survey_type = '1'";
      }

      if($params['survey_type']){
        $cond .=" and survey.survey_type = '".$params['survey_type']."'";
      }

      if($params['user']){
        $cond .=" and survey.user_id = '".$params['user']."'";
      }

      if($params['date_from'] && !$params['date_from']){
        $cond .=" and survey.survey_date = '".$params['date_from']."'";
      }

      if(!$params['date_from'] && $params['date_to']){
        $cond .=" and survey.survey_date = '".$params['date_to']."'";
      }

      if($params['date_from'] && $params['date_to']){
        $cond .=" and survey.survey_date between  '".$params['date_from']."' and '".$params['date_to']."'";
      }

      $sql = "select survey.*, u.StaffName, u.LoginID, st.survey_name as survey_type_name from tbl_survey as survey left join logi_user as u on (u.id = survey.user_id) left join tbl_survey_type as st on (st.id = survey.survey_type) where 1 $cond order by survey.id desc";
      $result = $this->db->fetchAll($sql);
        // echo '<pre>';
        // print_r($result);
        // exit();
      $page=$this->_getParam('page',1);
      $paginator = Zend_Paginator::factory($result);      
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(15); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec = $paginator->getTotalItemCount();

        if($params['report'] == 'Generate'){
        	require_once 'PHPExcel/Classes/PHPExcel.php';
        	$objPHPExcel = new PHPExcel();
        	$objDrawing  = new PHPExcel_Worksheet_Drawing();
        	$objPHPExcel->getProperties()->setCreator("Puneet Mishra")
        	->setLastModifiedBy("Puneet Mishra")
        	->setTitle("Office 2007 XLSX  Document")
        	->setSubject("Office 2007 XLSX  Document")
        	->setDescription("Document for Office 2007 XLSX, generated using PHP classes.")
        	->setKeywords("office 2007 openxml php")
        	->setCategory("Survey Report");
        	if($params['survey_type'] == '1'){
        		$objPHPExcel->getActiveSheet()
        		->setCellValue('A1', '#')
        		->setCellValue('B1', 'Survey Type')
        		->setCellValue('C1', 'Survey Date')
        		->setCellValue('D1', 'Surveyor Name')
        		->setCellValue('E1', 'Party Name')
        		->setCellValue('F1', 'Address')
        		->setCellValue('G1', 'Contact Name')
        		->setCellValue('H1', 'Contact No')
        		->setCellValue('I1', 'Name of Dairy')
        		->setCellValue('J1', 'Avg. Qty(Lit/Day)')
        		->setCellValue('K1', 'Tentative Reqiremen')
        		->setCellValue('L1', 'Agree with saahaj')
        		->setCellValue('M1', 'Sku Wise Qty')
        		->setCellValue('N1', 'Existing Distributor')
        		->setCellValue('O1', 'Remark')
        		->setCellValue('P1', 'Retailer Signature');
        	}
        	else if($params['survey_type'] == '2'){
        		$objPHPExcel->getActiveSheet()
        		->setCellValue('A1', '#')
        		->setCellValue('B1', 'Survey Type')
        		->setCellValue('C1', 'Survey Date')
        		->setCellValue('D1', 'Surveyor Name')
        		->setCellValue('E1', 'Name Of Colony')
        		->setCellValue('F1', 'House No.')
        		->setCellValue('G1', 'Contact Name')
        		->setCellValue('H1', 'Contact No')
        		->setCellValue('I1', 'Milk Type Consumtion')
        		->setCellValue('J1', 'Sku Type')
        		->setCellValue('K1', 'Daily Consumption Qty (in Lit)')
        		->setCellValue('L1', 'Brand Name')
        		->setCellValue('M1', 'Remark')
        		->setCellValue('N1', 'Customer Signatur');
        	}
        	else if($params['survey_type'] == '3'){
        		$objPHPExcel->getActiveSheet()
        		->setCellValue('A1', '#')
        		->setCellValue('B1', 'Survey Type')
        		->setCellValue('C1', 'Survey Date')
        		->setCellValue('D1', 'Surveyor Name')
        		->setCellValue('E1', 'Name Of Institution')
        		->setCellValue('F1', 'Address')
        		->setCellValue('G1', 'Contact Name')
        		->setCellValue('H1', 'Contact No')
        		->setCellValue('I1', 'Designation')
        		->setCellValue('J1', 'Milk Type Consumtion')
        		->setCellValue('K1', 'Sku Type')
        		->setCellValue('L1', 'Daily Consumption Qty (in Lit)')
        		->setCellValue('M1', 'Brand Name')
        		->setCellValue('N1', 'Competitor Price & Payment Term')
        		->setCellValue('O1', 'Remark')
        		->setCellValue('P1', 'Instutution Signature');
        	}
        	else if($params['survey_type'] == '4'){
        		$objPHPExcel->getActiveSheet()
        		->setCellValue('A1', '#')
        		->setCellValue('B1', 'Survey Type')
        		->setCellValue('C1', 'Survey Date')
        		->setCellValue('D1', 'Surveyor Name')
        		->setCellValue('E1', 'Party Name')
        		->setCellValue('F1', 'Address')
        		->setCellValue('G1', 'Contact Name')
        		->setCellValue('H1', 'Contact No')
        		->setCellValue('I1', 'Nature Of Bussiness')
        		->setCellValue('J1', 'Other Nature Of Bussiness')
        		->setCellValue('K1', 'Existing Distributor')
        		->setCellValue('L1', 'Term & Condition')
        		->setCellValue('M1', 'Party Agreed')
        		->setCellValue('N1', 'New Party Demond')
        		->setCellValue('O1', 'New Party Retailer')
        		->setCellValue('P1', 'Remark')
        		->setCellValue('Q1', 'Distributor Signature');
        	}
        	$default_border = array(
        		'style' => PHPExcel_Style_Border::BORDER_THIN,
        		'color' => array('rgb'=>'000000')
        	);
        	$style_header = array(
        		'fill' => array(
        			'type' => PHPExcel_Style_Fill::FILL_SOLID,
        			'color' => array('rgb'=>'999999')
        		)
        	);
        	$objPHPExcel->getActiveSheet()->getStyle('A1:U1')->applyFromArray( $style_header ); 
        	$i = 2;   
        	foreach($result as $data){
        		if($params['survey_type'] == '1'){
        			$objPHPExcel->setActiveSheetIndex(0)
        			->setCellValue('A'.$i, $i - 1)
        			->setCellValue('B'.$i, $data['survey_type_name'])
        			->setCellValue('C'.$i, $data['survey_date'])
        			->setCellValue('D'.$i, $data['StaffName'])
        			->setCellValue('E'.$i, $data['party_name'])
        			->setCellValue('F'.$i, $data['address'])
        			->setCellValue('G'.$i, $data['contact_person'])
        			->setCellValue('H'.$i, $data['contact_number'])
        			->setCellValue('I'.$i, $data['name_of_dairy'])
        			->setCellValue('J'.$i, $data['avg_qty'])
        			->setCellValue('K'.$i, $data['tentative_reqirement'])
        			->setCellValue('L'.$i, $data['party_agreed'])
        			->setCellValue('M'.$i, $data['sku_wise_qty'])
        			->setCellValue('N'.$i, $data['existing_distributor'])
        			->setCellValue('O'.$i, $data['remark']);
        		}
        		else if($params['survey_type'] == '2'){
        			$objPHPExcel->setActiveSheetIndex(0)
        			->setCellValue('A'.$i, $i - 1)
        			->setCellValue('B'.$i, $data['survey_type_name'])
        			->setCellValue('C'.$i, $data['survey_date'])
        			->setCellValue('D'.$i, $data['StaffName'])
        			->setCellValue('E'.$i, $data['name_of_colony'])
        			->setCellValue('F'.$i, $data['house_num'])
        			->setCellValue('G'.$i, $data['contact_person'])
        			->setCellValue('H'.$i, $data['contact_number'])
        			->setCellValue('I'.$i, $data['type_milk_consumtion'])
        			->setCellValue('J'.$i, $data['sku_type'])
        			->setCellValue('K'.$i, $data['consumption_qty'])
        			->setCellValue('L'.$i, $data['ppm_sale'])
        			->setCellValue('M'.$i, $data['remark']);
        		}
        		else if($params['survey_type'] == '3'){
        			$objPHPExcel->setActiveSheetIndex(0)
        			->setCellValue('A'.$i, $i - 1)
        			->setCellValue('B'.$i, $data['survey_type_name'])
        			->setCellValue('C'.$i, $data['survey_date'])
        			->setCellValue('D'.$i, $data['StaffName'])
        			->setCellValue('E'.$i, $data['name_of_institution'])
        			->setCellValue('F'.$i, $data['address'])
        			->setCellValue('G'.$i, $data['contact_person'])
        			->setCellValue('H'.$i, $data['contact_number'])
        			->setCellValue('I'.$i, $data['designation'])
        			->setCellValue('J'.$i, $data['type_milk_consumtion'])
        			->setCellValue('K'.$i, $data['sku_type'])
        			->setCellValue('L'.$i, $data['consumption_qty'])
        			->setCellValue('M'.$i, $data['ppm_sale'])
        			->setCellValue('N'.$i, $data['competitor_price'])
        			->setCellValue('O'.$i, $data['remark']);    
        		}
        		else if($params['survey_type'] == '4'){
        			$objPHPExcel->setActiveSheetIndex(0)
        			->setCellValue('A'.$i, $i - 1)
        			->setCellValue('B'.$i, $data['survey_type_name'])
        			->setCellValue('C'.$i, $data['survey_date'])
        			->setCellValue('D'.$i, $data['StaffName'])
        			->setCellValue('E'.$i, $data['party_name'])
        			->setCellValue('F'.$i, $data['address'])
        			->setCellValue('G'.$i, $data['contact_person'])
        			->setCellValue('H'.$i, $data['contact_number'])
        			->setCellValue('I'.$i, $data['nature_of_bussiness'])
        			->setCellValue('J'.$i, $data['nature_of_bussiness_other'])
        			->setCellValue('K'.$i, $data['existing_distributor'])
        			->setCellValue('L'.$i, $data['terms_condition'])
        			->setCellValue('M'.$i, $data['party_agreed'])
        			->setCellValue('N'.$i, $data['demand_of_new_party'])
        			->setCellValue('O'.$i, $data['new_party_retailer'])
        			->setCellValue('P'.$i, $data['remark']);            
        		}  
        		try{
        			$objDrawing->setName('Sample image');
        			$objDrawing->setDescription('Sample image');
        			$objDrawing->setImageResource('uploads/survey/1515394164sign.jpg');
        		}
        		catch (Zend_Exception $e){
        			echo  $e->getMessage();
        		}    
                // $objDrawing->setRenderingFunction(PHPExcel_Worksheet_MemoryDrawing::RENDERING_JPEG);
                // $objDrawing->setMimeType(PHPExcel_Worksheet_MemoryDrawing::MIMETYPE_DEFAULT);
                // $objDrawing->setHeight(150);
                // if($params['survey_type'] == '1'){
                //     $objDrawing->setCoordinates('P'.$i);
                // }   
                // $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());
        		$i++;             
        	}
          // Redirect output to a client’s web browser (Excel2007)
        	header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        	header('Content-Disposition: attachment;filename="SurveyReport.xlsx"');
        	header('Cache-Control: max-age=0'); 

        	$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        	$objWriter->save('php://output');

        	exit;                
        }
      }

      public function taskReportAction(){

       $this->checklogin();
       $params = $this->view->params = $this->getRequest()->getParams();
       $role = $this->Role;
       $id = $this->id;

       $gmap = new Application_Model_Gmap();
       $this->view->getUserList = $getUserList = $gmap->getUserList($this->role, $this->id); 

       if ($role == 'super_admin') {
        $user_cond .= "";
      }

      if ($role == 'RM') {
        $user_cond .= "and t.parent_regional_manager = '" . $id . "'";
      }

      if ($role == 'ZM') {
        $user_cond .= "and t.parent_zonal_manager = '" . $id . "' ";
      }

      if ($role == 'ASM') {
        $user_cond .= "and t.parent_area_manager = '" . $id . "' ";
      }

      if ($role == 'Sales') {
        $user_cond .= "and t.parent_sale_person = '" . $id . "' ";
      }

        // print_r($getUserList);exit;
      $sql_user = "select t.*, l.StaffName,l.id,l.LoginID,t32.id as created_id,t32.StaffName as created_staff from tbl_task as t left join logi_user as l on(l.id = t.assign_to) LEFT  JOIN logi_user as t32 ON (t32.id = t.created_by) where 1 $user_cond";
      $result_user = $this->db->fetchAll($sql_user); 
      $this->view->result_user = $result_user;
    	// echo '<pre>';
    	// print_r($params);exit;
      if($params['Assign_person']!=''){
        $cond .=" and t.assign_to LIKE  '%".$params['Assign_person']."%'";
      }

      if($params['date_from']  && $params['date_to']){
        $cond .=" and t.start_date between '".$params['date_from']."' and'". $params['date_to']."'";
      }

      $sql = "select t.*, l.StaffName,l.id,l.LoginID,t32.id as created_id,t32.StaffName as created_staff from tbl_task as t left join logi_user as l on(l.id = t.assign_to) LEFT  JOIN logi_user as t32 ON (t32.id = t.created_by)
      where 1 $cond $user_cond order by t.id desc";
      $result_user = $this->db->fetchAll($sql);

      $page=$this->_getParam('page',1);
      $paginator = Zend_Paginator::factory($result_user);      
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(15); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec = $paginator->getTotalItemCount();


        if($params['report'] == 'Generate'){

        	$data = array(
        		array(
        			'#'=> "",
        			'Assign To'=> "" , 
        			'Task Id'=> "",
        			'Description'=> "",
        			'Created By'=>"",
                    // 'Approved By'=>"",
        			'Start Date'=>"",
        			'Due Date'=>"",
        			'Reminder'=> "",
        			'Priority'=> "",
        			'Status'=>""

        		));
        	$i = 2; 
        	foreach ($result_user as $rs) {
        		if($rs['status'] == '0'){ 
        			$status = 'Pending'; }
        			else if($rs['status'] == '1'){ 
        				$status = 'Approved'; }
        				else if($rs['status'] == '2'){ 
        					$status = 'Decline'; }


        					if($rs['created_staff'] !=''){
        						$created_by = $rs['created_staff'];
        					}
        					else{
        						$created_by = 'Admin';
        					}
        					if($rs['start_date'] !='0000-00-00'){  $start_date =  date("d/m/Y", strtotime($rs['start_date'])); }else{ $start_date = ''; }
        					if($rs['due_date'] !='0000-00-00'){  $due_date   =  date("d/m/Y", strtotime($rs['due_date']));}else{ $due_date = ''; }

        					$row    = array();
        					$row[]  = stripslashes($i-1);
        					$row[]  = stripslashes($rs['StaffName']);
        					$row[]  = stripslashes($rs['task_id']);
        					$row[]  = stripslashes($rs['description']);
        					$row[]  = stripslashes($created_by);
                            // $row[]  = stripslashes($rs['approved_by']);
        					$row[]  = stripslashes($start_date);
        					$row[]  = stripslashes($due_date);
        					$row[]  = stripslashes($rs['reminder']);
        					$row[]  = stripslashes($rs['priority']);
        					$row[]  = stripslashes($status);

        					$data[] = $row;
        					$i++;
        				}
        				function filterData(&$str){
        					$str = preg_replace("/\t/", "\\t", $str);
        					$str = preg_replace("/\r?\n/", "\\n", $str);
        					if(strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
        				}

        // file name for download
        				$fileName = "Task Report.xls"; 

        // headers for download
        				header("Content-Disposition: attachment; filename=\"$fileName\"");
        				header("Content-Type: application/vnd.ms-excel");

        				$flag = false;
        				foreach($data as $row) {
        					if(!$flag) {
        // display column names as first row
        						echo implode("\t", array_keys($row)) . "\n";
        						$flag = true;
        					}
    // filter data
        					array_walk($row, 'filterData');
        					echo implode("\t", array_values($row)) . "\n";
        				}
        				exit;
        			}

        		}

        		public function taskViewAction()
        		{
        			$this->checklogin();
        			$db = Zend_Db_Table::getDefaultAdapter();
        			$params = $this->view->params = $this->getRequest()->getParams();

        			$query = "select t.*, l.StaffName,l.id,l.LoginID,t32.id as created_id,t32.StaffName as created_staff from tbl_task as t 
        			left join logi_user as l on(l.id = t.assign_to) 
        			LEFT JOIN logi_user as t32 ON (t32.id = t.created_by) where task_id='".$params['id']."'";
        			$result = $db->fetchRow($query);
	            	// print_r($result);exit;
        			$this->view->description = $result;
        			$layout = $this->_helper->layout();
        			$layout->disableLayout('');   
        		}


        		public function feedbackReportAction(){

        			$this->checklogin();
        			$params = $this->view->params = $this->getRequest()->getParams();
        			$gmap = new Application_Model_Gmap();
        			$this->view->getUserList = $getUserList = $gmap->getUserList($this->role, $this->id);

                    // print_r($getUserList);exit;

        			$sql_user = "select t.*, r.StaffName as retailer, d.StaffName as distributor, l.StaffName,l.id,l.LoginID from tbl_feedback as t 
        			left join logi_user as l on(l.id = t.login_id) 
        			left join logi_user as r on (r.id = t.retailer_id) 
        			left join logi_user as d on (d.id = t.distributor_id)";
        			$result_user = $this->db->fetchAll($sql_user); 
        			// print_r($result_user);exit;
        			$this->view->result_user = $result_user;
        			if($params['Assign_person']!=''){
        				$cond .=" and t.login_id LIKE  '%".$params['Assign_person']."%'";
        			}
        			if($params['date_from'] !=''){
        				$cond .=" and t.created_on LIKE '%".$params['date_from']."%'";
        			}
        			$sql_user1 = "select t.*, l.StaffName,l.id,l.LoginID from tbl_feedback as t left join logi_user as l on(l.id = t.login_id) where 1 $cond order by t.id desc";
        			$result_user1 = $this->db->fetchAll($sql_user1); 

        			$page=$this->_getParam('page',1);
        			$paginator = Zend_Paginator::factory($result_user1);      
        			$paginator = Zend_Paginator::factory($result_user);      
                    $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
                    $paginator->setItemCountPerPage(15); // number of items to show per page
                    $this->view->paginator = $paginator;
                    $this->view->totalrec = $paginator->getTotalItemCount();

                    if($params['report'] == 'Generate'){

                    	$data = array(
                    		array(
                    			'#'=> "",
                    			'User'=> "" , 
                    			'Issues'=> "",
                    			'Remark'=> "",
                    			'Resolution'=>"",
                    			'Create On'=>"",


                    		));
                    	$i = 2; 
                    	foreach ($result_user as $rs) {

                    		$row    = array();
                    		$row[]  = stripslashes($i-1);
                    		$row[]  = stripslashes($rs['StaffName']);
                    		$row[]  = stripslashes($rs['issues']);
                    		$row[]  = stripslashes($rs['remark']);
                    		$row[]  = stripslashes($rs['resolution']);
                    		$row[]  = stripslashes($rs['created_on']);

                    		$data[] = $row;
                    		$i++;
                    	}
                    	function filterData(&$str){
                    		$str = preg_replace("/\t/", "\\t", $str);
                    		$str = preg_replace("/\r?\n/", "\\n", $str);
                    		if(strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
                    	}

        // file name for download
                    	$fileName = "Task Report.xls"; 

        // headers for download
                    	header("Content-Disposition: attachment; filename=\"$fileName\"");
                    	header("Content-Type: application/vnd.ms-excel");

                    	$flag = false;
                    	foreach($data as $row) {
                    		if(!$flag) {
        // display column names as first row
                    			echo implode("\t", array_keys($row)) . "\n";
                    			$flag = true;
                    		}
    // filter data
                    		array_walk($row, 'filterData');
                    		echo implode("\t", array_values($row)) . "\n";
                    	}
                    	exit;
                    }

                  }

        /*  Product Collection Report 
            Created By : Amit Chaurasiya
            Date : 20-07-2018
        */
            public function feedbackViewAction()
            {
            	$this->checklogin();
            	$db = Zend_Db_Table::getDefaultAdapter();
            	$params = $this->view->params = $this->getRequest()->getParams();

            	$query = "select f.*, p.product_name, sp.sub_product_name from tbl_feedback as f 
            	LEFT JOIN logi_product as p ON (p.id = f.product_id)
            	LEFT JOIN sub_product as sp ON (sp.id = f.subproduct_id)"; 
            	$result = $db->fetchRow($query);
                // print_r($result);exit;
            	$this->view->product = $result;
            	$layout = $this->_helper->layout();
            	$layout->disableLayout('');
            }

            public function reachSiteReportAction(){
            	$this->checklogin();
            	$this->db = Zend_Db_Table::getDefaultAdapter();
            	$db = $this->db;
            	$auth = Zend_Auth::getInstance();
            	$authStorage = $auth->getStorage();
            	$this->WebLoginID = $authStorage->read()->LoginID;
            	$params = $this->view->params = $this->getRequest()->getParams(); 
            	$gmap = new Application_Model_Gmap();
            	$this->view->getUserList = $gmap->getUserList();    
            	$users = new Application_Model_Users();
            	$this->view->result =$result =  $users->getReachSiteData($params['user'], $params['selected_date'], $this->role, $this->id);
            	$page=$this->_getParam('page',1);
            	$paginator = Zend_Paginator::factory($result);      
                    $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number 
                    $paginator->setItemCountPerPage(15); // number of items to show per page
                    $this->view->paginator = $paginator;
                    $this->view->totalrec = $paginator->getTotalItemCount();

                    if($params['report'] == 'Generate'){
                    	$data = array(
                    		array(
                    			'#'=> "",
                    			'Sale Person Name'=> "" , 
                    			'Retailer Name'=> "",
                    			'Reach at site date site'=> "",
                    			'Left site date time'=>"",
                    			'Total Working Time'=>"",
                    			'Notification Date'=>""
                    		));
                    	$i = 2; 
                    	foreach ($result as $rs) {
                    		$getReachAtSiteDateTime = $users->getReachAtSiteDateTime($rs['retailer_id'],$rs['app_user_id'], $rs['notification_date']);
                    		$getMoveFromSiteDateTime   = $users->getMoveFromSiteDateTime($rs['retailer_id'],$rs['app_user_id'], $rs['notification_date']);

                    		$dateDiff = intval((strtotime($getMoveFromSiteDateTime['notification_date_time'])-strtotime($getReachAtSiteDateTime['notification_date_time']))/60);
                    		$hours = intval($dateDiff/60);
                    		$minutes = $dateDiff%60;

                    		if($getMoveFromSiteDateTime['notification_date_time']){ 

                    			if($hours !='0'){
                    				$working_hour = $hours.". ".$minutes." hour";
                    			}
                    			else{
                    				$working_hour = $minutes." Min";
                    			} 

                    		}
                    		else{
                    			$working_hour =  ""; 
                    		}

                    		$reach_at_site_date_time  = date("d/m/Y h:i:s", strtotime($getReachAtSiteDateTime['notification_date_time']));
                    		$move_from_site_date_time = date("d/m/Y h:i:s", strtotime($getMoveFromSiteDateTime['notification_date_time']));
                    		$notification_date        = date("d/m/Y", strtotime($rs['notification_date']));

                    		$row    = array();
                    		$row[]  = stripslashes($i-1);
                    		$row[]  = stripslashes($rs['sale_person']);
                    		$row[]  = stripslashes($rs['retailer']);
                    		$row[]  = stripslashes($reach_at_site_date_time);
                    		$row[]  = stripslashes($move_from_site_date_time);
                    		$row[]  = stripslashes($working_hour);
                    		$row[]  = stripslashes($notification_date);

                    		$data[] = $row;
                    		$i++;
                    	}
                    	function filterData(&$str){
                    		$str = preg_replace("/\t/", "\\t", $str);
                    		$str = preg_replace("/\r?\n/", "\\n", $str);
                    		if(strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
                    	}
                    	$fileName = "Site activity report.xls"; 
                    	header("Content-Disposition: attachment; filename=\"$fileName\"");
                    	header("Content-Type: application/vnd.ms-excel");

                    	$flag = false;
                    	foreach($data as $row) {
                    		if(!$flag) {
                    			echo implode("\t", array_keys($row)) . "\n";
                    			$flag = true;
                    		}
                    		array_walk($row, 'filterData');
                    		echo implode("\t", array_values($row)) . "\n";
                    	}
                    	exit;
                    }
                  }

                  public function orderViewAction(){
                   $this->checklogin();
                   $layout = $this->_helper->layout();
                   $layout->disableLayout('');
                   $params = $this->view->params = $this->getRequest()->getParams();

                   $sql    = "select order_items.*,  product.product_name, subproduct.sub_product_name from logi_order_item_detail as order_items left join logi_product as product on(order_items.product_id = product.id) LEFT JOIN  sub_product as subproduct ON (subproduct.id = order_items.subproduct_id) where order_items.order_id = '".$params['id']."'";       
                   $this->view->result = $result = $this->db->fetchAll($sql);
                 }



                 public function retailerGeoLocationAction(){
                   $this->checklogin();
                   $this->db = Zend_Db_Table::getDefaultAdapter();
                   $db = $this->db;

                   $params = $this->view->params = $this->getRequest()->getParams();

                   $sql_user_location = "select tsi.StaffName as tsi_name, retailers_site_location.photograph1,  retailers_site_location.photograph2, logi_user.StaffName,logi_user.address,logi_user.MobileNo ,retailers_site_location.lat,retailers_site_location.long from retailers_site_location left join logi_user on retailers_site_location.retailer_id = logi_user.id 
                   left join logi_user as tsi on tsi.id = logi_user.parent_sale where logi_user.Role = 'Retailer' and md5(retailers_site_location.retailer_id) = '".$params['id']."' and logi_user.StaffStatus = 'AC'";
                   $user_location_result = $db->fetchAll($sql_user_location);   

                   $user_location_result = array('tsi_name'=>$user_location_result[0]['tsi_name'],'photograph1'=>$user_location_result[0]['photograph1'],'photograph2'=>$user_location_result[0]['photograph2'],'StaffName'=>$user_location_result[0]['StaffName'],'address'=>$this->getAddressFromLatLong($user_location_result[0]['lat'], $user_location_result[0]['long']),'MobileNo'=>$user_location_result[0]['MobileNo'],'lat'=>$user_location_result[0]['lat'],'long'=>$user_location_result[0]['long']);

                   $this->view->user_location_result = $user_location_result = $user_location_result;



                 }

                 function getAddressFromLatLong($latitude, $longitude){
                   $val1 = $latitude;
                   $val2 = $longitude;

                   $url  = "https://maps.googleapis.com/maps/api/geocode/json?latlng=".$val1.",".$val2."&sensor=true&key=AIzaSyCHy1BcbxWG5gNfygIGP9DhwqpRUYBgkb0";
                   $json = @file_get_contents($url);
                   $data = json_decode($json);
                    //print_r($data);exit;
                   $status = $data->status;
                   $address = '';
                   if($status == "OK"){
                    $address = $data->results[0]->formatted_address;
                  }
                  if(!empty($address)){
                    $address = $address;
                    return $address;
                  }
                  else{
                    $address = "Not Found";
                    return $address;
                  }

                }


                public function stockHistoryAction(){
                	$this->checklogin();
                	$params = $this->view->params = $this->getRequest()->getParams();

                	$Retailer = new Application_Model_Retailer();
                	$this->view->getAllProduct = $getAllProduct = $Retailer->getAllProduct();

                	if($params['product_id']){
                		$cond .="and subproduct.product_id = '".$params['product_id']."'";
                	}
                	if($params['sub_product']){
                		$cond .="and  subproduct.sub_product_name like '%".$params['sub_product']."%'";
                	}

                	$sql = "select tsh.*, product.product_name, subproduct.product_image, subproduct.sub_product_name, product.product_name from
                	tbl_stock_history as tsh left join sub_product as subproduct on (subproduct.id = tsh.subproduct_id)  left join logi_product as product on (product.id = subproduct.product_id) where 1  $cond order by id desc ";

                	$result = $this->db->fetchAll($sql);        

                	$page=$this->_getParam('page',1);
                	$paginator = Zend_Paginator::factory($result);      
    $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
    $paginator->setItemCountPerPage(15); // number of items to show per page
    $this->view->paginator = $paginator;
    $this->view->totalrec = $paginator->getTotalItemCount();
  }

    /*  Product Allocation Report 
        Created By : Amit Chaurasiya
        Date : 18-07-2018
    */
        public function productAllocationAction()
        {
        	$this->checklogin();
        	$db = Zend_Db_Table::getDefaultAdapter();
        	$params = $this->view->params = $this->getRequest()->getParams();
        	if($params['allocator']){
        		$cond .="and creator.StaffName LIKE '%".$params['allocator']."%'";
        	}
        	if($params['allocated_date']){
        		$cond .="and  date(pa.allocated_date) LIKE '%".$params['allocated_date']."%'";
        	}

            // echo "Hello World!";exit;
        	$product_allocation_query = " select pa.*, pa.allocated_to as at, retailer.StaffName as allocated_to, distributor.StaffName as distributor, creator.StaffName as allocatedBy FROM tbl_product_allocation as pa 
        	LEFT JOIN logi_user AS retailer ON (retailer.id = pa.allocated_to) 
        	LEFT JOIN logi_user AS distributor ON (distributor.id = pa.distributor_id) 
        	LEFT JOIN logi_user AS creator ON (creator.id = pa.allocated_by) where 1 $cond order by allocated_date DESC";
        	$product_allocation_result = $db->fetchAll($product_allocation_query);
            // print_r($product_allocation_result);exit;
            // $this->view->product = $product_allocation_result;
        	$page=$this->_getParam('page',1);
        	$paginator = Zend_Paginator::factory($product_allocation_result);      
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(15); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec = $paginator->getTotalItemCount();
        if($params['report'] == 'Generate'){

        	$data = array(
        		array(
        			'#'=> "",
        			'Allocated By'=> "" , 
        			'Product Name'=> "",
        			'Sub Product Name'=> "",
        			'Allocated Date'=>"",
        			'Remark'=>"",
        			'Allocated To'=>"",
        		));
        	$i = 2; 
        	foreach ($product_allocation_result as $rs) {



        		$row = array();
        		$row[] = stripslashes($i-1);
        		$row[] = stripslashes($rs['allocated_by']);
        		$row[] = stripslashes($rs['product_name']);
        		$row[] = stripslashes($rs['sub_product_name']);
        		$row[] = stripslashes($rs['allocated_date']);
        		$row[] = stripslashes($rs['remark']);
        		$row[] = stripslashes($rs['allocated_to']);
        		$data[] = $row;
        		$i++;
        	}
        	function filterData(&$str){
        		$str = preg_replace("/\t/", "\\t", $str);
        		$str = preg_replace("/\r?\n/", "\\n", $str);
        		if(strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
        	}
            // file name for download
        	$fileName = "Product_allocation.xls"; 
            // headers for download
        	header("Content-Disposition: attachment; filename=\"$fileName\"");
        	header("Content-Type: application/vnd.ms-excel");

        	$flag = false;
        	foreach($data as $row) {
        		if(!$flag) {
                    // display column names as first row
        			echo implode("\t", array_keys($row)) . "\n";
        			$flag = true;
        		}
                // filter data
        		array_walk($row, 'filterData');
        		echo implode("\t", array_values($row)) . "\n";
        	}
        	exit;
        }   
      }

    /*  Product Collection Report 
            Created By : Amit Chaurasiya
            Date : 20-07-2018
        */
            public function productViewAction()
            {
            	$this->checklogin();
            	$db = Zend_Db_Table::getDefaultAdapter();
            	$params = $this->view->params = $this->getRequest()->getParams();

            	$query = "select pd.*, pa.remark, p.product_name as productName, sp.sub_product_name as subproductName FROM tbl_allocated_product_details as pd 
            	LEFT JOIN logi_product as p ON (p.id = pd.product_id) 
            	LEFT JOIN tbl_product_allocation as pa ON (pa.id = pd.product_id) 
            	LEFT JOIN sub_product as sp ON (sp.id = pd.subproduct_id) WHERE pd.id ='".$params['id']."'";
            	$result = $db->fetchAll($query);
            	// print_r($result);exit;
            	$this->view->product = $result;
            	$layout = $this->_helper->layout();
            	$layout->disableLayout('');

            }

        /*  Product Collection Report 
            Created By : Amit Chaurasiya
            Date : 18-07-2018
        */
            public function collectionAction()
            {
            	$this->checklogin();
            	$db = Zend_Db_Table::getDefaultAdapter();
            	$params = $this->view->params = $this->getRequest()->getParams();
            	if($params['allocator']){
            		$cond .="and creator.StaffName LIKE '%".$params['collector']."%'";
            	}
            	if($params['allocated_date']){
            		$cond .="and  date(col.collection_date) LIKE '%".$params['collection_date']."%'";
            	}
            	$collection_query = "select col.*, retailer.StaffName as retailer, distributor.StaffName as distributor, collector.StaffName as collector from tbl_collection as col 
            	LEFT JOIN logi_user AS retailer ON (col.retailer_id = retailer.id) 
            	LEFT JOIN logi_user AS distributor ON (col.distributor_id = distributor.id) 
            	LEFT JOIN logi_user AS collector ON (col.created_by = collector.id) 
            	where 1 $cond order by collection_date DESC";
            	$collection_result = $db->fetchAll($collection_query);
                // $this->view->collection = $collection_result;
            	$page=$this->_getParam('page',1);
            	$paginator = Zend_Paginator::factory($collection_result);      
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(15); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec = $paginator->getTotalItemCount();
        if($params['report'] == 'Generate'){

        	$data = array(
        		array(
        			'#'=> "",
        			'Retailer'=> "" , 
        			'Distributor'=> "",
        			'Payment Mode'=> "",
        			'Amount'=>"",
        			'Collected By'=>"",
        			'Collection Date'=>"",
        		));
        	$i = 2; 
        	foreach ($collection_result as $rs) {



        		$row = array();
        		$row[] = stripslashes($i-1);
        		$row[] = stripslashes($rs['retailer']);
        		$row[] = stripslashes($rs['distributor']);
        		$row[] = stripslashes($rs['payment_mode']);
        		$row[] = stripslashes($rs['amount']);
        		$row[] = stripslashes($rs['collector']);
        		$row[] = stripslashes($rs['collection_date']);
        		$data[] = $row;
        		$i++;
        	}
        	function filterData(&$str){
        		$str = preg_replace("/\t/", "\\t", $str);
        		$str = preg_replace("/\r?\n/", "\\n", $str);
        		if(strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
        	}
            // file name for download
        	$fileName = "Collection_report.xls"; 
            // headers for download
        	header("Content-Disposition: attachment; filename=\"$fileName\"");
        	header("Content-Type: application/vnd.ms-excel");

        	$flag = false;
        	foreach($data as $row) {
        		if(!$flag) {
                    // display column names as first row
        			echo implode("\t", array_keys($row)) . "\n";
        			$flag = true;
        		}
                // filter data
        		array_walk($row, 'filterData');
        		echo implode("\t", array_values($row)) . "\n";
        	}
        	exit;
        }   
      }

      public function checklogin(){   
       $auth = Zend_Auth::getInstance(); 
       $errorMessage = ""; 
       /*************** check user identity ************/
       if(!$auth->hasIdentity()){
        $this->_redirect('admin/index');  
      }   
    }     
  }
