<?php

/***************************************************************
* Logimetrix Techsolution Pvt. Ltd.
* File Name           : TestApiController.php
* File Description   : All Api Method
* Created By        : Arpita Upadhyay
* Created Date     : 20-JUN-2019
***************************************************************/



class TestApiController extends Zend_Controller_Action{

	var $phpNative;
	var $secretkey;
	var $db;
	var $currdate;
	var $siteurl;

	public function init(){
        //Initialize action controller here 
		$this->_helper->viewRenderer->setNoRender(true);
		$bootstrap           = $this->getInvokeArg('bootstrap');
		$aConfig             = $bootstrap->getOptions();
		if(isset($aConfig['api']['searchuser']['secret']) && $aConfig['api']['searchuser']['secret'] != ""){
			$this->secretkey = $aConfig['api']['searchuser']['secret'];
		}
		$this->siteurl   = $aConfig['api']['site']['url'];
		$this->db        = Zend_Db_Table::getDefaultAdapter();
        $this->currdate  = date("Y-m-d H:i:s"); //$date->toString('Y-m-d H:m:s');
        $this->day       = date("d");
        $this->month     = date("m");
        $this->year      = date("Y");
    }
    
    public function bmcAuditAction(){
        // Get the Request parameters
    	$params        = $this->getRequest()->getParams();
    	$secretkey      = $this->secretkey;
    	$db             = $this->db;
    	$appkey         = isset($params['appkey']) ? $params['appkey'] : "";
    	$password         = isset($params['password']) ? $params['password'] : "";
    	$user_id        = isset($params['LoginID']) ? $params['LoginID'] : "";
    	$Imei           = isset($params['device_id']) ? $params['device_id'] : "";
    	$device_type    = isset($params['device_type']) ? $params['device_type'] : "";

    	$error_code     = 1;
    	$succes         = FALSE;

    	try {

    		$db->beginTransaction();
    		$user                       = new Application_Model_Users();


    		if (!$appkey || !$password || !$user_id || !$Imei || !$device_type) {
    			throw new Exception("Required parameter missing.");
    		}

    		$alldata                    = $user->getUserDataByLoginId($user_id,$password);
    		if ($alldata['Device_token'] != $appkey) {
    			throw new Exception("Invalid request.");
    		}

    		if (!$Imei || !$user_id) {
    			throw new Exception("Required parameter missing.");
    		}

    		if (!empty($alldata['LoginID']) != $user_id) {
    			throw new Exception('Invalid login id.');
    		}

    		if (!empty($alldata['device_id'])) {
    			if ($alldata['device_id'] != $Imei) {
    				$error_code = 3;
    				throw new Exception('You are not athorized for this device.');
    			}
    		}

    		
    		if (strtolower($alldata['StaffStatus']) != 'ac') {
    			$error_code = 3;
    			throw new Exception('Your account is not active.');
    		}

    		if ($alldata['access_status'] == 2) {
    			$error_code = 2;
    			throw new Exception('This account deactivated by admin.');
    		}
    		

    		$bmcAudit = array();    			   		
    		$bmcAudit['is_premises_clean']                     = $params['is_premises_clean'];
    		$bmcAudit['unwanted_materials_type']               = $params['unwanted_materials_type'];
    		$bmcAudit['cobwebs_found']                         = $params['cobwebs_found'];
    		$bmcAudit['cleaning_condition_of']                 = $params['cleaning_condition_of'];
    		$bmcAudit['air_curtain']                           = $params['air_curtain'];
    		$bmcAudit['fly_catcher']                           = $params['fly_catcher'];
    		$bmcAudit['bmc_tank_and_bmc_valve']                = $params['bmc_tank_and_bmc_valve'];
    		$bmcAudit['indiFoss_&_epos']                       = $params['indiFoss_&_epos'];
    		$bmcAudit['weighing_platform_top']                 = $params['weighing_platform_top	'];
    		$bmcAudit['weighing_platform_from_below']          = $params['weighing_platform_from_below'];
    		$bmcAudit['ss_strainer']                           = $params['ss_strainer'];
    		$bmcAudit['nylon_filter']                          = $params['nylon_filter'];
    		$bmcAudit['ss_cans']                               = $params['ss_cans'];
    		$bmcAudit['plunger_and_dipper']                    = $params['plunger_and_dipper'];
    		$bmcAudit['ss_drain_trap']                         = $params['ss_drain_trap'];
    		$bmcAudit['glassware_and_lab_Instruments']         = $params['glassware_and_lab_Instruments'];
    		$bmcAudit['flooring_and_lab_platform']             = $params['flooring_and_lab_platform'];
    		$bmcAudit['dust_collection']                       = $params['dust_collection'];
    		$bmcAudit['files_and_type_insects_inside_bmc']     = $params['files_and_type_insects_inside_bmc'];
    		$bmcAudit['facilitator_reaches_bmc']               = $params['facilitator_reaches_bmc'];
    		$bmcAudit['is_bmc_connected']                      = $params['is_bmc_connected'];
    		$bmcAudit['is_proper_light_maintained']            = $params['is_proper_light_maintained'];
    		$bmcAudit['fssai_license']                         = $params['fssai_license'];
    		$bmcAudit['cleaniness']                            = $params['cleaniness'];
    		$bmcAudit['collection_start_and_finish_on_time']   = $params['collection_start_and_finish_on_time'];
    		$bmcAudit['door_remains_closed_during_collection'] = $params['door_remains_closed_during_collection'];
    		$bmcAudit['air_curtain_is_switched_on']            = $params['air_curtain_is_switched_on'];
    		$bmcAudit['pest_o_flash_is_operating']             = $params['pest_o_flash_is_operating'];
    		$bmcAudit['exhaust_is_running']                    = $params['exhaust_is_running'];
    		$bmcAudit['indifoss_properly_operating']           = $params['indifoss_properly_operating'];
    		$bmcAudit['facilitator_is_using_cap']              = $params['facilitator_is_using_cap'];
    		$bmcAudit['milk_producers_maintain']               = $params['milk_producers_maintain'];
    		$bmcAudit['fifo']             = $params['fifo'];
    		$bmcAudit['all_farmers_carrying_ss_cans']          = $params['all_farmers_carrying_ss_cans'];
    		$bmcAudit['all_farmers_follow_cleaning']           = $params['all_farmers_follow_cleaning'];
    		$bmcAudit['proper_sampling_followed']              = $params['proper_sampling_followed'];
    		$bmcAudit['facilitator_follows_ot']                = $params['facilitator_follows_ot'];
    		$bmcAudit['low_quality_and_substandard_milk']      = $params['low_quality_and_substandard_milk'];
    		$bmcAudit['all_farmers_receiving_slips']           = $params['all_farmers_receiving_slips'];
    		$bmcAudit['all_farmers_personally_coming']         = $params['all_farmers_personally_coming'];
    		$bmcAudit['milk_spillage_near_bmc']                = $params['milk_spillage_near_bmc'];
    		$bmcAudit['is_cleaning_equipment_maintained']      = $params['is_cleaning_equipment_maintained'];
    		$bmcAudit['ss_strainer_using_pouring']             = $params['ss_strainer_using_pouring'];
    		$bmcAudit['bmc_with_agitator']                     = $params['bmc_with_agitator'];
    		$bmcAudit['bmc_is_in_auto_mode']                   = $params['bmc_is_in_auto_mode'];
    		$bmcAudit['both_compressors_working']              = $params['both_compressors_working'];
    		$bmcAudit['temperature_of_milk_is_maintained']     = $params['temperature_of_milk_is_maintained'];
    		$bmcAudit['bmc_record_maintained']                 = $params['bmc_record_maintained'];
    		$bmcAudit['number_of_farmers_are_same']            = $params['number_of_farmers_are_same'];
    		$bmcAudit['tanker_dispatch_challan']               = $params['tanker_dispatch_challan'];
    		$bmcAudit['cleaning_of_bmc']                       = $params['cleaning_of_bmc'];
    		$bmcAudit['cleaning_condition_after_collection']   = $params['cleaning_condition_after_collection'];
    		$bmcAudit['bulk_milk_cooler_tank']                 = $params['bulk_milk_cooler_tank'];
    		$bmcAudit['bmc_valve_&_lid']                       = $params['bmc_valve_&_lid'];
    		$bmcAudit['Indi_foss_&_epos']                      = $params['Indi_foss_&_epos'];
    		$bmcAudit['weighing_platform']                     = $params['weighing_platform'];
    		$bmcAudit['ss_strainer_maintain']                  = $params['ss_strainer_maintain'];
    		$bmcAudit['nylon_filter_after_collection']         = $params['nylon_filter_after_collection'];
    		$bmcAudit['ss_cans_after_collection']              = $params['ss_cans_after_collection'];
    		$bmcAudit['plunger_and_dipper_after_collection']   = $params['plunger_and_dipper_after_collection'];
    		$bmcAudit['drain_trap']                            = $params['drain_trap'];
    		$bmcAudit['glassware_and_lab_Instruments_after_collection']   = $params['glassware_and_lab_Instruments_after_collection'];
    		$bmcAudit['flooring_and_lab_platform_after_collection']       = $params['flooring_and_lab_platform_after_collection'];
    		$bmcAudit['material_and_equipment_placed']                    = $params['material_and_equipment_placed'];
    		$bmcAudit['sufficient_stock_of_liquid_soap']                  = $params['sufficient_stock_of_liquid_soap'];
    		$bmcAudit['audit_date']                                       = $params['audit_date'];

    		$db->insert('tbl_bmc_audit', $bmcAudit);


    		$db->commit();
    		$succes = TRUE;

    	}

    	catch (Exception $e) {
            //Rollback transaction
    		$db->rollBack();
    		$error = $e->getMessage();
    	}

    	if ($succes == TRUE) {
    		echo json_encode(array(
    			"error_code" => '0',
    			'response_string' => 'BMC Audit detail added successfully'
    		));
    		exit;
    	} else {
    		echo json_encode(array(
    			"error_code" => $error_code,
    			'response_string' => $error
    		));
    		exit;
    	}
    }
}