<?php

/***************************************************************
 * Logimetrix Techsolutions Pvt. Ltd.
 * File Name   : SubproductController.php
 * File Description  : SubproductController
 * Created By : Ajay Kumar
 * Created Date: 25 Nov 2016
 ***************************************************************/

class SubproductController extends Zend_Controller_Action{
  var $dbAdapter;
  var $db;
  public function init(){
    /* Initialize action controller here */
    $this->_flashMessenger  = $this->_helper->getHelper('FlashMessenger');
    $bootstrap = $this->getInvokeArg('bootstrap');
    $aConfig = $bootstrap->getOptions();
    $this->db = Zend_Db_Table::getDefaultAdapter();
    $auth = Zend_Auth::getInstance();
    $authStorage = $auth->getStorage();
    $this->WebLoginID = $authStorage->read()->WebLoginID;
    $users = new Application_Model_Users();
    $logout_details = $users->getUserLoginDetailByWebLoginCode($this->WebLoginID);
    $this->view->last_login = $logout_details['login_time'];               
  }

  public function indexAction(){
    $this->checklogin();
    $this->view->messages = $this->_flashMessenger->getMessages();
    $params = $this->view->params = $this->getRequest()->getParams();

    $Retailer = new Application_Model_Retailer();
    $this->view->getAllProduct = $getAllProduct = $Retailer->getAllProduct();


    if($params['product_id']){
      $cond .="and subproduct.product_id = '".$params['product_id']."'";
    }
    if($params['sub_product']){
     $cond .="and subproduct.sub_product_name like '%".$params['sub_product']."%'";
   }

   $query = "select u.id, u.unit, subproduct.sku, subproduct.product_image, subproduct.description, subproduct.rate , subproduct.qty_in_stock, subproduct.id, subproduct.sub_product_name,subproduct.gst_slab,subproduct.gst_rate, product.product_name, unit.unit from sub_product as subproduct 
   left join unit as unit on (subproduct.unit = unit.id) 
   left join logi_product as product on (product.id = subproduct.product_id) 
   left join unit as u on (u.id = subproduct.unit) where subproduct.status = '1' $cond order by subproduct.id desc ";      
   $result = $this->db->fetchAll($query); 

   $page=$this->_getParam('page',1);
   $paginator = Zend_Paginator::factory($result);      
            $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
            $paginator->setItemCountPerPage(30); // number of items to show per page
            $this->view->paginator = $paginator;
            $this->view->totalrec = $paginator->getTotalItemCount();
          }

          public function addNewSubProductAction(){
            $this->checklogin();
            $db = $this->db;
            $this->view->messages = $this->_flashMessenger->getMessages();
            
            $params = $this->getRequest()->getParams();
            $Retailer = new Application_Model_Retailer();
            $this->view->params = $params;
            $auth = Zend_Auth::getInstance();
            $authStorage = $auth->getStorage();
            $sql = "select * from unit";
            $this->view->res_unit = $res_unit = $db->fetchAll($sql);

            $this->view->GetallUnitType = $GetallUnitType = $Retailer->GetallUnitType();
            $this->view->getAllProduct = $getAllProduct = $Retailer->getAllProduct();
            $gstdata ="SELECT id,CONCAT(gst_slab_from,'-',gst_slab_to) AS gst_slab,gst_rate FROM tbl_gst_slab";
            $this->view->gstslab = $gstslab = $db->fetchAll($gstdata);

            if($this->getRequest()->isPost()){ 
              if($params['submit']=='Save'){
                if(isset($_FILES['product_image']['tmp_name']) AND !empty($_FILES['product_image']['tmp_name'])){
                  $tempName   = $_FILES['product_image']['tmp_name'];
                  $type       = explode('.', $_FILES['product_image']['name']);
                  $imageName  = time().'.'.$_FILES['product_image']['name']; 
                  $uploads    = 'uploads/product_catalogue/';
                  if(!file_exists($uploads)){
                    mkdir($uploads); 
                  }
                  $pathComplete = $uploads.$imageName;
                  @move_uploaded_file($tempName,$pathComplete);
                }
                $data = array();

                $gstdataSql ="SELECT id,CONCAT(gst_slab_from,'-',gst_slab_to) AS gst_slab,gst_rate FROM tbl_gst_slab where id =".$params['gst_slab'];
                $gstslab = $db->fetchRow($gstdataSql);


                $data['product_id']       = $params['product'];
                $data['sub_product_name'] = $params['sub_product'];
                $data['rate']             = $params['rate'];
                $data['unit']             = $params['unit'];
                $data['pouch_per_crate']  = $params['pouch_per_crate'];
                $data['product_image']    = $imageName;
                $data['description']      = $params['product_description'];
                $data['gst_slab']         = $gstslab['gst_slab'];
                $data['gst_rate']         = $params['price_off'];
                // echo "<pre>";
                // print_r($data);
                // exit();

                $db->insert('sub_product', $data);                                       
                $this->_flashMessenger->addMessage('Sub Product Detail added successfully.'); 
                $this->_redirect('subproduct/add-new-sub-product');
              }
              else{

                if($_FILES['importxl']==''){ ?>
                  <script>alert("Please Choose a Excel File.")</script><?php
                }
                else{

                  if(isset($_FILES["importxl"]["error"])){
                    if($_FILES["importxl"]["error"] > 0){ ?>
                      <script>alert("Please select file.")</script><?php
                    }
                    else{
                      $allowed = array("xls" => "application/vnd.ms-excel", "xlsx" => "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
                      $filename = $_FILES["importxl"]["name"];
                      $filetype = $_FILES["importxl"]["type"];
                      $filesize = $_FILES["importxl"]["size"];
                      
                      $ext = pathinfo($filename, PATHINFO_EXTENSION);
                      if(!array_key_exists($ext, $allowed)){
                        ?><script>alert("This file is not an accepted file type.")</script><?php
                      }
                            // siati fua - 10MB
                      $maxsize = 200000 * 60;
                      if($filesize > $maxsize) { ?>
                        <script>alert("File size is larger than the allowed 10MB limit.")</script>
                      <?php }

                      if(in_array($filetype, $allowed)){
                        move_uploaded_file($_FILES["importxl"]["tmp_name"], "PHPExcleReader/" . $_FILES["importxl"]["name"]);
                        /** Include path **/
                        set_include_path(get_include_path() . PATH_SEPARATOR . 'PHPExcleReader/Classes/');

                        /** PHPExcel_IOFactory */
                        include 'PHPExcel/IOFactory.php';

                  $inputFileName = 'PHPExcleReader/'.$filename;  // File to read
                  try {
                    $objPHPExcel = PHPExcel_IOFactory::load($inputFileName);
                  } 
                  catch(Exception $e) {
                    die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
                  }
                  $sheetData = $objPHPExcel->getActiveSheet()->toArray(null,true,true,true);

                  $arr = array();
                  $k   = 0;  

                  foreach($sheetData as $key){
                    $x  = array('product_code'=>trim($key['A']),'subproduct_name'=>trim($key['B']),'rate'=>trim($key['C']),'sku'=>trim($key['D']),'description'=>trim($key['E']));
                    $arr[$k] = $x;
                    $k++;
                  }
                  array_shift($arr);
                  //Existing products array 
                  echo '<pre>';
                  print_r($arr);
                  exit();
                  $array_existing_product = array();  
                  foreach($arr as  $key){
                    $product = trim($key['product']);
                    if($product){
                      //vaidate existing product
                      $sqlVaidateProduct = "select * from logi_product where product_name = '".ucfirst($params['product'])."'";
                      $resultProduct = $db->fetchRow($sqlVaidateProduct);
                      
                      if($resutProduct){
                        $this->view->errorMessage = "Product allready exists";
                        array_push($array_existing_product, "".$product."");
                      }
                      else{
                        $data = array();
                        $data['product_name'] = ucfirst($product);
                        $db->insert('logi_product', $data);
                      }
                    } 
                  }
                }
                if($array_existing_product){
                  $existing_product_str = implode(',', $array_existing_product);
                  $this->view->errorMessage = $existing_product_str." these products allready exists";
                }
                $this->view->successMessage = "Product Detail added successfully.";                
              }
            }
          }
        }

      }        
    }

    public function editSubProductAction(){

      $db = $this->db;
      $this->view->messages = $this->_flashMessenger->getMessages();
      $auth = Zend_Auth::getInstance();
      $authStorage = $auth->getStorage();
      $params = $this->getRequest()->getParams();
      $Retailer = new Application_Model_Retailer();               
      $this->view->params = $params;
      $sql = "select * from unit";
      $this->view->res_unit = $res_unit = $db->fetchAll($sql);
      $this->view->GetallUnitType = $GetallUnitType = $Retailer->GetallUnitType();
      $this->view->getAllProduct = $getAllProduct = $Retailer->getAllProduct(); 
      
      $this->view->result = $result = $Retailer->GetSubProductDetailId($params['datacode']);    $gstdata ="SELECT id,CONCAT(gst_slab_from,'-',gst_slab_to) AS gst_slab,gst_rate FROM tbl_gst_slab";
      $this->view->gstslab = $gstslab = $db->fetchAll($gstdata);

      if($this->getRequest()->isPost()){
        try{

          if(isset($_FILES['product_image']['tmp_name']) AND !empty($_FILES['product_image']['tmp_name'])){
            $tempName   = $_FILES['product_image']['tmp_name'];
            $type       = explode('.', $_FILES['product_image']['name']);
            $imageName  = time().'.'.$_FILES['product_image']['name']; 
            $uploads    = 'uploads/product_catalogue/';
            if(!file_exists($uploads)){
              mkdir($uploads); 
            }
            $pathComplete = $uploads.$imageName;
            @move_uploaded_file($tempName,$pathComplete);
          }
          $data = array();

          $gstdataSql ="SELECT id,CONCAT(gst_slab_from,'-',gst_slab_to) AS gst_slab,gst_rate FROM tbl_gst_slab where id =".$params['gst_slab'];
          $gstslab = $db->fetchRow($gstdataSql);
          $data['product_id']       = $params['product'];
          $data['sub_product_name'] = $params['sub_product'];
          $data['rate']             = $params['rate'];
          $data['unit']             = $params['unit'];
          
          $data['rate']             = $params['rate'];
          $data['pouch_per_crate']  = $params['pouch_per_crate'];

          if($imageName){
            $data['product_image']  = $imageName;
          }
          $data['description']      = $params['product_description'];
          $data['gst_slab']         = $gstslab['gst_slab'];   
          $data['gst_rate']         = $params['price_off'];

          $db->update('sub_product',$data,array('id=?'=>$params['sub_product_id']));
          $this->_flashMessenger->addMessage('Sub Product Detail Updated successfully.'); 
          $this->_redirect('/subproduct/index');

        }catch(Exception $e){
          echo $e->getMessage();exit;
        }
      }        
    }

    public function productFormatAction(){

      $this->checklogin();
      $this->view->messages  = $this->_flashMessenger->getMessages();
      $db = $this->db = Zend_Db_Table::getDefaultAdapter();
      $this->view->params = $params = $this->getRequest()->getParams();
      $sql_user = "select * from logi_product  where status = '0'";
      $result = $this->db->fetchAll($sql_user);

      include 'PHPExcel/IOFactory.php';
      require_once 'PHPExcel/Classes/PHPExcel.php';
      $objPHPExcel = new PHPExcel();
      $objPHPExcel->getProperties()->setCreator("Ajay Kumar")
      ->setLastModifiedBy("Ajay Kumar")
      ->setTitle("Office 2007 XLSX  Document")
      ->setSubject("Office 2007 XLSX  Document")
      ->setDescription("Document for Office 2007 XLSX, generated using PHP classes.")
      ->setKeywords("office 2007 openxml php")
      ->setCategory("BOQ Data");
      
      $objPHPExcel->getActiveSheet()
      ->setCellValue('A1', 'Product Code')
      ->setCellValue('B1', 'Product Name');
      $default_border = array(
        'style' => PHPExcel_Style_Border::BORDER_THIN,
        'color' => array('rgb'=>'000000')
      );

      $style_header = array(
        'fill' => array(
          'type' => PHPExcel_Style_Fill::FILL_SOLID,
          'color' => array('rgb'=>'999999')
        )
      );
      $objPHPExcel->getActiveSheet()->getStyle('A1:J1'); 
      $i = 2;   
      foreach($result as $data){
        $product_code = 'PRO00'.$data['id'];  
        $objPHPExcel->setActiveSheetIndex(0)
        ->setCellValue('A'.$i, $product_code)->setCellValue('B'.$i, $data['product_name']);
        $i++; 
      }
      $objPHPExcel->setActiveSheetIndex(0);

      header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
      header('Content-Disposition: attachment;filename="product_format.xlsx"');
      header('Cache-Control: max-age=0'); 

      $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
      $objWriter->save('php://output');

      exit;
    }

    public function deleteSubProductAction(){   
      $this->checklogin(); 
      $Retailer = new Application_Model_Retailer();
      $subproductId = $this->getRequest()->getParam('subproductId');
      if($subproductId!=""){ 
        $Retailer->DeleteSubProducttype($subproductId);
        $this->_redirect('subproduct'); 
      }                                                                                    
    }

    public function updateQtyAction(){
      $db = $this->db;
      $layout = $this->_helper->layout();
      $layout->disableLayout('');
      $this->view->params = $params = $this->getRequest()->getParams();
      $sql_get_subprdouct_detail = "select qty_in_stock from sub_product where id = '".$params['id']."'";
      $this->view->result = $result = $db->fetchRow($sql_get_subprdouct_detail);
      if($params['qty'] !=""){
        $sql_get_subprdouct_detail = "select qty_in_stock from sub_product where id = '".$params['subproduct_id']."'";
        $result = $db->fetchRow($sql_get_subprdouct_detail);

        $total_qty = $params['qty']   + $result['qty_in_stock'];

        $data = array();
        $data['qty_in_stock'] = $total_qty;
        $db->update('sub_product',$data,array('id=?'=>$params['subproduct_id']));

        $curr_date = date('Y-m-d');
        $stock_history    = array();
        $stock_history['subproduct_id'] = $params['subproduct_id'];
        $stock_history['qty']           = $params['qty'];
        $stock_history['created_at']    = $curr_date;
        $db->insert('tbl_stock_history', $stock_history);
      }
    }

    public function checklogin(){   
      $auth = Zend_Auth::getInstance(); 
      $errorMessage = ""; 
      /*************** check user identity ************/
      if(!$auth->hasIdentity()){
        $this->_redirect('admin/index');  
      }   
    }     
  }
