<?php

/***************************************************************
 * Logimetrix Techsolutions Pvt. Ltd.
 * File Name   : StateController.php
 * File Description  : StateController
 * Created By : Puneet Mishra
 * Created Date: 25 Nov 2016
 ***************************************************************/
 
class StateController extends Zend_Controller_Action{
    var $dbAdapter;
    var $db;
    public function init(){
             /* Initialize action controller here */
             $bootstrap = $this->getInvokeArg('bootstrap');
             $aConfig = $bootstrap->getOptions();
             $this->db = Zend_Db_Table::getDefaultAdapter();
             $auth = Zend_Auth::getInstance();
             $authStorage = $auth->getStorage();
             $this->WebLoginID = $authStorage->read()->WebLoginID;
             $users = new Application_Model_Users();
             $logout_details = $users->getUserLoginDetailByWebLoginCode($this->WebLoginID);
             $this->view->last_login = $logout_details['login_time'];               
    }
    
    public function indexAction(){

             $this->checklogin();
             $params = $this->view->params = $this->getRequest()->getParams(); 
             $db = $this->db = Zend_Db_Table::getDefaultAdapter();

             $state_query = "SELECT * FROM state";
             $this->view->state_result = $state_result = $db->fetchAll($state_query);

             $page=$this->_getParam('page',1);
             $paginator = Zend_Paginator::factory($state_result);      
             $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
             $paginator->setItemCountPerPage(10); // number of items to show per page
             $this->view->paginator = $paginator;
             $this->view->totalrec = $paginator->getTotalItemCount();
    }

    public function addNewStateAction(){
            $this->checklogin();
            $db = $this->db = Zend_Db_Table::getDefaultAdapter();
            $this->view->params = $params = $this->getRequest()->getParams();
            
            $auth = Zend_Auth::getInstance();
            $authStorage = $auth->getStorage();

            if($this->getRequest()->isPost()){ 

                $state = array();

                $state['state'] = $params['state'];

                $db->insert('state', $state);
                 
                $state_id = $db->lastInsertId();

                foreach ($params['district_name'] as $key => $value) {
                    $district = array();
                    $district['state'] = $state_id;
                    $district['district'] = $params['district_name'][$key];
                    $db->insert('district', $district);  
                }  
                                                      
                $this->view->successMessage = "State Detail added successfully.";
                $this->_redirect("state/"); 
            }        
    }
  
  
  
    public function editStateAction(){
            $this->checklogin();
            
            $auth = Zend_Auth::getInstance();
            $authStorage = $auth->getStorage();
            
            $db = $this->db = Zend_Db_Table::getDefaultAdapter();
            $this->view->params = $params = $this->getRequest()->getParams('id');
            $Retailer = new Application_Model_Retailer();               

            $state_query = "SELECT * FROM state WHERE id = '".$params['id']."' ";
            $this->view->state_result = $state_result = $db->fetchRow($state_query);

            $district_query = "SELECT * FROM district WHERE state = '".$state_result['id']."' ";
            $this->view->district_result = $district_result = $db->fetchAll($district_query);

            if($this->getRequest()->isPost()){
                $state = array();
                $state['state'] = $params['state'];   
                $db->update('state', $state, array('id=?'=>$params['id'])); 

                foreach ($params['district_name'] as $key => $value) {     
                    $district = array();
                    foreach ($value as $key => $x_value) {
                         $district['district'] = $x_value;
                         $db->update('district', $district, array('state=?'=>$params['id'],'id=?' =>$key));  
                    }

                }  
                $this->view->successMessage = "State Detail(s) updated successfully.";
                $this->_redirect('state/');

            }        
    }

    public function deleteStateAction(){ 
      
      $db = $this->db = Zend_Db_Table::getDefaultAdapter();
      $this->view->params = $params = $this->getRequest()->getParams('id');
      
      $state = array();
      $district = array();

       $state[] = $this->db->quoteInto('id=?', $params['id']);
       $district[] = $this->db->quoteInto('state=?', $params['id']);

       $state_result =  $this->db->delete('state', $state);
       $district_result =  $this->db->delete('district', $district);

       $this->view->successMessage = "State Detail(s) deleted successfully.";
        
       $this->_redirect('/state/');     
    }
     
  public function checklogin(){   
      $auth = Zend_Auth::getInstance(); 
      $errorMessage = ""; 
      /*************** check user identity ************/
      if(!$auth->hasIdentity()){
            $this->_redirect('admin/index');  
      }   
  }     
}