<?php

/***************************************************************
 * Logimetrix Techsolutions Pvt. Ltd.
 * File Name   : SchemeController.php
 * File Description  : SchemeController
 * Created By : Puneet Mishra
 * Created Date: 14 Nov 2017
 ***************************************************************/

class SchemeController extends Zend_Controller_Action{

  var $dbAdapter;
  var $db;

  public function init(){
   /* Initialize action controller here */
   $this->_flashMessenger  = $this->_helper->getHelper('FlashMessenger');
   $bootstrap = $this->getInvokeArg('bootstrap');
   $aConfig = $bootstrap->getOptions();
   $this->db = Zend_Db_Table::getDefaultAdapter();
   $auth = Zend_Auth::getInstance();
   $authStorage = $auth->getStorage();
   $this->WebLoginID = $authStorage->read()->WebLoginID;
   $users = new Application_Model_Users();
   $logout_details = $users->getUserLoginDetailByWebLoginCode($this->WebLoginID);
   $this->view->last_login = $logout_details['login_time'];               
 }

 public function indexAction(){
   $this->checklogin();
   $params = $this->view->params = $this->getRequest()->getParams(); 
   $Retailer = new Application_Model_Retailer(); 

 }

 public function manageProductSchemeAction(){
  $this->checklogin();
  $db = $this->db;
  $params = $this->getRequest()->getParams();
  $Retailer = new Application_Model_Retailer();
  $this->view->messages = $this->_flashMessenger->getMessages();
  $this->view->params = $params;
  $auth = Zend_Auth::getInstance();
  $authStorage = $auth->getStorage();

  $sql_product = "select * from logi_product";
  $res_product = $this->db->fetchAll($sql_product);
  $this->view->res_product = $res_product;

  $sql_route = "select * from tbl_route order by route_name";
  $res_route = $this->db->fetchAll($sql_route);
  $this->view->res_route = $res_route;

  $sql_user = "select * from logi_user where Role ='Distributer' order by StaffName";
  $res_user = $this->db->fetchAll($sql_user);
  $this->view->res_distributor = $res_user;

  $sql_prduct_scheme_mapping = "select spsm.*, psf.product_name as scheme_on_product, spsf.sub_product_name as scheme_on_subproduct, r.route_name, d.StaffName, p.product_name, sp.sub_product_name from tbl_product_scheme as spsm left join logi_product as psf on (spsm.scheme_on_product = psf.id) left join sub_product as spsf on (spsf.id = spsm.scheme_on_subproduct) left join logi_user as d on (d.id = spsm.distributor) left join logi_product as p on (p.id = spsm.offered_product) left join sub_product as sp on (sp.id = spsm.offered_subproduct) left join tbl_route as r on (r.id = spsm.route) order by spsm.id desc";
  $result  =  $this->db->fetchAll($sql_prduct_scheme_mapping);
  $this->view->result = $result;

  if($this->getRequest()->isPost()){

    // echo '<pre>';
    // print_r($params);
    // exit();

    $data = array();                    
    $data['type']                        = $params['scheme_for'];
    $data['off_price_percentage']        = $params['percentage_off'];

    $data['scheme_on_product']           = $params['product'];;
    $data['scheme_on_subproduct']        = $params['sub_product'];      
    $data['date_from']                   = $params['date_from'];
    $data['date_to']                     = $params['date_to'];
    $data['buy_qty']                     = $params['caret'];
    $data['get_free_qty']                = $params['offered_pouch'];
    $data['offered_product']             = $params['on_product'];
    $data['offered_subproduct']          = $params['on_sub_product'];

    $db->insert('tbl_product_scheme', $data);
    $lastid = $db->lastInsertId();
    $this->_flashMessenger->addMessage('Product scheme created successfully!');
    $this->_redirect('scheme/manage-product-scheme');
  }        
}

public function getSubProductListAction(){

  $this->getHelper('Layout')->disableLayout();
  $this->getHelper('ViewRenderer')->setNoRender();
  $this->getResponse()->setHeader('Content-Type', 'application/json');
  $Retailer = new Application_Model_Retailer();      
  $product_id = $this->getRequest()->getParam('product_id');
  $data_list_unformat = $Retailer->getSubProductListByProductId($product_id); 

  $sub_product_list[] = array("value"=>"",'text'=>"--Select Sub Product--");
  foreach($data_list_unformat as $single){
    $sub_product_list[] = array("value"=>$single['id'],"text"=>$single['sub_product_name']);
  }             
  $this->getHelper('Layout')->disableLayout();
  $this->getHelper('ViewRenderer')->setNoRender();
  $this->getResponse()->setHeader('Content-Type', 'application/json');
  echo json_encode(array('options'=>$sub_product_list));
  return;      
}

public function getTownAction(){

  $this->getHelper('Layout')->disableLayout();
  $this->getHelper('ViewRenderer')->setNoRender();
  $this->getResponse()->setHeader('Content-Type', 'application/json');
  $Retailer = new Application_Model_Retailer();      
  $route_id = $this->getRequest()->getParam('route_id');

  $sql_town ="select * from tbl_route_town where route_id = '".$route_id."' order by town_name";
  $data_list_unformat = $this->db->fetchAll($sql_town); 

  $sub_product_list[] = array("value"=>"",'text'=>"--Select Town--");
  foreach($data_list_unformat as $single){
    $sub_product_list[] = array("value"=>$single['id'],"text"=>$single['town_name']);
  }             
  $this->getHelper('Layout')->disableLayout();
  $this->getHelper('ViewRenderer')->setNoRender();
  $this->getResponse()->setHeader('Content-Type', 'application/json');
  echo json_encode(array('options'=>$sub_product_list));
  return;      
}

public function editProductSchemeAction(){

  $this->checklogin();
  $db = $this->db;
  $auth = Zend_Auth::getInstance();
  $authStorage = $auth->getStorage();

  $Retailer = new Application_Model_Retailer();               
  $this->view->params = $params = $this->getRequest()->getParams();;	
  $this->view->AllRETAILERData  = $AllRETAILERData= $Retailer->AllDistributerData(); 
  $this->view->result = $result = $Retailer->GetRetailerDetailByLOginId($params['datacode']);

  if($this->getRequest()->isPost()){

    $data = array();
    $data['StaffName'] =    $params['name'];

    $db->update('logi_user',$data, array('LoginID=?'=>$params['loginID']));

    $this->_redirect('scheme/index');
  }        
} 

public function checklogin(){   
  $auth = Zend_Auth::getInstance(); 
  $errorMessage = ""; 
  /*************** check user identity ************/
  if(!$auth->hasIdentity()){
    $this->_redirect('admin/index');  
  }   
}     
}
