<?php

/***************************************************************
 * Logimetrix Techsolutions Pvt. Ltd.
 * File Name   : ReportsController.php
 * File Description  : ReportsController
 * Created By : Puneet Mishra
 * Created Date: 16 Nov 2016
 ***************************************************************/

class ReportsController extends Zend_Controller_Action{
	var $dbAdapter;
	var $db;
	public function init(){
		/* Initialize action controller here */
		$this->_flashMessenger  = $this->_helper->getHelper('FlashMessenger');
		$bootstrap = $this->getInvokeArg('bootstrap');
		$aConfig = $bootstrap->getOptions();
		$bootstrap                     = $this->getInvokeArg('bootstrap');
		$aConfig                       = $bootstrap->getOptions();
		$this->db                      = Zend_Db_Table::getDefaultAdapter();
		$auth                          = Zend_Auth::getInstance();
		$authStorage                   = $auth->getStorage();
		if(isset($authStorage->read()->LoginID)){
			$this->WebLoginID              = $authStorage->read()->LoginID;
			$users                         = new Application_Model_Users();
			$logout_details                = $users->getUserLoginDetailByWebLoginCode($this->WebLoginID);
			$this->Role                    = $authStorage->read()->Role;
			$this->role                    = $authStorage->read()->Role;
			$this->id                      = $authStorage->read()->id;
			$this->LoginID                 = $authStorage->read()->LoginID;
			$this->parent_regional_manager = $authStorage->read()->parent_regional_manager;
			$this->parent_zonal_manager    = $authStorage->read()->parent_zonal_manager;
			$this->parent_area_manager     = $authStorage->read()->parent_area_manager;
			$this->parent_sale             = $authStorage->read()->parent_sale;
			$this->view->last_login        = $logout_details['login_time'];
		}
	}

	public function allOrderListAction(){
		$this->checklogin();
		$this->db         = Zend_Db_Table::getDefaultAdapter();
		$db               = $this->db;
		$auth             = Zend_Auth::getInstance();
		$authStorage      = $auth->getStorage();
		$this->WebLoginID = $authStorage->read()->LoginID;
		$params           = $this->view->params = $this->getRequest()->getParams();
		$Retailer         = new Application_Model_Retailer();

		$this->view->result = $result = $Retailer->getAllOrderListOfDistributers();

		$page      = $this->_getParam('page', 1);
		$paginator = Zend_Paginator::factory($result);
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(50); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec  = $paginator->getTotalItemCount();
    }
    
    public function retailerTaggingAction(){
    	$this->checklogin();
    	$params                   = $this->view->params = $this->getRequest()->getParams();
    	$Retailer                 = new Application_Model_Retailer();
    	$gmap                     = new Application_Model_Gmap();
    	$this->view->getUserList  = $gmap->getUserList($this->role, $this->id);
    	$this->db                 = Zend_Db_Table::getDefaultAdapter();
    	$this->view->role = $role = $this->role;
    	$id   = $this->id;


    	$date_from = $params['date_from'];
    	$date_to   = $params['date_to'];

    	$sql_state = "select * from state";
    	$this->view->stateList = $stateList      = $this->db->fetchAll($sql_state);

    	$this->view->getRetailerTaggingData      = $result = $Retailer->getRetailerTaggingData($params['state'], $params['sale_person'], $date_from, $date_to, $role, $id);
    	$this->view->getRetailerTaggingCountData = $getRetailerTaggingCountData = $Retailer->getRetailerTaggingCountData($params['state'], $params['sale_person'], $date_from, $date_to, $role, $id);

    	$page      = $this->_getParam('page', 1);
    	$paginator = Zend_Paginator::factory($result);
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(100); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec  = $paginator->getTotalItemCount();
        // print_r($paginator);exit;
        if ($params['tagging'] == 'Generate') {
        	$data = array(
        		array(
        			'Sr. No.' => "",
        			'Retailer Name' => "",
        			'Retailer Mobile No' => "",
        			'Sale Person Name' => "",
        			'Sale Person Login Id' => "",
        			'Sale Person Mobile No' => "",
        			'Tagging Date' => ""
        		)
        	);
        	$i    = 2;
        	foreach ($result as $rs) {


        		$tagging_date = date("d/m/Y h:i:s", strtotime($rs['taging_date']));

        		
        		$row          = array();
        		$row[]        = stripslashes($i - 1);
        		$row[]        = stripslashes($rs["Retailer"]);
        		$row[]        = stripslashes($rs["retailer_mobil_no"]);
        		$row[]        = stripslashes($rs["Sale_person_name"]);
        		$row[]        = stripslashes($rs["sale_login"]);
        		$row[]        = stripslashes($rs["sale_person_mob"]);
        		$row[]        = stripslashes($tagging_date);

        		$data[]       = $row;
        		$i++;
        	}
        	function filterData(&$str){
        		$str = preg_replace("/\t/", "\\t", $str);
        		$str = preg_replace("/\r?\n/", "\\n", $str);
        		if (strstr($str, '"'))
        			$str = '"' . str_replace('"', '""', $str) . '"';
        	}

            // file name for download
        	$fileName = "retailer_tagging_report.xls";

            // headers for download
        	header("Content-Disposition: attachment; filename=\"$fileName\"");
        	header("Content-Type: application/vnd.ms-excel");

        	$flag = false;
        	foreach ($data as $row) {
        		if (!$flag) {
                    // display column names as first row
        			echo implode("\t", array_keys($row)) . "\n";
        			$flag = true;
        		}
                // filter data
        		array_walk($row, 'filterData');
        		echo implode("\t", array_values($row)) . "\n";
        	}
        	exit;
        }
    }


    public function orderListInCurrentDateAction(){

    	$this->checklogin();
    	$this->db         = Zend_Db_Table::getDefaultAdapter();
    	$db               = $this->db;
    	$auth             = Zend_Auth::getInstance();
    	$authStorage      = $auth->getStorage();
    	$this->WebLoginID = $authStorage->read()->LoginID;
    	$params           = $this->view->params = $this->getRequest()->getParams();
    	$Retailer         = new Application_Model_Retailer();
    	if ($params['date'] != '') {
    		$curr_date = @date('Y-m-d', strtotime($params['date']));
    	} else {
    		$curr_date = date("Y-m-d");
    	}

    	$this->view->result = $result = $Retailer->getAllOrderListOfDistributersInCurrentDate($curr_date);

    	$page      = $this->_getParam('page', 1);
    	$paginator = Zend_Paginator::factory($result);
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(10); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec  = $paginator->getTotalItemCount();
    }
    
    public function distributerOrderSummaryInCurrentDateAction(){
    	$this->checklogin();
    	$this->db         = Zend_Db_Table::getDefaultAdapter();
    	$db               = $this->db;
    	$auth             = Zend_Auth::getInstance();
    	$authStorage      = $auth->getStorage();
    	$this->WebLoginID = $authStorage->read()->LoginID;
    	$params           = $this->view->params = $this->getRequest()->getParams();
    	$Retailer         = new Application_Model_Retailer();
    	if ($params['date'] != '') {
    		$curr_date = @date('Y-m-d', strtotime($params['date']));
    	} else {
    		$curr_date = date("Y-m-d");
    	}
    	$getcountOrderByDistributerLoginIdForOwn = $Retailer->getcountOrderByDistributerLoginIdForOwnInCurrentDate($this->WebLoginID, $curr_date);
    	if ($getcountOrderByDistributerLoginIdForOwn['num'] != '0') {
    		$this->view->WebLoginID = $this->WebLoginID;
    		$this->view->result     = $result = $Retailer->getOrderByDistributerLoginIdForOwnInCurrentDate($this->WebLoginID, $curr_date);
    		$page                   = $this->_getParam('page', 1);
    		$paginator              = Zend_Paginator::factory($result);
            $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
            $paginator->setItemCountPerPage(10); // number of items to show per page
            $this->view->paginator = $paginator;
            $this->view->totalrec  = $paginator->getTotalItemCount();
        }
        $this->view->getcountOrderBYDistributerLoginId = $getcountOrderBYDistributerLoginId = $Retailer->getcountOrderBYDistributerLoginId($this->WebLoginID, $curr_date);
        if ($getcountOrderBYDistributerLoginId['num'] != '0') {
        	$this->view->getOrderBYDistributerLoginId = $getOrderBYDistributerLoginId = $Retailer->getOrderBYDistributerLoginId($this->WebLoginID, $curr_date);
        }
        
    }
    
    public function distributerAllOrderSummaryAction(){
    	$this->checklogin();
    	$this->db         = Zend_Db_Table::getDefaultAdapter();
    	$db               = $this->db;
    	$auth             = Zend_Auth::getInstance();
    	$authStorage      = $auth->getStorage();
    	$this->WebLoginID = $authStorage->read()->LoginID;
    	$params           = $this->view->params = $this->getRequest()->getParams();
    	$Retailer         = new Application_Model_Retailer();
    	if ($params['date'] != '') {
    		$curr_date = @date('Y-m-d', strtotime($params['date']));
    	} else {
    		$curr_date = date("Y-m-d");
    	}
    	$getcountOrderByDistributerLoginIdForOwn = $Retailer->getcountOrderByDistributerLoginIdForOwn($this->WebLoginID, $curr_date);
    	if ($getcountOrderByDistributerLoginIdForOwn['num'] != '0') {
    		$this->view->WebLoginID = $this->WebLoginID;
    		$this->view->result     = $result = $Retailer->getOrderByDistributerLoginIdForOwn($this->WebLoginID, $curr_date);
    		$page                   = $this->_getParam('page', 1);
    		$paginator              = Zend_Paginator::factory($result);
            $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
            $paginator->setItemCountPerPage(10); // number of items to show per page
            $this->view->paginator = $paginator;
            $this->view->totalrec  = $paginator->getTotalItemCount();
        }
        $this->view->getcountOrderBYDistributerLoginId = $getcountOrderBYDistributerLoginId = $Retailer->getcountOrderBYDistributerLoginId($this->WebLoginID, $curr_date);
        if ($getcountOrderBYDistributerLoginId['num'] != '0') {
        	$this->view->getOrderBYDistributerLoginId = $getOrderBYDistributerLoginId = $Retailer->getOrderBYDistributerLoginId($this->WebLoginID, $curr_date);
        }
    }
    
    public function attendanceAction(){
    	$this->checklogin();
    	$params                  = $this->view->params = $this->getRequest()->getParams();
    	$Retailer                = new Application_Model_Retailer();
    	$gmap                    = new Application_Model_Gmap();
    	$this->view->getUserList = $gmap->getUserList();
    	$currdatetime            = date("Y-m-d H:i:s", strtotime('+330 minutes'));
    	if ($params['date_from']) {
    		$date_from = $params['date_from'];
    	} else {
    		$date_from = Date('Y-m-d');
    	}
    	
    	$this->view->date_from         = $date_from;
    	$this->view->getAttendanceData = $result = $Retailer->getAttendanceData($params['sale_person'], $date_from);
    	
    	if ($params['report'] == 'Generate') {

    		$data = array(
    			array(
    				'#' => "",
    				'Sale Person Name' => "",
    				'Day Start Time' => "",
    				'Day End Time' => "",
    				'Total Working Hour' => ""
    			)
    		);
    		$i    = 2;
    		foreach ($result as $rs) {

    			$getDayStart = $Retailer->getDayStart($rs['sale_login'], $date_from);
    			$getDayEnd   = $Retailer->getDayEnd($rs['sale_login'], $date_from);
    			
    			if ($getDayEnd) {
    				$end           = $getDayEnd['noti_date'];
    				$End_date_time = $getDayEnd['noti_date'];
    			} else {
    				if (date("Y-m-d") > $date_from) {
    					$End_date_time = date("$date_from 23:59:59");
    					$end           = date("$date_from 23:59:59");
    					;
    				} else if (date("Y-m-d") == $date_from) {
    					$End_date_time = $currdatetime;
    					$end           = 'N/A';
    				} else {

    				}
    			}
    			$dateDiff = intval((strtotime($End_date_time) - strtotime($getDayStart['noti_date'])) / 60);
    			$hours    = intval($dateDiff / 60);
    			$minutes  = $dateDiff % 60;
    			
    			$row   = array();
    			$row[] = stripslashes($i - 1);
    			$row[] = stripslashes($rs['Sale_person_name'] . ' (' . $rs['sale_login'] . ')');
    			$row[] = stripslashes($getDayStart['noti_date']);
    			$row[] = stripslashes($end);
    			$row[] = stripslashes($hours . ". " . $minutes . " hour");
    			
    			$data[] = $row;
    			$i++;
    		}
    		function filterData(&$str)
    		{
    			$str = preg_replace("/\t/", "\\t", $str);
    			$str = preg_replace("/\r?\n/", "\\n", $str);
    			if (strstr($str, '"'))
    				$str = '"' . str_replace('"', '""', $str) . '"';
    		}
            // file name for download
    		$fileName = "Attendance report.xls";
            // headers for download
    		header("Content-Disposition: attachment; filename=\"$fileName\"");
    		header("Content-Type: application/vnd.ms-excel");
    		
    		$flag = false;
    		foreach ($data as $row) {
    			if (!$flag) {
                    // display column names as first row
    				echo implode("\t", array_keys($row)) . "\n";
    				$flag = true;
    			}
                // filter data
    			array_walk($row, 'filterData');
    			echo implode("\t", array_values($row)) . "\n";
    		}
    		exit;
    	}
    }




    public function tripTrackAction(){

    	$curr = date('y-m-d');
    	$sql = "SELECT * from tbl_track_trip where created_at = .$curr.group by user_id";
    	$this->getRequest()->getParams();
    	$getTripTrackQuery = "SELECT tbl_trip_detail.id,(logi_user.StaffName),(tbl_trip_detail.created_at ) AS trip_start_date,CONCAT(tbl_trip_detail.trip_start_latitude,'/',tbl_trip_detail.trip_start_longitude) AS trip_start_location FROM `tbl_trip_detail`
    	LEFT JOIN logi_user ON (tbl_trip_detail.user_id = logi_user.id) WHERE tbl_trip_detail.trip_status = '1'
    	GROUP BY logi_user.StaffName";
    	$this->view->tripStartDetails = $tripStartDetails = $this->db->fetchAll($getTripTrackQuery);
        // echo "<pre>";
        // print_r($tripStartDetails);
        // exit();

    	$getTripTrackDetailsQuery = "SELECT tbl_trip_detail.id,logi_user.StaffName,(tbl_trip_detail.created_at ) AS trip_end_date,CONCAT(tbl_trip_detail.trip_start_latitude,'/',tbl_trip_detail.trip_start_longitude) AS trip_end_location FROM `tbl_trip_detail`
    	LEFT JOIN logi_user ON (tbl_trip_detail.user_id = logi_user.id) WHERE tbl_trip_detail.trip_status = '2'
    	GROUP BY logi_user.StaffName";
    	$this->view->tripEndDetails = $tripEndDetails = $this->db->fetchAll($getTripTrackDetailsQuery);
        // echo "<pre>";
        // print_r($tripEndDetails);
        // exit();
    	$page      = $this->_getParam('page', 1);
    	$paginator = Zend_Paginator::factory($tripStartDetails);
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(30); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec  = $paginator->getTotalItemCount();

    }

    
    public function userAttendanceAction(){
    	$this->checklogin();

    	$this->db                = Zend_Db_Table::getDefaultAdapter();
    	$db                      = $this->db;
    	$id                      = $this->id;
    	$role                    = $this->role;
    	$params                  = $this->view->params = $this->getRequest()->getParams();
    	$Retailer                = new Application_Model_Retailer();
    	$gmap                    = new Application_Model_Gmap();
    	$this->view->getUserList = $gmap->getUserList($this->role, $this->id);
    	$currdatetime            = date("Y-m-d H:i:s", strtotime('+330 minutes'));

    	if ($role == 'super_admin') {
    		$user_cond .= "";
    	}
    	if ($role == 'RM') {
    		$user_cond .= "and a.parent_regional_manager = '" . $id . "' or a.LoginID = '" . $this->LoginID . "'";
    	}
    	if ($role == 'ZM') {
    		$user_cond .= "and a.parent_zonal_manager = '" . $id . "' or a.LoginID = '" . $this->LoginID . "'";
    	}
    	if ($role == 'ASM') {
    		$user_cond .= "and a.parent_area_manager = '" . $id . "' or a.LoginID = '" . $this->LoginID . "'";
    	}
    	if ($role == 'Sales') {
    		$user_cond .= "and a.parent_sale_person = '" . $id . "' or a.LoginID = '" . $this->LoginID . "'";
    	}
    	if ($params['user']) {
    		$cond .= " and a.LoginID = '" . $params['user'] . "'";
    	}
    	if ($params['date_from'] && $params['date_to']) {
    		$cond .= " and date(a.noti_date) between '" . $params['date_from'] . "'  and '" . $params['date_to'] . "' ";
    	}
    	else {
    		$this->view->curr_date = $cur_date = Date('Y-m-d');
    		$cond .= " and date(a.noti_date) = '" . $cur_date . "'";
    	}
    	$query     = "SELECT lu.app_version, lu.id as staff_id, lu.StaffName as Sale_person_name, lu.LoginID as sale_login, lu.MobileNo as sale_person_mob, a.noti_date, date(a.noti_date) as attendance_date,a.latitude,a.longitude,a.area_name from Attendance as a left join logi_user as lu on (lu.LoginID = a.LoginID)  where 1 $cond $user_cond  group by date(a.noti_date), a.LoginID  order by date(a.noti_date) desc";
    	$result    = $db->fetchAll($query);

    	$page      = $this->_getParam('page', 1);
    	$paginator = Zend_Paginator::factory($result);
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(90); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec  = $paginator->getTotalItemCount();
        
        if ($params['report'] == 'Generate') {
        	$data = array(
        		array(
        			'#' => "",
        			'Sale Person Name' => "",
        			'Area Name' => "",
        			'Latitude' => "",
        			'Longitude' => "",
        			'Day Start Time' => "",
        			'Day End Time' => "",
        			'Total Working Hour' => ""
        		)
        	);
        	$i    = 2;
        	foreach ($result as $rs) {
        		if ($params['date_from'] && $params['date_to']) {
        			$curr_date = $rs['attendance_date'];
        		} else {
        			$curr_date = Date('Y-m-d');
        		}

        		$getDayStart = $Retailer->getDayStart($rs['sale_login'], $curr_date);
        		$getDayEnd   = $Retailer->getDayEnd($rs['sale_login'], $curr_date);
        		
        		if ($getDayEnd) {
        			$end           = $getDayEnd['noti_date'];
        			$End_date_time = $getDayEnd['noti_date'];
        		} else {
        			if (date("Y-m-d") > $curr_date) {
        				$End_date_time = date("$curr_date 23:59:59");
        				$end           = date("$curr_date 23:59:59");
        				;
        			} else if (date("Y-m-d") == $curr_date) {
        				$End_date_time = $currdatetime;
        				$end           = 'N/A';
        			} else {

        			}
        		}
        		$dateDiff = intval((strtotime($End_date_time) - strtotime($getDayStart['noti_date'])) / 60);
        		$hours    = intval($dateDiff / 60);
        		$minutes  = $dateDiff % 60;
        		
        		$start_date = date("d/m/Y H:i:s", strtotime($getDayStart['noti_date']));
        		if ($end != 'N/A') {
        			$end_date = date("d/m/Y H:i:s", strtotime($end));
        		} else {
        			$end_date = $end;
        		}
        		
        		$row    = array();
        		$row[]  = stripslashes($i - 1);
        		$row[]  = stripslashes($rs['Sale_person_name'] . ' (' . $rs['sale_login'] . ')');
        		$row[]  = stripslashes($rs['area_name']);
        		$row[]  = stripslashes($rs['latitude']);
        		$row[]  = stripslashes($rs['longitude']);
        		$row[]  = stripslashes($start_date);
        		$row[]  = stripslashes($end_date);
        		$row[]  = stripslashes($hours . ". " . $minutes . " hour");
        		$data[] = $row;
        		$i++;
        	}
        	function filterData(&$str){
        		$str = preg_replace("/\t/", "\\t", $str);
        		$str = preg_replace("/\r?\n/", "\\n", $str);
        		if (strstr($str, '"'))
        			$str = '"' . str_replace('"', '""', $str) . '"';
        	}
            // file name for download
        	$fileName = "Attendance report.xls";
            // headers for download
        	header("Content-Disposition: attachment; filename=\"$fileName\"");
        	header("Content-Type: application/vnd.ms-excel");
        	
        	$flag = false;
        	foreach ($data as $row) {
        		if (!$flag) {
                    // display column names as first row
        			echo implode("\t", array_keys($row)) . "\n";
        			$flag = true;
        		}
                // filter data
        		array_walk($row, 'filterData');
        		echo implode("\t", array_values($row)) . "\n";
        	}
        	exit;
        }
    }
    public function bmcAttendanceAction(){
    	$this->checklogin();
    	$this->db                = Zend_Db_Table::getDefaultAdapter();
    	$db                      = $this->db;
    	$id                      = $this->id;
    	$role                    = $this->role;
    	$params                  = $this->view->params = $this->getRequest()->getParams();
    	$Retailer                = new Application_Model_Retailer();
    	$gmap                    = new Application_Model_Gmap();
    	$query = "SELECT id, LoginID, StaffName from logi_user where Role in ('FSV') $cond order by StaffName"; 
    	$this->view->getUserList =  $getUserList = $db->fetchAll($query);
    	$currdatetime            = date("Y-m-d H:i:s", strtotime('+330 minutes'));

    	if ($role == 'super_admin') {
    		$user_cond .= "";
    	}

    	if ($role == 'RM') {
    		$user_cond .= "and a.parent_regional_manager = '" . $id . "' or a.LoginID = '" . $this->LoginID . "'";
    	}

    	if ($role == 'ZM') {
    		$user_cond .= "and a.parent_zonal_manager = '" . $id . "' or a.LoginID = '" . $this->LoginID . "'";
    	}

    	if ($role == 'ASM') {
    		$user_cond .= "and a.parent_area_manager = '" . $id . "' or a.LoginID = '" . $this->LoginID . "'";
    	}

    	if ($role == 'Sales') {
    		$user_cond .= "and a.parent_sale_person = '" . $id . "' or a.LoginID = '" . $this->LoginID . "'";
    	}

    	if ($params['user']) {
    		$cond .= " and a.LoginID = '" . $params['user'] . "'";
    	}
    	if ($params['date_from'] && $params['date_to']) {
    		$cond .= " and date(a.noti_date) between '" . $params['date_from'] . "'  and '" . $params['date_to'] . "' ";
    	} else {
    		$this->view->curr_date = $cur_date = Date('Y-m-d');
    		$cond .= " and date(a.noti_date) = '" . $cur_date . "'";
    	}

    	$query     = "SELECT a.bmc_name, lu.id as staff_id, lu.StaffName as Sale_person_name, lu.LoginID as sale_login, lu.MobileNo as sale_person_mob, a.noti_date, date(a.noti_date) as attendance_date,a.bmc_latitude,a.bmc_longitude,a.bmc_name from tbl_bmc_attendance as a left join logi_user as lu on (lu.LoginID = a.LoginID)  where 1 $cond $user_cond  group by date(a.noti_date), a.LoginID, a.bmc_name  order by date(a.noti_date) desc";
    	$result    = $db->fetchAll($query);
        // $this->view->getAttendanceData = $result; 
        // print_r($result);
        // exit;
    	$page      = $this->_getParam('page', 1);
    	$paginator = Zend_Paginator::factory($result);
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(30); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec  = $paginator->getTotalItemCount();
        
        if ($params['report'] == 'Generate') {
        	$data = array(
        		array(
        			'#' => "",
        			'Sale Person Name' => "",
        			'BMC Name' => "",
        			'BMC Latitude' => "",
        			'BMC Longitude' => "",

        			'Day Start Time' => "",
        			'Day End Time' => ""
        		)
        	);
        	$i    = 2;
        	foreach ($result as $rs) {
        		if ($params['date_from'] && $params['date_to']) {
        			$curr_date = $rs['attendance_date'];
        		} else {
        			$curr_date = Date('Y-m-d');
        		}

        		$getDayStarts = $Retailer->getDayStarts($rs['sale_login'], $curr_date);
        		$getDayEnds   = $Retailer->getDayEnds($rs['sale_login'], $curr_date);

        		if ($getDayEnds) {
        			$end           = $getDayEnds['noti_date'];
        			$End_date_time = $getDayEnds['noti_date'];
        		} else {
        			if (date("Y-m-d") > $curr_date) {
        				$End_date_time = date("$curr_date 23:59:59");
        				$end           = date("$curr_date 23:59:59");

        			} else if (date("Y-m-d") == $curr_date) {
        				$End_date_time = $currdatetime;
        				$end           = 'N/A';
        			} else {

        			}
        		}
        		$dateDiff = intval((strtotime($End_date_time) - strtotime($getDayStarts['noti_date'])) / 60);
        		$hours    = intval($dateDiff / 60);
        		$minutes  = $dateDiff % 60;

        		$start_date = date("d/m/Y h:i:s", strtotime($getDayStarts['noti_date']));
        		if ($end != 'N/A') {
        			$end_date = date("d/m/Y h:i:s", strtotime($end));
        		} else {
        			$end_date = $end;
        		}

        		$row    = array();
        		$row[]  = stripslashes($i - 1);
        		$row[]  = stripslashes($rs['Sale_person_name'] . ' (' . $rs['sale_login'] . ')');
        		$row[]  = stripslashes($rs['bmc_name']);
        		$row[]  = stripslashes($rs['bmc_latitude']);
        		$row[]  = stripslashes($rs['bmc_longitude']);
        		$row[]  = stripslashes($start_date);
        		$row[]  = stripslashes($end_date);
        		$row[]  = stripslashes($hours . ". " . $minutes . " hour");
        		$data[] = $row;
        		$i++;
        	}
        	function filterData(&$str)
        	{
        		$str = preg_replace("/\t/", "\\t", $str);
        		$str = preg_replace("/\r?\n/", "\\n", $str);
        		if (strstr($str, '"'))
        			$str = '"' . str_replace('"', '""', $str) . '"';
        	}
            // file name for download
        	$fileName = "Attendance report.xls";
            // headers for download
        	header("Content-Disposition: attachment; filename=\"$fileName\"");
        	header("Content-Type: application/vnd.ms-excel");

        	$flag = false;
        	foreach ($data as $row) {
        		if (!$flag) {
                    // display column names as first row
        			echo implode("\t", array_keys($row)) . "\n";
        			$flag = true;
        		}
                // filter data
        		array_walk($row, 'filterData');
        		echo implode("\t", array_values($row)) . "\n";
        	}
        	exit;
        }
    }
    public function bmcAttendanceOnlyAction(){
    	try{
    		$this->checklogin();
    		$this->db                = Zend_Db_Table::getDefaultAdapter();
    		$db                      = $this->db;
    		$id                      = $this->id;
    		$role                    = $this->role;
    		$params                  = $this->view->params = $this->getRequest()->getParams();
    		$Retailer                = new Application_Model_Retailer();
    		$gmap                    = new Application_Model_Gmap();

    		$this->view->getUserList = $gmap->getUserListBmc($this->role, $this->id);
    		$currdatetime            = date("Y-m-d H:i:s", strtotime('+330 minutes'));
    		if ($role == 'super_admin') {
    			$user_cond .= "";
    		}
    		if ($role == 'RM') {
    			$user_cond .= "and a.parent_regional_manager = '" . $id . "' or a.LoginID = '" . $this->LoginID . "'";
    		}
    		if ($role == 'ZM') {
    			$user_cond .= "and a.parent_zonal_manager = '" . $id . "' or a.LoginID = '" . $this->LoginID . "'";
    		}
    		if ($role == 'ASM') {
    			$user_cond .= "and a.parent_area_manager = '" . $id . "' or a.LoginID = '" . $this->LoginID . "'";
    		}
    		if ($role == 'Sales') {
    			$user_cond .= "and a.parent_sale_person = '" . $id . "' or a.LoginID = '" . $this->LoginID . "'";
    		}
    		if ($params['user']) {
    			$cond .= " and a.LoginID = '" . $params['user'] . "'";
    		}
    		if ($params['date_from'] && $params['date_to']) {
    			$cond .= " and date(a.noti_date) between '" . $params['date_from'] . "'  and '" . $params['date_to'] . "' ";
    		}
    		else {
    			$this->view->curr_date = $cur_date = Date('Y-m-d');
    			$cond .= " and date(a.noti_date) = '" . $cur_date . "'";
    		}
    		$query     = " SELECT lu.app_version, lu.id as staff_id, lu.StaffName as Sale_person_name, lu.LoginID as sale_login, lu.MobileNo as sale_person_mob, a.noti_date, date(a.noti_date) as attendance_date,a.latitude,a.longitude from mpd_attendance as a left join logi_user as lu on (lu.LoginID = a.LoginID)  where 1 $cond $user_cond  group by date(a.noti_date), a.LoginID  order by date(a.noti_date) desc "; 
    		$result      = $db->fetchAll($query); 

    		$page      = $this->_getParam('page', 1);
    		$paginator = Zend_Paginator::factory($result);
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(30); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec  = $paginator->getTotalItemCount();
        
        if ($params['report'] == 'Generate') {
        	$data = array(
        		array(
        			'#' => "",
        			'Sale Person Name' => "",
        			'Area Name' => "",
        			'Latitude' => "",
        			'Longitude' => "",
        			'Day Start Time' => "",
        			'Day End Time' => "",
        			'Total Working Hour' => ""
        		)
        	);
        	$i    = 2;
        	foreach ($result as $rs) {
        		if ($params['date_from'] && $params['date_to']) {
        			$curr_date = $rs['attendance_date'];
        		} else {
        			$curr_date = Date('Y-m-d');
        		}

        		$getDayStart = $Retailer->getDayStartBmc($rs['sale_login'], $curr_date);
        		$getDayEnd   = $Retailer->getDayEndBmc($rs['sale_login'], $curr_date);

        		if ($getDayEnd) {
        			$end           = $getDayEnd['noti_date'];
        			$End_date_time = $getDayEnd['noti_date'];
        		} else {
        			if (date("Y-m-d") > $curr_date) {
        				$End_date_time = date("$curr_date 23:59:59");
        				$end           = date("$curr_date 23:59:59");
        				;
        			} else if (date("Y-m-d") == $curr_date) {
        				$End_date_time = $currdatetime;
        				$end           = 'N/A';
        			} else {

        			}
        		}
        		$dateDiff = intval((strtotime($End_date_time) - strtotime($getDayStart['noti_date'])) / 60);
        		$hours    = intval($dateDiff / 60);
        		$minutes  = $dateDiff % 60;

        		$start_date = date("d/m/Y h:i:s", strtotime($getDayStart['noti_date']));
        		if ($end != 'N/A') {
        			$end_date = date("d/m/Y h:i:s", strtotime($end));
        		} else {
        			$end_date = $end;
        		}

        		$row    = array();
        		$row[]  = stripslashes($i - 1);
        		$row[]  = stripslashes($rs['Sale_person_name'] . ' (' . $rs['sale_login'] . ')');
        		$row[]  = stripslashes($rs['area_name']);
        		$row[]  = stripslashes($rs['latitude']);
        		$row[]  = stripslashes($rs['longitude']);
        		$row[]  = stripslashes($start_date);
        		$row[]  = stripslashes($end_date);
        		$row[]  = stripslashes($hours . ". " . $minutes . " hour");
        		$data[] = $row;
        		$i++;
        	}
        	function filterData(&$str){
        		$str = preg_replace("/\t/", "\\t", $str);
        		$str = preg_replace("/\r?\n/", "\\n", $str);
        		if (strstr($str, '"'))
        			$str = '"' . str_replace('"', '""', $str) . '"';
        	}
            // file name for download
        	$fileName = "Attendance report.xls";
            // headers for download
        	header("Content-Disposition: attachment; filename=\"$fileName\"");
        	header("Content-Type: application/vnd.ms-excel");

        	$flag = false;
        	foreach ($data as $row) {
        		if (!$flag) {
                    // display column names as first row
        			echo implode("\t", array_keys($row)) . "\n";
        			$flag = true;
        		}
                // filter data
        		array_walk($row, 'filterData');
        		echo implode("\t", array_values($row)) . "\n";
        	}
        	exit;
        }

    }  catch(Exception $e) {
    	echo 'Message: ' .$e->getMessage();
    }
}



public function tabletDescriptionAction(){
	$this->checklogin();
	$params                  = $this->view->params = $this->getRequest()->getParams();
	$Retailer                = new Application_Model_Retailer();
	$gmap                    = new Application_Model_Gmap();
	$this->view->getUserList = $gmap->getUserList();

	if ($params['date_from']) {
		$date_from = $params['date_from'];
	} else {
		$date_from = Date('Y-m-d');
	}

	$this->view->date_from = $date_from;
	$result                = $Retailer->getTabeltReportZoneWise($params['sale_person'], $date_from);

	$page      = $this->_getParam('page', 1);
	$paginator = Zend_Paginator::factory($result);
	$paginator->setCurrentPageNumber($this->getRequest()->getParam('page'));
	$paginator->setItemCountPerPage(10);
	$this->view->paginator = $paginator;
	$this->view->totalrec  = $paginator->getTotalItemCount();
}



public function userTabletDescriptionAction()
{
	$this->checklogin();

	$params                  = $this->view->params = $this->getRequest()->getParams();
	$Retailer                = new Application_Model_Retailer();
	$gmap                    = new Application_Model_Gmap();
	$this->view->getUserList = $gmap->getUserList();
	if ($params['date_from']) {
		$date_from = $params['date_from'];
	} else {
		$date_from = Date('Y-m-d');
	}

	$this->view->date_from = $date_from;
	$result                = $Retailer->getTabeltReportUserAndZoneWise($params['sale_person'], $date_from);

	$page      = $this->_getParam('page', 1);
	$paginator = Zend_Paginator::factory($result);
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(10); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec  = $paginator->getTotalItemCount();
    }
    
    
    public function monthlyReportAction()
    {
    	$this->checklogin();
    	$auth                    = Zend_Auth::getInstance();
    	$authStorage             = $auth->getStorage();
    	$params                  = $this->view->params = $this->getRequest()->getParams();
    	$gmap                    = new Application_Model_Gmap();
    	$this->view->getUserList = $getUserList = $gmap->getUserList();
    	
    	$this->view->totalnum = $params['page'];
    	$Retailer             = new Application_Model_Retailer();
    	$this->view->result   = $result = $Retailer->getMonthlyPsmReport($params['sale_person'], $params['date_from'], $params['date_to']);
    	if ($params['report'] == 'Generate') {

    		$data = array(
    			array(
    				'#' => "",
    				'Date' => "",
    				'Sale Person' => "",
    				'Sale Person Code' => "",
    				'Total Distance Travelled' => "",
    				'New Retailers' => "",
    				'Existing Retailers' => "",
    				'Total PPM Cartes' => "",
    				'Total Dahi Cartes' => "",
    				'Total BM Cartes' => "",
    				'Total GHEE Cartes' => "",
    				'Login Time' => "",
    				'Log Off Time' => "",
    				'Difference in Logoff & Login Time' => "",
    				'No of HRs Tablet On' => ""
    			)
    		);
    		$i    = 2;
    		foreach ($result as $rs) {
    			$row   = array();
    			$row[] = stripslashes($i - 1);
    			$row[] = stripslashes($rs['date']);
    			$row[] = stripslashes($rs['sale_person']);
    			$row[] = stripslashes($rs['LoginID']);
    			$row[] = stripslashes($rs['travelled_distance']);
    			$row[] = stripslashes($rs['new_retailer_tagged']);
    			$row[] = stripslashes($rs['existing_retailer']);
    			$row[] = stripslashes('0');
    			$row[] = stripslashes('0');
    			$row[] = stripslashes('0');
    			$row[] = stripslashes('0');
    			$row[] = stripslashes($rs['login_time']);
    			$row[] = stripslashes($rs['logout_time']);
    			$row[] = stripslashes($rs['hour_diff']);
    			$row[] = stripslashes($rs['tablet_hr_on']);
    			$data[] = $row;
    			$i++;
    		}
    		function filterData(&$str){
    			$str = preg_replace("/\t/", "\\t", $str);
    			$str = preg_replace("/\r?\n/", "\\n", $str);
    			if (strstr($str, '"'))
    				$str = '"' . str_replace('"', '""', $str) . '"';
    		}
    		
            // file name for download
    		$fileName = "Monthly Report.xls";
    		
            // headers for download
    		header("Content-Disposition: attachment; filename=\"$fileName\"");
    		header("Content-Type: application/vnd.ms-excel");
    		
    		$flag = false;
    		foreach ($data as $row) {
    			if (!$flag) {
                    // display column names as first row
    				echo implode("\t", array_keys($row)) . "\n";
    				$flag = true;
    			}
                // filter data
    			array_walk($row, 'filterData');
    			echo implode("\t", array_values($row)) . "\n";
    		}
    		exit;
    	}
    }
    
    public function salePersonMonthlyReportAction(){
    	$this->checklogin();
    	$auth                    = Zend_Auth::getInstance();
    	$authStorage             = $auth->getStorage();
    	$params                  = $this->view->params = $this->getRequest()->getParams();
    	$gmap                    = new Application_Model_Gmap();
    	$this->view->getUserList = $getUserList = $gmap->getUserList();
    	
    	$this->view->totalnum = $params['page'];
    	$Retailer             = new Application_Model_Retailer();
    	$this->view->result   = $result = $Retailer->getSalePersonMonthlyPsmReport($params['sale_person'], $params['date_from'], $params['date_to']);
    	
    	if ($params['report'] == 'Generate') {

    		$data = array(
    			array(
    				'#' => "",
    				'Date' => "",
    				'Sale Person' => "",
    				'Sale Person Code' => "",
    				'Total Distance Travelled' => "",
    				'New Retailers' => "",
    				'Existing Retailers' => "",
    				'No of HRs Tablet On' => ""
    			)
    		);
    		$i    = 2;
    		foreach ($result as $rs) {
    			$row    = array();
    			$row[]  = stripslashes($i - 1);
    			$row[]  = stripslashes($rs['date']);
    			$row[]  = stripslashes($rs['sale_person']);
    			$row[]  = stripslashes($rs['LoginID']);
    			$row[]  = stripslashes($rs['travelled_distance']);
    			$row[]  = stripslashes($rs['new_retailer_tagged']);
    			$row[]  = stripslashes($rs['existing_retailer']);
    			$row[]  = stripslashes($rs['tablet_hr_on']);
    			$data[] = $row;
    			$i++;
    		}
    		function filterData(&$str){
    			$str = preg_replace("/\t/", "\\t", $str);
    			$str = preg_replace("/\r?\n/", "\\n", $str);
    			if (strstr($str, '"'))
    				$str = '"' . str_replace('"', '""', $str) . '"';
    		}
            // file name for download
    		$fileName = "Monthly Day Wise Report.xls";
    		
            // headers for download
    		header("Content-Disposition: attachment; filename=\"$fileName\"");
    		header("Content-Type: application/vnd.ms-excel");
    		
    		$flag = false;
    		foreach ($data as $row) {
    			if (!$flag) {
                    // display column names as first row
    				echo implode("\t", array_keys($row)) . "\n";
    				$flag = true;
    			}
                // filter data
    			array_walk($row, 'filterData');
    			echo implode("\t", array_values($row)) . "\n";
    		}
    		exit;
    	}
    }
    
    
    public function orderReportAction(){
    	$this->checklogin();
    	$auth                 = Zend_Auth::getInstance();
    	$authStorage          = $auth->getStorage();
    	$params               = $this->view->params = $this->getRequest()->getParams();
    	$this->view->totalnum = $params['page'];
    	
    	$id   = $this->id;
    	$role = $this->role;
    	
    	if ($role == 'super_admin') {
    		$user_cond .= "";
    	}
    	if ($role == 'RM') {
    		$user_cond .= "and o.parent_regional_manager = '" . $id . "' ";
    	}
    	if ($role == 'ZM') {
    		$user_cond .= "and o.parent_zonal_manager = '" . $id . "' ";
    	}
    	if ($role == 'ASM') {
    		$user_cond .= "and o.parent_area_manager = '" . $id . "' ";
    	}
    	if ($role == 'Sales') {
    		$user_cond .= "and o.sale_person_id = '" . $id . "' ";
    	}
    	if ($params['shift']) {
    		$user_cond .= "and o.shift = '" . $params['shift'] . "'";
    	}
    	if ($params['status']) {
    		$user_cond .= "and o.status = '" . $params['status'] . "'";
    	}
    	if ($params['date_from'] && $params['date_to'] == '') {
    		$user_cond .= "and DATE(o.order_date) = '" . $params['date_from'] . "'";
    	}
    	elseif ($params['date_to'] && $params['date_from'] == '') {
    		$user_cond .= "and DATE(o.order_date) = '" . $params['date_to'] . "'";
    	}
    	elseif ($params['date_from'] && $params['date_to']) {
    		$user_cond .= "and DATE(o.order_date) between '" . $params['date_from'] . "' and '" . $params['date_to'] . "'";
    	}
    	else{
    		$user_cond .= "and DATE(o.order_date) = '" . date('Y-m-d') . "'"; 
    	}

    	$sql_order = "select o.*, created_person_by.StaffName as created_by_person, s.StaffName as sale_person_name, r.StaffName as retailer_name, u.StaffName, u.sap_code, date(o.order_date) as ordered_date, u.id as dis_id from logi_order as o left join  logi_user as u on (o.distributor_id = u.id) left join  logi_user as r on (o.retailer_id = r.id) left join  logi_user as s on (o.sale_person_id = s.id) left join logi_user as created_person_by on (created_person_by.id = o.created_by) where 1 $user_cond  order by o.id desc";
    	$res_order = $this->db->fetchAll($sql_order);

    	$page      = $this->_getParam('page', 1);
    	$paginator = Zend_Paginator::factory($res_order);
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(30); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec  = $paginator->getTotalItemCount();

        if($params['export_type'] == 'Generate'){
        	if ($params['date_from'] && $params['date_to'] == '') {
        		$item_cond .= "and DATE(order_items.created_at) = '" . $params['date_from'] . "'";
        	}
        	elseif ($params['date_to'] && $params['date_from'] == '') {
        		$item_cond .= "and DATE(order_items.created_at) = '" . $params['date_to'] . "'";
        	}
        	elseif ($params['date_from'] && $params['date_to']) {
        		$item_cond .= "and DATE(order_items.created_at) between '" . $params['date_from'] . "' and '" . $params['date_to'] . "'";
        	}
        	else{
        		$item_cond .= "and DATE(order_items.created_at) = '" . date('Y-m-d') . "'"; 
        	}
        	$sql  = "select order_items.*, subproduct.sku, offered_sub_product.sub_product_name as offered_subproduct,  product.product_name, subproduct.sub_product_name from logi_order_item_detail as order_items left join logi_product as product on(order_items.product_id = product.id) LEFT JOIN  sub_product as subproduct ON (subproduct.id = order_items.subproduct_id) left join sub_product as offered_sub_product on (order_items.schemed_subproduct_id  = offered_sub_product.id)   where 1 $item_cond";
        	$result_item = $this->db->fetchAll($sql);

        	$data = array(array('Sr. No.'=> "", 'Order  Number'=> "", 'Ordre Date'=> "", 'Party Account'=> "", 'Executive name'=> "", 'Contact number'=> "", 'Name of Product'=> "", 'Name of Item'=> "", 'Quantity'=> "", 'Rate'=> "", 'UOM'=> "", 'Amount'=> "", 'Remark'=> ""));
        	$i = 2; 

        	foreach ($result_item as $rs) {
        		$sql_orders = "select date(o.order_date) as curr_order_date, o.*, d.StaffName as distributor_name,  created_person_by.StaffName as created_by_person, s.StaffName as sale_person_name,  s.MobileNo as tsi_mobile_no, r.StaffName as retailer_name, u.StaffName, u.sap_code, date(o.order_date) as ordered_date, u.id as dis_id from logi_order as o left join  logi_user as u on (o.distributor_id = u.id) left join  logi_user as r on (o.retailer_id = r.id) left join  logi_user as s on (o.sale_person_id = s.id) left join logi_user as created_person_by on (created_person_by.id = o.created_by)
        		left join  logi_user as d on (o.distributor_id = d.id)
        		where o.id = '".$rs['order_id']."'";  
        		$res_orders = $this->db->fetchRow($sql_orders);

        		$sql_unit= "select u.unit as unit_name from sub_product  as sub left join unit as u on (u.id  = sub.unit) where sub.id = '".$rs['subproduct_id']."'"; 
        		$res_unit = $this->db->fetchRow($sql_unit);

        		$remark = '';
        		$row    = array();
        		$row[]  = stripslashes($i-1);
        		$row[]  = stripslashes($res_orders["code"]);
        		$row[]  = stripslashes($res_orders["curr_order_date"]);
        		$row[]  = stripslashes($res_orders["retailer_name"]);
        		$row[]  = stripslashes($res_orders["sale_person_name"]);
        		$row[]  = stripslashes($res_orders["tsi_mobile_no"]);
        		$row[]  = stripslashes($rs["product_name"]);
        		$row[]  = stripslashes($rs["sub_product_name"]);
        		$row[]  = stripslashes($rs["qty"]);
        		$row[]  = stripslashes($rs["rate"]);
        		$row[]  = stripslashes($res_unit["unit_name"]);
        		$row[]  = stripslashes($rs["amount"]);
        		$row[]  = stripslashes($res_orders["remark"]);
        		$data[] = $row;
        		$i++;
        	}

        	function filterData(&$str){
        		$str = preg_replace("/\t/", "\\t", $str);
        		$str = preg_replace("/\r?\n/", "\\n", $str);
        		if(strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
        	}
                // file name for download
        	$fileName = "order_report.xls"; 
                // headers for download
        	header("Content-Disposition: attachment; filename=\"$fileName\"");
        	header("Content-Type: application/vnd.ms-excel");

        	$flag = false;
        	foreach($data as $row) {
        		if(!$flag) {
                        // display column names as first row
        			echo implode("\t", array_keys($row));
        			$flag = true;
        		}
                    // filter data
        		array_walk($row, 'filterData');
        		echo implode("\t", array_values($row)) . "\n";
        	}
        	exit;
        }
    }


    public function orderDeliveredAction(){
    	try{
    		$db = $this->db = Zend_Db_Table::getDefaultAdapter();
    		$params = $this->getRequest()->getParams(); 
    		$updateDataArray = array();
    		$updateDataArray['status'] = 1;
    		$db->update('logi_order', $updateDataArray, array('id=?'=>$params['id']));
    	}catch(Exception $e){
    		echo $e->getMessage();exit;
    	}
    	$this->view->successMessage = "Delivered successfully.";               
    	$this->_redirect('/reports/order-report');
    	exit();
    }

    public function orderPendingAction(){
    	$db = $this->db = Zend_Db_Table::getDefaultAdapter();
    	$params =$this->getRequest()->getParams();
    	$updateDataArray = array();
    	$updateDataArray['status'] = 2;
    	$db->update('logi_order',$updateDataArray,array('id=?'=>$params['id']));

    	$this->view->successMessage = "Pending successfully.";               
    	$this->_redirect('/reports/order-report');
    	exit();
    }

    public function venSaleDescriptionAction()
    {
    	$this->checklogin();
    	$auth                 = Zend_Auth::getInstance();
    	$authStorage          = $auth->getStorage();
    	$params               = $this->view->params = $this->getRequest()->getParams();
    	$this->view->totalnum = $params['page'];

    	$id   = $this->id;
    	$role = $this->role;

    	if ($role == 'super_admin') {
    		$user_cond .= "";
    	}

    	if ($role == 'RM') {
    		$user_cond .= "and o.parent_regional_manager = '" . $id . "' ";
    	}

    	if ($role == 'ZM') {
    		$user_cond .= "and o.parent_zonal_manager = '" . $id . "' ";
    	}

    	if ($role == 'ASM') {
    		$user_cond .= "and o.parent_area_manager = '" . $id . "' ";
    	}

    	if ($role == 'Sales') {
    		$user_cond .= "and o.parent_sale_person = '" . $id . "' ";
    	}

    	$sql_order = "select o.*, s.StaffName as sale_person_name, r.StaffName as retailer_name, u.StaffName, u.sap_code from tbl_ven_sale_description as o left join  logi_user as u on (o.distributor_id = u.id) left join  logi_user as r on (o.retailer_id = r.id) left join  logi_user as s on (o.parent_sale_person = s.id) where 1 $user_cond  order by o.id desc";
    	$res_order = $this->db->fetchAll($sql_order);

    	$page      = $this->_getParam('page', 1);
    	$paginator = Zend_Paginator::factory($res_order);
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(30); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec  = $paginator->getTotalItemCount();
    }
    
    public function viewVenSaleDescriptionAction()
    {
    	$this->checklogin();
    	$layout = $this->_helper->layout();
    	$layout->disableLayout('');
    	$params = $this->view->params = $this->getRequest()->getParams();
    	
    	$sql                = "select order_items.*,  product.product_name, subproduct.sub_product_name from tbl_ven_sale_item_detail as order_items left join logi_product as product on(order_items.product_id = product.id) LEFT JOIN  sub_product as subproduct ON (subproduct.id = order_items.sub_product_id) where order_items.description_id = '" . $params['id'] . "'";
    	$this->view->result = $result = $this->db->fetchAll($sql);
    }
    
    public function vanSalesMonthlyReportAction()
    {
    	try{

        // $this->getRequest()->getParams();
    		$params                 = $this->view->params = $this->getRequest()->getParams(); 

    		if ($params['month']) {
    			$this->view->month = $month = $params['month'];
    		}else{
    			$this->view->month = $month = date('m');
    		}
    		if($params['year']){
    			$this->view->year = $year = $params['year'];
    		}else{
    			$this->view->year = $year = date('Y');
    		}
    		$this->view->working_days = cal_days_in_month(CAL_GREGORIAN, $month, $year);
    		$where="";
    		$where.=" and MONTH(order_date) =".$month;
    		$final_array = array();                         

    		$getVenSalesMonthlyDetail = "SELECT tbl_ven_sale_description.parent_sale_person,logi_user.StaffName,tbl_ven_sale_description.order_date FROM `tbl_ven_sale_description`
    		LEFT JOIN logi_user ON (tbl_ven_sale_description.parent_sale_person = logi_user.id) 
    		WHERE 1 $where
    		GROUP by tbl_ven_sale_description.parent_sale_person";
    		$result = $this->db->fetchAll($getVenSalesMonthlyDetail);

    		foreach($result as $data){
    			$sql_van_sal = "
    			select tbl_ven_sale_item_detail.product_id, tbl_ven_sale_item_detail.sub_product_id,logi_product.product_name,sub_product.sub_product_name from tbl_ven_sale_item_detail 
    			LEFT join logi_product ON(logi_product.id = tbl_ven_sale_item_detail.product_id)
    			LEFT JOIN sub_product ON (sub_product.id =  tbl_ven_sale_item_detail.sub_product_id)
    			where MONTH(tbl_ven_sale_item_detail.created_at) = ".$month." AND tbl_ven_sale_item_detail.parent_sale_person = '".$data['parent_sale_person']."' group by tbl_ven_sale_item_detail.product_id, tbl_ven_sale_item_detail.sub_product_id";


    			$result_ven_data = $this->db->fetchAll($sql_van_sal);
          // print_r($result_ven_data);
          // exit();
    			if($result_ven_data){
    				foreach($result_ven_data as $van_data){
    					$sql_product = "select sum(qty) as quantity, (sum(qty)*sum(rate)) as amount from tbl_ven_sale_item_detail where MONTH(created_at) =".$month." and parent_sale_person = '".$data['parent_sale_person']."'  and product_id = '".$van_data['product_id']."' and sub_product_id = '".$van_data['sub_product_id']."'";
    					$result_product = $this->db->fetchRow($sql_product);
    					$detail= array(
    						'sale_person'=>$data['StaffName'],
    						'product'=>$van_data['product_name'],
    						'sub_product'=>$van_data['sub_product_name'],
    						'qty'=>$result_product['quantity'],
    						'amount'=>$result_product['amount']
    					);
    					array_push($final_array,$detail);
    					$this->view->final_array = $final_array;

    				}
    			}
    		}

    		$page      = $this->_getParam('page', 1);
    		$paginator = Zend_Paginator::factory($final_array);
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(30); // number of items to show per page
        $this->view->paginator = $paginator;

        $this->view->totalrec  = $paginator->getTotalItemCount();
        // echo"<pre>";
        // print_r($final_array);


    }catch(Exception $e){
    	echo $e->getMessage();exit;
        }        // exit();

    }
    public function surveyAction()
    {
    	$this->checklogin();
    	$params = $this->view->params = $this->getRequest()->getParams();
    	
    	$sql_user                = "select * from logi_user where Role = 'Survey'";
    	$result_user             = $this->db->fetchAll($sql_user);
    	$this->view->getUserList = $result_user;
    	
    	$sql_survey_type              = "select * from tbl_survey_type where status = '0'";
    	$result_survey_type           = $this->db->fetchAll($sql_survey_type);
    	$this->view->survey_type_list = $result_survey_type;
    	
    	if ($params['survey_type'] == '') {
    		$cond .= " and survey.survey_type = '1'";
    	}
    	
    	if ($params['survey_type']) {
    		$cond .= " and survey.survey_type = '" . $params['survey_type'] . "'";
    	}
    	
    	if ($params['user']) {
    		$cond .= " and survey.user_id = '" . $params['user'] . "'";
    	}
    	
    	if ($params['date_from'] && !$params['date_from']) {
    		$cond .= " and survey.survey_date = '" . $params['date_from'] . "'";
    	}
    	
    	if (!$params['date_from'] && $params['date_to']) {
    		$cond .= " and survey.survey_date = '" . $params['date_to'] . "'";
    	}
    	
    	if ($params['date_from'] && $params['date_to']) {
    		$cond .= " and survey.survey_date between  '" . $params['date_from'] . "' and '" . $params['date_to'] . "'";
    	}
    	
    	$sql       = "select survey.*, u.StaffName, u.LoginID, st.survey_name as survey_type_name from tbl_survey as survey left join logi_user as u on (u.id = survey.user_id) left join tbl_survey_type as st on (st.id = survey.survey_type) where 1 $cond order by survey.id desc";
    	$result    = $this->db->fetchAll($sql);
        // echo '<pre>';
        // print_r($result);
        // exit();
    	$page      = $this->_getParam('page', 1);
    	$paginator = Zend_Paginator::factory($result);
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(30); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec  = $paginator->getTotalItemCount();
        
        if ($params['report'] == 'Generate') {
            // require_once 'PHPExcel/Classes/PHPExcel.php';
            // $objPHPExcel = new PHPExcel();

        	if ($params['survey_type'] == '1') {
        		$data = array(
        			array(
        				'#' => "",
        				'Survey Type' => "",
        				'Survey Date' => "",
        				'Surveyor Name' => "",
        				'Party Name' => "",
        				'Address' => "",
        				'Contact Name' => "",
        				'Contact No' => "",
        				'Name of Dairy' => "",
        				'Avg. Qty(Lit/Day' => "",
        				'Tentative Reqiremen' => "",
        				'Agree with saahaj' => "",
        				'Sku Wise Qty' => "",
        				'Existing Distributor' => "",
        				'Remark' => "",
        				'Retailer Signature' => ""
        			)
        		);
        	}
        	
        	else if ($params['survey_type'] == '2') {
        		$data = array(
        			array(
        				'#' => "",
        				'Survey Type' => "",
        				'Survey Date' => "",
        				'Surveyor Name' => "",
        				'Name Of Colony' => "",
        				'House No.' => "",
        				'Contact Name' => "",
        				'Contact No' => "",
        				'Milk Type Consumtion' => "",
        				'Sku Type' => "",
        				'Daily Consumption Qty (in Lit)' => "",
        				'Brand Name' => "",
        				'Remark' => "",
        				'Customer Signatur' => ""
        			)
        		);
        	}
        	
        	else if ($params['survey_type'] == '3') {
        		$data = array(
        			array(
        				'#' => "",
        				'Survey Type' => "",
        				'Survey Date' => "",
        				'Surveyor Name' => "",
        				'Name Of Institution' => "",
        				'Address' => "",
        				'Contact Name' => "",
        				'Contact No' => "",
        				'Designation' => "",
        				'Milk Type Consumtion' => "",
        				'Sku Type' => "",
        				'Daily Consumption Qty (in Lit)' => "",
        				'Brand Name' => "",
        				'Competitor Price & Payment Term' => "",
        				'Remark' => "",
        				'Instutution Signature' => ""
        			)
        		);
        	}
        	
        	else if ($params['survey_type'] == '4') {
        		$data = array(
        			array(
        				'#' => "",
        				'Survey Type' => "",
        				'Survey Date' => "",
        				'Surveyor Name' => "",
        				'Party Name' => "",
        				'Address' => "",
        				'Contact Name' => "",
        				'Contact No' => "",
        				'Nature Of Bussiness' => "",
        				'Other Nature Of Bussiness' => "",
        				'Existing Distributor' => "",
        				'Term & Condition' => "",
        				'Party Agreed' => "",
        				'New Party Demond' => "",
        				'New Party Retailer' => "",
        				'Remark' => "",
        				'Distributor Signature' => ""
        			)
        		);
        	}
        	$i = 2;
        	foreach ($result as $rs) {
        		$row   = array();
        		$row[] = stripslashes($i - 1);
        		if ($params['survey_type'] == '1') {
        			$row[] = stripslashes($rs['survey_type_name']);
        			$row[] = stripslashes($rs['survey_date']);
        			$row[] = stripslashes($rs['StaffName']);
        			$row[] = stripslashes($rs['party_name']);
        			$row[] = stripslashes($rs['address']);
        			$row[] = stripslashes($rs['contact_person']);
        			$row[] = stripslashes($rs['contact_number']);
        			$row[] = stripslashes($rs['name_of_dairy']);
        			$row[] = stripslashes($rs['avg_qty']);
        			$row[] = stripslashes($rs['tentative_reqirement']);
        			$row[] = stripslashes($rs['party_agreed']);
        			$row[] = stripslashes($rs['sku_wise_qty']);
        			$row[] = stripslashes($rs['existing_distributor']);
        			$row[] = stripslashes($rs['remark']);
        		} else if ($params['survey_type'] == '2') {
        			$row[] = stripslashes($rs['survey_type_name']);
        			$row[] = stripslashes($rs['survey_date']);
        			$row[] = stripslashes($rs['StaffName']);
        			$row[] = stripslashes($rs['name_of_colony']);
        			$row[] = stripslashes($rs['house_num']);
        			$row[] = stripslashes($rs['contact_person']);
        			$row[] = stripslashes($rs['contact_number']);
        			$row[] = stripslashes($rs['type_milk_consumtion']);
        			$row[] = stripslashes($rs['sku_type']);
        			$row[] = stripslashes($rs['consumption_qty']);
        			$row[] = stripslashes($rs['ppm_sale']);
        			$row[] = stripslashes($rs['remark']);
        		} else if ($params['survey_type'] == '3') {
        			$row[] = stripslashes($rs['survey_type_name']);
        			$row[] = stripslashes($rs['survey_date']);
        			$row[] = stripslashes($rs['StaffName']);
        			$row[] = stripslashes($rs['name_of_institution']);
        			$row[] = stripslashes($rs['address']);
        			$row[] = stripslashes($rs['contact_person']);
        			$row[] = stripslashes($rs['contact_number']);
        			$row[] = stripslashes($rs['designation']);
        			$row[] = stripslashes($rs['type_milk_consumtion']);
        			$row[] = stripslashes($rs['sku_type']);
        			$row[] = stripslashes($rs['consumption_qty']);
        			$row[] = stripslashes($rs['ppm_sale']);
        			$row[] = stripslashes($rs['competitor_price']);
        			$row[] = stripslashes($rs['remark']);
        		} else if ($params['survey_type'] == '4') {
        			$row[] = stripslashes($rs['survey_type_name']);
        			$row[] = stripslashes($rs['survey_date']);
        			$row[] = stripslashes($rs['StaffName']);
        			$row[] = stripslashes($rs['party_name']);
        			$row[] = stripslashes($rs['address']);
        			$row[] = stripslashes($rs['contact_person']);
        			$row[] = stripslashes($rs['contact_number']);
        			$row[] = stripslashes($rs['nature_of_bussiness']);
        			$row[] = stripslashes($rs['nature_of_bussiness_other']);
        			$row[] = stripslashes($rs['existing_distributor']);
        			$row[] = stripslashes($rs['terms_condition']);
        			$row[] = stripslashes($rs['party_agreed']);
        			$row[] = stripslashes($rs['demand_of_new_party']);
        			$row[] = stripslashes($rs['new_party_retailer']);
        			$row[] = stripslashes($rs['remark']);
        		}
        		$data[] = $row;
        		$i++;
        	}
        	function filterData(&$str)
        	{
        		$str = preg_replace("/\t/", "\\t", $str);
        		$str = preg_replace("/\r?\n/", "\\n", $str);
        		if (strstr($str, '"'))
        			$str = '"' . str_replace('"', '""', $str) . '"';
        	}
        	
            // file name for download
        	$fileName = "Survey Report.xls";
            // headers for download
        	header("Content-Disposition: attachment; filename=\"$fileName\"");
        	header("Content-Type: application/vnd.ms-excel");
        	
        	$flag = false;
        	foreach ($data as $row) {
        		if (!$flag) {
                    // display column names as first row
        			echo implode("\t", array_keys($row)) . "\n";
        			$flag = true;
        		}
                // filter data
        		array_walk($row, 'filterData');
        		echo implode("\t", array_values($row)) . "\n";
        	}
        	exit;
        }
    }
    
    
    public function surveyReportAction()
    {
    	$this->checklogin();
    	$params                  = $this->view->params = $this->getRequest()->getParams();
        // echo 'hi';
        // exit();
    	$sql_user                = "select * from logi_user where Role = 'Survey'";
    	$result_user             = $this->db->fetchAll($sql_user);
    	$this->view->getUserList = $result_user;
    	
    	$sql_survey_type              = "select * from tbl_survey_type where status = '0'";
    	$result_survey_type           = $this->db->fetchAll($sql_survey_type);
    	$this->view->survey_type_list = $result_survey_type;
    	
    	if ($params['survey_type'] == '') {
    		$cond .= " and survey.survey_type = '1'";
    	}
    	
    	if ($params['survey_type']) {
    		$cond .= " and survey.survey_type = '" . $params['survey_type'] . "'";
    	}
    	
    	if ($params['user']) {
    		$cond .= " and survey.user_id = '" . $params['user'] . "'";
    	}
    	
    	if ($params['date_from'] && !$params['date_from']) {
    		$cond .= " and survey.survey_date = '" . $params['date_from'] . "'";
    	}
    	
    	if (!$params['date_from'] && $params['date_to']) {
    		$cond .= " and survey.survey_date = '" . $params['date_to'] . "'";
    	}
    	
    	if ($params['date_from'] && $params['date_to']) {
    		$cond .= " and survey.survey_date between  '" . $params['date_from'] . "' and '" . $params['date_to'] . "'";
    	}
    	
    	$sql       = "select survey.*, u.StaffName, u.LoginID, st.survey_name as survey_type_name from tbl_survey as survey left join logi_user as u on (u.id = survey.user_id) left join tbl_survey_type as st on (st.id = survey.survey_type) where 1 $cond order by survey.id desc";
    	$result    = $this->db->fetchAll($sql);
        // echo '<pre>';
        // print_r($result);
        // exit();
    	$page      = $this->_getParam('page', 1);
    	$paginator = Zend_Paginator::factory($result);
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(30); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec  = $paginator->getTotalItemCount();
        
        if ($params['report'] == 'Generate') {
        	require_once 'PHPExcel/Classes/PHPExcel.php';
        	$objPHPExcel = new PHPExcel();
        	$objDrawing  = new PHPExcel_Worksheet_Drawing();
        	$objPHPExcel->getProperties()->setCreator("Puneet Mishra")->setLastModifiedBy("Puneet Mishra")->setTitle("Office 2007 XLSX  Document")->setSubject("Office 2007 XLSX  Document")->setDescription("Document for Office 2007 XLSX, generated using PHP classes.")->setKeywords("office 2007 openxml php")->setCategory("Survey Report");
        	if ($params['survey_type'] == '1') {
        		$objPHPExcel->getActiveSheet()->setCellValue('A1', '#')->setCellValue('B1', 'Survey Type')->setCellValue('C1', 'Survey Date')->setCellValue('D1', 'Surveyor Name')->setCellValue('E1', 'Party Name')->setCellValue('F1', 'Address')->setCellValue('G1', 'Contact Name')->setCellValue('H1', 'Contact No')->setCellValue('I1', 'Name of Dairy')->setCellValue('J1', 'Avg. Qty(Lit/Day)')->setCellValue('K1', 'Tentative Reqiremen')->setCellValue('L1', 'Agree with saahaj')->setCellValue('M1', 'Sku Wise Qty')->setCellValue('N1', 'Existing Distributor')->setCellValue('O1', 'Remark')->setCellValue('P1', 'Retailer Signature');
        	} else if ($params['survey_type'] == '2') {
        		$objPHPExcel->getActiveSheet()->setCellValue('A1', '#')->setCellValue('B1', 'Survey Type')->setCellValue('C1', 'Survey Date')->setCellValue('D1', 'Surveyor Name')->setCellValue('E1', 'Name Of Colony')->setCellValue('F1', 'House No.')->setCellValue('G1', 'Contact Name')->setCellValue('H1', 'Contact No')->setCellValue('I1', 'Milk Type Consumtion')->setCellValue('J1', 'Sku Type')->setCellValue('K1', 'Daily Consumption Qty (in Lit)')->setCellValue('L1', 'Brand Name')->setCellValue('M1', 'Remark')->setCellValue('N1', 'Customer Signatur');
        	} else if ($params['survey_type'] == '3') {
        		$objPHPExcel->getActiveSheet()->setCellValue('A1', '#')->setCellValue('B1', 'Survey Type')->setCellValue('C1', 'Survey Date')->setCellValue('D1', 'Surveyor Name')->setCellValue('E1', 'Name Of Institution')->setCellValue('F1', 'Address')->setCellValue('G1', 'Contact Name')->setCellValue('H1', 'Contact No')->setCellValue('I1', 'Designation')->setCellValue('J1', 'Milk Type Consumtion')->setCellValue('K1', 'Sku Type')->setCellValue('L1', 'Daily Consumption Qty (in Lit)')->setCellValue('M1', 'Brand Name')->setCellValue('N1', 'Competitor Price & Payment Term')->setCellValue('O1', 'Remark')->setCellValue('P1', 'Instutution Signature');
        	} else if ($params['survey_type'] == '4') {
        		$objPHPExcel->getActiveSheet()->setCellValue('A1', '#')->setCellValue('B1', 'Survey Type')->setCellValue('C1', 'Survey Date')->setCellValue('D1', 'Surveyor Name')->setCellValue('E1', 'Party Name')->setCellValue('F1', 'Address')->setCellValue('G1', 'Contact Name')->setCellValue('H1', 'Contact No')->setCellValue('I1', 'Nature Of Bussiness')->setCellValue('J1', 'Other Nature Of Bussiness')->setCellValue('K1', 'Existing Distributor')->setCellValue('L1', 'Term & Condition')->setCellValue('M1', 'Party Agreed')->setCellValue('N1', 'New Party Demond')->setCellValue('O1', 'New Party Retailer')->setCellValue('P1', 'Remark')->setCellValue('Q1', 'Distributor Signature');
        	}
        	$default_border = array(
        		'style' => PHPExcel_Style_Border::BORDER_THIN,
        		'color' => array(
        			'rgb' => '000000'
        		)
        	);
        	$style_header   = array(
        		'fill' => array(
        			'type' => PHPExcel_Style_Fill::FILL_SOLID,
        			'color' => array(
        				'rgb' => '999999'
        			)
        		)
        	);
        	$objPHPExcel->getActiveSheet()->getStyle('A1:U1')->applyFromArray($style_header);
        	$i = 2;
        	foreach ($result as $data) {
        		if ($params['survey_type'] == '1') {
        			$objPHPExcel->setActiveSheetIndex(0)->setCellValue('A' . $i, $i - 1)->setCellValue('B' . $i, $data['survey_type_name'])->setCellValue('C' . $i, $data['survey_date'])->setCellValue('D' . $i, $data['StaffName'])->setCellValue('E' . $i, $data['party_name'])->setCellValue('F' . $i, $data['address'])->setCellValue('G' . $i, $data['contact_person'])->setCellValue('H' . $i, $data['contact_number'])->setCellValue('I' . $i, $data['name_of_dairy'])->setCellValue('J' . $i, $data['avg_qty'])->setCellValue('K' . $i, $data['tentative_reqirement'])->setCellValue('L' . $i, $data['party_agreed'])->setCellValue('M' . $i, $data['sku_wise_qty'])->setCellValue('N' . $i, $data['existing_distributor'])->setCellValue('O' . $i, $data['remark']);
        		} else if ($params['survey_type'] == '2') {
        			$objPHPExcel->setActiveSheetIndex(0)->setCellValue('A' . $i, $i - 1)->setCellValue('B' . $i, $data['survey_type_name'])->setCellValue('C' . $i, $data['survey_date'])->setCellValue('D' . $i, $data['StaffName'])->setCellValue('E' . $i, $data['name_of_colony'])->setCellValue('F' . $i, $data['house_num'])->setCellValue('G' . $i, $data['contact_person'])->setCellValue('H' . $i, $data['contact_number'])->setCellValue('I' . $i, $data['type_milk_consumtion'])->setCellValue('J' . $i, $data['sku_type'])->setCellValue('K' . $i, $data['consumption_qty'])->setCellValue('L' . $i, $data['ppm_sale'])->setCellValue('M' . $i, $data['remark']);
        		} else if ($params['survey_type'] == '3') {
        			$objPHPExcel->setActiveSheetIndex(0)->setCellValue('A' . $i, $i - 1)->setCellValue('B' . $i, $data['survey_type_name'])->setCellValue('C' . $i, $data['survey_date'])->setCellValue('D' . $i, $data['StaffName'])->setCellValue('E' . $i, $data['name_of_institution'])->setCellValue('F' . $i, $data['address'])->setCellValue('G' . $i, $data['contact_person'])->setCellValue('H' . $i, $data['contact_number'])->setCellValue('I' . $i, $data['designation'])->setCellValue('J' . $i, $data['type_milk_consumtion'])->setCellValue('K' . $i, $data['sku_type'])->setCellValue('L' . $i, $data['consumption_qty'])->setCellValue('M' . $i, $data['ppm_sale'])->setCellValue('N' . $i, $data['competitor_price'])->setCellValue('O' . $i, $data['remark']);
        		} else if ($params['survey_type'] == '4') {
        			$objPHPExcel->setActiveSheetIndex(0)->setCellValue('A' . $i, $i - 1)->setCellValue('B' . $i, $data['survey_type_name'])->setCellValue('C' . $i, $data['survey_date'])->setCellValue('D' . $i, $data['StaffName'])->setCellValue('E' . $i, $data['party_name'])->setCellValue('F' . $i, $data['address'])->setCellValue('G' . $i, $data['contact_person'])->setCellValue('H' . $i, $data['contact_number'])->setCellValue('I' . $i, $data['nature_of_bussiness'])->setCellValue('J' . $i, $data['nature_of_bussiness_other'])->setCellValue('K' . $i, $data['existing_distributor'])->setCellValue('L' . $i, $data['terms_condition'])->setCellValue('M' . $i, $data['party_agreed'])->setCellValue('N' . $i, $data['demand_of_new_party'])->setCellValue('O' . $i, $data['new_party_retailer'])->setCellValue('P' . $i, $data['remark']);
        		}
        		try {
        			$objDrawing->setName('Sample image');
        			$objDrawing->setDescription('Sample image');
        			$objDrawing->setImageResource('uploads/survey/1515394164sign.jpg');
        		}
        		catch (Zend_Exception $e) {
        			echo $e->getMessage();
        		}
                // $objDrawing->setRenderingFunction(PHPExcel_Worksheet_MemoryDrawing::RENDERING_JPEG);
                // $objDrawing->setMimeType(PHPExcel_Worksheet_MemoryDrawing::MIMETYPE_DEFAULT);
                // $objDrawing->setHeight(150);
                // if($params['survey_type'] == '1'){
                //     $objDrawing->setCoordinates('P'.$i);
                // }   
                // $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());
        		$i++;
        	}
            // Redirect output to a client’s web browser (Excel2007)
        	header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        	header('Content-Disposition: attachment;filename="SurveyReport.xlsx"');
        	header('Cache-Control: max-age=0');
        	
        	$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        	$objWriter->save('php://output');
        	
        	exit;
        }
    }
    
    public function taskReportAction()
    {

    	$this->checklogin();
    	$this->view->messages = $this->_flashMessenger->getMessages();
    	$params = $this->view->params = $this->getRequest()->getParams();
    	$role   = $this->Role;
    	$id     = $this->id;
    	
    	$gmap                    = new Application_Model_Gmap();
    	$this->view->getUserList = $getUserList = $gmap->getUserList($this->role, $this->id);
    	
    	if ($role == 'super_admin') {
    		$user_cond .= "";
    	}
    	
    	if ($role == 'RM') {
    		$user_cond .= "and t.created_by = '" . $id . "'";
    	}
    	
    	if ($role == 'ZM') {
    		$user_cond .= "and t.created_by = '" . $id . "' ";
    	}
    	
    	if ($role == 'ASM') {
    		$user_cond .= "and t.created_by = '" . $id . "' ";
    	}
    	
    	if ($role == 'Sales') {
    		$user_cond .= "and t.created_by = '" . $id . "' ";
    	}
    	
        // print_r($getUserList);exit;
    	$sql_user                = "select t.*, l.StaffName,l.id,l.LoginID,t32.id as created_id,t32.StaffName as created_staff from tbl_task as t left join logi_user as l on(l.id = t.assign_to) LEFT  JOIN logi_user as t32 ON (t32.id = t.created_by) where 1 $user_cond";
    	$result_user             = $this->db->fetchAll($sql_user);
    	$this->view->result_user = $result_user;
        // echo '<pre>';
        // print_r($params);exit;
    	if ($params['Assign_person'] != '') {
    		$cond .= " and t.assign_to LIKE  '%" . $params['Assign_person'] . "%'";
    	}
    	
    	if ($params['date_from'] && $params['date_to']) {
    		$cond .= " and t.start_date between '" . $params['date_from'] . "' and'" . $params['date_to'] . "'";
    	}
    	
    	$sql         = "select t.*, l.StaffName,l.id,l.LoginID,t32.id as created_id,t32.StaffName as created_staff from tbl_task as t left join logi_user as l on(l.id = t.assign_to) LEFT  JOIN logi_user as t32 ON (t32.id = t.created_by)
    	where 1 $cond $user_cond order by t.id desc";
    	$result_user = $this->db->fetchAll($sql);
    	
    	$page      = $this->_getParam('page', 1);
    	$paginator = Zend_Paginator::factory($result_user);
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(30); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec  = $paginator->getTotalItemCount();
        
        
        if ($params['report'] == 'Generate') {

        	$data = array(
        		array(
        			'#' => "",
        			'Assign To' => "",
        			'Task Id' => "",
        			'Description' => "",
        			'Created By' => "",
                    // 'Approved By'=>"",
        			'Start Date' => "",
        			'Due Date' => "",
        			'Reminder' => "",
        			'Priority' => "",
        			'Status' => ""
        			
        		)
        	);
        	$i    = 2;
        	foreach ($result_user as $rs) {
        		if ($rs['status'] == '0') {
        			$status = 'Pending';
        		} else if ($rs['status'] == '1') {
        			$status = 'Approved';
        		} else if ($rs['status'] == '2') {
        			$status = 'Decline';
        		}
        		
        		
        		if ($rs['created_staff'] != '') {
        			$created_by = $rs['created_staff'];
        		} else {
        			$created_by = 'Admin';
        		}
        		if ($rs['start_date'] != '0000-00-00') {
        			$start_date = date("d/m/Y", strtotime($rs['start_date']));
        		} else {
        			$start_date = '';
        		}
        		if ($rs['due_date'] != '0000-00-00') {
        			$due_date = date("d/m/Y", strtotime($rs['due_date']));
        		} else {
        			$due_date = '';
        		}
        		
        		$row   = array();
        		$row[] = stripslashes($i - 1);
        		$row[] = stripslashes($rs['StaffName']);
        		$row[] = stripslashes($rs['task_id']);
        		$row[] = stripslashes($rs['description']);
        		$row[] = stripslashes($created_by);
                // $row[]  = stripslashes($rs['approved_by']);
        		$row[] = stripslashes($start_date);
        		$row[] = stripslashes($due_date);
        		$row[] = stripslashes($rs['reminder']);
        		$row[] = stripslashes($rs['priority']);
        		$row[] = stripslashes($status);
        		
        		$data[] = $row;
        		$i++;
        	}
        	function filterData(&$str)
        	{
        		$str = preg_replace("/\t/", "\\t", $str);
        		$str = preg_replace("/\r?\n/", "\\n", $str);
        		if (strstr($str, '"'))
        			$str = '"' . str_replace('"', '""', $str) . '"';
        	}
        	
            // file name for download
        	$fileName = "Task Report.xls";
        	
            // headers for download
        	header("Content-Disposition: attachment; filename=\"$fileName\"");
        	header("Content-Type: application/vnd.ms-excel");
        	
        	$flag = false;
        	foreach ($data as $row) {
        		if (!$flag) {
                    // display column names as first row
        			echo implode("\t", array_keys($row)) . "\n";
        			$flag = true;
        		}
                // filter data
        		array_walk($row, 'filterData');
        		echo implode("\t", array_values($row)) . "\n";
        	}
        	exit;
        }
        
    }
    
    
    public function feedbackReportAction()
    {

    	$this->checklogin();
    	$params                  = $this->view->params = $this->getRequest()->getParams();
    	$gmap                    = new Application_Model_Gmap();
    	$this->view->getUserList = $getUserList = $gmap->getUserList($this->role, $this->id);
    	
        // print_r($getUserList);exit;
    	
    	$sql_user                = "select t.*, r.StaffName as retailer, d.StaffName as distributor, l.StaffName,l.id,l.LoginID from tbl_feedback as t left join logi_user as l on(l.id = t.login_id) left join logi_user as r on (r.id = t.retailer_id) left join logi_user as d on (d.id = t.distributor_id)";
    	$result_user             = $this->db->fetchAll($sql_user);
    	$this->view->result_user = $result_user;
    	if ($params['Assign_person'] != '') {
    		$cond .= " and t.login_id LIKE  '%" . $params['Assign_person'] . "%'";
    	}
    	if ($params['date_from'] != '') {
    		$cond .= " and t.created_on LIKE '%" . $params['date_from'] . "%'";
    	}
    	$sql_user    = "select t.*, l.StaffName,l.id,l.LoginID from tbl_feedback as t left join logi_user as l on(l.id = t.login_id) where 1 $cond order by t.id desc";
    	$result_user = $this->db->fetchAll($sql_user);
    	
    	$page      = $this->_getParam('page', 1);
    	$paginator = Zend_Paginator::factory($result_user);
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(30); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec  = $paginator->getTotalItemCount();
        
        if ($params['report'] == 'Generate') {

        	$data = array(
        		array(
        			'#' => "",
        			'User' => "",
        			'Issues' => "",
        			'Remark' => "",
        			'Resolution' => "",
        			'Create On' => ""
        			
        			
        		)
        	);
        	$i    = 2;
        	foreach ($result_user as $rs) {

        		$row   = array();
        		$row[] = stripslashes($i - 1);
        		$row[] = stripslashes($rs['StaffName']);
        		$row[] = stripslashes($rs['issues']);
        		$row[] = stripslashes($rs['remark']);
        		$row[] = stripslashes($rs['resolution']);
        		$row[] = stripslashes($rs['created_on']);
        		
        		$data[] = $row;
        		$i++;
        	}
        	function filterData(&$str){
        		$str = preg_replace("/\t/", "\\t", $str);
        		$str = preg_replace("/\r?\n/", "\\n", $str);
        		if (strstr($str, '"'))
        			$str = '"' . str_replace('"', '""', $str) . '"';
        	}
        	
            // file name for download
        	$fileName = "Task Report.xls";
        	
            // headers for download
        	header("Content-Disposition: attachment; filename=\"$fileName\"");
        	header("Content-Type: application/vnd.ms-excel");
        	
        	$flag = false;
        	foreach ($data as $row) {
        		if (!$flag) {
                    // display column names as first row
        			echo implode("\t", array_keys($row)) . "\n";
        			$flag = true;
        		}
                // filter data
        		array_walk($row, 'filterData');
        		echo implode("\t", array_values($row)) . "\n";
        	}
        	exit;
        }
        
    }
    
    public function reachSiteReportAction(){
    	$this->checklogin();
    	$this->db                = Zend_Db_Table::getDefaultAdapter();
    	$db                      = $this->db;
    	$auth                    = Zend_Auth::getInstance();
    	$authStorage             = $auth->getStorage();
    	$this->WebLoginID        = $authStorage->read()->LoginID;
    	$params                  = $this->view->params = $this->getRequest()->getParams();
    	$gmap                    = new Application_Model_Gmap();
    	$this->view->getUserList = $gmap->getUserList();
    	$users                   = new Application_Model_Users();
    	$this->view->result      = $result = $users->getReachSiteData($params['user'], $params['selected_date'], $this->role, $this->id);
    	$page                    = $this->_getParam('page', 1);
    	$paginator               = Zend_Paginator::factory($result);
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number 
        $paginator->setItemCountPerPage(30); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec  = $paginator->getTotalItemCount();
        
        if ($params['report'] == 'Generate') {
        	$data = array(
        		array(
        			'#' => "",
        			'Sale Person Name' => "",
        			'Retailer Name' => "",
        			'Reach at site date site' => "",
        			'Left site date time' => "",
        			'Total Working Time' => "",
        			'Notification Date' => ""
        		)
        	);
        	$i    = 2;
        	foreach ($result as $rs) {
        		$getReachAtSiteDateTime  = $users->getReachAtSiteDateTime($rs['retailer_id'], $rs['app_user_id'], $rs['notification_date']);
        		$getMoveFromSiteDateTime = $users->getMoveFromSiteDateTime($rs['retailer_id'], $rs['app_user_id'], $rs['notification_date']);
        		
        		$dateDiff = intval((strtotime($getMoveFromSiteDateTime['notification_date_time']) - strtotime($getReachAtSiteDateTime['notification_date_time'])) / 60);
        		$hours    = intval($dateDiff / 60);
        		$minutes  = $dateDiff % 60;
        		
        		if ($getMoveFromSiteDateTime['notification_date_time']) {
        			if ($hours != '0') {
        				$working_hour = $hours . ". " . $minutes . " hour";
        			} else {
        				$working_hour = $minutes . " Min";
        			}
        		}
        		else {
        			$working_hour = "";
        		}
        		
        		$reach_at_site_date_time  = date("d/m/Y h:i:s", strtotime($getReachAtSiteDateTime['notification_date_time']));
        		$move_from_site_date_time = date("d/m/Y h:i:s", strtotime($getMoveFromSiteDateTime['notification_date_time']));
        		$notification_date        = date("d/m/Y", strtotime($rs['notification_date']));
        		
        		$row   = array();
        		$row[] = stripslashes($i - 1);
        		$row[] = stripslashes($rs['sale_person']);
        		$row[] = stripslashes($rs['retailer']);
        		$row[] = stripslashes($reach_at_site_date_time);
        		$row[] = stripslashes($move_from_site_date_time);
        		$row[] = stripslashes($working_hour);
        		$row[] = stripslashes($notification_date);
        		
        		$data[] = $row;
        		$i++;
        	}
        	function filterData(&$str)
        	{
        		$str = preg_replace("/\t/", "\\t", $str);
        		$str = preg_replace("/\r?\n/", "\\n", $str);
        		if (strstr($str, '"'))
        			$str = '"' . str_replace('"', '""', $str) . '"';
        	}
        	$fileName = "Site activity report.xls";
        	header("Content-Disposition: attachment; filename=\"$fileName\"");
        	header("Content-Type: application/vnd.ms-excel");
        	
        	$flag = false;
        	foreach ($data as $row) {
        		if (!$flag) {
        			echo implode("\t", array_keys($row)) . "\n";
        			$flag = true;
        		}
        		array_walk($row, 'filterData');
        		echo implode("\t", array_values($row)) . "\n";
        	}
        	exit;
        }
    }
    
    public function orderViewAction(){
    	$this->checklogin();
    	$layout = $this->_helper->layout();
    	$layout->disableLayout('');
    	$params = $this->view->params = $this->getRequest()->getParams();
    	
    	$sql_order              = "select o.*, s.shift from logi_order as o left join logi_shift as s on (o.shift = s.id) where o.id = '" . $params['id'] . "'";
    	$this->view->result_ord = $result_ord = $this->db->fetchRow($sql_order);
    	
    	$sql                = "select order_items.*, offered_sub_product.sub_product_name as offered_subproduct,  product.product_name, subproduct.sub_product_name from logi_order_item_detail as order_items left join logi_product as product on(order_items.product_id = product.id) LEFT JOIN  sub_product as subproduct ON (subproduct.id = order_items.subproduct_id) left join sub_product as offered_sub_product on (order_items.schemed_subproduct_id  = offered_sub_product.id) where order_items.order_id = '" . $params['id'] . "'";
    	$this->view->result = $result = $this->db->fetchAll($sql);
    	
    	
    	
    	$sql          = "select order_items.*, offered_sub_product.sub_product_name as offered_subproduct,  product.product_name, subproduct.sub_product_name from logi_order_item_detail as order_items 
    	LEFT JOIN logi_product as product on(order_items.product_id = product.id) 
    	LEFT JOIN  sub_product as subproduct ON (subproduct.id = order_items.subproduct_id) 
    	LEFT JOIN sub_product as offered_sub_product on (order_items.schemed_subproduct_id  = offered_sub_product.id) 
    	where order_items.order_id = '" . $params['id'] . "' and (`off_price_percentage` IS NOT NULL OR `off_price` IS NOT NULL OR `offered_qty` IS NOT NULL) ";
    	$offer_result = $this->db->fetchAll($sql);
    	
    	$offer_product = array();
    	foreach ($offer_result as $value) {
    		$query = "select sub.sub_product_name as offered_sub_product from tbl_product_scheme as s
    		LEFT JOIN sub_product as sub on (s.offered_subproduct = sub.id)                     
    		where s.id = '" . $value['scheme_id'] . "'";
    		
    		$offer_results = $this->db->fetchRow($query);
    		
            //  if($offer_results['off_price_percentage']!=0){
    		$offer = array(
    			'id'                              => $value['id'],
    			'product_id'                      => $value['product_id'],
    			'subproduct_id'                   => $value['subproduct_id'],
    			'scheme_id'                       => $value['scheme_id'],
    			'schemed_product_id'              => $value['schemed_product_id'],
    			'schemed_subproduct_id'           => $value['schemed_subproduct_id'],
    			'qty'                             => $value['qty'],
    			'rate'                            => $value['rate'],
    			'amount'                          => $value['amount'],
    			'off_price_percentage'            => $value['off_price_percentage'],
    			'off_price'                       => $value['off_price'],
    			'offered_qty'                     => $value['offered_qty'],
    			'order_id'                        => $value['order_id'],
    			'distributor_id'                  => $value['distributor_id'],
    			'retailer_id'                     => $value['retailer_id'],
    			'parent_regional_manager'         => $value['parent_regional_manager'],
    			'parent_zonal_manager'            => $value['parent_zonal_manager'],
    			'offered_subproduct'              => $value['offered_subproduct'],
    			'product_name'                    => $value['product_name'],
    			'offered_sub_product'             => $offer_results['offered_sub_product']
    		);
    		array_push($offer_product, $offer);
            // }
    		
    	}
    	
    	$this->view->offer_result = $offer_product;
        // echo '<pre>';
        // print_r($offer_product);
        // exit;
    }
    
    
    
    public function retailerGeoLocationAction(){
    	$this->checklogin();
    	$this->db = Zend_Db_Table::getDefaultAdapter();
    	$db       = $this->db;
    	
    	$params = $this->view->params = $this->getRequest()->getParams();
    	
    	$sql_user_location    = "select tsi.StaffName as tsi_name, retailers_site_location.photograph1,  retailers_site_location.photograph2, logi_user.StaffName,logi_user.address,logi_user.MobileNo ,retailers_site_location.lat,retailers_site_location.long from retailers_site_location left join logi_user on retailers_site_location.retailer_id = logi_user.id 
    	left join logi_user as tsi on tsi.id = logi_user.parent_sale where logi_user.Role = 'Retailer' and md5(retailers_site_location.retailer_id) = '" . $params['id'] . "' and logi_user.StaffStatus = 'AC'";
    	$user_location_result = $db->fetchAll($sql_user_location);
    	
    	$user_location_result = array(
    		'tsi_name' => $user_location_result[0]['tsi_name'],
    		'photograph1' => $user_location_result[0]['photograph1'],
    		'photograph2' => $user_location_result[0]['photograph2'],
    		'StaffName' => $user_location_result[0]['StaffName'],
    		'address' => $this->getAddressFromLatLong($user_location_result[0]['lat'], $user_location_result[0]['long']),
    		'MobileNo' => $user_location_result[0]['MobileNo'],
    		'lat' => $user_location_result[0]['lat'],
    		'long' => $user_location_result[0]['long']
    	);
    	$this->view->user_location_result = $user_location_result = $user_location_result;
    }
    public function checkinGeoLocationAction(){
    	$this->checklogin();
    	$this->db                = Zend_Db_Table::getDefaultAdapter();
    	$db                      = $this->db;


    	$params                  = $this->view->params = $this->getRequest()->getParams();




    	$user_location_result = array(

    		'lat' => $params['latitude'],
    		'long' => $params['longitude'],
    		'address' => $this->getAddressFromLatLong($params['latitude'], $params['longitude']),
    		'date_time'=>date("d/m/Y h:i:s", strtotime($params['date_time'])),
    		'user_name'=> $params['user_name'],
    		'login_id'=> $params['login_id'],
    		'activity_type'=>$params['activity_type']   
    	);
    	$this->view->users_location_result = $user_location_result = $user_location_result;



    }


    public function bmcGeoLocationAction(){
    	$this->checklogin();
    	$this->db = Zend_Db_Table::getDefaultAdapter();
    	$db       = $this->db;

    	$params = $this->view->params = $this->getRequest()->getParams();

    	$sql_user_location    = "SELECT bmc.*, user.MobileNo, user.StaffName, user.LoginID from tbl_bmc as bmc left join logi_user as user on (user.id = bmc.fsv_id) where md5(bmc.id) = '".$params['id']."'";
    	$user_location_result = $db->fetchAll($sql_user_location);

    	$user_location_result = array(
    		'bmc_name' => $user_location_result[0]['bmc_name'],
    		'photograph1' => $user_location_result[0]['photograph1'],
    		'photograph2' => $user_location_result[0]['photograph2'],
    		'StaffName' => $user_location_result[0]['StaffName'],
    		'address' => $this->getAddressFromLatLong($user_location_result[0]['lat'], $user_location_result[0]['long']),
    		'MobileNo' => $user_location_result[0]['MobileNo'],
    		'lat' => $user_location_result[0]['lat'],
    		'long' => $user_location_result[0]['long']
    	);
    	$this->view->user_location_result = $user_location_result = $user_location_result;   
    }
    
    function getAddressFromLatLong($latitude, $longitude){
    	$val1 = $latitude;
    	$val2 = $longitude;
    	
    	$url     = "https://maps.googleapis.com/maps/api/geocode/json?latlng=" . $val1 . "," . $val2 . "&sensor=true&key=AIzaSyCHy1BcbxWG5gNfygIGP9DhwqpRUYBgkb0";
    	$json    = @file_get_contents($url);
    	$data    = json_decode($json);
        //print_r($data);exit;
    	$status  = $data->status;
    	$address = '';
    	if ($status == "OK") {
    		$address = $data->results[0]->formatted_address;
    	}
    	if (!empty($address)) {
    		$address = $address;
    		return $address;
    	} else {
    		$address = "Not Found";
    		return $address;
    	}
    	
    }
    
    
    public function stockHistoryAction(){
    	$this->checklogin();
    	$params = $this->view->params = $this->getRequest()->getParams();
    	
    	$Retailer                  = new Application_Model_Retailer();
    	$this->view->getAllProduct = $getAllProduct = $Retailer->getAllProduct();
    	
    	if ($params['product_id']) {
    		$cond .= "and subproduct.product_id = '" . $params['product_id'] . "'";
    	}
    	if ($params['sub_product']) {
    		$cond .= "and  subproduct.sub_product_name like '%" . $params['sub_product'] . "%'";
    	}
    	
    	$sql = "select tsh.*, product.product_name, subproduct.product_image, subproduct.sub_product_name, product.product_name from
    	tbl_stock_history as tsh left join sub_product as subproduct on (subproduct.id = tsh.subproduct_id)  left join logi_product as product on (product.id = subproduct.product_id) where 1  $cond order by id desc ";
    	
    	$result = $this->db->fetchAll($sql);
    	
    	$page      = $this->_getParam('page', 1);
    	$paginator = Zend_Paginator::factory($result);
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(30); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec  = $paginator->getTotalItemCount();
    }
    
    /*  Product Allocation Report 
    Created By : Amit Chaurasiya
    Date : 18-07-2018
    */
    public function productAllocationAction(){
    	$this->checklogin();
    	$db     = Zend_Db_Table::getDefaultAdapter();
    	$params = $this->view->params = $this->getRequest()->getParams();
    	if ($params['allocator']) {
    		$cond .= "and creator.StaffName LIKE '%" . $params['allocator'] . "%'";
    	}
    	if ($params['allocated_date']) {
    		$cond .= "and  date(pa.allocated_date) LIKE '%" . $params['allocated_date'] . "%'";
    	}
    	
    	$product_allocation_query  = " select pa.remark, pa.status, pa.allocated_date, retailer.StaffName as allocated_to, product.product_name, subproduct.sub_product_name, distributor.StaffName as distributor, creator.StaffName as allocated_by FROM tbl_product_allocation as pa 
    	LEFT JOIN sub_product AS subproduct ON (subproduct.id = pa.subproduct_id) 
    	LEFT JOIN logi_product AS product ON (product.id = subproduct.product_id) 
    	LEFT JOIN logi_user AS retailer ON (retailer.id = pa.allocated_to) 
    	LEFT JOIN logi_user AS distributor ON (distributor.id = pa.distributor_id) 
    	LEFT JOIN logi_user AS creator ON (creator.id = pa.created_by) where 1 $cond order by allocated_date DESC";
    	$product_allocation_result = $db->fetchAll($product_allocation_query);
        // print_r($product_allocation_result);exit;
        // $this->view->product = $product_allocation_result;
    	$page                      = $this->_getParam('page', 1);
    	$paginator                 = Zend_Paginator::factory($product_allocation_result);
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(30); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec  = $paginator->getTotalItemCount();
        if ($params['report'] == 'Generate') {

        	$data = array(
        		array(
        			'#' => "",
        			'Allocated By' => "",
        			'Product Name' => "",
        			'Sub Product Name' => "",
        			'Allocated Date' => "",
        			'Remark' => "",
        			'Allocated To' => ""
        		)
        	);
        	$i    = 2;
        	foreach ($product_allocation_result as $rs) {
        		$row    = array();
        		$row[]  = stripslashes($i - 1);
        		$row[]  = stripslashes($rs['allocated_by']);
        		$row[]  = stripslashes($rs['product_name']);
        		$row[]  = stripslashes($rs['sub_product_name']);
        		$row[]  = stripslashes($rs['allocated_date']);
        		$row[]  = stripslashes($rs['remark']);
        		$row[]  = stripslashes($rs['allocated_to']);
        		$data[] = $row;
        		$i++;
        	}
        	function filterData(&$str){
        		$str = preg_replace("/\t/", "\\t", $str);
        		$str = preg_replace("/\r?\n/", "\\n", $str);
        		if (strstr($str, '"'))
        			$str = '"' . str_replace('"', '""', $str) . '"';
        	}
            // file name for download
        	$fileName = "Product_allocation.xls";
            // headers for download
        	header("Content-Disposition: attachment; filename=\"$fileName\"");
        	header("Content-Type: application/vnd.ms-excel");
        	
        	$flag = false;
        	foreach ($data as $row) {
        		if (!$flag) {
                    // display column names as first row
        			echo implode("\t", array_keys($row)) . "\n";
        			$flag = true;
        		}
                // filter data
        		array_walk($row, 'filterData');
        		echo implode("\t", array_values($row)) . "\n";
        	}
        	exit;
        }
    }
    
    
    /*  Product Collection Report 
    Created By : Amit Chaurasiya
    Date : 18-07-2018
    */
    public function collectionAction(){
    	$this->checklogin();
    	$db     = Zend_Db_Table::getDefaultAdapter();
    	$params = $this->view->params = $this->getRequest()->getParams();

    	if ($params['collector']) {
    		$cond .= "and retailer.StaffName LIKE '%" . $params['collector'] . "%'";
    	}
    	if ($params['collection_date']) {
    		$cond .= "and  date(col.collection_date) LIKE '%" . $params['collection_date'] . "%'";
    	}
    	
    	$collection_query  = "select col.*, retailer.StaffName as retailer, distributor.StaffName as distributor, collector.StaffName as collector from tbl_collection as col 
    	LEFT JOIN logi_user AS retailer ON (col.retailer_id = retailer.id) 
    	LEFT JOIN logi_user AS distributor ON (col.distributor_id = distributor.id) 
    	LEFT JOIN logi_user AS collector ON (col.created_by = collector.id) 
    	where 1 $cond order by col.collection_date DESC"; 
    	$collection_result = $db->fetchAll($collection_query);
        // $this->view->collection = $collection_result;
    	$page              = $this->_getParam('page', 1);
    	$paginator         = Zend_Paginator::factory($collection_result);
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(300); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec  = $paginator->getTotalItemCount();
        if ($params['report'] == 'Generate') {
        	$data = array(
        		array(
        			'#' => "",
        			'Retailer' => "",
        			'Distributor' => "",
        			'Payment Mode' => "",
        			'Amount' => "",
        			'Collected By' => "",
        			'Collection Date' => ""
        		)
        	);
        	$i    = 2;
        	foreach ($collection_result as $rs) {
        		$row    = array();
        		$row[]  = stripslashes($i - 1);
        		$row[]  = stripslashes($rs['retailer']);
        		$row[]  = stripslashes($rs['distributor']);
        		$row[]  = stripslashes($rs['payment_mode']);
        		$row[]  = stripslashes($rs['amount']);
        		$row[]  = stripslashes($rs['collector']);
        		$row[]  = stripslashes($rs['collection_date']);
        		$data[] = $row;
        		$i++;
        	}
        	function filterData(&$str){
        		$str = preg_replace("/\t/", "\\t", $str);
        		$str = preg_replace("/\r?\n/", "\\n", $str);
        		if (strstr($str, '"'))
        			$str = '"' . str_replace('"', '""', $str) . '"';
        	}
            // file name for download
        	$fileName = "Collection_report.xls";
            // headers for download
        	header("Content-Disposition: attachment; filename=\"$fileName\"");
        	header("Content-Type: application/vnd.ms-excel");
        	
        	$flag = false;
        	foreach ($data as $row) {
        		if (!$flag) {
                    // display column names as first row
        			echo implode("\t", array_keys($row)) . "\n";
        			$flag = true;
        		}
                // filter data
        		array_walk($row, 'filterData');
        		echo implode("\t", array_values($row)) . "\n";
        	}
        	exit;
        }
    }
    
    
    public function approvedTaskAction(){
        // echo "approvedLeaveAction";exit;
    	$db                 = $this->db = Zend_Db_Table::getDefaultAdapter();
    	$this->view->params = $params = $this->getRequest()->getParams();
        // print_r($params);exit; 
        // if($this->getRequest()->isPost()){
    	$where           = array();
    	$where['status'] = $params['status'];
    	$db->update('tbl_task', $where, array(
    		'id=?' => $params['id']
    	));
    	$this->view->successMessage = "Approved successfully.";
    	$this->_redirect('/reports/task-report');
        // }
    }


    public function getTaskDetailAction(){
    	$this->checklogin();

    	$db                 = $this->db = Zend_Db_Table::getDefaultAdapter();
    	$layout = $this->_helper->layout();
    	$layout->disableLayout('');
    	$this->view->messages = $this->_flashMessenger->getMessages();
    	$params = $this->view->params = $this->getRequest()->getParams();
    	
    	$sql = "select * from tbl_task where task_id = '" . $params['id'] . "'";
    	$this->view->result = $result = $this->db->fetchRow($sql);

    	if ($this->getRequest()->isPost()) {
    		$data             = array();
    		$data['status']   = $params['status'];
    		$data['approver_remark'] = $params['remark'];

    		$db->update('tbl_task', $data, array(
    			'task_id=?' => $params['id']
    		));
    		$this->_flashMessenger->addMessage('Task detail has been updated  successfully.');
    		$this->_redirect('/reports/task-report'); 
    	}   

    }


    public function distanceTravelledAction(){
    	try{
    		$this->checklogin();


    		$db = $this->db = Zend_Db_Table::getDefaultAdapter();
    		$this->view->params = $params = $this->getRequest()->getParams();
    		$auth = Zend_Auth::getInstance();
    		$authStorage = $auth->getStorage();

    		$sale_query = "SELECT * FROM logi_user WHERE Role IN ('Sales', 'TSE','RM', 'ASM', 'ZM')  and StaffStatus = 'AC' ORDER BY StaffName ";
    		$this->view->sale_result = $sale_result = $db->fetchAll($sale_query);
    		$cond = '';
    		if(isset($params['sales']) && $params['sales'] != ""){
    			$cond .= "AND up.userId = '".$params['sales']."'";
    		}

    		if(isset($params['date_from']) && isset($params['date_to']) && $params['date_from'] && $params['date_to']){
    			$cond .=" AND DATE(up.add_date_time) between '".$params['date_from']."' and '".$params['date_to']."' ";

    			$this->view->cur_date = $cur_date = $params['date_from'];
    		}
    		else{
    			$this->view->cur_date = $cur_date = date("Y-m-d");
    			$cond .= "AND DATE(up.add_date_time) = '".$cur_date."'";
    		}

    		$final_array  = array();

    		$query = "SELECT up.*, luSale.id as tsi_id, luSale.StaffName as sales_person FROM user_path AS up 
    		LEFT JOIN logi_user AS luSale ON (up.userId = luSale.id) 
    		WHERE 1 $cond group by  up.userId";

    		$distance_travelled = $db->fetchAll($query);

    		foreach($distance_travelled as $distance_data){
    			$queryLatLong = "SELECT sum(travelled_distance) as dis FROM `user_path` WHERE `mob_user_staff_code` ='".$distance_data['mob_user_staff_code']."' and date(add_date_time) = '".$cur_date."'";
    			$resaltLong = $db->fetchRow($queryLatLong);
    			// $i = 0;
    			// $distance_array = array();
    			// foreach($resaltLong as $latLongData){
    			// 	if($i>1){
    			// 		$i_prev = $i-1;
    			// 		$previous_lat = $resaltLong[$i_prev]['lat'];
    			// 		$previous_long = $resaltLong[$i_prev]['long'];
    			// 		$distance = $this->getCordinateDistances($latLongData['lat'], $latLongData['long'], $previous_lat, $previous_long);
    			// 		array_push($distance_array, $distance);
    			// 	}
    			// 	$i++;
    			// } 

    			$sales_person_array = array('tsi_id'=> $distance_data['tsi_id'], 'add_date_time'=> $cur_date,  'add_date_time'=> $cur_date, 'distance_travlled'=>$resaltLong['dis'], 'sales_person'=>$distance_data['sales_person']);
    			array_push($final_array, $sales_person_array);
    		}
    		$this->view->distance_travelled = $final_array;

    	}catch(Exception $e){
    		echo $e->getMessage();exit;
    	}
    }

    function getCordinateDistances($lat2, $long2, $lat1, $long1) { 
    	$pi80 = M_PI / 180; 
    	$lat1 *= $pi80; 
    	$lon1 *= $pi80; 
    	$lat2 *= $pi80; 
    	$lon2 *= $pi80; 
    	$r = 6372.797; 
    	$dlat = $lat2 - $lat1; 
    	$dlon = $lon2 - $lon1; 
    	$a = sin($dlat / 2) * sin($dlat / 2) + cos($lat1) * cos($lat2) * sin($dlon / 2) * sin($dlon / 2); 
    	$c = 2 * atan2(sqrt($a), sqrt(1 - $a)); 
    	$km = $r * $c;  
    	return $km; 
    }

    public function distanceTravelledVariationAction(){
    	try{
    		$this->checklogin();
    		$db = $this->db = Zend_Db_Table::getDefaultAdapter();
    		$this->view->params = $params = $this->getRequest()->getParams();
    		$auth = Zend_Auth::getInstance();
    		$authStorage = $auth->getStorage();

    		$sale_query = "SELECT * FROM logi_user WHERE Role = 'Sales'  and StaffStatus = 'AC' ORDER BY StaffName ";
    		$this->view->sale_result = $sale_result = $db->fetchAll($sale_query);
    		$cond = '';
    		if(isset($params['sales']) && $params['sales'] != ""){
    			$cond .= "AND up.userId = '".$params['sales']."'";
    		}

    		if(isset($params['date_from']) && isset($params['date_to']) && $params['date_from'] && $params['date_to']){
    			$cond .=" AND DATE(up.add_date_time) between '".$params['date_from']."' and '".$params['date_to']."' ";
    		}
    		else{
    			$this->view->cur_date = $cur_date = date("Y-m-d");
    			$cond .= "AND DATE(up.add_date_time) = '".$cur_date."'";
    		}

    		$query = "SELECT up.add_date_time,sum(up.travelled_distance) as distance_travlled, luSale.id as tsi_id, luSale.StaffName as sales_person FROM user_path AS up 
    		LEFT JOIN logi_user AS luSale ON (up.userId = luSale.id) 
    		WHERE 1 $cond group by Date(up.add_date_time)"; 
    		$this->view->distance_travelled = $distance_travelled = $db->fetchAll($query);

    	}catch(Exception $e){
    		echo $e->getMessage();exit;
    	}
    }
    public function checkRetailerAction(){
    	try{
    		$this->checklogin();
    		$db = $this->db = Zend_Db_Table::getDefaultAdapter();
    		$this->view->params = $params = $this->getRequest()->getParams();
    		if($params['date']){
    			$curr_date = $params['date'];
    		}
    		
    		$query = "SELECT * FROM logi_user WHERE LoginID = '".$params['use_id']."'";
    		$this->view->result = $result = $db->fetchRow($query);
    		$Retailer = "select retailer_check_in_out.*, logi_user.id as users_id,logi_user.StaffName from retailer_check_in_out left join logi_user on  (logi_user.id = retailer_check_in_out.retailer) where  date(retailer_check_in_out.timedate) = '".$curr_date."' AND status ='checkin' and retailer_check_in_out.saleperson = '".$result['id']."'group by  retailer_check_in_out.retailer "  ; 
    		$Retailer = $db->fetchAll($Retailer); 
    		$final_array = array();
    		foreach ($Retailer as $results) {
    			$gRetailer = "select * from retailer_check_in_out where  date(timedate) = '".$curr_date."' AND status ='checkin' and retailer = '".$results['retailer']."'  ORDER BY timedate ASC limit 1"  ; 
    			$Retailercheckin = $db->fetchRow($gRetailer); 

    			$TagRetailer = "select * from retailer_check_in_out where  date(timedate) = '".$curr_date."' AND status ='checkout' and retailer = '".$results['retailer']."'  ORDER BY timedate desc limit 1"  ;
    			$Retailercheckout = $db->fetchRow($TagRetailer);  

    			if(!$Retailercheckout){
    				$check_out_date_time =  date('Y-m-d H:i:s',strtotime('+5 minutes',strtotime($Retailercheckin['timedate'])));

    			}
    			else{
    				$check_out_date_time =  $Retailercheckout['timedate']; 
    			}

    			$check_in_date =  date('Y-m-d',strtotime($Retailercheckin['timedate']));
    			$check_in_time =  date('H:i:s',strtotime($Retailercheckin['timedate']));
    			$check_out_time =  date('H:i:s',strtotime($check_out_date_time));

    			$detail = array('Retailer'=>$results['StaffName'], 'checkin'=>$Retailercheckin['status'],'checkintime'=>$Retailercheckin['timedate'], 'checkout'=>$Retailercheckout['status'],'checkouttime'=>$check_out_date_time, 'saleperson'=>$params['use_id'], 'check_in_time'=>$check_in_time, 'check_out_time'=>$check_out_time, 'check_in_date'=>$check_in_date);
    			array_push($final_array, $detail);
    		}

    		$data = array(
    			array(
    				'Sr. No.' => "",
    				'RetailerName' => "",
    				'Date' => "",
    				'Checkin Time' => "",
    				'Checkout Time' =>"",
    				'saleperson' =>"",
    			)
    		);
    		$i    = 1;
    		foreach ($final_array as $rs) {
    			$row          = array();
    			$row[]        = stripslashes($i);
    			$row[]        = stripslashes($rs['Retailer']);
    			$row[]        = stripslashes($check_in_date);
    			$row[]        = stripslashes($check_in_time);
    			$row[]        = stripslashes($check_out_time);
    			$row[]        = stripslashes($rs["saleperson"]);
    			$data[]       = $row;

    			$i++;


    		}
    		function filterData(&$str){
    			$str = preg_replace("/\t/", "\\t", $str);
    			$str = preg_replace("/\r?\n/", "\\n", $str);
    			if (strstr($str, '"'))
    				$str = '"' . str_replace('"', '""', $str) . '"';
    		}
            // file name for download
    		$fileName = "retailer_report.xls";
            // headers for download
    		header("Content-Disposition: attachment; filename=\"$fileName\"");
    		header("Content-Type: application/vnd.ms-excel");
    		$flag = false;
    		foreach ($data as $row) {
    			if (!$flag) {
                    // display column names as first row
    				echo implode("\t", array_keys($row)) . "\n";
    				$flag = true;
    			}
                // filter data
    			array_walk($row, 'filterData');
    			echo implode("\t", array_values($row)) . "\n";
    		}
    		exit;

    	}catch(Exception $e){
    		echo $e->getMessage();exit;
    	}
    }


    public function bmcTaggingAction(){
    	$this->checklogin();
    	$params                  = $this->view->params = $this->getRequest()->getParams();
    	$Retailer                = new Application_Model_Retailer();
    	$gmap                    = new Application_Model_Gmap();
    	$this->view->getUserList = $Retailer->getFsvUserList($this->role, $this->id);
    	$this->db         = Zend_Db_Table::getDefaultAdapter();
    	$this->view->role = $role = $this->role;
    	$id   = $this->id;

    	$date_from = $params['date_from'];
    	$date_to   = $params['date_to'];

    	$sql_state = "select * from state";
    	$this->view->stateList = $stateList = $this->db->fetchAll($sql_state);

    	$this->view->getBmcTaggingData      = $getBmcTaggingData = $Retailer->getBmcTaggingData($params['state'], $params['sale_person'], $date_from, $date_to, $role, $id);

    	$page      = $this->_getParam('page', 1);
    	$paginator = Zend_Paginator::factory($getBmcTaggingData);
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(10); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec  = $paginator->getTotalItemCount();
        // print_r($paginator);exit;
        if ($params['tagging'] == 'Generate') {
        	$data = array(
        		array(
        			'Sr. No.' => "",
        			'Bmc Name' => "",
        			'User' => "",
        			'Mobile No' => "",
        			'Address' => "",
        			'Latitude' => "",
        			'Longitude' => "",
        			'Tagging Date' => ""
        		)
        	);
        	$i    = 1;
        	foreach ($getBmcTaggingData as $rs) {
        		$address      = $this->getAddressFromLatLong($rs['lat'], $rs['long']);
        		$tagging_date = date("d/m/Y", strtotime($rs['taging_date']));
        		$row          = array();
        		$row[]        = stripslashes($i - 1);
        		$row[]        = stripslashes($rs["bmc_name"]);
        		$row[]        = stripslashes($rs["StaffName"]);
        		$row[]        = stripslashes($rs["MobileNo"]);
        		$row[]        = stripslashes($address);
        		$row[]        = stripslashes($rs["lat"]);
        		$row[]        = stripslashes($rs["long"]);
        		$row[]        = stripslashes($tagging_date);
        		$data[]       = $row;
        		$i++;
        	}
        	function filterData(&$str){
        		$str = preg_replace("/\t/", "\\t", $str);
        		$str = preg_replace("/\r?\n/", "\\n", $str);
        		if (strstr($str, '"'))
        			$str = '"' . str_replace('"', '""', $str) . '"';
        	}
            // file name for download
        	$fileName = "bmc_tagging_report.xls";
            // headers for download
        	header("Content-Disposition: attachment; filename=\"$fileName\"");
        	header("Content-Type: application/vnd.ms-excel");

        	$flag = false;
        	foreach ($data as $row) {
        		if (!$flag) {
                    // display column names as first row
        			echo implode("\t", array_keys($row)) . "\n";
        			$flag = true;
        		}
                // filter data
        		array_walk($row, 'filterData');
        		echo implode("\t", array_values($row)) . "\n";
        	}
        	exit;
        }
    }


    public function attendanceSummarisedReportAction(){
    	$this->checklogin();
    	$db                 = $this->db = Zend_Db_Table::getDefaultAdapter();
    	$this->view->messages = $this->_flashMessenger->getMessages();
    	$params = $this->view->params = $this->getRequest()->getParams();
    	$curr_date = date('Y-m-d');

    	if($parent_id == 4){
    		$table = 'mpd_attendance';
    	}
    	else{
    		$table = 'Attendance';
    	}
    	if($params['date_from']){
    		$cond .="and date(attendance.noti_date) = '".$params['date_from']."'";
    		$curr_date = $params['date_from'];
    	}
    	else{
    		$cond .="and date(attendance.noti_date) = '".$curr_date."'";
    		$curr_date = date('Y-m-d');
    	}        
    	$query = "select user.app_version, user.id, user.StaffName, user.LoginID, attendance.noti_date from $table as attendance  left join logi_user as user on  (user.LoginID = attendance.LoginID) where 1  $cond   group by attendance.LoginID";
    	$result = $db->fetchAll($query);

    	$final_array = array();
    	if($result){
    		foreach($result as $data){
    			$queryFirstDayStart = "select * from $table as attendance  where date(attendance.noti_date) = '".$curr_date."' and attendance.status = 'day_start' and attendance.LoginID = '".$data['LoginID']."' order by attendance.id asc limit 1";
    			$resultFirstDayStart = $db->fetchRow($queryFirstDayStart);

    			$queryDayStartArea = "select * from logi_location  where location_name  LIKE '%".$resultFirstDayStart['area_name']."%'  and status = '1' order by id asc limit 1";
    			$resultDayStartArea = $db->fetchRow($queryDayStartArea);

    			$distance_from_nearest_area_at_day_start = round($this->getCordinateDistance($resultFirstDayStart['latitude'],$resultFirstDayStart['longitude'],$resultDayStartArea['latitude'],$resultDayStartArea['longitude'],2));

    			$queryLastDayEnd = "select * from $table as attendance  where date(attendance.noti_date) = '".$curr_date."' and attendance.status = 'day_close' and attendance.LoginID = '".$data['LoginID']."' order by attendance.id desc limit 1";
    			$resultLastDayEnd = $db->fetchRow($queryLastDayEnd);

    			$queryDayEndArea = "select * from logi_location  where location_name = '".$resultLastDayEnd['area_name']."'  and status = '1' ";
    			$resultDayEndArea = $db->fetchRow($queryDayEndArea);

    			$distance_from_nearest_area_at_day_end = round($this->getCordinateDistance($resultDayEndArea['latitude'],$resultDayEndArea['longitude'],$resultLastDayEnd['latitude'],$resultLastDayEnd['longitude'],2));
    			if($resultLastDayEnd){
    				$End_date_time = $resultLastDayEnd['noti_date'];
    			}
    			else{
    				$End_date_time = date('Y-m-d H:i:s');
    			}

    			$dateDiff          = intval((strtotime($End_date_time)-strtotime($resultFirstDayStart['noti_date']))/60);
    			$hours             = intval($dateDiff/60);
    			$minutes           = $dateDiff%60;
    			$working_hours = $hours.'.'.$minutes.' hours';

    			$user_detail = array('StaffName'=>$data['StaffName'], 'LoginID'=>$data['LoginID'], 'date'=>$curr_date, 'date_start_date_time'=>$resultFirstDayStart['noti_date'], 'day_start_distance'=>$distance_from_nearest_area_at_day_start, 'day_start_area_latitude'=>$resultDayStartArea['latitude'], 'day_start_area_longitude'=>$resultDayStartArea['longitude'], 'day_start_area_longitude'=>$resultDayStartArea['longitude'], 'date_end_date_time'=>$resultLastDayEnd['noti_date'],  'day_end_area_latitude'=>$resultLastDayEnd['latitude'], 'day_end_area_longitude'=>$resultLastDayEnd['longitude'], 'distance_from_nearest_area_at_day_end'=>$distance_from_nearest_area_at_day_end, 'working_hour'=>$working_hours, 'day_start_area_name'=>$resultFirstDayStart['area_name'], 'nearest_day_end_area_name'=>$resultLastDayEnd['area_name'], 'user_id'=>$data['id']);
    			array_push($final_array, $user_detail);
    		}
    		$this->view->final_array = $final_array;
    		if ($params['report'] == 'Generate') {
    			$data = array(
    				array(
    					'Sr. No.' => "",
    					'TSI Name' => "",
    					'App. version' => "",
    					'Date' => "",
    					'First Day Start Time' => "",
    					'Area Name/nearest area' => "",
    					'Distance from nearest area' => "",
    					'Area Location Link' => "",
    					'Last Day End Time' => "",
    					'Nearest Day End Area' => "",
    					'Distance from Nearest Day End Area' => "",
    					'Working Hours' => ""
    				)
    			);
    			$i    = 1;
    			foreach ($final_array as $rs) {
    				$row          = array();
    				$row[]        = stripslashes($i);
    				$row[]        = stripslashes($rs['StaffName'].' ('.$rs['LoginID'].')');
    				$row[]        = stripslashes($rs["app_version"]);
    				$row[]        = stripslashes($rs["date"]);
    				$row[]        = stripslashes($rs["date_start_date_time"]);
    				$row[]        = stripslashes($rs["day_start_area_name"]);
    				$row[]        = stripslashes($rs['day_start_distance'].' k.m.');
    				$row[]        = stripslashes($rs['day_start_area_latitude'].'/'.$rs['day_start_area_longitude']);
    				$row[]        = stripslashes($rs["date_end_date_time"]);
    				$row[]        = stripslashes($rs["nearest_day_end_area_name"]);
    				$row[]        = stripslashes($rs['distance_from_nearest_area_at_day_end'].' k.m.');
    				$row[]        = stripslashes($rs["working_hour"]);
    				$data[]       = $row;
    				$i++;
    			}
    			function filterData(&$str){
    				$str = preg_replace("/\t/", "\\t", $str);
    				$str = preg_replace("/\r?\n/", "\\n", $str);
    				if (strstr($str, '"'))
    					$str = '"' . str_replace('"', '""', $str) . '"';
    			}
            // file name for download
    			$fileName = "attendance_summary_report.xls";
            // headers for download
    			header("Content-Disposition: attachment; filename=\"$fileName\"");
    			header("Content-Type: application/vnd.ms-excel");
    			$flag = false;
    			foreach ($data as $row) {
    				if (!$flag) {
                    // display column names as first row
    					echo implode("\t", array_keys($row)) . "\n";
    					$flag = true;
    				}
                // filter data
    				array_walk($row, 'filterData');
    				echo implode("\t", array_values($row)) . "\n";
    			}
    			exit;
    		}
    	}
    }

    public function attendanceDetailReportAction(){
    	$this->checklogin();
    	$db                 = $this->db = Zend_Db_Table::getDefaultAdapter();
    	$this->view->messages = $this->_flashMessenger->getMessages();
    	$this->view->params = $params   = $this->getRequest()->getParams();


    	if($parent_id == 4){
    		$table = 'mpd_attendance';
    	}
    	else{
    		$table = 'Attendance';
    	}
    	if($params['date_from']){
    		$curr_date = $params['date_from'];
    	}
    	else{
    		$curr_date = date('Y-m-d');
    	}
    	$sql_user_list = "select LoginID, StaffName from logi_user where Role in('Sales', 'ASM')  order by StaffName";
    	$this->view->resUser = $resUser = $db->fetchAll($sql_user_list);

    	$query = "select attendance.attendance_count, user.app_version, user.id, user.StaffName, user.LoginID, attendance.noti_date from $table as attendance  left join logi_user as user on  (user.LoginID = attendance.LoginID) where 1  $cond and attendance.LoginID = '".$params['sales_person']."' and date(attendance.noti_date) = '".$curr_date."'  group by attendance.attendance_count";

    	$result = $db->fetchAll($query);

    	$final_array = array();
    	if($result){
    		foreach($result as $data){
    			$queryFirstDayStart = "select * from $table as attendance  where date(attendance.noti_date) = '".$curr_date."' and attendance.status = 'day_start' and attendance.LoginID = '".$data['LoginID']."'  and attendance.attendance_count = '".$data['attendance_count']."' order by attendance.id asc limit 1";
    			$resultFirstDayStart = $db->fetchRow($queryFirstDayStart);

    			$queryDayStartArea = "select * from logi_location  where location_name = '".$resultFirstDayStart['area_name']."'  and status = '1' ";
    			$resultDayStartArea = $db->fetchRow($queryDayStartArea);

    			$distance_from_nearest_area_at_day_start = round($this->getCordinateDistance($resultFirstDayStart['latitude'],$resultFirstDayStart['longitude'],$resultDayStartArea['latitude'],$resultDayStartArea['longitude'],2));

    			$queryLastDayEnd = "select * from $table as attendance  where date(attendance.noti_date) = '".$curr_date."' and attendance.status = 'day_close' and attendance.LoginID = '".$data['LoginID']."' and attendance.attendance_count = '".$data['attendance_count']."' order by attendance.id desc limit 1";
    			$resultLastDayEnd = $db->fetchRow($queryLastDayEnd);

    			$queryDayEndArea = "select * from logi_location  where location_name = '".$resultLastDayEnd['area_name']."'  and status = '1' ";
    			$resultDayEndArea = $db->fetchRow($queryDayEndArea);

    			$distance_from_nearest_area_at_day_end = round($this->getCordinateDistance($resultDayEndArea['latitude'],$resultDayEndArea['longitude'],$resultLastDayEnd['latitude'],$resultLastDayEnd['longitude'],2));
    			if($resultLastDayEnd){
    				$End_date_time = $resultLastDayEnd['noti_date'];
    			}
    			else{
    				$End_date_time = date('Y-m-d H:i:s');
    			}

    			$dateDiff          = intval((strtotime($End_date_time)-strtotime($resultFirstDayStart['noti_date']))/60);
    			$hours             = intval($dateDiff/60);
    			$minutes           = $dateDiff%60;
    			$working_hours = $hours.'.'.$minutes.' hours';

    			$user_detail = array('StaffName'=>$data['StaffName'], 'LoginID'=>$data['LoginID'], 'date'=>$curr_date, 'date_start_date_time'=>$resultFirstDayStart['noti_date'], 'day_start_distance'=>$distance_from_nearest_area_at_day_start, 'day_start_area_latitude'=>$resultDayStartArea['latitude'], 'day_start_area_longitude'=>$resultDayStartArea['longitude'], 'day_start_area_longitude'=>$resultDayStartArea['longitude'], 'date_end_date_time'=>$resultLastDayEnd['noti_date'],  'day_end_area_latitude'=>$resultLastDayEnd['latitude'], 'day_end_area_longitude'=>$resultLastDayEnd['longitude'], 'distance_from_nearest_area_at_day_end'=>$distance_from_nearest_area_at_day_end, 'working_hour'=>$working_hours, 'day_start_area_name'=>$resultFirstDayStart['area_name'], 'nearest_day_end_area_name'=>$resultLastDayEnd['area_name'], 'user_id'=>$data['id']);
    			array_push($final_array, $user_detail);
    		}

    		$this->view->final_array = $final_array;
    		if ($params['report'] == 'Generate') {
    			$data = array(
    				array(
    					'Sr. No.' => "",
    					'TSI Name' => "",
    					'App. version' => "",
    					'Date' => "",
    					'First Day Start Time' => "",
    					'Area Name/nearest area' => "",
    					'Distance from nearest area' => "",
    					'Area Location Link' => "",
    					'Last Day End Time' => "",
    					'Nearest Day End Area' => "",
    					'Distance from Nearest Day End Area' => "",
    					'Working Hours' => ""
    				)
    			);
    			$i    = 1;
    			foreach ($final_array as $rs) {
    				$row          = array();
    				$row[]        = stripslashes($i);
    				$row[]        = stripslashes($rs['StaffName'].' ('.$rs['LoginID'].')');
    				$row[]        = stripslashes($rs["app_version"]);
    				$row[]        = stripslashes($rs["date"]);
    				$row[]        = stripslashes($rs["date_start_date_time"]);
    				$row[]        = stripslashes($rs["day_start_area_name"]);
    				$row[]        = stripslashes($rs['day_start_distance'].' k.m.');
    				$row[]        = stripslashes($rs['day_start_area_latitude'].'/'.$rs['day_start_area_longitude']);
    				$row[]        = stripslashes($rs["date_end_date_time"]);
    				$row[]        = stripslashes($rs["nearest_day_end_area_name"]);
    				$row[]        = stripslashes($rs['distance_from_nearest_area_at_day_end'].' k.m.');
    				$row[]        = stripslashes($rs["working_hour"]);
    				$data[]       = $row;
    				$i++;
    			}
    			function filterData(&$str){
    				$str = preg_replace("/\t/", "\\t", $str);
    				$str = preg_replace("/\r?\n/", "\\n", $str);
    				if (strstr($str, '"'))
    					$str = '"' . str_replace('"', '""', $str) . '"';
    			}
            // file name for download
    			$fileName = "attendance_detail_report.xls";
            // headers for download
    			header("Content-Disposition: attachment; filename=\"$fileName\"");
    			header("Content-Type: application/vnd.ms-excel");
    			$flag = false;
    			foreach ($data as $row) {
    				if (!$flag) {
                    // display column names as first row
    					echo implode("\t", array_keys($row)) . "\n";
    					$flag = true;
    				}
                // filter data
    				array_walk($row, 'filterData');
    				echo implode("\t", array_values($row)) . "\n";
    			}
    			exit;
    		}
    	}
    }


    public function userActivityReportAction(){
    	$this->checklogin();
    	$db                 = $this->db = Zend_Db_Table::getDefaultAdapter();
    	$this->view->messages = $this->_flashMessenger->getMessages();
    	$params = $this->view->params = $this->getRequest()->getParams();
    	$curr_date = date('Y-m-d');

    	if($parent_id == 4){
    		$table = 'mpd_attendance';
    	}
    	else{
    		$table = 'Attendance';
    	}
    	if($params['date_from']){
    		$cond .="and date(attendance.noti_date) = '".$params['date_from']."'";
    		$curr_date = $params['date_from'];
    	}
    	else{
    		$cond .="and date(attendance.noti_date) = '".$curr_date."'";
    		$curr_date = date('Y-m-d');
    	}        
    	$query = "select date(user.Created) as retailer_added_date, user.id as user_id, user.app_version, user.id, user.StaffName, user.LoginID, attendance.noti_date from $table as attendance  left join logi_user as user on  (user.LoginID = attendance.LoginID) where 1  $cond   group by attendance.LoginID";
    	$result = $db->fetchAll($query);

    	$final_array = array();
    	if($result){
    		foreach($result as $data){
    			$queryFirstDayStart = "select * from $table as attendance  where date(attendance.noti_date) = '".$curr_date."' and attendance.status = 'day_start' and attendance.LoginID = '".$data['LoginID']."' order by attendance.id asc limit 1";
    			$resultFirstDayStart = $db->fetchRow($queryFirstDayStart);

    			$queryDayStartArea = "select * from logi_location  where location_name = '".$resultFirstDayStart['area_name']."'  and status = '1' ";
    			$resultDayStartArea = $db->fetchRow($queryDayStartArea);

    			$distance_from_nearest_area_at_day_start = round($this->getCordinateDistance($resultFirstDayStart['latitude'],$resultFirstDayStart['longitude'],$resultDayStartArea['latitude'],$resultDayStartArea['longitude'],2));

    			$queryLastDayEnd = "select * from $table as attendance  where date(attendance.noti_date) = '".$curr_date."' and attendance.status = 'day_close' and attendance.LoginID = '".$data['LoginID']."' order by attendance.id desc limit 1";
    			$resultLastDayEnd = $db->fetchRow($queryLastDayEnd);

    			$queryDayEndArea = "select * from logi_location  where location_name = '".$resultLastDayEnd['area_name']."'  and status = '1' ";
    			$resultDayEndArea = $db->fetchRow($queryDayEndArea);

    			$distance_from_nearest_area_at_day_end = round($this->getCordinateDistance($resultDayEndArea['latitude'],$resultDayEndArea['longitude'],$resultLastDayEnd['latitude'],$resultLastDayEnd['longitude'],2));
    			$first =   date('Y-m-d',strtotime($resultFirstDayStart['noti_date']));
    			$dat = date('Y-m-d');
    			$expDate =  date_create($first);
    			$todayDate = date_create($dat);
    			$diff =  date_diff($todayDate, $expDate);
    			$ok = $diff->format("%R%a");
    			print_r( $ok);
    			if($resultLastDayEnd){
    				$End_date_time = $resultLastDayEnd['noti_date'];
    			}
    			else if($ok  == '+0'){
    				$End_date_time = date('Y-m-d H:i:s');
    			}
    			else{
    				$first =   date('Y-m-d',strtotime($resultFirstDayStart['noti_date']));
    				$date = new DateTime($first);
    				$date->setTime(23, 59);
    				$End_date_time =  $date->format('Y-m-d H:i:s') . "\n";
    			}

                  // print_r($End_date_time);


    			$dateDiff          = intval((strtotime($End_date_time)-strtotime($resultFirstDayStart['noti_date']))/60);
    			$hours             = intval($dateDiff/60);
    			$minutes           = $dateDiff%60;
    			$working_hours = $hours.'.'.$minutes.' hours';

    			$sqlTagRetailer = "select count(id) as cnt from logi_user where date(Created) = '".$curr_date."' and parent_sale = '".$data['user_id']."'";
    			$resRetCount = $db->fetchRow($sqlTagRetailer);

    			$sqlVisitCount = "SELECT  *, date(timedate) as visit_date from  retailer_check_in_out where date(timedate) = '".$curr_date."' and saleperson = '".$data['user_id']."' and status = 'checkin' group by retailer";
    			$resVisitCount = $db->fetchAll($sqlVisitCount); 

    			$visit = array();
    			if($resVisitCount){
    				foreach($resVisitCount as $vists_cnt){
    					$new_check_sql ="SELECT *, date(timedate) as visit_date from retailer_check_in_out where date(timedate) = '".$curr_date."' and saleperson = '".$vists_cnt['saleperson']."' and retailer='".$vists_cnt['retailer']."' and status = 'checkout' ORDER BY timedate desc limit 1";
    					$checkout_result = $db->fetchRow($new_check_sql);
    					$diff_time=(strtotime($checkout_result['timedate'])-strtotime($vists_cnt['timedate']))/60;
    					if($diff_time >= 3 ){
    						array_push($visit, $vists_cnt['id']);
    					}
    					/*$sqlCheckAddedDate = "select date(Created) as added_date from logi_user where id = '".$vists_cnt['retailer']."'";
    					$resultCheckAddedDate = $db->fetchRow($sqlCheckAddedDate);
    					if($vists_cnt['visit_date'] !=$resultCheckAddedDate['added_date']){
    						array_push($visit, $vists_cnt['id']);
    					}*/
    				}
    			}

    			$user_detail = array('StaffName'=>$data['StaffName'], 'LoginID'=>$data['LoginID'], 'date'=>$curr_date, 'date_start_date_time'=>$resultFirstDayStart['noti_date'], 'day_start_distance'=>$distance_from_nearest_area_at_day_start, 'day_start_area_latitude'=>$resultDayStartArea['latitude'], 'day_start_area_longitude'=>$resultDayStartArea['longitude'], 'day_start_area_longitude'=>$resultDayStartArea['longitude'], 'date_end_date_time'=>$resultLastDayEnd['noti_date'],  'day_end_area_latitude'=>$resultLastDayEnd['latitude'], 'day_end_area_longitude'=>$resultLastDayEnd['longitude'], 'distance_from_nearest_area_at_day_end'=>$distance_from_nearest_area_at_day_end, 'working_hour'=>$working_hours, 'day_start_area_name'=>$resultFirstDayStart['area_name'], 'nearest_day_end_area_name'=>$resultLastDayEnd['area_name'], 'user_id'=>$data['id'], 'retailer_count'=>$resRetCount['cnt'], 'visit_count'=>count($visit));
    			array_push($final_array, $user_detail);

    			$this->view->final_array = $final_array;
    			if ($params['report'] == 'Generate') {
    				$data = array(
    					array(
    						'Sr. No.' => "",
    						'TSI Name' => "",
    						'Date' => "",
    						'First Day Start Time' => "",
    						'Last Day End Time' => "",
    						'Working Hours' => "",
    						'Added retailer count' => "",
    						'Visited retailer count' => "",
    						'Total count' => ""
    					)
    				);
    				$i    = 1;
    				foreach ($final_array as $rs) {
    					$row          = array();
    					$row[]        = stripslashes($i);
    					$row[]        = stripslashes($rs['StaffName'].' ('.$rs['LoginID'].')');
    					$row[]        = stripslashes($rs["date"]);
    					$row[]        = stripslashes($rs["date_start_date_time"]);
    					$row[]        = stripslashes($rs["date_end_date_time"]);
    					$row[]        = stripslashes($rs["working_hour"]);
    					$row[]        = stripslashes($rs["retailer_count"]);
    					$row[]        = stripslashes($rs["visit_count"]);
    					$row[]        = stripslashes($rs["visit_count"] + $rs["retailer_count"]);
    					$data[]       = $row;
    					$i++;
    				}
    				function filterData(&$str){
    					$str = preg_replace("/\t/", "\\t", $str);
    					$str = preg_replace("/\r?\n/", "\\n", $str);
    					if (strstr($str, '"'))
    						$str = '"' . str_replace('"', '""', $str) . '"';
    				}
            // file name for download
    				$fileName = "user_activity_report.xls";
            // headers for download
    				header("Content-Disposition: attachment; filename=\"$fileName\"");
    				header("Content-Type: application/vnd.ms-excel");
    				$flag = false;
    				foreach ($data as $row) {
    					if (!$flag) {
                    // display column names as first row
    						echo implode("\t", array_keys($row)) . "\n";
    						$flag = true;
    					}
                // filter data
    					array_walk($row, 'filterData');
    					echo implode("\t", array_values($row)) . "\n";
    				}
    				exit;
    			}
    		}
    	}
    }


    public function activityDetailReportAction(){
    	$this->checklogin();
    	$db                 = $this->db = Zend_Db_Table::getDefaultAdapter();
    	$this->view->messages = $this->_flashMessenger->getMessages();
    	$this->view->params = $params   = $this->getRequest()->getParams();


    	if($parent_id == 4){
    		$table = 'mpd_attendance';
    	}
    	else{
    		$table = 'Attendance';
    	}
    	if($params['date_from']){
    		$curr_date = $params['date_from'];
    	}
    	else{
    		$curr_date = date('Y-m-d');
    	}
    	$sql_user_list = "select LoginID, StaffName from logi_user where Role in('Sales', 'ASM')  order by StaffName";
    	$this->view->resUser = $resUser = $db->fetchAll($sql_user_list);

    	$query = "select date(user.Created) as retailer_added_date, user.id as user_id, user.app_version, user.id, user.StaffName, user.LoginID, attendance.noti_date from $table as attendance  left join logi_user as user on  (user.LoginID = attendance.LoginID) where  user.Role in('Sales', 'ASM')   $cond   group by attendance.LoginID";
        $result = $db->fetchAll($query);
        // print_r($result); exit;
        $final_array = array();
        if($result){
          foreach($result as $data){
             $queryFirstDayStart = "select * from $table as attendance  where date(attendance.noti_date) = '".$curr_date."' and attendance.status = 'day_start' and attendance.LoginID = '".$data['LoginID']."'  and attendance.attendance_count = '".$data['attendance_count']."' order by attendance.id asc limit 1";
             $resultFirstDayStart = $db->fetchRow($queryFirstDayStart);

             $queryDayStartArea = "select * from logi_location  where location_name = '".$resultFirstDayStart['area_name']."'  and status = '1' ";
             $resultDayStartArea = $db->fetchRow($queryDayStartArea);

             $distance_from_nearest_area_at_day_start = round($this->getCordinateDistance($resultFirstDayStart['latitude'],$resultFirstDayStart['longitude'],$resultDayStartArea['latitude'],$resultDayStartArea['longitude'],2));

             $queryLastDayEnd = "select * from $table as attendance  where date(attendance.noti_date) = '".$curr_date."' and attendance.status = 'day_close' and attendance.LoginID = '".$data['LoginID']."' and attendance.attendance_count = '".$data['attendance_count']."' order by attendance.id desc limit 1";
             $resultLastDayEnd = $db->fetchRow($queryLastDayEnd);

             $queryDayEndArea = "select * from logi_location  where location_name = '".$resultLastDayEnd['area_name']."'  and status = '1' ";
             $resultDayEndArea = $db->fetchRow($queryDayEndArea);


             $sqlTagRetailer = "select count(id) as cnt from logi_user where date(Created) = '".$curr_date."' and parent_sale = '".$data['user_id']."'";
             $resRetCount = $db->fetchRow($sqlTagRetailer);


             $sqlVisitCount = "select count(id) as cnt from tbl_visit_management where date(schedule_date) = '".$curr_date."' and sale_person_id = '".$data['user_id']."'";
             $resVisitCount = $db->fetchRow($sqlVisitCount);


             $distance_from_nearest_area_at_day_end = round($this->getCordinateDistance($resultDayEndArea['latitude'],$resultDayEndArea['longitude'],$resultLastDayEnd['latitude'],$resultLastDayEnd['longitude'],2));
             if($resultLastDayEnd){
                $End_date_time = $resultLastDayEnd['noti_date'];
            }
            else{
                $End_date_time = date('Y-m-d H:i:s');
            }

            $dateDiff          = intval((strtotime($End_date_time)-strtotime($resultFirstDayStart['noti_date']))/60);
            $hours             = intval($dateDiff/60);
            $minutes           = $dateDiff%60;
            $working_hours = $hours.'.'.$minutes.' hours';


            $sqlTagRetailer = "select count(id) as cnt from logi_user where date(Created) = '".$curr_date."' and parent_sale = '".$data['user_id']."'";
            $resRetCount = $db->fetchRow($sqlTagRetailer);


            $sqlVisitCount = "select count(id) as cnt from tbl_visit_management where date(schedule_date) = '".$curr_date."' and sale_person_id = '".$data['user_id']."'";
            $resVisitCount = $db->fetchRow($sqlVisitCount);


            $user_detail = array('StaffName'=>$data['StaffName'], 'LoginID'=>$data['LoginID'], 'date'=>$curr_date, 'date_start_date_time'=>$resultFirstDayStart['noti_date'], 'day_start_distance'=>$distance_from_nearest_area_at_day_start, 'day_start_area_latitude'=>$resultDayStartArea['latitude'], 'day_start_area_longitude'=>$resultDayStartArea['longitude'], 'day_start_area_longitude'=>$resultDayStartArea['longitude'], 'date_end_date_time'=>$resultLastDayEnd['noti_date'],  'day_end_area_latitude'=>$resultLastDayEnd['latitude'], 'day_end_area_longitude'=>$resultLastDayEnd['longitude'], 'distance_from_nearest_area_at_day_end'=>$distance_from_nearest_area_at_day_end, 'working_hour'=>$working_hours, 'day_start_area_name'=>$resultFirstDayStart['area_name'], 'nearest_day_end_area_name'=>$resultLastDayEnd['area_name'], 'user_id'=>$data['id'], 'retailer_count'=>$resRetCount['cnt'], 'visit_count'=>$resVisitCount['cnt']);
            array_push($final_array, $user_detail);
        }

        $this->view->final_array = $final_array;
        if ($params['report'] == 'Generate') {
         $data = array(
            array(
               'Sr. No.' => "",
               'TSI Name' => "",
               'Date' => "",
               'First Day Start Time' => "",
               'Last Day End Time' => "",
               'Working Hours' => "",
               'Added retailer count' => "",
               'Visited retailer count' => "",
               'Total count' => ""
           )
        );
         $i    = 1;
         foreach ($final_array as $rs) {
            $row          = array();
            $row[]        = stripslashes($i);
            $row[]        = stripslashes($rs['StaffName'].' ('.$rs['LoginID'].')');
            $row[]        = stripslashes($rs["date"]);
            $row[]        = stripslashes($rs["date_start_date_time"]);
            $row[]        = stripslashes($rs["date_end_date_time"]);
            $row[]        = stripslashes($rs["working_hour"]);
            $row[]        = stripslashes($rs["retailer_count"]);
            $row[]        = stripslashes($rs["visit_count"]);
            $row[]        = stripslashes($rs["visit_count"] + $rs["retailer_count"]);
            $data[]       = $row;
            $i++;
        }
        function filterData(&$str){
            $str = preg_replace("/\t/", "\\t", $str);
            $str = preg_replace("/\r?\n/", "\\n", $str);
            if (strstr($str, '"'))
               $str = '"' . str_replace('"', '""', $str) . '"';
       }
            // file name for download
       $fileName = "activity_detail_report.xls";
            // headers for download
       header("Content-Disposition: attachment; filename=\"$fileName\"");
       header("Content-Type: application/vnd.ms-excel");
       $flag = false;
       foreach ($data as $row) {
        if (!$flag) {
                    // display column names as first row
           echo implode("\t", array_keys($row)) . "\n";
           $flag = true;
       }
                // filter data
       array_walk($row, 'filterData');
       echo implode("\t", array_values($row)) . "\n";
   }
   exit;
}


if ($params['report'] == 'addretailer') {
 $add = array();
 foreach ($result as $data) {
    $sqladdtailer = "select *  from logi_user where date(Created) = '".$curr_date."' and parent_sale = '".$data['user_id']."' and role = 'Retailer'"; 
    $detail = $db->fetchAll($sqladdtailer);
    array_push($add,$detail);
}


$data = array(
    array(
       'Sr. No.' => "",
       'Retailer Name' => "",

       'Date'=>""
   )
);
$i    = 1;

foreach ($add as $test) { 
    foreach ($detail as $rs) {
       $row          = array();
       $row[]        = stripslashes($i);
       $row[]        = stripslashes($rs['StaffName']);
       $row[]        = stripslashes($rs["Created"]);
       $data[]       = $row;

       $i++;
   }

}
function filterData(&$str){
    $str = preg_replace("/\t/", "\\t", $str);
    $str = preg_replace("/\r?\n/", "\\n", $str);
    if (strstr($str, '"'))
       $str = '"' . str_replace('"', '""', $str) . '"';
}
            // file name for download
$fileName = "add_retailer_report.xls";
            // headers for download
header("Content-Disposition: attachment; filename=\"$fileName\"");
header("Content-Type: application/vnd.ms-excel");
$flag = false;
foreach ($data as $row) {
    if (!$flag) {
                    // display column names as first row
       echo implode("\t", array_keys($row)) . "\n";
       $flag = true;
   }
                // filter data
   array_walk($row, 'filterData');
   echo implode("\t", array_values($row)) . "\n";
}
exit;
}
}
}

public function getCordinateDistance($lat1, $lon1, $lat2, $lon2) {
   if (($lat1 == $lat2) && ($lon1 == $lon2)) {
      return 0;
  }
  else {
      $theta = $lon1 - $lon2;
      $dist = sin(deg2rad($lat1)) * sin(deg2rad($lat2)) +  cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta));
      $dist = acos($dist);
      $dist = rad2deg($dist);
      $miles = $dist * 60 * 1.1515;
      if(strval($miles) == "NAN"){
         return 0;
     }else{

         return ($miles * 1.609344);
     }
 }
}


public function checklogin(){
   $auth         = Zend_Auth::getInstance();
   $errorMessage = "";
   /*************** check user identity ************/
   if (!$auth->hasIdentity()) {
      $this->_redirect('admin/index');
  }
}

public function distributorAction(){
   try{
      $params                   = $this->view->params = $this->getRequest()->getParams();
      $this->db                 = Zend_Db_Table::getDefaultAdapter();
      $sqdistributor = "  SELECT * FROM `logi_location`"; 
      $this->view->location=   $location = $this->db->fetchAll($sqdistributor);
  }catch(Exception $e){
      echo $e->getMessage();exit;
  }

} 




public function distributorExportAction(){
   $this->checklogin();
   $params                   = $this->view->params = $this->getRequest()->getParams();
   $this->db                 = Zend_Db_Table::getDefaultAdapter();
   $this->view->role = $role = $this->role;
   $id   = $this->id;

   if($params['export_area']) {
      $cond= " AND distributor_area.area_id = '".$params['export_area']."'";
  }
  $sqdistributor = "SELECT logi_user.staffName,logi_user.id,logi_user.Created,logi_user.MobileNo,distributor_area.distributor_id,distributor_area.area_id,logi_location.id,logi_location.location_name FROM `logi_user`LEFT join distributor_area ON ( logi_user.id =distributor_area.distributor_id ) LEFT JOIN logi_location on (distributor_area.area_id = logi_location.id) WHERE logi_user.Role = 'Distributer' $cond"; 
  $resVisitCount = $this->db->fetchAll($sqdistributor);
  $data = array(
      array(
         'Sr. No.' => "",
         'Distributer Name' => "",
         'location_name ' => "",
         'Mobile No ' => "",
         'Created date' => ""
     )
  );
  $i    = 2;
  foreach ($resVisitCount as $rs) {
      $row          = array();
      $row[]        = stripslashes($i - 1);
      $row[]        = stripslashes($rs["staffName"]);
      $row[]        = stripslashes($rs["location_name"]);
      $row[]        = stripslashes($rs["MobileNo"]);
      $row[]        = stripslashes($rs["Created"]);
      $data[]       = $row;
      $i++;
  }
  function filterData(&$str){
      $str = preg_replace("/\t/", "\\t", $str);
      $str = preg_replace("/\r?\n/", "\\n", $str);
      if (strstr($str, '"'))
         $str = '"' . str_replace('"', '""', $str) . '"';
 }

            // file name for download
 $fileName = "distributorlist.xls";

            // headers for download
 header("Content-Disposition: attachment; filename=\"$fileName\"");
 header("Content-Type: application/vnd.ms-excel");

 $flag = false;
 foreach ($data as $row) {
  if (!$flag) {
                    // display column names as first row
     echo implode("\t", array_keys($row)) . "\n";
     $flag = true;
 }
                // filter data
 array_walk($row, 'filterData');
 echo implode("\t", array_values($row)) . "\n";
}
exit;

}

public function employeeGpsTrackingReportsAction(){
    $params  = $this->view->params = $this->getRequest()->getParams();
    $this->db = Zend_Db_Table::getDefaultAdapter();
    $ssql="select id, StaffName from logi_user where Role='Sales' order by id desc";
    $employies = $this->db->fetchAll($ssql);
    $final_data =array();

    $date = $params['current_date'];
    $download = $params['download'];
    if($date == ""){
        $date = date('Y-m-d');
    }

    $current_date = date('Y-m-d');

    date_default_timezone_set('Asia/Kolkata');
    $cur_date = date('Y-m-d H:i:s');
    $data = array(['id'=>"","Employee Name"=>"","GPS Setting at 8:00 AM"=>"","Internet Setting at 8:00 AM"=>"","GPS Setting at 12:00 PM"=>"","Internet Setting at 12:00 PM"=>"","GPS Setting at 04:00 PM"=>"","Internet Setting at 04:00 PM"=>""]);
    $i = 2;
    foreach ($employies as $key => $value) {

        $final_data[$key]['id'] = $value['id'];
        $final_data[$key]['name'] = $value['StaffName'];
        $start_date1 = $date." 08:00:00";
        $end_date1 = $date." 08:30:00";
        $esql="select dataOnOff, battery_status, add_date_time from user_path where userId=".$value['id']." and add_date_time > '".$start_date1."' and add_date_time < '".$end_date1."'  and date(datetime)='".$date."' order by add_date_time  limit 1";
        $result8 = $this->db->fetchRow($esql);
        if($result8){
            $final_data[$key]['gps'] = $result8['dataOnOff'];
            $final_data[$key]['battery_status'] = $result8['battery_status'];
        }else{
            $final_data[$key]['gps'] ='NA';
            $final_data[$key]['battery_status'] = 'NA';
        }

        $start_date2 = $date." 12:00:00";
        $end_date2 = $date." 12:30:00";

        $tvsql="select dataOnOff, battery_status, add_date_time from user_path where userId=".$value['id']." and add_date_time > '".$start_date2."' and add_date_time < '".$end_date2."'  and date(datetime)='".$date."' order by add_date_time  limit 1";
        $result12 = $this->db->fetchRow($tvsql);
        if($result12){
            $final_data[$key]['gps_t'] = $result12['dataOnOff'];
            $final_data[$key]['battery_status_t'] = $result12['battery_status'];
        }else{
            $final_data[$key]['gps_t'] = 'NA';
            $final_data[$key]['battery_status_t'] = 'NA';
        }

        $start_date3 = $date." 16:00:00";
        $end_date3 = $date." 16:30:00";
        $fsql="select dataOnOff, battery_status, add_date_time from user_path where userId=".$value['id']." and add_date_time > '".$start_date3."' and add_date_time < '".$end_date3."'  and date(datetime)='".$date."' order by add_date_time  limit 1";
        $result4 = $this->db->fetchRow($fsql);
        if($result4){   
            $final_data[$key]['gps_f'] = $result4['dataOnOff'];
            $final_data[$key]['battery_status_f'] = $result4['battery_status'];
        }else{
            $final_data[$key]['gps_f'] = 'NA';
            $final_data[$key]['battery_status_f'] = 'NA';
        }

        $data[$i] = $final_data[$key];
        $i++;
    }


    $this->view->final_data = $final_data;

    if($download == "export"){


        function filterData(&$str){
            $str = preg_replace("/\t/", "\\t", $str);
            $str = preg_replace("/\r?\n/", "\\n", $str);
            if(strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
        }
                // file name for download
        $fileName = "order_report.xls"; 
                // headers for download
        header("Content-Disposition: attachment; filename=\"$fileName\"");
        header("Content-Type: application/vnd.ms-excel");

        $flag = false;
        foreach($data as $row) {
            if(!$flag) {
                        // display column names as first row
                echo implode("\t", array_keys($row));
                $flag = true;
            }
                    // filter data
            array_walk($row, 'filterData');
            echo implode("\t", array_values($row)) . "\n";
        }
        exit;
        
    }
}


}