<?php

/***************************************************************
 * Logimetrix Techsolutions Pvt. Ltd.
 * File Name   : Productallocation.php
 * File Description  : Productallocation
 * Created By : Puneet Mishra
 * Created Date: 31 Aug 2018
 ***************************************************************/

class ProductallocationController extends Zend_Controller_Action{

  var $dbAdapter;
  var $db;

  public function init(){
     /* Initialize action controller here */
    $this->_flashMessenger  = $this->_helper->getHelper('FlashMessenger');
    $bootstrap              = $this->getInvokeArg('bootstrap');
    $aConfig                = $bootstrap->getOptions();
    $this->db               = Zend_Db_Table::getDefaultAdapter();
    $auth                   = Zend_Auth::getInstance();
    $authStorage            = $auth->getStorage();
    $this->WebLoginID       = $authStorage->read()->WebLoginID;
    $users                  = new Application_Model_Users();
    $logout_details         = $users->getUserLoginDetailByWebLoginCode($this->WebLoginID);
    $this->view->last_login = $logout_details['login_time']; 

    $this->role             = $authStorage->read()->Role;
    $this->id               = $authStorage->read()->id;              
  }

  public function indexAction(){
    $this->view->messages = $this->_flashMessenger->getMessages();  
    $this->checklogin();
    $params = $this->view->params = $this->getRequest()->getParams();
    $gmap = new Application_Model_Gmap();
    $this->view->getUserList = $getUserList =  $gmap->getUserList( $this->role, $this->id); 

    $role = $this->role;
    $id   = $this->id;

    if($params['sale_person'] !=""){
      $cond .="and u.parent_sale = '".$params['sale_person']."'";
    }

    if($params['user'] !=""){
      $cond .="and u.StaffName  like '%".$params['user']."%'";
    }

    if ($role == 'super_admin') {
      $user_cond .= "";
    }

    if ($role == 'RM') {
      $user_cond .= "and u.parent_regional_manager = '" . $id . "'";
    }

    if ($role == 'ZM') {
      $user_cond .= "and u.parent_zonal_manager = '" . $id . "' ";
    }

    if ($role == 'ASM') {
      $user_cond .= "and u.parent_area_manager = '" . $id . "' ";
    }

    if ($role == 'Sales') {
      $user_cond .= "and u.parent_sale = '" . $id . "' ";
    }

    if($params['curr_date']){
        $this->view->currDate = $currDate = $params['curr_date'];
    }
    else{
       $this->view->currDate  = $currDate = date('Y-m-d'); 
    }

    $query = "select  u.id as van_sale_person_id, tsi.id as tsi_id, u.LoginID, u.StaffName, u.MobileNo, s.state as state_name, d.district as district_name, rm.StaffName as regional_manager, zm.StaffName as zonal_manager, am.StaffName as area_manager, tsi.StaffName as tsi, dis.StaffName as distributor, tsi.LoginID as tsi_loginid  from  logi_user as u left join logi_user as rm on (u.parent_regional_manager = rm.id) left join logi_user as am on (u.parent_area_manager = am.id) left join logi_user as tsi on (u.parent_sale = tsi.id) left join logi_user as dis on (u.parent_distributer = dis.id) left join logi_user as zm on (u.parent_zonal_manager = zm.id) left join state as s on (u.state = s.id) left join district as d on (u.DistrictID = d.id) where u.Role = 'van_sale' $cond  $user_cond"; 
    $result = $this->db->fetchAll($query);

    $page=$this->_getParam('page',1);
    $paginator = Zend_Paginator::factory($result);      
    $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
    $paginator->setItemCountPerPage(15); // number of items to show per page
    $this->view->paginator = $paginator;
    $this->view->totalrec = $paginator->getTotalItemCount();
  }

  public function allocateProductAction(){
    $this->checklogin();
    $db = $this->db;
    $this->view->messages = $this->_flashMessenger->getMessages();

    $this->view->params   = $params = $this->getRequest()->getParams();
    $Retailer = new Application_Model_Retailer();
    $Model = new Application_Model_Model();
    $this->view->params = $params;
    $auth = Zend_Auth::getInstance();
    $authStorage = $auth->getStorage(); 

    $sql_user             = "select * from logi_user where md5(id) = '".$params['datacode']."' ";
    $this->view->res_user = $res_user = $this->db->fetchRow($sql_user);

    $getDistributorStrBySalesPerson = $Model->getDistributorStrBySalesPerson($res_user['parent_sale']);
    $this->view->getAllProduct = $getAllProduct = $Model->getDistributorProductDetail($getDistributorStrBySalesPerson);
    $this->view->getWarehouseList = $getWarehouseList = $Model->getWarehouseList();  

    if($this->getRequest()->isPost()){
        $params = $this->getRequest()->getParams();
        $sql_get_lastId = "select id from tbl_product_allocation order by id desc limit 1";
        $res_id = $this->db->fetchRow($sql_get_lastId);

        $currDate       = date('Y-m-d');
        $sql_vansale    = "select * from logi_user where id = '".$params['datacode']."' ";
        $res_vansale    = $this->db->fetchRow($sql_vansale);

        $sql_get_warehouse = "select * from logi_warehouse where id = '".$params['warehouse']."'";
        $res_get_warehouse = $this->db->fetchRow($sql_get_warehouse);

        $sql_get_vehicle_mapping_detail = "select * from tbl_vehicle_mapping where user_id = '".$params['datacode']."'";
        $res_vehicle_mapping = $this->db->fetchRow($sql_get_vehicle_mapping_detail);

        $allocation_detail                          = array();
        $allocation_detail['allocation_code']       = 'ALOC00'.($res_id['id']+1);
        $allocation_detail['distributor_id']        = $res_vansale['parent_distributer'];
        $allocation_detail['allocated_date']        = $currDate;
        $allocation_detail['allocated_to']          = $params['datacode'];
        $allocation_detail['sale_person_id']        = $res_vansale['parent_sale'];
        $allocation_detail['remark']                = $params['remark'];
        $allocation_detail['allocated_by']          = $res_vansale['parent_sale'];
        $allocation_detail['warehouse_id']          = $res_get_warehouse['id'];
        $allocation_detail['warehouse_name']        = $res_get_warehouse['warehouse_name'];
        $allocation_detail['warehouse_latitude']    = $res_get_warehouse['warehouse_latitude'];
        $allocation_detail['warehouse_longitude']   = $res_get_warehouse['warehouse_longitude'];
        $allocation_detail['vehicle_id']            = $res_vehicle_mapping['id'];
        $allocation_detail['vehicle_no']            = $res_vehicle_mapping['vehicle_no'];
        $db->insert('tbl_product_allocation', $allocation_detail);
        $lastorderInsertId = $db->lastInsertId();
        
        $i = 0;
        foreach($params['product_name'] as $key=>$value){
          $allocation_item_detail                   = array();
          $allocation_item_detail['allocator_id']   = $lastorderInsertId;
          $allocation_item_detail['product_id']     = $params['product_name'][$i];
          $allocation_item_detail['subproduct_id']  = $params['sub_product_name'][$i];
          $allocation_item_detail['allocated_to']   = $params['datacode'];
          $allocation_item_detail['sale_person_id'] = $res_vansale['parent_sale'];
          $allocation_item_detail['qty']            = $params['qty'][$i];
          $allocation_item_detail['remaining_qty']  = $params['qty'][$i];
          $allocation_item_detail['rate']           = '12';
          $db->insert('tbl_allocated_product_details', $allocation_item_detail);
          $i++;  
        }

        $datacode = md5($params['datacode']);                            
        $this->_flashMessenger->addMessage('Product allocated successfully.'); 
        $this->_redirect('productallocation/view-product-allocation/datacode/'.$datacode);
    }        
  }

  public function editAllocatedProductAction(){
    $this->checklogin();
    $db = $this->db;
    $this->view->messages = $this->_flashMessenger->getMessages();
    $params = $this->getRequest()->getParams();
    $Retailer = new Application_Model_Retailer();
    $Model = new Application_Model_Model();
    $this->view->params = $params;
    $auth = Zend_Auth::getInstance();
    $authStorage = $auth->getStorage(); 
    $currDate = date('Y-m-d');

    $this->view->getWarehouseList = $getWarehouseList = $Model->getWarehouseList(); 
    
    $sql_user             = "select * from logi_user where md5(id) = '".$params['datacode']."' ";
    $this->view->res_user = $res_user = $this->db->fetchRow($sql_user);

    $getDistributorStrBySalesPerson = $Model->getDistributorStrBySalesPerson($res_user['parent_sale']);
    $this->view->getAllProduct = $getAllProduct = $Model->getDistributorProductDetail($getDistributorStrBySalesPerson); 
    
    $query_get_mapped_product = "select * from tbl_product_allocation where md5(id) = '".$params['allocation_id']."'" ;        
    $this->view->result_mapped_product = $result_mapped_product = $this->db->fetchRow($query_get_mapped_product);

    $query_get_mapped_product_item_detail = "select * from tbl_allocated_product_details where allocator_id = '".$result_mapped_product['id']."'" ;        
    $this->view->result_mapped_product_item_detail = $result_mapped_product_item_detail = $this->db->fetchAll($query_get_mapped_product_item_detail);

    if($this->getRequest()->isPost()){ 
        $currDate = date('Y-m-d');
        $sql_delete_mapped_product = "delete from tbl_allocated_product_details where allocator_id = '".$params['allocation_id']."'";
        $this->db->query($sql_delete_mapped_product);

        $sql_vansale  = "select * from logi_user where id = '".$params['datacode']."' ";
        $res_vansale  = $this->db->fetchRow($sql_vansale);

        $sql_get_warehouse = "select * from logi_warehouse where id = '".$params['warehouse']."'";
        $res_get_warehouse = $this->db->fetchRow($sql_get_warehouse);

        $sql_get_vehicle_mapping_detail = "select * from tbl_vehicle_mapping where user_id = '".$params['datacode']."'";
        $res_vehicle_mapping = $this->db->fetchRow($sql_get_vehicle_mapping_detail);

        $allocation_detail                          = array();
        $allocation_detail['distributor_id']        = $res_vansale['parent_distributer'];
        $allocation_detail['allocated_date']        = $currDate;
        $allocation_detail['allocated_to']          = $params['datacode'];
        $allocation_detail['sale_person_id']        = $res_vansale['parent_sale'];
        $allocation_detail['remark']                = $params['remark'];
        $allocation_detail['allocated_by']          = $res_vansale['parent_sale'];
        $allocation_detail['warehouse_id']          = $res_get_warehouse['id'];
        $allocation_detail['warehouse_name']        = $res_get_warehouse['warehouse_name'];
        $allocation_detail['warehouse_latitude']    = $res_get_warehouse['warehouse_latitude'];
        $allocation_detail['warehouse_longitude']   = $res_get_warehouse['warehouse_longitude'];
        $allocation_detail['vehicle_id']            = $res_vehicle_mapping['id'];
        $allocation_detail['vehicle_no']            = $res_vehicle_mapping['vehicle_no'];
        $db->update('tbl_product_allocation', $allocation_detail, array('id=?' => $params['allocation_id']));

        $i = 0;
        foreach($params['product_name'] as $key=>$value){
          $allocation_item_detail                   = array();
          $allocation_item_detail['allocator_id']   = $params['allocation_id'];
          $allocation_item_detail['product_id']     = $params['product_name'][$i];
          $allocation_item_detail['subproduct_id']  = $params['sub_product_name'][$i];
          $allocation_item_detail['allocated_to']   = $params['datacode'];
          $allocation_item_detail['sale_person_id'] = $res_vansale['parent_sale'];
          $allocation_item_detail['qty']            = $params['qty'][$i];
          $allocation_item_detail['remaining_qty']  = $params['qty'][$i];
          $db->insert('tbl_allocated_product_details', $allocation_item_detail);
          $i++;  
        }       
        $this->_flashMessenger->addMessage('Product updated successfully.'); 
        $this->_redirect('productallocation/index'); 
    }        
  }


  public function printProductAllocationDataAction(){

	  $db = $this->db;
    $Model = new Application_Model_Model();
    $params = $this->getRequest()->getParams();
    $currdate = date('Y-m-d');

    $sql_user             = "select * from logi_user where md5(id) = '".$params['datacode']."' ";
    $this->view->res_user = $res_user = $this->db->fetchRow($sql_user);

    $sql_user             = "select * from logi_user where md5(id) = '".$params['datacode']."' ";
    $this->view->res_user = $res_user = $this->db->fetchRow($sql_user);

    $getDistributorStrBySalesPerson = $Model->getDistributorStrBySalesPerson($res_user['parent_sale']);
    $this->view->getAllProduct = $getAllProduct = $Model->getDistributorProductDetail($getDistributorStrBySalesPerson); 
    
    $query_get_mapped_product = "select * from tbl_product_allocation where md5(id) = '".$params['allocation_id']."'" ;        
    $this->view->result_mapped_product = $result_mapped_product = $this->db->fetchRow($query_get_mapped_product);

    $query_get_mapped_product_item_detail = "select tbl_allocated_product_details.*,  logi_product.product_name, sub_product.sub_product_name from tbl_allocated_product_details left join logi_product on (logi_product.id = tbl_allocated_product_details.product_id) left join sub_product on (sub_product.id = tbl_allocated_product_details.subproduct_id) where tbl_allocated_product_details.allocator_id = '".$result_mapped_product['id']."'" ; 
    $this->view->result_mapped_product_item_detail = $result_mapped_product_item_detail = $this->db->fetchAll($query_get_mapped_product_item_detail);  
  }

  
  public function getSubProductListAction(){
  
    	$this->checklogin();
    	$this->getHelper('Layout')->disableLayout();
    	$this->getHelper('ViewRenderer')->setNoRender();
    	$this->getResponse()->setHeader('Content-Type', 'application/json');
    	$Model = new Application_Model_Model();
    	$product_id         = $this->getRequest()->getParam('product_id');
    	$parent_sale        = $this->getRequest()->getParam('parent_sale');
    	$getDistributorStrBySalesPerson = $Model->getDistributorStrBySalesPerson($parent_sale);

      $data_list_unformat = $Model->getDistributorSubProductDetail($product_id, $getDistributorStrBySalesPerson);

    	$sub_product_list[] = array(
    		"value" => "",
    		'text' => "--Select Sub Product--"
    	);
    	foreach ($data_list_unformat as $single) {
    		$sub_product_list[] = array(
    			"value" => $single['id'],
    			"text" => $single['sub_product_name']
    		);
    	}
    	$this->getHelper('Layout')->disableLayout();
    	$this->getHelper('ViewRenderer')->setNoRender();
    	$this->getResponse()->setHeader('Content-Type', 'application/json');
    	echo json_encode(array(
    		'options' => $sub_product_list
    	));
    	return;
  }


  public function viewProductAllocationAction(){
      $this->view->messages = $this->_flashMessenger->getMessages();  
      $this->checklogin();
      $params = $this->view->params = $this->getRequest()->getParams();
      $gmap = new Application_Model_Gmap();
      $this->view->getUserList = $getUserList =  $gmap->getUserList( $this->role, $this->id);

      $currDate = date('Y-m-d'); 

      $role = $this->role;
      $id   = $this->id;

      $query = " select *, date(allocated_date) as allocation_date from tbl_product_allocation where md5(allocated_to) = '".$params['datacode']."' and date(allocated_date) = '".$currDate."'"; 
      $result = $this->db->fetchAll($query);

      $page=$this->_getParam('page',1);
      $paginator = Zend_Paginator::factory($result);      
      $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
      $paginator->setItemCountPerPage(15); // number of items to show per page
      $this->view->paginator = $paginator;
      $this->view->totalrec = $paginator->getTotalItemCount();
  }  

  public function checklogin(){   
    $auth = Zend_Auth::getInstance(); 
    $errorMessage = ""; 
    /*************** check user identity ************/
    if(!$auth->hasIdentity()){
      $this->_redirect('admin/index');  
    }   
  }     
}
