<?php

/***************************************************************
 * Logimetrix Techsolutions Pvt. Ltd.
 * File Name   : ProductController.php
 * File Description  : ProductController
 * Created By : Puneet Mishra
 * Created Date: 25 Nov 2016
 ***************************************************************/

class ProductController extends Zend_Controller_Action{
  var $dbAdapter;
  var $db;
  public function init(){
    /* Initialize action controller here */
    $bootstrap = $this->getInvokeArg('bootstrap');
    $aConfig = $bootstrap->getOptions();
    $this->db = Zend_Db_Table::getDefaultAdapter();
    $auth = Zend_Auth::getInstance();
    $authStorage = $auth->getStorage();
    $this->WebLoginID = $authStorage->read()->WebLoginID;
    $users = new Application_Model_Users();
    $logout_details = $users->getUserLoginDetailByWebLoginCode($this->WebLoginID);
    $this->view->last_login = $logout_details['login_time'];               
  }

  public function indexAction(){
    $this->checklogin();
    $params = $this->view->params = $this->getRequest()->getParams(); 
    $Retailer = new Application_Model_Retailer(); 
    $this->view->customer = $result = $Retailer->AllPRODUCTData();    
    $page=$this->_getParam('page',1);
    $paginator = Zend_Paginator::factory($result);      
      $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
      $paginator->setItemCountPerPage(10); // number of items to show per page
      $this->view->paginator = $paginator;
      $this->view->totalrec = $paginator->getTotalItemCount();
    }

    public function addNewProductAction(){
      // $this->checklogin();
      $db = $this->db;
      $params = $this->getRequest()->getParams();
      $Retailer = new Application_Model_Retailer();
      $this->view->params = $params;
      $auth = Zend_Auth::getInstance();
      $authStorage = $auth->getStorage();
      $this->view->GetallUnitType = $GetallUnitType = $Retailer->GetallUnitType();
      $this->view->GetallPackingType = $GetallPackingType = $Retailer->GetallPackingType();
      if($this->getRequest()->isPost()){
        if($params['submit']=='Save'){

          $sqlVaidateProduct = "select * from logi_product where product_name = '".ucfirst($params['product'])."'";
          $resutProduct = $db->fetchAll($sqlVaidateProduct);
          if($resutProduct){
            $this->view->errorMessage = "Product allready exists";
          }
          else{
            $data = array();
            $data['product_name'] = ucfirst($params['product']);
            $db->insert('logi_product', $data);
            $this->view->successMessage = "Product Detail added successfully.";
          }  
        } 
        else{
          if($_FILES['importxl']==''){ ?>
            <script>alert("Please Choose a Excel File.")</script><?php
          }
          else{
            if(isset($_FILES["importxl"]["error"])){
              if($_FILES["importxl"]["error"] > 0){ ?>
                <script>alert("Please select file.")</script><?php
              }
              else{
                $allowed = array("xls" => "application/vnd.ms-excel", "xlsx" => "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
                $filename = $_FILES["importxl"]["name"];
                $filetype = $_FILES["importxl"]["type"];
                $filesize = $_FILES["importxl"]["size"];
                
                $ext = pathinfo($filename, PATHINFO_EXTENSION);
                if(!array_key_exists($ext, $allowed)){
                  ?><script>alert("This file is not an accepted file type.")</script><?php
                }
                            // siati fua - 10MB
                $maxsize = 200000 * 60;
                if($filesize > $maxsize) {

                  ?><script>alert("File size is larger than the allowed 10MB limit.")</script><?php
                }

                if(in_array($filetype, $allowed)){
                  move_uploaded_file($_FILES["importxl"]["tmp_name"], "PHPExcleReader/" . $_FILES["importxl"]["name"]);
                  /** Include path **/
                  set_include_path(get_include_path() . PATH_SEPARATOR . 'PHPExcleReader/Classes/');

                  /** PHPExcel_IOFactory */
                  include 'PHPExcel/IOFactory.php';

                  $inputFileName = 'PHPExcleReader/'.$filename;  // File to read
                  try {
                    $objPHPExcel = PHPExcel_IOFactory::load($inputFileName);
                  } 
                  catch(Exception $e) {
                    die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
                  }
                  $sheetData = $objPHPExcel->getActiveSheet()->toArray(null,true,true,true);

                  $arr= array();
                  $k=0;
                  foreach($sheetData as $key){
                    $arr[$k]=trim($key['A']);
                    $x  = array('product'=>trim($key['A']));
                    $arr[$k] = $x;
                    $k++;
                  }
                  array_shift($arr);
                  //Existing products array
                  $array_existing_product = array();  
                  foreach($arr as  $key){
                    $product = trim($key['product']);
                    if($product){
                      //vaidate existing product
                      $sqlVaidateProduct = "select * from logi_product where product_name = '".ucfirst($params['product'])."'";
                      $resultProduct = $db->fetchRow($sqlVaidateProduct);
                      
                      if($resutProduct){
                        $this->view->errorMessage = "Product allready exists";
                        array_push($array_existing_product, "".$product."");
                      }
                      else{
                        $data = array();
                        $data['product_name'] = ucfirst($product);
                        $db->insert('logi_product', $data);
                      }
                    } 
                  }
                }
                if($array_existing_product){
                  $existing_product_str = implode(',', $array_existing_product);
                  $this->view->errorMessage = $existing_product_str." these products allready exists";
                }
                $this->view->successMessage = "Product Detail added successfully.";                
              }
            }
          }
        }                                         
      }        
    }

    
    public function editProductAction(){
      $this->checklogin();
      $db = $this->db;
      $auth = Zend_Auth::getInstance();
      $authStorage = $auth->getStorage();
      $params = $this->getRequest()->getParams();
      $Retailer = new Application_Model_Retailer();               
      $this->view->params = $params;
      $this->view->GetallUnitType = $GetallUnitType = $Retailer->GetallUnitType();
      $this->view->GetallPackingType = $GetallPackingType = $Retailer->GetallPackingType();              
      $this->view->result = $result = $Retailer->GetProductDetailId($params['datacode']);   
      if($this->getRequest()->isPost()){
        $data = array();
        $data['product_name'] = $params['product'];                 
        $db->update('logi_product',$data,array('id=?'=>$params['productId']));
        $this->_redirect('product/index');
      }        
    }

    public function deleteProductAction(){		
      $this->checklogin(); 
      $Retailer = new Application_Model_Retailer();
      $productId = $this->getRequest()->getParam('productId');
      if($productId!=""){ 
        $Retailer->DeleteProducttype($productId);
        $this->_redirect('product'); 
      }                                                                                    
    }

    public function checklogin(){   
      $auth = Zend_Auth::getInstance(); 
      $errorMessage = ""; 
      /*************** check user identity ************/
      if(!$auth->hasIdentity()){
        $this->_redirect('admin/index');  
      }   
    }     
  }
