<?php

/***************************************************************
 * Logimetrix Techsolutions Pvt. Ltd.
 * File Name   : PaymentController.php
 * File Description  : PaymentController
 * Created By : Puneet Mishra
 * Created Date: 25 Nov 2016
 ***************************************************************/
 
class PaymentController extends Zend_Controller_Action{
    var $dbAdapter;
    var $db;
    public function init(){
             /* Initialize action controller here */
             $bootstrap = $this->getInvokeArg('bootstrap');
             $aConfig = $bootstrap->getOptions();
             $this->db = Zend_Db_Table::getDefaultAdapter();
             $auth = Zend_Auth::getInstance();
             $authStorage = $auth->getStorage();
             $this->WebLoginID = $authStorage->read()->WebLoginID;
             $users = new Application_Model_Users();
             $logout_details = $users->getUserLoginDetailByWebLoginCode($this->WebLoginID);
             $this->view->last_login = $logout_details['login_time'];               
    }
    
    public function indexAction(){

             $this->checklogin();
             $db = $this->db = Zend_Db_Table::getDefaultAdapter();
             $this->view->params = $params = $this->getRequest()->getParams();
             $auth = Zend_Auth::getInstance();
             $authStorage = $auth->getStorage();
             
             $dist_query = "SELECT LoginID, StaffName FROM logi_user WHERE Role = 'Distributer' ";
             $this->view->getUserList = $getUserList = $db->fetchAll($dist_query);
              
             $payment_query = "SELECT lpd.*, lu.StaffName FROM logi_payment_detail AS lpd LEFT JOIN logi_user AS lu ON (lpd.loginID = lu.LoginID)";
             $this->view->payment_result = $payment_result = $db->fetchAll($payment_query);

             $page=$this->_getParam('page',1);
             $paginator = Zend_Paginator::factory($payment_result);      
             $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
             $paginator->setItemCountPerPage(10); // number of items to show per page
             $this->view->paginator = $paginator;
             $this->view->totalrec = $paginator->getTotalItemCount();
    }

    public function searchAction(){
         $this->checklogin();
         $db = $this->db = Zend_Db_Table::getDefaultAdapter();
         $this->view->params = $params = $this->getRequest()->getParams();

         if($params['user'] != ""){
            $cond = "AND lpd.loginID = '".$params['user']."' ";
         }
            $search_query = "SELECT lpd.*, lu.StaffName FROM logi_payment_detail AS lpd LEFT JOIN logi_user AS lu ON (lpd.loginID = lu.LoginID) WHERE 1 $cond ";
            $this->view->search_result = $search_result = $db->fetchAll($search_query);

             $page=$this->_getParam('page',1);
             $paginator = Zend_Paginator::factory($search_result);      
             $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
             $paginator->setItemCountPerPage(10); // number of items to show per page
             $this->view->paginator = $paginator;
             $this->view->totalrec = $paginator->getTotalItemCount();


        if($params['payment'] == 'Generate'){
    
                $data = array(array('Sr. No.'=> "", 'Distributer Name'=> "", 'Sales Person'=> "", 'Total Amount'=> "", 'Amount Payed'=> "", 'Amount Left'=> "", 'Payment Status'=> "", 'Status by Sales Person'=> "", 'Status by Admin'=>"", 'Payment Date'=> ""));
                $i = 2; 
                foreach ($search_result as $rs) {
                   
                   if($rs['sellerID'] != ""){
                      $seller_query = "SELECT StaffName FROM logi_user WHERE LoginID = '".$rs['sellerID']."' ";
                      $sellerName = $db->fetchRow($seller_query);
                    }
                   
                    if($rs['payment_status'] == 0){  
                       $paymentStatus = "Due" ; 
                     } else { 
                       $paymentStatus = "Done" ; 
                     }  
                    if($rs['approval_status_sales'] == 0){  
                      $approvalStatusSales = "Processing"; 
                     } elseif($rs['approval_status_sales'] == 1){ 
                      $approvalStatusSales = "Accepted"; 
                     } elseif($rs['approval_status_sales'] == 2){
                      $approvalStatusSales = "Denied";
                     } 
                    if($rs['approval_status_admin'] == 0){ 
                      $approvalStatusAdmin = "Processing"; 
                     } elseif($rs['approval_status_admin'] == 1){ 
                      $approvalStatusAdmin = "Accepted"; 
                     } elseif($rs['approval_status_admin'] == 2){ 
                      $approvalStatusAdmin = "Denied"; 
                     } 
                  
                    $row = array();
                    $row[] = stripslashes($i-1);
                    $row[] = stripslashes($rs["StaffName"]);
                    $row[] = stripslashes($sellerName['StaffName']);
                    $row[] = stripslashes($rs["total_amount"]);
                    $row[] = stripslashes($rs["paying_amount"]);
                    $row[] = stripslashes($rs["pending_amount"]);
                    $row[] = stripslashes($paymentStatus);
                    $row[] = stripslashes($approvalStatusSales);
                    $row[] = stripslashes($approvalStatusAdmin);
                    $row[] = stripslashes($rs["payment_date"]);
                                            
                    $data[] = $row;
                    $i++;
                }
                function filterData(&$str){
                    $str = preg_replace("/\t/", "\\t", $str);
                    $str = preg_replace("/\r?\n/", "\\n", $str);
                    if(strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
                }

                // file name for download
                $fileName = "distributer_payment_report.xls"; 

                // headers for download
                header("Content-Disposition: attachment; filename=\"$fileName\"");
                header("Content-Type: application/vnd.ms-excel");

                $flag = false;
                foreach($data as $row) {
                    if(!$flag) {
                        // display column names as first row
                        echo implode("\t", array_keys($row)) . "\n";
                        $flag = true;
                    }
                    // filter data
                    array_walk($row, 'filterData');
                    echo implode("\t", array_values($row)) . "\n";
                }
                exit;
      }
         

    }

     
  public function checklogin(){   
      $auth = Zend_Auth::getInstance(); 
      $errorMessage = ""; 
      /*************** check user identity ************/
      if(!$auth->hasIdentity()){
            $this->_redirect('admin/index');  
      }   
  }     
}
