<?php

/***************************************************************
 * Logimetrix Techsolutions Pvt. Ltd.
 * File Name   : MasterController.php
 * File Description  : MasterController
 * Created By : Puneet Mishra
 * Created Date: 21 Sep 2018
 ***************************************************************/

class MasterController extends Zend_Controller_Action{
	var $dbAdapter;
	var $db;
	public function init(){
		/* Initialize action controller here */
		$this->_flashMessenger  = $this->_helper->getHelper('FlashMessenger');
		$bootstrap = $this->getInvokeArg('bootstrap');
		$aConfig = $bootstrap->getOptions();
		$this->db = Zend_Db_Table::getDefaultAdapter();
		$auth = Zend_Auth::getInstance();
		$authStorage = $auth->getStorage();
		$this->WebLoginID = $authStorage->read()->WebLoginID;
		$users = new Application_Model_Users();
		$logout_details = $users->getUserLoginDetailByWebLoginCode($this->WebLoginID);
		$this->view->last_login = $logout_details['login_time'];               
	}

	public function vehicleAction(){
		$this->checklogin();
		$this->view->messages = $this->_flashMessenger->getMessages();
		$params = $this->view->params = $this->getRequest()->getParams();
		$model = new Application_Model_Model();
		$this->view->getVehicleList = $getVehicleList = $model->getVehicleList($params['vehicle_no']);
		$page=$this->_getParam('page',1);
		$paginator = Zend_Paginator::factory($getVehicleList);      
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(30); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec = $paginator->getTotalItemCount();
    }

    public function addVehicleAction(){

    	$this->checklogin();
    	$db = $this->db;
    	$this->view->messages = $this->_flashMessenger->getMessages();
    	$this->view->params = $params = $this->getRequest()->getParams();

    	if($this->getRequest()->isPost()){ 
    		if(isset($_FILES['vehicle_image']['tmp_name']) AND !empty($_FILES['vehicle_image']['tmp_name'])){
    			$tempName   = $_FILES['vehicle_image']['tmp_name'];
    			$type       = explode('.', $_FILES['vehicle_image']['name']);
    			$imageName  = time().'.'.$_FILES['vehicle_image']['name']; 
    			$uploads    = 'uploads/vehicle_image/';
    			if(!file_exists($uploads)){
    				mkdir($uploads); 
    			}
    			$pathComplete = $uploads.$imageName;
    			@move_uploaded_file($tempName,$pathComplete);
    		}
    		$data = array();
    		$data['vehicle_no']           = $params['vehicle_no'];
    		$data['vehicle_description']  = $params['description'];
    		$data['vehicle_image']        = $imageName;
    		$db->insert('tbl_vehicle', $data);                                       
    		$this->_flashMessenger->addMessage('Vehicle Detail added successfully.'); 
    		$this->_redirect('master/add-vehicle');
    	}        
    }

    public function addBrandAction(){

    	$this->checklogin();
    	$db = $this->db;
    	$this->view->messages = $this->_flashMessenger->getMessages();
    	$this->view->params = $params = $this->getRequest()->getParams();

    	if($this->getRequest()->isPost()){ 

    		$data = array();
    		$data['brand_name']           = $params['brand_name'];
    		$db->insert('tbl_brand', $data);                                       
    		$this->_flashMessenger->addMessage('Brand added successfully.'); 
    		$this->_redirect('master/add-brand');
    	}        
    }

    public function editVehicleAction(){
    	$this->checklogin();
    	$db = $this->db;
    	$this->view->messages = $this->_flashMessenger->getMessages();
    	$auth = Zend_Auth::getInstance();
    	$authStorage = $auth->getStorage();
    	$this->view->params = $params = $this->getRequest()->getParams();
    	$model = new Application_Model_Model();               

    	$this->view->getVehicleDetailById  = $getVehicleDetailById = $model->getVehicleDetailById($params['vehicle_no']);   
    	if($this->getRequest()->isPost()){
    		if(isset($_FILES['vehicle_image']['tmp_name']) AND !empty($_FILES['vehicle_image']['tmp_name'])){
    			$tempName   = $_FILES['vehicle_image']['tmp_name'];
    			$type       = explode('.', $_FILES['vehicle_image']['name']);
    			$imageName  = time().'.'.$_FILES['vehicle_image']['name']; 
    			$uploads    = 'uploads/vehicle_image/';
    			if(!file_exists($uploads)){
    				mkdir($uploads); 
    			}
    			$pathComplete = $uploads.$imageName;
    			@move_uploaded_file($tempName,$pathComplete);
    		}
    		$data = array();
    		$data['vehicle_no']           = $params['vehicle_no'];
    		$data['vehicle_description']  = $params['description'];
    		$data['vehicle_image']        = $imageName;
    		$db->update('tbl_vehicle',$data,array('id=?'=>$params['id']));
    		$this->_flashMessenger->addMessage('Vehicle Detail Updated successfully.'); 
    		$this->_redirect('master/vehicle');
    	}        
    }

    public function vehicleMappingAction(){
    	$this->checklogin();
    	$db = $this->db;
    	$this->view->messages = $this->_flashMessenger->getMessages();
    	$this->view->params = $params = $this->getRequest()->getParams();
    	$model  = new Application_Model_Model();
    	$this->view->getUnMappedVehicleList = $getUnMappedVehicleList = $model->getUnMappedVehicleList();
        //get vehicle mapping detail by mapping id
    	if($params['datacode']){
    		$this->view->getVehicleMappigDetailById = $getVehicleMappigDetailById = $model->getVehicleMappigDetailById($params['datacode']);
    	}
        //get vehicle mapping list
    	$this->view->getVehicleMappingList = $getVehicleMappingList = $model->getVehicleMappingList($params['vehicle_no']);
    	$page=$this->_getParam('page',1);
    	$paginator = Zend_Paginator::factory($getVehicleMappingList);      
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(30); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec = $paginator->getTotalItemCount();
        //mapped van sale person list with vehicle 
        $mapped_van_sale_person_list = array();
        foreach($getVehicleMappingList as $mapping_list){
        	array_push($mapped_van_sale_person_list, "'".$mapping_list['van_sale_person_id']."'");
        }
        //get unmapped van sale person list 
        $mapped_van_sale_person_str = implode(",", $mapped_van_sale_person_list);
        $this->view->getUnMappedVanSalePersonList = $getUnMappedVanSalePersonList = $model->getUnMappedVanSalePersonList($mapped_van_sale_person_str);
        //Save Vehicle Mapping
        if(isset($params['submit']) && $params['submit'] !="" && $params['submit'] =="submit"){
        	$getVehicleDetailById = $model->getVehicleDetailById(md5(md5($params['vehicle_id'])));

        	$vehicle_mapping_data = array();
        	$vehicle_mapping_data['vehicle_id']           = $getVehicleDetailById['id'];
        	$vehicle_mapping_data['vehicle_no']           = $getVehicleDetailById['vehicle_no'];
        	$vehicle_mapping_data['vehicle_description']  = $getVehicleDetailById['vehicle_description'];
        	$vehicle_mapping_data['user_id']              = $params['van_sale_person_id'];
        	$db->insert('tbl_vehicle_mapping', $vehicle_mapping_data);

        	$update_vehicle_mapped_status = array();
        	$update_vehicle_mapped_status['mapped_status'] = '1';
        	$db->update('tbl_vehicle',$update_vehicle_mapped_status,array('id=?'=>$getVehicleDetailById['id'])); 

        	$this->_flashMessenger->addMessage('Vehicle Mapped successfully.'); 
        	$this->_redirect('master/vehicle-mapping');               
        }
        //Update Vehicle Mapping
        if(isset($params['submit']) && $params['submit'] !="" && $params['submit'] =="update"){
        	$getVehicleDetailById = $model->getVehicleDetailById(md5(md5($params['vehicle_id'])));
        	$vehicle_mapping_data = array();
        	$vehicle_mapping_data['vehicle_id']           = $getVehicleDetailById['id'];
        	$vehicle_mapping_data['vehicle_no']           = $getVehicleDetailById['vehicle_no'];
        	$vehicle_mapping_data['vehicle_description']  = $getVehicleDetailById['vehicle_description'];
        	$vehicle_mapping_data['user_id']              = $params['van_sale_person_id'];
        	$db->update('tbl_vehicle_mapping',$vehicle_mapping_data,array('id=?'=>$params['vehicle_mapping_id']));

        	$update_prev_mapped_vehicle_status = array();
        	$update_prev_mapped_vehicle_status['mapped_status'] = '0';
        	$db->update('tbl_vehicle',$update_prev_mapped_vehicle_status,array('id=?'=>$params['prev_mapped_vehicle_id']));

        	$update_vehicle_mapped_status = array();
        	$update_vehicle_mapped_status['mapped_status'] = '1';
        	$db->update('tbl_vehicle',$update_vehicle_mapped_status,array('id=?'=>$getVehicleDetailById['id']));

        	$this->_flashMessenger->addMessage('Vehicle Mapping Updated successfully.'); 
        	$this->_redirect('master/vehicle-mapping');               
        }
    }

    public function regionAction(){
    	$this->checklogin();
    	$this->view->messages = $this->_flashMessenger->getMessages();
    	$params = $this->view->params = $this->getRequest()->getParams();
    	$model = new Application_Model_Model();
    	$this->view->getRegionMappingList = $getRegionMappingList = $model->getRegionMappingList($params['region_name']);
    	$page=$this->_getParam('page',1);
    	$paginator = Zend_Paginator::factory($getRegionMappingList);      
        $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $paginator->setItemCountPerPage(30); // number of items to show per page
        $this->view->paginator = $paginator;
        $this->view->totalrec = $paginator->getTotalItemCount();
    }

    public function addRegionAction(){
    	$this->checklogin();
    	$db = $this->db;
    	$this->view->messages = $this->_flashMessenger->getMessages();
    	$this->view->params = $params = $this->getRequest()->getParams();

    	if($this->getRequest()->isPost()){
    		$data = array();
    		$data['region_name']  = ucwords($params['region_name']);
    		$db->insert('tbl_region', $data); 
    		$lastInsertId = $db->lastInsertId();

    		$i = 0;   
    		foreach($params['zone_name'] as $zone_data){
    			$zone_array = array();
    			$zone_array['region_id']   = $lastInsertId;
    			$zone_array['region_name'] = ucwords($params['region_name']);
    			$zone_array['zone_name']   = $params['zone_name'][$i];
    			$db->insert('tbl_zone', $zone_array);
    			$i++;  
    		}
    		$this->_flashMessenger->addMessage('Region Detail added successfully.'); 
    		$this->_redirect('master/region');
    	}        
    }

    public function editRegionAction(){
    	$this->checklogin();
    	$db = $this->db;
    	$this->view->messages             = $this->_flashMessenger->getMessages();
    	$this->view->params               = $params = $this->getRequest()->getParams();
    	$model                            = new Application_Model_Model();
    	$this->view->getRegionDetailById  = $getRegionDetailById = $model->getRegionDetailById($params['datacode']);

    	if($this->getRequest()->isPost()){ 
    		$update_region_array = array();
    		$update_region_array['region_name']   = ucwords($params['region_name']);
    		$db->update('tbl_region', $update_region_array, array('id=?' => $params['region_id']));

    		$i = 0;
    		$zone_id_array = array(); 
    		foreach($params['zone_name'] as $zone_data){
    			if($params['zone_id'][$i]){
    				$update_zone_array = array();
    				$update_zone_array['region_id']   = $params['region_id'];
    				$update_zone_array['region_name'] = ucwords($params['region_name']);
    				$update_zone_array['zone_name']   = ucwords($params['zone_name'][$i]);
    				$db->update('tbl_zone', $update_zone_array, array('id=?' => $params['zone_id'][$i]));

    				$update_zone_state_mapping = array();
    				$update_zone_state_mapping['zone_name']     = ucwords($params['zone_name'][$i]);
    				$update_zone_state_mapping['region_name']   = ucwords($params['region_name']);
    				$db->update('tbl_zone_state_mapping', $update_zone_state_mapping, array('zone_id=?' => $params['zone_id'][$i]));
    				array_push($zone_id_array, "'".$params['zone_id'][$i]."'");
    			}
    			else{
    				$zone_array = array();
    				$zone_array['region_id']          = $params['region_id'];
    				$zone_array['region_name']        = ucwords($params['region_name']);
    				$zone_array['zone_name']          = ucwords($params['zone_name'][$i]);
    				$db->insert('tbl_zone', $zone_array);
    				$lastInsertId = $db->lastInsertId();
    				array_push($zone_id_array, "'".$lastInsertId."'");
    			}    
    			$i++;  
    		}
    		if($zone_id_array){
    			$zone_id_str = implode(",", $zone_id_array);
    			$sql_deactivate_zone  = "update tbl_zone set status = '0', region_name = '".ucwords($params['region_name'])."' where id not in ($zone_id_str) and region_id = '".$params['region_id']."'";
    			$db->query($sql_deactivate_zone);

    			$sql_unmap_state  = "update tbl_zone_state_mapping set status = '0', region_name = '".ucwords($params['region_name'])."' where zone_id not in ($zone_id_str) and region_id = '".$params['region_id']."'";
    			$db->query($sql_unmap_state);
    		}
    		$this->_flashMessenger->addMessage('Region Detail updaetd successfully.'); 
    		$this->_redirect('master/region');
    	}          
    }

    public function zoneStateMappingAction(){
    	$this->checklogin();
    	$db = $this->db;
    	$layout = $this->_helper->layout();
    	$layout->disableLayout('');
    	$model = new Application_Model_Model();
    	$this->view->messages = $this->_flashMessenger->getMessages();
    	$params = $this->view->params     = $this->getRequest()->getParams();
    	$this->view->getZoneDetailById    = $getZoneDetailById       = $model->getZoneDetailById($params['zone_id']);
    	$this->view->getUnmappedStateList = $getUnmappedStateList    = $model->getUnmappedStateList($params['zone_id'], $params['type']);
    	$this->view->getMappedStateWithZone    = $getMappedStateWithZone = $model->getMappedStateWithZone($params['zone_id']);

    	if($this->getRequest()->isPost()){

    		$sql_delete = "update tbl_zone_state_mapping set  status='0' where  zone_id = '".$params['zone_id']."'";
    		$db->query($sql_delete);

    		$sql_zone    = "select * from tbl_zone where id = '".$params['zone_id']."'";
    		$result_zone = $db->fetchRow($sql_zone);

    		$i = 0;
    		foreach($params['state'] as $state_data){
    			$sql_state  = "select * from state where id = '".$state_data."'";
    			$state_result = $db->fetchRow($sql_state);

    			$mapping_array = array();
    			$mapping_array['zone_id']     = $params['zone_id'];
    			$mapping_array['zone_name']   = ucwords($getZoneDetailById['zone_name']);
    			$mapping_array['state_id']    = $state_data;
    			$mapping_array['state_name']  = $state_result['state'];
    			$mapping_array['region_name'] = ucwords($result_zone['region_name']);
    			$mapping_array['region_id']   = $result_zone['region_id'];
    			$db->insert('tbl_zone_state_mapping', $mapping_array); 
    			$i++;
    		}

    		if($params['type']=='edit'){
    			$msg = "Update successfully";
    		}
    		else{
    			$msg = "Mapped successfully";
    		}
    		$this->_flashMessenger->addMessage($msg); 
    		$this->_redirect('master/region');
    	}     
    }

    public function deleteRegionAction(){
    	$this->checklogin();
    	$db                   = $this->db;
    	$auth                 = Zend_Auth::getInstance();
    	$authStorage          = $auth->getStorage();
    	$params               = $this->getRequest()->getParams();

    	$sql_region = "update tbl_region set  status='0' where  id = '".$params['id']."'";
    	$db->query($sql_region);

    	$sql_zone = "update tbl_zone set  status='0' where  region_id = '".$params['id']."'";
    	$db->query($sql_zone);

    	$sql_zone_state_mapping = "update tbl_zone_state_mapping set  status='0' where  region_id = '".$params['id']."'";
    	$db->query($sql_zone_state_mapping);

    	$this->_helper->layout()->disableLayout(); 
    	$this->_helper->viewRenderer->setNoRender(true);
    }


    public function getUsersDistrictListAction(){
    	$this->getHelper('Layout')->disableLayout();
    	$this->getHelper('ViewRenderer')->setNoRender();
    	$this->getResponse()->setHeader('Content-Type', 'application/json');
    	$params = $this->view->params = $this->getRequest()->getParams();
    	$model = new Application_Model_Model();

    	$data_list_unformat = $model->getUserDistrictList($params['state_id']); 


    	$data_list[] = array("value"=>"",'text'=>"--Select District--");
    	foreach($data_list_unformat as $single){
    		$data_list[] = array("value"=>$single['district_id'],"text"=>$single['district_name']);
    	}             
    	$this->getHelper('Layout')->disableLayout();
    	$this->getHelper('ViewRenderer')->setNoRender();
    	$this->getResponse()->setHeader('Content-Type', 'application/json');
    	echo json_encode(array('options'=>$data_list));
    	return;      
    }

    public function getUserListByStateAndDistrictAction(){
    	$this->getHelper('Layout')->disableLayout();
    	$this->getHelper('ViewRenderer')->setNoRender();
    	$this->getResponse()->setHeader('Content-Type', 'application/json');
    	$params = $this->view->params = $this->getRequest()->getParams();
    	$model = new Application_Model_Model();

    	$data_list_unformat = $model->getSalepersonByStateDistrict($params['state_id'], $params['district_id']);          
    	$data_list[] = array("value"=>"",'text'=>"--Select Sale Person--");
    	foreach($data_list_unformat as $single){
    		$data_list[] = array("value"=>$single['id'],"text"=>$single['StaffName'].'('.$single['LoginID'].')');
    	}             
    	$this->getHelper('Layout')->disableLayout();
    	$this->getHelper('ViewRenderer')->setNoRender();
    	$this->getResponse()->setHeader('Content-Type', 'application/json');
    	echo json_encode(array('options'=>$data_list));
    	return;      
    }


    public function viewCategoryAction(){
    	$this->checklogin();
    	$this->view->messages  = $this->_flashMessenger->getMessages();
    	$db                    =  $this->db = Zend_Db_Table::getDefaultAdapter();
    	$params                = $this->view->params = $this->getRequest()->getParams();
    	if($params['name']){
    		$sql = "select * from tbl_customer_category where category_name='".$params['name']."' AND status= 1";
    		$this->view->list = $list = $db->fetchAll($sql);
    	}
    	else{
    		$sq2="select * from tbl_customer_category where status = 1";

    		$this->view->list = $list = $db->fetchAll($sq2);
    	}
    }

    public function speechAction(){

        $this->view->messages  = $this->_flashMessenger->getMessages();
        $db                    =  $this->db = Zend_Db_Table::getDefaultAdapter();
        $params                = $this->view->params = $this->getRequest()->getParams();
        $this->_helper->layout()->disableLayout(); 
        // $this->_helper->viewRenderer->setNoRender();
    }

    public function getDataAction(){

        $this->_helper->layout()->disableLayout(); 
        $this->checklogin();
        $this->view->messages  = $this->_flashMessenger->getMessages();
        $this->db = Zend_Db_Table::getDefaultAdapter();

        $params = $this->view->params = $this->getRequest()->getParams();
        // print_r($params); exit;
        $name=$params['speechText'];
        $html = "";
        $keywords = explode(' ', $name);

        $curr_date =  date("Y-m-d");
        
        // print_r($params);
        // exit;
        foreach($keywords AS $names){
            // print_r($names); exit;
          echo  $sql_users = "select * FROM USER WHERE StaffName = '". $keywords."%' LIMIT 1";
          $this->view->user = $user = $this->db->fetchRow($sql_users); exit;
          print_r($user); exit;
      }

      echo $sql_user = "select u.*, s.state as state_name, d.district as district_name, rm.StaffName as regional_manager, zm.StaffName as zonal_manager, am.StaffName as area_manager, tsi.StaffName as tsi, dis.StaffName as distributor  from  logi_user as u left join logi_user as rm on (u.parent_regional_manager = rm.id) left join logi_user as am on (u.parent_area_manager = am.id) left join logi_user as tsi on (u.parent_sale = tsi.id) left join logi_user as dis on (u.parent_distributer = dis.id) left join logi_user as zm on (u.parent_zonal_manager = zm.id) left join state as s on (u.state = s.id) left join district as d on (u.DistrictID = d.id) where  u.id = '".$user['id']."'"; exit;
      $this->view->result_user = $result_user = $this->db->fetchRow($sql_user);
      print_r($result_user);
      exit;
      $query = "SELECT * FROM logi_user WHERE id = '".$params['id']."'";
      $this->view->result = $result = $this->db->fetchRow($query);
      $Retailer = "select retailer_check_in_out.*, logi_user.id as users_id,logi_user.Address_Curr,logi_user.StaffName,logi_user.Created from retailer_check_in_out left join logi_user on  (logi_user.id = retailer_check_in_out.retailer) where  date(retailer_check_in_out.timedate) = '".$curr_date."' AND status ='checkin' and retailer_check_in_out.saleperson = '".$result['id']."' and logi_user.Created != '".$curr_date."'group by  retailer_check_in_out.retailer "    ; 
      $Retailer = $this->db->fetchAll($Retailer); 
      $final_array = array();
      foreach ($Retailer as $results) {
       $created =  date('Y-m-d',strtotime($results['Created']));
       if (  $created != $curr_date) {
        $gRetailer = "select * from retailer_check_in_out where  date(timedate) = '".$curr_date."' AND status ='checkin' and retailer = '".$results['retailer']."'  ORDER BY timedate ASC limit 1"; 
        $Retailercheckin = $this->db->fetchRow($gRetailer); 

        $TagRetailer = "select * from retailer_check_in_out where  date(timedate) = '".$curr_date."' AND status ='checkout' and retailer = '".$results['retailer']."'  ORDER BY timedate desc limit 1"  ;
        $Retailercheckout = $this->db->fetchRow($TagRetailer);  
            // print_r();
            // $check_out_date_time =  $Retailercheckout['timedate']; 
        $check_in_date =  date('Y-m-d',strtotime($Retailercheckin['timedate']));
        $check_in_time =  date('H:i:s',strtotime($Retailercheckin['timedate']));
        $check_out_time =  date('H:i:s',strtotime($Retailercheckout['timedate']));
        $detail = array('id'=>$results['users_id'],'Retailer'=>$results['StaffName'],'address'=>$results['Address_Curr'],'checkouttime'=>$check_out_date_time,'checkintimedate'=>$Retailercheckin['timedate'], 'checkintime'=>$check_in_time, 'check_out_time'=>$Retailercheckout['timedate'], 'check_in_date'=>$check_in_date);
        array_push($final_array, $detail);
    }

}
$sqlTagRetailer = "select logi_user.*, retailers_site_location.created as added_date from logi_user left join retailers_site_location on (retailers_site_location.retailer_id = logi_user.id) where date(logi_user.Created) = '".$curr_date."' and logi_user.parent_sale = '".$params['id']."'";
$addRetailer = $this->db->fetchAll($sqlTagRetailer); 




$this->view->addRetailer = $addRetailer;

$this->view->final_array = $final_array;
print_r($addRetailer);

exit;
}



public function addCategoryAction(){

   $this->checklogin();
   $this->view->messages  = $this->_flashMessenger->getMessages();
   $db      =  $this->db = Zend_Db_Table::getDefaultAdapter();
   $params  = $this->view->params = $this->getRequest()->getParams();


   if($this->getRequest()->isPost()){

     $checkCategory = "select * from tbl_customer_category where category_name = '".$params['category_name']."'";
     $resCategory = $db->fetchRow($checkCategory);

     if($resCategory){
        $this->_flashMessenger->addMessage('Category already exist!'); 
        $this->_redirect('/master/add-category');
    }
    else{
        $dataArray = array();
        $dataArray['category_name']          = $params['category_name'];
        $db->insert('tbl_customer_category',$dataArray); 
        $this->_flashMessenger->addMessage('Record has been successfully Added!'); 
        $this->_redirect('/master/view-category');
    }


}       
}
public function updateCategoryAction(){
    try{
       $this->checklogin();
       $this->view->messages  = $this->_flashMessenger->getMessages();
       $db      =  $this->db = Zend_Db_Table::getDefaultAdapter();
       $params  = $this->view->params = $this->getRequest()->getParams();
       $sql = "select * from tbl_customer_category where id='".$params['datacode']."'";
       $this->view->list = $list = $db->fetchRow($sql);

       if($this->getRequest()->isPost()){

          $dataArray = array();
          $dataArray['category_name']          = $params['category_name'];

          $db->update('tbl_customer_category',$dataArray,array('id=?'=>$params['category_id'])); 

          $this->_flashMessenger->addMessage('Record has been successfully updated!'); 
          $this->_redirect('/master/view-category');


      }  
  }
  catch(Exception $e) {
      echo 'Message: ' .$e->getMessage();
  }        
}
public function deleteCatAction(){
   try{
      $this->checklogin();
      $db = $this->db = Zend_Db_Table::getDefaultAdapter();;
      $auth = Zend_Auth::getInstance();
      $authStorage = $auth->getStorage();
      $params = $this->view->params = $this->getRequest()->getParams();
            // print_r($params['status']);
            // exit;
            // $sq2 = "select* from tbl_customer_category where id = '".$params['datacode']."'"; 
            // $db->query($sq2);
      if($this->getRequest()->isPost()){


         $dataArr = array();
         $dataArr['status']          =$params['status']; 

         echo  $db->update('tbl_customer_category',$dataArr,array('id=?'=>$params['datacode'])); 

         $this->_flashMessenger->addMessage('Record has been successfully deleted!'); 


     } 
 }
 catch(Exception $e) {
  echo 'Message: ' .$e->getMessage();
}     

$this->_helper->layout()->disableLayout(); 
$this->_helper->viewRenderer->setNoRender(true);
}



public function checklogin(){   
   $auth = Zend_Auth::getInstance(); 
   $errorMessage = ""; 
   /*************** check user identity ************/
   if(!$auth->hasIdentity()){
      $this->_redirect('admin/index');  
  }   
}     
}