<?php


/***************************************************************
 * Logimetrix Techsolutions Pvt. Ltd.
 * File Name   : SearchAitController.php
 * File Description  : SearchAitController
 * Created By : Deeksha
 * Created Date: 9 Feb 2018
 ***************************************************************/

class MapAreaController extends Zend_Controller_Action{
  var $dbAdapter;
  var $db;

  public function init(){
    /* Initialize action controller here */
    $this->_flashMessenger  = $this->_helper->getHelper('FlashMessenger');
    $this->initView();
    $bootstrap              = $this->getInvokeArg('bootstrap');
    $aConfig                = $bootstrap->getOptions();
    $this->db               = Zend_Db_Table::getDefaultAdapter();
    $auth                   = Zend_Auth::getInstance();
    $authStorage            = $auth->getStorage();
    $this->WebLoginID       = $authStorage->read()->WebLoginID;
    $users                  = new Application_Model_Users();
    $logout_details         = $users->getUserLoginDetailByWebLoginCode($this->WebLoginID);
    $this->view->last_login = $logout_details['login_time'];  
    $this->mob="/^\d{10}$/";              
  }

  /** view manager details by viewManagerAction() created by Ajay Kumar **/
  public function indexAction(){

    $this->checklogin();
    $db = $this->db         = Zend_Db_Table::getDefaultAdapter();
    $auth           = Zend_Auth::getInstance();
    $this->view->params     = $params = $this->getRequest()->getParams();
    
    if($params['loginId']){
      $cond = "AND LoginID = '".$params['loginId']."'";
    }

    if($params['StaffName']){
     $cond .= "AND StaffName like '%".$params['StaffName']."%'";
   }

   if($params['MobileNo']){
     $cond .= "AND MobileNo  =   '".$params['MobileNo']."'";
   } 

   // $sql = "SELECT id, LoginID, StaffName, MobileNo, ver, parent_id FROM logi_users WHERE 1 $cond AND  Role = 'subfranchise' ";
   // $this->view->getSubFranchiseList = $getSubFranchiseList = $this->db->fetchAll($sql);

 }

 public function viewUserMappingAction(){

   $this->checklogin();
   $db                         = $this->db;
   $auth                       = Zend_Auth::getInstance();
   $authStorage                = $auth->getStorage();
   $params                     = $this->getRequest()->getParams();
   $this->view->messages       = $this->_flashMessenger->getMessages(); 
   $users                      = new Application_Model_Users();
   $this->Role                 = $authStorage->read()->Role;
   $this->id                   = $authStorage->read()->id;
   $this->view->params         = $params;
   $this->view->stateList      = $stateList = $users->getAllState();

   if($params['sub_fre_id']){ 
     $sql = " SELECT am.state_id, s.state_name, am.district_id, d.district_name, am.tehshil_id, t.tehshil_name, am.block_id , b.block_name, am.village_id, v.village_name FROM logi_area_mapping AS am
     LEFT JOIN logi_state_detail AS s ON (am.state_id = s.id) 
     LEFT JOIN logi_district_detail AS d ON (d.id = am.district_id) 
     LEFT JOIN logi_theshil_detail AS t ON (am.tehshil_id = t.id) 
     LEFT JOIN logi_block_detail AS b ON (b.id = am.block_id) 
     LEFT JOIN logi_village_detail AS v ON (v.id = am.village_id) WHERE am.sub_fre_id = '".$params['sub_fre_id']."'";
     $this->view->areaMapping = $areaMapping = $db->fetchAll($sql);
   }

   $query = "SELECT StaffName AS sub_fre_name FROM logi_users WHERE id = '".$params['sub_fre_id']."' AND Role = 'subfranchise' ";
   $subfranchiseName = $db->fetchRow($query);

   if($this->getRequest()->isPost()){

    $data = array();
    $data['state_id']      = $params['state_id'];
    $data['district_id']   = $params['district_id'];
    $data['tehshil_id']    = $params['tehsil_id'];
    $data['block_id']      = $params['block_id'];
    $data['village_id']    = $params['vill_id'];
    $data['sub_fre_id']    = $params['sub_fre_id'];
    $data['status']        = '1';
    $data['created_at']    = date('Y-m-d H:i:s');

    $db->insert('logi_area_mapping', $data);
    $this->_flashMessenger->addMessage('Mapping successfully saved.');
    $this->_redirect("/map-area/view-user-mapping/sub_fre_id/".$params['sub_fre_id']);

  }
}

public function addDetailsAction(){

  $this->view->messages = $this->_flashMessenger->getMessages();             
  $db = $this->db = Zend_Db_Table::getDefaultAdapter();
  $this->view->params = $params = $this->getRequest()->getParams();

  $district = array();

  $district['state_id']      = $params['state_id'];
  $district['district_name'] = $params['district_name'];
  $district['status']        = '1';

  $db->insert('logi_district_detail', $district);
  $last_district_id = $db->lastInsertId(); 

  $tehsil = array();

  $tehsil['state_id']        = $params['state_id'];
  $tehsil['district_id']     = $last_district_id;
  $tehsil['tehshil_name']    = $params['tehsil_name'];
  $tehsil['status']          = '1';
  
  $db->insert('logi_theshil_detail', $tehsil);
  $last_tehsil_id = $db->lastInsertId();

  $block = array();

  $block['state_id']        = $params['state_id'];
  $block['district_id']     = $last_district_id;
  $block['tehshil_id']      = $last_tehsil_id;
  $block['block_name']      = $params['block_name'];
  $block['status']          = '1';
  
  $db->insert('logi_block_detail', $block);
  $last_block_id = $db->lastInsertId();


  $village = array();

  $village['state_id']        = $params['state_id'];
  $village['district_id']     = $last_district_id;
  $village['tehshil_id']      = $last_tehsil_id;
  $village['block_id']        = $last_block_id;
  $village['village_name']    = $params['village_name'];
  $village['status']          = '1';

  $db->insert('logi_village_detail', $village);
  $last_village_id = $db->lastInsertId();

  $areaMapping = array();

  $areaMapping['state_id']        = $params['state_id'];
  $areaMapping['district_id']     = $last_district_id;
  $areaMapping['tehshil_id']      = $last_tehsil_id;
  $areaMapping['block_id']        = $last_block_id;
  $areaMapping['village_id']      = $last_village_id;
  $areaMapping['sub_fre_id']      = $params['sub_fre_id'];
  $areaMapping['status']          = '1';
  
  $db->insert('logi_area_mapping', $areaMapping);

  $this->_flashMessenger->addMessage('Details Added successfully.');
  $this->_redirect("/map-area/view-user-mapping/sub_fre_id/".$params['sub_fre_id']);


}

public function getDistrictByStateAction(){
  $params = $this->view->params = $this->getRequest()->getParams();

  $users = new Application_Model_Users();
  $dis_list_unformat = $users->getLogiDistrictByState($params['state_id']);
  $dis_list[] = array("value"=>"",'text'=>"--Select District--");
  foreach($dis_list_unformat as $single){
    $dis_list[] = array("value"=>$single['id'],"text"=>$single['district_name']);
  }

  $this->getHelper('Layout')->disableLayout();
  $this->getHelper('ViewRenderer')->setNoRender();
  $this->getResponse()->setHeader('Content-Type', 'application/json');
  echo json_encode(array('options'=>$dis_list));
  return; 

}

public function getAlltehsilByDistrictAction(){
  $district_id =  $this->_getParam('district_id'); 
  $users = new Application_Model_Users();
  $teh_list_unformat = $users->geLogitAllTehsilByDistrictID($district_id);
  $teh_list[] = array("value"=>"",'text'=>"--Select Tehsil--");
  foreach($teh_list_unformat as $single){
    $teh_list[] = array("value"=>$single['id'],"text"=>$single['tehshil_name']);
  }
  $this->getHelper('Layout')->disableLayout();
  $this->getHelper('ViewRenderer')->setNoRender();
  $this->getResponse()->setHeader('Content-Type', 'application/json');
  echo json_encode(array('options'=>$teh_list));
  return; 

}

public function getAllblockByTehsilAction(){
  $tehsil_id =  $this->_getParam('tehsil_id'); 
  $users = new Application_Model_Users();
  $block_list_unformat = $users->getLogiAllBlockByTehsil($tehsil_id);
  $block_list[] = array("value"=>"",'text'=>"--Select Block--");
  foreach($block_list_unformat as $single){
    $block_list[] = array("value"=>$single['id'],"text"=>$single['block_name']);
  }
  $this->getHelper('Layout')->disableLayout();
  $this->getHelper('ViewRenderer')->setNoRender();
  $this->getResponse()->setHeader('Content-Type', 'application/json');
  echo json_encode(array('options'=>$block_list));
  return;
}

public function getAllvillageByTehsilAction(){
  $block_id =  $this->_getParam('block_id'); 

  $users = new Application_Model_Users();
  $villageList = $users->getLogiAllVillageListByTehsilID($block_id);

  $vill_list[] = array("value"=>"",'text'=>"--Select Village--");
  foreach($villageList as $single){
    $vill_list[] = array("value"=>$single['id'],"text"=>$single['village_name']);
  }
        // echo '<pre>';print_r($villageList);exit();
  $this->getHelper('Layout')->disableLayout();
  $this->getHelper('ViewRenderer')->setNoRender();
  $this->getResponse()->setHeader('Content-Type', 'application/json');
  echo json_encode(array('options'=>$vill_list));
  return; 
}

/** check user login by checklogin() created by Ajay Kumar **/ 
public function checklogin(){   
  $auth       = Zend_Auth::getInstance(); 
  $errorMessage = ""; 
  /*************** check user identity ************/
  if(!$auth->hasIdentity()){
    $this->_redirect('/admin/index');  
  }   
}     

}

?>