<?php


class LocationController extends Zend_Controller_Action{
  var $dbAdapter;
  var $db;
  public function init(){
   /* Initialize action controller here */
   $this->_flashMessenger  = $this->_helper->getHelper('FlashMessenger');
   $bootstrap = $this->getInvokeArg('bootstrap');
   $aConfig = $bootstrap->getOptions();
   $this->db = Zend_Db_Table::getDefaultAdapter();
   $auth = Zend_Auth::getInstance();
   $authStorage = $auth->getStorage();
   $this->WebLoginID = $authStorage->read()->WebLoginID;
   $users = new Application_Model_Users();
   $logout_details = $users->getUserLoginDetailByWebLoginCode($this->WebLoginID);
   $this->view->last_login = $logout_details['login_time'];               
 }

 public function indexAction(){

   $this->checklogin();
   $params = $this->view->params = $this->getRequest()->getParams();
   $this->view->messages = $this->_flashMessenger->getMessages();

   $db = $this->db = Zend_Db_Table::getDefaultAdapter();

   $loc_query = "SELECT * FROM logi_location where status = 1";
   $this->view->loc_result = $loc_result = $db->fetchAll($loc_query);

   $page=$this->_getParam('page',1);
   $paginator = Zend_Paginator::factory($loc_result);      
             $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
             $paginator->setItemCountPerPage(10); // number of items to show per page
             $this->view->paginator = $paginator;
             $this->view->totalrec = $paginator->getTotalItemCount();
           }

           public function addNewLocationAction(){
            $this->checklogin();
            $db = $this->db = Zend_Db_Table::getDefaultAdapter();
            $this->view->messages = $this->_flashMessenger->getMessages();

            $this->view->params = $params = $this->getRequest()->getParams();
            
            $auth = Zend_Auth::getInstance();
            $authStorage = $auth->getStorage();

            if($this->getRequest()->isPost()){ 

              $location = array();
              $location['location_name'] = $params['location_name'];
              $location['latitude'] = $params['latitude'];
              $location['longitude'] = $params['longitude'];

              $db->insert('logi_location', $location);

              $location_id = $db->lastInsertId();


              $this->_flashMessenger->addMessage('Location Detail added successfully.');
              
              $this->_redirect("/location"); 
            }        
          }



          public function editLocationAction(){
            $this->checklogin();
            $db = $this->db = Zend_Db_Table::getDefaultAdapter();
            
            
            $auth = Zend_Auth::getInstance();
            $authStorage = $auth->getStorage();
            
            $db = $this->db = Zend_Db_Table::getDefaultAdapter();
            $this->view->messages = $this->_flashMessenger->getMessages();

            $this->view->params = $params = $this->getRequest()->getParams('id');


            $location_query = "SELECT * FROM logi_location WHERE id = '".$params['id']."' ";
            $this->view->location_result = $location_result = $db->fetchRow($location_query);            

            if($this->getRequest()->isPost()){
              $location = array();
              $location['location_name'] = $params['location_name'];   
              $location['latitude'] = $params['latitude'];   
              $location['longitude'] = $params['longitude'];   
              $db->update('logi_location', $location, array('id=?'=>$params['id'])); 

              $this->_flashMessenger->addMessage('Location Detail(s) updated successfully.');
              
              $this->_redirect('/location');

            }        
          }

          public function deleteLocationAction(){ 

            $db = $this->db = Zend_Db_Table::getDefaultAdapter();
            $this->view->params = $params = $this->getRequest()->getParams('id');
            $location = "update logi_location set  status='0' where id = '".$params['id']."'";
            $db->query($location);
            $this->_helper->layout()->disableLayout(); 
            $this->_helper->viewRenderer->setNoRender(true);
            $this->view->successMessage = "Location Detail(s) deleted successfully.";
            $this->_redirect('/location/');     
          }

          public function checklogin(){   
            $auth = Zend_Auth::getInstance(); 
            $errorMessage = ""; 
            /*************** check user identity ************/
            if(!$auth->hasIdentity()){
              $this->_redirect('admin/index');  
            }   
          }     
        }