<?php

/***************************************************************
 * Logimetrix Techsolutions Pvt. Ltd.
 * File Name   : IndentController.php
 * File Description  : IntentController
 * Created By : Puneet Mishra 
 * Created Date: 22 Nov 2017 
 ***************************************************************/

class IndentController extends Zend_Controller_Action{
	var $dbAdapter;
	var $db;
	public function init(){
		/* Initialize action controller here */
		$bootstrap = $this->getInvokeArg('bootstrap');
		$aConfig = $bootstrap->getOptions();
		$this->db = Zend_Db_Table::getDefaultAdapter();
		$auth = Zend_Auth::getInstance();
		$authStorage = $auth->getStorage();
	}

	public function orderIndentAction(){
		$this->checklogin();
		$this->db           = Zend_Db_Table::getDefaultAdapter();
		$db                 = $this->db;
		$auth               = Zend_Auth::getInstance();
		$authStorage        = $auth->getStorage();  
        //$this->LoginID      = $authStorage->read()->LoginID;
		$this->role = $role = $authStorage->read()->Role;
		$this->id   = $id   = $authStorage->read()->id;
		$params = $this->view->params = $this->getRequest()->getParams(); 

		$curr_date  = date("Y-m-d");
		$curr_date_time = date('Y-m-d h:i:s');

		$sql_user   = "Select * from logi_user where Role = 'retailer' ";               
		$this->view->user_data_array = $user_data_array  =  $this->db->fetchAll($sql_user);

		$sql_area   = "Select * from logi_location where status = '1' order by location_name";               
		$this->view->area_data_array = $area_data_array  =  $this->db->fetchAll($sql_area);

		$product_data   = array();
		$sql_product    = "select * from logi_product order by priority";
		$res_product    = $db->fetchAll($sql_product);
		foreach($res_product as $product_detail){
			$singal_product_detail   = $product_detail['product_name'].'_product_array';
			$singal_product_detail   = array();
			$sql_sub_product         = "select * from sub_product where product_id = '".$product_detail['id']."'";
			$res_sub_product         = $db->fetchAll($sql_sub_product);
			$product_detail['sub_products'] = $res_sub_product;
			array_push($product_data, $product_detail);
		}		
		$this->view->product_data    = $product_data;
		$this->view->user_data_array = $user_data_array;

		if ($this->getRequest()->isPost()) {
			$i = 0;
			foreach ($params['product'] as $key => $product_data) {
				$sqlSubProduct    = "select * from sub_product where id = '".$params['product'][$i]."'";
				$subProductResult = $db->fetchRow($sqlSubProduct);

				$sqlUser          = "select * from logi_user where id = '".$params['retailer_id'][$i]."'";
				$userResult       = $db->fetchRow($sqlUser);

				$indent_data = array();
				$indent_data['product_id']      = $subProductResult['product_id'];
				$indent_data['sub_product_id']  = $params['product'][$i];
				$indent_data['qty']             = $params['qty'][$i];
				$indent_data['crates']          = $parmas['qty'][$i]/$subProductResult['pouch_per_crate'];
				$indent_data['distributor_id']  = $userResult['parent_distributer'];
				$indent_data['retailer_id']     = $params['retailer_id'][$i];
				$indent_data['remark']          = $params['remarks'][$i];
				$indent_data['generated_date']  = $curr_date_time;
				$db->insert('tbl_order_indent', $indent_data);
				$i++;
			}

			$j = 0;
			foreach(array_unique($params['retailer_id']) as $indent_retailer_data){
				$remark_data = array();
				$remark_data['retailer_id']     = $indent_retailer_data;
				$remark_data['remark']          = $params['remarks'][$j];
				$remark_data['created_at']      = $curr_date_time;
				$db->insert('tbl_indent_remark', $remark_data);   
				$j++;      
			}
			$this->view->successMessage = "Order indent generated successfully.";
		}
	}

	public function getAreaWiseOrderIndentAction(){
		$this->checklogin();
		$this->db           = Zend_Db_Table::getDefaultAdapter();
		$db                 = $this->db;
		$auth               = Zend_Auth::getInstance();
		$authStorage        = $auth->getStorage();  
		$this->_helper->layout()->disableLayout();
		$this->role         = $role = $authStorage->read()->Role;
		$this->id           = $id   = $authStorage->read()->id;
		$params = $this->view->params = $this->getRequest()->getParams(); 

		$curr_date  = date("Y-m-d");
		$sql_user   = "Select * from logi_user where Role = 'retailer' and area_id = '".$params['area_id']."'";  

		$this->view->user_data_array = $user_data_array  =  $this->db->fetchAll($sql_user);

		$product_data   = array();
		$sql_product    = "select * from logi_product order by priority";
		$res_product    = $db->fetchAll($sql_product);
		foreach($res_product as $product_detail){
			$singal_product_detail   = $product_detail['product_name'].'_product_array';
			$singal_product_detail   = array();
			$sql_sub_product         = "select * from sub_product where product_id = '".$product_detail['id']."'";
			$res_sub_product         = $db->fetchAll($sql_sub_product);
			$product_detail['sub_products'] = $res_sub_product;
			array_push($product_data, $product_detail);
		}		
		$this->view->product_data    = $product_data;
		
	}

	public function editOrderIndentAction(){
		$this->checklogin();
		$this->db           = Zend_Db_Table::getDefaultAdapter();
		$db                 = $this->db;
		$auth               = Zend_Auth::getInstance();
		$authStorage        = $auth->getStorage();  
        //$this->LoginID      = $authStorage->read()->LoginID;
		$this->role = $role = $authStorage->read()->Role;
		$this->id   = $id   = $authStorage->read()->id;
		$params = $this->view->params = $this->getRequest()->getParams(); 

		$curr_date = date('Y-m-d');
		$curr_date_time = date('Y-m-d h:i:s');

		$sql_area   = "Select * from logi_location where status = '1' order by location_name";               
		$this->view->area_data_array = $area_data_array  =  $this->db->fetchAll($sql_area);

		if ($this->getRequest()->isPost()) {
			$delete_indent = "delete from tbl_order_indent where date(generated_date) = '".$curr_date."'";
			$db->query($delete_indent);

			$delete_indent_remark = "delete from tbl_indent_remark where date(created_at) = '".$curr_date."'";
			$db->query($delete_indent_remark);

			$i = 0;
			foreach ($params['product'] as $key => $product_data) {
				$sqlSubProduct    = "select * from sub_product where id = '".$params['product'][$i]."'";
				$subProductResult = $db->fetchRow($sqlSubProduct);

				$sqlUser          = "select * from logi_user where id = '".$params['retailer_id'][$i]."'";
				$userResult       = $db->fetchRow($sqlUser);

				$indent_data = array();
				$indent_data['product_id']      = $subProductResult['product_id'];
				$indent_data['sub_product_id']  = $params['product'][$i];
				$indent_data['qty']             = $params['qty'][$i];
				$indent_data['crates']          = $parmas['qty'][$i]/$subProductResult['pouch_per_crate'];
				$indent_data['distributor_id']  = $userResult['parent_distributer'];
				$indent_data['retailer_id']     = $params['retailer_id'][$i];
				$indent_data['remark']          = $params['remarks'][$i];
				$indent_data['generated_date']  = $curr_date_time;

				$db->insert('tbl_order_indent', $indent_data);
				$i++;
			}

			$j = 0;
			foreach(array_unique($params['retailer_id']) as $indent_retailer_data){
				$remark_data = array();
				$remark_data['retailer_id']     = $indent_retailer_data;
				$remark_data['remark']          = $params['remarks'][$j];
				$remark_data['created_at']      = $curr_date_time;
				$db->insert('tbl_indent_remark', $remark_data);   
				$j++;      
			}
			$this->view->successMessage = "Order indent updated successfully.";
		}
	}

	public function getGeneratedOrderIndentAction(){
		$this->checklogin();
		$this->db           = Zend_Db_Table::getDefaultAdapter();
		$db                 = $this->db;
		$auth               = Zend_Auth::getInstance();
		$authStorage        = $auth->getStorage();  
        //$this->LoginID      = $authStorage->read()->LoginID;
		$this->role = $role = $authStorage->read()->Role;
		$this->id   = $id   = $authStorage->read()->id;
		$params = $this->view->params = $this->getRequest()->getParams();
		$this->_helper->layout()->disableLayout(); 

		$curr_date = date('Y-m-d');
		$user_final_array = array();
		$curr_date  = date("Y-m-d");

		$product_data   = array();
		$sql_product    = "select * from logi_product order by priority";
		$res_product    = $db->fetchAll($sql_product);
		foreach($res_product as $product_detail){
			$singal_product_detail   = $product_detail['product_name'].'_product_array';
			$singal_product_detail   = array();
			$sql_sub_product         = "select * from sub_product where product_id = '".$product_detail['id']."'";
			$res_sub_product         = $db->fetchAll($sql_sub_product);
			$product_detail['sub_products'] = $res_sub_product;
			array_push($product_data, $product_detail);
		}

		$sql_user   = "Select * from logi_user where Role = 'retailer' and area_id = '".$params['area_id']."'";               
		$user_data_array  =  $this->db->fetchAll($sql_user);

		foreach($user_data_array as $user_data){
			$sql_order_product_indent = "select product_id  from tbl_order_indent where retailer_id = '".$user_data['id']."' and date(generated_date) = '".$curr_date."' group by product_id";
			$result_order_product_indent  =  $this->db->fetchAll($sql_order_product_indent);

			$product_array = array();
			foreach($result_order_product_indent as $product_detail){
				$sql_order_indent = "select sub_product_id, qty, remark  from tbl_order_indent where retailer_id = '".$user_data['id']."' and date(generated_date) = '".$curr_date."' and product_id = '".$product_detail['product_id']."'";
				$result_order_indent  =  $this->db->fetchAll($sql_order_indent);
				$product_detail = array('product'=>$product_detail['product_id'], 'sub_product_detail'=>$result_order_indent);
				array_push($product_array, $product_detail);

			}
			$get_remark = "select remark from tbl_indent_remark where retailer_id = '".$user_data['id']."' and date(created_at) = '".$curr_date."'";
			$remark_result = $this->db->fetchRow($get_remark);

			$detail = array('id'=>$user_data['id'], 'StaffName'=>$user_data['StaffName'], 'MobileNo'=>$user_data['MobileNo'], 'Address_Curr'=>$user_data['Address_Curr'], 'order_indent_detail'=>$product_array, 'remark'=>$remark_result['remark']);
			array_push($user_final_array, $detail);
		}
		$this->view->product_data     = $product_data;
		$this->view->user_final_array = $user_final_array;
	}

	public function orderIndentReportAction(){
		$this->checklogin();
		$this->db           = Zend_Db_Table::getDefaultAdapter();
		$db                 = $this->db;
		$auth               = Zend_Auth::getInstance();
		$authStorage        = $auth->getStorage();  
        //$this->LoginID      = $authStorage->read()->LoginID;
		$this->role = $role = $authStorage->read()->Role;
		$this->id   = $id   = $authStorage->read()->id;
		$params = $this->view->params = $this->getRequest()->getParams(); 

		$curr_date = date('Y-m-d');
		$user_final_array = array();
		$curr_date  = date("Y-m-d");

		$product_data   = array();
		$sql_product    = "select * from logi_product order by priority";
		$res_product    = $db->fetchAll($sql_product);
		foreach($res_product as $product_detail){
			$singal_product_detail   = $product_detail['product_name'].'_product_array';
			$singal_product_detail   = array();
			$sql_sub_product         = "select * from sub_product where product_id = '".$product_detail['id']."'";
			$res_sub_product         = $db->fetchAll($sql_sub_product);
			$product_detail['sub_products'] = $res_sub_product;
			array_push($product_data, $product_detail);
		}
		$sql_user   = "Select * from logi_user where Role = 'retailer' ";               
		$user_data_array  =  $this->db->fetchAll($sql_user);

		foreach($user_data_array as $user_data){
			$sql_order_product_indent = "select product_id  from tbl_order_indent where retailer_id = '".$user_data['id']."' and date(generated_date) = '".$curr_date."' group by product_id";
			$result_order_product_indent  =  $this->db->fetchAll($sql_order_product_indent);

			$product_array = array();
			foreach($result_order_product_indent as $product_detail){
				$sql_order_indent = "select sub_product_id, qty  from tbl_order_indent where retailer_id = '".$user_data['id']."' and date(generated_date) = '".$curr_date."' and product_id = '".$product_detail['product_id']."'";
				$result_order_indent  =  $this->db->fetchAll($sql_order_indent);
				$product_detail = array('product'=>$product_detail['product_id'], 'sub_product_detail'=>$result_order_indent);
				array_push($product_array, $product_detail);

				$get_remark = "select remark from tbl_indent_remark where retailer_id = '".$user_data['id']."' and date(created_at) = '".$curr_date."'";
				$remark_result = $this->db->fetchRow($get_remark);
			}
			$detail = array('id'=>$user_data['id'], 'StaffName'=>$user_data['StaffName'], 'MobileNo'=>$user_data['MobileNo'], 'Address_Curr'=>$user_data['Address_Curr'], 'order_indent_detail'=>$product_array, 'remark'=>$remark_result['remark']);
			array_push($user_final_array, $detail);
		}
		$this->view->product_data     = $product_data;
		$this->view->user_final_array = $user_final_array;
	}

	public function checklogin(){   
		$auth = Zend_Auth::getInstance(); 
		$errorMessage = ""; 
		/*************** check user identity ************/
		if(!$auth->hasIdentity()){
			$this->_redirect('admin/index');  
		}   
	}     
}
