<?php
/***************************************************************
 * Logimetrix Tech Solutions Pvt. Ltd.
 * File Name   : AccountSettingController.php
 * File Description  : Account Settings
 * Created By : Abhishek Kumar Mishra
 * Created Date: 20 June 2015
 ***************************************************************/
class GstController extends Zend_Controller_Action{
	public function init(){
		/* Initialize action controller here */
		$bootstrap = $this->getInvokeArg('bootstrap');
		$aConfig = $bootstrap->getOptions();
		$this->view->siteurl = $aConfig['site']['image']['url'];
		$this->dbAdapter = Zend_Db_Table::getDefaultAdapter(); 
		$auth = Zend_Auth::getInstance();
		$authStorage = $auth->getStorage();
		if(isset($authStorage->read()->StaffCode)){
			$this->StaffCode = $authStorage->read()->StaffCode;
			$this->role = $authStorage->read()->role;
		}
		$users = new Application_Model_Users();
	}

	public function addGstAction(){
		try{
			$db = $this->db=Zend_Db_Table::getDefaultAdapter();
			$params = $this->getRequest()->getParams();
            // $this->view->messages = $this->_flashMessenger->getMessages();
            // $dbAdapter = $this->dbAdapter;
			$this->view->$params = $params = $this->getRequest()->getParams(); 
			if($this->getRequest()->isPost()) {
				$gstlist= array();                                           
				$gstlist['gst_slab_from'] = $params['gst_from']; 
				$gstlist['gst_slab_to'] = $params['gst_to']; 
				$gstlist['gst_rate'] = $params['price_off']; 
		        // print_r($gstlist);
		        // exit();
				$this->dbAdapter->insert('tbl_gst_slab', $gstlist);
                // $this->_flashMessenger->addMessage('Data has been successfully saved');
				$this->_redirect('/gst/gst-slab');
			}
		}catch(Exception $e){
			echo $e->getMessage();
			exit;
		}
	}

	public function deleteGstAction(){
		$db = $this->db = Zend_Db_Table::getDefaultAdapter();
		$this->view->params = $params = $this->getRequest()->getParams('id');
		
		$where = array();      
		$where[] = $this->dbAdapter->quoteInto('id=?',$params['id']);
		$gst_result =  $this->db->delete('tbl_gst_slab',$where);
        // print_r($gst_result);
         // exit();
		$this->view->successMessage = "GST deleted successfully.";
		$this->_redirect('/gst/gst-slab');    
	}

	public function editGstAction(){
		$params = $this->getRequest()->getParams();
		try{
			$gstsql = "SELECT * FROM `tbl_gst_slab` WHERE id='".$params['id']."'";
			$gstrecord = $this->dbAdapter->fetchRow($gstsql);
			if($gstrecord){
				$this->view->gstrecord = $gstrecord;
			}else{
				$this->_redirect('/gst/gst-slab');    
			}
			if($this->getRequest()->isPost()){
				$gstdata= array();                                           
				$gstdata['gst_slab_from'] = $params['gst_from']; 
				$gstdata['gst_slab_to'] = $params['gst_to']; 
				$gstdata['gst_rate'] = $params['price_off']; 
				$where = array('id = ?' => $params['id']);
				$this->dbAdapter->update('tbl_gst_slab',$gstdata, $where);
				$this->_redirect('/gst/gst-slab');
			}
		}catch(Exception $e){
			echo $e->getMessage();
			exit;
		}
		// print_r($gstdata);
		// exit();
	}

	public function gstSlabAction(){
		try{
			$params = $this->getRequest()->getParams();
			$this->view->totalnum   = $params['page'];
			$gstsql = "SELECT id, CONCAT(gst_slab_from,'-',gst_slab_to) AS gstslab,gst_rate FROM `tbl_gst_slab` WHERE 1";
			$this->view->gstrecord = $gstrecord = $this->dbAdapter->fetchAll($gstsql);
			$page=$this->_getParam('page',1);
			$paginator = Zend_Paginator::factory($gstrecord);  
			$paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); 
			$paginator->setItemCountPerPage(10);
            // number of items to show per page
			$this->view->paginator = $paginator;
			$this->view->totalrec = $paginator->getTotalItemCount();   
		}
		catch(Exception $e){
			echo $e->getMessage();
			exit;
		}
	}

	public function gstRateBySlabAction(){
		$params = $this->getRequest()->getParams();
		
		$gstsql = "SELECT id, gst_rate FROM `tbl_gst_slab` WHERE id=".$params['gst_slab'];
		$gstrecord = $this->dbAdapter->fetchAll($gstsql);

		$option = "<option value=''>select Price</option>";
		foreach ($gstrecord as $record) {
			$option .= "<option value='".$record['gst_rate']."'>".$record['gst_rate']."</option>";
		}
		echo $option;
		exit;
	}
}
