<?php

class GmapController extends Zend_Controller_Action{
	var $db;

	public function init(){
		$this->db = Zend_Db_Table::getDefaultAdapter();
		$admin = new Application_Model_Admin($params);
		$auth = Zend_Auth::getInstance();
		$authStorage = $auth->getStorage();
		if($role=='cust'){
			$this->_helper->viewRenderer->setNoRender(true);
			$this->_helper->layout()->disableLayout();
			$this->_redirect('/index');
		}
		$this->role = $authStorage->read()->Role;
		$this->id   = $authStorage->read()->id;
	}
	
	public function trackAction(){
		$this->checklogin();
		$gmap = new Application_Model_Gmap();
		$auth = Zend_Auth::getInstance();
		$authStorage = $auth->getStorage();
		$role = $authStorage->read()->role;
		$StaffCodeMd5 = $authStorage->read()->StaffCodeMd5;

		$role = $this->role;
		$id   = $this->id;  
		if( $role =='super_admin'){
			$username =  $authStorage->read()->username;
		}
		if ($role == 'super_admin') {
			$user_cond .= "";
		}
		if ($role == 'RM') {
			$user_cond .= "and parent_regional_manager = '" . $id . "' ";
		}
		if ($role == 'ZM') {
			$user_cond .= "and parent_zonal_manager = '" . $id . "' ";
		}
		if ($role == 'ASM') {
			$user_cond .= "and parent_area_manager = '" . $id . "' ";
		}
		if ($role == 'Sales') {
			$user_cond .= "and parent_sale= '" . $id . "' ";
		}
		if($username =='mdpadmin'){
			$sql = "select * from logi_user where Role IN ('fsv') $user_cond order by StaffName";
		}
		else{
			$sql = "select * from logi_user where Role IN ('Sales', 'TSE','RM', 'ASM', 'ZM') $user_cond order by StaffName";
		}
		$res = $this->db->fetchAll($sql);
		$this->view->getUserList = $res;
		$this->view->role = $role;
	}
	public function trackTestAction(){
		$this->checklogin();
		$gmap = new Application_Model_Gmap();
		$auth = Zend_Auth::getInstance();
		$authStorage = $auth->getStorage();
		$role = $authStorage->read()->role;
		$StaffCodeMd5 = $authStorage->read()->StaffCodeMd5;

		$sql = "select * from logi_user where Role IN ('Sales', 'TSE')";
		$res = $this->db->fetchAll($sql);
		$this->view->getUserList = $res;
		$this->view->role = $role;
	}

	public function legendHelpAction(){
		$this->_helper->layout->disableLayout();
	}
	
	public function trackAllAction(){
		$this->checklogin();
		$gmapModel = new Application_Model_Gmap();
		$this->view->productTypeList = $gmapModel->productTypeList();
		$this->view->callTypeList = $gmapModel->callTypeList();
		$this->view->circleList = $gmapModel->circleList();
		$this->view->customerList = $gmapModel->customerList();	
	}

	public function customerAction(){
		$params = $this->getRequest()->getParams();
		$gmapModel = new Application_Model_Gmap();

		$joballdata = $gmapModel->getCustomerAllJobs($params);		
		$this->view->jobs = $joballdata; 

		foreach($joballdata as $single_job){
			$user_list[$single_job['curr_Alloted_Eng_Code']] = $single_job['curr_Alloted_Eng_Code'];
		}

		$allUsersLocation = $gmapModel->getUsersCurrentLoc($user_list);
		$this->view->users = $allUsersLocation;
		$this->view->params = $params; 
		$this->_helper->layout->disableLayout();
	}


	public function indexTestAction(){
		$this->checklogin();
		$params = $this->getRequest()->getParams();
		$gmap = new Application_Model_Gmap();
		if(trim($params['user_staff_code'])!=''){
			$this->view->user_staff_code = $params['user'] = $params['user_staff_code'];
		}
		if($params['dates']!=''){
			$this->view->date = $date =	date('Y-m-d', strtotime($params['dates']));
		}else{
			$this->view->date = $date =	date("Y-m-d");
		}
		
		$sqlQuery = $this->db->select() ->from('user_path',array('*')) ->where('mob_user_staff_code =?',$params['user'])
		->where('lat !=?','0.00000000')
		->where(new Zend_Db_Expr('date_format(datetime,"%Y-%m-%d") ="'.$date.'"'))->order('datetime asc')->limit(1);
		
		//echo 'q:'.$sqlQuery->__toString();die;
		$result = $this->db->fetchRow($sqlQuery);
		$this->view->center_coord = $result; 		

		$sqlQuery = $this->db->select()->from('logi_user',array('*'))->where('LoginID =?',$params['user']);  
		//echo 'q:'.$sqlQuery->__toString();die;
		$result = $this->db->fetchRow($sqlQuery);
		$this->view->current_coord = $result; 
		$this->view->user = $params['user'];
		// $user = new Application_Model_Users();
		// $alldata = $user->getUserAllDataByStaffCode($params['user']);
		//print_r($alldata);		
		$joballdata = $gmap->getAllJobs($params['user_staff_code']);		
		$this->view->jobs = $joballdata; 
		echo $sq = $this->db->select() ->from('user_path',array('*')) ->where('mob_user_staff_code =?',$params['user'])
		->where('lat !=?','0.00000000')
		->where(new Zend_Db_Expr('date_format(datetime,"%Y-%m-%d") ="'. $date.'"'))->order('datetime desc')->limit(1);
		$this->view->resultlast = $resultlast = $this->db->fetchRow($sq); 

		$sqlQuery = $this->db->select() ->from('user_path',array('*')) ->where('mob_user_staff_code =?',$params['user'])
		->where('lat !=?','0.00000000')
		->where(new Zend_Db_Expr('date_format(datetime,"%Y-%m-%d") ="'. $date.'"'))->order('datetime asc')->limit(2000);
		$result = $this->db->fetchAll($sqlQuery);
		// print_r($result);
		// exit;
		$single_coord_array = array();
		foreach($result as $single_path_coord){
			$single_coord_array[] = 'new google.maps.LatLng('.$single_path_coord['lat'].', '.$single_path_coord['long'].')';
		}
		$single_coord_array[] = $single_coord_array[0];
		$path_coords = implode(',',$single_coord_array);
		$this->view->path_coords = $path_coords; 

		$this->view->single_path_coord = $result; 
		$this->_helper->layout->disableLayout();
	}
	
	public function indexAction(){

		$this->checklogin();
		$params = $this->getRequest()->getParams();
		$gmap = new Application_Model_Gmap();
		
		if(trim($params['user_staff_code'])!=''){
			$this->view->user_staff_code = $params['user'] = $params['user_staff_code'];
		}
		if($params['dates']!=''){
			$this->view->date = $date =	date('Y-m-d', strtotime($params['dates']));
		}else{
			$this->view->date = $date =	date("Y-m-d");
		}
		
		$sqlQuery = $this->db->select() ->from('user_path',array('*')) ->where('mob_user_staff_code =?',$params['user'])
		->where('lat !=?','0.00000000')
		->where(new Zend_Db_Expr('date_format(datetime,"%Y-%m-%d") ="'. $date.'"'))->order('datetime asc')->limit(1);

		$this->view->center_coord = $this->db->fetchRow($sqlQuery); 	

		$sqlQuery = $this->db->select()->from('logi_user',array('*'))->where('LoginID =?',$params['user']);  
		$this->view->current_coord = $user = $this->db->fetchRow($sqlQuery);

		$sq = $this->db->select() ->from('user_path',array('*')) ->where('mob_user_staff_code =?',$params['user'])
		->where('lat !=?','0.00000000')
		->where(new Zend_Db_Expr('date_format(time_spend,"%Y-%m-%d") ="'. $date.'"'))->order('id desc')->limit(1);
		$this->view->resultlast = $resultlast = $this->db->fetchRow($sq); 
		// print_r( $resultlast);

		$first = $this->db->select() ->from('user_path',array('*')) ->where('mob_user_staff_code =?',$params['user'])
		->where('lat !=?','0.00000000')
		->where(new Zend_Db_Expr('date_format(time_spend,"%Y-%m-%d") ="'. $date.'"'))->order('time_spend asc')->limit(1);
		$this->view->resultfirst = $resultfirst = $this->db->fetchRow($first); 

		$sql1 ="select count(id) as id from user_path where mob_user_staff_code = '".$params['user']."' and lat != '0.00000000' and date(time_spend) = '".$date."'" ; 
		$this->view->count  = $count = $this->db->fetchRow($sql1); 
		if ($count['id'] >= 23 ) {
			$value = round($count['id']/22);
		}
		else
		{
			$value = 1 ;
		}
		// echo $count['id'] ;
		$sqlQuery = $this->db->select() ->from('user_path',array('*')) ->where('mob_user_staff_code =?',$params['user'])
		->where('lat !=?','0.00000000')
		->where('id % "'.$value.'" = ?','0')
		->where(new Zend_Db_Expr('date_format(time_spend,"%Y-%m-%d") ="'. $date.'"'))->group('lat')->order('time_spend asc')->limit(2000); 
		$this->view->result  = $result = $this->db->fetchAll($sqlQuery); 


		$sqlQuery1 = $this->db->select() ->from('user_path',array('*')) ->where('mob_user_staff_code =?',$params['user'])
		->where('lat !=?','0.00000000')

		->where(new Zend_Db_Expr('date_format(time_spend,"%Y-%m-%d") ="'. $date.'"'))->group('lat')->order('time_spend asc')->limit(2000); 
		$this->view->result1  = $result1 = $this->db->fetchAll($sqlQuery1); 
		// echo "<pre>";
		// print_r($result);
		// exit;
		$single_coord_array = array();
		foreach($result as $single_path_coord){
			$single_coord_array[] = 'new google.maps.LatLng('.$single_path_coord['lat'].', '.$single_path_coord['long'].')';
		}

		$this->view->path_coords = $single_coord_array; 



		$firstgeo= $this->db->select() ->from('user_path',array('*')) ->where('mob_user_staff_code =?',$params['user'])
		->where('lat !=?','0.00000000')
		->where(new Zend_Db_Expr('date_format(time_spend,"%Y-%m-%d") ="'. $date.'"'))->order('time_spend asc')->limit(1);
		$this->view->firstgeoresult =$firstgeoresult = $this->db->fetchRow($firstgeo);
		

		$retailersSql = "SELECT logi_user.*,retailers_site_location.photograph1 FROM `logi_user` LEFT join retailers_site_location on retailers_site_location.retailer_id = logi_user.id where logi_user.parent_sale =".$user['id'];  
		$this->view->retailers = $retailers = $this->db->fetchAll($retailersSql);


		$this->_helper->layout->disableLayout();
	}

	public function loadGeoJsonAction(){
		$params = $this->getRequest()->getParams();
		$gmapModel = new Application_Model_Gmap();

		$joballdata = $gmapModel->getCustomerAllJobs($params);		
		$jobs = $joballdata; 
		$customer_tower_code = array('Indus Towers Limited'=>'cust-i', 'Bharti Airtel Limited'=> 'cust-b' );
		$customer_call_type_code = array('BD'=>'call-b', 'PM'=>'call-p');
		$customer_product_type_code = array('AC'=>'product-a','PIU'=>'product-p');	
		$jobs_json = array();
		$site_counts = 0;
		foreach($jobs as $single_job){ 
			$single_json_entry = array();
			$image = '';
			if(isset($customer_tower_code[$single_job['Customer_Name']]) && $customer_tower_code[$single_job['Customer_Name']]!=''){ $image .= $customer_tower_code[$single_job['Customer_Name']]; }else{ $image .= 'cust-o'; }
			$image .= '-';
			if(isset($customer_call_type_code[$single_job['Call_Type_Code']]) && $customer_call_type_code[$single_job['Call_Type_Code']]!=''){ $image .= $customer_call_type_code[$single_job['Call_Type_Code']]; }else{ $image .= 'call-o'; }
			$image .= '-';
			if(isset($customer_product_type_code[$single_job['product_type']]) && $customer_product_type_code[$single_job['product_type']]!=''){ $image .= $customer_product_type_code[$single_job['product_type']]; }else{ $image .= 'product-o'; }
			$image .= '.gif';
			$single_json_entry['icon']         = 'http://apps.acme.in:9030/images/map-icons/'.$image;
			$single_json_entry['cust_name']    = $single_job['Customer_Name'];
			$single_json_entry['site_id']      = $single_job['Site_ID'];
			$single_json_entry['call_type']    = $single_job['Call_Type_Code'];
			$single_json_entry['product_type'] = $single_job['product_type'];
			$single_json_entry['call_log_no']  = $single_job['Call_Log_No'];

			if($single_job['slm_latitude']     !='' && $single_job['slm_longitude'] !='' && $single_job['slm_longitude'] !='0.0'  && $single_job['slm_latitude'] !='0.0'){
				$single_json_entry['lat']       = $single_job['slm_latitude'];	 
				$single_json_entry['long']      = $single_job['slm_longitude'];

			}else if($single_job['site_latitude'] !='' && $single_job['site_longitude'] !='' && $single_job['site_latitude'] !='0.0'  && $single_job['site_longitude'] !='0.0'){ 
				$single_json_entry['lat'] = $single_job['site_latitude'];	 
				$single_json_entry['long'] = $single_job['site_longitude'];
			}
			if($single_json_entry['lat']!='' && $single_json_entry['long']!=''){
				$jobs_json[] = $single_json_entry;
				$site_counts++;
			}
		}
		foreach($joballdata as $single_job){
			$user_list[$single_job['curr_Alloted_Eng_Code']] = $single_job['curr_Alloted_Eng_Code'];
		}
	    //print_r($user_list);die;	
		$allUsersLocation = $gmapModel->getUsersCurrentLoc($user_list);
		$this->view->users = $allUsersLocation; 
		print 'var data = '.json_encode(array('site_count'=>$site_counts,'site_list'=>$jobs_json));
		die;	
	}

	public function checklogin(){
		$auth = Zend_Auth::getInstance();
		$errorMessage = ""; 
		/*************** check user identity ************/
		if(!$auth->hasIdentity())  {  
			$this->_redirect('admin/index');  
		} 
	}

	public function getUserByClusterAction(){ 
		$cluster_id =  $this->_getParam('cluster_id'); 
		$users = new Application_Model_Users();

		$user_list_unformat = $users->getEnggNameByClusterID($cluster_id);
		$user_list[] = array("value"=>"-",'text'=>"Staff Code");
		foreach($user_list_unformat as $single){
			if($single['StaffCode']==$cluster_id){
				continue;
			}
			$user_list[] = array("value"=>$single['StaffCode'],"text"=>$single['StaffName']."(StaffCode : ".$single['StaffCode'].")");
		}
		$this->getHelper('Layout')->disableLayout();
		$this->getHelper('ViewRenderer')->setNoRender();
		$this->getResponse()->setHeader('Content-Type', 'application/json');
		echo json_encode(array('options'=>$user_list));
		return;	
	}

	public function exportExcelAction(){
		$this->checklogin();
		$params = $this->getRequest()->getParams();
		$gmap = new Application_Model_Gmap();
		if(trim($params['user_staff_code'])!=''){
			$params['user'] = $params['user_staff_code'];
		}
		if($params['dates']!=''){
			$date =	date('Y-m-d', strtotime($params['dates']));
		}else{
			$date =	date("Y-m-d");
		}
		$sqlQuery = $this->db->select() ->from('user_path',array('*')) ->where('mob_user_staff_code =?',$params['user'])
		->where('lat !=?','0.00000000')
		->where(new Zend_Db_Expr('date_format(datetime,"%Y-%m-%d") ="'. $date.'"'))->order('datetime asc');

		//echo 'q:'.$sqlQuery->__toString();die;
		$result = $this->db->fetchAll($sqlQuery);
		// echo '<pre>';
		// print_r($result);
		// exit();
		$data = array(
			array(
				'Sr. No.'=> "",
				'User Id'=> "" , 
				'Latitude'=> "",
				'Longitude'=> "",
				'Address'=> "",
				'Date'=> "",
			));
		$i = 2; 
		foreach ($result as $rs) {
			$row = array();
			$row[] = stripslashes($i-1);
			$row[] = stripslashes($rs["mob_user_staff_code"]);
			$row[] = stripslashes($rs["lat"]);
			$row[] = stripslashes($rs["long"]);
			$row[] = stripslashes($rs["address"]);
			$row[] = stripslashes($rs["add_date_time"]);
			$data[] = $row;
			$i++;
		}
		function filterData(&$str){
			$str = preg_replace("/\t/", "\\t", $str);
			$str = preg_replace("/\r?\n/", "\\n", $str);
			if(strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
		}

       // file name for download
		$fileName = "user_track_report.xls"; 
                    // headers for download
		header("Content-Disposition: attachment; filename=\"$fileName\"");
		header("Content-Type: application/vnd.ms-excel");

		$flag = false;
		foreach($data as $row) {
			if(!$flag) {
                            // display column names as first row
				echo implode("\t", array_keys($row)) . "\n";
				$flag = true;
			}
                        // filter data
			array_walk($row, 'filterData');
			echo implode("\t", array_values($row)) . "\n";
		}
		exit;
	}
}



