<?php


class FarmerController extends Zend_Controller_Action{
	var $dbAdapter;
	var $db;
	public function init(){
		/* Initialize action controller here */
		$bootstrap = $this->getInvokeArg('bootstrap');
		$aConfig = $bootstrap->getOptions();
		$this->db = Zend_Db_Table::getDefaultAdapter();
		$auth = Zend_Auth::getInstance();
		$authStorage = $auth->getStorage();
		$this->WebLoginID = $authStorage->read()->WebLoginID;
		$users = new Application_Model_Users();
		$logout_details = $users->getUserLoginDetailByWebLoginCode($this->WebLoginID);
		$this->view->last_login = $logout_details['login_time'];               
	}

	public function indexAction(){
		$this->checklogin();
		$db = $this->db = Zend_Db_Table::getDefaultAdapter();
		$this->view->params = $params = $this->getRequest()->getParams();
		$auth = Zend_Auth::getInstance();
		$authStorage = $auth->getStorage();

		$farmer_query = "SELECT fr.id,fr.farmer_code,fr.farmer_name,fr.mobile_no,fr.address,l.StaffName,fr.farmer_status FROM tbl_farmer AS fr LEFT JOIN logi_user AS l ON (l.id = fr.user_id) WHERE deleted_status = 1";
		$farmer_result = $db->fetchAll($farmer_query);

		$page=$this->_getParam('page',1);
		$paginator = Zend_Paginator::factory($farmer_result);      
             $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
             $paginator->setItemCountPerPage(15); // number of items to show per page
             $this->view->paginator = $paginator;
             $this->view->totalrec = $paginator->getTotalItemCount();

             foreach ($farmer_result as $rs) {
             	if($rs["farmer_status"]=='active'){
             		$farmerstatus = 'Active';
             	}
             	if($rs["farmer_status"]=='inactive'){
             		$farmerstatus = 'Inactive';
             	}
             	$row = array();
             	$row[] = stripslashes($i-1);
             	$row[] = stripslashes($rs["farmer_code"]);
             	$row[] = stripslashes($rs["farmer_name"]);
             	$row[] = stripslashes($rs["mobile_no"]);
             	$row[] = stripslashes($rs["address"]);
             	$row[] = stripslashes($rs["StaffName"]);
             	$row[] = stripslashes($farmerstatus);
             	$data[] = $row;
             }
             function filterData(&$str){
             	$str = preg_replace("/\t/", "\\t", $str);
             	$str = preg_replace("/\r?\n/", "\\n", $str);
             	if(strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
             }

             $flag = false;
             foreach($data as $row) {
             	if(!$flag) {
                        // display column names as first row
             		echo implode("\t", array_keys($row)) . "\n";
             		$flag = true;
             	}
                    // filter data
             	array_walk($row, 'filterData');
             	echo implode("\t", array_values($row)) . "\n";
             }
             
         }

         public function activeFarmerAction(){
         	$db = $this->db = Zend_Db_Table::getDefaultAdapter();      
         	$this->view->params = $params = $this->getRequest()->getParams('id'); 
         	$where = array();  
         	$where['farmer_status'] = 'active';
         	$db->update('tbl_farmer', $where, array('id=?'=>$params['id']));     
         	$this->view->successMessage = "Active successfully.";               
         	$this->_redirect('/farmer/index/');
         }

         public function inactiveFarmerAction(){
         	$db = $this->db = Zend_Db_Table::getDefaultAdapter();      
         	$this->view->params = $params = $this->getRequest()->getParams('id'); 
         	$where['farmer_status'] = 'inactive';
         	$db->update('tbl_farmer', $where,array('id=?'=>$params['id']));     
         	$this->view->successMessage = "Inactive successfully.";               
         	$this->_redirect('/farmer/index/');
         }

         public function deleteFarmerAction(){ 
         	$db = $this->db = Zend_Db_Table::getDefaultAdapter();
         	$this->view->params = $params = $this->getRequest()->getParams('id');

         	$farmer = "update tbl_farmer set  deleted_status='0' where id = '".$params['id']."'";
         	$db->query($farmer);

         	$this->_helper->layout()->disableLayout(); 
         	$this->_helper->viewRenderer->setNoRender(true);
         	
         	$this->view->successMessage = "Farmer Detail(s) deleted successfully.";
         	$this->_redirect('/farmer/index');     
         }

         public function viewFarmerAction(){
            $db = $this->db = Zend_Db_Table::getDefaultAdapter();
            $layout = $this->_helper->layout();
            $layout->disableLayout('');
            $params = $this->view->params = $this->getRequest()->getParams();
            
            $farmer_query = "SELECT fr.*, l.StaffName, fr.farmer_status FROM tbl_farmer AS fr LEFT JOIN logi_user AS l ON (l.id = fr.user_id) WHERE fr.deleted_status = 1 and fr.id = '".$params['id']."'";
            $this->view->farmer_result = $farmer_result = $db->fetchRow($farmer_query);
        }

        public function formDetailsAction(){
            try{
                $db = $this->db = Zend_Db_Table::getDefaultAdapter();
                $params = $this->view->params = $this->getRequest()->getParams();
                $bmc_form_detail = "SELECT * from bmc_farmer_farm_detail where id ='1'" ;
                $this->view->form_detail = $form_detail = $db->fetchRow($bmc_form_detail);
                // print_r($form_detail);
                // exit;
                if($this->getRequest()->isPost()){
                    $data = array();
                    $data['doc_no'] = $params['docno'];
                    $data['rev_no'] = $params['rev_no'];
                    $data['rev_date'] = $params['rev_date'];
                    $data['issue_no'] = $params['issue'];
                    $data['issue_date'] = $params['issue_date'];
                    $data['date_of_evalution'] = $params['Date_of_evalution'];
                    $where['id'] = '1';
                    $db->update('bmc_farmer_farm_detail',$data,$where);
                    $this->view->message = "Farmer Detail(s) Added successfully.";
                    $this->_redirect('/farmer/index');
                }
            }
            catch(Exception $e){
              echo $e->getMessage();
              exit;
          }
      }
      public function checklogin(){   
          $auth = Zend_Auth::getInstance(); 
          $errorMessage = ""; 
          /*************** check user identity ************/
          if(!$auth->hasIdentity()){
             $this->_redirect('admin/index');  
         }   
     }     
 }