<?php

/**
 * Logimetrix Techsolution Pvt. Ltd.
 * File Name   : DashboardController.php
 * Created By : Puneet Mishra
 * Created Date: 21 Dec 2016
 */

class DashboardController extends Zend_Controller_Action{
	var $dbAdapter;

	public function init(){
		/* Initialize action controller here */
		$bootstrap                     = $this->getInvokeArg('bootstrap');
		$aConfig                       = $bootstrap->getOptions();
		$this->view->siteurl           = $aConfig['site']['image']['url'];
		$this->dbAdapter               = Zend_Db_Table::getDefaultAdapter();
		$auth                          = Zend_Auth::getInstance();
		$authStorage                   = $auth->getStorage();
		if(isset($authStorage->read()->Role)){
			$users                         = new Application_Model_Users();
			$logout_details                = $users->getUserLoginDetailByWebLoginCode($this->WebLoginID);
			$this->view->last_login        = $logout_details['login_time'];
			$this->currdate                = date("Y-m-d H:i:s", strtotime('+330 minutes'));
			$this->WebLoginID              = $authStorage->read()->WebLoginID;
			$this->Role                    = $authStorage->read()->Role;
			$this->id                      = $authStorage->read()->id;
			$this->parent_regional_manager = $authStorage->read()->parent_regional_manager;
			$this->parent_zonal_manager    = $authStorage->read()->parent_zonal_manager;
			$this->parent_area_manager     = $authStorage->read()->parent_area_manager;
			$this->parent_sale             = $authStorage->read()->parent_sale;
			$this->view->last_login        = $logout_details['login_time'];
			$this->user_name               = $authStorage->read()->user_name;
		}
	}


    /**
     * index() method is used to admin login
     * @param Username and password
     * @return True 
     */
    public function indexAction(){
    	$this->checklogin();
       
        $this->db              = Zend_Db_Table::getDefaultAdapter();
        $db                    = $this->db;
        $auth                  = Zend_Auth::getInstance();
        $authStorage           = $auth->getStorage();
        $params                = $this->view->params = $this->getRequest()->getParams();
        $this->role            = $authStorage->read()->Role;
        $this->view->user_role = $this->role;
        $id                    = $authStorage->read()->id;
        $this->view->username  = $username   = $authStorage->read()->username;
        $Users                 = new Application_Model_Users();
        $order                 = new Application_Model_Order();


        $sqlLocationMaster = "select * from logi_location where status = '1' ";
        $this->view->sqlLocationMaster = $sqlLocationMaster = $db->fetchAll($sqlLocationMaster);


        if($params['submit'] =='export'){
            $this->exportRetailer($params);
        }   

        $curr_date = date('Y-m-d');
        if ($this->Role == 'super_admin') {
          $role_cond .= "";
      }
      if ($this->Role == 'RM') {
          $role_cond .= "and retailers_site_location.parent_regional_manager = '" . $this->id . "' ";
      }
      if ($this->Role == 'ZM') {
          $role_cond .= "and retailers_site_location.parent_zonal_manager = '" . $this->id . "' ";
      }
      if ($this->Role == 'ASM') {
          $role_cond .= "and retailers_site_location.parent_area_manager = '" . $this->id . "' ";
      }
      if ($this->Role == 'Sales') {
          $role_cond .= "and retailers_site_location.parent_sale_person = '" . $this->id . "' ";
      }
      $this->view->getUserListAccordingToDeviceActivity             = $getUserListAccordingToDeviceActivity     = $this->getUserListAccordingToDeviceActivity($this->username, $id);
      $this->view->loginUserActivity      = $loginUserActivity      = $this->loginUserActivity($this->username, $id);
      $this->view->attendanceActivity     = $attendanceActivity         = $this->attendanceActivity($this->username, $id);
      $queryretailer = "SELECT u2.StaffName,u2.MobileNo,u2.category,u2.area_id,logi_location.location_name,u.StaffName as parent_sales FROM `logi_user` as u2  JOIN logi_user as u on u.id=u2.parent_sale LEFT JOIN logi_location on logi_location.id = u2.area_id WHERE u2.Role = 'Retailer' ORDER BY u2.id DESC LIMIT 10";
      $this->view->retailer = $retailer = $db->fetchAll($queryretailer);
      $this->view->userGpsStatusActivity     = $userGpsStatusActivity     = $this->userGpsStatusActivity($this->username, $id); 
      $this->view->userDataOnOffActivity     = $userDataOnOffActivity     = $this->userDataOnOffActivity($this->username, $id);  
      $date = date('Y-m-d');
      if($params['distance'] !=''){
          $retailersSql = "SELECT logi_user.StaffName,logi_user.tagged_latitude,logi_user.tagged_longitude,logi_user.Address_Curr,logi_user.Created,retailers_site_location.photograph1 FROM `logi_user` LEFT join retailers_site_location on retailers_site_location.retailer_id = logi_user.id";  
          $retailers = $this->db->fetchAll($retailersSql);

          $retailers_array = array();
          foreach($retailers as $retailer_detail){
             $distance = $this->getCordinateDistance($retailer_detail['tagged_latitude'], $retailer_detail['tagged_longitude']);
             if($distance <= $params['distance']){
                $single_retailer_detail = array('StaffName'=>$retailer_detail['StaffName'], 'tagged_latitude'=>$retailer_detail['tagged_latitude'], 'tagged_longitude'=>$retailer_detail['tagged_longitude'], 'Address_Curr'=>$retailer_detail['Address_Curr'], 'Created'=>$retailer_detail['Created'], 'photograph1'=>$retailer_detail['photograph1']);

                array_push($retailers_array, $single_retailer_detail);
            }
        }
        $this->view->retailers =$retailers_array;
    }
    else{


        $retailersCountSql = "SELECT id from logi_user where Role = 'Retailer'";  
        $this->view->resRetailersCnt = $resRetailersCnt = $this->db->fetchAll($retailersCountSql);



        $retailersSql = "SELECT logi_user.StaffName,logi_user.tagged_latitude,logi_user.tagged_longitude,logi_user.Address_Curr,logi_user.Created,retailers_site_location.photograph1 FROM `logi_user` LEFT join retailers_site_location on retailers_site_location.retailer_id = logi_user.id";  
        $retailers = $this->db->fetchAll($retailersSql);

        $this->view->retailers =$retailers;

    }
}


function exportRetailer($params){

    $this->db              = Zend_Db_Table::getDefaultAdapter();
    $db                    = $this->db;


    if($params['date_from'] && $params['date_to']){
        $cond .="and date(u2.Created) between '".$params['date_from']."'  and '".$params['date_to']."'";
    }

    if($params['export_area']){
      $sqlLoc = "select id from logi_user_location_mapping where location_id = '".$params['export_area']."'";
      $resLoc = $db->fetchAll($sqlLoc);

      $loc_array = array();

      if($resLoc){
          foreach($resLoc as $locData){
            array_push($loc_array, "'".$locData['id']."'");
        }
        $loc_str = implode(',', $loc_array);
        $area_cond .="and u2.area_id in ($loc_str)";
    }
}

$queryretailer = "SELECT u2.parent_sale, u2.area_id, u2.LoginID, date(u2.Created) as added_date, u2.StaffName,u2.MobileNo,u2.category,u2.area_id FROM `logi_user` as u2 WHERE u2.Role = 'Retailer'  $cond $area_cond";

$result = $db->fetchAll($queryretailer);

$data = array(
    array(
        'Sr.No.' => "",
        'Retailer code' => "",
        'Retailer Name' => "",
        'Mobile No' => "",
        'Category Name' => "",
        'Area Name' => "",
        'Added by' => "",
        'Date' => ""
    )
);
$i    = 2;
foreach ($result as $rs) {
    $queryArea = "SELECT * from logi_user_location_mapping where id  = '".$rs['area_id']."'";
    $resultArea = $db->fetchRow($queryArea);

    $queryParent = "SELECT u2.StaffName FROM `logi_user` as u2 WHERE u2.id = '".$rs['parent_sale']."'";
    $resultParent = $db->fetchRow($queryParent);


    $row   = array();
    $row[] = stripslashes($i);
    $row[] = stripslashes($rs['LoginID']);
    $row[] = stripslashes($rs['StaffName']);
    $row[] = stripslashes($rs['MobileNo']);
    $row[] = stripslashes($rs['category']);
    $row[] = stripslashes($resultArea['location_name']);
    $row[] = stripslashes($resultParent['StaffName']);
    $row[] = stripslashes($rs['added_date']);
    $data[] = $row;
    $i++;
}
function filterData(&$str){
    $str = preg_replace("/\t/", "\\t", $str);
    $str = preg_replace("/\r?\n/", "\\n", $str);
    if (strstr($str, '"'))
        $str = '"' . str_replace('"', '""', $str) . '"';
}

            // file name for download
$fileName = "Retailer Report.xls";

            // headers for download
header("Content-Disposition: attachment; filename=\"$fileName\"");
header("Content-Type: application/vnd.ms-excel");

$flag = false;
foreach ($data as $row) {
    if (!$flag) {
                    // display column names as first row
        echo implode("\t", array_keys($row)) . "\n";
        $flag = true;
    }
                // filter data
    array_walk($row, 'filterData');
    echo implode("\t", array_values($row)) . "\n";
}
exit;
}


function getCordinateDistance($lat2, $long2) { 
   $lat1  = '26.81466835533823';
   $long1 = '75.60595750808716';
   $pi80 = M_PI / 180; 
   $lat1 *= $pi80; 
   $lon1 *= $pi80; 
   $lat2 *= $pi80; 
   $lon2 *= $pi80; 
   $r = 6372.797; 
   $dlat = $lat2 - $lat1; 
   $dlon = $lon2 - $lon1; 
   $a = sin($dlat / 2) * sin($dlat / 2) + cos($lat1) * cos($lat2) * sin($dlon / 2) * sin($dlon / 2); 
   $c = 2 * atan2(sqrt($a), sqrt(1 - $a)); 
   $km = $r * $c;  
   return $km; 
}




     /**
     * indexclone() method is used to admin login
     * @param Username and password
     * @return True 
     */


     public function indexokAction(){
     	$this->checklogin();

     	$this->db              = Zend_Db_Table::getDefaultAdapter();
     	$db                    = $this->db;
     	$auth                  = Zend_Auth::getInstance();
     	$authStorage           = $auth->getStorage();
     	$params                = $this->view->params = $this->getRequest()->getParams();
     	$this->role            = $authStorage->read()->Role;
     	$this->view->user_role = $this->role;
     	$id                    = $authStorage->read()->id;
     	$this->view->username  = $username   = $authStorage->read()->username;
     	$Users                 = new Application_Model_Users();
     	$order                 = new Application_Model_Order();

     	$curr_date = date('Y-m-d');
     	if ($this->Role == 'super_admin') {
     		$role_cond .= "";
     	}
     	if ($this->Role == 'RM') {
     		$role_cond .= "and retailers_site_location.parent_regional_manager = '" . $this->id . "' ";
     	}
     	if ($this->Role == 'ZM') {
     		$role_cond .= "and retailers_site_location.parent_zonal_manager = '" . $this->id . "' ";
     	}
     	if ($this->Role == 'ASM') {
     		$role_cond .= "and retailers_site_location.parent_area_manager = '" . $this->id . "' ";
     	}
     	if ($this->Role == 'Sales') {
     		$role_cond .= "and retailers_site_location.parent_sale_person = '" . $this->id . "' ";
     	}
     	$this->view->getUserListAccordingToDeviceActivity             = $getUserListAccordingToDeviceActivity     = $this->getUserListAccordingToDeviceActivity($this->username, $id);
     	$this->view->loginUserActivity      = $loginUserActivity      = $this->loginUserActivity($this->username, $id);
     	$this->view->attendanceActivity     = $attendanceActivity     = $this->attendanceActivity($this->username, $id);
     	$queryretailer = "SELECT u2.StaffName,u2.MobileNo,u2.category,u2.area_id,logi_location.location_name,u.StaffName as parent_sales FROM `logi_user` as u2  JOIN logi_user as u on u.id=u2.parent_sale LEFT JOIN logi_location on logi_location.id = u2.area_id WHERE u2.Role = 'Retailer' ORDER BY u2.id DESC LIMIT 10";
     	$this->view->retailer = $retailer = $db->fetchAll($queryretailer);
     	$this->view->userGpsStatusActivity     = $userGpsStatusActivity     = $this->userGpsStatusActivity($this->username, $id); 

     	$this->view->userDataOnOffActivity     = $userDataOnOffActivity     = $this->userDataOnOffActivity($this->username, $id);  

     	$date = date('Y-m-d');

     	$final_retailers = array();

     	$retailersSql = "SELECT logi_user.StaffName,logi_user.tagged_latitude,logi_user.tagged_longitude,logi_user.Address_Curr,logi_user.Created,retailers_site_location.photograph1 FROM `logi_user` LEFT join retailers_site_location on retailers_site_location.retailer_id = logi_user.id where logi_user.Created LIKE '%".$date."%'";  
     	$this->view->retailers = $retailers = $this->db->fetchAll($retailersSql);
     	if($params['lat']  && $params['lng']){

     		$radius_mile = ($params['radius']/1000) * 1.60934;


     		$sql_location        = "SELECT StaffName,Address_Curr,tagged_latitude,tagged_longitude,Created, ( 3959 * acos(cos(radians(".$params['lat'].")) * cos(radians(tagged_latitude)) * cos(radians(tagged_longitude ) - radians(".$params['lng'].")) + sin(radians(".$params['lat'].")) * sin(radians(tagged_latitude ))) ) AS distance FROM logi_user where Role = 'Retailer' ORDER BY `distance` ASC ";  

     		$retailers =  $db->fetchAll($sql_location); 
     		foreach ($retailers as $retailer ) {
     			if($retailer['distance'] <= $radius_mile ){
     				array_push($final_retailers, $retailer);
     			}
     		}

     		$this->view->retailers = $final_retailers ;

     	}




     }



     /**
     * indexclone() method is used to admin login
     * @param Username and password
     * @return True 
     */
     public function indexCloneAction(){
     	$this->checklogin();
     	$this->db              = Zend_Db_Table::getDefaultAdapter();
     	$db                    = $this->db;
     	$auth                  = Zend_Auth::getInstance();
     	$authStorage           = $auth->getStorage();
     	$params                = $this->view->params = $this->getRequest()->getParams();
     	$this->role            = $authStorage->read()->Role;
     	$this->view->user_role = $this->role;
     	$id                    = $authStorage->read()->id;
     	$Users                 = new Application_Model_Users();
     	$order                 = new Application_Model_Order();

     	$curr_date = date('Y-m-d');
     	if ($this->Role == 'super_admin') {
     		$role_cond .= "";
     	}
     	if ($this->Role == 'RM') {
     		$role_cond .= "and retailers_site_location.parent_regional_manager = '" . $this->id . "' ";
     	}
     	if ($this->Role == 'ZM') {
     		$role_cond .= "and retailers_site_location.parent_zonal_manager = '" . $this->id . "' ";
     	}
     	if ($this->Role == 'ASM') {
     		$role_cond .= "and retailers_site_location.parent_area_manager = '" . $this->id . "' ";
     	}
     	if ($this->Role == 'Sales') {
     		$role_cond .= "and retailers_site_location.parent_sale_person = '" . $this->id . "' ";
     	}

     	$this->view->getUserListAccordingToDeviceActivity            = $getUserListAccordingToDeviceActivity     = $this->getUserListAccordingToDeviceActivity($this->user_name, $id);
     	$this->view->loginUserActivity      = $loginUserActivity     = $this->loginUserActivity($this->user_name, $id);
     	$this->view->attendanceActivity     = $attendanceActivity    = $this->attendanceActivity($this->user_name, $id);


     }


     public function getUserListAccordingToDeviceActivity($user_name, $parent_id){
     	$db = $this->db  = Zend_Db_Table::getDefaultAdapter();
     	$curr_date = date("Y-m-d");

     	
     	$query = "select * from logi_user where  date(last_location_service_hit_time) = '".$curr_date."'   $cond and parent_id = '".$parent_id."' order by id desc";
     	$result = $db->fetchAll($query); 

     	$user_array = array();
     	foreach($result as $user_data){
     		if($params['battery_status']<'33'){
     			$battery_status = 'Low';
     		}
     		else if($params['battery_status']>'33' && $params['battery_status']<'60'){
     			$battery_status = 'Medium';
     		}
     		else if($params['battery_status']>'60'){
     			$battery_status = 'High';
     		}
     		else{

     		}
     		$last_location_service_hit_date_time      = $user_data['last_location_service_hit_time'];
     		$curr_date_time                           = date("Y-m-d H:i:s");
     		$timestamp_last_location_service_hit_time = new DateTime($last_location_service_hit_date_time);
     		$timestamp_curr_date_time                 = new DateTime($curr_date_time);
     		$interval                                 = $timestamp_curr_date_time->diff($timestamp_last_location_service_hit_time);

     		if($interval->format('%h') !=0){
     			$hour_diff                             = $interval->format('%h')." Hours ".$interval->format('%i')." Minutes";
     		}
     		else{
     			$hour_diff                                = $interval->format('%i')." Minutes";
     		}
     		$user_detail = array('id'=>$user_data['id'], 'StaffName'=>$user_data['StaffName'], 'LoginID'=>$user_data['LoginID'], 'battery_status_type'=>$battery_status, 'battery_status'=>$user_data['battery_status'], 'hour_diff'=>$hour_diff);
     		array_push($user_array, $user_detail);
     	}
     	return $user_array;
     }


     public function attendanceActivity($user_name, $parent_id){
     	$db = $this->db  = Zend_Db_Table::getDefaultAdapter();
     	$curr_date = date("Y-m-d");

     	if($parent_id == 4){
     		$table = 'mpd_attendance';
     	}
     	else{
     		$table = 'Attendance';
     	}

     	$query = "select  attendance.status, user.id, user.StaffName, user.LoginID, attendance.noti_date from $table as attendance  left join logi_user as user on  (user.LoginID = attendance.LoginID) where date(attendance.noti_date) = '".$curr_date."'  order by attendance.id desc";
     	$result = $db->fetchAll($query); 

     	$user_array = array();

     	foreach($result as $user_data){
     		$login_date_time      = $user_data['noti_date'];
     		$curr_date_time                           = date("Y-m-d H:i:s");
     		$timestamp_login_time = new DateTime($login_date_time);
     		$timestamp_curr_date_time                 = new DateTime($curr_date_time);
     		$interval                                 = $timestamp_curr_date_time->diff($timestamp_login_time);

     		if($interval->format('%h') !=0){
     			$hour_diff                             = $interval->format('%h')." Hours ".$interval->format('%i')." Minutes";
     		}
     		else{
     			$hour_diff                                = $interval->format('%i')." Minutes";
     		}
     		$user_detail = array('id'=>$user_data['id'], 'StaffName'=>$user_data['StaffName'], 'LoginID'=>$user_data['LoginID'], 'noti_date'=>$user_data['noti_date'], 'hour_diff'=>$hour_diff, 'status'=>$user_data['status']);
     		array_push($user_array, $user_detail);
     	}
     	return $user_array;
     }



     public function loginUserActivity($user_name, $parent_id){
     	$db = $this->db  = Zend_Db_Table::getDefaultAdapter();
     	$curr_date = date("Y-m-d");

     	$query = "select user.id, user.StaffName, user.LoginID, login.login_time from logi_user_login_detail as login  left join logi_user as user on  (user.LoginID = login.mob_user_staff_code) where date(login.login_time) = '".$curr_date."'  and user.parent_id = '".$parent_id."' group by login.mob_user_staff_code order by login.id desc";
     	$result = $db->fetchAll($query); 

     	$user_array = array();
     	foreach($result as $user_data){


     		$login_date_time      = $user_data['login_time'];
     		$curr_date_time                           = date("Y-m-d H:i:s");
     		$timestamp_login_time = new DateTime($login_date_time);
     		$timestamp_curr_date_time                 = new DateTime($curr_date_time);
     		$interval                                 = $timestamp_curr_date_time->diff($timestamp_login_time);

     		if($interval->format('%h') !=0){
     			$hour_diff                            = $interval->format('%h')." Hours ".$interval->format('%i')." Minutes";
     		}
     		else{
     			$hour_diff                             = $interval->format('%i')." Minutes";
     		}
     		$user_detail = array('id'=>$user_data['id'], 'StaffName'=>$user_data['StaffName'], 'LoginID'=>$user_data['LoginID'], 'login_time'=>$user_data['login_time'], 'hour_diff'=>$hour_diff);
     		array_push($user_array, $user_detail);
     	}
     	return $user_array;
     }

     public function userGpsStatusActivity($user_name, $parent_id){
     	$db = $this->db  = Zend_Db_Table::getDefaultAdapter();
     	$curr_date = date("Y-m-d");
     	$query = "select user.last_location_service_hit_time, user.id, user.StaffName, user.LoginID, user.Gps_status from logi_user as user  where date(user.last_location_service_hit_time) = '".$curr_date."'  and user.parent_id = '".$parent_id."' and user.Role in ('Sales', 'ASM')";
     	return $result = $db->fetchAll($query); 
     }

     public function userDataOnOffActivity($user_name, $parent_id){
     	$db = $this->db  = Zend_Db_Table::getDefaultAdapter();
     	$curr_date = date("Y-m-d H:i:s");

     	$userOnlineOffline = array();
     	$queryOnlineArray = "select *  from logi_user where TIMESTAMPDIFF(MINUTE,Last_location_service_hit_time,'" . $curr_date . "') < 15  and parent_id = '".$parent_id."' and Role in ('Sales', 'ASM')";
     	$resultOnlineArray = $db->fetchAll($queryOnlineArray);

     	foreach($resultOnlineArray as $userOnlineData){
     		$userOnlineDataArray = array('id'=>$userOnlineData['id'], 'StaffName'=>$userOnlineData['StaffName'], 'LoginID'=>$userOnlineData['LoginID'], 'last_location_service_hit_time'=>$userOnlineData['last_location_service_hit_time'], 'network_status'=>'Online');
     		array_push($userOnlineOffline, $userOnlineDataArray);
     	}

     	$queryOfflineArray = "select *  from logi_user where TIMESTAMPDIFF(MINUTE,Last_location_service_hit_time,'" . $curr_date . "') > 15  and parent_id = '".$parent_id."' and Role in ('Sales', 'ASM')";
     	$resultOfflineArray = $db->fetchAll($queryOfflineArray);

     	foreach($resultOfflineArray as $userOfflineData){
     		$userOfflineDataArray = array('id'=>$userOfflineData['id'], 'StaffName'=>$userOfflineData['StaffName'], 'LoginID'=>$userOfflineData['LoginID'], 'last_location_service_hit_time'=>$userOfflineData['last_location_service_hit_time'], 'network_status'=>'Offline');
     		array_push($userOnlineOffline, $userOfflineDataArray);
     	}


     	return $userOnlineOffline;
     }

     public function getRetailersMapAction(){
     	try{
     		$this->checklogin();
     		$this->db              = Zend_Db_Table::getDefaultAdapter();
     		$db                    = $this->db;
     		$auth                  = Zend_Auth::getInstance();
     		$authStorage           = $auth->getStorage();
     		$params                = $this->view->params = $this->getRequest()->getParams();
        // echo "pre";
        // print_r($params);



     		$radius_mile = ($params['radius']/1000) * 1.60934;

     		if($params['lat'] != "" && $params['lng']!=""){
     			$sql_location        = "SELECT StaffName,Address_Curr,tagged_latitude,tagged_longitude,Created, ( 3959 * acos(cos(radians(".$params['lat'].")) * cos(radians(tagged_latitude)) * cos(radians(tagged_longitude ) - radians(".$params['lng'].")) + sin(radians(".$params['lat'].")) * sin(radians(tagged_latitude ))) ) AS distance FROM logi_user where Role = 'Retailer' ORDER BY `distance` ASC ";  
     		}


     		$this->view->retailers = $db->fetchAll($sql_location); 
     		$this->view->params = $params;

     	}
     	catch(Exception $e){
     		echo 'Message: ' .$e->getMessage();
     	}



     	$this->_helper->layout->disableLayout();

     }


     public function checklogin(){
     	$auth         = Zend_Auth::getInstance();
     	$errorMessage = "";
     	/*************** check user identity ************/
     	if (!$auth->hasIdentity()) {
     		$this->_redirect('/admin');
     	}
     }


 }
