<?php


class BmcController extends Zend_Controller_Action{
	var $dbAdapter;
	var $db;
	public function init(){
		/* Initialize action controller here */
		$this->_flashMessenger  = $this->_helper->getHelper('FlashMessenger');
		$bootstrap = $this->getInvokeArg('bootstrap');
		$aConfig = $bootstrap->getOptions();
		$this->db = Zend_Db_Table::getDefaultAdapter();
		$auth = Zend_Auth::getInstance();
		$authStorage = $auth->getStorage();
		$this->WebLoginID = $authStorage->read()->WebLoginID;
		$users = new Application_Model_Users();
		$logout_details = $users->getUserLoginDetailByWebLoginCode($this->WebLoginID);
		$this->view->last_login = $logout_details['login_time'];               
	}

	public function indexAction(){

		$this->checklogin();
		$params = $this->view->params = $this->getRequest()->getParams();
		$this->view->messages = $this->_flashMessenger->getMessages();

		$db = $this->db = Zend_Db_Table::getDefaultAdapter();

		$bmc_query = "SELECT * FROM logi_bmc WHERE status = 1";
		$this->view->bmc_result = $bmc_result = $db->fetchAll($bmc_query);

		$page=$this->_getParam('page',1);
		$paginator = Zend_Paginator::factory($bmc_result);      
       $paginator->setCurrentPageNumber($this->getRequest()->getParam('page'));
       $paginator->setItemCountPerPage(10); 
       $this->view->paginator = $paginator;
       $this->view->totalrec = $paginator->getTotalItemCount();
 }

 public function addBmcAction(){
    $this->checklogin();
    $db = $this->db = Zend_Db_Table::getDefaultAdapter();
    $this->view->messages = $this->_flashMessenger->getMessages();

    $this->view->params = $params = $this->getRequest()->getParams();

    $auth = Zend_Auth::getInstance();
    $authStorage = $auth->getStorage();

    if($this->getRequest()->isPost()){ 

         $bmc = array();

         $bmc['location_name'] = $params['location_name'];
         $bmc['latitude'] = $params['latitude'];
         $bmc['longitude'] = $params['longitude'];

         $db->insert('logi_bmc', $bmc);

         $bmc_id = $db->lastInsertId();


         $this->_flashMessenger->addMessage('Bmc Detail added successfully.');

         $this->_redirect("/bmc"); 
   }        
}



public function editBmcAction(){
    $this->checklogin();

    $auth = Zend_Auth::getInstance();
    $authStorage = $auth->getStorage();

    $db = $this->db = Zend_Db_Table::getDefaultAdapter();
    $this->view->messages = $this->_flashMessenger->getMessages();

    $this->view->params = $params = $this->getRequest()->getParams('id');


    $bmc_query = "SELECT * FROM logi_bmc WHERE id = '".$params['id']."' ";
    $this->view->bmc_result = $bmc_result = $db->fetchRow($bmc_query);            

    if($this->getRequest()->isPost()){
         $bmc = array();
         $bmc['location_name'] = $params['location_name'];   
         $bmc['latitude'] = $params['latitude'];   
         $bmc['longitude'] = $params['longitude'];   
         $db->update('logi_bmc', $bmc, array('id=?'=>$params['id'])); 

         $this->_flashMessenger->addMessage('Bmc Detail(s) updated successfully.');

         $this->_redirect('/bmc');

   }        
}

public function deleteBmcAction(){ 

    $db = $this->db = Zend_Db_Table::getDefaultAdapter();
    $this->view->params = $params = $this->getRequest()->getParams('id');



    $bmc = "update logi_bmc set  status='0' where id = '".$params['id']."'";
    $db->query($bmc);

    $this->_helper->layout()->disableLayout(); 
    $this->_helper->viewRenderer->setNoRender(true);

    $this->view->successMessage = "Bmc Detail(s) deleted successfully.";

    $this->_redirect('/bmc/');

}

public function checklogin(){   
    $auth = Zend_Auth::getInstance(); 
    $errorMessage = ""; 
    /*************** check user identity ************/
    if(!$auth->hasIdentity()){
         $this->_redirect('admin/index');  
   }   
}     
}