<?php

/***************************************************************
 * Logimetrix Techsolutions Pvt. Ltd.
 * File Name   : Assignstock.php
 * File Description  : Assignstock
 * Created By : Puneet Mishra
 * Created Date: 28 March 2018
 ***************************************************************/

class AssignstockController extends Zend_Controller_Action{

  var $dbAdapter;
  var $db;

  public function init(){
   /* Initialize action controller here */
   $this->_flashMessenger  = $this->_helper->getHelper('FlashMessenger');
   $bootstrap = $this->getInvokeArg('bootstrap');
   $aConfig = $bootstrap->getOptions();
   $this->db = Zend_Db_Table::getDefaultAdapter();
   $auth = Zend_Auth::getInstance();
   $authStorage = $auth->getStorage();
   $this->WebLoginID = $authStorage->read()->WebLoginID;
   $users = new Application_Model_Users();
   $logout_details = $users->getUserLoginDetailByWebLoginCode($this->WebLoginID);
   $this->view->last_login = $logout_details['login_time'];  
   $this->role                    = $authStorage->read()->Role;
   $this->id                      = $authStorage->read()->id;                 
 }

 public function indexAction(){
  $this->view->messages = $this->_flashMessenger->getMessages();  
  $this->checklogin();
  $params = $this->view->params = $this->getRequest()->getParams();
  $gmap = new Application_Model_Gmap();
  $this->view->getUserList = $getUserList =  $gmap->getUserList($this->role, $this->id); 

  $role = $this->role;
  $id   = $this->id;

  if($params['sale_person'] !=""){
    $cond .="and LoginID = '".$params['sale_person']."'";
  }

  if($params['user'] !=""){
    $cond .="and StaffName  like '%".$params['user']."%'";
  }

  if ($role == 'super_admin') {
    $user_cond .= "";
  }

  if ($role == 'RM') {
    $user_cond .= "and parent_regional_manager = '" . $id . "'";
  }

  if ($role == 'ZM') {
    $user_cond .= "and parent_zonal_manager = '" . $id . "' ";
  }

  if ($role == 'ASM') {
    $user_cond .= "and parent_area_manager = '" . $id . "' ";
  }

  if ($role == 'Sales') {
    $user_cond .= "and parent_sale = '" . $id . "' ";
  }
  $query = "select * from logi_user where 1 and Role = 'Sales' $cond $user_cond order by id desc";
  $this->view->result = $result = $this->db->fetchAll($query);
}

public function assignProductStockAction(){
  $this->checklogin();
  $db = $this->db;
  $this->view->messages = $this->_flashMessenger->getMessages();
  $params = $this->getRequest()->getParams();
  $Retailer = new Application_Model_Retailer();
  $this->view->params = $params;
  $auth = Zend_Auth::getInstance();
  $authStorage = $auth->getStorage(); 
  $this->view->getAllProduct = $getAllProduct = $Retailer->getdetailforallproduct();  

  $sql_user             = "select * from logi_user where md5(id) = '".$params['datacode']."' ";
  $this->view->res_user = $res_user = $this->db->fetchRow($sql_user);

  if($this->getRequest()->isPost()){
    $i=0;
    foreach($params['product_name'] as $key=>$value){
      $product_detail[$i] = array();
      $product_detail[$i]['sale_person_id'] = $params['datacode'];
      $product_detail[$i]['product_id']     = $params['product_name'][$i];
      $product_detail[$i]['sub_product_id'] = $params['sub_product_name'][$i];
      $product_detail[$i]['qty']            = $params['qty'][$i]; 
      $product_detail[$i]['created_at']     = date('Y-m-d h:i:s'); 
      $db->insert('tbl_assigned_stock', $product_detail[$i]); 

      $sql_get_subprdouct_detail = "select qty_in_stock from sub_product where id = '".$params['sub_product_name'][$i]."'";
      $result = $this->db->fetchRow($sql_get_subprdouct_detail);
      $total_available_qty = $result['qty_in_stock']   - $params['qty'][$i]; 

      $data = array();
      $data['qty_in_stock'] = $total_available_qty;
      $db->update('sub_product',$data,array('id=?'=>$params['sub_product_name'][$i]));                          
      $i++;  
    } 
    $this->_flashMessenger->addMessage('Product assigned added successfully.'); 
    $this->_redirect('/assignstock/assign-product-stock/datacode/'.md5($params['datacode'])); 
  }        
}



public function getSubProductListAction(){

  $this->checklogin();
  $this->getHelper('Layout')->disableLayout();
  $this->getHelper('ViewRenderer')->setNoRender();
  $this->getResponse()->setHeader('Content-Type', 'application/json');
  $Retailer = new Application_Model_Retailer();      
  $product_id = $this->getRequest()->getParam('product_id');
  $data_list_unformat = $Retailer->getSubProductListByProductId($product_id);          
  $sub_product_list[] = array("value"=>"",'text'=>"--Select Sub Product--");
  foreach($data_list_unformat as $single){
    $sub_product_list[] = array("value"=>$single['id'],"text"=>$single['sub_product_name']);
  }             
  $this->getHelper('Layout')->disableLayout();
  $this->getHelper('ViewRenderer')->setNoRender();
  $this->getResponse()->setHeader('Content-Type', 'application/json');
  echo json_encode(array('options'=>$sub_product_list));
  return;      
}


public function checkSubproductAvailableQtyAction(){

  $this->checklogin();
  $this->getHelper('Layout')->disableLayout();
  $this->getHelper('ViewRenderer')->setNoRender();
  $this->getResponse()->setHeader('Content-Type', 'application/json');
  $subproduct_id = $this->getRequest()->getParam('sub_product_id');
  $sql = "select qty_in_stock from sub_product where id = '".$subproduct_id."'"; 
  $result = $this->db->fetchRow($sql); 

  if($result['qty_in_stock']){
    $qty_in_stock = $result['qty_in_stock'];
  }
  else{
    $qty_in_stock = '0';
  } 
  echo $qty_in_stock;
  exit();  
}


public function viewAssignedStockAction(){ 
  $this->checklogin();
  $this->view->messages = $this->_flashMessenger->getMessages();
  $this->view->params = $params = $this->getRequest()->getParams(); 
  $curr_date = date('Y-m-d');
  if($params['selected_date']){
    $cond .="and date(tas.created_at) = '".$params['selected_date']."'";
  }
  else{
    $cond .="and date(tas.created_at) = '".$curr_date."'";
  }

  $query = "select lu.StaffName, lu.LoginID, tas.qty, (tas.created_at) as date, subproduct.sub_product_name, 
  product.product_name from tbl_assigned_stock as tas left join sub_product as subproduct on 
  (subproduct.id = tas.sub_product_id) left join logi_product as product on (product.id = tas.product_id)
  left join logi_user as lu on (lu.id = tas.sale_person_id) where 1 $cond and md5(tas.sale_person_id) ='".$params['datacode']."'";
  $this->view->result = $result = $this->db->fetchAll($query);

}

public function checklogin(){   
  $auth = Zend_Auth::getInstance(); 
  $errorMessage = ""; 
  /*************** check user identity ************/
  if(!$auth->hasIdentity()){
    $this->_redirect('admin/index');  
  }   
}     
}
