<?php

/***************************************************************
 * Logimetrix Techsolutions Pvt. Ltd.
 * File Name   : ProductController.php
 * File Description  : ProductController
 * Created By : Puneet Mishra
 * Created Date: 25 Nov 2016
 ***************************************************************/
 
class AreaschemeController extends Zend_Controller_Action{
    var $dbAdapter;
    var $db;
    public function init(){
             /* Initialize action controller here */
             $bootstrap = $this->getInvokeArg('bootstrap');
             $aConfig = $bootstrap->getOptions();
             $this->db = Zend_Db_Table::getDefaultAdapter();
             $auth = Zend_Auth::getInstance();
             $authStorage = $auth->getStorage();
             $this->WebLoginID = $authStorage->read()->WebLoginID;
             $users = new Application_Model_Users();
             $logout_details = $users->getUserLoginDetailByWebLoginCode($this->WebLoginID);
             $this->view->last_login = $logout_details['login_time'];               
    }
    
    public function indexAction(){

            $this->checklogin();
            $db = $this->db = Zend_Db_Table::getDefaultAdapter();
            $this->view->params = $params = $this->getRequest()->getParams();
            $auth = Zend_Auth::getInstance();
            $authStorage = $auth->getStorage();

             $scheme_query = "SELECT tas.scheme_id, tas.product_id, tas.scheme, tas.area_id, tas.cat_id, tc.category, tpp.product, tpp.price, ta.area FROM tbl_area_scheme AS tas LEFT JOIN tbl_category AS tc ON (tas.cat_id = tc.category_id) LEFT JOIN tbl_product_price AS tpp ON (tas.product_id=tpp.product_id) LEFT JOIN tbl_area AS ta ON (tas.area_id=ta.area_id) ";
             $this->view->scheme_result = $scheme_result = $db->fetchAll($scheme_query);

             $prdct_query = "SELECT * FROM tbl_product_price GROUP BY product";
             $this->view->prdct_result = $prdct_result = $db->fetchAll($prdct_query);

             $area_query = "SELECT * FROM tbl_area GROUP BY area";
             $this->view->area_result = $area_result = $db->fetchAll($area_query);


             $page=$this->_getParam('page',1);
             $paginator = Zend_Paginator::factory($scheme_result);      
             $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
             $paginator->setItemCountPerPage(10); // number of items to show per page
             $this->view->paginator = $paginator;
             $this->view->totalrec = $paginator->getTotalItemCount();
    }

        public function categoryAction(){

            $this->checklogin();
            $db = $this->db = Zend_Db_Table::getDefaultAdapter();
            $this->view->params = $params = $this->getRequest()->getParams('category_id');
            $auth = Zend_Auth::getInstance();
            $authStorage = $auth->getStorage();

            $cat_query = "SELECT * FROM tbl_category GROUP BY category";
            $this->view->cat_result = $cat_result = $db->fetchAll($cat_query);

            $page=$this->_getParam('page',1);
            $paginator = Zend_Paginator::factory($cat_result);      
            $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
            $paginator->setItemCountPerPage(10); // number of items to show per page
            $this->view->paginator = $paginator;
            $this->view->totalrec = $paginator->getTotalItemCount();
             
             if($params['category_id'] != ""){
              $category_query = "SELECT * FROM tbl_category WHERE category_id = '".$params['category_id']."' ";
              $this->view->category_result = $category_result = $db->fetchRow($category_query);
            }

            if($this->getRequest()->isPost()){ 

                if($params['category_id'] != ""){

                $category_update = array();

                $category_update['category']   = $params['category'];

                $db->update('tbl_category', $category_update, array('category_id=?'=>$params['category_id']));  
                $this->view->successMessage = "Category updated successfully.";
                $this->_redirect('/areascheme/category');

                /*-----------------------------------------*/ 

                } else {

                $category_insert = array();

                $category_insert['category']   = $params['category'];
                
                $db->insert('tbl_category', $category_insert);
                                                      
                $this->view->successMessage = "Category added successfully.";
                $this->_redirect("/areascheme/category");

                }
                
            }       
    }

    public function deleteCategoryAction(){ 
      
       $db = $this->db = Zend_Db_Table::getDefaultAdapter();
       $this->view->params = $params = $this->getRequest()->getParams('category_id');
      
       $where = array();

       $where[] = $this->db->quoteInto('category_id=?', $params['category_id']);

       $result =  $this->db->delete('tbl_category', $where);

       $this->view->successMessage = "Category Detail deleted successfully.";
        
       $this->_redirect('/areascheme/category');     
    }

        public function productAction(){

            $this->checklogin();
            $db = $this->db = Zend_Db_Table::getDefaultAdapter();
            $this->view->params = $params = $this->getRequest()->getParams('product_id');
            $auth = Zend_Auth::getInstance();
            $authStorage = $auth->getStorage();

            $cat_query = "SELECT * FROM tbl_category GROUP BY category";
            $this->view->cat_result = $cat_result = $db->fetchAll($cat_query);

            $prdct_query = "SELECT p.*,c.* FROM tbl_product_price AS p LEFT JOIN tbl_category AS c ON (p.cat_id=c.category_id) GROUP BY product";
            $this->view->prdct_result = $prdct_result = $db->fetchAll($prdct_query);

            $page=$this->_getParam('page',1);
            $paginator = Zend_Paginator::factory($prdct_result);      
            $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
            $paginator->setItemCountPerPage(10); // number of items to show per page
            $this->view->paginator = $paginator;
            $this->view->totalrec = $paginator->getTotalItemCount();
             
             if($params['product_id'] != ""){
                $product_query = "SELECT p.*,c.* FROM tbl_product_price AS p LEFT JOIN tbl_category AS c ON (p.cat_id=c.category_id) WHERE product_id = '".$params['product_id']."' ";
                $this->view->product_result = $product_result = $db->fetchRow($product_query);
            }
            if($params['category'] != ""){
                $category_query = "SELECT * FROM tbl_category WHERE category_id = '".$params['category']."'";
                $this->view->category_result = $category_result = $db->fetchRow($category_query);
            }

            if($this->getRequest()->isPost()){ 

                if($params['product_id'] != ""){

                $product_update = array();

                $product_update['product']   = $params['product'];
                $product_update['price']     = $params['price'];
                $product_update['cat_id']    = $category_result['category_id'];
                $product_update['under']     = $category_result['category'];

                $db->update('tbl_product_price', $product_update, array('product_id=?'=>$params['product_id']));  
                $this->view->successMessage = "Product updated successfully.";
                $this->_redirect('/areascheme/product');

                /*-----------------------------------------*/ 

                } else {

                $product_insert = array();

                $product_insert['product']   = $params['product'];
                $product_insert['price']     = $params['price'];
                $product_insert['cat_id']    = $category_result['category_id'];
                $product_insert['under']     = $category_result['category'];
                
                $db->insert('tbl_product_price', $product_insert);
                                                      
                $this->view->successMessage = "Product added successfully.";
                $this->_redirect("/areascheme/product");

                }
                
            }       
    }

    public function deleteProductAction(){ 
      
      $db = $this->db = Zend_Db_Table::getDefaultAdapter();
      $this->view->params = $params = $this->getRequest()->getParams('product_id');
      
      $where = array();

       $where[] = $this->db->quoteInto('product_id=?', $params['product_id']);

       $result =  $this->db->delete('tbl_product_price', $where);

       $this->view->successMessage = "Product Detail deleted successfully.";
        
       $this->_redirect('/areascheme/product');     
    }

            public function areaAction(){

            $this->checklogin();
            $db = $this->db = Zend_Db_Table::getDefaultAdapter();
            $this->view->params = $params = $this->getRequest()->getParams('area_id');
            $auth = Zend_Auth::getInstance();
            $authStorage = $auth->getStorage();

            $all_area_query = "SELECT * FROM tbl_area GROUP BY area";
            $this->view->all_area_result = $all_area_result = $db->fetchAll($all_area_query);

            $page=$this->_getParam('page',1);
            $paginator = Zend_Paginator::factory($all_area_result);      
            $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
            $paginator->setItemCountPerPage(10); // number of items to show per page
            $this->view->paginator = $paginator;
            $this->view->totalrec = $paginator->getTotalItemCount();
             
             if($params['area_id'] != ""){
              $area_query = "SELECT * FROM tbl_area WHERE area_id = '".$params['area_id']."' ";
              $this->view->area_result = $area_result = $db->fetchRow($area_query);
            }

            if($this->getRequest()->isPost()){ 

                if($params['area_id'] != ""){

                $area_update = array();

                $area_update['area']   = $params['area'];

                $db->update('tbl_area', $area_update, array('area_id=?'=>$params['area_id']));  
                $this->view->successMessage = "Area updated successfully.";
                $this->_redirect('/areascheme/area');

                /*-----------------------------------------*/ 

                } else {

                $area_insert = array();

                $area_insert['area']   = $params['area'];
                
                $db->insert('tbl_area', $area_insert);
                                                      
                $this->view->successMessage = "Area added successfully.";
                $this->_redirect("/areascheme/area");

                }
                
            }       
    }

    public function deleteAreaAction(){ 
      
       $db = $this->db = Zend_Db_Table::getDefaultAdapter();
       $this->view->params = $params = $this->getRequest()->getParams('area_id');
      
       $where = array();

       $where[] = $this->db->quoteInto('area_id=?', $params['area_id']);

       $result =  $this->db->delete('tbl_area', $where);

       $this->view->successMessage = "Area Detail deleted successfully.";
        
       $this->_redirect('/areascheme/area');     
    }

    public function assignSchemeAction(){

            $this->checklogin();
            $db = $this->db = Zend_Db_Table::getDefaultAdapter();
            $this->view->params = $params = $this->getRequest()->getParams();
            $auth = Zend_Auth::getInstance();
            $authStorage = $auth->getStorage();

            $cat_query = "SELECT * FROM tbl_category GROUP BY category";
            $this->view->cat_result = $cat_result = $db->fetchAll($cat_query);

            $prdct_query = "SELECT * FROM tbl_product_price GROUP BY product";
            $this->view->prdct_result = $prdct_result = $db->fetchAll($prdct_query);

            $area_query = "SELECT * FROM tbl_area GROUP BY area";
            $this->view->area_result = $area_result = $db->fetchAll($area_query);

            if($params['category'] != ""){
                $category_query = "SELECT * FROM tbl_category WHERE category_id = '".$params['category']."'";
                $this->view->category_result = $category_result = $db->fetchRow($category_query);
            }

            if($params['product'] != ""){
                $product_query = "SELECT * FROM tbl_product_price WHERE product_id = '".$params['product']."'";
                $this->view->product_result = $product_result = $db->fetchRow($product_query);
            }

            if($params['area'] != ""){
                $area_query = "SELECT * FROM tbl_area WHERE area_id = '".$params['area']."'";
                $this->view->area_result = $area_result = $db->fetchRow($area_query);
            }

            if($this->getRequest()->isPost()){ 

                $data = array();

                $data['product_id']      = $product_result['product_id'];
                $data['scheme']          = $params['scheme'];
                $data['area_id']         = $area_result['area_id'];
                $data['cat_id']          = $category_result['category_id'];
                $data['under']           = $category_result['category'];

                $db->insert('tbl_area_scheme', $data);
                                                      
                $this->view->successMessage = "Task Scheduled successfully.";
                $this->_redirect("/areascheme"); 
            }        
    }
  
  
  
    public function editSchemeAction(){

            $this->checklogin();
            $auth = Zend_Auth::getInstance();
            $authStorage = $auth->getStorage();
            $db = $this->db = Zend_Db_Table::getDefaultAdapter();
            $this->view->params = $params = $this->getRequest()->getParams('scheme_id');              
            $scheme_query = "SELECT tas.scheme_id, tas.product_id, tas.scheme, tas.area_id, tas.cat_id, tc.category, tpp.product, tpp.price, ta.area FROM tbl_area_scheme AS tas LEFT JOIN tbl_category AS tc ON (tas.cat_id = tc.category_id) LEFT JOIN tbl_product_price AS tpp ON (tas.product_id=tpp.product_id) LEFT JOIN tbl_area AS ta ON (tas.area_id=ta.area_id) WHERE tas.scheme_id = '".$params['scheme_id']."' ";
            $this->view->scheme_result = $scheme_result = $db->fetchRow($scheme_query);

            $cat_query = "SELECT * FROM tbl_category GROUP BY category";
            $this->view->cat_result = $cat_result = $db->fetchAll($cat_query);

            $prdct_query = "SELECT * FROM tbl_product_price GROUP BY product";
            $this->view->prdct_result = $prdct_result = $db->fetchAll($prdct_query);

            $area_query = "SELECT * FROM tbl_area GROUP BY area";
            $this->view->area_result = $area_result = $db->fetchAll($area_query);

            if($params['category'] != ""){
                $category_query = "SELECT * FROM tbl_category WHERE category_id = '".$params['category']."'";
                $this->view->category_result = $category_result = $db->fetchRow($category_query);
            }

            if($params['product'] != ""){
                $product_query = "SELECT * FROM tbl_product_price WHERE product_id = '".$params['product']."'";
                $this->view->product_result = $product_result = $db->fetchRow($product_query);
            }

            if($params['area'] != ""){
                $area_query = "SELECT * FROM tbl_area WHERE area_id = '".$params['area']."'";
                $this->view->area_result = $area_result = $db->fetchRow($area_query);
            }

            if($this->getRequest()->isPost()){
                
               $data = array();

                $data['product_id']      = $product_result['product_id'];
                $data['scheme']          = $params['scheme'];
                $data['area_id']         = $area_result['area_id'];
                $data['cat_id']          = $category_result['category_id'];
                $data['under']           = $category_result['category'];

                $db->update('tbl_area_scheme', $data, array('scheme_id=?'=>$params['scheme_id']));  
                $this->view->successMessage = "Assigned Task updated successfully.";
                $this->_redirect('/areascheme');

            }        
    }

    public function deleteSchemeAction(){ 
      
      $db = $this->db = Zend_Db_Table::getDefaultAdapter();
      $this->view->params = $params = $this->getRequest()->getParams('scheme_id');
      
      $where = array();

       $where[] = $this->db->quoteInto('scheme_id=?', $params['scheme_id']);

       $result =  $this->db->delete('tbl_area_scheme', $where);

       $this->view->successMessage = "Scheme Detail(s) deleted successfully.";
        
       $this->_redirect('/areascheme');     
    }

    public function searchAction(){

            $this->checklogin();
            $auth = Zend_Auth::getInstance();
            $authStorage = $auth->getStorage();
            
            $db = $this->db = Zend_Db_Table::getDefaultAdapter();
            $this->view->params = $params = $this->getRequest()->getParams();

            if($params['product'] != ""){
                $cond .= "AND tas.product_id = '".$params['product']."'";
            }
            if($params['area'] != ""){
                $cond .= "AND tas.area_id = '".$params['area']."'";
            }
             $search_query = "SELECT tas.scheme_id, tas.product_id, tas.scheme, tas.area_id, tas.cat_id, tc.category, tpp.product, tpp.price, ta.area FROM tbl_area_scheme AS tas LEFT JOIN tbl_category AS tc ON (tas.cat_id = tc.category_id) LEFT JOIN tbl_product_price AS tpp ON (tas.product_id=tpp.product_id) LEFT JOIN tbl_area AS ta ON (tas.area_id=ta.area_id) WHERE 1 $cond ";
            $this->view->search_result = $search_result = $db->fetchAll($search_query);

             $page=$this->_getParam('page',1);
             $paginator = Zend_Paginator::factory($search_result);      
             $paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
             $paginator->setItemCountPerPage(10); // number of items to show per page
             $this->view->paginator = $paginator;
             $this->view->totalrec = $paginator->getTotalItemCount();

              if($params['scheme'] == 'Generate'){
    
                $data = array(array('Sr. No.'=> "", 'Product'=> "", 'Price Of Product'=> "", 'Scheme On Product'=> "", 'Area'=> ""));
                $i = 2; 
                foreach ($search_result as $rs) {
                    $row = array();
                    $row[] = stripslashes($i-1);
                    $row[] = stripslashes($rs["product"]);
                    $row[] = stripslashes($rs["price"]);
                    $row[] = stripslashes($rs["scheme"]);
                    $row[] = stripslashes($rs["area"]);
                                            
                    $data[] = $row;
                    $i++;
                }
                function filterData(&$str){
                    $str = preg_replace("/\t/", "\\t", $str);
                    $str = preg_replace("/\r?\n/", "\\n", $str);
                    if(strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
                }

                // file name for download
                $fileName = "area_scheme_report.xls"; 

                // headers for download
                header("Content-Disposition: attachment; filename=\"$fileName\"");
                header("Content-Type: application/vnd.ms-excel");

                $flag = false;
                foreach($data as $row) {
                    if(!$flag) {
                        // display column names as first row
                        echo implode("\t", array_keys($row)) . "\n";
                        $flag = true;
                    }
                    // filter data
                    array_walk($row, 'filterData');
                    echo implode("\t", array_values($row)) . "\n";
                }
                exit;
      }     

    }
     
  public function checklogin(){   
      $auth = Zend_Auth::getInstance(); 
      $errorMessage = ""; 
      /*************** check user identity ************/
      if(!$auth->hasIdentity()){
            $this->_redirect('admin/index');  
      }   
  }     
}