<?php

/***************************************************************
 * Logimetrix Tech Solutions Pvt. Ltd.
 * File Name   : AccountSettingController.php
 * File Description  : Account Settings
 * Created By : Abhishek Kumar Mishra
 * Created Date: 20 June 2015
 ***************************************************************/
 
class AccountsettingController extends Zend_Controller_Action
{
    var $dbAdapter;
	
    public function init()
    {
        /* Initialize action controller here */
		$bootstrap = $this->getInvokeArg('bootstrap');
		$aConfig = $bootstrap->getOptions();
	    $this->view->siteurl = $aConfig['site']['image']['url'];
		$this->dbAdapter = Zend_Db_Table::getDefaultAdapter(); 
		$auth = Zend_Auth::getInstance();
		$authStorage = $auth->getStorage();
		$this->StaffCode = $authStorage->read()->StaffCode;
		$this->role = $authStorage->read()->role;
		$users = new Application_Model_Users();
		$logout_details = $users->getUserLoginDetailByStaffCode($this->StaffCode);
		$this->view->last_login = $logout_details['login_time'];	
    }

    public function indexAction()
    {
        // action body
		exit;
    }
	

	/**
	* manageUsers() method is used to users list of under supervisor
	* @param Null
	* @return Array 
	*/	
    public function manageUsersAction()
    {
	    $this->checklogin();
		$dbAdapter = $this->dbAdapter;
		// get all role and filter by roletype
		$params = $this->getRequest()->getParams();
        $admin = new Application_Model_Admin($params);
		$this->view->params = $params;
		$auth = Zend_Auth::getInstance();
		$authStorage = $auth->getStorage();
		$staffCode = $this->getRequest()->getParam('staffCode');
		$urlrole = $this->getRequest()->getParam('role');
		$urlrole1 = $params['role'];
		$title =  $this->_getParam('title');
		$sortby =  $this->_getParam('sortby');
		$StaffCode = $authStorage->read()->StaffCode;
		$role = $authStorage->read()->role;
		if(!$staffCode)
		{
			$staffCode = $authStorage->read()->StaffCodeMd5;
		}
		
		$users = new Application_Model_Users();
		
		$get = $this->getRequest()->getParams('search');
		$this->view->get = $get;
		$result = $users->getAllUserListBySupervisorIdWithFilter($get,$staffCode,$title,$sortby);
                
        $page=$this->_getParam('page',1);
		$paginator = Zend_Paginator::factory($result);      
		$paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $perPage = $paginator->setItemCountPerPage(10); // number of items to show per page
        $this->view->paginator = $paginator;
		$this->view->totalrec = $paginator->getTotalItemCount();
		$this->view->supervisorStaffCode = $staffCode;
		$this->view->urlrole = $urlrole;
		$this->view->urlrole1 = $urlrole1;
		$this->view->sortby = $sortby;
		$this->view->title = $title;
		$this->view->perPage = $perPage;
		
		$this->view->supervisor = $users->getUserdetailsByUserId($staffCode);
		
		// get all role in drop down 
	    $this->view->selectRole = $admin->getRoles($role,$params['role']);

    }

	/**
	* manageUsers() method is used to users list of under supervisor
	* @param Null
	* @return Array 
	*/	
    public function searchUsersAction()
    {
	    $this->checklogin();
		$dbAdapter = $this->dbAdapter;
		// get all role and filter by roletype
		$params = $this->getRequest()->getParams();
        $admin = new Application_Model_Admin($params);
		$this->view->params = $params;
		$auth = Zend_Auth::getInstance();
		$authStorage = $auth->getStorage();
		$staffCode = $this->getRequest()->getParam('staffCode');
		$urlrole = $this->getRequest()->getParam('role');
		$urlrole1 = $params['role'];
		$title =  $this->_getParam('title');
		$sortby =  $this->_getParam('sortby');
		$StaffCode = $authStorage->read()->StaffCode;
		$role = $authStorage->read()->role;
		if(!$staffCode)
		{
			$staffCode = $authStorage->read()->StaffCodeMd5;
		}
		
		$users = new Application_Model_Users();
		
		$get = $this->getRequest()->getParams('user_search');
		//echo "<pre>";print_r($get);
		$this->view->get = $get;
		$result = $users->getAllUserSearchListByStaffCode($get,$staffCode,$title,$sortby);
        $page=$this->_getParam('page',1);
		$paginator = Zend_Paginator::factory($result);      
		$paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $perPage = $paginator->setItemCountPerPage(10); // number of items to show per page
        $this->view->paginator = $paginator;
		$this->view->totalrec = $paginator->getTotalItemCount();
		$this->view->supervisorStaffCode = $staffCode;
		$this->view->urlrole = $urlrole;
		$this->view->urlrole1 = $urlrole1;
		$this->view->sortby = $sortby;
		$this->view->title = $title;
		$this->view->perPage = $perPage;
		
		$this->view->supervisor = $users->getUserdetailsByUserId($staffCode);
		
		// get all role in drop down 
	    $this->view->selectRole = $admin->getRoles($role,$params['role']);

    }
	
	
	/**
	* editFieldUser() method is used to send notification
	* @param NULL
	* @return Array 
	*/	
	public function editFieldUserAction()
    {
        $this->checklogin();
		$layout = $this->_helper->layout();
        $layout->disableLayout('');
		$user = new Application_Model_Users();
		$StaffCode = $this->getRequest()->getParam('StaffCode'); 
		
		$successMessage="";
		$errorMessage="";
		if($this->getRequest()->isPost()){  
		    $StaffCode = $this->getRequest()->getParam('StaffCode');
		    $device_type = $this->getRequest()->getParam('device_type'); 
			//$device_token = $this->getRequest()->getParam('device_token'); 
		    $device_id = $this->getRequest()->getParam('device_id');
	
			/*if($device_type == "")
			{
			    $this->view->errorMessage = "Please enter device type";
			}
		    else if($device_id == "")
			{
			    $this->view->errorMessage = "Please enter device id";
			} */
			
			$Data = $user->getUserdetailsByUserId($StaffCode);
			$UserStaffCode = $Data['StaffCode'];
			$user->updateDeviceDataByStaffCode($device_type,$device_id,$UserStaffCode);
		  
			$this->view->successMessage = "User data updated successfully.";
        } 
		
		$userData = $user->getUserdetailsByUserId($StaffCode);
		$this->view->record = $userData;
		$this->view->StaffCode = $StaffCode;

    }
	
	
	/**
	* userDetail() method is used to users list of under supervisor
	* @param Null
	* @return Array 
	*/	
    public function userDetailAction()
    {
	    $this->checklogin();
		$layout = $this->_helper->layout();
        $layout->disableLayout('');
	    $StaffCode = $this->getRequest()->getParam('StaffCode'); 
		$dbAdapter = $this->dbAdapter;
		$users = new Application_Model_Users();
		$result = $users->getUserdetailsByUserId($StaffCode);
        $this->view->record = $result;
		
		$CMSStaffStockCode = $result['CMSStaffStockCode'];
		$UserStaffCode = $result['StaffCode'];
		$this->view->totalSiteVisitCount = $users->getTotalSiteVisitCount($CMSStaffStockCode);
		$this->view->totalonline = $users->getOnlineUser($UserStaffCode);
		$this->view->fsronline_or_offline = $users->getFsrDetailsByStaffCode($UserStaffCode);
		$this->view->ttonline_or_offline = $users->getTtClosedByCMSStaffStockCode($CMSStaffStockCode);
		$this->view->fsronsite_or_offsite = $users->getFsrFillDetailsByStaffCode($UserStaffCode);
		$this->view->ttonsite_or_offsite = $users->getTtClosedCountArrByStaffCode($UserStaffCode);
		$this->view->tt_process_details = $users->getJobStatusArrByStaffCode($UserStaffCode);
        //$this->view->user_move_ornot = $users->getPresentUserCountByStaffCode($UserStaffCode);
		$this->view->tt_toward_on_leftsite = $users->getJobWithUserStatusByStaffCode($UserStaffCode);
		
    }
	
	/**
	* userTickets() method is used to users tickets by supervisor user
	* @param Null
	* @return Array 
	*/	
	 
    public function userTicketsAction()
    {
	    $this->checklogin();
		$StaffCode = $this->getRequest()->getParam('userId'); 
		$supervisorId = $this->getRequest()->getParam('supervisorId'); 
		$this->view->encuserId = $this->getRequest()->getParam('userId'); 
		
		$title =  $this->getRequest()->getParam('title');
		$sortby =  $this->getRequest()->getParam('sortby');
		//echo 'dsfds';die;
		$dbAdapter = $this->dbAdapter;
		$get = $this->getRequest()->getParams('search');
		$this->view->get = $get;
		
		$users = new Application_Model_Users();
		$userData = $users->getUserdetailsByUserId($StaffCode);
		$userId = $userData['StaffCode']; 
		$cmsstaffcode = $userData['CMSStaffStockCode']; 
		
		$jobs = new Application_Model_Job();
		
		$result = $jobs->getAllTicketsByUserId($get,$cmsstaffcode,$title,$sortby);
		$page=$this->_getParam('page',1);
		$paginator = Zend_Paginator::factory($result);      
		$paginator->setCurrentPageNumber($this->getRequest()->getParam('page')); // page number
        $this->view->per_page_limit = $paginator->setItemCountPerPage(10); // number of items to show per page
        $this->view->paginator = $paginator;
		$this->view->totalrec = $paginator->getTotalItemCount();
		$this->view->userData = $userData;
        $this->view->sortby = $sortby;
		$this->view->title = $title;
		$this->view->supervisorId = $supervisorId;
		$this->view->userId = $userId; 
		$this->view->record = $StaffCode;
    }
	 
	 
    /**
	* userPath() method is used to users path by user id
	* @param Null
	* @return Array 
	*/	
    public function userPathAction()
    {
	    $this->checklogin();
		$StaffCode = $this->getRequest()->getParam('userId'); 
		$supervisorId = $this->getRequest()->getParam('supervisorId'); 
		//Get user details by field_users table
		$users = new Application_Model_Users();
		$userData = $users->getUserdetailsByUserId($StaffCode);
	    $userId = $userData['StaffCode']; 
        $this->view->record = $userData;
		
		$years = $this->getRequest()->getParams('year');
	    $year = $years['year']; 
		$month = $this->getRequest()->getParams('month'); 
		$this->view->year = $year;
		$this->view->month = $month;
		$date = $this->getRequest()->getParams('date');
		$date = $date['date']; 
		$user_path = $users->getUserPathDetailsByUserId($year,$month,$userId);
		$this->view->user_path = $user_path;
		
		$start_lat_long = $users->getStartPointLatLongByUserId($year,$month,$date,$userId);

		
		$this->view->start_lat_long =$start_lat_long;
		
		$end_lat_long = $users->getEndPointLatLongByUserId($year,$month,$date,$userId);
		$this->view->end_lat_long =$end_lat_long;

		$all_lat_long = $users->getAllPointLatLongByUserId($year,$month,$date,$userId);
		//echo "<pre>";print_r($all_lat_long);
		$this->view->all_lat_long =$all_lat_long;
		
		$this->view->supervisorId = $supervisorId;
		$this->view->userId = $StaffCode;
		$this->view->job_lat_long = $users->getAllJobLocationWithUser($year,$month,$date,$userId);
		
		if($date !="")
		{
		   $selected_date = $date;
		}
		else{
		   $selected_date = date('Y-m-d');
		}
		$this->view->selected_date = $selected_date;
		
    }
	
	
	/**
	* userLogs() method is used to users logs by supervisor user
	* @param Null
	* @return Array 
	*/	
	 
    public function userLogsAction()
    {
	    $this->checklogin();
		$layout = $this->_helper->layout();
        $layout->disableLayout('');
		$StaffCode = $this->getRequest()->getParam('userId'); 
		$supervisorId = $this->getRequest()->getParam('supervisorId'); 
		$this->view->supervisorId = $supervisorId;
		$get = $this->getRequest()->getParams('search');
		$this->view->get = $get;
		
		$users = new Application_Model_Users();
		$userData = $users->getUserdetailsByUserId($StaffCode);
		$userId = $userData['StaffCode'];
        $this->view->record = $userData;
		
		
		$Userlogs = $users->getAllUserLogDetailsByUserId($userId);
		$this->view->user_logs = $Userlogs;
		
		/* $logs = $users->getUserLogDetailsByUserId($userId);
		//echo "<pre>";print_r($logs);die;
		$this->view->loginTime = $logs;
		
		$job_accept_logs = $users->getUserJobAcceptStatusLogByUserId($userId);
		$this->view->job_accept_logs = $job_accept_logs;
		
		$job_toward_logs = $users->getUserJobTowardLogByUserId($userId);
		$this->view->job_toward_logs = $job_toward_logs;
		
		$job_left_logs = $users->getUserJobLeftLogByUserId($userId);
		$this->view->job_left_logs = $job_left_logs;
		
		$job_btlow_logs = $users->getUserBatteryLowLogByUserId($userId);
		$this->view->job_btlow_logs = $job_btlow_logs;
		*/
		
    }
	
	
    /**
	* addFieldUser() method is used to add new field user
	* @param Null
	* @return Array 
	*/	
    public function addFieldUserAction()
    {
	    $this->checklogin();
		$form = new Application_Form_User();
		$this->view->form = $form;
		if($this->getRequest()->isPost()){ 
			if($form->isValid($_POST)){
				$data = $form->getValues();
				
		    }
        } 		
    }
	
	
	/**
	* sendNotification() method is used to send notification
	* @param NULL
	* @return Array 
	*/	
	public function sendNotificationAction()
    {
        $this->checklogin();
		$user = new Application_Model_Users();
		$auth = Zend_Auth::getInstance();
		$authStorage = $auth->getStorage();
		$role = $authStorage->read()->role;
		$StaffCode = $authStorage->read()->StaffCode;
		$StaffCodeMd5 = $authStorage->read()->StaffCodeMd5;
		
		$successMessage="";
		$errorMessage="";
		if($this->getRequest()->isPost()){  
		    $circleCode = $this->getRequest()->getParam('circleCode'); 
			if($circleCode)
			{
			    $circleCode = implode(',',$circleCode); 
		    }
			$users = $this->getRequest()->getParam('user'); 
		    $message = $this->getRequest()->getParam('message');
			
			/* if($circleCode == "")
			{
			    $this->view->errorMessage = "Please select circle";
			} */
			
			if(empty($users))
			{
			    $this->view->errorMessage = "Please select user";
			}
		    else if($message == "")
			{
			    $this->view->errorMessage = "Please enter message";
			}
			else
			{
				// Insert data send_msg table
				$messageData = array();
				$messageData['msg'] = $message;
				$messageData['msg_date'] = date('Y-m-d H:i:s');
				$message_id = $user->insertUserMessage($messageData);

				// Insert data send_msg_user table
				$total_user = count($users); 
				for($i=0;$i<$total_user;$i++)
				{
				   $user->insertUserSendMessage($users[$i],$message_id,$circleCode);
				   $userStaffData = $user->getUserStaffEmailByStaffCode($users[$i]);
				   if(!empty($userStaffData))
				   {
				        if($userStaffData['device_token'] && $userStaffData['device_type'])
						{
							//Start code for push notification
							$deviceToken = $userStaffData['device_token'];
							$deviceType = $userStaffData['device_type'];
							$StaffName = $userStaffData['StaffName'];
							$pushmsg = $message;
							$payload['aps'] = array('alert' =>"$pushmsg",'push_type'=>'notification');
							$pushobj = new Application_Model_Sendpush();
							$pushobj->sendPush($deviceToken,$deviceType,$payload);
						}	
						
						$email = $userStaffData['EMail']; 
						$StaffName = $userStaffData['StaffName'];
						$from_name = "ACME";
						$subject = "User Notification Message"; 
						if(!empty($email))
						{
							$messageDetail = "<table>
							<tr>
							<td>Message: </td>
							</tr>
							<tr>
							<td>$message</td>
							</tr>
							<tr>
							<td>&nbsp;</td>
							</tr>
							<tr>
							<td>Thanks,</td>
							</tr>
							<tr>
							<td>ACME Team</td>
							</tr>
							</table>
							";
				
							// To send HTML mail, the Content-type header must be set
						//	$headers  = 'MIME-Version: 1.0' . "\r\n";
						//	$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
							//$headers .= 'From: '.$from_name.' ' . "\r\n";
														
							// Mail it
							//@mail($email, $subject, $messageDetail, $headers);
							
					unset($confobj);		
					$confobj = new Application_Model_Fsr();
					
					$confArr = $confobj->getSmtpMailServerSettings();
					
					$config = $confArr['config'];
					$server = $confArr['server'];
					$fromemailconf = $confArr['fromemailconf'];
					
	
					$transport = new Zend_Mail_Transport_Smtp($server, $config);
					Zend_Mail::setDefaultTransport($transport);
					try{
						$mail = new Zend_Mail();
						$mail->setSubject($subject);
						$mail->setFrom($fromemailconf['fromemail'], $fromemailconf['fromname']);
						$mail->addTo($email, $StaffName);
						$mail->setBodyHtml($messageDetail);
						
						$mail->send($transport);
						//$this->view->errorMessage = "Email has been sent successfully.";
					}
					catch (Exception $e)
					{
						//$this->view->errorMessage = "Error in sending email.";
					//	echo '<pre>';
					//echo $e->getMessage();
						//print_r($e);
					}	
							
							
						} 
						
				   }
				}
			
				$this->view->successMessage = "Notification has been sent successfully.";
		    }	
			
        } 
		
		//  User list by role name
		if($role == "super_admin" || $role == "national_head")
		{
		    $result = $user->getAllUserDetails();
            $this->view->users = $result;
		}
        else if($role == "cluster_incharge")
        {
		    $user_list = $user->getAllUserListBySupervisorIdWithFilter($get,$StaffCodeMd5,$title,$sortby);
			$this->view->users = $user_list;
        }		
		//  Circle list by role name
		if($role == "super_admin" || $role == "national_head")
		{
		    $all_circle_list = $user->getAllCircleList();
			$circleCode='';
			foreach($all_circle_list as $key=>$val)
			{
			     $CircleCodeVal = strtoupper($val['CircleCode']);
			     if($circleCode==''){ $circleCode = $CircleCodeVal;  } else { $circleCode .=','.$CircleCodeVal; }
			}
			$this->view->circleCodeList = $circleCode;
			$this->view->circle_list = $all_circle_list;
		}
        else
        {
		    $circleCodeArr = $user->getCircleCodeByRoleName();
			$all_circle_list_by_rolename = $user->getAllCircleListByCircleCode($circleCodeArr);
			$circleCode='';
			foreach($all_circle_list_by_rolename as $key=>$val)
			{
			     $CircleCodeVal = strtoupper($val['CircleCode']);
			     if($circleCode==''){ $circleCode = $CircleCodeVal;  } else { $circleCode .=','.$CircleCodeVal; }
			}
			//echo "<pre>";print_r($all_circle_list_by_rolename);die;
			$this->view->circleCodeList = $circleCode;
			$this->view->circle_list = $all_circle_list_by_rolename;
		}
		
		
		
    }
	
	
    /**
	* remoteWipe() method is used to send notification
	* @param NULL
	* @return Array 
	*/	
	public function remoteWipeAction()
    {
        $this->checklogin();
		$this->checkRolePage();
		$users = new Application_Model_Users();
		$staffCode = $this->getRequest()->getParam('staffCode');  
		$deactive = $this->getRequest()->getParam('deactive');  
		$successMessage="";
		
		if($staffCode !=""){ 
		   
			//$users->updateUserDeletedStaffCode($staffCode);
			//$users->insertUserDeletedStaffCode($staffCode);	
			$users->removeWipeOutUser($staffCode,$deactive);
			if($deactive == 'deactive')
			{
				$this->view->successMessage = "User deactivated successfully.";
			}
			else if($deactive == 'activate')
			{
				$this->view->successMessage = "User activated successfully.";
			}
			else
			{
				$this->view->successMessage = "User wipeout successfully.";
			}			
		}	

    }
	
	
	/**
	* locationServiceFrequency() method is used to send notification
	* @param NULL
	* @return Array 
	*/	
	
	public function locationServiceFrequencyAction()
    {
        $this->checklogin();
		$this->checkRolePage();
		$user = new Application_Model_Users();
		
		$errorMessage ="";
		$successMessage="";
		if($this->getRequest()->isPost()){  
			$default_frequency = $this->getRequest()->getParam('default_frequency');   
			$frequency_value_day = $this->getRequest()->getParam('frequency_value_day');
		    $frequency_value_night = $this->getRequest()->getParam('frequency_value_night'); 
			$id = $this->getRequest()->getParam('id'); 

			if($default_frequency =="")
			{
			    $this->view->errorMessage = "Please choose service frequency";
			}
			else if(($default_frequency == "FREQUENCY_VALUE") && ($frequency_value_day =="" ||$frequency_value_night ==""))
			{
				if($frequency_value_day =="")
				{
				    $this->view->errorMessage = "Please enter day frequency value";
				}
				else if($frequency_value_night =="")
				{
				    $this->view->errorMessage = "Please enter night frequency value";
				}
			}
			else
			{
			    $frequencyData = array();
			    if($default_frequency == "DEFAULT_VALUE")
				{
				    $default_frequency = $default_frequency;
					$frequency_value_day = "";
					$frequency_value_night = "";
					$default_value = "5";
				}
				else if($default_frequency == "FREQUENCY_VALUE")
				{
				    $default_frequency = $default_frequency;
					$frequency_value_day = $frequency_value_day;
					$frequency_value_night = $frequency_value_night;
					$default_value = "";
				}
				
				$total = $user->getSettingDataCountById($id);
				if($total['total']>0)
				{
				     $where = array('id =?',$id);
				     $user->updateUserSettingValue($default_frequency,$frequency_value_day,$frequency_value_night,$default_value,$id);
				}
				else
				{
				    $user->insertUserSettingValue($default_frequency,$frequency_value_day,$frequency_value_night,$default_values);
				}
			    
		     	$this->view->successMessage = "Frequency has been saved successfully.";
			}
			$this->view->default_frequency = $default_frequency;
			$this->view->frequency_value_day = $frequency_value_day;
			$this->view->frequency_value_night = $frequency_value_night;
		}
		
		$result = $user->getSettingData();
		$this->view->record = $result; 
    }
	
	
    public function accountActivateAction()
    {
        // action body
		$request = $this->getRequest()->getParams();
		$method = $this->getRequest()->getMethod();
		$usrHash = $request['hash'];
		try
		{
			
			if($method != 'GET' || !$usrHash) 
			{
				throw new Exception("Invalid request.");	
			}
			$user = new Application_Model_Users();
			$userData = $user->getAllData('users', 'user_hash',$usrHash);
			$count =  count($userData);
			if(!$count)
			{
				throw new Exception('Activaltion Url expired or invalid.');
			}
			$update['user_hash'] = md5(mt_rand(1,1000).time().$userData['user_id']);
			$update['access_status'] = 1;
			
			$user->updateSingleTableData('users', $update, 'user_id', $userData['user_id']);	
			$this->view->message  = 'Account Activated successfully.';
		}
		catch(Exception $e)
		{
			//Rollback transaction
			//$db->rollBack();
			$this->view->message= $e->getMessage();
		}
    }
  
    public function mappingStructureAction()
    {
		$this->_helper->layout->disableLayout();
		//$this->_helper->viewRenderer->setNoRender(TRUE);
        $this->checklogin();
		$this->checkRolePage();
		$user = new Application_Model_Users();

		$result = $user->mappingStructureUser();
		$this->view->record = $result;
    }  
	
	public function checklogin()
	{
		$auth = Zend_Auth::getInstance();
		
		$errorMessage = ""; 
		/*************** check user identity ************/
        if(!$auth->hasIdentity())
        {
		     $this->_redirect('admin/index');  
        }		
	}
	
	
	public function checkRolePage()
	{
	    $front = Zend_Controller_Front::getInstance();
		$controller = $front->getRequest()->getControllerName(); 
		$action = $front->getRequest()->getActionName(); 
		if(($controller=="accountsetting" && ($action=="remote-wipe" || $action=="location-service-frequency")) && ($this->role == "national_head" || $this->role == "zone_head" || $this->role == "regional_head" || $this->role == "circle_head" || $this->role == "service_manager" || $this->role == "cluster_incharge"))
		{
		    $this->_redirect('admin/index');  
		}
	}
	

}



